#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <string.h>
#include <errno.h>  

#include "sv_buzzer.h"
#include "ctlope_buzzer.h"

int main(int argc, char **argv)
{
	int cmd = 0;
	int data = 0;
	int rc = 0;
	int fd = 0;
	int i = 0;
	int errnum = 0;
	unsigned int *bptn = NULL;
	
	buz_args_t args = {
		.id = 0,
		.m = 0,
		.level = 0,
		.bptn0 = 0,
		.bptn1 = 0,
		.bptn2 = 0,
		.bptn3 = 0,
		.bptn4 = 0,
		.bptn5 = 0,
		.bptn6 = 0,
		.bptn7 = 0,
	};
	buzzer_info_t buz_info;

	if (argc == 2) {
		cmd = strtol(argv[1], NULL, 10);
	} else if (argc == 3) {
		cmd = strtol(argv[1], NULL, 10);
		data = strtol(argv[2], NULL, 10);
	} else if ((argc >= 6) || (argc <= 13)){
		cmd = strtol(argv[1], NULL, 10);
		args.id = strtol(argv[2], NULL, 10);
		args.m = strtol(argv[3], NULL, 10);
		args.level = strtol(argv[4], NULL, 10);
		bptn = &args.bptn0;
		for(i = 5; i < argc; i++){
			*bptn = strtol(argv[i], NULL, 10);
			printf("bptn%d:0x%d\n", (i-5), *bptn);
			bptn++;
		}
	} else {
		printf("Invalid argument...\n");
		rc = -1;
		goto EXIT_FUNC;
	}

	fd = open("/dev/opebuzzer", O_RDWR);
	if (fd < 0) {
		rc = -2;
		printf("Can't open device special...\n");
		goto EXIT_FUNC;
	}

	switch (cmd) {
	case 4:
		if (argc == 2) {
			rc = ioctl(fd, BZ_IOC_BUZZER_OFF);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 5:
		if (argc == 2) {
			rc = ioctl(fd, BZ_IOC_BUZZER_ON);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 6:
		if (argc == 3) {
			buzzer_info_t buz_info;
			buz_info.level = data;
			rc = ioctl(fd, BZ_IOC_SET_VOLUME, &buz_info);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 7:
		if (argc == 3) {
			buzzer_info_t buz_info;
			buz_info.id = data;
			rc = ioctl(fd, BZ_IOC_BUZ_ID_ON, &buz_info);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 8:
		if (argc == 2) {
			buzzer_info_t buz_info;
			rc = ioctl(fd, BZ_IOC_GET_BUZZER_INFO, &buz_info);
			printf("state:%d\n", buz_info.state);
			printf("level:%d\n", buz_info.level);
			printf("id:%d\n", buz_info.id);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;

	case 9:
		if (argc > 3) {
			rc = ioctl(fd, BZ_IOC_BUZ_ORG_PTN, &args);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;

	default:
		printf("Invalid command %d\n", cmd);
		rc = -1;
		break;
	}

	close(fd);

 EXIT_FUNC:
	return rc;
}
