#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <string.h>
#include <errno.h>  

#include "ctlope_led.h"

/**
   #define LD_IOC_ALL_LEDS_OFF _IO(0xe6, 0x04)
   #define LD_IOC_ALL_LEDS_ON _IO(0xe6, 0x05)
   #define LD_IOC_DYNAMIC_LED_OFF _IOW(0xe6, 0x06, led_args_t)
   #define LD_IOC_DYNAMIC_LED_ON _IOW(0xe6, 0x07, led_args_t)
   #define LD_IOC_ALL_LEDS_BLNK_STOP _IO(0xe6, 0x08)
   #define LD_IOC_ALL_LEDS_BLNK_START _IOW(0xe6, 0x09, led_args_t)
   #define LD_IOC_DYNAMIC_LED_BLNK_STOP _IOW(0xe6, 0x0c, led_args_t)
   #define LD_IOC_DYNAMIC_LED_BLNK_START _IOW(0xe6, 0x0d, led_args_t)
   #define LD_IOC_GET_LEDS_INFO _IOR(0xe6, 0x10, led_info_t)
*/

int main(int argc, char **argv)
{
	int cmd = 0;
	int rc = 0;
	int row = 0;
	int col = 0;
	int bt = 0;
	int fd = 0;
	int errnum = 0;
	led_args_t args = {
		.ledDataNo = 0,
		.ledScanNo = 0,
		.bt = 0,
		.echo = 0,
		.led2_DataNo = 0,
		.led2_ScanNo = 0,
	};
	led_info_t led_info;

	if (argc == 2) {
		cmd = strtol(argv[1], NULL, 10);
	} else if (argc == 3) {
		cmd = strtol(argv[1], NULL, 10);
		bt = strtol(argv[2], NULL, 10);
	} else if (argc == 4) {
		cmd = strtol(argv[1], NULL, 10);
		row = strtol(argv[2], NULL, 10);
		col = strtol(argv[3], NULL, 10);
	} else if (argc == 5) {
		cmd = strtol(argv[1], NULL, 10);
		row = strtol(argv[2], NULL, 10);
		col = strtol(argv[3], NULL, 10);
		bt = strtol(argv[4], NULL, 10);
	} else {
		printf("Invalid argument...\n");
		rc = -1;
		goto EXIT_FUNC;
	}

	fd = open("/dev/opeled", O_RDWR);
	if (fd < 0) {
		rc = -2;
		printf("Can't open device special...\n");
		goto EXIT_FUNC;
	}

	switch (cmd) {
	case 4:
		if (argc == 2) {
			rc = ioctl(fd, LD_IOC_ALL_LEDS_OFF);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 5:
		if (argc == 2) {
			rc = ioctl(fd, LD_IOC_ALL_LEDS_ON);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 6:
		if (argc == 4) {
			args.ledDataNo = row;
			args.ledScanNo = col;
			rc = ioctl(fd, LD_IOC_DYNAMIC_LED_OFF, &args);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 7:
		if (argc == 4) {
			args.ledDataNo = row;
			args.ledScanNo = col;
			rc = ioctl(fd, LD_IOC_DYNAMIC_LED_ON, &args);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 8:
		if (argc == 2) {
			rc = ioctl(fd, LD_IOC_ALL_LEDS_BLNK_STOP);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 9:
		if (argc == 3) {
			args.bt = bt;
			rc = ioctl(fd, LD_IOC_ALL_LEDS_BLNK_START, &args);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 12:/* 0x0c */
		if (argc == 4) {
			args.ledDataNo = row;
			args.ledScanNo = col;
			rc = ioctl(fd, LD_IOC_DYNAMIC_LED_BLNK_STOP, &args);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 13:/* 0x0d */
		if (argc == 5) {
			args.ledDataNo = row;
			args.ledScanNo = col;
			args.bt = bt;
			rc = ioctl(fd, LD_IOC_DYNAMIC_LED_BLNK_START, &args);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 15:/* 0x10 */
		if (argc == 2) {
			rc = ioctl(fd, LD_IOC_GET_LEDS_INFO, &led_info);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 20:
		if (argc == 4) {
			args.ledDataNo = row;
			args.ledScanNo = col;
			args.echo = 1;
			rc = ioctl(fd, LD_IOC_DYNAMIC_LED_ON, &args);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
	break;
	default:
		printf("Invalid command %d\n", cmd);
		rc = -1;
		break;
	}

	close(fd);

 EXIT_FUNC:
	return rc;
}
