/***** -*- C -*- **************************************
 * $Id$
 *
 * Copyright (C) 2015 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : RICOH input device driver
 *	 PROGRAM NAME	 : svinput.ko
 *	 FILE NAME		 : ctlope_inputevent.h
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : Hideaki Yamamoto
 *	 AUTHOR 		 : $Author$
 ******************************************************/
#ifndef _CTLOPE_INPUTEVENT_H_
#define _CTLOPE_INPUTEVENT_H_

#define OPE_MAX_POINTS 2

#define MAX_KEYSCAN_COL 6
#define MAX_KEYSCAN_ROW 6

typedef enum {
	KEY_RELEASE = 0,
	KEY_PUSH    = 1,
	KEY_REPEAT  = 2,
	KEY_SPKEY   = 3,
} key_event_t;

typedef enum {
	PANEL_RELEASE = 0,
	PANEL_PRESS   = 1,
	PANEL_REPEAT  = 2,
} panel_event_t;

typedef enum {
	SVKBD_NONE    = 0x00,
	SVKBD_PUSH    = 0x10,
	SVKBD_RELEASE = 0x20,
} key_stat_t;

typedef enum {
	OPE_KEY_1           = 0x0002,
	OPE_KEY_2           = 0x0003,
	OPE_KEY_3           = 0x0004,
	OPE_KEY_4           = 0x0005,
	OPE_KEY_5           = 0x0006,
	OPE_KEY_6           = 0x0007,
	OPE_KEY_7           = 0x0008,
	OPE_KEY_8           = 0x0009,
	OPE_KEY_9           = 0x000A,
	OPE_KEY_0           = 0x000B,
	OPE_KEY_KPASTERISK  = 0x0037,
	OPE_KEY_SHARP       = 0x0060,
	OPE_KEY_CLR         = 0x000E,
	OPE_KEY_START       = 0x001C,
	OPE_KEY_STP         = 0x006B,
	OPE_KEY_COUNTER     = 0x0040,
	OPE_KEY_PRGM        = 0x006E,
	OPE_KEY_RESET       = 0x006F,
	OPE_KEY_HOME        = 0x0066,
	OPE_KEY_F1          = 0x003B,
	OPE_KEY_F2          = 0x003C,
	OPE_KEY_F3          = 0x003D,
	OPE_KEY_F4          = 0x003E,
	OPE_KEY_F5          = 0x003F,
	OPE_KEY_SIMPLE_WIN  = 0x0058,
	OPE_KEY_LOGIN_OUT   = 0x0057,
	OPE_KEY_INT         = 0x0042,
	OPE_KEY_CHECK       = 0x0044,
	OPE_KEY_STS_INFO    = 0x0041,
	OPE_KEY_ENESAVE     = 0x0043,
	OPE_KEY_ALTCOUNTER  = 0x0030,
	OPE_KEY_USBRESET    = 0x007f,
	OPE_KEY_ALTLANGUAGE = 0x0072,
	OPE_KEY_PAGESETTING = 0x0070,
	OPE_KEY_RESERVED    = 0xeeee,
	OPE_KEY_INVALID     = 0xffff,
} sv_ctl_key_code_t;

typedef struct keyevent
{
	uint16_t code;
	uint16_t status;
} keyevent_t;

typedef struct touch_axis
{
	int32_t x;
	int32_t y;
} touch_axis_t;

typedef struct touchevent
{
	touch_axis_t abs[OPE_MAX_POINTS];
	uint16_t pointnum;
	uint16_t status;
} touchevent_t;

typedef struct ope_input_event
{
	struct timeval time;
	uint32_t type;
	union{
		keyevent_t key;
		touchevent_t touch;
	}param;
} ope_input_event_t;

#endif /* _CTLOPE_KEYBOARD_H_ */
