/***** -*- C -*- **************************************
 * 
 *
 * Copyright (C) 2017 Ricoh Company, Ltd.  All Rights Reserved.
 *   ORDER           : 
 *   PROGRAM NAME    : 
 *   FILE NAME       : ctlope_buzzer.h
 *   VERSION         : 
 *   DESIGNER        : 
 *   AUTHOR          : 
 ******************************************************/

#ifndef CTLOPE_BUZZER_H_
#define CTLOPE_BUZZER_H_

typedef struct _buzzer_info_t {
	unsigned char state;	/* on = 1, off = 0 */
	unsigned char level;
	unsigned char id; 	/* buzzer pattern id */
} buzzer_info_t;

#define BZ_IOC_BUZZER_OFF      _IO(0xe6, 0x21)
#define BZ_IOC_BUZZER_ON       _IO(0xe6, 0x20)
#define BZ_IOC_SET_VOLUME      _IOW(0xe6, 0x1e, buzzer_info_t)
#define BZ_IOC_BUZ_ID_ON       _IOW(0xe6, 0x1f, buzzer_info_t)
#define BZ_IOC_GET_BUZZER_INFO _IOR(0xe6, 0x22, buzzer_info_t)

#define BZ_BUZZER_OFF				(0)		/* uU[OFF */
#define BZ_BUZZER_ON				(1)		/* uU[ON */

/* uU[ */
typedef enum {
	BZ_SOUND_LEVEL0 = 0,	/* ʁF */
	BZ_SOUND_LEVEL1,		/* ʁF */
	BZ_SOUND_LEVEL2,		/* ʁF (W) (ftHg) */
	BZ_SOUND_LEVEL3			/* ʁF */
} BZ_SOUND_LEVEL;

#endif /* CTLOPE_BUZZER_H_ */
