/*****************************************************************************
 Copyright(c) 2010 DTS INSIGHT CORPORATION
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.

 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |	  +--------- Modified System Version
 |	  | 	+--- Classification of New, Modify, Append, Delete
 v	  v 	v
 No  Ver  Class Date				Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New 2012/10/01		New
 001 01.10 Mod 2013/01/28		Fixed #13113 
 002 02.12 MOD  2014/12/12      Fixed #13672
 003 02.13 MOD  2015/03/12      Fixed SMTNEW-113
 004 03.10 Mod  2016/05/20      SMTNEW-288
*****************************************************************************/

/* Include specification ****************************************************/
#include <linux/version.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,19)
#include <linux/config.h>
#endif
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/errno.h>
#include <linux/mm.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include <asm/page.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0)
#include <linux/cdev.h>
#endif

#include <smt/SMTAPI.h>
#include "smtif.h"
#include "smt.h"
#include "smtoutput.h"



/* Extern variables ******************************************************/
extern struct smt_device* smt_device;


/* Extern Function prototypes ******************************************************/
extern int _SMT_PortOut_core(_SMT_UNSIGNED_32BIT_INTEGER addr,_SMT_UNSIGNED_32BIT_INTEGER data,_SMT_PSZ size,_SMT_PRW rw);
extern int SMT_Putw(int level,const char *s);
extern int _SMT_UsrMsgTag0_core( int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum);
extern int _SMT_UsrMsgTag1_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1);
extern int _SMT_UsrMsgTag2_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2);
extern int _SMT_UsrMsgTag3_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3);
extern int _SMT_UsrMsgTag4_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4);
extern void _SMT_Hook0_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum);
extern void _SMT_Hook1_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1);
extern void _SMT_Hook2_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2 );
extern void _SMT_Hook3_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3 );
extern void _SMT_Hook4_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4 );
extern void _SMT_Hook5_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5 );
extern void _SMT_Hook6_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6 );
extern void _SMT_Hook7_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7 );
extern void _SMT_Hook8_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8 );
extern void _SMT_Hook9_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9 );
extern void _SMT_Hook10_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10 );
extern void _SMT_Hook11_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11 );
extern void _SMT_Hook12_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12 );
extern void _SMT_Hook13_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13 );
extern void _SMT_Hook14_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14 );
extern void _SMT_Hook15_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15 );
extern void _SMT_Hook16_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16 );

extern void _SMT_Hook0_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr);
extern void _SMT_Hook1_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr);
extern void _SMT_Hook2_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr);
extern void _SMT_Hook3_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook4_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook5_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook6_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook7_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook8_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook9_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook10_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook11_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook12_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook13_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook14_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook15_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );
extern void _SMT_Hook16_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr );

/* Static Function prototypes ***********************************************/
#ifdef HAVE_UNLOCKED_IOCTL 
static long smt_ioctl(struct file *file,unsigned int cmd,_SMT_UNSIGNED_32BIT_INTEGER arg);
#else 
static int smt_ioctl(struct inode *inode, struct file *file,unsigned int cmd,_SMT_UNSIGNED_32BIT_INTEGER arg);
#endif
static int smt_open(struct inode *inode,struct file *file);
static int smt_release(struct inode *inode,struct file *file);
static int smt_PortOut(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Puts(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_UsrMsgTag0(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_UsrMsgTag1(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_UsrMsgTag2(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_UsrMsgTag3(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_UsrMsgTag4(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook0(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook1(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook2(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook3(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook4(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook5(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook6(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook7(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook8(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook9(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook10(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook11(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook12(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook13(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook14(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook15(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook16(_SMT_UNSIGNED_32BIT_INTEGER arg);

static int smt_Hook0_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook1_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook2_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook3_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook4_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook5_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook6_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook7_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook8_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook9_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook10_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook11_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook12_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook13_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook14_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook15_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
static int smt_Hook16_SP(_SMT_UNSIGNED_32BIT_INTEGER arg);
///* Internal variables *******************************************************/
struct file_operations smt_fops = {						//file operation struct
	.owner =	THIS_MODULE,							
//	.read =		smt_read,								
//	.write =	smt_write,								
#ifdef HAVE_UNLOCKED_IOCTL
	.unlocked_ioctl =	smt_ioctl,						
#else
    .ioctl =	smt_ioctl,				            	
#endif
//	.mmap =		smt_mmap,								
//	.poll =		smt_poll,								
	.open =		smt_open,								
	.release =	smt_release,							
};
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0)
static struct cdev cdev;
#endif

/*****************************************************************************
1.Function: ioctl() system call

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	inode						i node structure
I	file						file structure
I	cmd							ioctl command
I/O arg							command argumen

4.Return Value:
								0	   : Normal
								-ENOTTY: Not a typewriter

*****************************************************************************/
#ifdef HAVE_UNLOCKED_IOCTL 
static long smt_ioctl(struct file *file,unsigned int cmd,_SMT_UNSIGNED_32BIT_INTEGER arg)
#else 
static int smt_ioctl(struct inode *inode, struct file *file,unsigned int cmd,_SMT_UNSIGNED_32BIT_INTEGER arg)
#endif
{
	int result;

	switch(cmd){
	case SMT_IOC_PORTOUT:
		result =  smt_PortOut(arg);
		break;
	case SMT_IOC_PUTS:
		return( smt_Puts(arg) );
		break;
	case SMT_IOC_USRMSGTAG0:
		return( smt_UsrMsgTag0(arg) );
		break;
	case SMT_IOC_USRMSGTAG1:
		return( smt_UsrMsgTag1(arg) );
		break;
	case SMT_IOC_USRMSGTAG2:
		return( smt_UsrMsgTag2(arg) );
		break;
	case SMT_IOC_USRMSGTAG3:
		return( smt_UsrMsgTag3(arg) );
		break;
	case SMT_IOC_USRMSGTAG4:
		return( smt_UsrMsgTag4(arg) );
		break;
	case SMT_IOC_HOOK0:
		return( smt_Hook0(arg) );
		break;
	case SMT_IOC_HOOK1:
		return( smt_Hook1(arg) );
		break;
	case SMT_IOC_HOOK2:
		return( smt_Hook2(arg) );
		break;
	case SMT_IOC_HOOK3:
		return( smt_Hook3(arg) );
		break;
	case SMT_IOC_HOOK4:
		return( smt_Hook4(arg) );
		break;
	case SMT_IOC_HOOK5:
		return( smt_Hook5(arg) );
		break;
	case SMT_IOC_HOOK6:
		return( smt_Hook6(arg) );
		break;
	case SMT_IOC_HOOK7:
		return( smt_Hook7(arg) );
		break;
	case SMT_IOC_HOOK8:
		return( smt_Hook8(arg) );
		break;
	case SMT_IOC_HOOK9:
		return( smt_Hook9(arg) );
		break;
	case SMT_IOC_HOOK10:
		return( smt_Hook10(arg) );
		break;
	case SMT_IOC_HOOK11:
		return( smt_Hook11(arg) );
		break;
	case SMT_IOC_HOOK12:
		return( smt_Hook12(arg) );
		break;
	case SMT_IOC_HOOK13:
		return( smt_Hook13(arg) );
		break;
	case SMT_IOC_HOOK14:
		return( smt_Hook14(arg) );
		break;
	case SMT_IOC_HOOK15:
		return( smt_Hook15(arg) );
		break;
	case SMT_IOC_HOOK16:
		return( smt_Hook16(arg) );
		break;
	case SMT_IOC_HOOK0_SP:
		return( smt_Hook0_SP(arg) );
		break;
	case SMT_IOC_HOOK1_SP:
		return( smt_Hook1_SP(arg) );
		break;
	case SMT_IOC_HOOK2_SP:
		return( smt_Hook2_SP(arg) );
		break;
	case SMT_IOC_HOOK3_SP:
		return( smt_Hook3_SP(arg) );
		break;
	case SMT_IOC_HOOK4_SP:
		return( smt_Hook4_SP(arg) );
		break;
	case SMT_IOC_HOOK5_SP:
		return( smt_Hook5_SP(arg) );
		break;
	case SMT_IOC_HOOK6_SP:
		return( smt_Hook6_SP(arg) );
		break;
	case SMT_IOC_HOOK7_SP:
		return( smt_Hook7_SP(arg) );
		break;
	case SMT_IOC_HOOK8_SP:
		return( smt_Hook8_SP(arg) );
		break;
	case SMT_IOC_HOOK9_SP:
		return( smt_Hook9_SP(arg) );
		break;
	case SMT_IOC_HOOK10_SP:
		return( smt_Hook10_SP(arg) );
		break;
	case SMT_IOC_HOOK11_SP:
		return( smt_Hook11_SP(arg) );
		break;
	case SMT_IOC_HOOK12_SP:
		return( smt_Hook12_SP(arg) );
		break;
	case SMT_IOC_HOOK13_SP:
		return( smt_Hook13_SP(arg) );
		break;
	case SMT_IOC_HOOK14_SP:
		return( smt_Hook14_SP(arg) );
		break;
	case SMT_IOC_HOOK15_SP:
		return( smt_Hook15_SP(arg) );
		break;
	case SMT_IOC_HOOK16_SP:
		return( smt_Hook16_SP(arg) );
		break;
	default:
		printk(KERN_WARNING "%s: Unknown command 0x%x\n", MODULE_NAME, cmd);
		result = -ENOTTY;
		break;
	}
	return( result );
}

/*****************************************************************************
1.Function: open() system call

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------

4.Return Value:

*****************************************************************************/
static int smt_open(struct inode *inode ,struct file *file)
{
	struct smt_device* dev = smt_device;

	file->private_data = dev;
	dev->opencount++;
	return (0);
}

/*****************************************************************************
1.Function: close() system call

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------

4.Return Value:

*****************************************************************************/
static int smt_release(struct inode *inode ,struct file *file)
{
	struct smt_device* dev = file->private_data;

	dev->opencount--;
	return (0);
}

/*****************************************************************************
1.Function: register of character device number

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/O	major						character device major number
I/	minor						character device minor number 

4.Return Value:
		 	0 <= result: normal
		 	result < 0 : error
*****************************************************************************/
int smt_register_chrdev(int* major, int* minor)
{
	int result;

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0)
	dev_t dev = 0;

	if (*major) {
		dev = MKDEV(*major, *minor);
		result = register_chrdev_region(dev, CDEV_NUM, MODULE_NAME);
	} else {
		result = alloc_chrdev_region(&dev, *minor, CDEV_NUM, MODULE_NAME);
		*major = MAJOR(dev);
	}
#else
	result = register_chrdev(*major, MODULE_NAME, &smt_fops);
	if (result < 0) {
		return(result);
	}
	if (*major == 0) {
		*major = result;
	}
#endif
	return (result);
}

/*****************************************************************************
1.Function: unregister of character device number

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/O	major						character device major number
I/	minor						character device minor number 

4.Return Value:
*****************************************************************************/
void smt_unregister_chrdev(int major, int minor)
{
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0)
	unregister_chrdev_region(MKDEV(major, minor), CDEV_NUM);
#else
	unregister_chrdev(major, MODULE_NAME);
#endif
}

/*****************************************************************************
1.Function: Init character device structure

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/O	devno						device number

4.Return Value:
		-ENOMEM					Out of memory 
		 0						normal
*****************************************************************************/
int smt_setup_chrdev(int devno)
{
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0)
	int status;

	cdev_init(&cdev, &smt_fops);
	cdev.owner = THIS_MODULE;
	cdev.ops = &smt_fops;
	status = cdev_add(&cdev, devno, 1);
	if (status < 0) {
		printk(KERN_WARNING "Error %d adding trqer minor device", status);
	}

	return (status);
#else
	return (0);
#endif
}

/*****************************************************************************
1.Function: release character device structure

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------


4.Return Value:
*****************************************************************************/
void smt_cleanup_chrdev(void)
{
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0)
		cdev_del(&cdev);
#endif
}

/*****************************************************************************
1.Function: output  _SMT_PortOut() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_PortOut(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	portout_info_t prm;

	if( copy_from_user(&prm,(portout_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	return( _SMT_PortOut_core(prm.addr,prm.data,prm.size,prm.rw) );
}

/*****************************************************************************
1.Function: output  _SMT_Printf()/_SMT_Puts() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Puts(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	printf_info_t prm;

	if( copy_from_user(&prm,(portout_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	return( SMT_Putw(prm.level,prm.data) );
}

/*****************************************************************************
1.Function: output  _SMT_UsrMsgTag0() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_UsrMsgTag0(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	usrmsgtag0_info_t prm;

	if( copy_from_user(&prm,(usrmsgtag0_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	return( _SMT_UsrMsgTag0_core(prm.level,prm.tagnum) );
}

/*****************************************************************************
1.Function: output  _SMT_UsrMsgTag1() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_UsrMsgTag1(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	usrmsgtag1_info_t prm;

	if( copy_from_user(&prm,(usrmsgtag1_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	return( _SMT_UsrMsgTag1_core(prm.level,prm.tagnum,prm.data) );
}

/*****************************************************************************
1.Function: output  _SMT_UsrMsgTag2() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_UsrMsgTag2(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	usrmsgtag2_info_t prm;

	if( copy_from_user(&prm,(usrmsgtag2_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	return( _SMT_UsrMsgTag2_core(prm.level,prm.tagnum,prm.data[0],prm.data[1]) );
}

/*****************************************************************************
1.Function: output  _SMT_UsrMsgTag3() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_UsrMsgTag3(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	usrmsgtag3_info_t prm;

	if( copy_from_user(&prm,(usrmsgtag3_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	return( _SMT_UsrMsgTag3_core(prm.level,prm.tagnum,prm.data[0],prm.data[1],prm.data[2]) );
}

/*****************************************************************************
1.Function: output  _SMT_UsrMsgTag4() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_UsrMsgTag4(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	usrmsgtag4_info_t prm;

	if( copy_from_user(&prm,(usrmsgtag4_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	return( _SMT_UsrMsgTag4_core(prm.level,prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3]) );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook0() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook0(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook0_info_t prm;

	if( copy_from_user(&prm,(hook0_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook0_userland_core(prm.tagnum,_SMT_SP_OUTPUT_DISABLE,0);

	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook1() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook1(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook1_info_t prm;

	if( copy_from_user(&prm,(hook1_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook1_userland_core(prm.tagnum,prm.data,_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook2() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook2(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook2_info_t prm;

	if( copy_from_user(&prm,(hook2_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook2_userland_core(prm.tagnum,prm.data[0],prm.data[1],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook3() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook3(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook3_info_t prm;

	if( copy_from_user(&prm,(hook3_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook3_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook4() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook4(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook4_info_t prm;

	if( copy_from_user(&prm,(hook4_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook4_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook5() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook5(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook5_info_t prm;

	if( copy_from_user(&prm,(hook5_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook5_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook6() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook6(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook6_info_t prm;

	if( copy_from_user(&prm,(hook6_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook6_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook7() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook7(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook7_info_t prm;

	if( copy_from_user(&prm,(hook7_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook7_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook8() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook8(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook8_info_t prm;

	if( copy_from_user(&prm,(hook8_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook8_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook9() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook9(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook9_info_t prm;

	if( copy_from_user(&prm,(hook9_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook9_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook10() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook10(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook10_info_t prm;

	if( copy_from_user(&prm,(hook10_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook10_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook11() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook11(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook11_info_t prm;

	if( copy_from_user(&prm,(hook11_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook11_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],prm.data[10],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook12() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook12(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook12_info_t prm;

	if( copy_from_user(&prm,(hook12_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook12_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],prm.data[10],prm.data[11],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook13() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook13(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook13_info_t prm;

	if( copy_from_user(&prm,(hook13_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook13_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],prm.data[10],prm.data[11],prm.data[12],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook14() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook14(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook14_info_t prm;

	if( copy_from_user(&prm,(hook14_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook14_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],prm.data[10],prm.data[11],prm.data[12],prm.data[13],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook15() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook15(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook15_info_t prm;

	if( copy_from_user(&prm,(hook15_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook15_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],prm.data[10],prm.data[11],prm.data[12],prm.data[13],prm.data[14],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook16() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook16(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook16_info_t prm;

	if( copy_from_user(&prm,(hook16_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook16_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],prm.data[10],prm.data[11],prm.data[12],prm.data[13],prm.data[14],prm.data[15],_SMT_SP_OUTPUT_DISABLE,0);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook0() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook0_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook0_sp_info_t prm;

	if( copy_from_user(&prm,(hook0_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook0_userland_core(prm.tagnum,_SMT_SP_OUTPUT_ENABLE,prm.sp);

	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook1() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook1_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook1_sp_info_t prm;

	if( copy_from_user(&prm,(hook1_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook1_userland_core(prm.tagnum,prm.data,_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook2() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook2_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook2_sp_info_t prm;

	if( copy_from_user(&prm,(hook2_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook2_userland_core(prm.tagnum,prm.data[0],prm.data[1],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook3() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook3_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook3_sp_info_t prm;

	if( copy_from_user(&prm,(hook3_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook3_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook4() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook4_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook4_sp_info_t prm;

	if( copy_from_user(&prm,(hook4_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook4_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook5() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook5_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook5_sp_info_t prm;

	if( copy_from_user(&prm,(hook5_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook5_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook6() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook6_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook6_sp_info_t prm;

	if( copy_from_user(&prm,(hook6_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook6_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook7() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook7_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook7_sp_info_t prm;

	if( copy_from_user(&prm,(hook7_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook7_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook8() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook8_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook8_sp_info_t prm;

	if( copy_from_user(&prm,(hook8_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook8_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook9() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook9_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook9_sp_info_t prm;

	if( copy_from_user(&prm,(hook9_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook9_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook10() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook10_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook10_sp_info_t prm;

	if( copy_from_user(&prm,(hook10_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook10_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook11() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook11_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook11_sp_info_t prm;

	if( copy_from_user(&prm,(hook11_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook11_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],prm.data[10],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook12() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook12_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook12_sp_info_t prm;

	if( copy_from_user(&prm,(hook12_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook12_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],prm.data[10],prm.data[11],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook13() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook13_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook13_sp_info_t prm;

	if( copy_from_user(&prm,(hook13_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook13_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],prm.data[10],prm.data[11],prm.data[12],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook14() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook14_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook14_sp_info_t prm;

	if( copy_from_user(&prm,(hook14_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook14_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],prm.data[10],prm.data[11],prm.data[12],prm.data[13],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook15() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook15_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook15_sp_info_t prm;

	if( copy_from_user(&prm,(hook15_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook15_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],prm.data[10],prm.data[11],prm.data[12],prm.data[13],prm.data[14],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: output  _TRQ_Hook16() data

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/O arg							command argument

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int smt_Hook16_SP(_SMT_UNSIGNED_32BIT_INTEGER arg)
{
	hook16_sp_info_t prm;

	if( copy_from_user(&prm,(hook16_sp_info_t *)arg,sizeof(prm)) ){
		return( _SMT_NG );
	}
	_SMT_Hook16_userland_core(prm.tagnum,prm.data[0],prm.data[1],prm.data[2],prm.data[3],prm.data[4],prm.data[5],prm.data[6],prm.data[7],prm.data[8],prm.data[9],prm.data[10],prm.data[11],prm.data[12],prm.data[13],prm.data[14],prm.data[15],_SMT_SP_OUTPUT_ENABLE,prm.sp);
	return( _SMT_OK );
}