/***** -*- mode: C; encodeing: utf-8 -*- **************************************
 * $Id$
 *
 * Copyright (C) 2016 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : rapi driver
 *	 PROGRAM NAME	 : rapi.ko
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : WAKABAYASHI, Ayumu
 *	 AUTHOR 		 : $Author$
 *-----------------------------------------------------
 *		 HISTORY
 *	 WAKABAYASHI, Ayumu - Nov 2016: Created.
 *	 $Log$
 ******************************************************/


#include <linux/init.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/cdev.h>
#include <linux/irqreturn.h>
#include <linux/interrupt.h>
#include <linux/io.h>
#include <linux/uaccess.h>
#include <linux/types.h>
#include <linux/clk.h>
#include <linux/clk-private.h>
#include <linux/clk-provider.h>
#include <linux/delay.h>
#include <linux/device.h>
#include <linux/platform_device.h>
#include <linux/kernel.h>
#include <linux/input.h>
#include <linux/gpio.h>
#include <linux/errno.h>
#include <linux/timer.h>
#include <linux/syscalls.h>
#include <linux/slab.h>
#include <linux/workqueue.h>
#include <linux/kthread.h>
#include <linux/of.h>
#include <linux/of_address.h>
#include <linux/device.h>
#include "rapivar.h"
extern rapi_t g_rapi_softc;
#define	LYRA_MASK_REGADR	0x74
#define	LYRA_MST		0x0002
#define	LYRA_MSR		0x0001
#define	LYRA_SPCI_REGADR	0x70
#define	LYRA_SPCI_FSR		0x01
#define	LYRA_SPCI_FST		0x02
#define	LYRA_PE2C_REGADR	0x00
#define	LYRA_C2PE_REGADR	0x40
#define	LYRA_TX_REGADR		0x08
#define	LYRA_RX_REGADR		0x48
char g_register_size[4] = { 0x00 };
char g_register_data[4][32] = {{0x00}};
void dump_packet(u_char * _buf, int _size)
{
	int i = 0;
	char buf[128];
	struct timeval cur;
	rapi_t *sc = &g_rapi_softc;
	memset(buf, 0x00, 128);
	do_gettimeofday(&cur);
	printk(KERN_ERR "[%s][%ld.%06ld] <<< PCIe PACKET DUMP >>> \n", __FUNCTION__, cur.tv_sec, cur.tv_usec);
	for (i = 0; i < _size; i++) {
			sprintf(&(buf[i*3]), "%02x ", _buf[i]);
	}
	printk(KERN_ERR "[%s] size=%d, packet=%s\n", __FUNCTION__, _size, buf);
	printk(KERN_ERR "[%s] ENGRDY_N     = %d(%s) \n", __FUNCTION__, gpio_get_value(GPIO_ENG_READY), gpio_get_value(GPIO_ENG_READY) ? "Busy" : "Ready");
	printk(KERN_ERR "[%s] VDET_EPCI    = %d(%s) \n", __FUNCTION__, gpio_get_value(GPIO_ENG_PWCTL), gpio_get_value(GPIO_ENG_PWCTL) ? "ON" : "Down");
	printk(KERN_ERR "[%s] sc->sc_err   = 0x%08x \n", __FUNCTION__, sc->sc_err);
	printk(KERN_ERR "[%s] sc->sc_err2  = 0x%08x \n", __FUNCTION__, sc->sc_err2);
	printk(KERN_ERR "[%s] sc->sc_flags = 0x%08x \n", __FUNCTION__, sc->sc_flags);
	printk(KERN_ERR "[%s] sc->sc_nrcv  = %d \n", __FUNCTION__, atomic_read(&(sc->sc_nrcv)));
	printk(KERN_ERR "[%s] sc->engine_down= %d \n", __FUNCTION__, sc->engine_down);
}
int rapi_intr_asic(rapi_t * sc)
{
	return 1;
}
void rapi_intr_asic_delay(rapi_t * sc)
{
	RapiEngStatInt(sc->sc_comm);
}
int rapi_intr_ipu(rapi_t * sc)
{
	return 1;
}
void rapi_intr_ipu_delay(rapi_t * sc)
{
	RapiEngStatInt(sc->sc_comm);
}
void rapi_attention(int unit, u_short atn)
{
}
u_short rapi_enginesense(int unit)
{
	return (0);
}
int rapi_intr_pci_PCIE(void *dev)
{
	rapi_t *sc = &g_rapi_softc;
	u_char spci;
	int intrflg;
	spci = ioread8((void *)(sc->mem_vaddr + 0x70));
	if (((spci & LYRA_SPCI_FSR) == 0) && ((spci & LYRA_SPCI_FST) == 0)) {
		return (0);
	}
	if (spci & LYRA_SPCI_FSR) {
		RapiCommRxInt(sc->sc_comm);
	}
	if (spci & LYRA_SPCI_FST) {
		RapiCommTxInt(sc->sc_comm);
		if (sc->sc_comm->_TxRequest) {
			rapi_settxint_PCIE(sc->sc_comm->_Unit,
					   sc->sc_comm->_TxRequest);
		}
	}
#if 0
	spci_2nd = ioread8((void *)(sc->mem_vaddr + 0x70));
	if ((spci & LYRA_SPCI_FSR) && (spci & LYRA_SPCI_FST)) {
		return (1);
	} else if (spci & LYRA_SPCI_FST) {
		if (spci_2nd & LYRA_SPCI_FSR)
			RapiCommRxInt(sc->sc_comm);
	} else if (spci & LYRA_SPCI_FSR) {
		if (spci_2nd & LYRA_SPCI_FST) {
			RapiCommTxInt(sc->sc_comm);
			if (sc->sc_comm->_TxRequest) {
				rapi_settxint_PCIE(sc->sc_comm->_Unit,
						   sc->sc_comm->_TxRequest);
			}
		}
	} else {
		;
	}
#endif
	intrflg = ioread32((void *)(sc->mem_vaddr + 0x74));
	return (1);
}
u_short rapi_readpacket_PCIE(int unit, u_char * buf, u_short * size)
{
	rapi_t *sc = &g_rapi_softc;
	int i;
	*size = ioread32((void *)(sc->mem_vaddr + 0x08));
	g_register_size[3] = g_register_size[2];
	g_register_size[2] = g_register_size[1];
	g_register_size[1] = g_register_size[0];
	g_register_size[0] = *size;
#if 0
	cnt = *size;
	loop = (*size + 7) / 8;
	bp = buf;
	rsvaddr = (u_int64_t *) (sc->sc_pa_ioh + LYRA_RX_REGADR);
	PRINT_INFO("\nrsv data \n");
	for (i = 0; i < loop; i++) {
		work = 0;
		if (rapienginesense(unit) & ENG_READY) {
			work = *rsvaddr;
			rsvaddr++;
		} else {
			PRINT_INFO("%s: engine down!\n", __FUNCTION__);
			return RAPI_ENG_DOWN;
		}
		wkp = (u_char *) & work;
		for (j = 0; j < 8; j++) {
			*bp++ = *wkp++;
			cnt--;
			PRINT_INFO("%02x ", *(bp - 1));
			if (cnt <= 0)
				break;
		}
		PRINT_INFO("\n");
	}
#endif
	for (i = 0; i < 32; i += 4) {
		unsigned long temp = ioread32((void *)(sc->mem_vaddr + 0x10 + i));
		buf[i + 0] = (unsigned char)(0xff & (temp >> 24));
		buf[i + 1] = (unsigned char)(0xff & (temp >> 16));
		buf[i + 2] = (unsigned char)(0xff & (temp >> 8));
		buf[i + 3] = (unsigned char)(0xff & (temp >> 0));
		g_register_data[3][i + 0] = g_register_data[2][i + 0];
		g_register_data[3][i + 1] = g_register_data[2][i + 1];
		g_register_data[3][i + 2] = g_register_data[2][i + 2];
		g_register_data[3][i + 3] = g_register_data[2][i + 3];
		g_register_data[2][i + 0] = g_register_data[1][i + 0];
		g_register_data[2][i + 1] = g_register_data[1][i + 1];
		g_register_data[2][i + 2] = g_register_data[1][i + 2];
		g_register_data[2][i + 3] = g_register_data[1][i + 3];
		g_register_data[1][i + 0] = g_register_data[0][i + 0];
		g_register_data[1][i + 1] = g_register_data[0][i + 1];
		g_register_data[1][i + 2] = g_register_data[0][i + 2];
		g_register_data[1][i + 3] = g_register_data[0][i + 3];
		g_register_data[0][i + 0] = buf[i + 0];
		g_register_data[0][i + 1] = buf[i + 1];
		g_register_data[0][i + 2] = buf[i + 2];
		g_register_data[0][i + 3] = buf[i + 3];
	}
	return RAPI_PKT;
}
u_short rapi_writepacket_PCIE(int unit, u_char * buf, u_short size)
{
	rapi_t *sc = &g_rapi_softc;
	u_int len = size;
	int i;
#if 0
	loop = (size + 7) / 8;
	bp = buf;
	sndaddr = (void *)(sc->mem_vaddr + 0x40);
	PRINT_INFO("send data\n");
	for (i = 0; i < loop; i++) {
		wkp = (u_char *) & work;
		work = 0;
		for (j = 0; j < 8; j++) {
			*wkp++ = *bp++;
			PRINT_INFO("%02x ", *(wkp - 1));
			size--;
			if (size <= 0)
				break;
		}
		PRINT_INFO("\n");
		if (rapienginesense(unit) & ENG_READY) {
			data64 = work;
			*sndaddr = data64;
			sndaddr++;
		} else {
			LYRA_WRITE4(MASK, (mask | LYRA_MST));
			return RAPI_ENG_DOWN;
		}
	}
#endif
	iowrite32(len, (void *)(sc->mem_vaddr + 0x38));
	{
		u_char buffer[32] = { 0x00 };
		memcpy(buffer, buf, size);
		for (i = 0; i < 32; i += 4) {
			unsigned long data;
			unsigned long data0 = buffer[i + 0];
			unsigned long data1 = buffer[i + 1];
			unsigned long data2 = buffer[i + 2];
			unsigned long data3 = buffer[i + 3];
			data =
			    data0 << 24 | data1 << 16 | data2 << 8 | data3 << 0;
			iowrite32(data, (void *)(sc->mem_vaddr + 0x40 + i));
		}
	}
	return RAPI_PKT;
}
void rapi_settxint_PCIE(int unit, u_short flag)
{
	rapi_t *sc = &g_rapi_softc;
	unsigned int msk;
	if (flag) {
		msk = ioread32((void *)(sc->mem_vaddr + LYRA_MASK_REGADR));
		msk &= ~LYRA_MST;
		iowrite32(msk, (void *)(sc->mem_vaddr + LYRA_MASK_REGADR));
	} else {
		msk = ioread32((void *)(sc->mem_vaddr + LYRA_MASK_REGADR));
		msk |= LYRA_MST;
		iowrite32(msk, (void *)(sc->mem_vaddr + LYRA_MASK_REGADR));
	}
	sc->sc_prevtxint = flag;
}
void rapi_setrxint_PCIE(int unit, u_short flag)
{
	rapi_t *sc = &g_rapi_softc;
	unsigned int msk;
	FUNC_START;
	msk = ioread32((void *)(sc->mem_vaddr + LYRA_MASK_REGADR));
	if (flag) {
		msk = ioread32((void *)(sc->mem_vaddr + LYRA_MASK_REGADR));
		msk &= ~LYRA_MSR;
		iowrite32(msk, (void *)(sc->mem_vaddr + LYRA_MASK_REGADR));
	} else {
		msk = ioread32((void *)(sc->mem_vaddr + LYRA_MASK_REGADR));
		msk |= LYRA_MSR;
		iowrite32(msk, (void *)(sc->mem_vaddr + LYRA_MASK_REGADR));
	}
	sc->sc_prevrxint = flag;
	FUNC_END;
}
int rapi_rxintcheck_PCIE(int unit)
{
	return 0;
}
