/***** -*- mode: C; encodeing: utf-8 -*- **************************************
 * $Id$
 *
 * Copyright (C) 2016 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : rapi driver
 *	 PROGRAM NAME	 : rapi.ko
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : WAKABAYASHI, Ayumu
 *	 AUTHOR 		 : $Author$
 *-----------------------------------------------------
 *		 HISTORY
 *	 WAKABAYASHI, Ayumu - Nov 2016: Created.
 *	 $Log$
 ******************************************************/


#define  TMP_USB_GATING
#define  ENABLE_ECO_AVS
#include <stdarg.h>
#include <linux/cdev.h>
#include <linux/clk.h>
#include <linux/clk-provider.h>
#include <linux/delay.h>
#include <linux/device.h>
#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/gpio.h>
#include <linux/input.h>
#include <linux/init.h>
#include <linux/interrupt.h>
#include <linux/io.h>
#include <linux/irqreturn.h>
#include <linux/kthread.h>
#include <linux/kernel.h>
#include <linux/linkage.h>
#include <linux/module.h>
#include <linux/pci.h>
#include <linux/poll.h>
#include <linux/printk.h>
#include <linux/platform_device.h>
#include <linux/string.h>
#include <linux/syscalls.h>
#include <linux/spinlock.h>
#include <linux/sysctl.h>
#include <linux/slab.h>
#include <linux/types.h>
#include <linux/timer.h>
#include <linux/uaccess.h>
#include <linux/wait.h>
#include <linux/workqueue.h>
#include <linux/mod_devicetable.h>
#include <asm/dma.h>
#include <asm/current.h>
#include <asm/uaccess.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/time.h>
#include "rapidev.h"
#include "rapi_com.h"
#include "rapivar.h"
#include "rapi.h"
#include "history.h"
#define RAPI_PROC_STATUS_FILENAME "rapi_status"
#define RAPI_PROC_PACKETS_FILENAME "rapi_packets"
static unsigned char is_inititlized = 0;
static unsigned int read_force_sleep_flag = 0;
static int __init rapi_init(void);
static void __exit rapi_exit(void);
static int rapi_attach(void *pdev);
static int rapi_detach(void *pdev);
static int rapi_probe(struct pci_dev *pdev, const struct pci_device_id *entry);
static void rapi_remove(struct pci_dev *pdev);
static int rapi_suspend(struct pci_dev *pdev, pm_message_t state);
static int rapi_resume(struct pci_dev *pdev);
static irqreturn_t rapi_intr(int irq, void *pdev);
static irqreturn_t rapi_engready_intr(int irq, void *pdev);
static int scerr_to_readsts(void);
static void initialize_rapi_comm(rapi_t *val);
struct cdev cdev_rapi_mod;
typedef struct rapi_mod_info {
	int major;
	struct class *rapi_class;
} rapi_mod_info_t;
rapi_mod_info_t rapi_info;
workqueue_struct_t *ptr_rapi_wqueue = NULL;
rapi_work_t rapi_work_struct;
wait_queue_head_t data_wait_queue;
wait_queue_head_t tx_wait_queue;
struct timer_list check_txtimeout_timer;
struct proc_dir_entry *proc_entry;
int intrnum = 0;
#ifdef RAPI_ENG_DELAY_TIME
#define	ENG_DELAY		RAPI_ENG_DELAY_TIME
#else
#define	ENG_DELAY		0
#endif
#ifdef RAPI_IPU_DELAY_TIME
#define	IPU_DELAY		RAPI_IPU_DELAY_TIME
#else
#define	IPU_DELAY		0
#endif
#ifdef RAPI_DIFFERENT_LOGIC
#define	DIFFERENTLOGIC_READY	1
#else
#define	DIFFERENTLOGIC_READY	0
#endif
#ifdef RAPI_RDYSYNCMODE_SEL
int rdysyncmode = 0;
#else
int rdysyncmode = 1;
#endif
int rdycount = 0;
COMMHANDLE rapicom[2] = { NULL, NULL };
static unsigned int rapi_device_major = 0;
module_param(rapi_device_major, uint, 0);
static rapi_share_param_t rapi_share_param;
static bool is_initialized = false;
static unsigned char is_entried = 0;
static int rapi_open(struct inode *inode, struct file *filep);
static int rapi_close(struct inode *inode, struct file *filep);
static ssize_t rapi_read(struct file *filep, char __user * buf, size_t len,
			 loff_t * ptr);
static ssize_t rapi_write(struct file *filep, const char __user * buf,
			  size_t len, loff_t * ptr);
static long rapi_ioctl(struct file *filep, unsigned int cmd, unsigned long arg);
static unsigned int rapi_poll(struct file *file, poll_table * wait);
static int rapi_proc_open(struct inode *node, struct file *fp);
static ssize_t rapi_proc_show(struct seq_file *m, void *v);
void rapiattention(int unit, u_short atn);
u_short rapienginesense(int unit);
void rapisetegint(int unit, u_short flag);
void dump_registers(int log_level);
extern void dump_packet(u_char * buf, int size);
void dump_rapi_struct(void);
DEFINE_MUTEX(sc_mutex);
DEFINE_MUTEX(engine_mutex);
static int engine_state(void);
rapi_t g_rapi_softc;
rapi_t *sc = &g_rapi_softc;
#ifdef RAPI_RETRY_TEST
u_int retry_txsumcnt;
u_int retry_txackcnt;
u_int retry_rxsumcnt;
u_int retry_rxackcnt;
#endif
long rx_read_jiffies_befor_wait;
long rx_read_jiffies_after_wait;
static struct file_operations rapi_fops = {
	.owner = THIS_MODULE,
	.open = rapi_open,
	.release = rapi_close,
	.read = rapi_read,
	.write = rapi_write,
	.unlocked_ioctl = rapi_ioctl,
	.poll = rapi_poll,
};
EXPORT_SYMBOL(rapi_fops);
struct devlist rapi_devlist[1] = {
	{
	 .softc = (void *)(&g_rapi_softc),
	 .ops = &rapi_fops,
	 .name = RAPI_DRIVER_NAME,
	 .attachfunc = rapi_attach,
	 .detachfunc = rapi_detach,
	 }
};
EXPORT_SYMBOL(rapi_devlist);
static struct file_operations rapi_status_proc_fops = {
        .owner = THIS_MODULE,
        .open = rapi_proc_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.release = single_release,
};
static struct pci_device_id rapi_pci_device_tbl[] = {
	{PCI_DEVICE(PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_RAPI)},
	{0,}
};
EXPORT_SYMBOL(rapi_pci_device_tbl);
static struct pci_driver rapi_driver = {
	.name = RAPI_DRIVER_NAME,
	.id_table = rapi_pci_device_tbl,
	.probe = rapi_probe,
	.remove = rapi_remove,
	.suspend = rapi_suspend,
	.resume = rapi_resume,
};
EXPORT_SYMBOL(rapi_driver);
#define PCIE_CORE_ADDR1 		(0xd42c8000)
#define PCIE_CORE_ADDR2 		(0xd42c9000)
#define PCIE_CORE_SIZE1 		(0xb44/sizeof(unsigned long))
#define PCIE_CORE_SIZE2 		(0x18/sizeof(unsigned long))
static unsigned long		reg_core_data1[PCIE_CORE_SIZE1];
static unsigned long		reg_core_data2[PCIE_CORE_SIZE2];
#if 0
static void parseCmdBuf(const char *buf, int sz) {
  int grp;
  int cmd;
  char _buf[512];
  int i;
  int offset;
  i = 0;
  offset = 0;
  memset(_buf, 0x00, 512);
  grp = buf[0];
  cmd = buf[1];
  if (0x04 == grp && 0x11 == cmd) {
    printk(KERN_EMERG"***** PSU *****");
  }
  if (0x04 == grp && 0x01 == cmd) {
    printk(KERN_EMERG"***** PGO *****");
  }
  if (0x04 == grp && 0x81 == cmd) {
    printk(KERN_EMERG"***** PGR *****");
  }
  if (0x04 == grp && 0x82 == cmd) {
    printk(KERN_EMERG"***** PST *****");
  }
  if (0x04 == grp && 0x92 == cmd) {
    printk(KERN_EMERG"***** PES *****");
  }
  if (0x08 == grp && 0xa1 == cmd) {
    printk(KERN_EMERG"***** PSC *****");
  }
  for ( i = 0; i < sz; i++) {
    snprintf(_buf + offset, 512 - offset, " %02x", buf[i]);
    offset += strlen(" xx");
    if (offset > (512-4)) {
      snprintf(_buf + offset, 512 - offset, "\n");
      break;
    }
    if (i == sz-1) {
      snprintf(_buf + offset, 512 - offset, "\n");
    }
  }
  printk(buf);
}
#endif
static void pcie_LinkDown_and_EngineDown(void)
{
	rapi_share_param_t *p_rapi_param;
	void  __iomem  *reg;
	int i=0;
	FUNC_START;
	printk("[rapi]%s L%d: PCIe LINK_DOWN Start \n", __FUNCTION__, __LINE__);
	p_rapi_param = get_rapi_share_param();
	reg = ioremap(PCIE_CORE_ADDR1, 0xc00);
	if (reg != NULL) {
		for (i=0; i<PCIE_CORE_SIZE1; i++) {
			reg_core_data1[i] = readl(reg + i*(sizeof(unsigned long)));
		}
		iounmap(reg);
	}
	reg = ioremap(PCIE_CORE_ADDR2, 0x020);
	if (reg != NULL) {
		for (i=0; i<PCIE_CORE_SIZE2; i++) {
			reg_core_data2[i] = readl(reg + i*(sizeof(unsigned long)));
		}
		iounmap(reg);
	}
	printk("[rapi]%s L%d:pci_save_state \n", __FUNCTION__, __LINE__);
	pci_save_state(p_rapi_param->pci_dev);
	printk("[rapi]%s L%d:pci_set_power_state(D0 -> D3)\n", __FUNCTION__, __LINE__);
	{
		pm_message_t state;
		state.event = PM_EVENT_SUSPEND;
		pci_set_power_state(p_rapi_param->pci_dev, pci_choose_state(p_rapi_param->pci_dev, state));
	}
	gpio_set_value(18, 0x00);
	mdelay(10);
	gpio_set_value(44, 0x01);
	mdelay(10);
	FUNC_END;
}
static void pcie_EngineWakeup_and_LinkUP(void)
{
	rapi_share_param_t *p_rapi_param = NULL;
	p_rapi_param = get_rapi_share_param();
	FUNC_START;
	printk("[rapi]%s L%d: PCIe LINK_UP Start \n", __FUNCTION__, __LINE__);
	RapiCommReset(sc->sc_comm);
	atomic_set(&(sc->sc_nrcv), 0);
	gpio_set_value(44, 0x00);
	mdelay(10);
	gpio_set_value(18, 0x01);
	mdelay(10);
	while (0x01 != gpio_get_value(51)) {
		mdelay(1);
		continue;
	}
#if 0
	reg = ioremap(PCIE_CORE_ADDR1, 0xc00);
	if (reg != NULL) {
		for (i=0; i<PCIE_CORE_SIZE1; i++) {
			writel(reg_core_data1[i], reg + i*(sizeof(unsigned long)));
		}
		iounmap(reg);
	}
	reg = ioremap(PCIE_CORE_ADDR2, 0x020);
	if (reg != NULL) {
		for (i=0; i<PCIE_CORE_SIZE2; i++) {
			writel(reg_core_data2[i], reg + i*(sizeof(unsigned long)));
		}
		iounmap(reg);
	}
#endif
	printk("[rapi]%s L%d:pci_set_power_state(D3 -> D0)\n", __FUNCTION__, __LINE__);
	pci_set_power_state(p_rapi_param->pci_dev, PCI_D0);
	mdelay(10);
	printk("[rapi]%s L%d:pci_restore_state \n", __FUNCTION__, __LINE__);
	pci_restore_state(p_rapi_param->pci_dev);
	mdelay(10);
	FUNC_END;
}
static int engine_state()
{
	int val;
	val = gpio_get_value(GPIO_ENG_READY);
	return val;
}
#if 0
void timer_handler(unsigned long data)
{
	int msk;
	msk = 0x02;
	iowrite32(msk, (void *)(sc->mem_vaddr + 0x74));
}
#endif
extern char g_register_size[4];
extern char g_register_data[4][32];
void dump_registers(int log_level)
{
	int i = 0;
	char buf[4][128];
	struct timeval cur;
#define PRINTK(fmt, args...)	FORCE_DPRINTK(KERN_SOH"%d" fmt, log_level, ## args)
	memset(buf[0], 0x00, 128);
	do_gettimeofday(&cur);
	PRINTK("[%s][%ld.%06ld] <<< PCIe REGSTER DUMP(%d) >>> \n", __FUNCTION__, cur.tv_sec, cur.tv_usec, log_level);
	for (i = 0; i < 32; i++) {
		sprintf(&(buf[0][i*3]), "%02x ", g_register_data[0][i]);
		sprintf(&(buf[1][i*3]), "%02x ", g_register_data[1][i]);
		sprintf(&(buf[2][i*3]), "%02x ", g_register_data[2][i]);
		sprintf(&(buf[3][i*3]), "%02x ", g_register_data[3][i]);
	}
	PRINTK("[%s] size[0]=%2d, packet[0]=%s\n", __FUNCTION__, g_register_size[0], buf[0]);
	PRINTK("[%s] size[1]=%2d, packet[1]=%s\n", __FUNCTION__, g_register_size[1], buf[1]);
	PRINTK("[%s] size[2]=%2d, packet[2]=%s\n", __FUNCTION__, g_register_size[2], buf[2]);
	PRINTK("[%s] size[3]=%2d, packet[3]=%s\n", __FUNCTION__, g_register_size[3], buf[3]);
	PRINTK("[%s] ENGRDY_N     = %d(%s) \n", __FUNCTION__, gpio_get_value(GPIO_ENG_READY), gpio_get_value(GPIO_ENG_READY) ? "Busy" : "Ready");
	PRINTK("[%s] VDET_EPCI    = %d(%s) \n", __FUNCTION__, gpio_get_value(GPIO_ENG_PWCTL), gpio_get_value(GPIO_ENG_PWCTL) ? "ON" : "Down");
	PRINTK("[%s] sc->sc_err   = 0x%08x \n", __FUNCTION__, sc->sc_err);
	PRINTK("[%s] sc->sc_err2  = 0x%08x \n", __FUNCTION__, sc->sc_err2);
	PRINTK("[%s] sc->sc_flags = 0x%08x \n", __FUNCTION__, sc->sc_flags);
	PRINTK("[%s] sc->sc_nrcv  = %d \n", __FUNCTION__, atomic_read(&(sc->sc_nrcv)));
	PRINTK("[%s] sc->engine_down= %d \n", __FUNCTION__, sc->engine_down);
}
void dump_rapi_struct()
{
  struct timeval cur;
  do_gettimeofday(&cur);
  FORCE_DPRINTK("[%s][%ld.%06ld] <<< RAPI SC STRUCT >>> \n",
		__FUNCTION__, cur.tv_sec, cur.tv_usec);
  FORCE_DPRINTK("[%s][%ld.%06ld] sc->irqno: %x \n",
		__FUNCTION__, cur.tv_sec, cur.tv_usec, sc->irqno);
  FORCE_DPRINTK("[%s][%ld.%06ld] sc->irq_eng_ready: %x \n",
		__FUNCTION__, cur.tv_sec, cur.tv_usec, sc->irq_eng_ready);
  FORCE_DPRINTK("[%s][%ld.%06ld] sc->sc_comm: %p \n",
		__FUNCTION__, cur.tv_sec, cur.tv_usec, sc->sc_comm);
  FORCE_DPRINTK("[%s][%ld.%06ld] sc->sc_nrcv: %d \n",
		__FUNCTION__, cur.tv_sec, cur.tv_usec, atomic_read(&(sc->sc_nrcv)));
  FORCE_DPRINTK("[%s][%ld.%06ld] sc->sc_err: %d \n",
		__FUNCTION__, cur.tv_sec, cur.tv_usec, sc->sc_err);
  FORCE_DPRINTK("[%s][%ld.%06ld] sc->sc_err2: %d \n",
		__FUNCTION__, cur.tv_sec, cur.tv_usec, sc->sc_err2);
  FORCE_DPRINTK("[%s][%ld.%06ld] sc->sc_al_opened: %d \n",
		__FUNCTION__, cur.tv_sec, cur.tv_usec, sc->sc_al_opened);
  FORCE_DPRINTK("[%s][%ld.%06ld] mem_guard: %02x %02x %02x %02x \n",
		__FUNCTION__, cur.tv_sec, cur.tv_usec,
		sc->mem_guard[0], sc->mem_guard[1], sc->mem_guard[2], sc->mem_guard[3]);
}
static int rapi_open(struct inode *inode, struct file *filep)
{
	int retvalue = -EBUSY;
	FUNC_START;
	retvalue = 0;
	filep->private_data = NULL;
	if (sc == NULL) {
		PRINT_ERR("device driver not attach\n");
		retvalue = -ENXIO;
		goto error;
	}
	if ((filep->f_flags & O_RDWR) != O_RDWR) {
		PRINT_ERR("invalid flag=[0x%08x]\n", (u_int) filep->f_flags);
		retvalue = -EACCES;
		goto error;
	}
	if (sc->sc_flags & CSF_OPENED) {
	        PRINT_ERR("device already opened\n");
	}
	if (sc->sc_comm == NULL) {
		PRINT_INFO("%s: device open failed\n", __FUNCTION__);
		retvalue = -ENXIO;
		goto error;
	}
	if (sc->sc_al_opened == 0) {
	        printk(KERN_EMERG"!!!!! [%s] open clear nrcv !!!!!\n", __FUNCTION__);
		sc->sc_al_opened = 1;
		atomic_set(&(sc->sc_nrcv), 0);
		sc->sc_err = 0;
		sc->sc_err2 = 0;
		RapiCommStart(sc->sc_comm);
	}
	sc->sc_flags |= CSF_OPENED;
	FUNC_END;
 error:
	return retvalue;
}
EXPORT_SYMBOL(rapi_open);
static int rapi_close(struct inode *inode, struct file *filep)
{
	FUNC_START;
	if (filep->private_data) {
		filep->private_data = NULL;
	}
	FUNC_END;
	return 0;
}
EXPORT_SYMBOL(rapi_close);
static ssize_t rapi_read(struct file *filep, char __user * buf, size_t len,
			 loff_t * ptr)
{
	ssize_t retvalue = -EBUSY;
	int readed = 0;
	int error = 0;
	u_char cmd[RAPIFRAMEMAXRX];
	u_char errcmd = 0;
	int _sc_nrcv_before = 0;
	int _sc_nrcv_after = 0;
	int _sc_nrcv_end = 0;
	int _sc_err_before = 0;
	int _sc_err_after = 0;
	u_short _rx_read_ptr1 = 0;
	u_short _rx_write_ptr1 = 0;
	u_short _rx_read_ptr2 = 0;
	u_short _rx_write_ptr2 = 0;
	struct timeval start;
	struct timeval end;
	int intrtn = 0;
	char _usrbuf[1];
	int retry_wait_event_cnt = 0;
#define MAX_RETRY_WAIT_EVENT (3)
	do_gettimeofday(&start);
	FUNC_START;
	retvalue = len;
	memset (cmd, 0xff, RAPIFRAMEMAXRX);
	if ((filep->f_flags & O_NONBLOCK))
	{
		FORCE_DPRINTK("rapi device does not suppor NONBLOCK mode\n");
		error = -EWOULDBLOCK;
		return error;
	}
	error = 0;
	errcmd = 0;
	if (len < RAPIFRAMEMAXRX || NULL == buf) {
		return -EINVAL;
	}
	errcmd = scerr_to_readsts();
	if (RAPI_FRAME != errcmd)
	{
		PRINT_ERR(" Error0 readed=%d, errcmd=%d, cmd[0]=0x%02x, retvalue=0x%02x\n", readed, errcmd, cmd[0], retvalue);
		cmd[0] = errcmd;
		retvalue = copy_to_user(buf, cmd, 1);
		if (0 == retvalue)
		{
			retvalue = 1;
		}
		goto exit_cause_error;
	}
	if (RAPI_FRAME == errcmd)
	{
	        if (0 == atomic_read(&(sc->sc_nrcv)))
		{
			if ((filep->f_flags & O_NONBLOCK))
			{
				FORCE_DPRINTK("rapi device does not suppor NONBLOCK mode\n");
				error = -EWOULDBLOCK;
				return error;
			}
			rx_read_jiffies_befor_wait = jiffies;
			_sc_nrcv_before = atomic_read(&(sc->sc_nrcv));
			_sc_err_before = sc->sc_err;
			sc->sc_flags |= CSF_WANTREAD;
		retry_wait_event_interruptible:
			intrtn =
			  wait_event_interruptible(data_wait_queue, ((0 < atomic_read(&(sc->sc_nrcv))) || (0 != sc->sc_err)));
			if (intrtn < 0) {
			  printk(KERN_EMERG"[rapi] ***** wait_event_interrupt: rtn: %d nrcv: %d sc_err: %d *****\n", intrtn, atomic_read(&(sc->sc_nrcv)), sc->sc_err);
			  retry_wait_event_cnt++;
			  if (retry_wait_event_cnt < MAX_RETRY_WAIT_EVENT) {
			    goto retry_wait_event_interruptible;
			  }
			  retry_wait_event_cnt = 0;
			}
			rx_read_jiffies_after_wait = jiffies;
			_sc_nrcv_after = atomic_read(&(sc->sc_nrcv));
			_rx_read_ptr1 = rapicom[0]->_RxReadPtr;
			_rx_write_ptr1 = rapicom[0]->_RxWritePtr;
			_sc_err_after = sc->sc_err;
			errcmd = scerr_to_readsts();
			if (RAPI_FRAME != errcmd)
			{
				cmd[0] = errcmd;
				retvalue = copy_to_user(buf, cmd, 1);
				if (0 == retvalue)
				{
					retvalue = 1;
				}
			}
		}
		if (read_force_sleep_flag > 0) {
		  read_force_sleep_flag--;
		}
		if (atomic_read(&(sc->sc_nrcv)) > 0) {
		        readed = RapiCommRead(sc->sc_comm, cmd + 1);
			if (0 < readed) {
			       if (atomic_read(&(sc->sc_nrcv)) <= 0) {
				       printk(KERN_EMERG"!!!!! [%s] rapi read set nrcv to negative value: %d !!!!!\n", __FUNCTION__, atomic_read(&(sc->sc_nrcv)));
				       dump_registers(0);
			       }
				atomic_dec(&(sc->sc_nrcv));
				cmd[0] = errcmd;
				retvalue = copy_to_user(buf, cmd, readed + 1);
				if (0 == retvalue) {
				  retvalue = readed + 1;
				}
			}
			if (0 == readed) {
			        PRINT_ERR(" Error1 readed=%d, errcmd=%d, cmd[0]=0x%02x, retvalue=0x%02x, sc->sc_nrcv=%d \n", readed, errcmd, cmd[0], retvalue, atomic_read(&(sc->sc_nrcv)));
				if (0xff == cmd[0]) {
				        printk(KERN_EMERG" !!! SC641 ?? Reset RAPI ERROR -> RAPI_DOWN !!!\n");
					dump_registers(0);
				}
				retvalue = copy_to_user(buf, cmd, 1);
				if (0 == retvalue) {
				        retvalue = 1;
				}
			}
			if ((0 > readed) && (RAPI_FRAME == errcmd) && (0xff == cmd[0])) {
			        PRINT_ERR(" Error2 readed=%d, errcmd=%d, cmd[0]=0x%02x retvalue=0x%02x, sc->sc_nrcv=%d \n", readed, errcmd, cmd[0], retvalue, atomic_read(&(sc->sc_nrcv)));
				dump_registers(0);
				cmd[0] = RAPI_DOWN;
				retvalue = copy_to_user(buf, cmd, 1);
				if (0 == retvalue) {
				        retvalue = 1;
				}
			}
			else if (0 > readed) {
			        PRINT_ERR(" Error3 readed=%d, errcmd=%d, cmd[0]=0x%02x, retvalue=0x%02x, sc->sc_nrcv=%d \n", readed, errcmd, cmd[0], retvalue, atomic_read(&(sc->sc_nrcv)));
				dump_registers(0);
			}
			_sc_nrcv_end = atomic_read(&(sc->sc_nrcv));
			_rx_read_ptr2 = rapicom[0]->_RxReadPtr;
			_rx_write_ptr2 = rapicom[0]->_RxWritePtr;;
			do_gettimeofday(&end);
#if 1
			{
			        int i=0;
				static char strbuff[(3*256)+1] = { 0x00 };
				printk("[rapi_read][%ld.%06ld][%ld.%06ld] nrcv: %d ptr: %d %d DRV->APP",
				       start.tv_sec, start.tv_usec, end.tv_sec, end.tv_usec,
				       _sc_nrcv_end,
				       _rx_read_ptr2,
				       _rx_write_ptr2);
				for (i=0; i<(retvalue + 1); i++) {
				        sprintf(&(strbuff[i*3]), " %02x", buf[i]);
					if (24 < retvalue && 10 < i) {
					        sprintf(&(strbuff[i*3]), " ... %02x", buf[retvalue]);
						break;
					}
				}
				printk("%s\n", strbuff);
				if ((rx_read_jiffies_after_wait - rx_read_jiffies_befor_wait) > 100) {
				        printk("\t wait before: %ld\n", rx_read_jiffies_befor_wait);
				        printk("\t wait after: %ld\n", rx_read_jiffies_after_wait);
				        printk("\t sc_nrcv: %d %d\n", _sc_nrcv_before, _sc_nrcv_after);
				        printk("\t Rx Ptr: %d %d\n", _rx_read_ptr1, _rx_write_ptr1);
				        printk("\t sc_err: %d %d\n", _sc_err_before, _sc_err_after);
				}
			}
#endif
		}
		else {
			printk(KERN_EMERG"!!!!! read called but nrecv is zero or negative %d errcmd:%x scerr:%x  !!!!! \n", atomic_read(&(sc->sc_nrcv)),errcmd,sc->sc_err);
			retvalue = 0;
			cmd[0] = errcmd;
			if (0 == retvalue) {
			  retvalue = 1;
			}
		}
	}
 exit_cause_error:
	if (intrtn < 0) {
	  copy_from_user(_usrbuf, buf, 1);
	  printk(KERN_EMERG"[rapi] ***** rapi read rtn: %d buf: %02x \n", retvalue, _usrbuf[0]);
	}
	FUNC_END;
	return retvalue;
}
EXPORT_SYMBOL(rapi_read);
static int scerr_to_readsts()
{
	int errcmd;
	errcmd = RAPI_FRAME;
	if (sc->sc_err & ~CSF_ERR_DOWN) {
		if (sc->sc_err & CSF_ERR_INTERR) {
			sc->sc_err &= ~CSF_ERR_INTERR;
			errcmd = RAPI_INTERR;
			FORCE_DPRINTK(KERN_EMERG"[rapi]<<ERROR>> INTERNAL ERROR \n");
		}
		else if (sc->sc_err & CSF_ERR_TIMEOUT) {
			sc->sc_err &= ~CSF_ERR_TIMEOUT;
			errcmd = RAPI_TIMEOUT;
			FORCE_DPRINTK(KERN_EMERG"[rapi]<<ERROR>> TIMEOUT ERROR \n");
		}
		else if (sc->sc_err & CSF_ERR_WAKEUP) {
			sc->sc_err &= ~CSF_ERR_WAKEUP;
			errcmd = RAPI_WAKEUP;
			FORCE_DPRINTK(KERN_ERR"[rapi]<<WARN>> ENGINE WAKEUP \n");
		}
		else if (sc->sc_err & CSF_ERR_BADFORM) {
			sc->sc_err &= ~CSF_ERR_BADFORM;
			errcmd = RAPI_BADFORM;
			FORCE_DPRINTK(KERN_EMERG"[rapi]<<ERROR>> BAD FRAME \n");
		}
		else if (sc->sc_err & CSF_ERR_SUM) {
			sc->sc_err &= ~CSF_ERR_SUM;
			errcmd = RAPI_SUMERR;
			FORCE_DPRINTK(KERN_EMERG"[rapi]<<ERROR>> SUM ERROR \n");
		}
		else if (sc->sc_err & CSF_ERR_RETRY) {
			sc->sc_err &= ~CSF_ERR_RETRY;
			errcmd = RAPI_RETRY;
			FORCE_DPRINTK(KERN_ERR"[rapi]<<ERROR>> RETRY ERROR \n");
		}
		else if (sc->sc_err & CSF_ERR_ERROR) {
			sc->sc_err &= ~CSF_ERR_ERROR;
			errcmd = RAPI_ERROR;
			FORCE_DPRINTK(KERN_EMERG"[rapi]<<ERROR>> RETRY_MAX ERROR \n");
		}
		else {
			errcmd = RAPI_INTERR;
			FORCE_DPRINTK(KERN_EMERG"[rapi]<<ERROR>> UNDEFINED ERROR \n");
		}
		mdelay(100);
	}
	else if ((sc->sc_err & CSF_ERR_DOWN) && (atomic_read(&(sc->sc_nrcv)) == 0)) {
		sc->sc_err &= ~CSF_ERR_DOWN;
		errcmd = RAPI_DOWN;
		FORCE_DPRINTK(KERN_ERR"[%s]L%d: sc_err=[0x%02x], errcmd=[0x%02x] \n", __FUNCTION__, __LINE__, sc->sc_err, errcmd);
		mdelay(100);
	} else if (sc->sc_err & CSF_ERR_DOWN) {
	        FORCE_DPRINTK(KERN_EMERG"[%s]L%d: sc_err=[0x%02x], errcmd=[0x%02x], sc->sc_nrcv=%d \n", __FUNCTION__, __LINE__, sc->sc_err, errcmd, atomic_read(&(sc->sc_nrcv)));
		mdelay(100);
	}
	return errcmd;
}
static ssize_t rapi_write(struct file *filep, const char __user * buf,
			  size_t len, loff_t * ptr)
{
	ssize_t retvalue = -EBUSY;
	u_char cmd[RAPIFRAMEMAX];
	int count;
	int error;
	struct timeval start, end;
	do_gettimeofday(&start);
	FUNC_START;
	retvalue = len;
	mutex_lock(&sc->engine_mutex);
	if ((filep->f_flags & O_NONBLOCK)) {
		FORCE_DPRINTK("rapi device does not suppor NONBLOCK mode\n");
		error = -EWOULDBLOCK;
		mutex_unlock(&sc->engine_mutex);
		return error;
	}
	count = len;
	if (count > RAPIFRAMEMAX || count == 0 || NULL == buf) {
		PRINT_ERR("tx data length over or 0  count=[%d]\n", count);
		mutex_unlock(&sc->engine_mutex);
		return -EINVAL;
	}
	error = copy_from_user(cmd, buf, count);
	if (error < 0) {
		PRINT_INFO("copy from user error=[%d]\n", error);
		mutex_unlock(&sc->engine_mutex);
		return -EINVAL;
	}
#if 0
	{
	  printk("[rapi_write] DRV->APP");
	  parseCmdBuf(buf, retvalue);
	}
	printk("%s", buf);
#endif
 RetryWrite:
	retvalue = 0;
#ifdef RAPI_TXFULL_TEST
	if (tx_full_test) {
	  FORCE_DPRINTK(KERN_ERR "***** TX_FULL test, RapiCommWrite return TX_FULL *****\n");
	  error = TX_FULL;
	  tx_full_test = false;
	}
	else {
	  error = RapiCommWrite(sc->sc_comm, cmd, count);
	}
#else
	error = RapiCommWrite(sc->sc_comm, cmd, count);
#endif
	switch (error) {
	case TX_FULL:
	        FORCE_DPRINTK(KERN_ERR "***** TX_FULL Retry...  *****\n");
		if ((filep->f_flags & O_NONBLOCK)) {
			PRINT_INFO
			    ("%s: RapiCommWrite error(TX_FULL) IO_NDELAY\n",
			     __FUNCTION__);
			mutex_unlock(&sc->engine_mutex);
			return -EWOULDBLOCK;
		}
		sc->sc_flags |= CSF_WANTWRITE;
		msleep(500);
	        FORCE_DPRINTK(KERN_ERR "***** goto RetryWrite  *****\n");
		goto RetryWrite;
	default:
		break;
	}
	do_gettimeofday(&end);
#if 1
	{
		int i=0;
		static char strbuff[(3*256)+1] = { 0x00 };
		printk("[rapi_write][%ld.%06ld][%ld.%06ld] APP->DRV len: %d ", start.tv_sec, start.tv_usec, end.tv_sec, end.tv_usec, len);
		for (i=0; i<(len + 1); i++)
		{
			sprintf(&(strbuff[i*3]), " %02x", buf[i]);
			if (24 < len && 10 < i)
			{
				sprintf(&(strbuff[i*3]), " ... %02x", buf[retvalue]);
				break;
			}
		}
		printk("%s\n", strbuff);
	}
#endif
	retvalue = len;
	mutex_unlock(&sc->engine_mutex);
	FUNC_END;
	return (retvalue);
}
EXPORT_SYMBOL(rapi_write);
static long rapi_ioctl(struct file *filep, unsigned int cmd, unsigned long arg)
{
	long retvalue = 0;
	struct rapi_getdata ioctl_data;
	struct rapi_getdata *usr_data = (struct rapi_getdata *)arg;
	FUNC_START;
	switch (cmd) {
	case RAPIDRV_PWRCTLOFF:
		printk(KERN_EMERG "[%s]RAPIDRV_PWRCTLOFF\n", __FUNCTION__);
		mutex_lock(&sc->engine_mutex);
		pcie_LinkDown_and_EngineDown();
		sc->engine_down = 1;
		mutex_unlock(&sc->engine_mutex);
		read_force_sleep_flag = 10;
		break;
	case RAPIDRV_PWRCTLON:
		printk(KERN_EMERG "[%s]RAPIDRV_PWRCTLON\n", __FUNCTION__);
		mutex_lock(&sc->engine_mutex);
		pcie_EngineWakeup_and_LinkUP();
		sc->engine_down = 0;
		mutex_unlock(&sc->engine_mutex);
		read_force_sleep_flag = 10;
		break;
	case RAPIDRV_PWRGET:
		printk(KERN_DEBUG "[%s]RAPIDRV_PWRGET\n", __FUNCTION__);
		ioctl_data.engrdy = (0x01 & !gpio_get_value(GPIO_ENG_READY));
		ioctl_data.pwctl  = (0x01 & gpio_get_value(GPIO_ENG_PWCTL));
		retvalue = copy_to_user(usr_data, &ioctl_data, sizeof(struct rapi_getdata));
		break;
	case RAPIDRV_FUKIOFF:
		printk(KERN_DEBUG "[%s]RAPIDRV_FUKIOFF\n", __FUNCTION__);
		retvalue = -EINVAL;
		break;
	case RAPIDRV_FUKION:
		printk(KERN_DEBUG "[%s]RAPIDRV_FUKION\n", __FUNCTION__);
		retvalue = -EINVAL;
		break;
	case RAPIDRV_SETDPKMODE:
		printk(KERN_DEBUG "[%s]RAPIDRV_SET_DPKMODE\n", __FUNCTION__);
       		RapiCommModeSet(sc->sc_comm, RAPI_COMM_DPK);
		break;
#ifdef RAPI_RETRY_TEST
	case RAPIDRV_RETRYTEST:
		{
			rapi_retry_test_t *rapidata = (rapi_retry_test_t *) arg;
			retry_txsumcnt = rapidata->txsumcnt;
			retry_txackcnt = rapidata->txackcnt;
			retry_rxsumcnt = rapidata->rxsumcnt;
			retry_rxackcnt = rapidata->rxackcnt;
			break;
		}
#endif
#ifdef RAPI_TXFULL_TEST
	case RAPIDRV_TXFULLTEST_START:
	  {
	    tx_full_test = true;
	    break;
	  }
	case RAPIDRV_TXFULLTEST_END:
	  {
	    tx_full_test = false;
	    break;
	  }
#endif
	case RAPIDRV_MAINTAINEON:
		printk(KERN_DEBUG "%s():RAPIDRV_MAINTAINEON\n", __FUNCTION__);
		break;
	case RAPIDRV_MAINTAINEOFF:
		printk(KERN_DEBUG "%s():RAPIDRV_MAINTAINEOFF\n", __FUNCTION__);
		break;
	default:
		printk(KERN_DEBUG "%s():No Command(%d)\n", __FUNCTION__, cmd);
		retvalue = -EINVAL;
		break;
	}
	FUNC_END;
	return (retvalue);
}
EXPORT_SYMBOL(rapi_ioctl);
static unsigned int rapi_poll(struct file *file, poll_table * wait)
{
	unsigned int retvalue = 0;
	FUNC_START;
	PRINT_INFO("sc_nrcv: %d sc_error: %d\n", atomic_read(&(sc->sc_nrcv)), sc->sc_err);
	poll_wait(file, &data_wait_queue, wait);
	if (atomic_read(&(sc->sc_nrcv)) > 0 || sc->sc_err) {
		retvalue |= (POLLIN | POLLRDNORM);
	}
	if (RapiTxEmpty(sc->sc_comm)) {
		retvalue |= (retvalue | (POLLOUT | POLLWRNORM));
	}
	FUNC_END;
	return (retvalue);
}
EXPORT_SYMBOL(rapi_poll);
static int rapi_proc_open(struct inode *node, struct file *fp)
{
        printk("open\n");
	return single_open(fp, rapi_proc_show, NULL);
}
static ssize_t rapi_proc_show(struct seq_file *m, void *v)
{
        int pon_eng;
	int vdet_epic;
	int pci_link;
	u_short vendor_id = 0, device_id = 0;
	int eng_ready;
	unsigned int val;
	val = 0;
        pon_eng = gpio_get_value(44);
	vdet_epic = gpio_get_value(GPIO_ENG_PWCTL);
	if (is_initialized == true) {
	  pci_read_config_word(sc->pci_dev, PCI_VENDOR_ID, &vendor_id);
	  pci_read_config_word(sc->pci_dev, PCI_DEVICE_ID, &device_id);
	  if (0x1180 == vendor_id && 0x5015 == device_id) {
	    pci_link = 1;
	  }
	  else {
	    pci_link = 0;
	  }
	}
	else {
	  pci_link = 0;
	  sc->sc_err2 = 1;
	}
	eng_ready = gpio_get_value(GPIO_ENG_READY);
	if (pon_eng) {
	        val |= (0x01 << 31);
	}
	if (vdet_epic) {
	        val |= (0x01 << 30);
	}
	if (pci_link) {
	        val |= (0x01 << 29);
	}
	if (eng_ready) {
	        val |= (0x01 << 28);
	}
	if (sc->sc_err2) {
	        val |= sc->sc_err2;
	}
        seq_printf(m, "%x\n",
		   val);
	seq_printf(m, " pon_eng: %d\n vdet_epic:%d\n pci_link:%d\n eng_ready:%d\n",
		   pon_eng,
		   vdet_epic,
		   pci_link,
		   eng_ready);
	seq_printf(m, "sc: %p sc->err: %x sc->err2: %x\n", sc, sc->sc_err, sc->sc_err2);
	sc->sc_err2 = 0;
        return 0;
}
void rapiattention(int unit, u_short atn)
{
	switch (atn) {
	case RAPI_FRAME:
	        atomic_inc(&(sc->sc_nrcv));
		break;
	case RAPI_BADFORM:
		sc->sc_err |= CSF_ERR_BADFORM;
		if (!sc->engine_down) {
		  sc->sc_err2 |= CSF_ERR_BADFORM;
		}
		PRINT_ERR("RAPI_BADFORM sc->sc_err=0x%02x, sc->sc_err2=0x%02x, sc->sc_flags=0x%02x \n", sc->sc_err, sc->sc_err2, sc->sc_flags);
		break;
	case RAPI_WAKEUP:
		sc->sc_err |= CSF_ERR_WAKEUP;
		if (!sc->engine_down) {
		  sc->sc_err2 |= CSF_ERR_WAKEUP;
		}
		PRINT_ERR("RAPI_WAKEUP sc->sc_err=0x%02x, sc->sc_err2=0x%02x, sc->sc_flags=0x%02x \n", sc->sc_err, sc->sc_err2, sc->sc_flags);
		break;
	case RAPI_DOWN:
		sc->sc_err |= CSF_ERR_DOWN;
		if (!sc->engine_down) {
		  sc->sc_err2 |= CSF_ERR_DOWN;
		}
		PRINT_ERR("RAPI_DOWN sc->sc_err=0x%02x, sc->sc_err2=0x%02x, sc->sc_flags=0x%02x \n", sc->sc_err, sc->sc_err2, sc->sc_flags);
		break;
	case RAPI_TIMEOUT:
		sc->sc_err |= CSF_ERR_TIMEOUT;
		if (!sc->engine_down) {
		  sc->sc_err2 |= CSF_ERR_TIMEOUT;
		}
		PRINT_ERR("RAPI_TIMEOUT sc->sc_err=0x%02x, sc->sc_err2=0x%02x, sc->sc_flags=0x%02x \n", sc->sc_err, sc->sc_err2, sc->sc_flags);
		break;
	case RAPI_INTERR:
		sc->sc_err |= CSF_ERR_INTERR;
		if (!sc->engine_down) {
		  sc->sc_err2 |= CSF_ERR_INTERR;
		}
		PRINT_ERR("RAPI_INTERR sc->sc_err=0x%02x, sc->sc_err2=0x%02x, sc->sc_flags=0x%02x \n", sc->sc_err, sc->sc_err2, sc->sc_flags);
		break;
	case RAPI_TXEMPTY:
		if (sc->sc_flags & CSF_SELWRITE && sc->sc_flags & CSF_OPENED) {
			sc->sc_flags &= ~CSF_SELWRITE;
		}
		PRINT_ERR("RAPI_TXEMPTY sc->sc_err=0x%02x, sc->sc_err2=0x%02x, sc->sc_flags=0x%02x \n", sc->sc_err, sc->sc_err2, sc->sc_flags);
		break;
	case RAPI_SUMERR:
		sc->sc_err |= CSF_ERR_SUM;
		if (!sc->engine_down) {
		  sc->sc_err2 |= CSF_ERR_SUM;
		}
		PRINT_ERR("RAPI_SUMERR sc->sc_err=0x%02x, sc->sc_err2=0x%02x, sc->sc_flags=0x%02x \n", sc->sc_err, sc->sc_err2, sc->sc_flags);
		break;
	case RAPI_RETRY:
		sc->sc_err |= CSF_ERR_RETRY;
		if (!sc->engine_down) {
		  sc->sc_err2 |= CSF_ERR_RETRY;
		}
		PRINT_ERR("RAPI_RETRY sc->sc_err=0x%02x, sc->sc_err2=0x%02x, sc->sc_flags=0x%02x \n", sc->sc_err, sc->sc_err2, sc->sc_flags);
		break;
	case RAPI_ERROR:
		sc->sc_err |= CSF_ERR_ERROR;
		if (!sc->engine_down) {
		  sc->sc_err2 |= CSF_ERR_ERROR;
		}
		PRINT_ERR("RAPI_ERROR sc->sc_err=0x%02x, sc->sc_err2=0x%02x, sc->sc_flags=0x%02x \n", sc->sc_err, sc->sc_err2, sc->sc_flags);
		break;
	default:
		PRINT_ERR("invalid attention code(%x)!, sc->sc_err=0x%02x, sc->sc_err2=0x%02x, sc->sc_flags=0x%02x \n", atn, sc->sc_err, sc->sc_err2, sc->sc_flags);
		break;
	}
	if ((atomic_read(&(sc->sc_nrcv)) != 0 || sc->sc_err) && (sc->sc_flags & CSF_OPENED)) {
		if (sc->sc_flags & CSF_WANTREAD) {
			sc->sc_flags &= ~CSF_WANTREAD;
			wake_up_interruptible(&data_wait_queue);
		}
		if (sc->sc_flags & CSF_SELREAD) {
			sc->sc_flags &= ~CSF_SELREAD;
			wake_up_interruptible(&data_wait_queue);
		}
	}
}
u_short rapienginesense(int unit)
{
	u_short res = 0;
	u_int sts0, sts1;
	FUNC_START;
	if (engine_state() != 0) {
		res |= PWR_ON;
	}
#if 0
	if (sc->int_type == 0) {
		if (DIFFERENTLOGIC_READY) {
			if ((ASIC_READ4(ENG_PORT) & 0x01) == 0x01) {
				res |= ENG_READY;
			}
		} else {
			sts0 = ASIC_READ4(ENG_PORT);
			sts1 = ASIC_READ4(ENG_PORT);
			if ((sts0 & 0x00000001) != (sts1 & 0x00000001)) {
				sts0 = ASIC_READ4(ENG_PORT);
			}
			if (!(sts0 & 0x00000001)) {
				res |= ENG_READY;
			}
		}
	} else {
		if (DIFFERENTLOGIC_READY) {
			if ((ASIC_READ4(ENG_PORT) & 0x10000) == 0x10000) {
				res |= ENG_READY;
			}
		} else {
			if ((ASIC_READ4(ENG_PORT) & 0x10000) == 0) {
				res |= ENG_READY;
			}
		}
	}
#endif
	sts0 = (0x01 & gpio_get_value(GPIO_ENG_READY));
	mdelay(100);
	sts1 = (0x01 & gpio_get_value(GPIO_ENG_READY));
	if ((sts0 & 0x00000001) != (sts1 & 0x00000001)) {
		sts0 = (0x01 & gpio_get_value(GPIO_ENG_READY));
	}
	if (!(sts0 & 0x00000001)) {
		res |= ENG_READY;
	}
	FUNC_END;
	return (res);
}
void rapisetegint(int unit, u_short flag)
{
	if (flag) {
	} else {
	}
}
static int rapi_attach(void *pdev)
{
	int ret;
	u_short vendor_id = 0, device_id = 0;
	u_short command = 0, status = 0;
	FUNC_START;
	printk("rapi.ko: version: %s \n", commitid);
	memset(sc, 0x00, sizeof(rapi_t));
	sc->sc_share = get_rapi_share_param();
	sc->pci_dev = sc->sc_share->pci_dev;
	ret = pci_enable_device(sc->pci_dev);
	if (ret) {
		PRINT_ERR("error pci_enable_device = %d \n", ret);
	} else {
	}
	pci_set_master(sc->pci_dev);
	{
		sc->mem_addr = pci_resource_start(sc->pci_dev, 0);
		sc->mem_len = pci_resource_len(sc->pci_dev, 0);
		if (!request_mem_region
		    (sc->mem_addr, sc->mem_len, RAPI_DRIVER_NAME)) {
			PRINT_ERR("%s:error request_mem_region\n",
				  RAPI_DRIVER_NAME);
		}
		sc->mem_vaddr =
		    (unsigned long)ioremap_nocache(sc->mem_addr, sc->mem_len);
		if (!sc->mem_vaddr) {
			PRINT_ERR("%s:error ioremap_nocache\n",
				  RAPI_DRIVER_NAME);
		}
	}
	mutex_init(&(sc->sc_mutex));
	atomic_set(&(sc->sc_mutex_count), 0);
	mutex_init(&(sc->engine_mutex));
	atomic_set(&(sc->engine_mutex_count), 0);
	sc->irqno = sc->pci_dev->irq;
	ret =
	    request_irq(sc->irqno, rapi_intr, IRQF_SHARED, RAPI_DRIVER_NAME,
			(void *)sc->pci_dev);
	if (ret) {
		PRINT_ERR("%s:error request_irq\n", RAPI_DRIVER_NAME);
	}
	pci_read_config_word(sc->pci_dev, PCI_VENDOR_ID, &vendor_id);
	pci_read_config_word(sc->pci_dev, PCI_DEVICE_ID, &device_id);
	pci_read_config_word(sc->pci_dev, PCI_COMMAND, &command);
	pci_read_config_word(sc->pci_dev, PCI_STATUS, &status);
	sc->sc_comm = RapiCommOpen(0,
				   RAPICMDQRXLEN, RAPICMDQTXLEN,
				   rapiattention,
				   rapi_readpacket_PCIE,
				   rapi_writepacket_PCIE,
				   rapienginesense,
				   rapi_settxint_PCIE,
				   rapi_setrxint_PCIE, rapisetegint);
	sc->irq_eng_ready = gpio_to_irq(GPIO_ENG_READY);
	PRINT_INFO("%s:irq_eng_ready=%d\n", RAPI_DRIVER_NAME,
	         sc->irq_eng_ready);
	ret =
	    request_irq(sc->irq_eng_ready, rapi_engready_intr,
			IRQF_TRIGGER_FALLING | IRQF_TRIGGER_RISING,
			RAPI_DRIVER_NAME, (void *)sc->pci_dev);
	if (ret) {
		PRINT_ERR("%s:error request_irq\n", RAPI_DRIVER_NAME);
	}
#if 0
	r = ioread8((void *)((void *)(sc->mem_vaddr + 0x10)));
	PRINT_INFO("0x%02x \n", r);
	r = ioread8((void *)((void *)(sc->mem_vaddr + 0x10 + 1)));
	PRINT_INFO("0x%02x \n", r);
	r = ioread8((void *)((void *)(sc->mem_vaddr + 0x10 + 2)));
	PRINT_INFO("0x%02x \n", r);
	r = ioread8((void *)((void *)(sc->mem_vaddr + 0x10 + 3)));
	PRINT_INFO("0x%02x \n", r);
	r = ioread8((void *)((void *)(sc->mem_vaddr + 0x10 + 4)));
	PRINT_INFO("0x%02x \n", r);
	r = ioread8((void *)((void *)(sc->mem_vaddr + 0x10 + 5)));
	PRINT_INFO("0x%02x \n", r);
	r = ioread8((void *)((void *)(sc->mem_vaddr + 0x10 + 6)));
	PRINT_INFO("0x%02x \n", r);
	r = ioread8((void *)((void *)(sc->mem_vaddr + 0x10 + 7)));
	PRINT_INFO("0x%02x \n", r);
	iowrite8(0xDE, (void *)(sc->mem_vaddr + 0x40));
	iowrite8(0xAD, (void *)(sc->mem_vaddr + 0x40 + 1));
	iowrite8(0xBE, (void *)(sc->mem_vaddr + 0x40 + 2));
	iowrite8(0xEF, (void *)(sc->mem_vaddr + 0x40 + 3));
	iowrite8(0xC0, (void *)(sc->mem_vaddr + 0x40 + 4));
	iowrite8(0xFF, (void *)(sc->mem_vaddr + 0x40 + 5));
	iowrite8(0xEE, (void *)(sc->mem_vaddr + 0x40 + 6));
#endif
	FUNC_END;
	return 0;
}
static int rapi_detach(void *pdev)
{
	FUNC_START;
	FUNC_END;
	return 0;
}
static void rapi_wqueue_handler(work_struct_t * work)
{
	rapi_work_t *ptr_work = NULL;
	FUNC_START;
	ptr_work = (rapi_work_t *) work;
	FUNC_END;
	return;
}
static irqreturn_t rapi_engready_intr(int irq, void *pdev)
{
	int ret;
	if (NULL != sc->sc_comm) {
	  RapiEngStatInt(sc->sc_comm);
	}
	else {
	  printk(KERN_EMERG"***** [rapi] INTERRUPT IGNORED CAUSE sc->sc_comm IS NULL *****");
	  dump_rapi_struct();
	}
	ret = IRQ_HANDLED;
	return ret;
}
static irqreturn_t rapi_intr(int irq, void *pdev)
{
#if 0
	if (intrnum != 0) {
		intrnum++;
		return IRQ_HANDLED;
	}
	FUNC_START;
	queue_work(ptr_rapi_wqueue, (work_struct_t *) & rapi_work_struct);
	intrnum++;
	FUNC_END;
	return IRQ_HANDLED;
#endif
	int sts;
	int ret;
	sts = rapi_intr_pci_PCIE(NULL);
	if (0 == sts) {
		ret = IRQ_NONE;
	} else {
		ret = IRQ_HANDLED;
	}
	return ret;
}
static int rapi_probe(struct pci_dev *pdev, const struct pci_device_id *entry)
{
	int ret = -1;
	dev_t rapi_dev;
	struct class *p_rapi_class;
	struct device *p_device;
	rapi_share_param_t *p_rapi_param;
	rapi_driver_header_t *p_rapi_header;
	FUNC_START;
	if (is_inititlized)
	{
		printk("Already Initialized \n");
		goto SKIP_END;
	}
	init_waitqueue_head(&data_wait_queue);
	init_waitqueue_head(&tx_wait_queue);
	p_rapi_param = get_rapi_share_param();
	p_rapi_param->pci_dev = pdev;
	p_rapi_class = class_create(THIS_MODULE, RAPI_DRIVER_NAME);
	if (IS_ERR(p_rapi_class)) {
		PRINT_ERR("error class_create\n");
		return PTR_ERR(p_rapi_class);
	}
	ret = alloc_chrdev_region(&rapi_dev, 0, 1, RAPI_DRIVER_NAME);
	if (ret) {
		PRINT_ERR("error alloc_chrdev_region = %d \n", ret);
		class_destroy(p_rapi_class);
		return PTR_ERR(p_rapi_class);
	}
	ret = rapi_devlist[0].attachfunc(rapi_devlist[0].softc);
	if (ret) {
		PRINT_ERR("error attachfunc = %d \n", ret);
		unregister_chrdev_region(rapi_device_major,
					 ARRAY_SIZE(rapi_devlist));
		class_destroy(p_rapi_class);
		return PTR_ERR(p_rapi_class);
	}
	p_rapi_header = rapi_devlist[0].softc;
	p_rapi_header->sc_dev = MKDEV(MAJOR(rapi_dev), 0);
	p_rapi_header->sc_class = p_rapi_class;
	p_rapi_header->sc_name = rapi_devlist[0].name;
	cdev_init(&(p_rapi_header->sc_cdev), rapi_devlist[0].ops);
	p_rapi_header->sc_cdev.owner = THIS_MODULE;
	ret = cdev_add(&(p_rapi_header->sc_cdev), p_rapi_header->sc_dev, 1);
	if (ret) {
		PRINT_ERR("error cdev_add = %d \n", ret);
		device_destroy(p_rapi_header->sc_class, p_rapi_header->sc_dev);
		cdev_del(&(p_rapi_header->sc_cdev));
		unregister_chrdev_region(rapi_device_major,
					 ARRAY_SIZE(rapi_devlist));
		class_destroy(p_rapi_class);
		return PTR_ERR(p_rapi_class);
	}
	p_device =
	    device_create(p_rapi_class, NULL, p_rapi_header->sc_dev, NULL,
			  rapi_devlist[0].name);
	if (IS_ERR(p_device)) {
		PRINT_ERR("error device_create = %d \n", ret);
		device_destroy(p_rapi_header->sc_class, p_rapi_header->sc_dev);
		cdev_del(&(p_rapi_header->sc_cdev));
		unregister_chrdev_region(rapi_device_major,
					 ARRAY_SIZE(rapi_devlist));
		class_destroy(p_rapi_class);
		return PTR_ERR(p_rapi_class);
	}
	ptr_rapi_wqueue = create_workqueue(RAPI_WQUEUE_NAME);
	if (!ptr_rapi_wqueue) {
		PRINT_ERR("Can't create workqueue_struct! orz!!!\n");
		destroy_workqueue(ptr_rapi_wqueue);
		device_destroy(p_rapi_header->sc_class, p_rapi_header->sc_dev);
		cdev_del(&(p_rapi_header->sc_cdev));
		unregister_chrdev_region(rapi_device_major,
					 ARRAY_SIZE(rapi_devlist));
		class_destroy(p_rapi_class);
		return PTR_ERR(p_rapi_class);
	}
	INIT_WORK((work_struct_t *) (&rapi_work_struct), rapi_wqueue_handler);
	is_inititlized = 1;
SKIP_END:
	FUNC_END;
	return 0;
}
static void rapi_remove(struct pci_dev *pdev)
{
	FUNC_START;
	FUNC_END;
}
static int rapi_suspend(struct pci_dev *pdev, pm_message_t state)
{
	FUNC_START;
	FUNC_END;
	return (0);
}
static int rapi_resume(struct pci_dev *pdev)
{
	FUNC_START;
	FUNC_END;
	return (0);
}
static void init_rapi_share_param(void)
{
	if (is_initialized == true) {
		return;
	}
	memset(&rapi_share_param, 0x00, sizeof(rapi_share_param));
	is_initialized = true;
}
rapi_share_param_t *get_rapi_share_param(void)
{
	if (is_initialized == false) {
		init_rapi_share_param();
	}
	return &rapi_share_param;
}
EXPORT_SYMBOL(get_rapi_share_param);
static void initialize_rapi_comm(rapi_t *val) {
  if (NULL != val) {
    memset(val, 0xff, sizeof(rapi_t));
    val->mem_guard[0]=0xde;
    val->mem_guard[1]=0xad;
    val->mem_guard[2]=0xbe;
    val->mem_guard[3]=0xef;
  }
}
static int __init rapi_init(void)
{
	int retval;
	FUNC_START;
	initialize_rapi_comm(sc);
	dump_rapi_struct();
#if 0
	rapi_info.rapi_class = class_create(THIS_MODULE, "rapi");
	if (IS_ERR(rapi_info.rapi_class)) {
		retval = PTR_ERR(rapi_info.rapi_class);
		printk(KERN_DEBUG "rapi:%s(): can't create class\n",
		       __FUNCTION__);
	}
	iret = alloc_chrdev_region(&rapi_dev, 0, 0, "rapi");
	if (iret) {
		printk(KERN_DEBUG "rapi:%s(): can't alloc character device.\n",
		       __FUNCTION__);
		return (iret);
	}
	rapi_info.major = MAJOR(rapi_dev);
	device_create(rapi_info.rapi_class, NULL, MKDEV(rapi_info.major, 0),
		      NULL, "rapi0");
	cdev_init(&cdev_rapi_mod, &rapi_fops);
	cdev_rapi_mod.owner = THIS_MODULE;
	iret = cdev_add(&cdev_rapi_mod, MKDEV(rapi_info.major, 0), 1);
	if (iret < 0) {
		printk(KERN_DEBUG "rapi:%s(): cdev_add() error(%d)\n",
		       __FUNCTION__, iret);
		return -1;
	}
	retval = 0;
#endif
	retval = pci_register_driver(&rapi_driver);
	if(is_entried == 0) {
	        proc_entry = proc_create(RAPI_PROC_STATUS_FILENAME, 0444, NULL, &rapi_status_proc_fops );
		if (proc_entry == NULL) {
			remove_proc_entry("errorinfo_for_emmc", NULL);
			printk(KERN_EMERG "rapi: ERROR Couldn't create proc entry\n");
		} else {
			printk(KERN_INFO "rapi_status: SUCCESS add /proc/rapi_status.\n");
		}
		is_entried = 1;
	}
	FUNC_END;
	return retval;
}
EXPORT_SYMBOL(rapi_init);
static void __exit rapi_exit(void)
{
	rapi_driver_header_t *p_rapi_header;
	FUNC_START;
	remove_proc_entry(RAPI_PROC_STATUS_FILENAME, NULL);
	p_rapi_header = rapi_devlist[0].softc;
	device_destroy(p_rapi_header->sc_class, p_rapi_header->sc_dev);
	cdev_del(&(p_rapi_header->sc_cdev));
	unregister_chrdev_region(p_rapi_header->sc_dev,
				 ARRAY_SIZE(rapi_devlist));
	class_destroy(p_rapi_header->sc_class);
	rapi_devlist[0].detachfunc(rapi_devlist[0].softc);
	FUNC_END;
}
EXPORT_SYMBOL(rapi_exit);
module_init(rapi_init);
module_exit(rapi_exit);
MODULE_AUTHOR("RICOH");
MODULE_DESCRIPTION("simva kernel module");
MODULE_LICENSE("GPL");
MODULE_VERSION("2015_July_23 01");
