/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/
 
/** 
* \file ipc_well_known_ports.h
* 
* \brief List of well known port values to be used by both sides 
*        of the IPC.
* 
* IPC ports help funnel data passing between processors to the 
* correct driver. 
*  
**/

#ifndef INC_IPC_WELL_KNOWN_PORTS_H
#define INC_IPC_WELL_KNOWN_PORTS_H

// NOTE - any ports that are OEM specific should be included from
//        an OEM file of well known ports.  Each OEM port should
//        include the IPC_OEM_PORT_MASK as part of its value.
#define IPC_OEM_PORT_MASK ( 0x80 )

// Definitions of common ports (0x00 - 0x0F are reserved by IPC)
#define IPC_PORT_POWER_MANAGER  0x10

#endif // INC_IPC_WELL_KNOWN_PORTS_H
