/*
**************************************************************************************
*
* Copyright (c) 2013 Marvell International, Ltd. All Rights Reserved
*
**************************************************************************************
*
* Marvell GPL License
*
* This file licensed to you in accordance with the terms and conditions of the General
* Public License Version 2, June 1991 (the "GPL License"). You can redistribute it
* and/or modify it under the terms of the GPL License; either version 2 of the License,
* or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but WITHOUT ANY
* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
* PARTICULAR PURPOSE. See the GPL License for more details.
*
* You should have received a copy of the GNU General Public License along with this
* program. If not, see http://www.gnu.org/licenses/.
*
**************************************************************************************
*/

#ifndef _LKM_HIPS_PLL_H
#define _LKM_HIPS_PLL_H

typedef struct _hips_dev hips_pll_device_t;
typedef struct _hips_dev hips_dev;

// Linux interface

hips_dev* hips_kopen( unsigned int channel );
int hips_kclose( hips_dev* dev );

// compatibility interface for RTOS codebase
typedef int error_type_t;
#ifndef OK
#define OK 0
#endif
#ifndef FAIL
#define FAIL -1
#endif

 /**
  * \brief Open a given hips pll channel
  * The hips pll is mapped to a number of different blocks.  The 
  * definition of the blocks depends on the asic.  This will enable a
  * given block to have the hips pll sent to it.
  * \param handle The address of a pointer for the returned handle
  * \param[in] The channel to open
  * \retval OK everything worked.  If a problem this will assert.
  */
static inline error_type_t hips_pll_open(hips_pll_device_t **handle, uint8_t channel)
{
    *handle = (hips_pll_device_t*)hips_kopen(channel);
    return (*handle != NULL) ? OK : FAIL;
}

 /**
  * \brief Close a given hips pll channel
  * The hips pll is mapped to a number of different blocks.  This close turns
  * off the pll clock to the given block and closes the channel.  If there is
  * a problem this will assert.
  * \param[in] the handle that was returned by the open above.
  * \returns error_type_t
  * \retval OK everything is ok.  
  */
static inline error_type_t hips_pll_close(hips_pll_device_t *handle)
{
    return (hips_kclose((hips_dev*)handle) == 0) ? OK : FAIL;
}

#endif


