/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


#ifndef MARVELL_LOGGER_H
#define MARVELL_LOGGER_H

#include <linux/kernel.h>

#define LOG_EMERG KERN_EMERG
#define LOG_ALERT KERN_ALERT
#define LOG_CRIT  KERN_CRIT
#define LOG_ERR   KERN_ERR
#define LOG_WARNING KERN_WARNING
#define LOG_NOTICE KERN_NOTICE
#define LOG_INFO  KERN_INFO
#define LOG_DEBUG KERN_DEBUG
#define LOG_DEBUG_M KERN_DEBUG
#define LOG_DEBUG_H KERN_DEBUG


#define DBG_PRINTF(level, fmt, args...) printk( level,## __VARGS__ )
#define dbg_printf printk
#define cmd_printf printk
/// macros to include log_level and a file provided DBG_PRFX
/// these are highly recommended as the automatic inclusion of DBG_PRFX allows for post 
/// logging searching.  DBG_PRFX can be a text prefix based on module or submodule.
///  
#define DBG_PRINTF_EMERG(...) DBG_PRINTF(LOG_EMERG, DBG_PRFX __VA_ARGS__)
#define DBG_PRINTF_ALERT(...) DBG_PRINTF(LOG_ALERT, DBG_PRFX __VA_ARGS__)
#define DBG_PRINTF_CRIT(...) DBG_PRINTF(LOG_CRIT, DBG_PRFX __VA_ARGS__)
#define DBG_PRINTF_ERR(...) DBG_PRINTF(LOG_ERR, DBG_PRFX __VA_ARGS__)
#define DBG_PRINTF_WARNING(...) DBG_PRINTF(LOG_WARNING, DBG_PRFX __VA_ARGS__)
#define DBG_PRINTF_NOTICE(...) DBG_PRINTF(LOG_NOTICE, DBG_PRFX __VA_ARGS__)
#define DBG_PRINTF_INFO(...) DBG_PRINTF(LOG_INFO, DBG_PRFX __VA_ARGS__)
#define DBG_PRINTF_DEBUG(...) DBG_PRINTF(LOG_DEBUG, DBG_PRFX __VA_ARGS__)
#define DBG_PRINTF_DEBUG_M(...) DBG_PRINTF(LOG_DEBUG_M, DBG_PRFX __VA_ARGS__)
#define DBG_PRINTF_DEBUG_H(...) DBG_PRINTF(LOG_DEBUG_H, DBG_PRFX __VA_ARGS__)


/// Below is NOT used other than to define a number that will be unused:


/// LOG_MODULE 0-31
/// must be sequential with unused at the end.
#define DEBUG_LOGGER_MODULE_PRINT           0 ///< PRINT MODULE has submodules.
#define DEBUG_LOGGER_MODULE_CNTRL_PANEL     1 ///< control panel 
#define DEBUG_LOGGER_MODULE_USB_DEVICE      2 
#define DEBUG_LOGGER_MODULE_NVRAM           3 ///< non-volatile spi flash etc.
#define DEBUG_LOGGER_MODULE_SYSTEM          4 ///< SYSTEM is a big bag.
#define DEBUG_LOGGER_MODULE_NETWORK         5 ///< Lots of submodules in NETWORK
#define DEBUG_LOGGER_MODULE_GPIO            6 ///< DEVICE with submodule might be better idea.
#define DEBUG_LOGGER_MODULE_SCAN            7
#define DEBUG_LOGGER_MODULE_ENGINE          8 ///< is this print engine 
#define DEBUG_LOGGER_MODULE_DPRINTF         9 ///< DPRINTF's without LOGGER_MODULE_MASK defined go here.
#define DEBUG_LOGGER_MODULE_DEVICES        10 ///< DEVICE with submodule
#define DEBUG_LOGGER_MODULE_VIDEO          11 ///< VIDEO
#define DEBUG_LOGGER_MODULE_JBIG           12 ///< JBIG
#define DEBUG_LOGGER_MODULE_HTTP           13 ///< HTTP
#define DEBUG_LOGGER_MODULE_FILESYSTEM     14 ///< Filesystem
#define DEBUG_LOGGER_MODULE_GENERATORS     15 ///< Generators
#define DEBUG_LOGGER_MODULE_CONSUMABLES    16 ///< Consumables
#define DEBUG_LOGGER_MODULE_OEM1           17 ///< OEM1 move OEM id's down as we add more 
#define DEBUG_LOGGER_MODULE_OEM2           18 ///< OEM2 each oem can add its own submodules.
#define DEBUG_LOGGER_MODULE_OEM3           19 ///< OEM3 Do not allow an oem to rename these.
#define DEBUG_LOGGER_MODULE_OEM4           20 ///< OEM4
#define DEBUG_LOGGER_LAST_MODULE           20 ///< keep this updated to the last in use module number, 
                                              ///< keep logger.c::debug_logger_idx_names[] updated. 
#define LOGGER_SUBMODULE_BIT(submodule_id)  1



#endif
