//#define USE_RAWTTY


#include <err.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#ifdef USE_RAWTTY
#include <termios.h>
#endif
#include <unistd.h>


#define DEVICE_UCOM1	"/dev/ttyUSB0"    /* デバイスファイル */
#define BUFFER_SIZE		512	/* コマンドのバッファサイズ */

#define ARMADA_HEADER   "0,DrawSC,2,0"  /* ARMADAへのコマンドに添付するヘッダ */
#define CMD_INTERVAL    2       /* コマンド送信間隔 (秒) */

struct ucom_cmd {
	const char *line0;
	const char *line1;
	const char *line2;
} ucom_cmds[] = {
    { "START", "start test", "(1/5)" },
    { "START", "in progress", "(2/5)" },
    { "START", "in progress", "(3/5)" },
    { "START", "in progress", "(4/5)" },
    { "START", "in progress", "(5/5)" },
    { "END", "all test complete", "conguraturation" },
};
#define NARRAY(a)   (sizeof(a)/sizeof(a[0]))


int main(int, char *[]);
int
main(int argc, char *argv[])
{
    int fd, rv, i;
    int len;
    char buf[BUFFER_SIZE];
#ifdef USE_RAWTTY
#define RAWTTY_PREFIX   "\r\n"  /* CRLF: (0D 0A) - XXX:LFだけでも動く */
    struct termios ts, ts_old;
#else
#define RAWTTY_PREFIX   ""
#endif

    /* デバイスのオープン */
    fd = open(DEVICE_UCOM1, O_RDWR);
    if (fd < 0)
        err(1, "fail open()");

#ifdef USE_RAWTTY
    /* ttyをrawモードに設定する */
    rv = tcgetattr(fd, &ts);
    if (rv)
        err(1, "fail tcgetattr()");
    ts_old =  ts;
    cfmakeraw(&ts);
    rv = tcsetattr(fd, TCSANOW, &ts);
    if (rv)
        err(1, "fail tcsetattr()");
#endif

    for (i = 0; i < NARRAY(ucom_cmds); i++) {

        /* 送信データバッファを生成 */
        memset(buf, 0x00, sizeof(buf));
        snprintf(buf, sizeof(buf),
             "%s,%d,\"%s\",%d,\"%s\",%d,\"%s\"\r" RAWTTY_PREFIX,
             ARMADA_HEADER,
             strlen(ucom_cmds[i].line0), ucom_cmds[i].line0,
             strlen(ucom_cmds[i].line1), ucom_cmds[i].line1,
             strlen(ucom_cmds[i].line2), ucom_cmds[i].line2);
        // XXX - バッファサイズのチェックは実施しない

        /* 総バッファサイズの計算 */
        len = strlen(buf);

        /* データ送信 */
        rv = write(fd, buf, len);
        if (rv < 0)
            err(1, "fail write()");
        if (rv != len)
            errx(1, "invalid write size : %d (expect %d)", rv, len);

        /* 次のコマンド送信前にウェイトを入れる */
        sleep(CMD_INTERVAL);
    }

#ifdef USE_RAWTTY
    rv = tcsetattr(fd, TCSADRAIN, &ts_old);
    if (rv)
        err(1, "fail tcsetattr()");
#endif
    close(fd);

    return 0;
}
