#!/bin/sh

# Emit a useful diagnostic if something fails:
bb_exit_handler() {
    ret=$?
    case $ret in
    0)  ;;
    *)  case $BASH_VERSION in
        "")   echo "WARNING: exit code $ret from a shell command.";;
        *)    echo "WARNING: ${BASH_SOURCE[0]}:${BASH_LINENO[0]} exit $ret from
  "$BASH_COMMAND"";;
        esac
        exit $ret
    esac
}
trap 'bb_exit_handler' 0
set -e
export prefix="/usr"
export localstatedir="/var"
export BUILD_CXX="g++ "
export LD="arm-poky-linux-gnueabi-ld --sysroot=/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2 "
export BUILD_LDFLAGS="-L/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/usr/lib -L/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/lib -Wl,-rpath-link,/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/usr/lib -Wl,-rpath-link,/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/lib -Wl,-rpath,/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/usr/lib -Wl,-rpath,/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/lib -Wl,-O1"
export STRINGS="arm-poky-linux-gnueabi-strings"
export CC="arm-poky-linux-gnueabi-gcc  -march=armv7-a -mthumb-interwork -mfloat-abi=softfp -mfpu=neon --sysroot=/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2"
export CPPFLAGS=""
export CXX="arm-poky-linux-gnueabi-g++  -march=armv7-a -mthumb-interwork -mfloat-abi=softfp -mfpu=neon --sysroot=/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2"
export OBJCOPY="arm-poky-linux-gnueabi-objcopy"
export servicedir="/srv"
export LC_ALL="C"
export sysconfdir="/etc"
export CCLD="arm-poky-linux-gnueabi-gcc  -march=armv7-a -mthumb-interwork -mfloat-abi=softfp -mfpu=neon --sysroot=/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2"
export base_bindir="/bin"
export PKG_CONFIG_LIBDIR="/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2//usr/lib/pkgconfig"
export sbindir="/usr/sbin"
export CFLAGS=" -O2 -pipe -g -feliminate-unused-debug-types"
export TARGET_LDFLAGS="-Wl,-O1 -Wl,--hash-style=gnu -Wl,--as-needed"
export NM="arm-poky-linux-gnueabi-nm"
export USER="mnakamura"
export KERNEL_VERSION="3.18.7-2015-08-28-88pa6270-bsp-yocto-standard"
export BUILD_CCLD="gcc "
export BUILD_CPP="cpp "
export BUILD_CFLAGS="-isystem/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/usr/include -O2 -pipe"
export base_prefix=""
export ARCH="arm"
export TERM="xterm"
export OS="linux-gnueabi"
export CPP="arm-poky-linux-gnueabi-gcc -E --sysroot=/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2  -march=armv7-a -mthumb-interwork -mfloat-abi=softfp -mfpu=neon"
export BUILD_CXXFLAGS="-isystem/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/usr/include -O2 -pipe -fpermissive"
export HOME="/home/mnakamura"
export PATCH_GET="0"
export CXXFLAGS=" -O2 -pipe -g -feliminate-unused-debug-types -fpermissive -fvisibility-inlines-hidden"
unset MACHINE
export BUILD_STRIP="strip"
export STRIP="arm-poky-linux-gnueabi-strip"
export libexecdir="/usr/lib/svinput-mod"
export datadir="/usr/share"
export PKG_CONFIG_SYSROOT_DIR="/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2"
export bindir="/usr/bin"
export TARGET_CXXFLAGS=" -O2 -pipe -g -feliminate-unused-debug-types -fpermissive"
export includedir="/usr/include"
export oldincludedir="/usr/include"
export LOGNAME="mnakamura"
export PKG_CONFIG_DISABLE_UNINSTALLED="yes"
export RANLIB="arm-poky-linux-gnueabi-ranlib"
export BUILD_NM="nm"
export BUILD_RANLIB="ranlib"
export mandir="/usr/share/man"
export CROSS_COMPILE="arm-poky-linux-gnueabi-"
export PSEUDO_DISABLED="1"
export BUILD_CC="gcc "
export systemd_unitdir="/lib/systemd"
export F77="arm-poky-linux-gnueabi-g77  -march=armv7-a -mthumb-interwork -mfloat-abi=softfp -mfpu=neon --sysroot=/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2"
export sharedstatedir="/com"
export PSEUDO_UNLOAD="1"
export LDFLAGS="-Wl,-O1 -Wl,--hash-style=gnu -Wl,--as-needed"
export MAKE="make"
unset TARGET_ARCH
export BUILD_F77="g77 "
export CCACHE_DIR="/home/mnakamura"
export infodir="/usr/share/info"
export base_sbindir="/sbin"
export PKG_CONFIG_PATH="/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2//usr/lib/pkgconfig:/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2/usr/share/pkgconfig"
export AS="arm-poky-linux-gnueabi-as "
export AR="arm-poky-linux-gnueabi-ar"
export BUILD_CPPFLAGS="-isystem/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/usr/include"
export CCACHE_DISABLE="1"
export TARGET_CPPFLAGS=""
export exec_prefix="/usr"
export base_libdir="/lib"
export PATH="/home/mnakamura/work_bsp/build-bundle/poky/scripts:/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/usr/bin/armv7a-vfp-neon-poky-linux-gnueabi:/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2/usr/bin/crossscripts:/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/usr/sbin:/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/usr/bin:/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux/sbin:/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/x86_64-linux//bin:/home/mnakamura/work_bsp/build-bundle/poky/scripts:/home/mnakamura/work_bsp/build-bundle/poky/bitbake/bin:/home/mnakamura/work_bsp/ostools.ostools/scripts:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/games"
export TARGET_CFLAGS=" -O2 -pipe -g -feliminate-unused-debug-types"
export BUILD_LD="ld "
export BUILD_AR="ar"
export BUILD_AS="as "
export OBJDUMP="arm-poky-linux-gnueabi-objdump"
unset DISTRO
export PKG_CONFIG_DIR="/home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2//usr/lib/pkgconfig"
export libdir="/usr/lib"
export nonarch_base_libdir="/lib"
export docdir="/usr/share/doc"
export SHELL="/bin/bash"
export UBOOT_ARCH="arm"


make ARCH=arm CROSS_COMPILE=arm-poky-linux-gnueabi- -C /home/mnakamura/work_bsp/build-bundle/poky/build/tmp/sysroots/granite2/usr/src/kernel M=`pwd` clean

