/*
 ******************************************************************************
 * Copyright (c) 2011 Marvell International, Ltd. All Rights Reserved
 *
 *                         Marvell Confidential
 ******************************************************************************
 *
 *
 *  Portions of this may contain copyrighted or confidential materials from
 *  Marvell and/or Marvell's suppliers. Copying and distribution of such
 *  materials for any other purpose except in conjunction with a Marvell
 *  Product, is expressly prohibited.
 *   
 *  DISCLAIMER OF WARRANTIES. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE
 *  LAW, THE SOURCE CODE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
 *  MARVELL AND ITS SUPPLIERS DISCLAIM ANY WARRANTY OR OBLIGATION TO PROVIDE
 *  SUPPORT, UPDATES OR BUG FIXES FOR THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTY AS TO THE ACCURACY, SUFFICIENCY OR SUITABILITY
 *  FOR ANY PURPOSES WHAT-SO-EVER OF THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTIES OR REPRE-SENTATIONS HEREUNDER, WHETHER
 *  EXPRESS OR IMPLIED, EITHER IN FACT OR BY OPERATION OF LAW, STATUTORY OR
 *  OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES, TERMS OR CONDITIONS
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, SATISFACTORY QUALITY,
 *  CORRESPONDENCE WITH DESCRIPTION, QUIET ENJOYMENT OR NON-INFRINGEMENT OF
 *  THIRD PARTY INTELLECTUAL PROPERTY RIGHTS.
 *  
 ******************************************************************************
*/

#define ALIGN32

#include <stdint.h>
#include "dbg_printf.h"

/****************************************
*             SWI Interrupt             *
*****************************************/

void CSwiHandler(void)
{
}

/****************************************
*             FIQ Interrupt             *
*****************************************/

void CFiqHandler(void)
{
}

/****************************************
*             IRQ Interrupt             *
*****************************************/

void CIrqHandler(void)
{
}

/****************************************
*             main function             *
*****************************************/

int main(void)
{
    int i,k;
    volatile uint32_t *upc_done = (uint32_t *)0x04000000; // the main cpu sees this at 0xF9280000
    
    do {
        print("UPC0 is now running...");

        for(i = 0; i < 10000000; i++) {
            if((k = *upc_done) == i) {
                print("\r\n");
            }
        }

        *upc_done = 0x42; // tell UPC1 we are done

        while(*upc_done != 0x56); // now wait here until UPC1 is done
    } while(1);
}

