/*
 ******************************************************************************
 * Copyright (c) 2011 Marvell International, Ltd. All Rights Reserved
 *
 *                         Marvell Confidential
 ******************************************************************************
 *
 *
 *  Portions of this may contain copyrighted or confidential materials from
 *  Marvell and/or Marvell's suppliers. Copying and distribution of such
 *  materials for any other purpose except in conjunction with a Marvell
 *  Product, is expressly prohibited.
 *   
 *  DISCLAIMER OF WARRANTIES. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE
 *  LAW, THE SOURCE CODE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
 *  MARVELL AND ITS SUPPLIERS DISCLAIM ANY WARRANTY OR OBLIGATION TO PROVIDE
 *  SUPPORT, UPDATES OR BUG FIXES FOR THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTY AS TO THE ACCURACY, SUFFICIENCY OR SUITABILITY
 *  FOR ANY PURPOSES WHAT-SO-EVER OF THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTIES OR REPRE-SENTATIONS HEREUNDER, WHETHER
 *  EXPRESS OR IMPLIED, EITHER IN FACT OR BY OPERATION OF LAW, STATUTORY OR
 *  OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES, TERMS OR CONDITIONS
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, SATISFACTORY QUALITY,
 *  CORRESPONDENCE WITH DESCRIPTION, QUIET ENJOYMENT OR NON-INFRINGEMENT OF
 *  THIRD PARTY INTELLECTUAL PROPERTY RIGHTS.
 *  
 ******************************************************************************
*/

#define ALIGN32

#include <stdint.h>

#include "Xena.h"

/****************************************
*             SWI Interrupt             *
*****************************************/

void CSwiHandler(void)
{
}

/****************************************
*             FIQ Interrupt             *
*****************************************/

void CFiqHandler(void)
{
}

/****************************************
*             IRQ Interrupt             *
*****************************************/

void CIrqHandler(void)
{
}

/****************************************
*             main function             *
*****************************************/

int main(void)
{
    volatile XENA_REGS_t *upcRegs;

    upcRegs = (XENA_REGS_t *)REGBASE;

    // NOTE: This loop "should" only run once and never wakeup, but
    //       if it does, then it should reset everything and sleep...

    do {
        // disable all UPC IRQs
        upcRegs->IRQEnableFM[0] = 0x00;
        upcRegs->IRQEnableFM[1] = 0x00;
        upcRegs->IRQEnableFM[2] = 0x00;

        // disable all UPC FIQs
        upcRegs->FIQEnableFM[0] = 0x00;
        upcRegs->FIQEnableFM[1] = 0x00;
        upcRegs->FIQEnableFM[2] = 0x00;

        // clear any pending UPC interrupts
        upcRegs->IntClearFM[0] = XENA_INTCLEARFM0_CLEAR_MASK;
        upcRegs->IntClearFM[1] = XENA_INTCLEARFM1_CLEAR_MASK;
        upcRegs->IntClearFM[2] = XENA_INTCLEARFM2_CLEAR_MASK;

        // now, sleep forever waiting for an interrupt
        WAIT_FOR_INT
    } while(1);
}

