/*
 ******************************************************************************
 * Copyright (c) 2011 Marvell International, Ltd. All Rights Reserved
 *
 *                         Marvell Confidential
 ******************************************************************************
 *
 *
 *  Portions of this may contain copyrighted or confidential materials from
 *  Marvell and/or Marvell's suppliers. Copying and distribution of such
 *  materials for any other purpose except in conjunction with a Marvell
 *  Product, is expressly prohibited.
 *   
 *  DISCLAIMER OF WARRANTIES. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE
 *  LAW, THE SOURCE CODE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
 *  MARVELL AND ITS SUPPLIERS DISCLAIM ANY WARRANTY OR OBLIGATION TO PROVIDE
 *  SUPPORT, UPDATES OR BUG FIXES FOR THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTY AS TO THE ACCURACY, SUFFICIENCY OR SUITABILITY
 *  FOR ANY PURPOSES WHAT-SO-EVER OF THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTIES OR REPRE-SENTATIONS HEREUNDER, WHETHER
 *  EXPRESS OR IMPLIED, EITHER IN FACT OR BY OPERATION OF LAW, STATUTORY OR
 *  OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES, TERMS OR CONDITIONS
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, SATISFACTORY QUALITY,
 *  CORRESPONDENCE WITH DESCRIPTION, QUIET ENJOYMENT OR NON-INFRINGEMENT OF
 *  THIRD PARTY INTELLECTUAL PROPERTY RIGHTS.
 *  
 ******************************************************************************
*/

#define ALIGN32

#include <stdint.h>
#include <stdbool.h>
#include "upc_uart.h"
#include "dbg_printf.h"

// Set this depending on your debug state...
#if 0
  #define dprint(x)  print(x)
  #define dprinth(x) printh(x)
#else
  #define dprint(x)
  #define dprinth(x)
#endif

volatile char uc_rxData;
volatile char uc_txData;

/************************************
*        Initialize function        *
*************************************/

void test_init(void)
{
    volatile uint32_t regVal;

    upcRegs   = (XENA_REGS_t *)REGBASE;
    //sic1Regs  = (SIC_REGS_t *)APB_APB_SIC1_BASE;
    uart3Regs = (UART_REGS_t *)AP_AP_APB_UART3_BASE; // APB_UART3_BASE;

    // 1st, disable all UPC IRQs
    upcRegs->IRQEnableIO[0] = 0x00;
    upcRegs->IRQEnableIO[1] = 0x00;
    upcRegs->IRQEnableIO[2] = 0x00;

    // then disable all UPC FIQs
    upcRegs->FIQEnableIO[0] = 0x00;
    upcRegs->FIQEnableIO[1] = 0x00;
    upcRegs->FIQEnableIO[2] = 0x00;

    dprint("\r\ninit() Initial IIR ");
    dprinth(uart3Regs->union2.UART_IIR);

    // 2nd, continue with UART3 setup
    uart3Regs->union1.UART_IER = 0x00;

    // Set the buad rate to 115200, 1 start/stop, no parity, etc...
    uart3Regs->UART_LCR = 0x83;
    uart3Regs->union0.UART_DLL = 0x0D;
    uart3Regs->union1.UART_DLH = 0x00;
    uart3Regs->UART_LCR = 0x03;

    uart3Regs->UART_MCR = 0x03;
    uart3Regs->union2.UART_FCR = 0x00;

    // 3rd, enable the UART3 interrupts
    regVal  = 0;
    regVal |= UART_UART_IER_RLSE_REPLACE_VAL(  regVal, 0x01);
    regVal |= UART_UART_IER_TIE_REPLACE_VAL( regVal, 0x01);
    regVal |= UART_UART_IER_RAVIE_REPLACE_VAL( regVal, 0x01);
    uart3Regs->union1.UART_IER = regVal;

    regVal = uart3Regs->UART_MSR;        // clear IIR id 0x00
    //regVal = uart3Regs->USR;        // clear IIR id 0x07
    regVal = uart3Regs->UART_LSR;        // clear IIR id 0x06
    regVal = uart3Regs->union0.UART_RBR; // clear IIR id 0x04 and 0x0C
    regVal = uart3Regs->union2.UART_IIR; // clear IIR id 0x02

    dprint(" Final IIR ");
    dprinth(uart3Regs->union2.UART_IIR);
    dprint("\r\n");

#if 0
    // 4th, continue with SIC1 setup
    sic1Regs->EN_CLEAR  = UART3_IRQ;
    sic1Regs->FIQ_EN    = UART3_IRQ;
    sic1Regs->IRQENABLE = UART3_IRQ;
    sic1Regs->INT_ACK   = UART3_IRQ;
#endif

    // clear any pending UPC interrupts
    upcRegs->IntClearIO[0] = XENA_INTCLEARIO0_CLEAR_MASK;
    upcRegs->IntClearIO[1] = XENA_INTCLEARIO1_CLEAR_MASK;
    upcRegs->IntClearIO[2] = XENA_INTCLEARIO2_CLEAR_MASK;

    // enable UART3 as an FIQ via the UPC IRQ enable
    upcRegs->IRQEnableIO[2] = SIC1_FIQ;
}

/****************************************
*             SWI Interrupt             *
*****************************************/

void CSwiHandler(void)
{
    print("Uart SWI ISR - We should never get here!\r\n");
    while(1);
}

/****************************************
*             FIQ Interrupt             *
*****************************************/

void CFiqHandler(void)
{
    print("Uart FIQ ISR - We should never get here!\r\n");
    while(1);
}

/****************************************
*             IRQ Interrupt             *
*****************************************/

void CIrqHandler(void)
{
	volatile uint32_t uc_iir;

    dprint("\r\nISR ");
    dprinth(upcRegs->IntPostIO[2]);

    if((upcRegs->IntPostIO[2]) & (upcRegs->IRQEnableIO[2]) & SIC1_FIQ) {
        while((uc_iir = UART_UART_IIR_IID10_MASK_SHIFT(uart3Regs->union2.UART_IIR)) != NON_INT) {

            dprint(" IIR ");
            dprinth(uc_iir);
            dprint("\r\n");

            switch(uc_iir & 0x0F) {
                /*** Line Status Change ***/
                case LST_CHNG_INT: {
                    volatile uint32_t uc_data;

                    dprint("  LSR INT: ");
                    if(UART_UART_LSR_OE_MASK_SHIFT(uc_data) == IO_ERROR) { // Overrun error
                        dprint("OV\r\n");
                    }
                    if(UART_UART_LSR_PE_MASK_SHIFT(uc_data) == IO_ERROR) { // Parity error
                        dprint("PR\r\n");	
                    }
                    if(UART_UART_LSR_FE_MASK_SHIFT(uc_data) == IO_ERROR) { // Framing error
                        dprint("FR\r\n");
                    }

                    uc_data = uart3Regs->UART_LSR; // clear LSR interrupt
                }
                break;

                /*** Receive RX data ***/
                case RX_AVAIL_INT:
                    dprint("  RX INT\r\n");
                    uc_rxData = uart3Regs->union0.UART_RBR; // get Rx Data clearing RBR interrupt
                break;

                /*** THR Empty ***/
                case THR_EMP_INT:
                    dprint("  TX INT\r\n");
                    uc_txData = 0xFF;
                    uc_iir = UART_UART_IIR_IID10_MASK_SHIFT(uart3Regs->union2.UART_IIR); // clear THR interrupt
                break;

                default:
                    dprint("  NO INT\r\n");
                break;
            }
        }

        // Ack SIC1's FIQ
        //sic1Regs->INT_ACK = UART3_IRQ;
        // Ack UPC's IRQ
        upcRegs->IntClearIO[2] = SIC1_FIQ;
    } else {
        print("\r\nASSERT: Invalid UPC Interrupt ");
        printh(upcRegs->IntPostIO[2]);
        print("\r\n");
        while(1);
    }

    dprint("Exit ");
    dprinth(upcRegs->IntPostIO[2]);
    dprint(" IIR ");
    dprinth(uc_iir);
    dprint("\r\n");
}

/****************************************
*          send_TxChar function         *
*****************************************/

void send_TxChar(char data)
{
    uc_txData = 0;
    dprint("Transmit ");
    dprinth(data);
    uart3Regs->union0.UART_THR = data;
    while(uc_txData == 0);
    dprint(" Complete\r\n");
}

/****************************************
*             main function             *
*****************************************/

int main(void)
{
    int i;
    char data[10];

    test_init();

    data[0] = 'U';
    data[1] = 'P';
    data[2] = 'C';
    data[3] = ' ';
    data[4] = 'T';
    data[5] = 'e';
    data[6] = 's';
    data[7] = 't';
    data[8] = 13;
    data[9] = 10;

    print("\r\nTransmit our Initial Prompt...\r\n");
    for(i = 0; i < 10; i++) {
        send_TxChar( data[i]);
    }

    // Now, just sit here and receive/echo characters...

    uc_rxData = 0;
    print("\r\nWaiting for Receive Characters...\r\n");
    while(1) {
        if (uc_rxData != 0) {
            print ("Received ");
            printh(uc_rxData);
            send_TxChar(uc_rxData);
            print (" and Echoed\r\n");
            uc_rxData = 0;
        }
    }
}

