/*
 ******************************************************************************
 * Copyright (c) 2011 Marvell International, Ltd. All Rights Reserved
 *
 *                         Marvell Confidential
 ******************************************************************************
 *
 *  Portions of this may contain copyrighted or confidential materials from
 *  Marvell and/or Marvell's suppliers. Copying and distribution of such
 *  materials for any other purpose except in conjunction with a Marvell
 *  Product, is expressly prohibited.
 *   
 *  DISCLAIMER OF WARRANTIES. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE
 *  LAW, THE SOURCE CODE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
 *  MARVELL AND ITS SUPPLIERS DISCLAIM ANY WARRANTY OR OBLIGATION TO PROVIDE
 *  SUPPORT, UPDATES OR BUG FIXES FOR THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTY AS TO THE ACCURACY, SUFFICIENCY OR SUITABILITY
 *  FOR ANY PURPOSES WHAT-SO-EVER OF THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTIES OR REPRE-SENTATIONS HEREUNDER, WHETHER
 *  EXPRESS OR IMPLIED, EITHER IN FACT OR BY OPERATION OF LAW, STATUTORY OR
 *  OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES, TERMS OR CONDITIONS
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, SATISFACTORY QUALITY,
 *  CORRESPONDENCE WITH DESCRIPTION, QUIET ENJOYMENT OR NON-INFRINGEMENT OF
 *  THIRD PARTY INTELLECTUAL PROPERTY RIGHTS.
 *  
 ******************************************************************************
*/

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>

#define XENA_REGS_t int // stub out user space unused upc.h typedefs
#include "upc_ioctl.h" 

void usage(char *arg)
{
    fprintf(stderr, "Usage: %s [-o <operation {stop|start}>] [-m <memory {itcm|dtcm}>]\n", arg);
    exit(EXIT_FAILURE);
}

int main(int argc, char *argv[])
{
    int fd;
    int opt;
    int retval;
    int upcOpr = 0; // 1=stop 2=start
    int upcMem = 0; // 1=itcm 2=dtcm

    if (argc < 2) usage(argv[0]);

    while ((opt = getopt(argc, argv, "o:m:")) != -1) {
        switch (opt) {
            char buff[6];

            case 'o':
                upcOpr++;
                strncpy(buff, optarg, 5);
                buff[5] = 0;
                if (0 == strcasecmp(buff, "start")) upcOpr++;
                break;

            case 'm':
                upcMem++;
                strncpy(buff, optarg, 4);
                buff[4] = 0;
                if (0 == strcasecmp(buff, "dtcm")) upcMem++;
                break;

            default: /* '?' */
                usage(argv[0]);
        }
    }

    if ((fd = open("/dev/upc0", O_RDWR)) < 0) {
        fprintf(stderr, "ERROR: %d opening %s\n", fd, "/dev/upc0");
        perror("open");
        return(fd);
    }

    if (upcOpr > 0) {
        if (2 == upcOpr) {
            printf("Starting UPC processors\n");
            retval = ioctl(fd, UPC_START_PROCESSORS);
        } else {
            printf("Stopping UPC processors\n");
            retval = ioctl(fd, UPC_STOP_PROCESSORS);
        }
        if (retval < 0) {
            fprintf(stderr, "ERROR: failed to stop/start UPC processors\n");
            perror("ioctl");
        }
    }

    if (upcMem > 0) {
        if (2 == upcMem) {
            printf("Selecting DTCM Memory access\n");
            retval = ioctl(fd, UPC_SELECT_DTCM);
        } else {
            printf("Selecting ITCM Memory access\n");
            retval = ioctl(fd, UPC_SELECT_ITCM);
        }
        if (retval < 0) {
            fprintf(stderr, "ERROR: failed UPC ITCM/DTCM memory selection\n");
            perror("ioctl");
        }
    }

    close(fd);
    return(retval);
}

