/*
 ******************************************************************************
 * Copyright (c) 2011 Marvell International, Ltd. All Rights Reserved
 *
 *                         Marvell Confidential
 ******************************************************************************
 *
 *
 *  Portions of this may contain copyrighted or confidential materials from
 *  Marvell and/or Marvell's suppliers. Copying and distribution of such
 *  materials for any other purpose except in conjunction with a Marvell
 *  Product, is expressly prohibited.
 *   
 *  DISCLAIMER OF WARRANTIES. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE
 *  LAW, THE SOURCE CODE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
 *  MARVELL AND ITS SUPPLIERS DISCLAIM ANY WARRANTY OR OBLIGATION TO PROVIDE
 *  SUPPORT, UPDATES OR BUG FIXES FOR THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTY AS TO THE ACCURACY, SUFFICIENCY OR SUITABILITY
 *  FOR ANY PURPOSES WHAT-SO-EVER OF THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTIES OR REPRE-SENTATIONS HEREUNDER, WHETHER
 *  EXPRESS OR IMPLIED, EITHER IN FACT OR BY OPERATION OF LAW, STATUTORY OR
 *  OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES, TERMS OR CONDITIONS
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, SATISFACTORY QUALITY,
 *  CORRESPONDENCE WITH DESCRIPTION, QUIET ENJOYMENT OR NON-INFRINGEMENT OF
 *  THIRD PARTY INTELLECTUAL PROPERTY RIGHTS.
 *  
 ******************************************************************************
*/

.set version_major, 0x00
.set version_minor, 0x00

.include "preboot.h"

/***********************************************************************
* reset vector table at address 0x0000_0000                            *
***********************************************************************/
.section .text

entry:
        b       ResetEntry
Undefined_ISR:
        b       Undefined_ISR
        b       SWI_ISR
Prefetch_ISR:
        b       Prefetch_ISR
Abort_ISR:
        b       Abort_ISR
Reserved_ISR:
        b       Reserved_ISR
        b       IRQ_ISR
        b       FIQ_ISR

/***********************************************************************
* Boot entry                                                           *
***********************************************************************/

ResetEntry:
        /* Init SVC Stack */
        ldr     r1, =SVCstack_IO
        mov     sp,r1

        /* Init IRQ Stack and Enable IRQ */
        mrs     r0,cpsr
        ldr     r1, =0xffffffe0
        and     r0,r0,r1
        orr     r0,r0,#0x12
        bic     r0,r0,#0x80
        msr     cpsr,r0
        ldr     r1, =IRQstack_IO
        mov     sp,r1

        /* Init FIQ Stack and Enable FIQ */
        mrs     r0,cpsr
        ldr     r1, =0xffffffe0
        and     r0,r0,r1
        orr     r0,r0,#0x11
        bic     r0,r0,#0x40
        msr     cpsr_c,r0
        ldr     r1, =FIQstack_IO
        mov     sp,r1

        /* Init User Stack and jump to main() */
        mrs     r0,cpsr
        ldr     r1, =0xffffffe0
        and     r0,r0,r1
        orr     r0,r0,#0x1f
        msr     cpsr_c,r0
        ldr     r1, =MainStack_IO
        mov     sp, r1
        bl      main

        /* Store Results */
        cmp     r0, #0
        ldr     r1, =0x900d0000
        orreq   r0, r1
        ldr     r1, =0x0bad0000
        orrne   r0, r1
        ldr     r1, =IO_Result
        str     r0, [r1]
        mcr     p15, 0, r0, c7, c0, 4

Should_not_get_here:
        b       Should_not_get_here

/***********************************************************************
* Interrupt service routines                                           *
***********************************************************************/

.include "preboot_isr.h"

