/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/

#ifndef _UPC_H_
#define _UPC_H_

#include "userspace/upc_ioctl.h"

#define UPC_DRIVER_NAME "marvell-upc"
#define MAX_NUM_DRAGONITES 2  // if a chip has more, increment here

struct upc_reg_config
{
    XENA_REGS_t value;
#define OP_IGNORE 0
#define OP_WRITE 1
#define OP_OR 2
#define OP_AND 3
    XENA_REGS_t operation;
};

#define ITCM_MEMORY 0
#define DTCM_MEMORY 1

// interface functions
// these functions write various upc registers
void upc_register_setup(struct upc_reg_config *upcconfig);
void upc_set_gp_status(int value);
uint32_t upc_get_gp_status(void);
int upc_write_mailbox(uint32_t mailboxnum, int value);
void upc_soft_reset(int value);

// these functions write/read instruction/data tightly coupled memory
int upc_write_dtcm(int dragonite_num, uint8_t *data, int length, int write_byte_offset);
int upc_read_dtcm(int dragonite_num, uint8_t *data, int length, int read_byte_offset);
int upc_write_itcm(int dragonite_num, uint8_t *data, int length, int write_byte_offset);
int upc_read_itcm(int dragonite_num, uint8_t *buffer, int length, int read_byte_offset);

// set the apb clock to run the upc cpu and io at a specific speed
void upc_set_apb_xcpu_clock(int divisor);
void upc_set_apb_io_clock(int divisor);

#endif // _UPC_H_
