/*
 * (C) Copyright 2003
 * Texas Instruments.
 * Kshitij Gupta <kshitij@ti.com>
 * Configuation settings for the TI OMAP Innovator board.
 *
 * (C) Copyright 2004
 * ARM Ltd.
 * Philippe Robin, <philippe.robin@arm.com>
 * Configuration for Versatile PB.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __CONFIG_H
#define __CONFIG_H

/*
 * High Level Configuration Options
 * (easy to change)
 */
#define CONFIG_ARMV7        1   /* This is an ARM V7 CPU core */
#define CONFIG_L2_OFF       1
#define CONFIG_OBELISK		1	/* in Obelisk emulation platform	*/
#define CONFIG_ARCH_OBELISK	1	/* Specifically, an Obelisk 	*/
#define CONFIG_SKIP_LOWLEVEL_INIT 1
#define CONFIG_SYS_THUMB_BUILD

#define CONFIG_BOOTARGS "console=ttyS0,115200n8"
#define CONFIG_CMDLINE_TAG
#define CONFIG_INITRD_TAG

#ifndef CONFIG_BOOTDELAY
#define CONFIG_BOOTDELAY 0
#define CONFIG_ZERO_BOOTDELAY_CHECK
#else
#define CONFIG_BOOTCOMMAND  "loop.l 0xf8000000 1"
#endif

#define CONFIG_SYS_MEMTEST_START	0x100000
#define CONFIG_SYS_MEMTEST_END		0x10000000
#define CONFIG_SYS_HZ			(1000)
#ifndef CONFIG_DRAM_INIT_ONLY
#define CONFIG_SYS_HUSH_PARSER
#define CONFIG_SYS_PROMPT_HUSH_PS2      "> "
#define CONFIG_CMD_SOURCE
#endif

#define CONFIG_BOARD_EARLY_INIT_F 1
#define CONFIG_BOARD_LATE_INIT	1

/*
 * If the icache is enabled and multiple items are loaded and
 * run at the same location, then the icache must be flushed
 * before each run.
 */
#define CONFIG_STANDALONE_ICACHE_FLUSH	1
#define CONFIG_SYS_CACHELINE_SIZE 32

/*
 * NS16550 Configuration
 */
#define CONFIG_SYS_NS16550_SERIAL
#define CONFIG_SYS_NS16550
#define CONFIG_SYS_NS16550_COM1 0xf8060000
#define CONFIG_SYS_NS16550_CLK  25000000
#define CONFIG_SYS_NS16550_REG_SIZE (-4)
#define CONFIG_CONS_INDEX 1
#define CONFIG_BAUDRATE			115200
#define CONFIG_SYS_BAUDRATE_TABLE	{ 38400, 115200 }

/*
 * Command line configuration.
 */
#define CONFIG_CMD_MEMORY
#define CONFIG_CMD_RUN

/*
 * Miscellaneous configurable options
 */
#define CONFIG_SYS_CBSIZE	512		/* Console I/O Buffer Size */
#define CONFIG_SYS_DEVICE_NULLDEV 1
#define CONFIG_SYS_CONSOLE_INFO_QUIET 1
/* Monitor Command Prompt	 */
# define CONFIG_SYS_PROMPT	"# "
/* Print Buffer Size */
#define CONFIG_SYS_PBSIZE	\
			(CONFIG_SYS_CBSIZE + sizeof(CONFIG_SYS_PROMPT) + 16)
#define CONFIG_SYS_MAXARGS	16		/* max number of command args */
#define CONFIG_SYS_BARGSIZE	CONFIG_SYS_CBSIZE /* Boot Argument Buffer Size */

#define CONFIG_SYS_LOAD_ADDR	0x8000	/* default load address */

#ifdef CONFIG_DRAM_INIT_ONLY
#define CONFIG_CMD_DFU 1

#define CONFIG_USB_MAX_CONTROLLER_COUNT 3

#define CONFIG_USB_GADGET_DUALSPEED 1
#define CONFIG_USB_GADGET 1
#define CONFIG_DFU_FUNCTION 1
#define CONFIG_DFU_RAM 1
#define CONFIG_USBDOWNLOAD_GADGET 1
#define CONFIG_USB_GADGET_VBUS_DRAW 2
#define CONFIG_MV_UDC 1
#define CONFIG_SYS_MV61X0_USBD_ADDR 0xF9040000
#define CONFIG_SYS_DFU_DATA_BUF_SIZE (512 * 1024)

#define CONFIG_USB_EHCI
#define CONFIG_USB_EHCI_MV61X0
#define CONFIG_CMD_USB
#define CONFIG_SYS_MV61X0_USBH_ADDR 0xF9041000
#define CONFIG_SYS_MV61X0_USBO_ADDR 0xF9048000

#define CONFIG_G_DNL_VENDOR_NUM 0x043d
#define CONFIG_G_DNL_PRODUCT_NUM 0x7755
#define CONFIG_G_DNL_MANUFACTURER "Stargate International, Inc."
#endif

#define CONFIG_CMD_CRAMFS
#define CONFIG_CRAMFS_CMDLINE
#define CONFIG_LXK_CRAMFS 1
#define CONFIG_SYS_MAX_FLASH_SECT 512
#define CONFIG_SYS_MAX_FLASH_BANKS 1

#define CONFIG_SHA256 1
#define CONFIG_RSAVERIFY 1
#define CONFIG_CMD_SHA256VERIFY 1

#ifndef CONFIG_DRAM_INIT_ONLY
#define CONFIG_MD5
#define CONFIG_CRASH_KERNEL_START_MB 128
#define CONFIG_CRASH_KERNEL_SIZE_MB 30
#endif

/*
 * SD setup
 */
#define CONFIG_MMC
#define CONFIG_GENERIC_MMC
#define CONFIG_MVSDH_MMC
#define CONFIG_SYS_MMC_BASE 0xf9080000

#ifndef CONFIG_DRAM_INIT_ONLY
#define CONFIG_CMD_MMC
#define CONFIG_CMD_EXT2
#define CONFIG_DOS_PARTITION
#define CONFIG_SSP_PARTITION
#endif

/*
 * I2c setup
 */
#define CONFIG_I2C_DW
#define CONFIG_DW_I2C_REG_BASE 0xf80a2000
#define CONFIG_HARD_I2C
#define CONFIG_SYS_I2C_SPEED 0
#define CONFIG_SYS_I2C_SLAVE 0
#define CONFIG_I2C_MULTI_BUS
#define CONFIG_SYS_MAX_I2C_BUS 4
#define CONFIG_I2C_DEFAULT_BUS 2

#if defined(CONFIG_CARD_01) \
    || defined(CONFIG_CARD_02) \
    || defined(CONFIG_CARD_03) \
    || defined(CONFIG_CARD_04) \
    || defined(CONFIG_CARD_05) \
    || defined(CONFIG_CARD_06) \
    || defined(CONFIG_CARD_07) \
    || defined(CONFIG_CARD_08) \
    || defined(CONFIG_CARD_12)
#define CONFIG_TPS40420_POWER
#define CONFIG_SYS_SPD_BUS_NUM 1
#elif defined(CONFIG_CARD_09) \
    || defined(CONFIG_CARD_10) \
    || defined(CONFIG_CARD_11)
#define CONFIG_TPS53819_POWER
#define CONFIG_SYS_SPD_BUS_NUM 1
#else
#define CONFIG_SYS_SPD_BUS_NUM 0
#endif

#define CONFIG_SYS_L2_PL310 1
#define CONFIG_SYS_PL310_BASE 0xf8fef000

/*-----------------------------------------------------------------------
 * Physical Memory Map
 */
#define CONFIG_SETUP_MEMORY_TAGS 1
#define CONFIG_NR_DRAM_BANKS	3	/* we have up to 3 banks of DRAM */
#define CONFIG_SYS_SDRAM_BASE 0

#define CONFIG_ENV_SIZE     (4 * 1024)

/*
 * Size of malloc() pool
 */
#define CONFIG_SYS_MALLOC_LEN		(CONFIG_ENV_SIZE + (16 * 1024 * 1024))
#define CONFIG_SYS_INIT_SP_SIZE     (2 * 1024)

/*
 * Memory Map
 * 0xf9280000 - 0xf92807ff  init stack
 * 0xf9280800               code
 */
#ifndef CONFIG_SYS_TEXT_BASE
#define CONFIG_SYS_TEXT_BASE 0xf9280800 /* (CONFIG_SYS_BASE_ADDR + CONFIG_SYS_INIT_SP_SIZE + CONFIG_SYS_MALLOC_LEN) */
#endif

#define CONFIG_SYS_BASE_ADDR (CONFIG_SYS_TEXT_BASE - 0x800)
#define CONFIG_SYS_INIT_SP_ADDR (CONFIG_SYS_BASE_ADDR + CONFIG_SYS_INIT_SP_SIZE - GENERATED_GBL_DATA_SIZE)

#define CONFIG_SYS_NO_FLASH
#define CONFIG_ENV_IS_NOWHERE	1

/* Give us the ability to enable dcache from app space */
#define CONFIG_CMD_CACHE
#define CONFIG_SYS_ARM_CACHE_WRITETHROUGH

/* Panel Configuration */
#ifndef CONFIG_DRAM_INIT_ONLY
#ifndef CONFIG_CARD_11
#define CONFIG_LCD
#define LCD_IS_NOT_STDIO
#define LCD_BPP LCD_COLOR16
#define CONFIG_SYS_STDIO_DEREGISTER
#define CONFIG_CMD_BMP
#define CONFIG_BMP_16BPP
#define CONFIG_SPLASH_SCREEN_ALIGN
#define CONFIG_LXK_PANEL
#define CONFIG_LXK_PANEL_VGA
#define CONFIG_LXK_PANEL_VGA_MV61FB
#define CONFIG_PANEL_I2C_BUS 2
#endif
#endif

/* UPC clock define changes based on card */
#define UPC_PROC_CLOCK_DIV      0x2
#define UPC_IO_CLOCK_DIV        0x7

#endif
