/*----------------------------------------------------------------------------
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * The software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the this software; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA.
 */
#include <stdarg.h>
#include <mv_mmp_panel.h>
#include <common.h>
#include "mv_mmp_eeprom_info.h"

/*
 * Contains the list of panels that are supported by the current hardware.
 * The actual panel type is detected at run-time.
 * The external clock requirement members may be updated by the probe functions.
 */
static const mv_mmp_panel_ctl_t panels[] = {
	{ mv62xx_disp_ref_panel_probe, mv62xx_disp_ref_panel_status,
		mv62xx_disp_ref_panel_buttons, mv62xx_disp_ref_panel_type,
		mv62xx_disp_ref_panel_subtype, mv62xx_disp_ref_panel_extclkreq},

#ifdef CONFIG_MV_MMP_PANEL_VGA

#ifdef CONFIG_MV_MMP_PANEL_SMPN
	{mv_mmp_panel_lb_vga_probe, mv_mmp_panel_vga_status, mv_mmp_panel_lb_vga_buttons, 
					mv_mmp_panel_lb_vga_type, mv_mmp_panel_lb_vga_subtype,
					mv_mmp_panel_lb_vga_extclkreq},
#endif
	{ mv_mmp_panel_vga_probe, mv_mmp_panel_vga_status, mv_mmp_panel_vga_buttons, 
					mv_mmp_panel_vga_type, mv_mmp_panel_vga_subtype,
					mv_mmp_panel_vga_extclkreq},
	{ mv_mmp_panel_vga_probe_gen2, mv_mmp_panel_vga_status, mv_mmp_panel_vga_buttons_gen2,
					mv_mmp_panel_vga_type_gen2, mv_mmp_panel_vga_subtype_gen2,
					mv_mmp_panel_vga_extclkreq},

#endif

#ifdef CONFIG_MV_MMP_PANEL_2X16V1
    {mv_mmp_panel_2x16v1_probe, mv_mmp_panel_2x16v1_status, mv_mmp_panel_2x16v1_buttons, 
    					mv_mmp_panel_2x16v1_type, NULL, NULL},
#endif
};

static int probed __attribute__ ((section (".data"))) = 0;
static const mv_mmp_panel_ctl_t *panel __attribute__ ((section (".data"))) = NULL;

static const mv_mmp_panel_ctl_t *mv_mmp_get_panel(void)
{
	int i;

	if (probed)
		return panel;
	probed = 1;

	for (i = 0; i < ARRAY_SIZE(panels); i++) {
		if (panels[i].probe() == 0) {
			panel = &panels[i];
			break;
		}
	}
	return panel;
}

void mv_mmp_panel_status(int msg, ...)
{
	va_list args;
	const mv_mmp_panel_ctl_t *panel = mv_mmp_get_panel();

	if (!panel || !panel->status)
		return;

	va_start(args, msg);
	panel->status(msg, args);
	va_end(args);
}

unsigned long long mv_mmp_panel_get_buttons(void)
{
	const mv_mmp_panel_ctl_t *panel = mv_mmp_get_panel();

	if (!panel || !panel->buttons)
		return 0;

	return panel->buttons();
}

int mv_mmp_panel_get_type(void)
{
	const mv_mmp_panel_ctl_t *panel = mv_mmp_get_panel();

	if (!panel || !panel->type)
		return MV_MMP_PANEL_TYPE_INVALID;
	
	return panel->type();
}

char *mv_mmp_panel_get_subtype(void)
{
	const mv_mmp_panel_ctl_t *panel = mv_mmp_get_panel();

	if (!panel || !panel->subtype)
		return NULL;
	
	return panel->subtype();
}

int mv_mmp_panel_init(void)
{
	return mv_mmp_get_panel() != NULL;
}

mv_mmp_panel_ext_clk_requirement_t mv_mmp_panel_clk_required(void)
{
	const mv_mmp_panel_ctl_t *panel = mv_mmp_get_panel();

	if (!panel || !panel->ext_clk_required)
		return MV_MMP_PANEL_EXT_CLK_USED;

	return panel->ext_clk_required();
}
