#include <common.h>
#include <stdarg.h>
#include <i2c.h>
#include <asm/io.h>
#include <lcd.h>
#include <lxk_panel.h>
#include <stdio_dev.h>
#include <lcd.h>
#include <lxk_panel.h>
#include <video_font.h>
#include "lxk_eeprom_info.h"
#include "atmelpnl_switch.h"
#include "lxk_panel_common.h"
#include "zforce.h"

#define I2CADDR_PANEL_TI (0x54 >> 1)
#define I2CADDR_PANEL_SCALER (0xc8 >> 1)

#define ENGINELESS (NM_3 | NM_5)

static vga_panel_data vpd = {
	.subtype = NULL,
	.backlight_enable = NULL,
	.vga_type = (unsigned char)LXK_PANEL_TYPE_INVALID,
	.hscalar = 0,
	.vscalar = 0,
	.backlight_duty_max = 0,
	.backlight_duty_init = 0,
	.backlight_select = 0,
	.lvds = LVDS_UNKNOWN,
	.bit_depth = 0,
	.gamma = NULL,
};

#ifndef CONFIG_PANEL_I2C_BUS
#error CONFIG_PANEL_I2C_BUS must be defined in board config
#endif
static lxk_panel_i2c_info_t i2c_info = {
	.bus_num = -1,
	.dev_addr = I2CADDR_PANEL_TI,
	.read_retries = 0,
	.write_retries = 0,
	.delay = 1000,
	.protocol = PROTOCOL_GEN2,
};

#ifdef CONFIG_LXK_PANEL_VGA_PEGMATITE
static lxk_panel_i2c_info_t scalar_i2c_info = {
	.bus_num = -1,
	.dev_addr = I2CADDR_PANEL_SCALER,
	.read_retries = 0,
	.write_retries = 0,
	.delay = 1000,
	.protocol = PROTOCOL_RAW,
};
#endif

static unsigned char hw_ver = 0;
static unsigned char panel_id = 0;
static unsigned char fwmajor = 0;
static unsigned char fwminor = 0;

/*-----------------------------------------------------------------------------
 *
 * Name:        backlightEnable
 *
 * Description: turn backlight off or on using current duty cycle
 *
 * Input:       None
 *
 * Output:      None
 *
 * Notes:
 *---------------------------------------------------------------------------*/
static int backlightEnable(int enable) {
  return 0;
}

/*-----------------------------------------------------------------------------
 *
 * Name:        lxk_panel_vga_extclkreq
 *
 * Description: Report whether the display requires external free-running clock.
 *
 * Input:       None
 *
 * Output:
 *
 * Notes:       Clock may still be required internally by lcd block even if not
 *              used externally.
 *---------------------------------------------------------------------------*/

unsigned long long lxk_panel_vga_buttons_gen2(void)
{
   uint32_t buttons;
   const key_map_t *map = lxk_common_key_map;

   buttons = lxk_panel_read_buttons(&i2c_info, map, 0, 0);

   return lxk_panel_buttons_alias(buttons);
}

void lxk_panel_disable_keyscan_gen2(void)
{
    int rc;
    int cmd;
    unsigned char data;
    unsigned char msg[2];

    cmd = MCU_SW_ENAB_REG;
    rc = lxk_panel_i2c_read(&i2c_info, cmd, 1, &data, 1);
    if(rc) {
	LXKPANELDBG("%s:%d: Unable to read MCU_SW_ENAB_REG, rc: %d\n", __func__, __LINE__, rc);
    }
    msg[0] = cmd;
    msg[1] = data | UIBC_SET_SW_OFF;
    rc = lxk_panel_i2c_write(&i2c_info, msg, sizeof(msg));
    if(rc) {
	LXKPANELDBG("%s:%d: Unable to write MCU_SW_ENAB_REG, rc: %d\n", __func__, __LINE__, rc);
    }
}

int lxk_panel_wait_irq_gen2(uint8_t irqmask, long timeout_ms) {
  int rc;
  int timeout = timeout_ms;
  unsigned char cmd;
  unsigned char data;

  while(timeout--)
  {
      /* Poll UIBC IRQ_STAT for requested irq */
      cmd = UIBC_IRQ_STATUS_REG;
      rc = lxk_panel_i2c_read(&i2c_info, cmd, 1, &data, 1);
      if(rc)
      {
	  LXKPANELDBG("%s:%d: Unable to read UIBC_IRQ_STATUS_REG, rc: %d\n", __func__, __LINE__, rc);
	  continue;
      }
      //LXKPANELDBG("DEBUG: DATA = 0x%x, timeout = %d\n", data, timeout);
      if(data & irqmask)
         return 0;
      if(timeout)
         udelay(1000);
   }
   printf("%s:%d: Timeout waiting for requested UIBC_IRQ flags 0x%02x\n",
                                            __func__, __LINE__, irqmask);

   return -1;
}

int lxk_panel_vga_probe_gen2(void)
{
  char porKeys[11];
  int rc;
  unsigned char cmd;
  unsigned char data;
  vga_panel_info *vpi = (vga_panel_info *)&vpd.vpi;
  lxk_gen2_display_info_t *dynamic_lcd;

  LXKPANELDBG("%s:%d\n", __func__, __LINE__);

  dynamic_lcd = lxk_gen2_eeprom_probe(&vpd);

  rc = lxk_panel_i2c_probe(&i2c_info);
  if(rc) {
     LXKPANELDBG("%s:%d: no response\n", __func__, __LINE__);
     return 1;
  }

  vpi->panel_type = PANEL_VGA_GEN2;

  /* Read FW VERSION from UIBC */
  cmd = UIBC_FW_VERSION_MAJ;
  rc = lxk_panel_i2c_read(&i2c_info, cmd, 1, &data, 1);
  if(rc) {
     LXKPANELDBG("%s:%d: Unable to read UIBC_FW_VERSION_MAJ, rc: %d\n", __func__, __LINE__, rc);
     return 1;
  }
  fwmajor = data;
  cmd = UIBC_FW_VERSION_MIN;
  rc = lxk_panel_i2c_read(&i2c_info, cmd, 1, &data, 1);
  if(rc) {
     LXKPANELDBG("%s:%d: Unable to read UIBC_FW_VERSION_MIN, rc: %d\n", __func__, __LINE__, rc);
     return 1;
  }
  fwminor = data;

  vpi->version_major = fwmajor;
  vpi->version_minor = fwminor;

  /* Read PANEL ID and VERSION from UIBC */
  cmd = UIBC_PANEL_ID;
  rc = lxk_panel_i2c_read(&i2c_info, cmd, 1, &data, 1);
  if(rc) {
     LXKPANELDBG("%s:%d: Unable to read UIBC_PANEL_ID, rc: %d\n", __func__, __LINE__, rc);
     return 1;
  }
  panel_id = data;
  cmd = UIBC_PANEL_VERSION;
  rc = lxk_panel_i2c_read(&i2c_info, cmd, 1, &data, 1);
  if(rc) {
     LXKPANELDBG("%s:%d: Unable to read UIBC_PANEL_VERSION, rc: %d\n", __func__, __LINE__, rc);
     return 1;
  }
  hw_ver = data;

  
  rc = zf_probe(&vpd, dynamic_lcd);

  if(rc) {
      printf("%s:%d zForce UIVC failed or not found.\n", __func__, __LINE__);

      /*
       * For now, report a valid panel just to allow booting to continue.
       * Remove this when hw is stable.
       */
#if 1
      vpd.xres = 480;
      vpd.yres = 272;
      vpd.vga_type = LXK_PANEL_TYPE_480X272_NON_SEQ;
#else
      vpd.xres = 800;
      vpd.yres = 480;
      vpd.vga_type = LXK_PANEL_TYPE_800X480;
#endif
      vpd.sequential = 0;
  }

#ifdef CONFIG_LXK_PANEL_VGA_PEGMATITE
  rc = lxk_panel_i2c_probe(&scalar_i2c_info);
  if(!rc) {
     /* Found external downscale hw. Need to upscale output. */
     vpd.hscalar = 3;
     printf("%s:%d: panel output hscalar hw found, set hscalar=%d\n", __func__, __LINE__, vpd.hscalar);
  }
#endif

  printf("%s:%d: panel uicc type %d, hw vers %d, panel id %d, eeprom v%d.%d\n", __func__, __LINE__,
					vpi->panel_type, hw_ver, panel_id,
					vpi->version_major, vpi->version_minor);

  if((vpi->panel_type == PANEL_NOT_DETECTED) || (vpi->panel_type >= PANEL_NOT_RECOGNIZED)) {
     return 1;
  }

  /*
   * Initialize the panel
   */
  {
    /* Read and set PORKEYs */
    snprintf(porKeys, sizeof(porKeys), "0x%08x", (uint32_t)lxk_panel_vga_buttons_gen2());
    setenv("PORKEYS", porKeys);
    /* Disable keyscan now that porkeys are set */
    lxk_panel_disable_keyscan_gen2();
  }

  /* update the defaults to real values for common/lcd.c*/
  panel_info.vl_row = vpd.yres;
  panel_info.vl_col = vpd.xres;

  /* hardware info for lxk_vga_mv61fb */
  panel_info.priv = &vpd;

  lcd_line_length = (panel_info.vl_col * NBITS (panel_info.vl_bpix)) / 8;

  vpd.backlight_enable = backlightEnable;

  /*
   * Returning without freeing dynamic_lcd because
   * dynamic_lcd->dt will be used by ft_lcd_setup().
   */
  return 0;
}

/* void lxk_panel_vga_status(LXK_PANEL_STATUS msg, va_list ap) */
/* Get it from lxk_vga.c */
int lxk_panel_vga_type_gen2(void)
{
	return (int)vpd.vga_type;
}

char *lxk_panel_vga_subtype_gen2(void)
{
	/*
	 * As a placeholder, just keep it simple.
	 * TODO: Build the subtype string in the probe function switch
	 * to handle the display_type field.
	 */
	return "";
}
