#ifndef _LXK_PANEL_COMMON_H_
#define _LXK_PANEL_COMMON_H_

#include <video/display_timing.h>
#include "lxk_eeprom_info.h"
#include "lxk_gen2_eeprom.h"

#define MCU_SW_ENAB_REG                 0x01    /* Switch Enable Register; SW_ENAB; R/W; 0100_000 */
#define 	MCU_SW_ENAB_ON		(1 << 6)	/* Enable key scanning (no effect in BB/LB api v1 */
#define MCU_ALT_FUNC_CONFIG_REG         0x02    /* Alternate Function Enable Register; ALT_FUNC_CONFIG; R/W; 0000_0000 */
#define MCU_KEY_RATE_REG                0x03    /* Key Scan Rate Prescale Register; KEY_RATE; R/W; 0001_0001 */
#define MCU_SPI_CLK_CONFIG_REG          0x04    /* SPI Clock Configuration Register; SPI_CLK_CONFIG; R/W; 0000_0100 */
#define MCU_SPI_SR_REG                  0x05    /* SPI Status Register; SPI_SR; R/W; 0000_1100 */
#define PWM_CONFIG                      0x06
#define PWM_ICR1L                       0x07
#define PWM_OCR1AL                      0x08
#define MCU_GPIOA_OER_REG               0x09    /* GPIOA Output Enable Register; GPIOA_OER; R/W; 1111_1111 */
#define MCU_GPIOB_OER_REG               0x0A    /* GPIOB Output Enable Register; GPIOB_OER; R/W; 1111_1111 */
#define MCU_GPIOC_OER_REG               0x0B    /* GPIOC Output Enable Register; GPIOC_OER; R/W; 1111_1111 */
#define MCU_GPIOD_OER_REG               0x0C    /* GPIOD Output Enable Register; GPIOD_OER; R/W; 1111_1111 */
#define MCU_GPIOA_OUT_REG               0x0D    /* GPIOA Output Data Status Register; GPIOA_OUT; R/W; 0000_0000 */
#define MCU_GPIOB_OUT_REG               0x0E    /* GPIOB Output Data Status Register; GPIOB_OUT; R/W; 0000_0000 */
#define MCU_GPIOC_OUT_REG               0x0F    /* GPIOC Output Data Status Register; GPIOC_OUT; R/W; 0000_0000 */
#define MCU_GPIOD_OUT_REG               0x10    /* GPIOD Output Data Status Register; GPIOD_OUT; R/W; 0000_0000 */
#define MCU_GPIOA_INDATA_REG            0x11    /* GPIOA Input Data Register; GPIOA_INDATA; R; 0000_0000 */
#define MCU_GPIOB_INDATA_REG            0x12    /* GPIOB Input Data Register; GPIOB_INDATA; R; 0000_0000 */
#define MCU_GPIOC_INDATA_REG            0x13    /* GPIOC Input Data Register; GPIOC_INDATA; R; 0000_0000 */
#define MCU_GPIOD_INDATA_REG            0x14    /* GPIOD Input Data Register; GPIOD_INDATA; R; 0000_0000 */
#define MCU_GPIOA_ISR_REG               0x15    /* GPIOA Interrupt Status Register; GPIOA_ISR; R; 0000_0000 */
#define MCU_GPIOB_ISR_REG               0x16    /* GPIOB Interrupt Status Register; GPIOB_ISR; R; 0000_0000 */
#define MCU_GPIOC_ISR_REG               0x17    /* GPIOC Interrupt Status Register; GPIOC_ISR; R; 0000_0000 */
#define MCU_GPIOD_ISR_REG               0x18    /* GPIOD Interrupt Status Register; GPIOD_ISR; R; 0000_0000 */
#define MCU_GPIOA_IRQ_MASK_REG          0x19    /* GPIOA Interrupt Mask Register; GPIOA_IRQ_MASK; R/W; 0000_0000 */
#define MCU_GPIOB_IRQ_MASK_REG          0x1A    /* GPIOB Interrupt Mask Register; GPIOB_IRQ_MASK; R/W; 0000_0000 */
#define MCU_GPIOC_IRQ_MASK_REG          0x1B    /* GPIOC Interrupt Mask Register; GPIOC_IRQ_MASK; R/W; 0000_0000 */
#define MCU_GPIOD_IRQ_MASK_REG          0x1C    /* GPIOD Interrupt Mask Register; GPIOD_IRQ_MASK; R/W; 0000_0000 */
#define MCU_IRQ_STATUS_REG              0x1D    /* Interrupt Status Register; IRQ_STATUS; R; 0000_0000 */
#define MCU_IRQ_MASK_REG                0x1E    /* Interrupt Mask Register; IRQ_MASK; R/W; 0000_0000 */
#define 	MCU_IRQ_MASK_KEYSCAN	(1 << 0)	/* Enable key scan irq */
#define MCU_ADMUX_REG                   0x1F    /* ADC Multiplexer Selection Register; ADMUX; R/W; 0000_0000 */
#define MCU_ADCSRA_REG                  0x20    /* ADC Control and Status Register A; ADCSRA; R/W; 0000_0000 */
#define MCU_ADCSRB_REG                  0x21    /* ADC Control and Status Register B; ADCSRB; R/W; 0000_0000 */
#define MCU_DiDRO                       0x22
#define MCU_SPI_ZERO_MSB                0x23    /* SPI Zero Data Command LSB count */
#define MCU_SPI_ZERO_LSB                0x24    /* SPI Zero Data Command MSB count */
#define MCU_LED_CONTROL                 0x25    /* Led control Register */
#define MCU_CAVE_CONTROL                0x26    /* Cave light control register */

#define MCU_KEY_FIFO_REG                0x81    /* Key Scan FIFO; KEY_FIFO; R; 0000_0000 */
#define MCU_SPI_TDR_REG                 0x82    /* SPI Transmit Data Register; SPI_TDR; R/W; 0000_0000 */
#define MCU_SPI_RDR_REG                 0x83    /* SPI Receive Data Register; SPI_RDR; R; 0000_0000 */
#define MCU_ADCL_REG                    0x84    /* ADC Data Low Register; ADCL; R; 0000_0000 */
#define MCU_ADCH_REG                    0x85    /* ADC Data High Register; ADCH; R; 0000_0000 */
#define MCU_LOAD_PAGEB_CMD              0x86    /* Load Page Buffer Command; LOAD_PAGEB_CMD; W; N/A */
#define MCU_EEPROM_ADDR_REG             0x87    /* EEPROM Address Register; EEPROM_AR; R/W; 0000_0000 */
#define MCU_EEPROM_DATA_REG             0x88    /* EEPROM Data Register; EEPROM_DR; R/W; 0000_0000 */
#define MCU_GET_FWREV                   0x89
#define MCU_EEPROM_ADDR_REG             0x87
#define MCU_EEPROM_DATA_REG             0x88

#define MCU_RESET_CMD                   0x99    /* Reset Command; RESET_CMD; W; N/A */

#define MCU_PAGE_REPR_CMD               0xFC    /* Page Reprogram Command; PAGE_REPR_CMD; W; N/A */

#define PIO(x) ((x) & 0x07)
#define PIO_BLOCK(x) (((x) & 0x18) >> 3)
#define PIO_ENABLED(x) ((x) & (1 << 5))

#define OER_OUTPUT 0
#define OER_INPUT 1
#define OER_DEFAULT OER_INPUT

#define SET_BIT(gpio, shift, value) \
    gpio = (((gpio) & ~(1 << (shift))) | ((value) << (shift)))

/* definitions for PROTOCOL_GEN2 only */
#define UIBC_READ (1 << 7)
#define UIBC_WRITE (0)
#define UIBC_DATA_SIZE_MASK (0x3f)

/* UIBC Command Definitions */
#define UIBC_IRQ_STATUS_REG 0x1D
#define UIBC_KEY_SCAN_FIFO  0x32
#define UIBC_PANEL_ID	    0xF0
#define UIBC_PANEL_VERSION  0xF1
#define UIBC_FW_VERSION_MAJ 0xFE
#define UIBC_FW_VERSION_MIN 0xFF

/* UIBC Bit Definitions */
#define UIBC_CLEAR_SW_OFF   ~(1 << 6)
#define UIBC_SET_SW_OFF   (1 << 6)
#define UIBC_UIVC_IRQ   (1 << 2)

typedef struct {
    uint8_t oer_reg;
    uint8_t out_reg;
} gpio_map_t;

typedef struct {
    unsigned int logic_btn;
    unsigned int hw_btn;
} key_map_t;

typedef enum {
    PRIMARY_RESET_OUT,
    SECONDARY_RESET_OUT,
} reset_type_t;

typedef enum {
    PROTOCOL_GEN1,
    PROTOCOL_GEN2,
    PROTOCOL_ZFORCE,
    PROTOCOL_RAW,
    PROTOCOL_EEPROM
 } protocol_gen_t;

#define BACKLIGHT_DUTY_MAX_DEFAULT 255
#define BACKLIGHT_DUTY_FAILSAFE 0x01

typedef struct {
    u8 red[256];
    u8 green[256];
    u8 blue[256];
} gamma_table_t;

/*
 * The hscaler and vscaler fields are used to handle hardware requiring scaled output timing.
 * Positive values will be treated as multipliers (upscale). Negative values will be
 * treated as dividers (downscale). Zero is ignored.
 */
typedef struct {
    vga_panel_info vpi;
    const struct display_timing *dt;
    int vga_type;
    int xres;
    int yres;
    int sequential;
    int hscalar;
    int vscalar;
    char *subtype;
    int bit_depth;
    lvds_bit_mapping_t lvds;
    int backlight_duty_max;
    int backlight_duty_init;
    int backlight_select;
    int (*backlight_enable)(int enable);
    gamma_table_t *gamma;
} vga_panel_data;

typedef struct {
    vga_panel_info vpi;
    int xres;
    int yres;
    int smpn_type;
    void *smpn_info;
    int use_te;
    int use_smpnclk;
    void *reg_base;
    const char *subtype;
    int backlight_duty_max;
    int backlight_duty_default;
    int backlight_select;
    int (*backlight_enable)(int enable);
    gamma_table_t *gamma;
} lb_vga_panel_data;

/* Not sure if these declarations belong here or in lxk_panel.h */
typedef struct {
    unsigned int bus_num;
    unsigned char dev_addr;
    int read_retries;
    int write_retries;
    int delay;     /* uSecs */
    int protocol;
} lxk_panel_i2c_info_t;

int lxk_panel_i2c_write(lxk_panel_i2c_info_t *i2c_info,
			unsigned char *msg, int msglen);
int lxk_panel_i2c_read(lxk_panel_i2c_info_t *i2c_info,
			unsigned int addr, int addrlen,
			unsigned char *rcv, int rcvlen);
int lxk_panel_read_buttons(lxk_panel_i2c_info_t *i2c_info, const key_map_t *map, unsigned int buttons, int toggle);
unsigned int lxk_panel_buttons_alias(unsigned int buttons);
int lxk_panel_vga_ctrl(vga_panel_info *vpi, reset_type_t which, int value);
int lxk_panel_keyscan_init(lxk_panel_i2c_info_t *i2c_info, unsigned char row, unsigned char col);
int lxk_panel_i2c_probe(lxk_panel_i2c_info_t *i2c_info);
int lxk_panel_disp_ctrl(lxk_panel_i2c_info_t *i2c_info, vga_panel_info *vpi, reset_type_t which, int value);
int lxk_panel_reset_mcu(lxk_panel_i2c_info_t *i2c_info);

int lxk_panel_wait_irq_gen2(uint8_t irqmask, long timeout_ms);

int lxk_vga_translate(vga_panel_data *vpd, const lxk_gen2_display_info_t *display);

lxk_gen2_display_info_t *lxk_gen2_eeprom_probe(vga_panel_data *vpd);

extern const key_map_t lxk_common_key_map[];
extern const gpio_map_t lxk_common_gpio_map[];
extern const lxk_gen2_display_info_t lxk_display_info[];
extern int lxk_display_info_count;
#endif /* _LXK_PANEL_COMMON_H_ */
