/*
 * LITTLE/BIG BROTHER EEPROM DEFINITION
 *
 * LB = 64 bytes
 * BB = 512 bytes
 *
 * WARNINGS:
 * - Please update MAJ_VERS/MIN_VERS in the uicc Makefile when modifying
 *   this structure.
 * - This file must be kept synchronized with uboot.
 *   Copy to <uboot>/drivers/video.
 */

#define LXK_EEPROM_CHECKSUM_MAGIC 0x0bad

typedef struct {
   unsigned char
/* byte   0 -- bit 7:0 -- structure version     */ version_major,
/* byte   1 -- bit 7:0 --                       */ version_minor,
/* byte   2 -- bit 7:0 -- key pad size          */ keyscan_rows,
/* byte   3 -- bit 7:0 --                       */ keyscan_cols,
/* byte   4 -- bit 7:0 -- resolution            */ xres_msb,
/* byte   5 -- bit 7:0 --                       */ xres_lsb,
/* byte   6 -- bit 7:0 --                       */ yres_msb,
/* byte   7 -- bit 7:0 --                       */ yres_lsb,
/* byte   8 -- bit 7:0 -- timing                */ hfp,
/* byte   9 -- bit 7:0 --                       */ hpw,
/* byte  10 -- bit 7:0 --                       */ hbp,
/* byte  11 -- bit 7:0 --                       */ vfp,
/* byte  12 -- bit 7:0 --                       */ vpw,
/* byte  13 -- bit 7:0 --                       */ vbp,
/* byte  14 -- bit   7 -- uc touch support      */ flags1,
/*          -- bit   6 -- RESERVED              */
/*          -- bit 5:4 -- pixel depth           */
/*          -- bit   3 -- RB swap               */
/*          -- bit   2 -- inverse clock         */
/*          -- bit   1 -- inverse sync          */
/*          -- bit   0 -- RGB sequence          */
/* byte  15 -- bit   7 -- 0 = BB, 1 = LB        */ panel_type,
/*          -- bit 6:0 -- panel enumeration     */
/* byte  16 -- bit 7:0 --                       */ xmin_msb,
/* byte  17 -- bit 7:0 --                       */ xmin_lsb,
/* byte  18 -- bit 7:0 --                       */ ymin_msb,
/* byte  19 -- bit 7:0 --                       */ ymin_lsb,
/* byte  20 -- bit 7:0 --                       */ zmin_msb,
/* byte  21 -- bit 7:0 --                       */ zmin_lsb,
/* byte  22 -- bit 7:0 --                       */ xmax_msb,
/* byte  23 -- bit 7:0 --                       */ xmax_lsb,
/* byte  24 -- bit 7:0 --                       */ ymax_msb,
/* byte  25 -- bit 7:0 --                       */ ymax_lsb,
/* byte  26 -- bit 7:0 --                       */ zmax_msb,
/* byte  27 -- bit 7:0 --                       */ zmax_lsb,
/* byte  28 -- bit 7:0 --                       */ xdrive,
/* byte  29 -- bit 7:0 --                       */ ydrive,
/* byte  30 -- bit 7:0 --                       */ zdrive,
/* byte  31 -- bit 7:0 -- RESERVED              */ reserved,
/* byte  32 -- bit 7:0 --                       */ mirror_size,
/* byte  33 -- bit 7:0 --                       */ lvds_type,
/* byte  34 -- bit   7 -- invert x              */ flags2,
/*          -- bit   6 -- invert y              */
/*          -- bit   5 -- cavelight support     */
/*          -- bit 4:3 -- RST-OUT-N PIO block   */
/*          -- bit 2:0 -- RST-OUT-N PIO         */
/* byte  35 -- bit 7:4 -- x                     */ adc_mux,
/*          -- bit 3:0 -- y                     */
/* byte  36 -- bit 7:0 --                       */ backlight_pwm_value,
/* byte  37 -- bit 7:6 -- RESERVED              */ led_info_green,
/*          -- bit   5 -- drive value           */
/*          -- bit 4:3 -- PIO block             */
/*          -- bit 2:0 -- PIO                   */
/* byte  38 -- bit 7:6 -- RESERVED              */ led_info_red,
/*          -- bit   5 -- drive value           */
/*          -- bit 4:3 -- PIO block             */
/*          -- bit 2:0 -- PIO                   */
/* byte  39 -- bit 7:0                          */ cavelight_bright,
/* byte  40 -- bit 7:0                          */ cavelight_dim,
/* byte  41 -- bit   7 -- 0 = dumb, 1 = smart   */ display_type,
/*          -- bit 6:0 -- display enumeration   */
/* byte  42 -- bit   7 -- RESERVED              */ flags3,
/*          -- bit   6 -- shutdown_enb          */
/*          -- bit   5 -- RST-2 enable          */
/*          -- bit 4:3 -- RST-2 PIO block       */
/*          -- bit 2:0 -- RST-2 PIO             */
/* byte  43 -- bit 7:4 -- haptics type          */ flags4,
/*          -- bit 3:0 -- backlight type        */
/* byte  44 -- bit 7:0 --                       */ touch_smooth_x,
/* byte  45 -- bit 7:0 --                       */ touch_smooth_y,
/* byte  46 -- bit 7:0 --                       */ touch_smooth_z,
/* byte  47 -- bit 7:6 -- RESERVED              */ fpga_rsthw_n,
/*          -- bit   5 -- enable                */
/*          -- bit 4:3 -- PIO block             */
/*          -- bit 2:0 -- PIO                   */
/* byte  48 -- bit 7:6 -- RESERVED              */ fpga_rstsw_n,
/*          -- bit   5 -- enable                */
/*          -- bit 4:3 -- PIO block             */
/*          -- bit 2:0 -- PIO                   */
/* byte  49 -- bit 7:6 -- RESERVED              */ fpga_strb,
/*          -- bit   5 -- enable                */
/*          -- bit 4:3 -- PIO block             */
/*          -- bit 2:0 -- PIO                   */
/* byte  50 -- bit 7:4 -- RESERVED              */ esd_flags,
/*          -- bit 3:0 -- method                */
/* byte  51 -- bit 7:4 --                       */ apa_type,
/* byte  52 -- bit 7:4 --                       */ apa_rr,
/* byte  53 -- bit 7:4 --                       */ apa_ev,

/************************************************/
/* bytes 54-60         -- RESERVED              */ reserved1[60 - 54 + 1],
/* 16 bit sum of checked data (currently 0:60)  */
/* and checksum_diff shall equal                */
/* LXK_EEPROM_CHECKSUM_MAGIC.                   */
/* byte  61 -- bit 7:0 -- checksum_diff         */ check_msb,
/* byte  62 -- bit 7:0 --                       */ check_lsb;
/************************************************/

/* byte  63 -- bit 7:0 -- LB hardware version   */
/* byte 509 -- bit 7:0 -- BB hardware version   */
/* byte 511 -- bit 7:0 -- BB bootloader         */
} panel_info_t;
