#include <common.h>
#include <asm/arch/regAddrs.h>
#include <asm/arch/efuse_regstructs.h>
#include <asm/arch/efuse_regmasks.h>
#include <tps40420.h>
#include <tps53819.h>


uint32_t read_apm_setting(void) {
    struct EFUSE_REGS_s *efuse = (struct EFUSE_REGS_s *)APB_EFUSE_BASE;

    /* Populate the efuse status registers */
    efuse->AUTO_Control = 1;
    while (efuse->TOP_Status & EFUSE_TOP_STATUS_BUSY_MASK);

    return ((efuse->EfuseStatus95to64_Bank0 >> 22) & 0x7);
}


void config_regulator(char *asic_rev, int dropoff, int bus_num, int addr) {
    int (*regulator_init)(int, uint8_t) = NULL;
    int (*regulator_set_vtrim)(int, uint8_t, int32_t) = NULL;

#if defined(CONFIG_TPS40420_POWER)
    regulator_init = tps40420_init;
    regulator_set_vtrim = tps40420_set_vtrim;
#elif defined(CONFIG_TPS53819_POWER)
    regulator_init = tps53819_init;
    regulator_set_vtrim = tps53819_set_vtrim;
#endif

    if (asic_rev[0] > 'B') {
        /* Adjust the trim power at the regulator */
        int trim = dropoff;
        uint32_t apm_setting = read_apm_setting( );

        if (regulator_init)
            regulator_init(bus_num, addr);

        if (apm_setting & 0x4) {
            trim += ((apm_setting & 0x3) * 25);
            if (!(apm_setting & 0x2) &&
                (asic_rev[0] == 'C') && (asic_rev[1] == '0'))
                trim += 10;
        }
        else
            trim -= ((apm_setting & 0x3) * 25);

        if (regulator_set_vtrim)
            regulator_set_vtrim(bus_num, addr, trim);
    }
}
