#include <common.h>
#include <asm/arch/gpio.h>
#include <asm/arch/regAddrs.h>
#include <asm/arch/apb_config_regmasks.h>
#include <asm/arch/apb_config_regstructs.h>
#include <asm/arch/LSCAN_regmasks.h>
#include <asm/arch/LSCAN_regstructs.h>
#include <asm/arch/GPIO_regstructs.h>
#include <asm/arch/GPIO_regmasks.h>
#include <asm/arch/efuse_regstructs.h>
#include <asm/arch/efuse_regmasks.h>
#include <asm/arch/MC_regstructs.h>

#include "card.h"
#include "ddr.h"
#include "regulator.h"


static const uint8_t card11GpioSetup[] = {
    S(1, 0, 0), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), // Block A  0 - 15
    S(0, 0, 1), S(1, 0, 0), S(0, 0, 1), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0),
    S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), // Block A 16 - 31
    S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0),

    S(0, 0, 2), S(0, 0, 2), S(0, 0, 2), S(0, 0, 2), S(0, 0, 2), S(0, 0, 2), S(1, 0, 0), S(1, 0, 0), // Block B  0 - 15
    S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0),
    S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), // Block B 16 - 31
    S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0),

    S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 2), S(0, 0, 2), // Block C  0 - 15
    S(0, 0, 2), S(0, 0, 2), S(0, 0, 0), S(1, 0, 0), S(1, 0, 0), S(0, 0, 8), S(0, 0, 8), S(1, 0, 0),
    S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(0, 0, 0), S(0, 0, 0), S(0, 0, 0), S(0, 0, 0), // Block C 16 - 31
    S(0, 0, 0), S(0, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0),

    S(0, 0, 2), S(0, 0, 2), S(0, 0, 2), S(0, 0, 2), S(0, 0, 2), S(0, 0, 2), S(0, 0, 1), S(0, 0, 1), // Block D  0 - 15
    S(0, 0, 5), S(0, 0, 5), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1),
    S(0, 0, 4), S(0, 0, 4), S(0, 0, 2), S(0, 0, 2), S(0, 0, 2), S(0, 0, 2), S(0, 0, 2), S(0, 0, 2), // Block D 16 - 31
    S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0),

    S(0, 0, 1), S(1, 0, 0), S(1, 0, 0), S(0, 0, 0), S(0, 0, 1), S(0, 0, 1), S(0, 0, 0), S(0, 0, 0), // Block E  0 - 15
    S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(1, 0, 0), S(0, 0, 1),
    S(0, 0, 1), S(1, 0, 0), S(0, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(0, 0, 1), // Block E 16 - 31
    S(1, 0, 0), S(0, 0, 0), S(0, 0, 1), S(1, 0, 0), S(0, 0, 0), S(1, 0, 0), S(0, 0, 1), S(0, 0, 8),

    S(0, 0, 0), S(0, 0, 0), S(0, 0, 1), S(0, 0, 0), S(1, 0, 0), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), // Block F  0 - 15
    S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1),
    S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 0), S(0, 0, 1), S(1, 0, 0), S(0, 0, 2), // Block F 16 - 31
    S(0, 0, 1), S(0, 0, 0), S(0, 0, 1), S(0, 0, 1), S(0, 0, 0), S(0, 0, 0), S(0, 0, 1), S(1, 0, 0),

    S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 0), S(0, 0, 5), // Block G  0 - 15
    S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5),
    S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), // Block G 16 - 31
    S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 1), S(0, 0, 6), S(0, 0, 6),

    S(0, 0, 6), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(0, 0, 2), S(0, 0, 2), S(0, 0, 0), // Block H  0 - 15
    S(0, 0, 0), S(1, 0, 0), S(1, 0, 0), S(0, 0, 1), S(0, 0, 1), S(0, 0, 9), S(0, 0, 9), S(0, 0, 0),
    S(1, 0, 0), S(1, 0, 0), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), // Block H 16 - 31
    S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0)
};


/* Mapping of signal name to physical gpio number */
static const struct gpio_mapping_t card11GpioMapping[] = {
    { OP_PANEL_IRQ, BLOCKA(0) },
    { BSPI_CLK, BLOCKA(3) },
    { BSPI_CS,  BLOCKA(4) },
    { BSPI_TXD, BLOCKA(5) },
    { BSPI_RXD, BLOCKA(6) },
    { SDMMC0_CLK,   BLOCKB(0) },
    { SDMMC0_DATA0, BLOCKB(2) },
    { SDMMC0_DATA1, BLOCKB(3) },
    { SDMMC0_DATA2, BLOCKB(4) },
    { SDMMC0_DATA3, BLOCKB(5) },
    { ENET_RESET,   BLOCKB(30) },
    { ENET_25MHZ,   BLOCKB(31) },
    { VIDEO_CLK, BLOCKC(11) },
    { VIDEO_SIG, BLOCKC(8) },
    { AUDIO_ENABLE, BLOCKE(2) },
    { eMMC_ENABLE, BLOCKG(3) },
    { CARD_REV0, BLOCKC(28) },
    { CARD_REV1, BLOCKC(29) },
    { CARD_REV2, BLOCKC(30) },
    { CARD_REV3, BLOCKC(31) },
    { RECOVERY,  BLOCKF(28) }
};

// LS_Clk_Acc_GalvoP period counted in 240mhz clocks
#define LVDS_12P6 19
#define LVDS_13P3 18
#define LVDS_14P1 17
#define LVDS_15P0 16
#define LVDS_16P0 15
#define LVDS_17P1 14
#define LVDS_18P5 13
#define LVDS_20P0 12

#define LVDS_REF_PERIOD LVDS_13P3

int clk_lvds_ui_init(void) {
    struct MIRROR1_REGS_s *mirror1 = (struct MIRROR1_REGS_s *)DEC_DEC_LSCAN_MIRROR1_BASE;

    // Enable reference clock, only used by FIN224C serializer

    // disable LS_Clk_Acc_GalvoP
    mirror1->mcfg2 = MIRROR1_MCFG2_GALVOR_IDLE_REPLACE_VAL(mirror1->mcfg2, 0);
    mirror1->mcfg2 = MIRROR1_MCFG2_GALVOP_DIS_REPLACE_VAL(mirror1->mcfg2, 1);

    // set frequency
    mirror1->mcfg1 = MIRROR1_MCFG1_MODE_REPLACE_VAL(mirror1->mcfg1, 0x1);
    mirror1->mcfg1 = MIRROR1_MCFG1_CONTROL_REPLACE_VAL(mirror1->mcfg1, (LVDS_REF_PERIOD - 2));

    // set duty cycle
    mirror1->galvop_rise0 = MIRROR1_GALVOP_RISE0_ENABLE_MASK;
    mirror1->galvop_fall0 = MIRROR1_GALVOP_FALL0_ENABLE_MASK | (LVDS_REF_PERIOD / 2);

    // enable LS_Clk_Acc_GalvoP
    mirror1->mcfg2 = MIRROR0_MCFG2_GALVOP_DIS_REPLACE_VAL(mirror1->mcfg2, 0);

    // Wait for FIN224C serdes PLLs to stabilize.
    udelay(200);

    return 0;
}

int is_phy_gigabit(void) {
    return 0;
}

const char * card_get_type(void) {
    return "card11";
}

static int is_card_rev_00b(void) {
    struct EFUSE_REGS_s *efuse = (struct EFUSE_REGS_s *)APB_EFUSE_BASE;

    /* Populate the efuse status registers */
    efuse->AUTO_Control = 1;
    while (efuse->TOP_Status & EFUSE_TOP_STATUS_BUSY_MASK);

    return (!(efuse->EfuseStatus96_Bank1 & 0x1));
}

const char * card_get_revision(void) {
    uint32_t revision = 0;

    if (is_card_rev_00b( ))
        return "00b";

    gpio_direction(CARD_REV0, 0);
    gpio_direction(CARD_REV1, 0);
    gpio_direction(CARD_REV2, 0);
    gpio_direction(CARD_REV3, 0);

    revision |= gpio_sample(CARD_REV3) << 3;
    revision |= gpio_sample(CARD_REV2) << 2;
    revision |= gpio_sample(CARD_REV1) << 1;
    revision |= gpio_sample(CARD_REV0);

    switch(revision) {
        case 2:  return "00c";  break;
        case 3:  return "00d";  break;
        case 4:  return "11a";  break;
        default:
        case 5:  return "00e";  break;
    }
}

int board_supports_lcd_vsync_in(void) {
    /*
     * This only means the board layout supports vsync_in.
     * There may be display-specific population differences.
     * To support "illegal" combinations of development hardware, the
     * driver for displays using vsync in will need to be verified by
     * setting a timeout.
     */
    return 1;
}

static void gpio_fix_for_wire_power_en(void) {
}

int card_init(void) {
    struct APB_CONFIG_REGS_s *apb_config = (struct APB_CONFIG_REGS_s *)APB_CONFIG_BASE;

    if (!(is_min_func_mode( )))
        pcie_init();

    gpio_init_pins(card11GpioMapping,
                   ARRAY_SIZE(card11GpioMapping),
                   card11GpioSetup,
                   ARRAY_SIZE(card11GpioSetup));

    gpio_fix_for_wire_power_en();

    // DCmotor4 encoder inputs are routed to the UPC block
    apb_config->PINCR = APB_CONFIG_PINCR_UPCENCODERSEL_REPLACE_VAL(apb_config->PINCR, 0x4);

    // Set drive characteristics for LVDS inputs
    apb_config->PDCR2 = APB_CONFIG_PDCR2_ILVDS_ODT_REPLACE_VAL(apb_config->PDCR2, 0xf);

    //turn off the 16ma override on lcd outputs
    apb_config->PDCR2 = APB_CONFIG_PDCR2_GPIOC_LEDB_REPLACE_VAL(apb_config->PDCR2, (~0));

    return 0;
}

void card_dram_init(void)
{
    struct MC_REGS_s *mc_reg = (struct MC_REGS_s *)MC_BASE;

    initDDR3_nt5cb128m16dp_be_MHz400(DDR3_x32);

    /* Adjust the priority for the MVDO group */
    mc_reg->SDRAMControl5 = 0x000A0403;
}

#define VOLTAGE_DROPOFF_ADJUSTMENT 10
#define TPS53819_I2C_BUS_NUM       1
#define TPS53819_I2C_MUX_CHANNEL   2
#define TPS53819_I2C_ADDR          0x10
/* The core voltage regulator is configured early (before PLL is ramped) */
void card_config_core_voltage(char *asic_rev) {
#if 0
    volatile struct GPIO_REGS_s *gpio_block = (volatile struct GPIO_REGS_s *)APB_GPIOD_BASE;
    uint32_t val;

/* turn off until S3 card revision fixes I2C bus setup for core voltage regulator */
    /* i2c mux select uses gpios 107:106  (GPIOC 31:30) */
    val = GPIO_PINCFG30_FUNCSEL_REPLACE_VAL(gpio_block->PinCfg30, 0);
    gpio_block->PinCfg30 = val;
    val = GPIO_PINCFG31_FUNCSEL_REPLACE_VAL(gpio_block->PinCfg31, 0);
    gpio_block->PinCfg31 = val;

    /* set gpios to select the I2C MUX channel */
    val = gpio_block->OutData;
    val |= (TPS53819_I2C_MUX_CHANNEL << 30);
    gpio_block->OutData = val;

    /* enable the gpios */
    val = gpio_block->OE;
    val |= (3 << 30);
    gpio_block->OE = val;

    config_regulator(asic_rev,
                     VOLTAGE_DROPOFF_ADJUSTMENT,
                     TPS53819_I2C_BUS_NUM,
                     TPS53819_I2C_ADDR);
#endif
}

