#include <common.h>
#include <asm/arch/gpio.h>
#include <asm/arch/regAddrs.h>
#include <asm/arch/apb_config_regmasks.h>
#include <asm/arch/apb_config_regstructs.h>
#include <asm/arch/GPIO_regstructs.h>
#include <asm/arch/GPIO_regmasks.h>

#include "card.h"
#include "ddr.h"
#include "regulator.h"

static const uint8_t card03GpioSetup[] = {
    S(0, 0, 0), S(0, 0, 1), S(0, 0, 1), S(0, 1, 1), S(0, 1, 1), S(0, 1, 1), S(0, 1, 1), S(0, 0, 1), // Block A  0 - 15
    S(1, 0, 0), S(1, 0, 0), S(0, 0, 5), S(0, 0, 5), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0),
    S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), // Block A 16 - 31
    S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0),

    S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), // Block B  0 - 15
    S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), S(0, 1, 2),
    S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), // Block B 16 - 31
    S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 9), S(0, 0, 1),

    S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 2), S(0, 0, 2), // Block C  0 - 15
    S(1, 0, 0), S(1, 0, 0), S(0, 0, 9), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1),
    S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), // Block C 16 - 31
    S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1),

    S(0, 1, 1), S(0, 0, 1), S(1, 1, 0), S(0, 1, 0), S(0, 0, 0), S(0, 0, 0), S(0, 1, 1), S(0, 0, 1), // Block D  0 - 15
    S(0, 1, 5), S(0, 1, 5), S(1, 0, 0), S(0, 0, 0), S(0, 0, 1), S(0, 0, 1), S(0, 0, 0), S(1, 0, 0),
    S(0, 0, 0), S(0, 0, 9), S(0, 0, 0), S(0, 0, 0), S(0, 0, 0), S(0, 0, 0), S(0, 0, 0), S(0, 0, 0), // Block D 16 - 31
    S(0, 0, 1), S(1, 0, 0), S(0, 0, 1), S(0, 0, 0), S(0, 0, 9), S(0, 0, 0), S(0, 0, 9), S(0, 0, 9),

    S(0, 1, 1), S(0, 1, 0), S(0, 1, 9), S(0, 1, 0), S(0, 0, 1), S(0, 0, 1), S(0, 0, 0), S(0, 0, 1), // Block E  0 - 15
    S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 1, 1), S(0, 1, 1), S(0, 1, 1), S(0, 1, 1),
    S(0, 1, 1), S(0, 1, 1), S(0, 1, 0), S(0, 1, 0), S(0, 1, 0), S(0, 1, 0), S(0, 1, 0), S(0, 1, 1), // Block E 16 - 31
    S(0, 1, 1), S(0, 1, 0), S(0, 1, 1), S(0, 1, 9), S(0, 1, 0), S(0, 1, 1), S(0, 1, 0), S(0, 1, 0),

    S(0, 1, 0), S(0, 1, 0), S(0, 1, 1), S(0, 1, 1), S(0, 1, 1), S(0, 1, 0), S(0, 1, 1), S(0, 1, 1), // Block F  0 - 15
    S(0, 1, 0), S(0, 1, 0), S(0, 1, 1), S(0, 1, 1), S(0, 1, 1), S(0, 1, 1), S(0, 0, 1), S(0, 1, 1),
    S(0, 0, 0), S(0, 0, 1), S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), S(0, 1, 2), S(0, 1, 9), S(0, 1, 2), // Block F 16 - 31
    S(0, 1, 2), S(0, 1, 2), S(0, 0, 3), S(0, 0, 1), S(0, 0, 0), S(0, 0, 0), S(0, 0, 0), S(0, 0, 0),

    S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 0), S(0, 0, 1), S(0, 1, 5), // Block G  0 - 15
    S(0, 1, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5),
    S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 1, 4), S(0, 1, 0), S(0, 1, 5), S(0, 1, 5), S(0, 1, 5), // Block G 16 - 31
    S(0, 1, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(0, 0, 5), S(1, 1, 0), S(0, 0, 6), S(0, 0, 0),

    S(0, 0, 6), S(0, 0, 2), S(1, 1, 0), S(0, 1, 2), S(0, 1, 6), S(0, 0, 0), S(0, 0, 2), S(0, 0, 0), // Block H  0 - 15
    S(0, 0, 9), S(0, 0, 0), S(0, 1, 0), S(0, 0, 1), S(0, 0, 1), S(0, 0, 9), S(0, 0, 9), S(0, 0, 0),
    S(0, 0, 8), S(0, 0, 1), S(0, 0, 1), S(0, 0, 1), S(0, 1, 1), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), // Block H 16 - 31
    S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0), S(1, 0, 0)
};


/* Mapping of signal name to physical gpio number */
static const struct gpio_mapping_t card03GpioMapping[] = {
    { OP_PANEL_IRQ, BLOCKA(0) },
    { BSPI_CLK, BLOCKA(3) },
    { BSPI_CS,  BLOCKA(4) },
    { BSPI_TXD, BLOCKA(5) },
    { BSPI_RXD, BLOCKA(6) },
    { SDMMC0_CLK,   BLOCKB(0) },
    { SDMMC0_DATA0, BLOCKB(2) },
    { SDMMC0_DATA1, BLOCKB(3) },
    { SDMMC0_DATA2, BLOCKB(4) },
    { SDMMC0_DATA3, BLOCKB(5) },
    { ENET_RESET,   BLOCKB(30) },
    { ENET_25MHZ,   BLOCKB(31) },
    { eMMC_ENABLE,  BLOCKD(16) },
    { AUDIO_ENABLE, BLOCKE(2)  },
    { VIDEO_CLK, BLOCKC(11) },
    { VIDEO_SIG, BLOCKD(23) },
    { CAGE_FAN, BLOCKE(26) }
};

int clk_lvds_ui_init(void){ return 0; }

int is_phy_gigabit(void) {
    return 1;
}

const char * card_get_type(void) {
    return "card03";
}

#define CARDREV_PIN 11
const char * card_get_revision(void) {
    uint32_t revision;

    revision = mv61x0_adc_read(CARDREV_PIN);

    switch (revision) {
        case 0x5:
        case 0x4:  return "02a";  break;
        case 0xb:
        case 0xa:  return "02b";  break;
        case 0x7:
        case 0x6:  return "02c";  break;
        case 0x3:
        case 0x2:  return "02d";  break;
        default:
        case 0xf:  return "02e-r2";  break;
        case 0xd:
        case 0xc:  return "02e";  break;
        case 0x8:
        case 0x9:  return "02f";  break;
    }
}

int board_supports_lcd_vsync_in(void) {
    return 0;
}

int card_init(void) {
    struct APB_CONFIG_REGS_s *apb_config = (struct APB_CONFIG_REGS_s *)APB_CONFIG_BASE;
    const char *cardrev;
    volatile struct GPIO_REGS_s *gpio_block = (volatile struct GPIO_REGS_s *)APB_GPIOE_BASE;
    uint32_t val;

    if (!(is_min_func_mode( )))
        pcie_init();

    gpio_init_pins(card03GpioMapping,
                   ARRAY_SIZE(card03GpioMapping),
                   card03GpioSetup,
                   ARRAY_SIZE(card03GpioSetup));

    // DCmotor4 encoder inputs are routed to the UPC block
    apb_config->PINCR = APB_CONFIG_PINCR_UPCENCODERSEL_REPLACE_VAL(apb_config->PINCR, 0x4);

    // Set drive characteristics for LVDS inputs
    apb_config->PDCR2 = APB_CONFIG_PDCR2_ILVDS_ODT_REPLACE_VAL(apb_config->PDCR2, 0xf);

    //turn off the 16ma override on lcd outputs
    apb_config->PDCR2 = APB_CONFIG_PDCR2_GPIOC_LEDB_REPLACE_VAL(apb_config->PDCR2, (~0));

    {
        // handle the gate dancer bus
        int z;
        volatile uint32_t *pincfg = (volatile uint32_t *)0xf8046080;

        for (z=0; z<5; ++z) {
            pincfg[z] |= (1 << 12);
        }
    }

    /* If card rev is 02b, default cage fan to high */
    cardrev = card_get_revision();
    if(strcmp(cardrev, "02b") == 0) {
        gpio_direction(CAGE_FAN, 1);
        gpio_set(CAGE_FAN, 1);
    }

    /* Setup threshold for WAKE_FROM_SC, which is the OR'd output of the ADF paper present sensor and the  */
    /* flatbed cover open sensor.  There is noise on this signal when toggling the 5V scan sensor rail.    */
    val = GPIO_PINCFG30_RAWALT_REPLACE_VAL(gpio_block->PinCfg30, 0);
    /* 14 ==> poll every 4ms, state must be constant for 12-16ms before PIO changes state  */
    gpio_block->PinCfg30 = GPIO_PINCFG30_DEGTB_REPLACE_VAL(val, 14);

    return 0;
}

void card_dram_init(void)
{
    initDDR3_nt5cb128m16dp_be_MHz400(DDR3_x32);
}

#define VOLTAGE_DROPOFF_ADJUSTMENT 10
#define TPS53819_I2C_BUS_NUM       1
#define TPS53819_I2C_ADDR          0x10
/* The core voltage regulator is configured early (before PLL is ramped) */
void card_config_core_voltage(char *asic_rev) {
    config_regulator(asic_rev,
                     VOLTAGE_DROPOFF_ADJUSTMENT,
                     TPS53819_I2C_BUS_NUM,
                     TPS53819_I2C_ADDR);
}

