/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or
modify this File in accordance with the terms and conditions of the General
Public License Version 2, June 1991 (the "GPL License"), a copy of which is
available along with the File in the license.txt file or by writing to the Free
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or
on the worldwide web at http://www.gnu.org/licenses/gpl.txt.

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
DISCLAIMED.  The GPL License provides additional details about this warranty
disclaimer.

*******************************************************************************/

/*
 * serial.c - serial support.
 */

#include <common.h>
#include <command.h>
#include <serial.h>
#include "mvCommon.h"
#include "uart/mvUart.h"
#include "cpu/mvCpu.h"

extern unsigned int whoAmI(void);

static int mv_serial_init (void)
{
	DECLARE_GLOBAL_DATA_PTR;

	int clock_divisor = (CONFIG_SYS_TCLK / 16)/gd->baudrate;

	/* muti-core support, initiate each Uart to each cpu */

	mvUartInit(whoAmI(), clock_divisor, mvUartBase(whoAmI()));

	return (0);
}

static void mv_serial_putc(const char c)
{
	if (c == '\n')

	mvUartPutc(whoAmI(), '\r');
	mvUartPutc(whoAmI(), c);
}

static int mv_serial_getc(void)
{
	return mvUartGetc(whoAmI());
}

static int mv_serial_tstc(void)
{
	return mvUartTstc(whoAmI());
}

static void mv_serial_setbrg (void)
{
	DECLARE_GLOBAL_DATA_PTR;
	int clock_divisor = (CONFIG_SYS_TCLK / 16)/gd->baudrate;

	/* muti-core support, initiate each Uart to each cpu */
	mvUartInit(whoAmI(), clock_divisor, mvUartBase(whoAmI()));
}

static void mv_serial_puts (const char *s)
{
	while (*s) {
		mv_serial_putc (*s++);
	}
}

struct serial_device mvSerialDevice = {
    .name   = "mv_serial",
    .start  = mv_serial_init,
    .stop   = NULL,
    .setbrg = mv_serial_setbrg,
    .getc   = mv_serial_getc,
    .tstc   = mv_serial_tstc,
    .putc   = mv_serial_putc,
    .puts   = mv_serial_puts,
};

struct serial_device *default_serial_console(void) {
    return &mvSerialDevice;
}

#if defined(CONFIG_CMD_KGDB)
void kgdb_serial_init(void){}

void putDebugChar (int c)
{
	mv_serial_putc (c);
}

void putDebugStr (const char *str)
{
	mv_serial_puts (str);
}

int getDebugChar (void)
{
	return mv_serial_getc();
}

void kgdb_interruptible (int yes)
{
	return;
}
#endif	/* CFG_CMD_KGDB	*/
