 /*
 **************************************************************************************
 *
 * Copyright (c) 2011 Marvell International, Ltd.
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file apb_config_regmasks.h
 * Generated using RegBuild 1.6.1
 *
 *************************************************************************
 */

#ifndef _APB_CONFIG_REGMASKS_H_
#define _APB_CONFIG_REGMASKS_H_

//#include <stdint.h>

//====================================================================
//
//Register File: Chip configuration registers (apb_config)
/** \brief Configuration registers contained in apb_config.v*/
//
//====================================================================

//====================================================================
//Register: ASIC Identification Register (AIR)
/** \brief This register may be read by the firmware to determine the hardware type and version.*/
//====================================================================

#define  APB_CONFIG_AIR_RESERVED1_MASK 0xff000000
#define  APB_CONFIG_AIR_RESERVED1_SHIFT 24
#define  APB_CONFIG_AIR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_AIR_RESERVED1_MASK) >> APB_CONFIG_AIR_RESERVED1_SHIFT)
#define  APB_CONFIG_AIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_AIR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_AIR_RESERVED1_SHIFT))

#define  APB_CONFIG_AIR_PLATID_MASK 0xffff00
#define  APB_CONFIG_AIR_PLATID_SHIFT 8
#define  APB_CONFIG_AIR_PLATID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_AIR_PLATID_MASK) >> APB_CONFIG_AIR_PLATID_SHIFT)
#define  APB_CONFIG_AIR_PLATID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_AIR_PLATID_MASK) | (((uint32_t)val) << APB_CONFIG_AIR_PLATID_SHIFT))

#define  APB_CONFIG_AIR_MAJORREV_MASK 0xf0
#define  APB_CONFIG_AIR_MAJORREV_SHIFT 4
#define  APB_CONFIG_AIR_MAJORREV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_AIR_MAJORREV_MASK) >> APB_CONFIG_AIR_MAJORREV_SHIFT)
#define  APB_CONFIG_AIR_MAJORREV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_AIR_MAJORREV_MASK) | (((uint32_t)val) << APB_CONFIG_AIR_MAJORREV_SHIFT))

#define  APB_CONFIG_AIR_MINORREV_MASK 0xf
#define  APB_CONFIG_AIR_MINORREV_SHIFT 0
#define  APB_CONFIG_AIR_MINORREV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_AIR_MINORREV_MASK) >> APB_CONFIG_AIR_MINORREV_SHIFT)
#define  APB_CONFIG_AIR_MINORREV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_AIR_MINORREV_MASK) | (((uint32_t)val) << APB_CONFIG_AIR_MINORREV_SHIFT))

//====================================================================
//Register: ASIC Configuration/Boot Status Register (ASR)
/** \brief This register may be read by the firmware to determine the hardware configuration upon reset.*/
//====================================================================

#define  APB_CONFIG_ASR_RESERVED1_MASK 0xffffff00
#define  APB_CONFIG_ASR_RESERVED1_SHIFT 8
#define  APB_CONFIG_ASR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_ASR_RESERVED1_MASK) >> APB_CONFIG_ASR_RESERVED1_SHIFT)
#define  APB_CONFIG_ASR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_ASR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_ASR_RESERVED1_SHIFT))

#define  APB_CONFIG_ASR_CONFIGBOOTSTATUS_MASK 0xff
#define  APB_CONFIG_ASR_CONFIGBOOTSTATUS_SHIFT 0
#define  APB_CONFIG_ASR_CONFIGBOOTSTATUS_MASK_SHIFT(reg) (((reg) & APB_CONFIG_ASR_CONFIGBOOTSTATUS_MASK) >> APB_CONFIG_ASR_CONFIGBOOTSTATUS_SHIFT)
#define  APB_CONFIG_ASR_CONFIGBOOTSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_ASR_CONFIGBOOTSTATUS_MASK) | (((uint32_t)val) << APB_CONFIG_ASR_CONFIGBOOTSTATUS_SHIFT))

//====================================================================
//Register: Optional Feature Control Register (OFCR)
/** \brief This register allows firmware control of feature options. If a feature is
disables via an efuse bit, then it is not affected by this register.*/
//====================================================================

#define  APB_CONFIG_OFCR_RESERVED1_MASK 0xffe00000
#define  APB_CONFIG_OFCR_RESERVED1_SHIFT 21
#define  APB_CONFIG_OFCR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFCR_RESERVED1_MASK) >> APB_CONFIG_OFCR_RESERVED1_SHIFT)
#define  APB_CONFIG_OFCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFCR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_OFCR_RESERVED1_SHIFT))

#define  APB_CONFIG_OFCR_CPU_FREQ_MASK 0x100000
#define  APB_CONFIG_OFCR_CPU_FREQ_SHIFT 20
#define  APB_CONFIG_OFCR_CPU_FREQ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFCR_CPU_FREQ_MASK) >> APB_CONFIG_OFCR_CPU_FREQ_SHIFT)
#define  APB_CONFIG_OFCR_CPU_FREQ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFCR_CPU_FREQ_MASK) | (((uint32_t)val) << APB_CONFIG_OFCR_CPU_FREQ_SHIFT))

#define  APB_CONFIG_OFCR_DDR_BUSWIDTH_MASK 0x80000
#define  APB_CONFIG_OFCR_DDR_BUSWIDTH_SHIFT 19
#define  APB_CONFIG_OFCR_DDR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFCR_DDR_BUSWIDTH_MASK) >> APB_CONFIG_OFCR_DDR_BUSWIDTH_SHIFT)
#define  APB_CONFIG_OFCR_DDR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFCR_DDR_BUSWIDTH_MASK) | (((uint32_t)val) << APB_CONFIG_OFCR_DDR_BUSWIDTH_SHIFT))

#define  APB_CONFIG_OFCR_ICE_MASK 0x40000
#define  APB_CONFIG_OFCR_ICE_SHIFT 18
#define  APB_CONFIG_OFCR_ICE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFCR_ICE_MASK) >> APB_CONFIG_OFCR_ICE_SHIFT)
#define  APB_CONFIG_OFCR_ICE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFCR_ICE_MASK) | (((uint32_t)val) << APB_CONFIG_OFCR_ICE_SHIFT))

#define  APB_CONFIG_OFCR_RESERVED2_MASK 0x3f000
#define  APB_CONFIG_OFCR_RESERVED2_SHIFT 12
#define  APB_CONFIG_OFCR_RESERVED2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFCR_RESERVED2_MASK) >> APB_CONFIG_OFCR_RESERVED2_SHIFT)
#define  APB_CONFIG_OFCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFCR_RESERVED2_MASK) | (((uint32_t)val) << APB_CONFIG_OFCR_RESERVED2_SHIFT))

#define  APB_CONFIG_OFCR_RESERVE_LVDSAFE_MASK 0x800
#define  APB_CONFIG_OFCR_RESERVE_LVDSAFE_SHIFT 11
#define  APB_CONFIG_OFCR_RESERVE_LVDSAFE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFCR_RESERVE_LVDSAFE_MASK) >> APB_CONFIG_OFCR_RESERVE_LVDSAFE_SHIFT)
#define  APB_CONFIG_OFCR_RESERVE_LVDSAFE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFCR_RESERVE_LVDSAFE_MASK) | (((uint32_t)val) << APB_CONFIG_OFCR_RESERVE_LVDSAFE_SHIFT))

#define  APB_CONFIG_OFCR_LASER_VIDEOCHAN_MASK 0x7f8
#define  APB_CONFIG_OFCR_LASER_VIDEOCHAN_SHIFT 3
#define  APB_CONFIG_OFCR_LASER_VIDEOCHAN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFCR_LASER_VIDEOCHAN_MASK) >> APB_CONFIG_OFCR_LASER_VIDEOCHAN_SHIFT)
#define  APB_CONFIG_OFCR_LASER_VIDEOCHAN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFCR_LASER_VIDEOCHAN_MASK) | (((uint32_t)val) << APB_CONFIG_OFCR_LASER_VIDEOCHAN_SHIFT))

#define  APB_CONFIG_OFCR_INK_PENCONTROL_MASK 0x4
#define  APB_CONFIG_OFCR_INK_PENCONTROL_SHIFT 2
#define  APB_CONFIG_OFCR_INK_PENCONTROL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFCR_INK_PENCONTROL_MASK) >> APB_CONFIG_OFCR_INK_PENCONTROL_SHIFT)
#define  APB_CONFIG_OFCR_INK_PENCONTROL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFCR_INK_PENCONTROL_MASK) | (((uint32_t)val) << APB_CONFIG_OFCR_INK_PENCONTROL_SHIFT))

#define  APB_CONFIG_OFCR_AGATE_SSPLL_MASK 0x2
#define  APB_CONFIG_OFCR_AGATE_SSPLL_SHIFT 1
#define  APB_CONFIG_OFCR_AGATE_SSPLL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFCR_AGATE_SSPLL_MASK) >> APB_CONFIG_OFCR_AGATE_SSPLL_SHIFT)
#define  APB_CONFIG_OFCR_AGATE_SSPLL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFCR_AGATE_SSPLL_MASK) | (((uint32_t)val) << APB_CONFIG_OFCR_AGATE_SSPLL_SHIFT))

#define  APB_CONFIG_OFCR_AGATE_TOP_MASK 0x1
#define  APB_CONFIG_OFCR_AGATE_TOP_SHIFT 0
#define  APB_CONFIG_OFCR_AGATE_TOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFCR_AGATE_TOP_MASK) >> APB_CONFIG_OFCR_AGATE_TOP_SHIFT)
#define  APB_CONFIG_OFCR_AGATE_TOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFCR_AGATE_TOP_MASK) | (((uint32_t)val) << APB_CONFIG_OFCR_AGATE_TOP_SHIFT))

//====================================================================
//Register: Optional Feature Status Register (OFSR)
/** \brief This register indicates the status of the optional features as set via the efuse bits or
     the OFCR Register bits. Note that the efuse bits take precedence over the OFCR Register bits.*/
//====================================================================

#define  APB_CONFIG_OFSR_RESERVED1_MASK 0xffe00000
#define  APB_CONFIG_OFSR_RESERVED1_SHIFT 21
#define  APB_CONFIG_OFSR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFSR_RESERVED1_MASK) >> APB_CONFIG_OFSR_RESERVED1_SHIFT)
#define  APB_CONFIG_OFSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFSR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_OFSR_RESERVED1_SHIFT))

#define  APB_CONFIG_OFSR_CPU_FREQ_MASK 0x100000
#define  APB_CONFIG_OFSR_CPU_FREQ_SHIFT 20
#define  APB_CONFIG_OFSR_CPU_FREQ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFSR_CPU_FREQ_MASK) >> APB_CONFIG_OFSR_CPU_FREQ_SHIFT)
#define  APB_CONFIG_OFSR_CPU_FREQ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFSR_CPU_FREQ_MASK) | (((uint32_t)val) << APB_CONFIG_OFSR_CPU_FREQ_SHIFT))

#define  APB_CONFIG_OFSR_DDR_BUSWIDTH_MASK 0x80000
#define  APB_CONFIG_OFSR_DDR_BUSWIDTH_SHIFT 19
#define  APB_CONFIG_OFSR_DDR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFSR_DDR_BUSWIDTH_MASK) >> APB_CONFIG_OFSR_DDR_BUSWIDTH_SHIFT)
#define  APB_CONFIG_OFSR_DDR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFSR_DDR_BUSWIDTH_MASK) | (((uint32_t)val) << APB_CONFIG_OFSR_DDR_BUSWIDTH_SHIFT))

#define  APB_CONFIG_OFSR_ICE_MASK 0x40000
#define  APB_CONFIG_OFSR_ICE_SHIFT 18
#define  APB_CONFIG_OFSR_ICE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFSR_ICE_MASK) >> APB_CONFIG_OFSR_ICE_SHIFT)
#define  APB_CONFIG_OFSR_ICE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFSR_ICE_MASK) | (((uint32_t)val) << APB_CONFIG_OFSR_ICE_SHIFT))

#define  APB_CONFIG_OFSR_RESERVED2_MASK 0x3f000
#define  APB_CONFIG_OFSR_RESERVED2_SHIFT 12
#define  APB_CONFIG_OFSR_RESERVED2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFSR_RESERVED2_MASK) >> APB_CONFIG_OFSR_RESERVED2_SHIFT)
#define  APB_CONFIG_OFSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFSR_RESERVED2_MASK) | (((uint32_t)val) << APB_CONFIG_OFSR_RESERVED2_SHIFT))

#define  APB_CONFIG_OFSR_RESERVE_LVDSAFE_MASK 0x800
#define  APB_CONFIG_OFSR_RESERVE_LVDSAFE_SHIFT 11
#define  APB_CONFIG_OFSR_RESERVE_LVDSAFE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFSR_RESERVE_LVDSAFE_MASK) >> APB_CONFIG_OFSR_RESERVE_LVDSAFE_SHIFT)
#define  APB_CONFIG_OFSR_RESERVE_LVDSAFE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFSR_RESERVE_LVDSAFE_MASK) | (((uint32_t)val) << APB_CONFIG_OFSR_RESERVE_LVDSAFE_SHIFT))

#define  APB_CONFIG_OFSR_LASER_VIDEOCHAN_MASK 0x7f8
#define  APB_CONFIG_OFSR_LASER_VIDEOCHAN_SHIFT 3
#define  APB_CONFIG_OFSR_LASER_VIDEOCHAN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFSR_LASER_VIDEOCHAN_MASK) >> APB_CONFIG_OFSR_LASER_VIDEOCHAN_SHIFT)
#define  APB_CONFIG_OFSR_LASER_VIDEOCHAN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFSR_LASER_VIDEOCHAN_MASK) | (((uint32_t)val) << APB_CONFIG_OFSR_LASER_VIDEOCHAN_SHIFT))

#define  APB_CONFIG_OFSR_INK_PENCONTROL_MASK 0x4
#define  APB_CONFIG_OFSR_INK_PENCONTROL_SHIFT 2
#define  APB_CONFIG_OFSR_INK_PENCONTROL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFSR_INK_PENCONTROL_MASK) >> APB_CONFIG_OFSR_INK_PENCONTROL_SHIFT)
#define  APB_CONFIG_OFSR_INK_PENCONTROL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFSR_INK_PENCONTROL_MASK) | (((uint32_t)val) << APB_CONFIG_OFSR_INK_PENCONTROL_SHIFT))

#define  APB_CONFIG_OFSR_AGATE_SSPLL_MASK 0x2
#define  APB_CONFIG_OFSR_AGATE_SSPLL_SHIFT 1
#define  APB_CONFIG_OFSR_AGATE_SSPLL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFSR_AGATE_SSPLL_MASK) >> APB_CONFIG_OFSR_AGATE_SSPLL_SHIFT)
#define  APB_CONFIG_OFSR_AGATE_SSPLL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFSR_AGATE_SSPLL_MASK) | (((uint32_t)val) << APB_CONFIG_OFSR_AGATE_SSPLL_SHIFT))

#define  APB_CONFIG_OFSR_AGATE_TOP_MASK 0x1
#define  APB_CONFIG_OFSR_AGATE_TOP_SHIFT 0
#define  APB_CONFIG_OFSR_AGATE_TOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_OFSR_AGATE_TOP_MASK) >> APB_CONFIG_OFSR_AGATE_TOP_SHIFT)
#define  APB_CONFIG_OFSR_AGATE_TOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_OFSR_AGATE_TOP_MASK) | (((uint32_t)val) << APB_CONFIG_OFSR_AGATE_TOP_SHIFT))

//====================================================================
//Register: Pinout and MemMap Configuration Register (PINCR)
/** \brief This register configures connections between chip pins and various function blocks.
      <br/>*/
//====================================================================

#define  APB_CONFIG_PINCR_SCANRSYNCSEL_MASK 0xf0000000
#define  APB_CONFIG_PINCR_SCANRSYNCSEL_SHIFT 28
#define  APB_CONFIG_PINCR_SCANRSYNCSEL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PINCR_SCANRSYNCSEL_MASK) >> APB_CONFIG_PINCR_SCANRSYNCSEL_SHIFT)
#define  APB_CONFIG_PINCR_SCANRSYNCSEL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PINCR_SCANRSYNCSEL_MASK) | (((uint32_t)val) << APB_CONFIG_PINCR_SCANRSYNCSEL_SHIFT))

#define  APB_CONFIG_PINCR_LVDO_OE_MASK 0xff00000
#define  APB_CONFIG_PINCR_LVDO_OE_SHIFT 20
#define  APB_CONFIG_PINCR_LVDO_OE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PINCR_LVDO_OE_MASK) >> APB_CONFIG_PINCR_LVDO_OE_SHIFT)
#define  APB_CONFIG_PINCR_LVDO_OE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PINCR_LVDO_OE_MASK) | (((uint32_t)val) << APB_CONFIG_PINCR_LVDO_OE_SHIFT))

#define  APB_CONFIG_PINCR_VID_NHSYNC_SEL_MASK 0x80000
#define  APB_CONFIG_PINCR_VID_NHSYNC_SEL_SHIFT 19
#define  APB_CONFIG_PINCR_VID_NHSYNC_SEL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PINCR_VID_NHSYNC_SEL_MASK) >> APB_CONFIG_PINCR_VID_NHSYNC_SEL_SHIFT)
#define  APB_CONFIG_PINCR_VID_NHSYNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PINCR_VID_NHSYNC_SEL_MASK) | (((uint32_t)val) << APB_CONFIG_PINCR_VID_NHSYNC_SEL_SHIFT))

#define  APB_CONFIG_PINCR_LVDS_PENNVID_SEL_MASK 0x7ff00
#define  APB_CONFIG_PINCR_LVDS_PENNVID_SEL_SHIFT 8
#define  APB_CONFIG_PINCR_LVDS_PENNVID_SEL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PINCR_LVDS_PENNVID_SEL_MASK) >> APB_CONFIG_PINCR_LVDS_PENNVID_SEL_SHIFT)
#define  APB_CONFIG_PINCR_LVDS_PENNVID_SEL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PINCR_LVDS_PENNVID_SEL_MASK) | (((uint32_t)val) << APB_CONFIG_PINCR_LVDS_PENNVID_SEL_SHIFT))

#define  APB_CONFIG_PINCR_RESERVED1_MASK 0x80
#define  APB_CONFIG_PINCR_RESERVED1_SHIFT 7
#define  APB_CONFIG_PINCR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PINCR_RESERVED1_MASK) >> APB_CONFIG_PINCR_RESERVED1_SHIFT)
#define  APB_CONFIG_PINCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PINCR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PINCR_RESERVED1_SHIFT))

#define  APB_CONFIG_PINCR_UPCENCODERSEL_MASK 0x70
#define  APB_CONFIG_PINCR_UPCENCODERSEL_SHIFT 4
#define  APB_CONFIG_PINCR_UPCENCODERSEL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PINCR_UPCENCODERSEL_MASK) >> APB_CONFIG_PINCR_UPCENCODERSEL_SHIFT)
#define  APB_CONFIG_PINCR_UPCENCODERSEL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PINCR_UPCENCODERSEL_MASK) | (((uint32_t)val) << APB_CONFIG_PINCR_UPCENCODERSEL_SHIFT))

#define  APB_CONFIG_PINCR_DISABLEUPCREMAP_MASK 0x8
#define  APB_CONFIG_PINCR_DISABLEUPCREMAP_SHIFT 3
#define  APB_CONFIG_PINCR_DISABLEUPCREMAP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PINCR_DISABLEUPCREMAP_MASK) >> APB_CONFIG_PINCR_DISABLEUPCREMAP_SHIFT)
#define  APB_CONFIG_PINCR_DISABLEUPCREMAP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PINCR_DISABLEUPCREMAP_MASK) | (((uint32_t)val) << APB_CONFIG_PINCR_DISABLEUPCREMAP_SHIFT))

#define  APB_CONFIG_PINCR_AFEREVERSE_MASK 0x4
#define  APB_CONFIG_PINCR_AFEREVERSE_SHIFT 2
#define  APB_CONFIG_PINCR_AFEREVERSE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PINCR_AFEREVERSE_MASK) >> APB_CONFIG_PINCR_AFEREVERSE_SHIFT)
#define  APB_CONFIG_PINCR_AFEREVERSE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PINCR_AFEREVERSE_MASK) | (((uint32_t)val) << APB_CONFIG_PINCR_AFEREVERSE_SHIFT))

#define  APB_CONFIG_PINCR_RESERVED2_MASK 0x3
#define  APB_CONFIG_PINCR_RESERVED2_SHIFT 0
#define  APB_CONFIG_PINCR_RESERVED2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PINCR_RESERVED2_MASK) >> APB_CONFIG_PINCR_RESERVED2_SHIFT)
#define  APB_CONFIG_PINCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PINCR_RESERVED2_MASK) | (((uint32_t)val) << APB_CONFIG_PINCR_RESERVED2_SHIFT))

//====================================================================
//Register: Pad Drive Configuration Register 1 (PDCR1)
/** \brief This register is used to configure the drive characteristics of certain sets of I/O pads.*/
//====================================================================

#define  APB_CONFIG_PDCR1_USBFP_MASK 0xc0000000
#define  APB_CONFIG_PDCR1_USBFP_SHIFT 30
#define  APB_CONFIG_PDCR1_USBFP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR1_USBFP_MASK) >> APB_CONFIG_PDCR1_USBFP_SHIFT)
#define  APB_CONFIG_PDCR1_USBFP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR1_USBFP_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR1_USBFP_SHIFT))

#define  APB_CONFIG_PDCR1_RESERVED1_MASK 0x38000000
#define  APB_CONFIG_PDCR1_RESERVED1_SHIFT 27
#define  APB_CONFIG_PDCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR1_RESERVED1_MASK) >> APB_CONFIG_PDCR1_RESERVED1_SHIFT)
#define  APB_CONFIG_PDCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR1_RESERVED1_SHIFT))

#define  APB_CONFIG_PDCR1_OLVDSPDM_MASK 0x7fc0000
#define  APB_CONFIG_PDCR1_OLVDSPDM_SHIFT 18
#define  APB_CONFIG_PDCR1_OLVDSPDM_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR1_OLVDSPDM_MASK) >> APB_CONFIG_PDCR1_OLVDSPDM_SHIFT)
#define  APB_CONFIG_PDCR1_OLVDSPDM_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR1_OLVDSPDM_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR1_OLVDSPDM_SHIFT))

#define  APB_CONFIG_PDCR1_OLVDSPDP_MASK 0x3fe00
#define  APB_CONFIG_PDCR1_OLVDSPDP_SHIFT 9
#define  APB_CONFIG_PDCR1_OLVDSPDP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR1_OLVDSPDP_MASK) >> APB_CONFIG_PDCR1_OLVDSPDP_SHIFT)
#define  APB_CONFIG_PDCR1_OLVDSPDP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR1_OLVDSPDP_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR1_OLVDSPDP_SHIFT))

#define  APB_CONFIG_PDCR1_OLVDSSR_MASK 0x1ff
#define  APB_CONFIG_PDCR1_OLVDSSR_SHIFT 0
#define  APB_CONFIG_PDCR1_OLVDSSR_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR1_OLVDSSR_MASK) >> APB_CONFIG_PDCR1_OLVDSSR_SHIFT)
#define  APB_CONFIG_PDCR1_OLVDSSR_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR1_OLVDSSR_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR1_OLVDSSR_SHIFT))

//====================================================================
//Register: Pad Drive Configuration Register 2 (PDCR2)
/** \brief This register is used to configure the drive characteristics of certain sets of I/O pads.*/
//====================================================================

#define  APB_CONFIG_PDCR2_GPIOC_LEDB_MASK 0xfffff800
#define  APB_CONFIG_PDCR2_GPIOC_LEDB_SHIFT 11
#define  APB_CONFIG_PDCR2_GPIOC_LEDB_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR2_GPIOC_LEDB_MASK) >> APB_CONFIG_PDCR2_GPIOC_LEDB_SHIFT)
#define  APB_CONFIG_PDCR2_GPIOC_LEDB_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR2_GPIOC_LEDB_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR2_GPIOC_LEDB_SHIFT))

#define  APB_CONFIG_PDCR2_RESERVED1_MASK 0x700
#define  APB_CONFIG_PDCR2_RESERVED1_SHIFT 8
#define  APB_CONFIG_PDCR2_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR2_RESERVED1_MASK) >> APB_CONFIG_PDCR2_RESERVED1_SHIFT)
#define  APB_CONFIG_PDCR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR2_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR2_RESERVED1_SHIFT))

#define  APB_CONFIG_PDCR2_ILVDS_PD_MASK 0xf0
#define  APB_CONFIG_PDCR2_ILVDS_PD_SHIFT 4
#define  APB_CONFIG_PDCR2_ILVDS_PD_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR2_ILVDS_PD_MASK) >> APB_CONFIG_PDCR2_ILVDS_PD_SHIFT)
#define  APB_CONFIG_PDCR2_ILVDS_PD_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR2_ILVDS_PD_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR2_ILVDS_PD_SHIFT))

#define  APB_CONFIG_PDCR2_ILVDS_ODT_MASK 0xf
#define  APB_CONFIG_PDCR2_ILVDS_ODT_SHIFT 0
#define  APB_CONFIG_PDCR2_ILVDS_ODT_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR2_ILVDS_ODT_MASK) >> APB_CONFIG_PDCR2_ILVDS_ODT_SHIFT)
#define  APB_CONFIG_PDCR2_ILVDS_ODT_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR2_ILVDS_ODT_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR2_ILVDS_ODT_SHIFT))

//====================================================================
//Register: Pad Drive Configuration Register 3 (PDCR3)
/** \brief This register is used to configure the drive characteristics of the LAN HSIO pads.*/
//====================================================================

#define  APB_CONFIG_PDCR3_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_PDCR3_RESERVED1_SHIFT 9
#define  APB_CONFIG_PDCR3_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR3_RESERVED1_MASK) >> APB_CONFIG_PDCR3_RESERVED1_SHIFT)
#define  APB_CONFIG_PDCR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR3_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR3_RESERVED1_SHIFT))

#define  APB_CONFIG_PDCR3_HSIO_VSEL_MASK 0x180
#define  APB_CONFIG_PDCR3_HSIO_VSEL_SHIFT 7
#define  APB_CONFIG_PDCR3_HSIO_VSEL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR3_HSIO_VSEL_MASK) >> APB_CONFIG_PDCR3_HSIO_VSEL_SHIFT)
#define  APB_CONFIG_PDCR3_HSIO_VSEL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR3_HSIO_VSEL_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR3_HSIO_VSEL_SHIFT))

#define  APB_CONFIG_PDCR3_HSIO_ZN_MASK 0x70
#define  APB_CONFIG_PDCR3_HSIO_ZN_SHIFT 4
#define  APB_CONFIG_PDCR3_HSIO_ZN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR3_HSIO_ZN_MASK) >> APB_CONFIG_PDCR3_HSIO_ZN_SHIFT)
#define  APB_CONFIG_PDCR3_HSIO_ZN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR3_HSIO_ZN_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR3_HSIO_ZN_SHIFT))

#define  APB_CONFIG_PDCR3_HSIO_ZP_MASK 0xe
#define  APB_CONFIG_PDCR3_HSIO_ZP_SHIFT 1
#define  APB_CONFIG_PDCR3_HSIO_ZP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR3_HSIO_ZP_MASK) >> APB_CONFIG_PDCR3_HSIO_ZP_SHIFT)
#define  APB_CONFIG_PDCR3_HSIO_ZP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR3_HSIO_ZP_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR3_HSIO_ZP_SHIFT))

#define  APB_CONFIG_PDCR3_HSIO_PD_MASK 0x1
#define  APB_CONFIG_PDCR3_HSIO_PD_SHIFT 0
#define  APB_CONFIG_PDCR3_HSIO_PD_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDCR3_HSIO_PD_MASK) >> APB_CONFIG_PDCR3_HSIO_PD_SHIFT)
#define  APB_CONFIG_PDCR3_HSIO_PD_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDCR3_HSIO_PD_MASK) | (((uint32_t)val) << APB_CONFIG_PDCR3_HSIO_PD_SHIFT))

//====================================================================
//Register: Pad Voltage Sensor Configuration Register (PVSCR)
/** \brief This register configures the voltage sensors which automatically configure the pads for either 1.8V or 3.3V VDD supply voltage.
      There are two groups of pads that support both voltages, and there is a sensor for each group: <br/>
            0 NAND pins<br/>
            1 Ink Pen pins<br/>
      Note: Operating 1.8V pads in 3.3V mode will not work reliably but it's safe - the pads won't be damaged. Operating 3.3V pads in 1.8V mode can permanently damage the pads.*/
//====================================================================

#define  APB_CONFIG_PVSCR_RESERVED1_MASK 0xffc00000
#define  APB_CONFIG_PVSCR_RESERVED1_SHIFT 22
#define  APB_CONFIG_PVSCR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PVSCR_RESERVED1_MASK) >> APB_CONFIG_PVSCR_RESERVED1_SHIFT)
#define  APB_CONFIG_PVSCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PVSCR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PVSCR_RESERVED1_SHIFT))

#define  APB_CONFIG_PVSCR_TSEL_MASK 0x300000
#define  APB_CONFIG_PVSCR_TSEL_SHIFT 20
#define  APB_CONFIG_PVSCR_TSEL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PVSCR_TSEL_MASK) >> APB_CONFIG_PVSCR_TSEL_SHIFT)
#define  APB_CONFIG_PVSCR_TSEL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PVSCR_TSEL_MASK) | (((uint32_t)val) << APB_CONFIG_PVSCR_TSEL_SHIFT))

#define  APB_CONFIG_PVSCR_TEST_MASK 0xe0000
#define  APB_CONFIG_PVSCR_TEST_SHIFT 17
#define  APB_CONFIG_PVSCR_TEST_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PVSCR_TEST_MASK) >> APB_CONFIG_PVSCR_TEST_SHIFT)
#define  APB_CONFIG_PVSCR_TEST_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PVSCR_TEST_MASK) | (((uint32_t)val) << APB_CONFIG_PVSCR_TEST_SHIFT))

#define  APB_CONFIG_PVSCR_VTHRESH_MASK 0x10000
#define  APB_CONFIG_PVSCR_VTHRESH_SHIFT 16
#define  APB_CONFIG_PVSCR_VTHRESH_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PVSCR_VTHRESH_MASK) >> APB_CONFIG_PVSCR_VTHRESH_SHIFT)
#define  APB_CONFIG_PVSCR_VTHRESH_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PVSCR_VTHRESH_MASK) | (((uint32_t)val) << APB_CONFIG_PVSCR_VTHRESH_SHIFT))

#define  APB_CONFIG_PVSCR_RESERVED2_MASK 0xfff0
#define  APB_CONFIG_PVSCR_RESERVED2_SHIFT 4
#define  APB_CONFIG_PVSCR_RESERVED2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PVSCR_RESERVED2_MASK) >> APB_CONFIG_PVSCR_RESERVED2_SHIFT)
#define  APB_CONFIG_PVSCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PVSCR_RESERVED2_MASK) | (((uint32_t)val) << APB_CONFIG_PVSCR_RESERVED2_SHIFT))

#define  APB_CONFIG_PVSCR_V18EN_IN_MASK 0xc
#define  APB_CONFIG_PVSCR_V18EN_IN_SHIFT 2
#define  APB_CONFIG_PVSCR_V18EN_IN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PVSCR_V18EN_IN_MASK) >> APB_CONFIG_PVSCR_V18EN_IN_SHIFT)
#define  APB_CONFIG_PVSCR_V18EN_IN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PVSCR_V18EN_IN_MASK) | (((uint32_t)val) << APB_CONFIG_PVSCR_V18EN_IN_SHIFT))

#define  APB_CONFIG_PVSCR_BYPASS_MASK 0x2
#define  APB_CONFIG_PVSCR_BYPASS_SHIFT 1
#define  APB_CONFIG_PVSCR_BYPASS_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PVSCR_BYPASS_MASK) >> APB_CONFIG_PVSCR_BYPASS_SHIFT)
#define  APB_CONFIG_PVSCR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PVSCR_BYPASS_MASK) | (((uint32_t)val) << APB_CONFIG_PVSCR_BYPASS_SHIFT))

#define  APB_CONFIG_PVSCR_DISABLE_MASK 0x1
#define  APB_CONFIG_PVSCR_DISABLE_SHIFT 0
#define  APB_CONFIG_PVSCR_DISABLE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PVSCR_DISABLE_MASK) >> APB_CONFIG_PVSCR_DISABLE_SHIFT)
#define  APB_CONFIG_PVSCR_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PVSCR_DISABLE_MASK) | (((uint32_t)val) << APB_CONFIG_PVSCR_DISABLE_SHIFT))

//====================================================================
//Register: Pad Voltage Sensor Status Register (PVSSR)
/** \brief This register contains the actual pad voltage control values.*/
//====================================================================

#define  APB_CONFIG_PVSSR_RESERVED1_MASK 0xfffffffc
#define  APB_CONFIG_PVSSR_RESERVED1_SHIFT 2
#define  APB_CONFIG_PVSSR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PVSSR_RESERVED1_MASK) >> APB_CONFIG_PVSSR_RESERVED1_SHIFT)
#define  APB_CONFIG_PVSSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PVSSR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PVSSR_RESERVED1_SHIFT))

#define  APB_CONFIG_PVSSR_V18EN_OUT_MASK 0x3
#define  APB_CONFIG_PVSSR_V18EN_OUT_SHIFT 0
#define  APB_CONFIG_PVSSR_V18EN_OUT_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PVSSR_V18EN_OUT_MASK) >> APB_CONFIG_PVSSR_V18EN_OUT_SHIFT)
#define  APB_CONFIG_PVSSR_V18EN_OUT_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PVSSR_V18EN_OUT_MASK) | (((uint32_t)val) << APB_CONFIG_PVSSR_V18EN_OUT_SHIFT))

//====================================================================
//Register: Bandgap Configuration Register (BGCR)
/** \brief Configuration values for the bandgap current reference which is used by the oscillator and the USB PHYs and PCIe ANA_GRP.*/
//====================================================================

#define  APB_CONFIG_BGCR_RESERVED1_MASK 0xffffe000
#define  APB_CONFIG_BGCR_RESERVED1_SHIFT 13
#define  APB_CONFIG_BGCR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_BGCR_RESERVED1_MASK) >> APB_CONFIG_BGCR_RESERVED1_SHIFT)
#define  APB_CONFIG_BGCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_BGCR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_BGCR_RESERVED1_SHIFT))

#define  APB_CONFIG_BGCR_PECL_BG_PU_MASK 0x1000
#define  APB_CONFIG_BGCR_PECL_BG_PU_SHIFT 12
#define  APB_CONFIG_BGCR_PECL_BG_PU_MASK_SHIFT(reg) (((reg) & APB_CONFIG_BGCR_PECL_BG_PU_MASK) >> APB_CONFIG_BGCR_PECL_BG_PU_SHIFT)
#define  APB_CONFIG_BGCR_PECL_BG_PU_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_BGCR_PECL_BG_PU_MASK) | (((uint32_t)val) << APB_CONFIG_BGCR_PECL_BG_PU_SHIFT))

#define  APB_CONFIG_BGCR_PECL_BG_TEST_MASK 0xf00
#define  APB_CONFIG_BGCR_PECL_BG_TEST_SHIFT 8
#define  APB_CONFIG_BGCR_PECL_BG_TEST_MASK_SHIFT(reg) (((reg) & APB_CONFIG_BGCR_PECL_BG_TEST_MASK) >> APB_CONFIG_BGCR_PECL_BG_TEST_SHIFT)
#define  APB_CONFIG_BGCR_PECL_BG_TEST_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_BGCR_PECL_BG_TEST_MASK) | (((uint32_t)val) << APB_CONFIG_BGCR_PECL_BG_TEST_SHIFT))

#define  APB_CONFIG_BGCR_PECL_BG_SEL_MASK 0xc0
#define  APB_CONFIG_BGCR_PECL_BG_SEL_SHIFT 6
#define  APB_CONFIG_BGCR_PECL_BG_SEL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_BGCR_PECL_BG_SEL_MASK) >> APB_CONFIG_BGCR_PECL_BG_SEL_SHIFT)
#define  APB_CONFIG_BGCR_PECL_BG_SEL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_BGCR_PECL_BG_SEL_MASK) | (((uint32_t)val) << APB_CONFIG_BGCR_PECL_BG_SEL_SHIFT))

#define  APB_CONFIG_BGCR_BG_TEST_MASK 0x3c
#define  APB_CONFIG_BGCR_BG_TEST_SHIFT 2
#define  APB_CONFIG_BGCR_BG_TEST_MASK_SHIFT(reg) (((reg) & APB_CONFIG_BGCR_BG_TEST_MASK) >> APB_CONFIG_BGCR_BG_TEST_SHIFT)
#define  APB_CONFIG_BGCR_BG_TEST_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_BGCR_BG_TEST_MASK) | (((uint32_t)val) << APB_CONFIG_BGCR_BG_TEST_SHIFT))

#define  APB_CONFIG_BGCR_BG_SEL_MASK 0x3
#define  APB_CONFIG_BGCR_BG_SEL_SHIFT 0
#define  APB_CONFIG_BGCR_BG_SEL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_BGCR_BG_SEL_MASK) >> APB_CONFIG_BGCR_BG_SEL_SHIFT)
#define  APB_CONFIG_BGCR_BG_SEL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_BGCR_BG_SEL_MASK) | (((uint32_t)val) << APB_CONFIG_BGCR_BG_SEL_SHIFT))

//====================================================================
//Register: PLL 0 Configuration Register 0 (PLL0_CR0)
/** \brief Configuration values for the main dithering PLL.*/
//====================================================================

#define  APB_CONFIG_PLL0_CR0_VCODIV_SEL_SE_MASK 0xf0000000
#define  APB_CONFIG_PLL0_CR0_VCODIV_SEL_SE_SHIFT 28
#define  APB_CONFIG_PLL0_CR0_VCODIV_SEL_SE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR0_VCODIV_SEL_SE_MASK) >> APB_CONFIG_PLL0_CR0_VCODIV_SEL_SE_SHIFT)
#define  APB_CONFIG_PLL0_CR0_VCODIV_SEL_SE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR0_VCODIV_SEL_SE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR0_VCODIV_SEL_SE_SHIFT))

#define  APB_CONFIG_PLL0_CR0_VCODIV_SEL_DIFF_MASK 0xf000000
#define  APB_CONFIG_PLL0_CR0_VCODIV_SEL_DIFF_SHIFT 24
#define  APB_CONFIG_PLL0_CR0_VCODIV_SEL_DIFF_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR0_VCODIV_SEL_DIFF_MASK) >> APB_CONFIG_PLL0_CR0_VCODIV_SEL_DIFF_SHIFT)
#define  APB_CONFIG_PLL0_CR0_VCODIV_SEL_DIFF_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR0_VCODIV_SEL_DIFF_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR0_VCODIV_SEL_DIFF_SHIFT))

#define  APB_CONFIG_PLL0_CR0_VCO_VRNG_MASK 0xe00000
#define  APB_CONFIG_PLL0_CR0_VCO_VRNG_SHIFT 21
#define  APB_CONFIG_PLL0_CR0_VCO_VRNG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR0_VCO_VRNG_MASK) >> APB_CONFIG_PLL0_CR0_VCO_VRNG_SHIFT)
#define  APB_CONFIG_PLL0_CR0_VCO_VRNG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR0_VCO_VRNG_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR0_VCO_VRNG_SHIFT))

#define  APB_CONFIG_PLL0_CR0_KVCO_MASK 0x1e0000
#define  APB_CONFIG_PLL0_CR0_KVCO_SHIFT 17
#define  APB_CONFIG_PLL0_CR0_KVCO_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR0_KVCO_MASK) >> APB_CONFIG_PLL0_CR0_KVCO_SHIFT)
#define  APB_CONFIG_PLL0_CR0_KVCO_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR0_KVCO_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR0_KVCO_SHIFT))

#define  APB_CONFIG_PLL0_CR0_FBDIV_MASK 0x1ff00
#define  APB_CONFIG_PLL0_CR0_FBDIV_SHIFT 8
#define  APB_CONFIG_PLL0_CR0_FBDIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR0_FBDIV_MASK) >> APB_CONFIG_PLL0_CR0_FBDIV_SHIFT)
#define  APB_CONFIG_PLL0_CR0_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR0_FBDIV_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR0_FBDIV_SHIFT))

#define  APB_CONFIG_PLL0_CR0_REFDIV_MASK 0xf8
#define  APB_CONFIG_PLL0_CR0_REFDIV_SHIFT 3
#define  APB_CONFIG_PLL0_CR0_REFDIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR0_REFDIV_MASK) >> APB_CONFIG_PLL0_CR0_REFDIV_SHIFT)
#define  APB_CONFIG_PLL0_CR0_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR0_REFDIV_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR0_REFDIV_SHIFT))

#define  APB_CONFIG_PLL0_CR0_RESET_MASK 0x4
#define  APB_CONFIG_PLL0_CR0_RESET_SHIFT 2
#define  APB_CONFIG_PLL0_CR0_RESET_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR0_RESET_MASK) >> APB_CONFIG_PLL0_CR0_RESET_SHIFT)
#define  APB_CONFIG_PLL0_CR0_RESET_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR0_RESET_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR0_RESET_SHIFT))

#define  APB_CONFIG_PLL0_CR0_BYPASS_EN_MASK 0x2
#define  APB_CONFIG_PLL0_CR0_BYPASS_EN_SHIFT 1
#define  APB_CONFIG_PLL0_CR0_BYPASS_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR0_BYPASS_EN_MASK) >> APB_CONFIG_PLL0_CR0_BYPASS_EN_SHIFT)
#define  APB_CONFIG_PLL0_CR0_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR0_BYPASS_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR0_BYPASS_EN_SHIFT))

#define  APB_CONFIG_PLL0_CR0_PU_MASK 0x1
#define  APB_CONFIG_PLL0_CR0_PU_SHIFT 0
#define  APB_CONFIG_PLL0_CR0_PU_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR0_PU_MASK) >> APB_CONFIG_PLL0_CR0_PU_SHIFT)
#define  APB_CONFIG_PLL0_CR0_PU_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR0_PU_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR0_PU_SHIFT))

//====================================================================
//Register: PLL 0 Configuration Register 1 (PLL0_CR1)
/** \brief Configuration values for the main dithering PLL*/
//====================================================================

#define  APB_CONFIG_PLL0_CR1_TEST_MON_MASK 0xf0000000
#define  APB_CONFIG_PLL0_CR1_TEST_MON_SHIFT 28
#define  APB_CONFIG_PLL0_CR1_TEST_MON_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_TEST_MON_MASK) >> APB_CONFIG_PLL0_CR1_TEST_MON_SHIFT)
#define  APB_CONFIG_PLL0_CR1_TEST_MON_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_TEST_MON_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_TEST_MON_SHIFT))

#define  APB_CONFIG_PLL0_CR1_RESERVED1_MASK 0xf000000
#define  APB_CONFIG_PLL0_CR1_RESERVED1_SHIFT 24
#define  APB_CONFIG_PLL0_CR1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_RESERVED1_MASK) >> APB_CONFIG_PLL0_CR1_RESERVED1_SHIFT)
#define  APB_CONFIG_PLL0_CR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_RESERVED1_SHIFT))

#define  APB_CONFIG_PLL0_CR1_SEL_VCO_DIFF_MASK 0x800000
#define  APB_CONFIG_PLL0_CR1_SEL_VCO_DIFF_SHIFT 23
#define  APB_CONFIG_PLL0_CR1_SEL_VCO_DIFF_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_SEL_VCO_DIFF_MASK) >> APB_CONFIG_PLL0_CR1_SEL_VCO_DIFF_SHIFT)
#define  APB_CONFIG_PLL0_CR1_SEL_VCO_DIFF_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_SEL_VCO_DIFF_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_SEL_VCO_DIFF_SHIFT))

#define  APB_CONFIG_PLL0_CR1_SEL_VCO_CLK_SE_MASK 0x400000
#define  APB_CONFIG_PLL0_CR1_SEL_VCO_CLK_SE_SHIFT 22
#define  APB_CONFIG_PLL0_CR1_SEL_VCO_CLK_SE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_SEL_VCO_CLK_SE_MASK) >> APB_CONFIG_PLL0_CR1_SEL_VCO_CLK_SE_SHIFT)
#define  APB_CONFIG_PLL0_CR1_SEL_VCO_CLK_SE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_SEL_VCO_CLK_SE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_SEL_VCO_CLK_SE_SHIFT))

#define  APB_CONFIG_PLL0_CR1_GATE_CLK_CTRL_MASK 0x200000
#define  APB_CONFIG_PLL0_CR1_GATE_CLK_CTRL_SHIFT 21
#define  APB_CONFIG_PLL0_CR1_GATE_CLK_CTRL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_GATE_CLK_CTRL_MASK) >> APB_CONFIG_PLL0_CR1_GATE_CLK_CTRL_SHIFT)
#define  APB_CONFIG_PLL0_CR1_GATE_CLK_CTRL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_GATE_CLK_CTRL_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_GATE_CLK_CTRL_SHIFT))

#define  APB_CONFIG_PLL0_CR1_BYPASS_FBDIV_MASK 0x100000
#define  APB_CONFIG_PLL0_CR1_BYPASS_FBDIV_SHIFT 20
#define  APB_CONFIG_PLL0_CR1_BYPASS_FBDIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_BYPASS_FBDIV_MASK) >> APB_CONFIG_PLL0_CR1_BYPASS_FBDIV_SHIFT)
#define  APB_CONFIG_PLL0_CR1_BYPASS_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_BYPASS_FBDIV_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_BYPASS_FBDIV_SHIFT))

#define  APB_CONFIG_PLL0_CR1_PI_EN_MASK 0x80000
#define  APB_CONFIG_PLL0_CR1_PI_EN_SHIFT 19
#define  APB_CONFIG_PLL0_CR1_PI_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_PI_EN_MASK) >> APB_CONFIG_PLL0_CR1_PI_EN_SHIFT)
#define  APB_CONFIG_PLL0_CR1_PI_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_PI_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_PI_EN_SHIFT))

#define  APB_CONFIG_PLL0_CR1_DIFFCLK_EN_MASK 0x40000
#define  APB_CONFIG_PLL0_CR1_DIFFCLK_EN_SHIFT 18
#define  APB_CONFIG_PLL0_CR1_DIFFCLK_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_DIFFCLK_EN_MASK) >> APB_CONFIG_PLL0_CR1_DIFFCLK_EN_SHIFT)
#define  APB_CONFIG_PLL0_CR1_DIFFCLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_DIFFCLK_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_DIFFCLK_EN_SHIFT))

#define  APB_CONFIG_PLL0_CR1_CLK_DET_EN_MASK 0x20000
#define  APB_CONFIG_PLL0_CR1_CLK_DET_EN_SHIFT 17
#define  APB_CONFIG_PLL0_CR1_CLK_DET_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_CLK_DET_EN_MASK) >> APB_CONFIG_PLL0_CR1_CLK_DET_EN_SHIFT)
#define  APB_CONFIG_PLL0_CR1_CLK_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_CLK_DET_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_CLK_DET_EN_SHIFT))

#define  APB_CONFIG_PLL0_CR1_VREG_IVREF_MASK 0x18000
#define  APB_CONFIG_PLL0_CR1_VREG_IVREF_SHIFT 15
#define  APB_CONFIG_PLL0_CR1_VREG_IVREF_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_VREG_IVREF_MASK) >> APB_CONFIG_PLL0_CR1_VREG_IVREF_SHIFT)
#define  APB_CONFIG_PLL0_CR1_VREG_IVREF_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_VREG_IVREF_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_VREG_IVREF_SHIFT))

#define  APB_CONFIG_PLL0_CR1_VDDL_MASK 0x7800
#define  APB_CONFIG_PLL0_CR1_VDDL_SHIFT 11
#define  APB_CONFIG_PLL0_CR1_VDDL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_VDDL_MASK) >> APB_CONFIG_PLL0_CR1_VDDL_SHIFT)
#define  APB_CONFIG_PLL0_CR1_VDDL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_VDDL_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_VDDL_SHIFT))

#define  APB_CONFIG_PLL0_CR1_VDDM_MASK 0x600
#define  APB_CONFIG_PLL0_CR1_VDDM_SHIFT 9
#define  APB_CONFIG_PLL0_CR1_VDDM_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_VDDM_MASK) >> APB_CONFIG_PLL0_CR1_VDDM_SHIFT)
#define  APB_CONFIG_PLL0_CR1_VDDM_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_VDDM_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_VDDM_SHIFT))

#define  APB_CONFIG_PLL0_CR1_INTPI_MASK 0x1e0
#define  APB_CONFIG_PLL0_CR1_INTPI_SHIFT 5
#define  APB_CONFIG_PLL0_CR1_INTPI_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_INTPI_MASK) >> APB_CONFIG_PLL0_CR1_INTPI_SHIFT)
#define  APB_CONFIG_PLL0_CR1_INTPI_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_INTPI_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_INTPI_SHIFT))

#define  APB_CONFIG_PLL0_CR1_ICP_MASK 0x1c
#define  APB_CONFIG_PLL0_CR1_ICP_SHIFT 2
#define  APB_CONFIG_PLL0_CR1_ICP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_ICP_MASK) >> APB_CONFIG_PLL0_CR1_ICP_SHIFT)
#define  APB_CONFIG_PLL0_CR1_ICP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_ICP_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_ICP_SHIFT))

#define  APB_CONFIG_PLL0_CR1_CTUNE_MASK 0x3
#define  APB_CONFIG_PLL0_CR1_CTUNE_SHIFT 0
#define  APB_CONFIG_PLL0_CR1_CTUNE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR1_CTUNE_MASK) >> APB_CONFIG_PLL0_CR1_CTUNE_SHIFT)
#define  APB_CONFIG_PLL0_CR1_CTUNE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR1_CTUNE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR1_CTUNE_SHIFT))

//====================================================================
//Register: PLL 0 Configuration Register 2 (PLL0_CR2)
/** \brief Configuration values for the main dithering PLL*/
//====================================================================

#define  APB_CONFIG_PLL0_CR2_SSC_RESET_EXT_MASK 0x80000000
#define  APB_CONFIG_PLL0_CR2_SSC_RESET_EXT_SHIFT 31
#define  APB_CONFIG_PLL0_CR2_SSC_RESET_EXT_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR2_SSC_RESET_EXT_MASK) >> APB_CONFIG_PLL0_CR2_SSC_RESET_EXT_SHIFT)
#define  APB_CONFIG_PLL0_CR2_SSC_RESET_EXT_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR2_SSC_RESET_EXT_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR2_SSC_RESET_EXT_SHIFT))

#define  APB_CONFIG_PLL0_CR2_SSC_RNGE_MASK 0x7ff00000
#define  APB_CONFIG_PLL0_CR2_SSC_RNGE_SHIFT 20
#define  APB_CONFIG_PLL0_CR2_SSC_RNGE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR2_SSC_RNGE_MASK) >> APB_CONFIG_PLL0_CR2_SSC_RNGE_SHIFT)
#define  APB_CONFIG_PLL0_CR2_SSC_RNGE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR2_SSC_RNGE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR2_SSC_RNGE_SHIFT))

#define  APB_CONFIG_PLL0_CR2_SSC_FREQ_DIV_MASK 0xffff0
#define  APB_CONFIG_PLL0_CR2_SSC_FREQ_DIV_SHIFT 4
#define  APB_CONFIG_PLL0_CR2_SSC_FREQ_DIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR2_SSC_FREQ_DIV_MASK) >> APB_CONFIG_PLL0_CR2_SSC_FREQ_DIV_SHIFT)
#define  APB_CONFIG_PLL0_CR2_SSC_FREQ_DIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR2_SSC_FREQ_DIV_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR2_SSC_FREQ_DIV_SHIFT))

#define  APB_CONFIG_PLL0_CR2_SSC_MODE_MASK 0x8
#define  APB_CONFIG_PLL0_CR2_SSC_MODE_SHIFT 3
#define  APB_CONFIG_PLL0_CR2_SSC_MODE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR2_SSC_MODE_MASK) >> APB_CONFIG_PLL0_CR2_SSC_MODE_SHIFT)
#define  APB_CONFIG_PLL0_CR2_SSC_MODE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR2_SSC_MODE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR2_SSC_MODE_SHIFT))

#define  APB_CONFIG_PLL0_CR2_SSC_CLK_EN_MASK 0x4
#define  APB_CONFIG_PLL0_CR2_SSC_CLK_EN_SHIFT 2
#define  APB_CONFIG_PLL0_CR2_SSC_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR2_SSC_CLK_EN_MASK) >> APB_CONFIG_PLL0_CR2_SSC_CLK_EN_SHIFT)
#define  APB_CONFIG_PLL0_CR2_SSC_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR2_SSC_CLK_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR2_SSC_CLK_EN_SHIFT))

#define  APB_CONFIG_PLL0_CR2_SSC_EN_MASK 0x2
#define  APB_CONFIG_PLL0_CR2_SSC_EN_SHIFT 1
#define  APB_CONFIG_PLL0_CR2_SSC_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR2_SSC_EN_MASK) >> APB_CONFIG_PLL0_CR2_SSC_EN_SHIFT)
#define  APB_CONFIG_PLL0_CR2_SSC_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR2_SSC_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR2_SSC_EN_SHIFT))

#define  APB_CONFIG_PLL0_CR2_RESET_EXT_MASK 0x1
#define  APB_CONFIG_PLL0_CR2_RESET_EXT_SHIFT 0
#define  APB_CONFIG_PLL0_CR2_RESET_EXT_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR2_RESET_EXT_MASK) >> APB_CONFIG_PLL0_CR2_RESET_EXT_SHIFT)
#define  APB_CONFIG_PLL0_CR2_RESET_EXT_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR2_RESET_EXT_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR2_RESET_EXT_SHIFT))

//====================================================================
//Register: PLL 0 Configuration Register 3 (PLL0_CR3)
/** \brief Configuration values for the main dithering PLL*/
//====================================================================

#define  APB_CONFIG_PLL0_CR3_RESERVED1_MASK 0xfff00000
#define  APB_CONFIG_PLL0_CR3_RESERVED1_SHIFT 20
#define  APB_CONFIG_PLL0_CR3_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR3_RESERVED1_MASK) >> APB_CONFIG_PLL0_CR3_RESERVED1_SHIFT)
#define  APB_CONFIG_PLL0_CR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR3_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR3_RESERVED1_SHIFT))

#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_MODE_SELECTION_MASK 0x80000
#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_MODE_SELECTION_SHIFT 19
#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_MODE_SELECTION_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR3_FREQ_OFFSET_MODE_SELECTION_MASK) >> APB_CONFIG_PLL0_CR3_FREQ_OFFSET_MODE_SELECTION_SHIFT)
#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_MODE_SELECTION_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR3_FREQ_OFFSET_MODE_SELECTION_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR3_FREQ_OFFSET_MODE_SELECTION_SHIFT))

#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_VALID_MASK 0x40000
#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_VALID_SHIFT 18
#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_VALID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR3_FREQ_OFFSET_VALID_MASK) >> APB_CONFIG_PLL0_CR3_FREQ_OFFSET_VALID_SHIFT)
#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_VALID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR3_FREQ_OFFSET_VALID_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR3_FREQ_OFFSET_VALID_SHIFT))

#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_EN_MASK 0x20000
#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_EN_SHIFT 17
#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR3_FREQ_OFFSET_EN_MASK) >> APB_CONFIG_PLL0_CR3_FREQ_OFFSET_EN_SHIFT)
#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR3_FREQ_OFFSET_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR3_FREQ_OFFSET_EN_SHIFT))

#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_MASK 0x1ffff
#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_SHIFT 0
#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_CR3_FREQ_OFFSET_MASK) >> APB_CONFIG_PLL0_CR3_FREQ_OFFSET_SHIFT)
#define  APB_CONFIG_PLL0_CR3_FREQ_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_CR3_FREQ_OFFSET_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_CR3_FREQ_OFFSET_SHIFT))

//====================================================================
//Register: PLL 0 Status Register (PLL0_SR)
/** \brief The PLL Status Register contains the "lock" indicator from the main dithering PLL.*/
//====================================================================

#define  APB_CONFIG_PLL0_SR_RESERVED1_MASK 0xfffffffe
#define  APB_CONFIG_PLL0_SR_RESERVED1_SHIFT 1
#define  APB_CONFIG_PLL0_SR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_SR_RESERVED1_MASK) >> APB_CONFIG_PLL0_SR_RESERVED1_SHIFT)
#define  APB_CONFIG_PLL0_SR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_SR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_SR_RESERVED1_SHIFT))

#define  APB_CONFIG_PLL0_SR_LOCK_MASK 0x1
#define  APB_CONFIG_PLL0_SR_LOCK_SHIFT 0
#define  APB_CONFIG_PLL0_SR_LOCK_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL0_SR_LOCK_MASK) >> APB_CONFIG_PLL0_SR_LOCK_SHIFT)
#define  APB_CONFIG_PLL0_SR_LOCK_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL0_SR_LOCK_MASK) | (((uint32_t)val) << APB_CONFIG_PLL0_SR_LOCK_SHIFT))

//====================================================================
//Register: PLL 1 Configuration Register 0 (PLL1_CR0)
/** \brief Configuration values for the video PLL.*/
//====================================================================

#define  APB_CONFIG_PLL1_CR0_VCODIV_SEL_SE_MASK 0xf0000000
#define  APB_CONFIG_PLL1_CR0_VCODIV_SEL_SE_SHIFT 28
#define  APB_CONFIG_PLL1_CR0_VCODIV_SEL_SE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR0_VCODIV_SEL_SE_MASK) >> APB_CONFIG_PLL1_CR0_VCODIV_SEL_SE_SHIFT)
#define  APB_CONFIG_PLL1_CR0_VCODIV_SEL_SE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR0_VCODIV_SEL_SE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR0_VCODIV_SEL_SE_SHIFT))

#define  APB_CONFIG_PLL1_CR0_VCODIV_SEL_DIFF_MASK 0xf000000
#define  APB_CONFIG_PLL1_CR0_VCODIV_SEL_DIFF_SHIFT 24
#define  APB_CONFIG_PLL1_CR0_VCODIV_SEL_DIFF_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR0_VCODIV_SEL_DIFF_MASK) >> APB_CONFIG_PLL1_CR0_VCODIV_SEL_DIFF_SHIFT)
#define  APB_CONFIG_PLL1_CR0_VCODIV_SEL_DIFF_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR0_VCODIV_SEL_DIFF_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR0_VCODIV_SEL_DIFF_SHIFT))

#define  APB_CONFIG_PLL1_CR0_VCO_VRNG_MASK 0xe00000
#define  APB_CONFIG_PLL1_CR0_VCO_VRNG_SHIFT 21
#define  APB_CONFIG_PLL1_CR0_VCO_VRNG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR0_VCO_VRNG_MASK) >> APB_CONFIG_PLL1_CR0_VCO_VRNG_SHIFT)
#define  APB_CONFIG_PLL1_CR0_VCO_VRNG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR0_VCO_VRNG_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR0_VCO_VRNG_SHIFT))

#define  APB_CONFIG_PLL1_CR0_KVCO_MASK 0x1e0000
#define  APB_CONFIG_PLL1_CR0_KVCO_SHIFT 17
#define  APB_CONFIG_PLL1_CR0_KVCO_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR0_KVCO_MASK) >> APB_CONFIG_PLL1_CR0_KVCO_SHIFT)
#define  APB_CONFIG_PLL1_CR0_KVCO_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR0_KVCO_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR0_KVCO_SHIFT))

#define  APB_CONFIG_PLL1_CR0_FBDIV_MASK 0x1ff00
#define  APB_CONFIG_PLL1_CR0_FBDIV_SHIFT 8
#define  APB_CONFIG_PLL1_CR0_FBDIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR0_FBDIV_MASK) >> APB_CONFIG_PLL1_CR0_FBDIV_SHIFT)
#define  APB_CONFIG_PLL1_CR0_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR0_FBDIV_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR0_FBDIV_SHIFT))

#define  APB_CONFIG_PLL1_CR0_REFDIV_MASK 0xf8
#define  APB_CONFIG_PLL1_CR0_REFDIV_SHIFT 3
#define  APB_CONFIG_PLL1_CR0_REFDIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR0_REFDIV_MASK) >> APB_CONFIG_PLL1_CR0_REFDIV_SHIFT)
#define  APB_CONFIG_PLL1_CR0_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR0_REFDIV_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR0_REFDIV_SHIFT))

#define  APB_CONFIG_PLL1_CR0_RESET_MASK 0x4
#define  APB_CONFIG_PLL1_CR0_RESET_SHIFT 2
#define  APB_CONFIG_PLL1_CR0_RESET_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR0_RESET_MASK) >> APB_CONFIG_PLL1_CR0_RESET_SHIFT)
#define  APB_CONFIG_PLL1_CR0_RESET_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR0_RESET_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR0_RESET_SHIFT))

#define  APB_CONFIG_PLL1_CR0_BYPASS_EN_MASK 0x2
#define  APB_CONFIG_PLL1_CR0_BYPASS_EN_SHIFT 1
#define  APB_CONFIG_PLL1_CR0_BYPASS_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR0_BYPASS_EN_MASK) >> APB_CONFIG_PLL1_CR0_BYPASS_EN_SHIFT)
#define  APB_CONFIG_PLL1_CR0_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR0_BYPASS_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR0_BYPASS_EN_SHIFT))

#define  APB_CONFIG_PLL1_CR0_PU_MASK 0x1
#define  APB_CONFIG_PLL1_CR0_PU_SHIFT 0
#define  APB_CONFIG_PLL1_CR0_PU_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR0_PU_MASK) >> APB_CONFIG_PLL1_CR0_PU_SHIFT)
#define  APB_CONFIG_PLL1_CR0_PU_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR0_PU_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR0_PU_SHIFT))

//====================================================================
//Register: PLL 1 Configuration Register 1 (PLL1_CR1)
/** \brief Configuration values for the video PLL*/
//====================================================================

#define  APB_CONFIG_PLL1_CR1_TEST_MON_MASK 0xf0000000
#define  APB_CONFIG_PLL1_CR1_TEST_MON_SHIFT 28
#define  APB_CONFIG_PLL1_CR1_TEST_MON_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_TEST_MON_MASK) >> APB_CONFIG_PLL1_CR1_TEST_MON_SHIFT)
#define  APB_CONFIG_PLL1_CR1_TEST_MON_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_TEST_MON_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_TEST_MON_SHIFT))

#define  APB_CONFIG_PLL1_CR1_RESERVED1_MASK 0xf000000
#define  APB_CONFIG_PLL1_CR1_RESERVED1_SHIFT 24
#define  APB_CONFIG_PLL1_CR1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_RESERVED1_MASK) >> APB_CONFIG_PLL1_CR1_RESERVED1_SHIFT)
#define  APB_CONFIG_PLL1_CR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_RESERVED1_SHIFT))

#define  APB_CONFIG_PLL1_CR1_SEL_VCO_DIFF_MASK 0x800000
#define  APB_CONFIG_PLL1_CR1_SEL_VCO_DIFF_SHIFT 23
#define  APB_CONFIG_PLL1_CR1_SEL_VCO_DIFF_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_SEL_VCO_DIFF_MASK) >> APB_CONFIG_PLL1_CR1_SEL_VCO_DIFF_SHIFT)
#define  APB_CONFIG_PLL1_CR1_SEL_VCO_DIFF_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_SEL_VCO_DIFF_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_SEL_VCO_DIFF_SHIFT))

#define  APB_CONFIG_PLL1_CR1_SEL_VCO_CLK_SE_MASK 0x400000
#define  APB_CONFIG_PLL1_CR1_SEL_VCO_CLK_SE_SHIFT 22
#define  APB_CONFIG_PLL1_CR1_SEL_VCO_CLK_SE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_SEL_VCO_CLK_SE_MASK) >> APB_CONFIG_PLL1_CR1_SEL_VCO_CLK_SE_SHIFT)
#define  APB_CONFIG_PLL1_CR1_SEL_VCO_CLK_SE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_SEL_VCO_CLK_SE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_SEL_VCO_CLK_SE_SHIFT))

#define  APB_CONFIG_PLL1_CR1_GATE_CLK_CTRL_MASK 0x200000
#define  APB_CONFIG_PLL1_CR1_GATE_CLK_CTRL_SHIFT 21
#define  APB_CONFIG_PLL1_CR1_GATE_CLK_CTRL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_GATE_CLK_CTRL_MASK) >> APB_CONFIG_PLL1_CR1_GATE_CLK_CTRL_SHIFT)
#define  APB_CONFIG_PLL1_CR1_GATE_CLK_CTRL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_GATE_CLK_CTRL_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_GATE_CLK_CTRL_SHIFT))

#define  APB_CONFIG_PLL1_CR1_BYPASS_FBDIV_MASK 0x100000
#define  APB_CONFIG_PLL1_CR1_BYPASS_FBDIV_SHIFT 20
#define  APB_CONFIG_PLL1_CR1_BYPASS_FBDIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_BYPASS_FBDIV_MASK) >> APB_CONFIG_PLL1_CR1_BYPASS_FBDIV_SHIFT)
#define  APB_CONFIG_PLL1_CR1_BYPASS_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_BYPASS_FBDIV_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_BYPASS_FBDIV_SHIFT))

#define  APB_CONFIG_PLL1_CR1_PI_EN_MASK 0x80000
#define  APB_CONFIG_PLL1_CR1_PI_EN_SHIFT 19
#define  APB_CONFIG_PLL1_CR1_PI_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_PI_EN_MASK) >> APB_CONFIG_PLL1_CR1_PI_EN_SHIFT)
#define  APB_CONFIG_PLL1_CR1_PI_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_PI_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_PI_EN_SHIFT))

#define  APB_CONFIG_PLL1_CR1_DIFFCLK_EN_MASK 0x40000
#define  APB_CONFIG_PLL1_CR1_DIFFCLK_EN_SHIFT 18
#define  APB_CONFIG_PLL1_CR1_DIFFCLK_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_DIFFCLK_EN_MASK) >> APB_CONFIG_PLL1_CR1_DIFFCLK_EN_SHIFT)
#define  APB_CONFIG_PLL1_CR1_DIFFCLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_DIFFCLK_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_DIFFCLK_EN_SHIFT))

#define  APB_CONFIG_PLL1_CR1_CLK_DET_EN_MASK 0x20000
#define  APB_CONFIG_PLL1_CR1_CLK_DET_EN_SHIFT 17
#define  APB_CONFIG_PLL1_CR1_CLK_DET_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_CLK_DET_EN_MASK) >> APB_CONFIG_PLL1_CR1_CLK_DET_EN_SHIFT)
#define  APB_CONFIG_PLL1_CR1_CLK_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_CLK_DET_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_CLK_DET_EN_SHIFT))

#define  APB_CONFIG_PLL1_CR1_VREG_IVREF_MASK 0x18000
#define  APB_CONFIG_PLL1_CR1_VREG_IVREF_SHIFT 15
#define  APB_CONFIG_PLL1_CR1_VREG_IVREF_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_VREG_IVREF_MASK) >> APB_CONFIG_PLL1_CR1_VREG_IVREF_SHIFT)
#define  APB_CONFIG_PLL1_CR1_VREG_IVREF_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_VREG_IVREF_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_VREG_IVREF_SHIFT))

#define  APB_CONFIG_PLL1_CR1_VDDL_MASK 0x7800
#define  APB_CONFIG_PLL1_CR1_VDDL_SHIFT 11
#define  APB_CONFIG_PLL1_CR1_VDDL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_VDDL_MASK) >> APB_CONFIG_PLL1_CR1_VDDL_SHIFT)
#define  APB_CONFIG_PLL1_CR1_VDDL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_VDDL_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_VDDL_SHIFT))

#define  APB_CONFIG_PLL1_CR1_VDDM_MASK 0x600
#define  APB_CONFIG_PLL1_CR1_VDDM_SHIFT 9
#define  APB_CONFIG_PLL1_CR1_VDDM_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_VDDM_MASK) >> APB_CONFIG_PLL1_CR1_VDDM_SHIFT)
#define  APB_CONFIG_PLL1_CR1_VDDM_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_VDDM_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_VDDM_SHIFT))

#define  APB_CONFIG_PLL1_CR1_INTPI_MASK 0x1e0
#define  APB_CONFIG_PLL1_CR1_INTPI_SHIFT 5
#define  APB_CONFIG_PLL1_CR1_INTPI_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_INTPI_MASK) >> APB_CONFIG_PLL1_CR1_INTPI_SHIFT)
#define  APB_CONFIG_PLL1_CR1_INTPI_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_INTPI_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_INTPI_SHIFT))

#define  APB_CONFIG_PLL1_CR1_ICP_MASK 0x1c
#define  APB_CONFIG_PLL1_CR1_ICP_SHIFT 2
#define  APB_CONFIG_PLL1_CR1_ICP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_ICP_MASK) >> APB_CONFIG_PLL1_CR1_ICP_SHIFT)
#define  APB_CONFIG_PLL1_CR1_ICP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_ICP_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_ICP_SHIFT))

#define  APB_CONFIG_PLL1_CR1_CTUNE_MASK 0x3
#define  APB_CONFIG_PLL1_CR1_CTUNE_SHIFT 0
#define  APB_CONFIG_PLL1_CR1_CTUNE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR1_CTUNE_MASK) >> APB_CONFIG_PLL1_CR1_CTUNE_SHIFT)
#define  APB_CONFIG_PLL1_CR1_CTUNE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR1_CTUNE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR1_CTUNE_SHIFT))

//====================================================================
//Register: PLL 1 Configuration Register 2 (PLL1_CR2)
/** \brief Configuration values for the video PLL*/
//====================================================================

#define  APB_CONFIG_PLL1_CR2_SSC_RESET_EXT_MASK 0x80000000
#define  APB_CONFIG_PLL1_CR2_SSC_RESET_EXT_SHIFT 31
#define  APB_CONFIG_PLL1_CR2_SSC_RESET_EXT_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR2_SSC_RESET_EXT_MASK) >> APB_CONFIG_PLL1_CR2_SSC_RESET_EXT_SHIFT)
#define  APB_CONFIG_PLL1_CR2_SSC_RESET_EXT_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR2_SSC_RESET_EXT_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR2_SSC_RESET_EXT_SHIFT))

#define  APB_CONFIG_PLL1_CR2_SSC_RNGE_MASK 0x7ff00000
#define  APB_CONFIG_PLL1_CR2_SSC_RNGE_SHIFT 20
#define  APB_CONFIG_PLL1_CR2_SSC_RNGE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR2_SSC_RNGE_MASK) >> APB_CONFIG_PLL1_CR2_SSC_RNGE_SHIFT)
#define  APB_CONFIG_PLL1_CR2_SSC_RNGE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR2_SSC_RNGE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR2_SSC_RNGE_SHIFT))

#define  APB_CONFIG_PLL1_CR2_SSC_FREQ_DIV_MASK 0xffff0
#define  APB_CONFIG_PLL1_CR2_SSC_FREQ_DIV_SHIFT 4
#define  APB_CONFIG_PLL1_CR2_SSC_FREQ_DIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR2_SSC_FREQ_DIV_MASK) >> APB_CONFIG_PLL1_CR2_SSC_FREQ_DIV_SHIFT)
#define  APB_CONFIG_PLL1_CR2_SSC_FREQ_DIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR2_SSC_FREQ_DIV_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR2_SSC_FREQ_DIV_SHIFT))

#define  APB_CONFIG_PLL1_CR2_SSC_MODE_MASK 0x8
#define  APB_CONFIG_PLL1_CR2_SSC_MODE_SHIFT 3
#define  APB_CONFIG_PLL1_CR2_SSC_MODE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR2_SSC_MODE_MASK) >> APB_CONFIG_PLL1_CR2_SSC_MODE_SHIFT)
#define  APB_CONFIG_PLL1_CR2_SSC_MODE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR2_SSC_MODE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR2_SSC_MODE_SHIFT))

#define  APB_CONFIG_PLL1_CR2_SSC_CLK_EN_MASK 0x4
#define  APB_CONFIG_PLL1_CR2_SSC_CLK_EN_SHIFT 2
#define  APB_CONFIG_PLL1_CR2_SSC_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR2_SSC_CLK_EN_MASK) >> APB_CONFIG_PLL1_CR2_SSC_CLK_EN_SHIFT)
#define  APB_CONFIG_PLL1_CR2_SSC_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR2_SSC_CLK_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR2_SSC_CLK_EN_SHIFT))

#define  APB_CONFIG_PLL1_CR2_SSC_EN_MASK 0x2
#define  APB_CONFIG_PLL1_CR2_SSC_EN_SHIFT 1
#define  APB_CONFIG_PLL1_CR2_SSC_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR2_SSC_EN_MASK) >> APB_CONFIG_PLL1_CR2_SSC_EN_SHIFT)
#define  APB_CONFIG_PLL1_CR2_SSC_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR2_SSC_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR2_SSC_EN_SHIFT))

#define  APB_CONFIG_PLL1_CR2_RESET_EXT_MASK 0x1
#define  APB_CONFIG_PLL1_CR2_RESET_EXT_SHIFT 0
#define  APB_CONFIG_PLL1_CR2_RESET_EXT_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR2_RESET_EXT_MASK) >> APB_CONFIG_PLL1_CR2_RESET_EXT_SHIFT)
#define  APB_CONFIG_PLL1_CR2_RESET_EXT_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR2_RESET_EXT_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR2_RESET_EXT_SHIFT))

//====================================================================
//Register: PLL 1 Configuration Register 3 (PLL1_CR3)
/** \brief Configuration values for the video PLL*/
//====================================================================

#define  APB_CONFIG_PLL1_CR3_RESERVED1_MASK 0xfff00000
#define  APB_CONFIG_PLL1_CR3_RESERVED1_SHIFT 20
#define  APB_CONFIG_PLL1_CR3_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR3_RESERVED1_MASK) >> APB_CONFIG_PLL1_CR3_RESERVED1_SHIFT)
#define  APB_CONFIG_PLL1_CR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR3_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR3_RESERVED1_SHIFT))

#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_MODE_SELECTION_MASK 0x80000
#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_MODE_SELECTION_SHIFT 19
#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_MODE_SELECTION_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR3_FREQ_OFFSET_MODE_SELECTION_MASK) >> APB_CONFIG_PLL1_CR3_FREQ_OFFSET_MODE_SELECTION_SHIFT)
#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_MODE_SELECTION_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR3_FREQ_OFFSET_MODE_SELECTION_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR3_FREQ_OFFSET_MODE_SELECTION_SHIFT))

#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_VALID_MASK 0x40000
#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_VALID_SHIFT 18
#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_VALID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR3_FREQ_OFFSET_VALID_MASK) >> APB_CONFIG_PLL1_CR3_FREQ_OFFSET_VALID_SHIFT)
#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_VALID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR3_FREQ_OFFSET_VALID_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR3_FREQ_OFFSET_VALID_SHIFT))

#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_EN_MASK 0x20000
#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_EN_SHIFT 17
#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR3_FREQ_OFFSET_EN_MASK) >> APB_CONFIG_PLL1_CR3_FREQ_OFFSET_EN_SHIFT)
#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR3_FREQ_OFFSET_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR3_FREQ_OFFSET_EN_SHIFT))

#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_MASK 0x1ffff
#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_SHIFT 0
#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_CR3_FREQ_OFFSET_MASK) >> APB_CONFIG_PLL1_CR3_FREQ_OFFSET_SHIFT)
#define  APB_CONFIG_PLL1_CR3_FREQ_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_CR3_FREQ_OFFSET_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_CR3_FREQ_OFFSET_SHIFT))

//====================================================================
//Register: PLL 1 Status Register (PLL1_SR)
/** \brief The PLL Status Register contains the "lock" indicator from the video PLL.*/
//====================================================================

#define  APB_CONFIG_PLL1_SR_RESERVED1_MASK 0xfffffffe
#define  APB_CONFIG_PLL1_SR_RESERVED1_SHIFT 1
#define  APB_CONFIG_PLL1_SR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_SR_RESERVED1_MASK) >> APB_CONFIG_PLL1_SR_RESERVED1_SHIFT)
#define  APB_CONFIG_PLL1_SR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_SR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_SR_RESERVED1_SHIFT))

#define  APB_CONFIG_PLL1_SR_LOCK_MASK 0x1
#define  APB_CONFIG_PLL1_SR_LOCK_SHIFT 0
#define  APB_CONFIG_PLL1_SR_LOCK_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL1_SR_LOCK_MASK) >> APB_CONFIG_PLL1_SR_LOCK_SHIFT)
#define  APB_CONFIG_PLL1_SR_LOCK_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL1_SR_LOCK_MASK) | (((uint32_t)val) << APB_CONFIG_PLL1_SR_LOCK_SHIFT))

//====================================================================
//Register: PLL 2 Configuration Register 0 (PLL2_CR0)
/** \brief Configuration values for the AFE PLL.*/
//====================================================================

#define  APB_CONFIG_PLL2_CR0_VCODIV_SEL_SE_MASK 0xf0000000
#define  APB_CONFIG_PLL2_CR0_VCODIV_SEL_SE_SHIFT 28
#define  APB_CONFIG_PLL2_CR0_VCODIV_SEL_SE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR0_VCODIV_SEL_SE_MASK) >> APB_CONFIG_PLL2_CR0_VCODIV_SEL_SE_SHIFT)
#define  APB_CONFIG_PLL2_CR0_VCODIV_SEL_SE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR0_VCODIV_SEL_SE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR0_VCODIV_SEL_SE_SHIFT))

#define  APB_CONFIG_PLL2_CR0_VCODIV_SEL_DIFF_MASK 0xf000000
#define  APB_CONFIG_PLL2_CR0_VCODIV_SEL_DIFF_SHIFT 24
#define  APB_CONFIG_PLL2_CR0_VCODIV_SEL_DIFF_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR0_VCODIV_SEL_DIFF_MASK) >> APB_CONFIG_PLL2_CR0_VCODIV_SEL_DIFF_SHIFT)
#define  APB_CONFIG_PLL2_CR0_VCODIV_SEL_DIFF_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR0_VCODIV_SEL_DIFF_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR0_VCODIV_SEL_DIFF_SHIFT))

#define  APB_CONFIG_PLL2_CR0_VCO_VRNG_MASK 0xe00000
#define  APB_CONFIG_PLL2_CR0_VCO_VRNG_SHIFT 21
#define  APB_CONFIG_PLL2_CR0_VCO_VRNG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR0_VCO_VRNG_MASK) >> APB_CONFIG_PLL2_CR0_VCO_VRNG_SHIFT)
#define  APB_CONFIG_PLL2_CR0_VCO_VRNG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR0_VCO_VRNG_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR0_VCO_VRNG_SHIFT))

#define  APB_CONFIG_PLL2_CR0_KVCO_MASK 0x1e0000
#define  APB_CONFIG_PLL2_CR0_KVCO_SHIFT 17
#define  APB_CONFIG_PLL2_CR0_KVCO_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR0_KVCO_MASK) >> APB_CONFIG_PLL2_CR0_KVCO_SHIFT)
#define  APB_CONFIG_PLL2_CR0_KVCO_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR0_KVCO_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR0_KVCO_SHIFT))

#define  APB_CONFIG_PLL2_CR0_FBDIV_MASK 0x1ff00
#define  APB_CONFIG_PLL2_CR0_FBDIV_SHIFT 8
#define  APB_CONFIG_PLL2_CR0_FBDIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR0_FBDIV_MASK) >> APB_CONFIG_PLL2_CR0_FBDIV_SHIFT)
#define  APB_CONFIG_PLL2_CR0_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR0_FBDIV_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR0_FBDIV_SHIFT))

#define  APB_CONFIG_PLL2_CR0_REFDIV_MASK 0xf8
#define  APB_CONFIG_PLL2_CR0_REFDIV_SHIFT 3
#define  APB_CONFIG_PLL2_CR0_REFDIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR0_REFDIV_MASK) >> APB_CONFIG_PLL2_CR0_REFDIV_SHIFT)
#define  APB_CONFIG_PLL2_CR0_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR0_REFDIV_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR0_REFDIV_SHIFT))

#define  APB_CONFIG_PLL2_CR0_RESET_MASK 0x4
#define  APB_CONFIG_PLL2_CR0_RESET_SHIFT 2
#define  APB_CONFIG_PLL2_CR0_RESET_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR0_RESET_MASK) >> APB_CONFIG_PLL2_CR0_RESET_SHIFT)
#define  APB_CONFIG_PLL2_CR0_RESET_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR0_RESET_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR0_RESET_SHIFT))

#define  APB_CONFIG_PLL2_CR0_BYPASS_EN_MASK 0x2
#define  APB_CONFIG_PLL2_CR0_BYPASS_EN_SHIFT 1
#define  APB_CONFIG_PLL2_CR0_BYPASS_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR0_BYPASS_EN_MASK) >> APB_CONFIG_PLL2_CR0_BYPASS_EN_SHIFT)
#define  APB_CONFIG_PLL2_CR0_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR0_BYPASS_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR0_BYPASS_EN_SHIFT))

#define  APB_CONFIG_PLL2_CR0_PU_MASK 0x1
#define  APB_CONFIG_PLL2_CR0_PU_SHIFT 0
#define  APB_CONFIG_PLL2_CR0_PU_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR0_PU_MASK) >> APB_CONFIG_PLL2_CR0_PU_SHIFT)
#define  APB_CONFIG_PLL2_CR0_PU_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR0_PU_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR0_PU_SHIFT))

//====================================================================
//Register: PLL 2 Configuration Register 1 (PLL2_CR1)
/** \brief Configuration values for the AFE PLL.*/
//====================================================================

#define  APB_CONFIG_PLL2_CR1_TEST_MON_MASK 0xf0000000
#define  APB_CONFIG_PLL2_CR1_TEST_MON_SHIFT 28
#define  APB_CONFIG_PLL2_CR1_TEST_MON_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_TEST_MON_MASK) >> APB_CONFIG_PLL2_CR1_TEST_MON_SHIFT)
#define  APB_CONFIG_PLL2_CR1_TEST_MON_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_TEST_MON_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_TEST_MON_SHIFT))

#define  APB_CONFIG_PLL2_CR1_LINEUP_EN_MASK 0x8000000
#define  APB_CONFIG_PLL2_CR1_LINEUP_EN_SHIFT 27
#define  APB_CONFIG_PLL2_CR1_LINEUP_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_LINEUP_EN_MASK) >> APB_CONFIG_PLL2_CR1_LINEUP_EN_SHIFT)
#define  APB_CONFIG_PLL2_CR1_LINEUP_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_LINEUP_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_LINEUP_EN_SHIFT))

#define  APB_CONFIG_PLL2_CR1_CLKOUTNNP_MASK 0x4000000
#define  APB_CONFIG_PLL2_CR1_CLKOUTNNP_SHIFT 26
#define  APB_CONFIG_PLL2_CR1_CLKOUTNNP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_CLKOUTNNP_MASK) >> APB_CONFIG_PLL2_CR1_CLKOUTNNP_SHIFT)
#define  APB_CONFIG_PLL2_CR1_CLKOUTNNP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_CLKOUTNNP_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_CLKOUTNNP_SHIFT))

#define  APB_CONFIG_PLL2_CR1_DELAYLINE6_4_MASK 0x3800000
#define  APB_CONFIG_PLL2_CR1_DELAYLINE6_4_SHIFT 23
#define  APB_CONFIG_PLL2_CR1_DELAYLINE6_4_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_DELAYLINE6_4_MASK) >> APB_CONFIG_PLL2_CR1_DELAYLINE6_4_SHIFT)
#define  APB_CONFIG_PLL2_CR1_DELAYLINE6_4_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_DELAYLINE6_4_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_DELAYLINE6_4_SHIFT))

#define  APB_CONFIG_PLL2_CR1_RESERVED1_MASK 0x400000
#define  APB_CONFIG_PLL2_CR1_RESERVED1_SHIFT 22
#define  APB_CONFIG_PLL2_CR1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_RESERVED1_MASK) >> APB_CONFIG_PLL2_CR1_RESERVED1_SHIFT)
#define  APB_CONFIG_PLL2_CR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_RESERVED1_SHIFT))

#define  APB_CONFIG_PLL2_CR1_GATE_CLK_CTRL_MASK 0x200000
#define  APB_CONFIG_PLL2_CR1_GATE_CLK_CTRL_SHIFT 21
#define  APB_CONFIG_PLL2_CR1_GATE_CLK_CTRL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_GATE_CLK_CTRL_MASK) >> APB_CONFIG_PLL2_CR1_GATE_CLK_CTRL_SHIFT)
#define  APB_CONFIG_PLL2_CR1_GATE_CLK_CTRL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_GATE_CLK_CTRL_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_GATE_CLK_CTRL_SHIFT))

#define  APB_CONFIG_PLL2_CR1_RESERVE_MASK 0x180000
#define  APB_CONFIG_PLL2_CR1_RESERVE_SHIFT 19
#define  APB_CONFIG_PLL2_CR1_RESERVE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_RESERVE_MASK) >> APB_CONFIG_PLL2_CR1_RESERVE_SHIFT)
#define  APB_CONFIG_PLL2_CR1_RESERVE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_RESERVE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_RESERVE_SHIFT))

#define  APB_CONFIG_PLL2_CR1_DIFFCLK_EN_MASK 0x40000
#define  APB_CONFIG_PLL2_CR1_DIFFCLK_EN_SHIFT 18
#define  APB_CONFIG_PLL2_CR1_DIFFCLK_EN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_DIFFCLK_EN_MASK) >> APB_CONFIG_PLL2_CR1_DIFFCLK_EN_SHIFT)
#define  APB_CONFIG_PLL2_CR1_DIFFCLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_DIFFCLK_EN_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_DIFFCLK_EN_SHIFT))

#define  APB_CONFIG_PLL2_CR1_RESERVED2_MASK 0x20000
#define  APB_CONFIG_PLL2_CR1_RESERVED2_SHIFT 17
#define  APB_CONFIG_PLL2_CR1_RESERVED2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_RESERVED2_MASK) >> APB_CONFIG_PLL2_CR1_RESERVED2_SHIFT)
#define  APB_CONFIG_PLL2_CR1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_RESERVED2_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_RESERVED2_SHIFT))

#define  APB_CONFIG_PLL2_CR1_VREG_IVREF_MASK 0x18000
#define  APB_CONFIG_PLL2_CR1_VREG_IVREF_SHIFT 15
#define  APB_CONFIG_PLL2_CR1_VREG_IVREF_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_VREG_IVREF_MASK) >> APB_CONFIG_PLL2_CR1_VREG_IVREF_SHIFT)
#define  APB_CONFIG_PLL2_CR1_VREG_IVREF_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_VREG_IVREF_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_VREG_IVREF_SHIFT))

#define  APB_CONFIG_PLL2_CR1_VDDL_MASK 0x7800
#define  APB_CONFIG_PLL2_CR1_VDDL_SHIFT 11
#define  APB_CONFIG_PLL2_CR1_VDDL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_VDDL_MASK) >> APB_CONFIG_PLL2_CR1_VDDL_SHIFT)
#define  APB_CONFIG_PLL2_CR1_VDDL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_VDDL_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_VDDL_SHIFT))

#define  APB_CONFIG_PLL2_CR1_VDDM_MASK 0x600
#define  APB_CONFIG_PLL2_CR1_VDDM_SHIFT 9
#define  APB_CONFIG_PLL2_CR1_VDDM_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_VDDM_MASK) >> APB_CONFIG_PLL2_CR1_VDDM_SHIFT)
#define  APB_CONFIG_PLL2_CR1_VDDM_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_VDDM_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_VDDM_SHIFT))

#define  APB_CONFIG_PLL2_CR1_DELAYLINE3_0_MASK 0x1e0
#define  APB_CONFIG_PLL2_CR1_DELAYLINE3_0_SHIFT 5
#define  APB_CONFIG_PLL2_CR1_DELAYLINE3_0_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_DELAYLINE3_0_MASK) >> APB_CONFIG_PLL2_CR1_DELAYLINE3_0_SHIFT)
#define  APB_CONFIG_PLL2_CR1_DELAYLINE3_0_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_DELAYLINE3_0_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_DELAYLINE3_0_SHIFT))

#define  APB_CONFIG_PLL2_CR1_ICP_MASK 0x1c
#define  APB_CONFIG_PLL2_CR1_ICP_SHIFT 2
#define  APB_CONFIG_PLL2_CR1_ICP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_ICP_MASK) >> APB_CONFIG_PLL2_CR1_ICP_SHIFT)
#define  APB_CONFIG_PLL2_CR1_ICP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_ICP_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_ICP_SHIFT))

#define  APB_CONFIG_PLL2_CR1_CTUNE_MASK 0x3
#define  APB_CONFIG_PLL2_CR1_CTUNE_SHIFT 0
#define  APB_CONFIG_PLL2_CR1_CTUNE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_CR1_CTUNE_MASK) >> APB_CONFIG_PLL2_CR1_CTUNE_SHIFT)
#define  APB_CONFIG_PLL2_CR1_CTUNE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_CR1_CTUNE_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_CR1_CTUNE_SHIFT))

//====================================================================
//Register: PLL 2 Status Register (PLL2_SR)
/** \brief The PLL Status Register contains the "lock" indicator from the AFE PLL.*/
//====================================================================

#define  APB_CONFIG_PLL2_SR_RESERVED1_MASK 0xfffffffe
#define  APB_CONFIG_PLL2_SR_RESERVED1_SHIFT 1
#define  APB_CONFIG_PLL2_SR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_SR_RESERVED1_MASK) >> APB_CONFIG_PLL2_SR_RESERVED1_SHIFT)
#define  APB_CONFIG_PLL2_SR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_SR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_SR_RESERVED1_SHIFT))

#define  APB_CONFIG_PLL2_SR_LOCK_MASK 0x1
#define  APB_CONFIG_PLL2_SR_LOCK_SHIFT 0
#define  APB_CONFIG_PLL2_SR_LOCK_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PLL2_SR_LOCK_MASK) >> APB_CONFIG_PLL2_SR_LOCK_SHIFT)
#define  APB_CONFIG_PLL2_SR_LOCK_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PLL2_SR_LOCK_MASK) | (((uint32_t)val) << APB_CONFIG_PLL2_SR_LOCK_SHIFT))

//====================================================================
//Register: Clock Divider Configuration Register 1 (CDCR1)
/** \brief Clock Divider Configuration Register 1 contains the dividors to generate clocks from the dithering PLL0.
       This register also controls selection of SCAN Clock and LVDSAFE_VCAP Clock sources for
       the respective output clocks.*/
//====================================================================

#define  APB_CONFIG_CDCR1_RESERVED1_MASK 0xfc000000
#define  APB_CONFIG_CDCR1_RESERVED1_SHIFT 26
#define  APB_CONFIG_CDCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_CDCR1_RESERVED1_MASK) >> APB_CONFIG_CDCR1_RESERVED1_SHIFT)
#define  APB_CONFIG_CDCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_CDCR1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_CDCR1_RESERVED1_SHIFT))

#define  APB_CONFIG_CDCR1_DAADIV_MASK 0x3fc0000
#define  APB_CONFIG_CDCR1_DAADIV_SHIFT 18
#define  APB_CONFIG_CDCR1_DAADIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_CDCR1_DAADIV_MASK) >> APB_CONFIG_CDCR1_DAADIV_SHIFT)
#define  APB_CONFIG_CDCR1_DAADIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_CDCR1_DAADIV_MASK) | (((uint32_t)val) << APB_CONFIG_CDCR1_DAADIV_SHIFT))

#define  APB_CONFIG_CDCR1_SDMMCDIV_MASK 0x3e000
#define  APB_CONFIG_CDCR1_SDMMCDIV_SHIFT 13
#define  APB_CONFIG_CDCR1_SDMMCDIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_CDCR1_SDMMCDIV_MASK) >> APB_CONFIG_CDCR1_SDMMCDIV_SHIFT)
#define  APB_CONFIG_CDCR1_SDMMCDIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_CDCR1_SDMMCDIV_MASK) | (((uint32_t)val) << APB_CONFIG_CDCR1_SDMMCDIV_SHIFT))

#define  APB_CONFIG_CDCR1_XIODIV_MASK 0x1f00
#define  APB_CONFIG_CDCR1_XIODIV_SHIFT 8
#define  APB_CONFIG_CDCR1_XIODIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_CDCR1_XIODIV_MASK) >> APB_CONFIG_CDCR1_XIODIV_SHIFT)
#define  APB_CONFIG_CDCR1_XIODIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_CDCR1_XIODIV_MASK) | (((uint32_t)val) << APB_CONFIG_CDCR1_XIODIV_SHIFT))

#define  APB_CONFIG_CDCR1_XCPUDIV_MASK 0xe0
#define  APB_CONFIG_CDCR1_XCPUDIV_SHIFT 5
#define  APB_CONFIG_CDCR1_XCPUDIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_CDCR1_XCPUDIV_MASK) >> APB_CONFIG_CDCR1_XCPUDIV_SHIFT)
#define  APB_CONFIG_CDCR1_XCPUDIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_CDCR1_XCPUDIV_MASK) | (((uint32_t)val) << APB_CONFIG_CDCR1_XCPUDIV_SHIFT))

#define  APB_CONFIG_CDCR1_BUSDIV_MASK 0x1c
#define  APB_CONFIG_CDCR1_BUSDIV_SHIFT 2
#define  APB_CONFIG_CDCR1_BUSDIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_CDCR1_BUSDIV_MASK) >> APB_CONFIG_CDCR1_BUSDIV_SHIFT)
#define  APB_CONFIG_CDCR1_BUSDIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_CDCR1_BUSDIV_MASK) | (((uint32_t)val) << APB_CONFIG_CDCR1_BUSDIV_SHIFT))

#define  APB_CONFIG_CDCR1_DDRDIV_MASK 0x3
#define  APB_CONFIG_CDCR1_DDRDIV_SHIFT 0
#define  APB_CONFIG_CDCR1_DDRDIV_MASK_SHIFT(reg) (((reg) & APB_CONFIG_CDCR1_DDRDIV_MASK) >> APB_CONFIG_CDCR1_DDRDIV_SHIFT)
#define  APB_CONFIG_CDCR1_DDRDIV_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_CDCR1_DDRDIV_MASK) | (((uint32_t)val) << APB_CONFIG_CDCR1_DDRDIV_SHIFT))

//====================================================================
//Register: Powerdown Configuration Register (PWCR)
/** \brief The Powerdown Configuration Register allows various global clocks, memories, and i/o pads inside the ASIC to be powered down under firmware control, to save power when the parts of the ASIC that use them are not in use. The affected blocks must be idle before their clocks are stopped. Stopping a clock also powers down all memories within the affected blocks. Some blocks have separate memory powerdown bits because their clocks can not be stopped. Memories retain their contents when powered down.*/
//====================================================================

#define  APB_CONFIG_PWCR_PDLVMC_MASK 0x80000000
#define  APB_CONFIG_PWCR_PDLVMC_SHIFT 31
#define  APB_CONFIG_PWCR_PDLVMC_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_PDLVMC_MASK) >> APB_CONFIG_PWCR_PDLVMC_SHIFT)
#define  APB_CONFIG_PWCR_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_PDLVMC_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_PDLVMC_SHIFT))

#define  APB_CONFIG_PWCR_POR_PDWN_MASK 0x40000000
#define  APB_CONFIG_PWCR_POR_PDWN_SHIFT 30
#define  APB_CONFIG_PWCR_POR_PDWN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_POR_PDWN_MASK) >> APB_CONFIG_PWCR_POR_PDWN_SHIFT)
#define  APB_CONFIG_PWCR_POR_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_POR_PDWN_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_POR_PDWN_SHIFT))

#define  APB_CONFIG_PWCR_EROM_MEM_PDWN_MASK 0x20000000
#define  APB_CONFIG_PWCR_EROM_MEM_PDWN_SHIFT 29
#define  APB_CONFIG_PWCR_EROM_MEM_PDWN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_EROM_MEM_PDWN_MASK) >> APB_CONFIG_PWCR_EROM_MEM_PDWN_SHIFT)
#define  APB_CONFIG_PWCR_EROM_MEM_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_EROM_MEM_PDWN_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_EROM_MEM_PDWN_SHIFT))

#define  APB_CONFIG_PWCR_USB_MEM_PDWN_MASK 0x1c000000
#define  APB_CONFIG_PWCR_USB_MEM_PDWN_SHIFT 26
#define  APB_CONFIG_PWCR_USB_MEM_PDWN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_USB_MEM_PDWN_MASK) >> APB_CONFIG_PWCR_USB_MEM_PDWN_SHIFT)
#define  APB_CONFIG_PWCR_USB_MEM_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_USB_MEM_PDWN_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_USB_MEM_PDWN_SHIFT))

#define  APB_CONFIG_PWCR_LCM_MEM_PDWN_MASK 0x2000000
#define  APB_CONFIG_PWCR_LCM_MEM_PDWN_SHIFT 25
#define  APB_CONFIG_PWCR_LCM_MEM_PDWN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_LCM_MEM_PDWN_MASK) >> APB_CONFIG_PWCR_LCM_MEM_PDWN_SHIFT)
#define  APB_CONFIG_PWCR_LCM_MEM_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_LCM_MEM_PDWN_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_LCM_MEM_PDWN_SHIFT))

#define  APB_CONFIG_PWCR_SCCP_MEM_PDWN_MASK 0x1000000
#define  APB_CONFIG_PWCR_SCCP_MEM_PDWN_SHIFT 24
#define  APB_CONFIG_PWCR_SCCP_MEM_PDWN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_SCCP_MEM_PDWN_MASK) >> APB_CONFIG_PWCR_SCCP_MEM_PDWN_SHIFT)
#define  APB_CONFIG_PWCR_SCCP_MEM_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_SCCP_MEM_PDWN_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_SCCP_MEM_PDWN_SHIFT))

#define  APB_CONFIG_PWCR_ANTIC_MEM_PDWN_MASK 0x800000
#define  APB_CONFIG_PWCR_ANTIC_MEM_PDWN_SHIFT 23
#define  APB_CONFIG_PWCR_ANTIC_MEM_PDWN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_ANTIC_MEM_PDWN_MASK) >> APB_CONFIG_PWCR_ANTIC_MEM_PDWN_SHIFT)
#define  APB_CONFIG_PWCR_ANTIC_MEM_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_ANTIC_MEM_PDWN_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_ANTIC_MEM_PDWN_SHIFT))

#define  APB_CONFIG_PWCR_ASELA_MEM_PDWN_MASK 0x400000
#define  APB_CONFIG_PWCR_ASELA_MEM_PDWN_SHIFT 22
#define  APB_CONFIG_PWCR_ASELA_MEM_PDWN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_ASELA_MEM_PDWN_MASK) >> APB_CONFIG_PWCR_ASELA_MEM_PDWN_SHIFT)
#define  APB_CONFIG_PWCR_ASELA_MEM_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_ASELA_MEM_PDWN_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_ASELA_MEM_PDWN_SHIFT))

#define  APB_CONFIG_PWCR_RESERVED1_MASK 0x3ff800
#define  APB_CONFIG_PWCR_RESERVED1_SHIFT 11
#define  APB_CONFIG_PWCR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_RESERVED1_MASK) >> APB_CONFIG_PWCR_RESERVED1_SHIFT)
#define  APB_CONFIG_PWCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_RESERVED1_SHIFT))

#define  APB_CONFIG_PWCR_MVDOCLK_STOP_MASK 0x400
#define  APB_CONFIG_PWCR_MVDOCLK_STOP_SHIFT 10
#define  APB_CONFIG_PWCR_MVDOCLK_STOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_MVDOCLK_STOP_MASK) >> APB_CONFIG_PWCR_MVDOCLK_STOP_SHIFT)
#define  APB_CONFIG_PWCR_MVDOCLK_STOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_MVDOCLK_STOP_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_MVDOCLK_STOP_SHIFT))

#define  APB_CONFIG_PWCR_NANDSDCLK_STOP_MASK 0x200
#define  APB_CONFIG_PWCR_NANDSDCLK_STOP_SHIFT 9
#define  APB_CONFIG_PWCR_NANDSDCLK_STOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_NANDSDCLK_STOP_MASK) >> APB_CONFIG_PWCR_NANDSDCLK_STOP_SHIFT)
#define  APB_CONFIG_PWCR_NANDSDCLK_STOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_NANDSDCLK_STOP_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_NANDSDCLK_STOP_SHIFT))

#define  APB_CONFIG_PWCR_LCDCLK_STOP_MASK 0x100
#define  APB_CONFIG_PWCR_LCDCLK_STOP_SHIFT 8
#define  APB_CONFIG_PWCR_LCDCLK_STOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_LCDCLK_STOP_MASK) >> APB_CONFIG_PWCR_LCDCLK_STOP_SHIFT)
#define  APB_CONFIG_PWCR_LCDCLK_STOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_LCDCLK_STOP_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_LCDCLK_STOP_SHIFT))

#define  APB_CONFIG_PWCR_DAACLK_STOP_MASK 0x80
#define  APB_CONFIG_PWCR_DAACLK_STOP_SHIFT 7
#define  APB_CONFIG_PWCR_DAACLK_STOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_DAACLK_STOP_MASK) >> APB_CONFIG_PWCR_DAACLK_STOP_SHIFT)
#define  APB_CONFIG_PWCR_DAACLK_STOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_DAACLK_STOP_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_DAACLK_STOP_SHIFT))

#define  APB_CONFIG_PWCR_PCIECLK_STOP_MASK 0x40
#define  APB_CONFIG_PWCR_PCIECLK_STOP_SHIFT 6
#define  APB_CONFIG_PWCR_PCIECLK_STOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_PCIECLK_STOP_MASK) >> APB_CONFIG_PWCR_PCIECLK_STOP_SHIFT)
#define  APB_CONFIG_PWCR_PCIECLK_STOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_PCIECLK_STOP_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_PCIECLK_STOP_SHIFT))

#define  APB_CONFIG_PWCR_LANCLK_STOP_MASK 0x20
#define  APB_CONFIG_PWCR_LANCLK_STOP_SHIFT 5
#define  APB_CONFIG_PWCR_LANCLK_STOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_LANCLK_STOP_MASK) >> APB_CONFIG_PWCR_LANCLK_STOP_SHIFT)
#define  APB_CONFIG_PWCR_LANCLK_STOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_LANCLK_STOP_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_LANCLK_STOP_SHIFT))

#define  APB_CONFIG_PWCR_IMAGINGCLK_STOP_MASK 0x10
#define  APB_CONFIG_PWCR_IMAGINGCLK_STOP_SHIFT 4
#define  APB_CONFIG_PWCR_IMAGINGCLK_STOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_IMAGINGCLK_STOP_MASK) >> APB_CONFIG_PWCR_IMAGINGCLK_STOP_SHIFT)
#define  APB_CONFIG_PWCR_IMAGINGCLK_STOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_IMAGINGCLK_STOP_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_IMAGINGCLK_STOP_SHIFT))

#define  APB_CONFIG_PWCR_UPCCLK_STOP_MASK 0x8
#define  APB_CONFIG_PWCR_UPCCLK_STOP_SHIFT 3
#define  APB_CONFIG_PWCR_UPCCLK_STOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_UPCCLK_STOP_MASK) >> APB_CONFIG_PWCR_UPCCLK_STOP_SHIFT)
#define  APB_CONFIG_PWCR_UPCCLK_STOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_UPCCLK_STOP_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_UPCCLK_STOP_SHIFT))

#define  APB_CONFIG_PWCR_DDRCLK_STOP_MASK 0x4
#define  APB_CONFIG_PWCR_DDRCLK_STOP_SHIFT 2
#define  APB_CONFIG_PWCR_DDRCLK_STOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_DDRCLK_STOP_MASK) >> APB_CONFIG_PWCR_DDRCLK_STOP_SHIFT)
#define  APB_CONFIG_PWCR_DDRCLK_STOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_DDRCLK_STOP_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_DDRCLK_STOP_SHIFT))

#define  APB_CONFIG_PWCR_L2CCLK_STOP_MASK 0x2
#define  APB_CONFIG_PWCR_L2CCLK_STOP_SHIFT 1
#define  APB_CONFIG_PWCR_L2CCLK_STOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_L2CCLK_STOP_MASK) >> APB_CONFIG_PWCR_L2CCLK_STOP_SHIFT)
#define  APB_CONFIG_PWCR_L2CCLK_STOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_L2CCLK_STOP_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_L2CCLK_STOP_SHIFT))

#define  APB_CONFIG_PWCR_CPUCLK_STOP_MASK 0x1
#define  APB_CONFIG_PWCR_CPUCLK_STOP_SHIFT 0
#define  APB_CONFIG_PWCR_CPUCLK_STOP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PWCR_CPUCLK_STOP_MASK) >> APB_CONFIG_PWCR_CPUCLK_STOP_SHIFT)
#define  APB_CONFIG_PWCR_CPUCLK_STOP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PWCR_CPUCLK_STOP_MASK) | (((uint32_t)val) << APB_CONFIG_PWCR_CPUCLK_STOP_SHIFT))

//====================================================================
//Register: Power Island Configuration Register (PICR)
/** \brief <p>The Power Island Configuration Register (PICR) and the Power Island Status Register (PISR) control internal power switches for on-chip power islands. When power to a island is switched off the blocks in it are unactive and consume zero power. When the power is switched back on, the blocks get a complete hardware reset to return them to their default power-on state. This register is "locked" when PI_LOCK is not 0x0 or PI_UNLOCK is not 0x3. Then values written still stored but they have no effect and are not reflected in the PISR. Locking the register when not doing power switching operations provides some protection against spurious register writes.</p>
        To switch off an island:<br/>
        <ul>
        <li>Disable the clock to the island in the PWCR.</li>
        <li>Set PI_LOCK=0 and PI_UNLOCK=3</li>
        <li>Set the ISOLATE bit</li>
        <li>Set the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=1</li>
        <li>Set the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=1</li>
        <li>Set PI_LOCK=3 and PI_UNLOCK=0</li></ul>
        To switch an island back on:
        <ul>
        <li>Set the RESET bit</li>
        <li>Set PI_LOCK=0 and PI_UNLOCK=3</li>
        <li>Clear the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=0</li>
        <li>Clear the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=0</li>
        <li>Enable the clock to the island in the PWCR (to propagate the reset)</li>
        <li>Disable the clock to the island in the PWCR.</li>
        <li>Clear RESET bit</li>
        <li>Clear ISOLATE bit</li>
        <li>Set PI_LOCK=3 and PI_UNLOCK=0</li>
        <li>Enable the clock for the island in the PWCR.</li></ul>
        Only switch one island at a time, to avoid high surge currents that which cause a malfunction.*/
//====================================================================

#define  APB_CONFIG_PICR_PI_UNLOCK_MASK 0xc0000000
#define  APB_CONFIG_PICR_PI_UNLOCK_SHIFT 30
#define  APB_CONFIG_PICR_PI_UNLOCK_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_PI_UNLOCK_MASK) >> APB_CONFIG_PICR_PI_UNLOCK_SHIFT)
#define  APB_CONFIG_PICR_PI_UNLOCK_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_PI_UNLOCK_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_PI_UNLOCK_SHIFT))

#define  APB_CONFIG_PICR_PI_LOCK_MASK 0x30000000
#define  APB_CONFIG_PICR_PI_LOCK_SHIFT 28
#define  APB_CONFIG_PICR_PI_LOCK_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_PI_LOCK_MASK) >> APB_CONFIG_PICR_PI_LOCK_SHIFT)
#define  APB_CONFIG_PICR_PI_LOCK_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_PI_LOCK_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_PI_LOCK_SHIFT))

#define  APB_CONFIG_PICR_RESERVED1_MASK 0xfff8000
#define  APB_CONFIG_PICR_RESERVED1_SHIFT 15
#define  APB_CONFIG_PICR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_RESERVED1_MASK) >> APB_CONFIG_PICR_RESERVED1_SHIFT)
#define  APB_CONFIG_PICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_RESERVED1_SHIFT))

#define  APB_CONFIG_PICR_IMAGING_RESET_MASK 0x4000
#define  APB_CONFIG_PICR_IMAGING_RESET_SHIFT 14
#define  APB_CONFIG_PICR_IMAGING_RESET_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_IMAGING_RESET_MASK) >> APB_CONFIG_PICR_IMAGING_RESET_SHIFT)
#define  APB_CONFIG_PICR_IMAGING_RESET_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_IMAGING_RESET_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_IMAGING_RESET_SHIFT))

#define  APB_CONFIG_PICR_UPC_RESET_MASK 0x2000
#define  APB_CONFIG_PICR_UPC_RESET_SHIFT 13
#define  APB_CONFIG_PICR_UPC_RESET_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_UPC_RESET_MASK) >> APB_CONFIG_PICR_UPC_RESET_SHIFT)
#define  APB_CONFIG_PICR_UPC_RESET_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_UPC_RESET_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_UPC_RESET_SHIFT))

#define  APB_CONFIG_PICR_CPU_RESET_MASK 0x1000
#define  APB_CONFIG_PICR_CPU_RESET_SHIFT 12
#define  APB_CONFIG_PICR_CPU_RESET_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_CPU_RESET_MASK) >> APB_CONFIG_PICR_CPU_RESET_SHIFT)
#define  APB_CONFIG_PICR_CPU_RESET_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_CPU_RESET_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_CPU_RESET_SHIFT))

#define  APB_CONFIG_PICR_RESERVED2_MASK 0x800
#define  APB_CONFIG_PICR_RESERVED2_SHIFT 11
#define  APB_CONFIG_PICR_RESERVED2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_RESERVED2_MASK) >> APB_CONFIG_PICR_RESERVED2_SHIFT)
#define  APB_CONFIG_PICR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_RESERVED2_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_RESERVED2_SHIFT))

#define  APB_CONFIG_PICR_IMAGING_SLEEP2_MASK 0x400
#define  APB_CONFIG_PICR_IMAGING_SLEEP2_SHIFT 10
#define  APB_CONFIG_PICR_IMAGING_SLEEP2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_IMAGING_SLEEP2_MASK) >> APB_CONFIG_PICR_IMAGING_SLEEP2_SHIFT)
#define  APB_CONFIG_PICR_IMAGING_SLEEP2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_IMAGING_SLEEP2_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_IMAGING_SLEEP2_SHIFT))

#define  APB_CONFIG_PICR_UPC_SLEEP2_MASK 0x200
#define  APB_CONFIG_PICR_UPC_SLEEP2_SHIFT 9
#define  APB_CONFIG_PICR_UPC_SLEEP2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_UPC_SLEEP2_MASK) >> APB_CONFIG_PICR_UPC_SLEEP2_SHIFT)
#define  APB_CONFIG_PICR_UPC_SLEEP2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_UPC_SLEEP2_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_UPC_SLEEP2_SHIFT))

#define  APB_CONFIG_PICR_CPU_SLEEP2_MASK 0x100
#define  APB_CONFIG_PICR_CPU_SLEEP2_SHIFT 8
#define  APB_CONFIG_PICR_CPU_SLEEP2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_CPU_SLEEP2_MASK) >> APB_CONFIG_PICR_CPU_SLEEP2_SHIFT)
#define  APB_CONFIG_PICR_CPU_SLEEP2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_CPU_SLEEP2_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_CPU_SLEEP2_SHIFT))

#define  APB_CONFIG_PICR_RESERVED3_MASK 0x80
#define  APB_CONFIG_PICR_RESERVED3_SHIFT 7
#define  APB_CONFIG_PICR_RESERVED3_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_RESERVED3_MASK) >> APB_CONFIG_PICR_RESERVED3_SHIFT)
#define  APB_CONFIG_PICR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_RESERVED3_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_RESERVED3_SHIFT))

#define  APB_CONFIG_PICR_IMAGING_SLEEP1_MASK 0x40
#define  APB_CONFIG_PICR_IMAGING_SLEEP1_SHIFT 6
#define  APB_CONFIG_PICR_IMAGING_SLEEP1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_IMAGING_SLEEP1_MASK) >> APB_CONFIG_PICR_IMAGING_SLEEP1_SHIFT)
#define  APB_CONFIG_PICR_IMAGING_SLEEP1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_IMAGING_SLEEP1_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_IMAGING_SLEEP1_SHIFT))

#define  APB_CONFIG_PICR_UPC_SLEEP1_MASK 0x20
#define  APB_CONFIG_PICR_UPC_SLEEP1_SHIFT 5
#define  APB_CONFIG_PICR_UPC_SLEEP1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_UPC_SLEEP1_MASK) >> APB_CONFIG_PICR_UPC_SLEEP1_SHIFT)
#define  APB_CONFIG_PICR_UPC_SLEEP1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_UPC_SLEEP1_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_UPC_SLEEP1_SHIFT))

#define  APB_CONFIG_PICR_CPU_SLEEP1_MASK 0x10
#define  APB_CONFIG_PICR_CPU_SLEEP1_SHIFT 4
#define  APB_CONFIG_PICR_CPU_SLEEP1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_CPU_SLEEP1_MASK) >> APB_CONFIG_PICR_CPU_SLEEP1_SHIFT)
#define  APB_CONFIG_PICR_CPU_SLEEP1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_CPU_SLEEP1_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_CPU_SLEEP1_SHIFT))

#define  APB_CONFIG_PICR_RESERVED4_MASK 0x8
#define  APB_CONFIG_PICR_RESERVED4_SHIFT 3
#define  APB_CONFIG_PICR_RESERVED4_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_RESERVED4_MASK) >> APB_CONFIG_PICR_RESERVED4_SHIFT)
#define  APB_CONFIG_PICR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_RESERVED4_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_RESERVED4_SHIFT))

#define  APB_CONFIG_PICR_IMAGING_ISOLATE_MASK 0x4
#define  APB_CONFIG_PICR_IMAGING_ISOLATE_SHIFT 2
#define  APB_CONFIG_PICR_IMAGING_ISOLATE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_IMAGING_ISOLATE_MASK) >> APB_CONFIG_PICR_IMAGING_ISOLATE_SHIFT)
#define  APB_CONFIG_PICR_IMAGING_ISOLATE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_IMAGING_ISOLATE_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_IMAGING_ISOLATE_SHIFT))

#define  APB_CONFIG_PICR_UPC_ISOLATE_MASK 0x2
#define  APB_CONFIG_PICR_UPC_ISOLATE_SHIFT 1
#define  APB_CONFIG_PICR_UPC_ISOLATE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_UPC_ISOLATE_MASK) >> APB_CONFIG_PICR_UPC_ISOLATE_SHIFT)
#define  APB_CONFIG_PICR_UPC_ISOLATE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_UPC_ISOLATE_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_UPC_ISOLATE_SHIFT))

#define  APB_CONFIG_PICR_CPU_ISOLATE_MASK 0x1
#define  APB_CONFIG_PICR_CPU_ISOLATE_SHIFT 0
#define  APB_CONFIG_PICR_CPU_ISOLATE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PICR_CPU_ISOLATE_MASK) >> APB_CONFIG_PICR_CPU_ISOLATE_SHIFT)
#define  APB_CONFIG_PICR_CPU_ISOLATE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PICR_CPU_ISOLATE_MASK) | (((uint32_t)val) << APB_CONFIG_PICR_CPU_ISOLATE_SHIFT))

//====================================================================
//Register: Power Island Status Register (PISR)
/** \brief The Power Island Status Register contains the current state of the power switch controls. It is identical to the contents of the PICR except when the state is changing, or when a spurious value has been written to the PICR when it is locked.*/
//====================================================================

#define  APB_CONFIG_PISR_PI_UNLOCK_MASK 0xc0000000
#define  APB_CONFIG_PISR_PI_UNLOCK_SHIFT 30
#define  APB_CONFIG_PISR_PI_UNLOCK_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_PI_UNLOCK_MASK) >> APB_CONFIG_PISR_PI_UNLOCK_SHIFT)
#define  APB_CONFIG_PISR_PI_UNLOCK_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_PI_UNLOCK_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_PI_UNLOCK_SHIFT))

#define  APB_CONFIG_PISR_PI_LOCK_MASK 0x30000000
#define  APB_CONFIG_PISR_PI_LOCK_SHIFT 28
#define  APB_CONFIG_PISR_PI_LOCK_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_PI_LOCK_MASK) >> APB_CONFIG_PISR_PI_LOCK_SHIFT)
#define  APB_CONFIG_PISR_PI_LOCK_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_PI_LOCK_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_PI_LOCK_SHIFT))

#define  APB_CONFIG_PISR_RESERVED1_MASK 0xfff8000
#define  APB_CONFIG_PISR_RESERVED1_SHIFT 15
#define  APB_CONFIG_PISR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_RESERVED1_MASK) >> APB_CONFIG_PISR_RESERVED1_SHIFT)
#define  APB_CONFIG_PISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_RESERVED1_SHIFT))

#define  APB_CONFIG_PISR_IMAGING_RESET_MASK 0x4000
#define  APB_CONFIG_PISR_IMAGING_RESET_SHIFT 14
#define  APB_CONFIG_PISR_IMAGING_RESET_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_IMAGING_RESET_MASK) >> APB_CONFIG_PISR_IMAGING_RESET_SHIFT)
#define  APB_CONFIG_PISR_IMAGING_RESET_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_IMAGING_RESET_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_IMAGING_RESET_SHIFT))

#define  APB_CONFIG_PISR_UPC_RESET_MASK 0x2000
#define  APB_CONFIG_PISR_UPC_RESET_SHIFT 13
#define  APB_CONFIG_PISR_UPC_RESET_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_UPC_RESET_MASK) >> APB_CONFIG_PISR_UPC_RESET_SHIFT)
#define  APB_CONFIG_PISR_UPC_RESET_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_UPC_RESET_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_UPC_RESET_SHIFT))

#define  APB_CONFIG_PISR_CPU_RESET_MASK 0x1000
#define  APB_CONFIG_PISR_CPU_RESET_SHIFT 12
#define  APB_CONFIG_PISR_CPU_RESET_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_CPU_RESET_MASK) >> APB_CONFIG_PISR_CPU_RESET_SHIFT)
#define  APB_CONFIG_PISR_CPU_RESET_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_CPU_RESET_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_CPU_RESET_SHIFT))

#define  APB_CONFIG_PISR_RESERVED2_MASK 0x800
#define  APB_CONFIG_PISR_RESERVED2_SHIFT 11
#define  APB_CONFIG_PISR_RESERVED2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_RESERVED2_MASK) >> APB_CONFIG_PISR_RESERVED2_SHIFT)
#define  APB_CONFIG_PISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_RESERVED2_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_RESERVED2_SHIFT))

#define  APB_CONFIG_PISR_IMAGING_SLEEP2_MASK 0x400
#define  APB_CONFIG_PISR_IMAGING_SLEEP2_SHIFT 10
#define  APB_CONFIG_PISR_IMAGING_SLEEP2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_IMAGING_SLEEP2_MASK) >> APB_CONFIG_PISR_IMAGING_SLEEP2_SHIFT)
#define  APB_CONFIG_PISR_IMAGING_SLEEP2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_IMAGING_SLEEP2_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_IMAGING_SLEEP2_SHIFT))

#define  APB_CONFIG_PISR_UPC_SLEEP2_MASK 0x200
#define  APB_CONFIG_PISR_UPC_SLEEP2_SHIFT 9
#define  APB_CONFIG_PISR_UPC_SLEEP2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_UPC_SLEEP2_MASK) >> APB_CONFIG_PISR_UPC_SLEEP2_SHIFT)
#define  APB_CONFIG_PISR_UPC_SLEEP2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_UPC_SLEEP2_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_UPC_SLEEP2_SHIFT))

#define  APB_CONFIG_PISR_CPU_SLEEP2_MASK 0x100
#define  APB_CONFIG_PISR_CPU_SLEEP2_SHIFT 8
#define  APB_CONFIG_PISR_CPU_SLEEP2_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_CPU_SLEEP2_MASK) >> APB_CONFIG_PISR_CPU_SLEEP2_SHIFT)
#define  APB_CONFIG_PISR_CPU_SLEEP2_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_CPU_SLEEP2_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_CPU_SLEEP2_SHIFT))

#define  APB_CONFIG_PISR_RESERVED3_MASK 0x80
#define  APB_CONFIG_PISR_RESERVED3_SHIFT 7
#define  APB_CONFIG_PISR_RESERVED3_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_RESERVED3_MASK) >> APB_CONFIG_PISR_RESERVED3_SHIFT)
#define  APB_CONFIG_PISR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_RESERVED3_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_RESERVED3_SHIFT))

#define  APB_CONFIG_PISR_IMAGING_SLEEP1_MASK 0x40
#define  APB_CONFIG_PISR_IMAGING_SLEEP1_SHIFT 6
#define  APB_CONFIG_PISR_IMAGING_SLEEP1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_IMAGING_SLEEP1_MASK) >> APB_CONFIG_PISR_IMAGING_SLEEP1_SHIFT)
#define  APB_CONFIG_PISR_IMAGING_SLEEP1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_IMAGING_SLEEP1_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_IMAGING_SLEEP1_SHIFT))

#define  APB_CONFIG_PISR_UPC_SLEEP1_MASK 0x20
#define  APB_CONFIG_PISR_UPC_SLEEP1_SHIFT 5
#define  APB_CONFIG_PISR_UPC_SLEEP1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_UPC_SLEEP1_MASK) >> APB_CONFIG_PISR_UPC_SLEEP1_SHIFT)
#define  APB_CONFIG_PISR_UPC_SLEEP1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_UPC_SLEEP1_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_UPC_SLEEP1_SHIFT))

#define  APB_CONFIG_PISR_CPU_SLEEP1_MASK 0x10
#define  APB_CONFIG_PISR_CPU_SLEEP1_SHIFT 4
#define  APB_CONFIG_PISR_CPU_SLEEP1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_CPU_SLEEP1_MASK) >> APB_CONFIG_PISR_CPU_SLEEP1_SHIFT)
#define  APB_CONFIG_PISR_CPU_SLEEP1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_CPU_SLEEP1_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_CPU_SLEEP1_SHIFT))

#define  APB_CONFIG_PISR_RESERVED4_MASK 0x8
#define  APB_CONFIG_PISR_RESERVED4_SHIFT 3
#define  APB_CONFIG_PISR_RESERVED4_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_RESERVED4_MASK) >> APB_CONFIG_PISR_RESERVED4_SHIFT)
#define  APB_CONFIG_PISR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_RESERVED4_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_RESERVED4_SHIFT))

#define  APB_CONFIG_PISR_IMAGING_ISOLATE_MASK 0x4
#define  APB_CONFIG_PISR_IMAGING_ISOLATE_SHIFT 2
#define  APB_CONFIG_PISR_IMAGING_ISOLATE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_IMAGING_ISOLATE_MASK) >> APB_CONFIG_PISR_IMAGING_ISOLATE_SHIFT)
#define  APB_CONFIG_PISR_IMAGING_ISOLATE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_IMAGING_ISOLATE_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_IMAGING_ISOLATE_SHIFT))

#define  APB_CONFIG_PISR_UPC_ISOLATE_MASK 0x2
#define  APB_CONFIG_PISR_UPC_ISOLATE_SHIFT 1
#define  APB_CONFIG_PISR_UPC_ISOLATE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_UPC_ISOLATE_MASK) >> APB_CONFIG_PISR_UPC_ISOLATE_SHIFT)
#define  APB_CONFIG_PISR_UPC_ISOLATE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_UPC_ISOLATE_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_UPC_ISOLATE_SHIFT))

#define  APB_CONFIG_PISR_CPU_ISOLATE_MASK 0x1
#define  APB_CONFIG_PISR_CPU_ISOLATE_SHIFT 0
#define  APB_CONFIG_PISR_CPU_ISOLATE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PISR_CPU_ISOLATE_MASK) >> APB_CONFIG_PISR_CPU_ISOLATE_SHIFT)
#define  APB_CONFIG_PISR_CPU_ISOLATE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PISR_CPU_ISOLATE_MASK) | (((uint32_t)val) << APB_CONFIG_PISR_CPU_ISOLATE_SHIFT))

//====================================================================
//Register: SRAM WTC/RTC Configuration Register 0 (SRCR0)
//====================================================================

#define  APB_CONFIG_SRCR0_WTCRTC_MASK 0xffffffff
#define  APB_CONFIG_SRCR0_WTCRTC_SHIFT 0
#define  APB_CONFIG_SRCR0_WTCRTC_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR0_WTCRTC_MASK) >> APB_CONFIG_SRCR0_WTCRTC_SHIFT)
#define  APB_CONFIG_SRCR0_WTCRTC_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR0_WTCRTC_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR0_WTCRTC_SHIFT))

//====================================================================
//Register: SRAM WTC/RTC Configuration Register 1 (SRCR1)
//====================================================================

#define  APB_CONFIG_SRCR1_WTCRTC_MASK 0xffffffff
#define  APB_CONFIG_SRCR1_WTCRTC_SHIFT 0
#define  APB_CONFIG_SRCR1_WTCRTC_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR1_WTCRTC_MASK) >> APB_CONFIG_SRCR1_WTCRTC_SHIFT)
#define  APB_CONFIG_SRCR1_WTCRTC_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR1_WTCRTC_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR1_WTCRTC_SHIFT))

//====================================================================
//Register: SRAM WTC/RTC Configuration Register 2 (SRCR2)
//====================================================================

#define  APB_CONFIG_SRCR2_WTCRTC_MASK 0xffffffff
#define  APB_CONFIG_SRCR2_WTCRTC_SHIFT 0
#define  APB_CONFIG_SRCR2_WTCRTC_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR2_WTCRTC_MASK) >> APB_CONFIG_SRCR2_WTCRTC_SHIFT)
#define  APB_CONFIG_SRCR2_WTCRTC_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR2_WTCRTC_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR2_WTCRTC_SHIFT))

//====================================================================
//Register: SRAM WTC/RTC Configuration Register 3 (SRCR3)
//====================================================================

#define  APB_CONFIG_SRCR3_WTCRTC_MASK 0xffffffff
#define  APB_CONFIG_SRCR3_WTCRTC_SHIFT 0
#define  APB_CONFIG_SRCR3_WTCRTC_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR3_WTCRTC_MASK) >> APB_CONFIG_SRCR3_WTCRTC_SHIFT)
#define  APB_CONFIG_SRCR3_WTCRTC_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR3_WTCRTC_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR3_WTCRTC_SHIFT))

//====================================================================
//Register: SRAM WTC/RTC Configuration Register 4 (SRCR4)
//====================================================================

#define  APB_CONFIG_SRCR4_WTCRTC_MASK 0xffffffff
#define  APB_CONFIG_SRCR4_WTCRTC_SHIFT 0
#define  APB_CONFIG_SRCR4_WTCRTC_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR4_WTCRTC_MASK) >> APB_CONFIG_SRCR4_WTCRTC_SHIFT)
#define  APB_CONFIG_SRCR4_WTCRTC_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR4_WTCRTC_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR4_WTCRTC_SHIFT))

//====================================================================
//Register: SRAM WTC/RTC Configuration Register 5 (SRCR5)
//====================================================================

#define  APB_CONFIG_SRCR5_WTCRTC_MASK 0xffffffff
#define  APB_CONFIG_SRCR5_WTCRTC_SHIFT 0
#define  APB_CONFIG_SRCR5_WTCRTC_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR5_WTCRTC_MASK) >> APB_CONFIG_SRCR5_WTCRTC_SHIFT)
#define  APB_CONFIG_SRCR5_WTCRTC_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR5_WTCRTC_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR5_WTCRTC_SHIFT))

//====================================================================
//Register: SRAM WTC/RTC Configuration Register 6 (SRCR6)
//====================================================================

#define  APB_CONFIG_SRCR6_WTCRTC_MASK 0xffffffff
#define  APB_CONFIG_SRCR6_WTCRTC_SHIFT 0
#define  APB_CONFIG_SRCR6_WTCRTC_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR6_WTCRTC_MASK) >> APB_CONFIG_SRCR6_WTCRTC_SHIFT)
#define  APB_CONFIG_SRCR6_WTCRTC_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR6_WTCRTC_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR6_WTCRTC_SHIFT))

//====================================================================
//Register: SRAM WTC/RTC Configuration Register 7 (SRCR7)
//====================================================================

#define  APB_CONFIG_SRCR7_WTCRTC_MASK 0xffffffff
#define  APB_CONFIG_SRCR7_WTCRTC_SHIFT 0
#define  APB_CONFIG_SRCR7_WTCRTC_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR7_WTCRTC_MASK) >> APB_CONFIG_SRCR7_WTCRTC_SHIFT)
#define  APB_CONFIG_SRCR7_WTCRTC_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR7_WTCRTC_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR7_WTCRTC_SHIFT))

//====================================================================
//Register: SRAM WTC/RTC Configuration Register 8 (SRCR8)
//====================================================================

#define  APB_CONFIG_SRCR8_RESERVED1_MASK 0xff000000
#define  APB_CONFIG_SRCR8_RESERVED1_SHIFT 24
#define  APB_CONFIG_SRCR8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR8_RESERVED1_MASK) >> APB_CONFIG_SRCR8_RESERVED1_SHIFT)
#define  APB_CONFIG_SRCR8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR8_RESERVED1_SHIFT))

#define  APB_CONFIG_SRCR8_WTCRTC_MASK 0xffffff
#define  APB_CONFIG_SRCR8_WTCRTC_SHIFT 0
#define  APB_CONFIG_SRCR8_WTCRTC_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR8_WTCRTC_MASK) >> APB_CONFIG_SRCR8_WTCRTC_SHIFT)
#define  APB_CONFIG_SRCR8_WTCRTC_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR8_WTCRTC_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR8_WTCRTC_SHIFT))

//====================================================================
//Register: EROM RTC Configuration Register 9 (SRCR9)
//====================================================================

#define  APB_CONFIG_SRCR9_RESERVED1_MASK 0xfffffc00
#define  APB_CONFIG_SRCR9_RESERVED1_SHIFT 10
#define  APB_CONFIG_SRCR9_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR9_RESERVED1_MASK) >> APB_CONFIG_SRCR9_RESERVED1_SHIFT)
#define  APB_CONFIG_SRCR9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR9_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR9_RESERVED1_SHIFT))

#define  APB_CONFIG_SRCR9_VCF_RTC_MASK 0x380
#define  APB_CONFIG_SRCR9_VCF_RTC_SHIFT 7
#define  APB_CONFIG_SRCR9_VCF_RTC_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR9_VCF_RTC_MASK) >> APB_CONFIG_SRCR9_VCF_RTC_SHIFT)
#define  APB_CONFIG_SRCR9_VCF_RTC_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR9_VCF_RTC_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR9_VCF_RTC_SHIFT))

#define  APB_CONFIG_SRCR9_VCF_RTC_REF_MASK 0x60
#define  APB_CONFIG_SRCR9_VCF_RTC_REF_SHIFT 5
#define  APB_CONFIG_SRCR9_VCF_RTC_REF_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR9_VCF_RTC_REF_MASK) >> APB_CONFIG_SRCR9_VCF_RTC_REF_SHIFT)
#define  APB_CONFIG_SRCR9_VCF_RTC_REF_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR9_VCF_RTC_REF_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR9_VCF_RTC_REF_SHIFT))

#define  APB_CONFIG_SRCR9_ROM_RTC_MASK 0x1c
#define  APB_CONFIG_SRCR9_ROM_RTC_SHIFT 2
#define  APB_CONFIG_SRCR9_ROM_RTC_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR9_ROM_RTC_MASK) >> APB_CONFIG_SRCR9_ROM_RTC_SHIFT)
#define  APB_CONFIG_SRCR9_ROM_RTC_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR9_ROM_RTC_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR9_ROM_RTC_SHIFT))

#define  APB_CONFIG_SRCR9_ROM_RTC_REF_MASK 0x3
#define  APB_CONFIG_SRCR9_ROM_RTC_REF_SHIFT 0
#define  APB_CONFIG_SRCR9_ROM_RTC_REF_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SRCR9_ROM_RTC_REF_MASK) >> APB_CONFIG_SRCR9_ROM_RTC_REF_SHIFT)
#define  APB_CONFIG_SRCR9_ROM_RTC_REF_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SRCR9_ROM_RTC_REF_MASK) | (((uint32_t)val) << APB_CONFIG_SRCR9_ROM_RTC_REF_SHIFT))

//====================================================================
//Register: Firmware-controlled Reset Register (FCRR)
/** \brief This register controls soft reset of various blocks in the system.*/
//====================================================================

#define  APB_CONFIG_FCRR_RESERVED1_MASK 0xfffffff8
#define  APB_CONFIG_FCRR_RESERVED1_SHIFT 3
#define  APB_CONFIG_FCRR_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FCRR_RESERVED1_MASK) >> APB_CONFIG_FCRR_RESERVED1_SHIFT)
#define  APB_CONFIG_FCRR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FCRR_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FCRR_RESERVED1_SHIFT))

#define  APB_CONFIG_FCRR_WATCHDOGRESET_SYSNCHIP_MASK 0x4
#define  APB_CONFIG_FCRR_WATCHDOGRESET_SYSNCHIP_SHIFT 2
#define  APB_CONFIG_FCRR_WATCHDOGRESET_SYSNCHIP_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FCRR_WATCHDOGRESET_SYSNCHIP_MASK) >> APB_CONFIG_FCRR_WATCHDOGRESET_SYSNCHIP_SHIFT)
#define  APB_CONFIG_FCRR_WATCHDOGRESET_SYSNCHIP_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FCRR_WATCHDOGRESET_SYSNCHIP_MASK) | (((uint32_t)val) << APB_CONFIG_FCRR_WATCHDOGRESET_SYSNCHIP_SHIFT))

#define  APB_CONFIG_FCRR_SOFTRESET_PCIEPHY_MASK 0x2
#define  APB_CONFIG_FCRR_SOFTRESET_PCIEPHY_SHIFT 1
#define  APB_CONFIG_FCRR_SOFTRESET_PCIEPHY_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FCRR_SOFTRESET_PCIEPHY_MASK) >> APB_CONFIG_FCRR_SOFTRESET_PCIEPHY_SHIFT)
#define  APB_CONFIG_FCRR_SOFTRESET_PCIEPHY_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FCRR_SOFTRESET_PCIEPHY_MASK) | (((uint32_t)val) << APB_CONFIG_FCRR_SOFTRESET_PCIEPHY_SHIFT))

#define  APB_CONFIG_FCRR_SOFTRESET_DAVINCI_MASK 0x1
#define  APB_CONFIG_FCRR_SOFTRESET_DAVINCI_SHIFT 0
#define  APB_CONFIG_FCRR_SOFTRESET_DAVINCI_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FCRR_SOFTRESET_DAVINCI_MASK) >> APB_CONFIG_FCRR_SOFTRESET_DAVINCI_SHIFT)
#define  APB_CONFIG_FCRR_SOFTRESET_DAVINCI_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FCRR_SOFTRESET_DAVINCI_MASK) | (((uint32_t)val) << APB_CONFIG_FCRR_SOFTRESET_DAVINCI_SHIFT))

//====================================================================
//Register: FW BIST Control Register 1 (FBCR1)
/** \brief See X1P_memories.xls on X1P twiki page.*/
//====================================================================

#define  APB_CONFIG_FBCR1_FWBISTMODE_MASK 0xffffffff
#define  APB_CONFIG_FBCR1_FWBISTMODE_SHIFT 0
#define  APB_CONFIG_FBCR1_FWBISTMODE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBCR1_FWBISTMODE_MASK) >> APB_CONFIG_FBCR1_FWBISTMODE_SHIFT)
#define  APB_CONFIG_FBCR1_FWBISTMODE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBCR1_FWBISTMODE_MASK) | (((uint32_t)val) << APB_CONFIG_FBCR1_FWBISTMODE_SHIFT))

//====================================================================
//Register: FW BIST Control Register 2 (FBCR2)
//====================================================================

#define  APB_CONFIG_FBCR2_FWBISTMODE_MASK 0xffffffff
#define  APB_CONFIG_FBCR2_FWBISTMODE_SHIFT 0
#define  APB_CONFIG_FBCR2_FWBISTMODE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBCR2_FWBISTMODE_MASK) >> APB_CONFIG_FBCR2_FWBISTMODE_SHIFT)
#define  APB_CONFIG_FBCR2_FWBISTMODE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBCR2_FWBISTMODE_MASK) | (((uint32_t)val) << APB_CONFIG_FBCR2_FWBISTMODE_SHIFT))

//====================================================================
//Register: FW BIST Control Register 3 (FBCR3)
//====================================================================

#define  APB_CONFIG_FBCR3_FWBISTMODE_MASK 0xffffffff
#define  APB_CONFIG_FBCR3_FWBISTMODE_SHIFT 0
#define  APB_CONFIG_FBCR3_FWBISTMODE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBCR3_FWBISTMODE_MASK) >> APB_CONFIG_FBCR3_FWBISTMODE_SHIFT)
#define  APB_CONFIG_FBCR3_FWBISTMODE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBCR3_FWBISTMODE_MASK) | (((uint32_t)val) << APB_CONFIG_FBCR3_FWBISTMODE_SHIFT))

//====================================================================
//Register: FW BIST Control Register 4 (FBCR4)
//====================================================================

#define  APB_CONFIG_FBCR4_FWBISTMODE_MASK 0xffffffff
#define  APB_CONFIG_FBCR4_FWBISTMODE_SHIFT 0
#define  APB_CONFIG_FBCR4_FWBISTMODE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBCR4_FWBISTMODE_MASK) >> APB_CONFIG_FBCR4_FWBISTMODE_SHIFT)
#define  APB_CONFIG_FBCR4_FWBISTMODE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBCR4_FWBISTMODE_MASK) | (((uint32_t)val) << APB_CONFIG_FBCR4_FWBISTMODE_SHIFT))

//====================================================================
//Register: FW BIST Control Register 5 (FBCR5)
//====================================================================

#define  APB_CONFIG_FBCR5_FWBISTMODE_MASK 0xffffffff
#define  APB_CONFIG_FBCR5_FWBISTMODE_SHIFT 0
#define  APB_CONFIG_FBCR5_FWBISTMODE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBCR5_FWBISTMODE_MASK) >> APB_CONFIG_FBCR5_FWBISTMODE_SHIFT)
#define  APB_CONFIG_FBCR5_FWBISTMODE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBCR5_FWBISTMODE_MASK) | (((uint32_t)val) << APB_CONFIG_FBCR5_FWBISTMODE_SHIFT))

//====================================================================
//Register: FW BIST Control Register 6 (FBCR6)
//====================================================================

#define  APB_CONFIG_FBCR6_RESERVED1_MASK 0xf8000000
#define  APB_CONFIG_FBCR6_RESERVED1_SHIFT 27
#define  APB_CONFIG_FBCR6_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBCR6_RESERVED1_MASK) >> APB_CONFIG_FBCR6_RESERVED1_SHIFT)
#define  APB_CONFIG_FBCR6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBCR6_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FBCR6_RESERVED1_SHIFT))

#define  APB_CONFIG_FBCR6_FWBISTMODE_MASK 0x7ffffff
#define  APB_CONFIG_FBCR6_FWBISTMODE_SHIFT 0
#define  APB_CONFIG_FBCR6_FWBISTMODE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBCR6_FWBISTMODE_MASK) >> APB_CONFIG_FBCR6_FWBISTMODE_SHIFT)
#define  APB_CONFIG_FBCR6_FWBISTMODE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBCR6_FWBISTMODE_MASK) | (((uint32_t)val) << APB_CONFIG_FBCR6_FWBISTMODE_SHIFT))

//====================================================================
//Register: FW BIST Finish Register 1 (FBFR1)
/** \brief See X1P_memories.xls on X1P twiki page.*/
//====================================================================

#define  APB_CONFIG_FBFR1_FWBISTFINISH_MASK 0xffffffff
#define  APB_CONFIG_FBFR1_FWBISTFINISH_SHIFT 0
#define  APB_CONFIG_FBFR1_FWBISTFINISH_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBFR1_FWBISTFINISH_MASK) >> APB_CONFIG_FBFR1_FWBISTFINISH_SHIFT)
#define  APB_CONFIG_FBFR1_FWBISTFINISH_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBFR1_FWBISTFINISH_MASK) | (((uint32_t)val) << APB_CONFIG_FBFR1_FWBISTFINISH_SHIFT))

//====================================================================
//Register: FW BIST Finish Register 2 (FBFR2)
//====================================================================

#define  APB_CONFIG_FBFR2_FWBISTFINISH_MASK 0xffffffff
#define  APB_CONFIG_FBFR2_FWBISTFINISH_SHIFT 0
#define  APB_CONFIG_FBFR2_FWBISTFINISH_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBFR2_FWBISTFINISH_MASK) >> APB_CONFIG_FBFR2_FWBISTFINISH_SHIFT)
#define  APB_CONFIG_FBFR2_FWBISTFINISH_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBFR2_FWBISTFINISH_MASK) | (((uint32_t)val) << APB_CONFIG_FBFR2_FWBISTFINISH_SHIFT))

//====================================================================
//Register: FW BIST Finish Register 3 (FBFR3)
//====================================================================

#define  APB_CONFIG_FBFR3_FWBISTFINISH_MASK 0xffffffff
#define  APB_CONFIG_FBFR3_FWBISTFINISH_SHIFT 0
#define  APB_CONFIG_FBFR3_FWBISTFINISH_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBFR3_FWBISTFINISH_MASK) >> APB_CONFIG_FBFR3_FWBISTFINISH_SHIFT)
#define  APB_CONFIG_FBFR3_FWBISTFINISH_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBFR3_FWBISTFINISH_MASK) | (((uint32_t)val) << APB_CONFIG_FBFR3_FWBISTFINISH_SHIFT))

//====================================================================
//Register: FW BIST Finish Register 4 (FBFR4)
//====================================================================

#define  APB_CONFIG_FBFR4_FWBISTFINISH_MASK 0xffffffff
#define  APB_CONFIG_FBFR4_FWBISTFINISH_SHIFT 0
#define  APB_CONFIG_FBFR4_FWBISTFINISH_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBFR4_FWBISTFINISH_MASK) >> APB_CONFIG_FBFR4_FWBISTFINISH_SHIFT)
#define  APB_CONFIG_FBFR4_FWBISTFINISH_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBFR4_FWBISTFINISH_MASK) | (((uint32_t)val) << APB_CONFIG_FBFR4_FWBISTFINISH_SHIFT))

//====================================================================
//Register: FW BIST Finish Register 5 (FBFR5)
//====================================================================

#define  APB_CONFIG_FBFR5_FWBISTFINISH_MASK 0xffffffff
#define  APB_CONFIG_FBFR5_FWBISTFINISH_SHIFT 0
#define  APB_CONFIG_FBFR5_FWBISTFINISH_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBFR5_FWBISTFINISH_MASK) >> APB_CONFIG_FBFR5_FWBISTFINISH_SHIFT)
#define  APB_CONFIG_FBFR5_FWBISTFINISH_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBFR5_FWBISTFINISH_MASK) | (((uint32_t)val) << APB_CONFIG_FBFR5_FWBISTFINISH_SHIFT))

//====================================================================
//Register: FW BIST Finish Register 6 (FBFR6)
//====================================================================

#define  APB_CONFIG_FBFR6_RESERVED1_MASK 0xf8000000
#define  APB_CONFIG_FBFR6_RESERVED1_SHIFT 27
#define  APB_CONFIG_FBFR6_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBFR6_RESERVED1_MASK) >> APB_CONFIG_FBFR6_RESERVED1_SHIFT)
#define  APB_CONFIG_FBFR6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBFR6_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FBFR6_RESERVED1_SHIFT))

#define  APB_CONFIG_FBFR6_FWBISTFINISH_MASK 0x7ffffff
#define  APB_CONFIG_FBFR6_FWBISTFINISH_SHIFT 0
#define  APB_CONFIG_FBFR6_FWBISTFINISH_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBFR6_FWBISTFINISH_MASK) >> APB_CONFIG_FBFR6_FWBISTFINISH_SHIFT)
#define  APB_CONFIG_FBFR6_FWBISTFINISH_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBFR6_FWBISTFINISH_MASK) | (((uint32_t)val) << APB_CONFIG_FBFR6_FWBISTFINISH_SHIFT))

//====================================================================
//Register: FW BIST Error Register 1 (FBER1)
/** \brief See X1P_memories.xls on X1P twiki page.*/
//====================================================================

#define  APB_CONFIG_FBER1_FWBISTFAIL_MASK 0xffffffff
#define  APB_CONFIG_FBER1_FWBISTFAIL_SHIFT 0
#define  APB_CONFIG_FBER1_FWBISTFAIL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBER1_FWBISTFAIL_MASK) >> APB_CONFIG_FBER1_FWBISTFAIL_SHIFT)
#define  APB_CONFIG_FBER1_FWBISTFAIL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBER1_FWBISTFAIL_MASK) | (((uint32_t)val) << APB_CONFIG_FBER1_FWBISTFAIL_SHIFT))

//====================================================================
//Register: FW BIST Error Register 2 (FBER2)
//====================================================================

#define  APB_CONFIG_FBER2_FWBISTFAIL_MASK 0xffffffff
#define  APB_CONFIG_FBER2_FWBISTFAIL_SHIFT 0
#define  APB_CONFIG_FBER2_FWBISTFAIL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBER2_FWBISTFAIL_MASK) >> APB_CONFIG_FBER2_FWBISTFAIL_SHIFT)
#define  APB_CONFIG_FBER2_FWBISTFAIL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBER2_FWBISTFAIL_MASK) | (((uint32_t)val) << APB_CONFIG_FBER2_FWBISTFAIL_SHIFT))

//====================================================================
//Register: FW BIST Error Register 3 (FBER3)
//====================================================================

#define  APB_CONFIG_FBER3_FWBISTFAIL_MASK 0xffffffff
#define  APB_CONFIG_FBER3_FWBISTFAIL_SHIFT 0
#define  APB_CONFIG_FBER3_FWBISTFAIL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBER3_FWBISTFAIL_MASK) >> APB_CONFIG_FBER3_FWBISTFAIL_SHIFT)
#define  APB_CONFIG_FBER3_FWBISTFAIL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBER3_FWBISTFAIL_MASK) | (((uint32_t)val) << APB_CONFIG_FBER3_FWBISTFAIL_SHIFT))

//====================================================================
//Register: FW BIST Error Register 4 (FBER4)
//====================================================================

#define  APB_CONFIG_FBER4_FWBISTFAIL_MASK 0xffffffff
#define  APB_CONFIG_FBER4_FWBISTFAIL_SHIFT 0
#define  APB_CONFIG_FBER4_FWBISTFAIL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBER4_FWBISTFAIL_MASK) >> APB_CONFIG_FBER4_FWBISTFAIL_SHIFT)
#define  APB_CONFIG_FBER4_FWBISTFAIL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBER4_FWBISTFAIL_MASK) | (((uint32_t)val) << APB_CONFIG_FBER4_FWBISTFAIL_SHIFT))

//====================================================================
//Register: FW BIST Error Register 5 (FBER5)
//====================================================================

#define  APB_CONFIG_FBER5_FWBISTFAIL_MASK 0xffffffff
#define  APB_CONFIG_FBER5_FWBISTFAIL_SHIFT 0
#define  APB_CONFIG_FBER5_FWBISTFAIL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBER5_FWBISTFAIL_MASK) >> APB_CONFIG_FBER5_FWBISTFAIL_SHIFT)
#define  APB_CONFIG_FBER5_FWBISTFAIL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBER5_FWBISTFAIL_MASK) | (((uint32_t)val) << APB_CONFIG_FBER5_FWBISTFAIL_SHIFT))

//====================================================================
//Register: FW BIST Error Register 6 (FBER6)
//====================================================================

#define  APB_CONFIG_FBER6_RESERVED1_MASK 0xf8000000
#define  APB_CONFIG_FBER6_RESERVED1_SHIFT 27
#define  APB_CONFIG_FBER6_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBER6_RESERVED1_MASK) >> APB_CONFIG_FBER6_RESERVED1_SHIFT)
#define  APB_CONFIG_FBER6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBER6_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FBER6_RESERVED1_SHIFT))

#define  APB_CONFIG_FBER6_FWBISTFAIL_MASK 0x7ffffff
#define  APB_CONFIG_FBER6_FWBISTFAIL_SHIFT 0
#define  APB_CONFIG_FBER6_FWBISTFAIL_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FBER6_FWBISTFAIL_MASK) >> APB_CONFIG_FBER6_FWBISTFAIL_SHIFT)
#define  APB_CONFIG_FBER6_FWBISTFAIL_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FBER6_FWBISTFAIL_MASK) | (((uint32_t)val) << APB_CONFIG_FBER6_FWBISTFAIL_SHIFT))

//====================================================================
//Register: General Purpose Register (GPR)
/** \brief This is a spare register that is synthesized into the ASIC netlist. The register is writable and readable by firmware, but the state bits are - intentionally - not connected. In the event that some ASIC block needs an ECO which includes firmware controllable register bits, the state bits of this register can be used and connected (as part of the ECO).*/
//====================================================================

#define  APB_CONFIG_GPR_GPBITS_MASK 0xffffffff
#define  APB_CONFIG_GPR_GPBITS_SHIFT 0
#define  APB_CONFIG_GPR_GPBITS_MASK_SHIFT(reg) (((reg) & APB_CONFIG_GPR_GPBITS_MASK) >> APB_CONFIG_GPR_GPBITS_SHIFT)
#define  APB_CONFIG_GPR_GPBITS_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_GPR_GPBITS_MASK) | (((uint32_t)val) << APB_CONFIG_GPR_GPBITS_SHIFT))

//====================================================================
//Register: RTC Analog Test Pin Config (RTC_ATEST)
/** \brief Controls the enabling and muxing of the analog test signal from the RTC module.*/
//====================================================================

#define  APB_CONFIG_RTC_ATEST_RESERVED1_MASK 0xfffffffc
#define  APB_CONFIG_RTC_ATEST_RESERVED1_SHIFT 2
#define  APB_CONFIG_RTC_ATEST_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_RTC_ATEST_RESERVED1_MASK) >> APB_CONFIG_RTC_ATEST_RESERVED1_SHIFT)
#define  APB_CONFIG_RTC_ATEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_RTC_ATEST_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_RTC_ATEST_RESERVED1_SHIFT))

#define  APB_CONFIG_RTC_ATEST_TE_MASK 0x2
#define  APB_CONFIG_RTC_ATEST_TE_SHIFT 1
#define  APB_CONFIG_RTC_ATEST_TE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_RTC_ATEST_TE_MASK) >> APB_CONFIG_RTC_ATEST_TE_SHIFT)
#define  APB_CONFIG_RTC_ATEST_TE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_RTC_ATEST_TE_MASK) | (((uint32_t)val) << APB_CONFIG_RTC_ATEST_TE_SHIFT))

#define  APB_CONFIG_RTC_ATEST_TS_MASK 0x1
#define  APB_CONFIG_RTC_ATEST_TS_SHIFT 0
#define  APB_CONFIG_RTC_ATEST_TS_MASK_SHIFT(reg) (((reg) & APB_CONFIG_RTC_ATEST_TS_MASK) >> APB_CONFIG_RTC_ATEST_TS_SHIFT)
#define  APB_CONFIG_RTC_ATEST_TS_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_RTC_ATEST_TS_MASK) | (((uint32_t)val) << APB_CONFIG_RTC_ATEST_TS_SHIFT))

#endif // APB_CONFIG
