 /*
 **************************************************************************************
 *
 * Copyright (c) 2010 Marvell International, Ltd.
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file adc_regmasks.h
 * Generated using RegBuild 1.6.1
 *
 *************************************************************************
 */

#ifndef _ADC_REGS_REGMASKS_H_
#define _ADC_REGS_REGMASKS_H_

//#include <stdint.h>

//====================================================================
//
//Register File: ADC registers (adc_regs)
/** \brief Registers for ADC Control which provides for programmable ADC communications and assist functions.*/
//
//====================================================================

//====================================================================
//Register: SARADC Control Register (SARADC_Control)
/** \brief This register controls the SARADC hardmacro. <BR>
            SARADC hardmacro timing parameters are also programmed in this register.
            See the SARADC Electrical Specifications. <BR>
            The timing parameters in this register are used only when the ADC Controller is placed in
            automatic mode (see ADC_Control.interface_mode bit) for the SARADC part type (see ADC_Control.part_type bits). <BR>*/
//====================================================================

#define  ADC_REGS_SARADC_CONTROL_T_STRT_SEL_MASK 0xf0000000
#define  ADC_REGS_SARADC_CONTROL_T_STRT_SEL_SHIFT 28
#define  ADC_REGS_SARADC_CONTROL_T_STRT_SEL_MASK_SHIFT(reg) (((reg) & ADC_REGS_SARADC_CONTROL_T_STRT_SEL_MASK) >> ADC_REGS_SARADC_CONTROL_T_STRT_SEL_SHIFT)
#define  ADC_REGS_SARADC_CONTROL_T_STRT_SEL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_SARADC_CONTROL_T_STRT_SEL_MASK) | (((uint32_t)val) << ADC_REGS_SARADC_CONTROL_T_STRT_SEL_SHIFT))

#define  ADC_REGS_SARADC_CONTROL_T_STRT_DONE_MASK 0xf000000
#define  ADC_REGS_SARADC_CONTROL_T_STRT_DONE_SHIFT 24
#define  ADC_REGS_SARADC_CONTROL_T_STRT_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_SARADC_CONTROL_T_STRT_DONE_MASK) >> ADC_REGS_SARADC_CONTROL_T_STRT_DONE_SHIFT)
#define  ADC_REGS_SARADC_CONTROL_T_STRT_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_SARADC_CONTROL_T_STRT_DONE_MASK) | (((uint32_t)val) << ADC_REGS_SARADC_CONTROL_T_STRT_DONE_SHIFT))

#define  ADC_REGS_SARADC_CONTROL_T_STRT_LOW_MASK 0xf00000
#define  ADC_REGS_SARADC_CONTROL_T_STRT_LOW_SHIFT 20
#define  ADC_REGS_SARADC_CONTROL_T_STRT_LOW_MASK_SHIFT(reg) (((reg) & ADC_REGS_SARADC_CONTROL_T_STRT_LOW_MASK) >> ADC_REGS_SARADC_CONTROL_T_STRT_LOW_SHIFT)
#define  ADC_REGS_SARADC_CONTROL_T_STRT_LOW_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_SARADC_CONTROL_T_STRT_LOW_MASK) | (((uint32_t)val) << ADC_REGS_SARADC_CONTROL_T_STRT_LOW_SHIFT))

#define  ADC_REGS_SARADC_CONTROL_CKSCALER_MASK 0xf0000
#define  ADC_REGS_SARADC_CONTROL_CKSCALER_SHIFT 16
#define  ADC_REGS_SARADC_CONTROL_CKSCALER_MASK_SHIFT(reg) (((reg) & ADC_REGS_SARADC_CONTROL_CKSCALER_MASK) >> ADC_REGS_SARADC_CONTROL_CKSCALER_SHIFT)
#define  ADC_REGS_SARADC_CONTROL_CKSCALER_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_SARADC_CONTROL_CKSCALER_MASK) | (((uint32_t)val) << ADC_REGS_SARADC_CONTROL_CKSCALER_SHIFT))

#define  ADC_REGS_SARADC_CONTROL_CKSEL_MASK 0xc000
#define  ADC_REGS_SARADC_CONTROL_CKSEL_SHIFT 14
#define  ADC_REGS_SARADC_CONTROL_CKSEL_MASK_SHIFT(reg) (((reg) & ADC_REGS_SARADC_CONTROL_CKSEL_MASK) >> ADC_REGS_SARADC_CONTROL_CKSEL_SHIFT)
#define  ADC_REGS_SARADC_CONTROL_CKSEL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_SARADC_CONTROL_CKSEL_MASK) | (((uint32_t)val) << ADC_REGS_SARADC_CONTROL_CKSEL_SHIFT))

#define  ADC_REGS_SARADC_CONTROL_RESERVED1_MASK 0x2000
#define  ADC_REGS_SARADC_CONTROL_RESERVED1_SHIFT 13
#define  ADC_REGS_SARADC_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_SARADC_CONTROL_RESERVED1_MASK) >> ADC_REGS_SARADC_CONTROL_RESERVED1_SHIFT)
#define  ADC_REGS_SARADC_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_SARADC_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_SARADC_CONTROL_RESERVED1_SHIFT))

#define  ADC_REGS_SARADC_CONTROL_R_ROTATE_SEL_MASK 0x1000
#define  ADC_REGS_SARADC_CONTROL_R_ROTATE_SEL_SHIFT 12
#define  ADC_REGS_SARADC_CONTROL_R_ROTATE_SEL_MASK_SHIFT(reg) (((reg) & ADC_REGS_SARADC_CONTROL_R_ROTATE_SEL_MASK) >> ADC_REGS_SARADC_CONTROL_R_ROTATE_SEL_SHIFT)
#define  ADC_REGS_SARADC_CONTROL_R_ROTATE_SEL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_SARADC_CONTROL_R_ROTATE_SEL_MASK) | (((uint32_t)val) << ADC_REGS_SARADC_CONTROL_R_ROTATE_SEL_SHIFT))

#define  ADC_REGS_SARADC_CONTROL_TST_SAR_MASK 0x800
#define  ADC_REGS_SARADC_CONTROL_TST_SAR_SHIFT 11
#define  ADC_REGS_SARADC_CONTROL_TST_SAR_MASK_SHIFT(reg) (((reg) & ADC_REGS_SARADC_CONTROL_TST_SAR_MASK) >> ADC_REGS_SARADC_CONTROL_TST_SAR_SHIFT)
#define  ADC_REGS_SARADC_CONTROL_TST_SAR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_SARADC_CONTROL_TST_SAR_MASK) | (((uint32_t)val) << ADC_REGS_SARADC_CONTROL_TST_SAR_SHIFT))

#define  ADC_REGS_SARADC_CONTROL_VREF_ADJUST_MASK 0x7f8
#define  ADC_REGS_SARADC_CONTROL_VREF_ADJUST_SHIFT 3
#define  ADC_REGS_SARADC_CONTROL_VREF_ADJUST_MASK_SHIFT(reg) (((reg) & ADC_REGS_SARADC_CONTROL_VREF_ADJUST_MASK) >> ADC_REGS_SARADC_CONTROL_VREF_ADJUST_SHIFT)
#define  ADC_REGS_SARADC_CONTROL_VREF_ADJUST_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_SARADC_CONTROL_VREF_ADJUST_MASK) | (((uint32_t)val) << ADC_REGS_SARADC_CONTROL_VREF_ADJUST_SHIFT))

#define  ADC_REGS_SARADC_CONTROL_VREF_SEL_MASK 0x4
#define  ADC_REGS_SARADC_CONTROL_VREF_SEL_SHIFT 2
#define  ADC_REGS_SARADC_CONTROL_VREF_SEL_MASK_SHIFT(reg) (((reg) & ADC_REGS_SARADC_CONTROL_VREF_SEL_MASK) >> ADC_REGS_SARADC_CONTROL_VREF_SEL_SHIFT)
#define  ADC_REGS_SARADC_CONTROL_VREF_SEL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_SARADC_CONTROL_VREF_SEL_MASK) | (((uint32_t)val) << ADC_REGS_SARADC_CONTROL_VREF_SEL_SHIFT))

#define  ADC_REGS_SARADC_CONTROL_PU_SARADC_MASK 0x2
#define  ADC_REGS_SARADC_CONTROL_PU_SARADC_SHIFT 1
#define  ADC_REGS_SARADC_CONTROL_PU_SARADC_MASK_SHIFT(reg) (((reg) & ADC_REGS_SARADC_CONTROL_PU_SARADC_MASK) >> ADC_REGS_SARADC_CONTROL_PU_SARADC_SHIFT)
#define  ADC_REGS_SARADC_CONTROL_PU_SARADC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_SARADC_CONTROL_PU_SARADC_MASK) | (((uint32_t)val) << ADC_REGS_SARADC_CONTROL_PU_SARADC_SHIFT))

#define  ADC_REGS_SARADC_CONTROL_RESET_MASK 0x1
#define  ADC_REGS_SARADC_CONTROL_RESET_SHIFT 0
#define  ADC_REGS_SARADC_CONTROL_RESET_MASK_SHIFT(reg) (((reg) & ADC_REGS_SARADC_CONTROL_RESET_MASK) >> ADC_REGS_SARADC_CONTROL_RESET_SHIFT)
#define  ADC_REGS_SARADC_CONTROL_RESET_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_SARADC_CONTROL_RESET_MASK) | (((uint32_t)val) << ADC_REGS_SARADC_CONTROL_RESET_SHIFT))

//====================================================================
//Register: ADC Control Register (ADC_Control)
/** \brief This register controls the ADC Control block operation.*/
//====================================================================

#define  ADC_REGS_ADC_CONTROL_RESERVED1_MASK 0xf0000000
#define  ADC_REGS_ADC_CONTROL_RESERVED1_SHIFT 28
#define  ADC_REGS_ADC_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_ADC_CONTROL_RESERVED1_MASK) >> ADC_REGS_ADC_CONTROL_RESERVED1_SHIFT)
#define  ADC_REGS_ADC_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_ADC_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_ADC_CONTROL_RESERVED1_SHIFT))

#define  ADC_REGS_ADC_CONTROL_RXFIFO2_ENABLE_MASK 0x8000000
#define  ADC_REGS_ADC_CONTROL_RXFIFO2_ENABLE_SHIFT 27
#define  ADC_REGS_ADC_CONTROL_RXFIFO2_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_ADC_CONTROL_RXFIFO2_ENABLE_MASK) >> ADC_REGS_ADC_CONTROL_RXFIFO2_ENABLE_SHIFT)
#define  ADC_REGS_ADC_CONTROL_RXFIFO2_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_ADC_CONTROL_RXFIFO2_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_ADC_CONTROL_RXFIFO2_ENABLE_SHIFT))

#define  ADC_REGS_ADC_CONTROL_RXFIFO2_WATERMARK_MASK 0x7000000
#define  ADC_REGS_ADC_CONTROL_RXFIFO2_WATERMARK_SHIFT 24
#define  ADC_REGS_ADC_CONTROL_RXFIFO2_WATERMARK_MASK_SHIFT(reg) (((reg) & ADC_REGS_ADC_CONTROL_RXFIFO2_WATERMARK_MASK) >> ADC_REGS_ADC_CONTROL_RXFIFO2_WATERMARK_SHIFT)
#define  ADC_REGS_ADC_CONTROL_RXFIFO2_WATERMARK_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_ADC_CONTROL_RXFIFO2_WATERMARK_MASK) | (((uint32_t)val) << ADC_REGS_ADC_CONTROL_RXFIFO2_WATERMARK_SHIFT))

#define  ADC_REGS_ADC_CONTROL_RXFIFO1_ENABLE_MASK 0x800000
#define  ADC_REGS_ADC_CONTROL_RXFIFO1_ENABLE_SHIFT 23
#define  ADC_REGS_ADC_CONTROL_RXFIFO1_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_ADC_CONTROL_RXFIFO1_ENABLE_MASK) >> ADC_REGS_ADC_CONTROL_RXFIFO1_ENABLE_SHIFT)
#define  ADC_REGS_ADC_CONTROL_RXFIFO1_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_ADC_CONTROL_RXFIFO1_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_ADC_CONTROL_RXFIFO1_ENABLE_SHIFT))

#define  ADC_REGS_ADC_CONTROL_RXFIFO1_WATERMARK_MASK 0x700000
#define  ADC_REGS_ADC_CONTROL_RXFIFO1_WATERMARK_SHIFT 20
#define  ADC_REGS_ADC_CONTROL_RXFIFO1_WATERMARK_MASK_SHIFT(reg) (((reg) & ADC_REGS_ADC_CONTROL_RXFIFO1_WATERMARK_MASK) >> ADC_REGS_ADC_CONTROL_RXFIFO1_WATERMARK_SHIFT)
#define  ADC_REGS_ADC_CONTROL_RXFIFO1_WATERMARK_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_ADC_CONTROL_RXFIFO1_WATERMARK_MASK) | (((uint32_t)val) << ADC_REGS_ADC_CONTROL_RXFIFO1_WATERMARK_SHIFT))

#define  ADC_REGS_ADC_CONTROL_SPI_DESELDELAY_MASK 0xf0000
#define  ADC_REGS_ADC_CONTROL_SPI_DESELDELAY_SHIFT 16
#define  ADC_REGS_ADC_CONTROL_SPI_DESELDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_ADC_CONTROL_SPI_DESELDELAY_MASK) >> ADC_REGS_ADC_CONTROL_SPI_DESELDELAY_SHIFT)
#define  ADC_REGS_ADC_CONTROL_SPI_DESELDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_ADC_CONTROL_SPI_DESELDELAY_MASK) | (((uint32_t)val) << ADC_REGS_ADC_CONTROL_SPI_DESELDELAY_SHIFT))

#define  ADC_REGS_ADC_CONTROL_SPI_CLKDIVISOR_MASK 0xff00
#define  ADC_REGS_ADC_CONTROL_SPI_CLKDIVISOR_SHIFT 8
#define  ADC_REGS_ADC_CONTROL_SPI_CLKDIVISOR_MASK_SHIFT(reg) (((reg) & ADC_REGS_ADC_CONTROL_SPI_CLKDIVISOR_MASK) >> ADC_REGS_ADC_CONTROL_SPI_CLKDIVISOR_SHIFT)
#define  ADC_REGS_ADC_CONTROL_SPI_CLKDIVISOR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_ADC_CONTROL_SPI_CLKDIVISOR_MASK) | (((uint32_t)val) << ADC_REGS_ADC_CONTROL_SPI_CLKDIVISOR_SHIFT))

#define  ADC_REGS_ADC_CONTROL_RESERVED2_MASK 0xfc
#define  ADC_REGS_ADC_CONTROL_RESERVED2_SHIFT 2
#define  ADC_REGS_ADC_CONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_ADC_CONTROL_RESERVED2_MASK) >> ADC_REGS_ADC_CONTROL_RESERVED2_SHIFT)
#define  ADC_REGS_ADC_CONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_ADC_CONTROL_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_ADC_CONTROL_RESERVED2_SHIFT))

#define  ADC_REGS_ADC_CONTROL_PART_TYPE_MASK 0x2
#define  ADC_REGS_ADC_CONTROL_PART_TYPE_SHIFT 1
#define  ADC_REGS_ADC_CONTROL_PART_TYPE_MASK_SHIFT(reg) (((reg) & ADC_REGS_ADC_CONTROL_PART_TYPE_MASK) >> ADC_REGS_ADC_CONTROL_PART_TYPE_SHIFT)
#define  ADC_REGS_ADC_CONTROL_PART_TYPE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_ADC_CONTROL_PART_TYPE_MASK) | (((uint32_t)val) << ADC_REGS_ADC_CONTROL_PART_TYPE_SHIFT))

#define  ADC_REGS_ADC_CONTROL_INTERFACE_MODE_MASK 0x1
#define  ADC_REGS_ADC_CONTROL_INTERFACE_MODE_SHIFT 0
#define  ADC_REGS_ADC_CONTROL_INTERFACE_MODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_ADC_CONTROL_INTERFACE_MODE_MASK) >> ADC_REGS_ADC_CONTROL_INTERFACE_MODE_SHIFT)
#define  ADC_REGS_ADC_CONTROL_INTERFACE_MODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_ADC_CONTROL_INTERFACE_MODE_MASK) | (((uint32_t)val) << ADC_REGS_ADC_CONTROL_INTERFACE_MODE_SHIFT))

//====================================================================
//Register: Continuous-mode Timebase Configuration Register (ContTimebaseConfig)
/** \brief This register configures the internally derived timebase that is used in Continuous mode. A timebase tick triggers a new ADC conversion sequence. <BR>*/
//====================================================================

#define  ADC_REGS_CONTTIMEBASECONFIG_RESERVED1_MASK 0xf0000000
#define  ADC_REGS_CONTTIMEBASECONFIG_RESERVED1_SHIFT 28
#define  ADC_REGS_CONTTIMEBASECONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_CONTTIMEBASECONFIG_RESERVED1_MASK) >> ADC_REGS_CONTTIMEBASECONFIG_RESERVED1_SHIFT)
#define  ADC_REGS_CONTTIMEBASECONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_CONTTIMEBASECONFIG_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_CONTTIMEBASECONFIG_RESERVED1_SHIFT))

#define  ADC_REGS_CONTTIMEBASECONFIG_PERIOD_MASK 0xfffffff
#define  ADC_REGS_CONTTIMEBASECONFIG_PERIOD_SHIFT 0
#define  ADC_REGS_CONTTIMEBASECONFIG_PERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_CONTTIMEBASECONFIG_PERIOD_MASK) >> ADC_REGS_CONTTIMEBASECONFIG_PERIOD_SHIFT)
#define  ADC_REGS_CONTTIMEBASECONFIG_PERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_CONTTIMEBASECONFIG_PERIOD_MASK) | (((uint32_t)val) << ADC_REGS_CONTTIMEBASECONFIG_PERIOD_SHIFT))

//====================================================================
//Register: General-purpose Timestamp Configuration Register (Instance 1 of 2) (GpTimestampConfig0)
/** \brief This register configures the general-purpose Timestamp0/1 counter that is used to generated a tag for ADC samples (to be stored in the RXData and RXFIFO registers). <BR> (Instance 1 of 2)*/
//====================================================================

#define  ADC_REGS_GPTIMESTAMPCONFIG0_ENABLE_MASK 0x80000000
#define  ADC_REGS_GPTIMESTAMPCONFIG0_ENABLE_SHIFT 31
#define  ADC_REGS_GPTIMESTAMPCONFIG0_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_GPTIMESTAMPCONFIG0_ENABLE_MASK) >> ADC_REGS_GPTIMESTAMPCONFIG0_ENABLE_SHIFT)
#define  ADC_REGS_GPTIMESTAMPCONFIG0_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_GPTIMESTAMPCONFIG0_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_GPTIMESTAMPCONFIG0_ENABLE_SHIFT))

#define  ADC_REGS_GPTIMESTAMPCONFIG0_RESERVED1_MASK 0x7fff0000
#define  ADC_REGS_GPTIMESTAMPCONFIG0_RESERVED1_SHIFT 16
#define  ADC_REGS_GPTIMESTAMPCONFIG0_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_GPTIMESTAMPCONFIG0_RESERVED1_MASK) >> ADC_REGS_GPTIMESTAMPCONFIG0_RESERVED1_SHIFT)
#define  ADC_REGS_GPTIMESTAMPCONFIG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_GPTIMESTAMPCONFIG0_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_GPTIMESTAMPCONFIG0_RESERVED1_SHIFT))

#define  ADC_REGS_GPTIMESTAMPCONFIG0_PERIOD_MASK 0xffff
#define  ADC_REGS_GPTIMESTAMPCONFIG0_PERIOD_SHIFT 0
#define  ADC_REGS_GPTIMESTAMPCONFIG0_PERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_GPTIMESTAMPCONFIG0_PERIOD_MASK) >> ADC_REGS_GPTIMESTAMPCONFIG0_PERIOD_SHIFT)
#define  ADC_REGS_GPTIMESTAMPCONFIG0_PERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_GPTIMESTAMPCONFIG0_PERIOD_MASK) | (((uint32_t)val) << ADC_REGS_GPTIMESTAMPCONFIG0_PERIOD_SHIFT))

//====================================================================
//Register: General-purpose Timestamp Configuration Register (Instance 2 of 2) (GpTimestampConfig1)
/** \brief This register configures the general-purpose Timestamp0/1 counter that is used to generated a tag for ADC samples (to be stored in the RXData and RXFIFO registers). <BR> (Instance 2 of 2)*/
//====================================================================

#define  ADC_REGS_GPTIMESTAMPCONFIG1_ENABLE_MASK 0x80000000
#define  ADC_REGS_GPTIMESTAMPCONFIG1_ENABLE_SHIFT 31
#define  ADC_REGS_GPTIMESTAMPCONFIG1_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_GPTIMESTAMPCONFIG1_ENABLE_MASK) >> ADC_REGS_GPTIMESTAMPCONFIG1_ENABLE_SHIFT)
#define  ADC_REGS_GPTIMESTAMPCONFIG1_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_GPTIMESTAMPCONFIG1_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_GPTIMESTAMPCONFIG1_ENABLE_SHIFT))

#define  ADC_REGS_GPTIMESTAMPCONFIG1_RESERVED1_MASK 0x7fff0000
#define  ADC_REGS_GPTIMESTAMPCONFIG1_RESERVED1_SHIFT 16
#define  ADC_REGS_GPTIMESTAMPCONFIG1_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_GPTIMESTAMPCONFIG1_RESERVED1_MASK) >> ADC_REGS_GPTIMESTAMPCONFIG1_RESERVED1_SHIFT)
#define  ADC_REGS_GPTIMESTAMPCONFIG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_GPTIMESTAMPCONFIG1_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_GPTIMESTAMPCONFIG1_RESERVED1_SHIFT))

#define  ADC_REGS_GPTIMESTAMPCONFIG1_PERIOD_MASK 0xffff
#define  ADC_REGS_GPTIMESTAMPCONFIG1_PERIOD_SHIFT 0
#define  ADC_REGS_GPTIMESTAMPCONFIG1_PERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_GPTIMESTAMPCONFIG1_PERIOD_MASK) >> ADC_REGS_GPTIMESTAMPCONFIG1_PERIOD_SHIFT)
#define  ADC_REGS_GPTIMESTAMPCONFIG1_PERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_GPTIMESTAMPCONFIG1_PERIOD_MASK) | (((uint32_t)val) << ADC_REGS_GPTIMESTAMPCONFIG1_PERIOD_SHIFT))

//====================================================================
//Register: General-purpose Timestamp Status Register (Instance 1 of 2) (GpTimestampStatus0)
/** \brief This register provides status information about the 18-bit Timestamp0/1 counter. <BR> (Instance 1 of 2)*/
//====================================================================

#define  ADC_REGS_GPTIMESTAMPSTATUS0_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_GPTIMESTAMPSTATUS0_RESERVED1_SHIFT 18
#define  ADC_REGS_GPTIMESTAMPSTATUS0_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_GPTIMESTAMPSTATUS0_RESERVED1_MASK) >> ADC_REGS_GPTIMESTAMPSTATUS0_RESERVED1_SHIFT)
#define  ADC_REGS_GPTIMESTAMPSTATUS0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_GPTIMESTAMPSTATUS0_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_GPTIMESTAMPSTATUS0_RESERVED1_SHIFT))

#define  ADC_REGS_GPTIMESTAMPSTATUS0_COUNT_MASK 0x3ffff
#define  ADC_REGS_GPTIMESTAMPSTATUS0_COUNT_SHIFT 0
#define  ADC_REGS_GPTIMESTAMPSTATUS0_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_GPTIMESTAMPSTATUS0_COUNT_MASK) >> ADC_REGS_GPTIMESTAMPSTATUS0_COUNT_SHIFT)
#define  ADC_REGS_GPTIMESTAMPSTATUS0_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_GPTIMESTAMPSTATUS0_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_GPTIMESTAMPSTATUS0_COUNT_SHIFT))

//====================================================================
//Register: General-purpose Timestamp Status Register (Instance 2 of 2) (GpTimestampStatus1)
/** \brief This register provides status information about the 18-bit Timestamp0/1 counter. <BR> (Instance 2 of 2)*/
//====================================================================

#define  ADC_REGS_GPTIMESTAMPSTATUS1_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_GPTIMESTAMPSTATUS1_RESERVED1_SHIFT 18
#define  ADC_REGS_GPTIMESTAMPSTATUS1_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_GPTIMESTAMPSTATUS1_RESERVED1_MASK) >> ADC_REGS_GPTIMESTAMPSTATUS1_RESERVED1_SHIFT)
#define  ADC_REGS_GPTIMESTAMPSTATUS1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_GPTIMESTAMPSTATUS1_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_GPTIMESTAMPSTATUS1_RESERVED1_SHIFT))

#define  ADC_REGS_GPTIMESTAMPSTATUS1_COUNT_MASK 0x3ffff
#define  ADC_REGS_GPTIMESTAMPSTATUS1_COUNT_SHIFT 0
#define  ADC_REGS_GPTIMESTAMPSTATUS1_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_GPTIMESTAMPSTATUS1_COUNT_MASK) >> ADC_REGS_GPTIMESTAMPSTATUS1_COUNT_SHIFT)
#define  ADC_REGS_GPTIMESTAMPSTATUS1_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_GPTIMESTAMPSTATUS1_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_GPTIMESTAMPSTATUS1_COUNT_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 1 of 15) (TriggerConfig0)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 1 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG0_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG0_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG0_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG0_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG0_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG0_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG0_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG0_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG0_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG0_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG0_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG0_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG0_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG0_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG0_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG0_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG0_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG0_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG0_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG0_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG0_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG0_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG0_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG0_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG0_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG0_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG0_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG0_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG0_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG0_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG0_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG0_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG0_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG0_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG0_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG0_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG0_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG0_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG0_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG0_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 2 of 15) (TriggerConfig1)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 2 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG1_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG1_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG1_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG1_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG1_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG1_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG1_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG1_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG1_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG1_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG1_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG1_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG1_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG1_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG1_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG1_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG1_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG1_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG1_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG1_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG1_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG1_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG1_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG1_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG1_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG1_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG1_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG1_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG1_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG1_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG1_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG1_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG1_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG1_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG1_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG1_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG1_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG1_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG1_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG1_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 3 of 15) (TriggerConfig2)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 3 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG2_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG2_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG2_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG2_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG2_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG2_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG2_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG2_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG2_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG2_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG2_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG2_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG2_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG2_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG2_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG2_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG2_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG2_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG2_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG2_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG2_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG2_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG2_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG2_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG2_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG2_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG2_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG2_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG2_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG2_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG2_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG2_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG2_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG2_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG2_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG2_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG2_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG2_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG2_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG2_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 4 of 15) (TriggerConfig3)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 4 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG3_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG3_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG3_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG3_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG3_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG3_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG3_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG3_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG3_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG3_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG3_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG3_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG3_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG3_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG3_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG3_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG3_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG3_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG3_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG3_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG3_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG3_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG3_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG3_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG3_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG3_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG3_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG3_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG3_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG3_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG3_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG3_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG3_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG3_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG3_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG3_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG3_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG3_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG3_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG3_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 5 of 15) (TriggerConfig4)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 5 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG4_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG4_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG4_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG4_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG4_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG4_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG4_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG4_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG4_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG4_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG4_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG4_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG4_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG4_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG4_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG4_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG4_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG4_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG4_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG4_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG4_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG4_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG4_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG4_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG4_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG4_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG4_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG4_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG4_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG4_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG4_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG4_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG4_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG4_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG4_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG4_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG4_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG4_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG4_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG4_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 6 of 15) (TriggerConfig5)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 6 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG5_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG5_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG5_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG5_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG5_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG5_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG5_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG5_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG5_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG5_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG5_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG5_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG5_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG5_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG5_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG5_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG5_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG5_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG5_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG5_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG5_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG5_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG5_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG5_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG5_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG5_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG5_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG5_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG5_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG5_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG5_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG5_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG5_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG5_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG5_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG5_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG5_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG5_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG5_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG5_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 7 of 15) (TriggerConfig6)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 7 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG6_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG6_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG6_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG6_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG6_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG6_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG6_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG6_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG6_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG6_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG6_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG6_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG6_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG6_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG6_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG6_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG6_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG6_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG6_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG6_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG6_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG6_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG6_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG6_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG6_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG6_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG6_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG6_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG6_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG6_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG6_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG6_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG6_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG6_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG6_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG6_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG6_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG6_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG6_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG6_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 8 of 15) (TriggerConfig7)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 8 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG7_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG7_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG7_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG7_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG7_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG7_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG7_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG7_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG7_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG7_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG7_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG7_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG7_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG7_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG7_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG7_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG7_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG7_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG7_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG7_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG7_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG7_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG7_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG7_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG7_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG7_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG7_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG7_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG7_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG7_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG7_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG7_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG7_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG7_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG7_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG7_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG7_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG7_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG7_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG7_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 9 of 15) (TriggerConfig8)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 9 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG8_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG8_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG8_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG8_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG8_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG8_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG8_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG8_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG8_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG8_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG8_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG8_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG8_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG8_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG8_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG8_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG8_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG8_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG8_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG8_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG8_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG8_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG8_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG8_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG8_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG8_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG8_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG8_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG8_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG8_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG8_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG8_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG8_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG8_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG8_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG8_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG8_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG8_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG8_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG8_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 10 of 15) (TriggerConfig9)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 10 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG9_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG9_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG9_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG9_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG9_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG9_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG9_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG9_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG9_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG9_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG9_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG9_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG9_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG9_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG9_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG9_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG9_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG9_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG9_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG9_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG9_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG9_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG9_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG9_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG9_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG9_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG9_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG9_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG9_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG9_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG9_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG9_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG9_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG9_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG9_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG9_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG9_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG9_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG9_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG9_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 11 of 15) (TriggerConfig10)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 11 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG10_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG10_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG10_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG10_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG10_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG10_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG10_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG10_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG10_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG10_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG10_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG10_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG10_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG10_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG10_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG10_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG10_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG10_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG10_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG10_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG10_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG10_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG10_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG10_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG10_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG10_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG10_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG10_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG10_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG10_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG10_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG10_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG10_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG10_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG10_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG10_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG10_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG10_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG10_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG10_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 12 of 15) (TriggerConfig11)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 12 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG11_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG11_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG11_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG11_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG11_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG11_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG11_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG11_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG11_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG11_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG11_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG11_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG11_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG11_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG11_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG11_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG11_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG11_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG11_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG11_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG11_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG11_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG11_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG11_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG11_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG11_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG11_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG11_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG11_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG11_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG11_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG11_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG11_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG11_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG11_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG11_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG11_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG11_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG11_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG11_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 13 of 15) (TriggerConfig12)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 13 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG12_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG12_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG12_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG12_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG12_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG12_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG12_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG12_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG12_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG12_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG12_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG12_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG12_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG12_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG12_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG12_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG12_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG12_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG12_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG12_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG12_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG12_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG12_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG12_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG12_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG12_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG12_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG12_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG12_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG12_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG12_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG12_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG12_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG12_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG12_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG12_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG12_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG12_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG12_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG12_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 14 of 15) (TriggerConfig13)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 14 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG13_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG13_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG13_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG13_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG13_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG13_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG13_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG13_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG13_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG13_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG13_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG13_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG13_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG13_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG13_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG13_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG13_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG13_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG13_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG13_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG13_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG13_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG13_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG13_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG13_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG13_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG13_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG13_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG13_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG13_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG13_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG13_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG13_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG13_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG13_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG13_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG13_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG13_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG13_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG13_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Configuration Register (Instance 15 of 15) (TriggerConfig14)
/** \brief This register configures the timebase generator and timestamp counter for the respective HW or FW trigger. <BR>
            The timebase is used to generate an internal trigger, given the raw input trigger, for requesting conversion samples. <BR>
            The timestamp is used for tagging the for ADC samples (to be stored in the RXData and RXFIFO registers). <BR>
            TriggerConfig0-13 Register serves HW trigger[0-13], and TriggerConfig14 Register serves the FW request. <BR> (Instance 15 of 15)*/
//====================================================================

#define  ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_ENA_MASK 0x80000000
#define  ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_ENA_SHIFT 31
#define  ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_ENA_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_ENA_MASK) >> ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_ENA_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_ENA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_ENA_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_ENA_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_STARTMODE_MASK 0x40000000
#define  ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_STARTMODE_SHIFT 30
#define  ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_STARTMODE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_STARTMODE_MASK) >> ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_STARTMODE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_STARTMODE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_STARTMODE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_STARTMODE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_UNIT_MASK 0x38000000
#define  ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_UNIT_SHIFT 27
#define  ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_UNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_UNIT_MASK) >> ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_UNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_UNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_UNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG14_TIMESTAMP_UNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG14_TRIG_EDGE_MASK 0x6000000
#define  ADC_REGS_TRIGGERCONFIG14_TRIG_EDGE_SHIFT 25
#define  ADC_REGS_TRIGGERCONFIG14_TRIG_EDGE_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG14_TRIG_EDGE_MASK) >> ADC_REGS_TRIGGERCONFIG14_TRIG_EDGE_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG14_TRIG_EDGE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG14_TRIG_EDGE_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG14_TRIG_EDGE_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG14_TBUNIT_MASK 0x1c00000
#define  ADC_REGS_TRIGGERCONFIG14_TBUNIT_SHIFT 22
#define  ADC_REGS_TRIGGERCONFIG14_TBUNIT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG14_TBUNIT_MASK) >> ADC_REGS_TRIGGERCONFIG14_TBUNIT_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG14_TBUNIT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG14_TBUNIT_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG14_TBUNIT_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG14_TBDELAY_MASK 0x3ff000
#define  ADC_REGS_TRIGGERCONFIG14_TBDELAY_SHIFT 12
#define  ADC_REGS_TRIGGERCONFIG14_TBDELAY_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG14_TBDELAY_MASK) >> ADC_REGS_TRIGGERCONFIG14_TBDELAY_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG14_TBDELAY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG14_TBDELAY_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG14_TBDELAY_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG14_RESERVED1_MASK 0xc00
#define  ADC_REGS_TRIGGERCONFIG14_RESERVED1_SHIFT 10
#define  ADC_REGS_TRIGGERCONFIG14_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG14_RESERVED1_MASK) >> ADC_REGS_TRIGGERCONFIG14_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG14_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG14_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERCONFIG14_TBPERIOD_MASK 0x3ff
#define  ADC_REGS_TRIGGERCONFIG14_TBPERIOD_SHIFT 0
#define  ADC_REGS_TRIGGERCONFIG14_TBPERIOD_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERCONFIG14_TBPERIOD_MASK) >> ADC_REGS_TRIGGERCONFIG14_TBPERIOD_SHIFT)
#define  ADC_REGS_TRIGGERCONFIG14_TBPERIOD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERCONFIG14_TBPERIOD_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERCONFIG14_TBPERIOD_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 1 of 15) (TrTimestampStatus0)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 1 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS0_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS0_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS0_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS0_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS0_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS0_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS0_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS0_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS0_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS0_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS0_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS0_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS0_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS0_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS0_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 2 of 15) (TrTimestampStatus1)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 2 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS1_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS1_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS1_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS1_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS1_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS1_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS1_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS1_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS1_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS1_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS1_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS1_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS1_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS1_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS1_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 3 of 15) (TrTimestampStatus2)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 3 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS2_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS2_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS2_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS2_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS2_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS2_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS2_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS2_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS2_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS2_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS2_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS2_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS2_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS2_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS2_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 4 of 15) (TrTimestampStatus3)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 4 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS3_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS3_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS3_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS3_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS3_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS3_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS3_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS3_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS3_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS3_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS3_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS3_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS3_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS3_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS3_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 5 of 15) (TrTimestampStatus4)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 5 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS4_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS4_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS4_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS4_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS4_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS4_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS4_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS4_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS4_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS4_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS4_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS4_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS4_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS4_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS4_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 6 of 15) (TrTimestampStatus5)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 6 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS5_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS5_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS5_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS5_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS5_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS5_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS5_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS5_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS5_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS5_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS5_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS5_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS5_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS5_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS5_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 7 of 15) (TrTimestampStatus6)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 7 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS6_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS6_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS6_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS6_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS6_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS6_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS6_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS6_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS6_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS6_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS6_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS6_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS6_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS6_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS6_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 8 of 15) (TrTimestampStatus7)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 8 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS7_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS7_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS7_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS7_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS7_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS7_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS7_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS7_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS7_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS7_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS7_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS7_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS7_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS7_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS7_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 9 of 15) (TrTimestampStatus8)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 9 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS8_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS8_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS8_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS8_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS8_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS8_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS8_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS8_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS8_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS8_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS8_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS8_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS8_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS8_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS8_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 10 of 15) (TrTimestampStatus9)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 10 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS9_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS9_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS9_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS9_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS9_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS9_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS9_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS9_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS9_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS9_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS9_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS9_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS9_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS9_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS9_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 11 of 15) (TrTimestampStatus10)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 11 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS10_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS10_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS10_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS10_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS10_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS10_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS10_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS10_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS10_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS10_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS10_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS10_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS10_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS10_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS10_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 12 of 15) (TrTimestampStatus11)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 12 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS11_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS11_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS11_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS11_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS11_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS11_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS11_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS11_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS11_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS11_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS11_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS11_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS11_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS11_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS11_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 13 of 15) (TrTimestampStatus12)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 13 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS12_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS12_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS12_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS12_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS12_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS12_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS12_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS12_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS12_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS12_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS12_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS12_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS12_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS12_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS12_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 14 of 15) (TrTimestampStatus13)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 14 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS13_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS13_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS13_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS13_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS13_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS13_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS13_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS13_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS13_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS13_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS13_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS13_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS13_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS13_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS13_COUNT_SHIFT))

//====================================================================
//Register: Trigger Timestamp Status Register (Instance 15 of 15) (TrTimestampStatus14)
/** \brief This register provides status information about the 18-bit timestamp for the respective HW or FW trigger. <BR>
            TrTimestampStatus0-13 Register serves HW trigger[0-13], and TrTimestampStatus14 Register serves the FW request. <BR> (Instance 15 of 15)*/
//====================================================================

#define  ADC_REGS_TRTIMESTAMPSTATUS14_RESERVED1_MASK 0xfffc0000
#define  ADC_REGS_TRTIMESTAMPSTATUS14_RESERVED1_SHIFT 18
#define  ADC_REGS_TRTIMESTAMPSTATUS14_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS14_RESERVED1_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS14_RESERVED1_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS14_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS14_RESERVED1_SHIFT))

#define  ADC_REGS_TRTIMESTAMPSTATUS14_COUNT_MASK 0x3ffff
#define  ADC_REGS_TRTIMESTAMPSTATUS14_COUNT_SHIFT 0
#define  ADC_REGS_TRTIMESTAMPSTATUS14_COUNT_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRTIMESTAMPSTATUS14_COUNT_MASK) >> ADC_REGS_TRTIMESTAMPSTATUS14_COUNT_SHIFT)
#define  ADC_REGS_TRTIMESTAMPSTATUS14_COUNT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRTIMESTAMPSTATUS14_COUNT_MASK) | (((uint32_t)val) << ADC_REGS_TRTIMESTAMPSTATUS14_COUNT_SHIFT))

//====================================================================
//Register: Threshold1 Register (Threshold1)
/** \brief The threshold registers are used to fire an interrupt when the digitized sample value
             (raw or accumulated result) exceeds the threshold level programmed in these register.
             This is to reduce the processor overhead in monitoring signal levels. <BR>
             Depending if accumulation is enabled or disabled (see Instruction.accum register bit),
             the min/max comparison is applied to the accumulated result or the last sample of the pass,
             respectively. Also see the Instruction.min/max register bits.*/
//====================================================================

#define  ADC_REGS_THRESHOLD1_RESERVED1_MASK 0xffffc000
#define  ADC_REGS_THRESHOLD1_RESERVED1_SHIFT 14
#define  ADC_REGS_THRESHOLD1_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD1_RESERVED1_MASK) >> ADC_REGS_THRESHOLD1_RESERVED1_SHIFT)
#define  ADC_REGS_THRESHOLD1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD1_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD1_RESERVED1_SHIFT))

#define  ADC_REGS_THRESHOLD1_LEVEL_MASK 0x3fff
#define  ADC_REGS_THRESHOLD1_LEVEL_SHIFT 0
#define  ADC_REGS_THRESHOLD1_LEVEL_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD1_LEVEL_MASK) >> ADC_REGS_THRESHOLD1_LEVEL_SHIFT)
#define  ADC_REGS_THRESHOLD1_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD1_LEVEL_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD1_LEVEL_SHIFT))

//====================================================================
//Register: Threshold2 Register (Threshold2)
/** \brief See description for Threshold1 register.*/
//====================================================================

#define  ADC_REGS_THRESHOLD2_RESERVED1_MASK 0xffffc000
#define  ADC_REGS_THRESHOLD2_RESERVED1_SHIFT 14
#define  ADC_REGS_THRESHOLD2_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD2_RESERVED1_MASK) >> ADC_REGS_THRESHOLD2_RESERVED1_SHIFT)
#define  ADC_REGS_THRESHOLD2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD2_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD2_RESERVED1_SHIFT))

#define  ADC_REGS_THRESHOLD2_LEVEL_MASK 0x3fff
#define  ADC_REGS_THRESHOLD2_LEVEL_SHIFT 0
#define  ADC_REGS_THRESHOLD2_LEVEL_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD2_LEVEL_MASK) >> ADC_REGS_THRESHOLD2_LEVEL_SHIFT)
#define  ADC_REGS_THRESHOLD2_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD2_LEVEL_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD2_LEVEL_SHIFT))

//====================================================================
//Register: Threshold3 Register (Threshold3)
/** \brief See description for Threshold1 register.*/
//====================================================================

#define  ADC_REGS_THRESHOLD3_RESERVED1_MASK 0xffffc000
#define  ADC_REGS_THRESHOLD3_RESERVED1_SHIFT 14
#define  ADC_REGS_THRESHOLD3_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD3_RESERVED1_MASK) >> ADC_REGS_THRESHOLD3_RESERVED1_SHIFT)
#define  ADC_REGS_THRESHOLD3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD3_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD3_RESERVED1_SHIFT))

#define  ADC_REGS_THRESHOLD3_LEVEL_MASK 0x3fff
#define  ADC_REGS_THRESHOLD3_LEVEL_SHIFT 0
#define  ADC_REGS_THRESHOLD3_LEVEL_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD3_LEVEL_MASK) >> ADC_REGS_THRESHOLD3_LEVEL_SHIFT)
#define  ADC_REGS_THRESHOLD3_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD3_LEVEL_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD3_LEVEL_SHIFT))

//====================================================================
//Register: Threshold4 Register (Threshold4)
/** \brief See description for Threshold1 register.*/
//====================================================================

#define  ADC_REGS_THRESHOLD4_RESERVED1_MASK 0xffffc000
#define  ADC_REGS_THRESHOLD4_RESERVED1_SHIFT 14
#define  ADC_REGS_THRESHOLD4_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD4_RESERVED1_MASK) >> ADC_REGS_THRESHOLD4_RESERVED1_SHIFT)
#define  ADC_REGS_THRESHOLD4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD4_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD4_RESERVED1_SHIFT))

#define  ADC_REGS_THRESHOLD4_LEVEL_MASK 0x3fff
#define  ADC_REGS_THRESHOLD4_LEVEL_SHIFT 0
#define  ADC_REGS_THRESHOLD4_LEVEL_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD4_LEVEL_MASK) >> ADC_REGS_THRESHOLD4_LEVEL_SHIFT)
#define  ADC_REGS_THRESHOLD4_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD4_LEVEL_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD4_LEVEL_SHIFT))

//====================================================================
//Register: Threshold5 Register (Threshold5)
/** \brief See description for Threshold1 register.*/
//====================================================================

#define  ADC_REGS_THRESHOLD5_RESERVED1_MASK 0xffffc000
#define  ADC_REGS_THRESHOLD5_RESERVED1_SHIFT 14
#define  ADC_REGS_THRESHOLD5_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD5_RESERVED1_MASK) >> ADC_REGS_THRESHOLD5_RESERVED1_SHIFT)
#define  ADC_REGS_THRESHOLD5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD5_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD5_RESERVED1_SHIFT))

#define  ADC_REGS_THRESHOLD5_LEVEL_MASK 0x3fff
#define  ADC_REGS_THRESHOLD5_LEVEL_SHIFT 0
#define  ADC_REGS_THRESHOLD5_LEVEL_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD5_LEVEL_MASK) >> ADC_REGS_THRESHOLD5_LEVEL_SHIFT)
#define  ADC_REGS_THRESHOLD5_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD5_LEVEL_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD5_LEVEL_SHIFT))

//====================================================================
//Register: Threshold6 Register (Threshold6)
/** \brief See description for Threshold1 register.*/
//====================================================================

#define  ADC_REGS_THRESHOLD6_RESERVED1_MASK 0xffffc000
#define  ADC_REGS_THRESHOLD6_RESERVED1_SHIFT 14
#define  ADC_REGS_THRESHOLD6_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD6_RESERVED1_MASK) >> ADC_REGS_THRESHOLD6_RESERVED1_SHIFT)
#define  ADC_REGS_THRESHOLD6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD6_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD6_RESERVED1_SHIFT))

#define  ADC_REGS_THRESHOLD6_LEVEL_MASK 0x3fff
#define  ADC_REGS_THRESHOLD6_LEVEL_SHIFT 0
#define  ADC_REGS_THRESHOLD6_LEVEL_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD6_LEVEL_MASK) >> ADC_REGS_THRESHOLD6_LEVEL_SHIFT)
#define  ADC_REGS_THRESHOLD6_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD6_LEVEL_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD6_LEVEL_SHIFT))

//====================================================================
//Register: Threshold7 Register (Threshold7)
/** \brief See description for Threshold1 register.*/
//====================================================================

#define  ADC_REGS_THRESHOLD7_RESERVED1_MASK 0xffffc000
#define  ADC_REGS_THRESHOLD7_RESERVED1_SHIFT 14
#define  ADC_REGS_THRESHOLD7_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD7_RESERVED1_MASK) >> ADC_REGS_THRESHOLD7_RESERVED1_SHIFT)
#define  ADC_REGS_THRESHOLD7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD7_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD7_RESERVED1_SHIFT))

#define  ADC_REGS_THRESHOLD7_LEVEL_MASK 0x3fff
#define  ADC_REGS_THRESHOLD7_LEVEL_SHIFT 0
#define  ADC_REGS_THRESHOLD7_LEVEL_MASK_SHIFT(reg) (((reg) & ADC_REGS_THRESHOLD7_LEVEL_MASK) >> ADC_REGS_THRESHOLD7_LEVEL_SHIFT)
#define  ADC_REGS_THRESHOLD7_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_THRESHOLD7_LEVEL_MASK) | (((uint32_t)val) << ADC_REGS_THRESHOLD7_LEVEL_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (IntEna)
/** \brief 0=disable interrupt. 1=enable interrupt.<BR>*/
//====================================================================

#define  ADC_REGS_INTENA_RESERVED1_MASK 0xff000000
#define  ADC_REGS_INTENA_RESERVED1_SHIFT 24
#define  ADC_REGS_INTENA_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTENA_RESERVED1_MASK) >> ADC_REGS_INTENA_RESERVED1_SHIFT)
#define  ADC_REGS_INTENA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTENA_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INTENA_RESERVED1_SHIFT))

#define  ADC_REGS_INTENA_RXFIFO2_OVERFLOW_MASK 0x800000
#define  ADC_REGS_INTENA_RXFIFO2_OVERFLOW_SHIFT 23
#define  ADC_REGS_INTENA_RXFIFO2_OVERFLOW_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTENA_RXFIFO2_OVERFLOW_MASK) >> ADC_REGS_INTENA_RXFIFO2_OVERFLOW_SHIFT)
#define  ADC_REGS_INTENA_RXFIFO2_OVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTENA_RXFIFO2_OVERFLOW_MASK) | (((uint32_t)val) << ADC_REGS_INTENA_RXFIFO2_OVERFLOW_SHIFT))

#define  ADC_REGS_INTENA_RXFIFO1_OVERFLOW_MASK 0x400000
#define  ADC_REGS_INTENA_RXFIFO1_OVERFLOW_SHIFT 22
#define  ADC_REGS_INTENA_RXFIFO1_OVERFLOW_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTENA_RXFIFO1_OVERFLOW_MASK) >> ADC_REGS_INTENA_RXFIFO1_OVERFLOW_SHIFT)
#define  ADC_REGS_INTENA_RXFIFO1_OVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTENA_RXFIFO1_OVERFLOW_MASK) | (((uint32_t)val) << ADC_REGS_INTENA_RXFIFO1_OVERFLOW_SHIFT))

#define  ADC_REGS_INTENA_RXFIFO2_ALMOSTFULL_MASK 0x200000
#define  ADC_REGS_INTENA_RXFIFO2_ALMOSTFULL_SHIFT 21
#define  ADC_REGS_INTENA_RXFIFO2_ALMOSTFULL_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTENA_RXFIFO2_ALMOSTFULL_MASK) >> ADC_REGS_INTENA_RXFIFO2_ALMOSTFULL_SHIFT)
#define  ADC_REGS_INTENA_RXFIFO2_ALMOSTFULL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTENA_RXFIFO2_ALMOSTFULL_MASK) | (((uint32_t)val) << ADC_REGS_INTENA_RXFIFO2_ALMOSTFULL_SHIFT))

#define  ADC_REGS_INTENA_RXFIFO1_ALMOSTFULL_MASK 0x100000
#define  ADC_REGS_INTENA_RXFIFO1_ALMOSTFULL_SHIFT 20
#define  ADC_REGS_INTENA_RXFIFO1_ALMOSTFULL_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTENA_RXFIFO1_ALMOSTFULL_MASK) >> ADC_REGS_INTENA_RXFIFO1_ALMOSTFULL_SHIFT)
#define  ADC_REGS_INTENA_RXFIFO1_ALMOSTFULL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTENA_RXFIFO1_ALMOSTFULL_MASK) | (((uint32_t)val) << ADC_REGS_INTENA_RXFIFO1_ALMOSTFULL_SHIFT))

#define  ADC_REGS_INTENA_RESERVED2_MASK 0x80000
#define  ADC_REGS_INTENA_RESERVED2_SHIFT 19
#define  ADC_REGS_INTENA_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTENA_RESERVED2_MASK) >> ADC_REGS_INTENA_RESERVED2_SHIFT)
#define  ADC_REGS_INTENA_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTENA_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INTENA_RESERVED2_SHIFT))

#define  ADC_REGS_INTENA_BYP_DONE_MASK 0x40000
#define  ADC_REGS_INTENA_BYP_DONE_SHIFT 18
#define  ADC_REGS_INTENA_BYP_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTENA_BYP_DONE_MASK) >> ADC_REGS_INTENA_BYP_DONE_SHIFT)
#define  ADC_REGS_INTENA_BYP_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTENA_BYP_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTENA_BYP_DONE_SHIFT))

#define  ADC_REGS_INTENA_CONT_DONE_MASK 0x20000
#define  ADC_REGS_INTENA_CONT_DONE_SHIFT 17
#define  ADC_REGS_INTENA_CONT_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTENA_CONT_DONE_MASK) >> ADC_REGS_INTENA_CONT_DONE_SHIFT)
#define  ADC_REGS_INTENA_CONT_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTENA_CONT_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTENA_CONT_DONE_SHIFT))

#define  ADC_REGS_INTENA_FW_DONE_MASK 0x10000
#define  ADC_REGS_INTENA_FW_DONE_SHIFT 16
#define  ADC_REGS_INTENA_FW_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTENA_FW_DONE_MASK) >> ADC_REGS_INTENA_FW_DONE_SHIFT)
#define  ADC_REGS_INTENA_FW_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTENA_FW_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTENA_FW_DONE_SHIFT))

#define  ADC_REGS_INTENA_RESERVED3_MASK 0xc000
#define  ADC_REGS_INTENA_RESERVED3_SHIFT 14
#define  ADC_REGS_INTENA_RESERVED3_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTENA_RESERVED3_MASK) >> ADC_REGS_INTENA_RESERVED3_SHIFT)
#define  ADC_REGS_INTENA_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTENA_RESERVED3_MASK) | (((uint32_t)val) << ADC_REGS_INTENA_RESERVED3_SHIFT))

#define  ADC_REGS_INTENA_HW_TRIGGER_DONE_MASK 0x3fff
#define  ADC_REGS_INTENA_HW_TRIGGER_DONE_SHIFT 0
#define  ADC_REGS_INTENA_HW_TRIGGER_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTENA_HW_TRIGGER_DONE_MASK) >> ADC_REGS_INTENA_HW_TRIGGER_DONE_SHIFT)
#define  ADC_REGS_INTENA_HW_TRIGGER_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTENA_HW_TRIGGER_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTENA_HW_TRIGGER_DONE_SHIFT))

//====================================================================
//Register: Interrupt Raw Register (IntRaw)
/** \brief This register represents the pre-masked interrupt condition. <BR>
        Remains set until cleared by writing the Interrupt Acknowledge register. <BR>*/
//====================================================================

#define  ADC_REGS_INTRAW_RESERVED1_MASK 0xfc000000
#define  ADC_REGS_INTRAW_RESERVED1_SHIFT 26
#define  ADC_REGS_INTRAW_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_RESERVED1_MASK) >> ADC_REGS_INTRAW_RESERVED1_SHIFT)
#define  ADC_REGS_INTRAW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_RESERVED1_SHIFT))

#define  ADC_REGS_INTRAW_RXFIFO2_EMPTY_MASK 0x2000000
#define  ADC_REGS_INTRAW_RXFIFO2_EMPTY_SHIFT 25
#define  ADC_REGS_INTRAW_RXFIFO2_EMPTY_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_RXFIFO2_EMPTY_MASK) >> ADC_REGS_INTRAW_RXFIFO2_EMPTY_SHIFT)
#define  ADC_REGS_INTRAW_RXFIFO2_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_RXFIFO2_EMPTY_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_RXFIFO2_EMPTY_SHIFT))

#define  ADC_REGS_INTRAW_RXFIFO1_EMPTY_MASK 0x1000000
#define  ADC_REGS_INTRAW_RXFIFO1_EMPTY_SHIFT 24
#define  ADC_REGS_INTRAW_RXFIFO1_EMPTY_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_RXFIFO1_EMPTY_MASK) >> ADC_REGS_INTRAW_RXFIFO1_EMPTY_SHIFT)
#define  ADC_REGS_INTRAW_RXFIFO1_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_RXFIFO1_EMPTY_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_RXFIFO1_EMPTY_SHIFT))

#define  ADC_REGS_INTRAW_RXFIFO2_OVERFLOW_MASK 0x800000
#define  ADC_REGS_INTRAW_RXFIFO2_OVERFLOW_SHIFT 23
#define  ADC_REGS_INTRAW_RXFIFO2_OVERFLOW_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_RXFIFO2_OVERFLOW_MASK) >> ADC_REGS_INTRAW_RXFIFO2_OVERFLOW_SHIFT)
#define  ADC_REGS_INTRAW_RXFIFO2_OVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_RXFIFO2_OVERFLOW_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_RXFIFO2_OVERFLOW_SHIFT))

#define  ADC_REGS_INTRAW_RXFIFO1_OVERFLOW_MASK 0x400000
#define  ADC_REGS_INTRAW_RXFIFO1_OVERFLOW_SHIFT 22
#define  ADC_REGS_INTRAW_RXFIFO1_OVERFLOW_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_RXFIFO1_OVERFLOW_MASK) >> ADC_REGS_INTRAW_RXFIFO1_OVERFLOW_SHIFT)
#define  ADC_REGS_INTRAW_RXFIFO1_OVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_RXFIFO1_OVERFLOW_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_RXFIFO1_OVERFLOW_SHIFT))

#define  ADC_REGS_INTRAW_RXFIFO2_ALMOSTFULL_MASK 0x200000
#define  ADC_REGS_INTRAW_RXFIFO2_ALMOSTFULL_SHIFT 21
#define  ADC_REGS_INTRAW_RXFIFO2_ALMOSTFULL_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_RXFIFO2_ALMOSTFULL_MASK) >> ADC_REGS_INTRAW_RXFIFO2_ALMOSTFULL_SHIFT)
#define  ADC_REGS_INTRAW_RXFIFO2_ALMOSTFULL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_RXFIFO2_ALMOSTFULL_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_RXFIFO2_ALMOSTFULL_SHIFT))

#define  ADC_REGS_INTRAW_RXFIFO1_ALMOSTFULL_MASK 0x100000
#define  ADC_REGS_INTRAW_RXFIFO1_ALMOSTFULL_SHIFT 20
#define  ADC_REGS_INTRAW_RXFIFO1_ALMOSTFULL_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_RXFIFO1_ALMOSTFULL_MASK) >> ADC_REGS_INTRAW_RXFIFO1_ALMOSTFULL_SHIFT)
#define  ADC_REGS_INTRAW_RXFIFO1_ALMOSTFULL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_RXFIFO1_ALMOSTFULL_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_RXFIFO1_ALMOSTFULL_SHIFT))

#define  ADC_REGS_INTRAW_RESERVED2_MASK 0x80000
#define  ADC_REGS_INTRAW_RESERVED2_SHIFT 19
#define  ADC_REGS_INTRAW_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_RESERVED2_MASK) >> ADC_REGS_INTRAW_RESERVED2_SHIFT)
#define  ADC_REGS_INTRAW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_RESERVED2_SHIFT))

#define  ADC_REGS_INTRAW_BYP_DONE_MASK 0x40000
#define  ADC_REGS_INTRAW_BYP_DONE_SHIFT 18
#define  ADC_REGS_INTRAW_BYP_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_BYP_DONE_MASK) >> ADC_REGS_INTRAW_BYP_DONE_SHIFT)
#define  ADC_REGS_INTRAW_BYP_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_BYP_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_BYP_DONE_SHIFT))

#define  ADC_REGS_INTRAW_CONT_DONE_MASK 0x20000
#define  ADC_REGS_INTRAW_CONT_DONE_SHIFT 17
#define  ADC_REGS_INTRAW_CONT_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_CONT_DONE_MASK) >> ADC_REGS_INTRAW_CONT_DONE_SHIFT)
#define  ADC_REGS_INTRAW_CONT_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_CONT_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_CONT_DONE_SHIFT))

#define  ADC_REGS_INTRAW_FW_DONE_MASK 0x10000
#define  ADC_REGS_INTRAW_FW_DONE_SHIFT 16
#define  ADC_REGS_INTRAW_FW_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_FW_DONE_MASK) >> ADC_REGS_INTRAW_FW_DONE_SHIFT)
#define  ADC_REGS_INTRAW_FW_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_FW_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_FW_DONE_SHIFT))

#define  ADC_REGS_INTRAW_RESERVED3_MASK 0xc000
#define  ADC_REGS_INTRAW_RESERVED3_SHIFT 14
#define  ADC_REGS_INTRAW_RESERVED3_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_RESERVED3_MASK) >> ADC_REGS_INTRAW_RESERVED3_SHIFT)
#define  ADC_REGS_INTRAW_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_RESERVED3_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_RESERVED3_SHIFT))

#define  ADC_REGS_INTRAW_HW_TRIGGER_DONE_MASK 0x3fff
#define  ADC_REGS_INTRAW_HW_TRIGGER_DONE_SHIFT 0
#define  ADC_REGS_INTRAW_HW_TRIGGER_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTRAW_HW_TRIGGER_DONE_MASK) >> ADC_REGS_INTRAW_HW_TRIGGER_DONE_SHIFT)
#define  ADC_REGS_INTRAW_HW_TRIGGER_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTRAW_HW_TRIGGER_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTRAW_HW_TRIGGER_DONE_SHIFT))

//====================================================================
//Register: Interrupt Active Register (IntActive)
/** \brief This register represents the post-masked interrupt condition: IntActive = IntRaw AND IntEna.<BR>*/
//====================================================================

#define  ADC_REGS_INTACTIVE_RESERVED1_MASK 0xff000000
#define  ADC_REGS_INTACTIVE_RESERVED1_SHIFT 24
#define  ADC_REGS_INTACTIVE_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACTIVE_RESERVED1_MASK) >> ADC_REGS_INTACTIVE_RESERVED1_SHIFT)
#define  ADC_REGS_INTACTIVE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACTIVE_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INTACTIVE_RESERVED1_SHIFT))

#define  ADC_REGS_INTACTIVE_RXFIFO2_OVERFLOW_MASK 0x800000
#define  ADC_REGS_INTACTIVE_RXFIFO2_OVERFLOW_SHIFT 23
#define  ADC_REGS_INTACTIVE_RXFIFO2_OVERFLOW_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACTIVE_RXFIFO2_OVERFLOW_MASK) >> ADC_REGS_INTACTIVE_RXFIFO2_OVERFLOW_SHIFT)
#define  ADC_REGS_INTACTIVE_RXFIFO2_OVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACTIVE_RXFIFO2_OVERFLOW_MASK) | (((uint32_t)val) << ADC_REGS_INTACTIVE_RXFIFO2_OVERFLOW_SHIFT))

#define  ADC_REGS_INTACTIVE_RXFIFO1_OVERFLOW_MASK 0x400000
#define  ADC_REGS_INTACTIVE_RXFIFO1_OVERFLOW_SHIFT 22
#define  ADC_REGS_INTACTIVE_RXFIFO1_OVERFLOW_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACTIVE_RXFIFO1_OVERFLOW_MASK) >> ADC_REGS_INTACTIVE_RXFIFO1_OVERFLOW_SHIFT)
#define  ADC_REGS_INTACTIVE_RXFIFO1_OVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACTIVE_RXFIFO1_OVERFLOW_MASK) | (((uint32_t)val) << ADC_REGS_INTACTIVE_RXFIFO1_OVERFLOW_SHIFT))

#define  ADC_REGS_INTACTIVE_RXFIFO2_ALMOSTFULL_MASK 0x200000
#define  ADC_REGS_INTACTIVE_RXFIFO2_ALMOSTFULL_SHIFT 21
#define  ADC_REGS_INTACTIVE_RXFIFO2_ALMOSTFULL_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACTIVE_RXFIFO2_ALMOSTFULL_MASK) >> ADC_REGS_INTACTIVE_RXFIFO2_ALMOSTFULL_SHIFT)
#define  ADC_REGS_INTACTIVE_RXFIFO2_ALMOSTFULL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACTIVE_RXFIFO2_ALMOSTFULL_MASK) | (((uint32_t)val) << ADC_REGS_INTACTIVE_RXFIFO2_ALMOSTFULL_SHIFT))

#define  ADC_REGS_INTACTIVE_RXFIFO1_ALMOSTFULL_MASK 0x100000
#define  ADC_REGS_INTACTIVE_RXFIFO1_ALMOSTFULL_SHIFT 20
#define  ADC_REGS_INTACTIVE_RXFIFO1_ALMOSTFULL_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACTIVE_RXFIFO1_ALMOSTFULL_MASK) >> ADC_REGS_INTACTIVE_RXFIFO1_ALMOSTFULL_SHIFT)
#define  ADC_REGS_INTACTIVE_RXFIFO1_ALMOSTFULL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACTIVE_RXFIFO1_ALMOSTFULL_MASK) | (((uint32_t)val) << ADC_REGS_INTACTIVE_RXFIFO1_ALMOSTFULL_SHIFT))

#define  ADC_REGS_INTACTIVE_RESERVED2_MASK 0x80000
#define  ADC_REGS_INTACTIVE_RESERVED2_SHIFT 19
#define  ADC_REGS_INTACTIVE_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACTIVE_RESERVED2_MASK) >> ADC_REGS_INTACTIVE_RESERVED2_SHIFT)
#define  ADC_REGS_INTACTIVE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACTIVE_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INTACTIVE_RESERVED2_SHIFT))

#define  ADC_REGS_INTACTIVE_BYP_DONE_MASK 0x40000
#define  ADC_REGS_INTACTIVE_BYP_DONE_SHIFT 18
#define  ADC_REGS_INTACTIVE_BYP_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACTIVE_BYP_DONE_MASK) >> ADC_REGS_INTACTIVE_BYP_DONE_SHIFT)
#define  ADC_REGS_INTACTIVE_BYP_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACTIVE_BYP_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTACTIVE_BYP_DONE_SHIFT))

#define  ADC_REGS_INTACTIVE_CONT_DONE_MASK 0x20000
#define  ADC_REGS_INTACTIVE_CONT_DONE_SHIFT 17
#define  ADC_REGS_INTACTIVE_CONT_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACTIVE_CONT_DONE_MASK) >> ADC_REGS_INTACTIVE_CONT_DONE_SHIFT)
#define  ADC_REGS_INTACTIVE_CONT_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACTIVE_CONT_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTACTIVE_CONT_DONE_SHIFT))

#define  ADC_REGS_INTACTIVE_FW_DONE_MASK 0x10000
#define  ADC_REGS_INTACTIVE_FW_DONE_SHIFT 16
#define  ADC_REGS_INTACTIVE_FW_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACTIVE_FW_DONE_MASK) >> ADC_REGS_INTACTIVE_FW_DONE_SHIFT)
#define  ADC_REGS_INTACTIVE_FW_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACTIVE_FW_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTACTIVE_FW_DONE_SHIFT))

#define  ADC_REGS_INTACTIVE_RESERVED3_MASK 0xc000
#define  ADC_REGS_INTACTIVE_RESERVED3_SHIFT 14
#define  ADC_REGS_INTACTIVE_RESERVED3_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACTIVE_RESERVED3_MASK) >> ADC_REGS_INTACTIVE_RESERVED3_SHIFT)
#define  ADC_REGS_INTACTIVE_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACTIVE_RESERVED3_MASK) | (((uint32_t)val) << ADC_REGS_INTACTIVE_RESERVED3_SHIFT))

#define  ADC_REGS_INTACTIVE_HW_TRIGGER_DONE_MASK 0x3fff
#define  ADC_REGS_INTACTIVE_HW_TRIGGER_DONE_SHIFT 0
#define  ADC_REGS_INTACTIVE_HW_TRIGGER_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACTIVE_HW_TRIGGER_DONE_MASK) >> ADC_REGS_INTACTIVE_HW_TRIGGER_DONE_SHIFT)
#define  ADC_REGS_INTACTIVE_HW_TRIGGER_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACTIVE_HW_TRIGGER_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTACTIVE_HW_TRIGGER_DONE_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (IntAck)
/** \brief Writing a 1 to an IntAck bit will clear the corresponding interrupt bit, raw and active.<BR>*/
//====================================================================

#define  ADC_REGS_INTACK_RESERVED1_MASK 0xff000000
#define  ADC_REGS_INTACK_RESERVED1_SHIFT 24
#define  ADC_REGS_INTACK_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACK_RESERVED1_MASK) >> ADC_REGS_INTACK_RESERVED1_SHIFT)
#define  ADC_REGS_INTACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACK_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INTACK_RESERVED1_SHIFT))

#define  ADC_REGS_INTACK_RXFIFO2_OVERFLOW_MASK 0x800000
#define  ADC_REGS_INTACK_RXFIFO2_OVERFLOW_SHIFT 23
#define  ADC_REGS_INTACK_RXFIFO2_OVERFLOW_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACK_RXFIFO2_OVERFLOW_MASK) >> ADC_REGS_INTACK_RXFIFO2_OVERFLOW_SHIFT)
#define  ADC_REGS_INTACK_RXFIFO2_OVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACK_RXFIFO2_OVERFLOW_MASK) | (((uint32_t)val) << ADC_REGS_INTACK_RXFIFO2_OVERFLOW_SHIFT))

#define  ADC_REGS_INTACK_RXFIFO1_OVERFLOW_MASK 0x400000
#define  ADC_REGS_INTACK_RXFIFO1_OVERFLOW_SHIFT 22
#define  ADC_REGS_INTACK_RXFIFO1_OVERFLOW_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACK_RXFIFO1_OVERFLOW_MASK) >> ADC_REGS_INTACK_RXFIFO1_OVERFLOW_SHIFT)
#define  ADC_REGS_INTACK_RXFIFO1_OVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACK_RXFIFO1_OVERFLOW_MASK) | (((uint32_t)val) << ADC_REGS_INTACK_RXFIFO1_OVERFLOW_SHIFT))

#define  ADC_REGS_INTACK_RXFIFO2_ALMOSTFULL_MASK 0x200000
#define  ADC_REGS_INTACK_RXFIFO2_ALMOSTFULL_SHIFT 21
#define  ADC_REGS_INTACK_RXFIFO2_ALMOSTFULL_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACK_RXFIFO2_ALMOSTFULL_MASK) >> ADC_REGS_INTACK_RXFIFO2_ALMOSTFULL_SHIFT)
#define  ADC_REGS_INTACK_RXFIFO2_ALMOSTFULL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACK_RXFIFO2_ALMOSTFULL_MASK) | (((uint32_t)val) << ADC_REGS_INTACK_RXFIFO2_ALMOSTFULL_SHIFT))

#define  ADC_REGS_INTACK_RXFIFO1_ALMOSTFULL_MASK 0x100000
#define  ADC_REGS_INTACK_RXFIFO1_ALMOSTFULL_SHIFT 20
#define  ADC_REGS_INTACK_RXFIFO1_ALMOSTFULL_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACK_RXFIFO1_ALMOSTFULL_MASK) >> ADC_REGS_INTACK_RXFIFO1_ALMOSTFULL_SHIFT)
#define  ADC_REGS_INTACK_RXFIFO1_ALMOSTFULL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACK_RXFIFO1_ALMOSTFULL_MASK) | (((uint32_t)val) << ADC_REGS_INTACK_RXFIFO1_ALMOSTFULL_SHIFT))

#define  ADC_REGS_INTACK_RESERVED2_MASK 0x80000
#define  ADC_REGS_INTACK_RESERVED2_SHIFT 19
#define  ADC_REGS_INTACK_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACK_RESERVED2_MASK) >> ADC_REGS_INTACK_RESERVED2_SHIFT)
#define  ADC_REGS_INTACK_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACK_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INTACK_RESERVED2_SHIFT))

#define  ADC_REGS_INTACK_BYP_DONE_MASK 0x40000
#define  ADC_REGS_INTACK_BYP_DONE_SHIFT 18
#define  ADC_REGS_INTACK_BYP_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACK_BYP_DONE_MASK) >> ADC_REGS_INTACK_BYP_DONE_SHIFT)
#define  ADC_REGS_INTACK_BYP_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACK_BYP_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTACK_BYP_DONE_SHIFT))

#define  ADC_REGS_INTACK_CONT_DONE_MASK 0x20000
#define  ADC_REGS_INTACK_CONT_DONE_SHIFT 17
#define  ADC_REGS_INTACK_CONT_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACK_CONT_DONE_MASK) >> ADC_REGS_INTACK_CONT_DONE_SHIFT)
#define  ADC_REGS_INTACK_CONT_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACK_CONT_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTACK_CONT_DONE_SHIFT))

#define  ADC_REGS_INTACK_FW_DONE_MASK 0x10000
#define  ADC_REGS_INTACK_FW_DONE_SHIFT 16
#define  ADC_REGS_INTACK_FW_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACK_FW_DONE_MASK) >> ADC_REGS_INTACK_FW_DONE_SHIFT)
#define  ADC_REGS_INTACK_FW_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACK_FW_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTACK_FW_DONE_SHIFT))

#define  ADC_REGS_INTACK_RESERVED3_MASK 0xc000
#define  ADC_REGS_INTACK_RESERVED3_SHIFT 14
#define  ADC_REGS_INTACK_RESERVED3_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACK_RESERVED3_MASK) >> ADC_REGS_INTACK_RESERVED3_SHIFT)
#define  ADC_REGS_INTACK_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACK_RESERVED3_MASK) | (((uint32_t)val) << ADC_REGS_INTACK_RESERVED3_SHIFT))

#define  ADC_REGS_INTACK_HW_TRIGGER_DONE_MASK 0x3fff
#define  ADC_REGS_INTACK_HW_TRIGGER_DONE_SHIFT 0
#define  ADC_REGS_INTACK_HW_TRIGGER_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTACK_HW_TRIGGER_DONE_MASK) >> ADC_REGS_INTACK_HW_TRIGGER_DONE_SHIFT)
#define  ADC_REGS_INTACK_HW_TRIGGER_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTACK_HW_TRIGGER_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTACK_HW_TRIGGER_DONE_SHIFT))

//====================================================================
//Register: Interrupt Force Register (IntForce)
/** \brief 0 = do nothing, 1 = set corresponding interrupt bit, raw and active if enabled.<BR>*/
//====================================================================

#define  ADC_REGS_INTFORCE_RESERVED1_MASK 0xff000000
#define  ADC_REGS_INTFORCE_RESERVED1_SHIFT 24
#define  ADC_REGS_INTFORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTFORCE_RESERVED1_MASK) >> ADC_REGS_INTFORCE_RESERVED1_SHIFT)
#define  ADC_REGS_INTFORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTFORCE_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INTFORCE_RESERVED1_SHIFT))

#define  ADC_REGS_INTFORCE_RXFIFO2_OVERFLOW_MASK 0x800000
#define  ADC_REGS_INTFORCE_RXFIFO2_OVERFLOW_SHIFT 23
#define  ADC_REGS_INTFORCE_RXFIFO2_OVERFLOW_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTFORCE_RXFIFO2_OVERFLOW_MASK) >> ADC_REGS_INTFORCE_RXFIFO2_OVERFLOW_SHIFT)
#define  ADC_REGS_INTFORCE_RXFIFO2_OVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTFORCE_RXFIFO2_OVERFLOW_MASK) | (((uint32_t)val) << ADC_REGS_INTFORCE_RXFIFO2_OVERFLOW_SHIFT))

#define  ADC_REGS_INTFORCE_RXFIFO1_OVERFLOW_MASK 0x400000
#define  ADC_REGS_INTFORCE_RXFIFO1_OVERFLOW_SHIFT 22
#define  ADC_REGS_INTFORCE_RXFIFO1_OVERFLOW_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTFORCE_RXFIFO1_OVERFLOW_MASK) >> ADC_REGS_INTFORCE_RXFIFO1_OVERFLOW_SHIFT)
#define  ADC_REGS_INTFORCE_RXFIFO1_OVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTFORCE_RXFIFO1_OVERFLOW_MASK) | (((uint32_t)val) << ADC_REGS_INTFORCE_RXFIFO1_OVERFLOW_SHIFT))

#define  ADC_REGS_INTFORCE_RXFIFO2_ALMOSTFULL_MASK 0x200000
#define  ADC_REGS_INTFORCE_RXFIFO2_ALMOSTFULL_SHIFT 21
#define  ADC_REGS_INTFORCE_RXFIFO2_ALMOSTFULL_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTFORCE_RXFIFO2_ALMOSTFULL_MASK) >> ADC_REGS_INTFORCE_RXFIFO2_ALMOSTFULL_SHIFT)
#define  ADC_REGS_INTFORCE_RXFIFO2_ALMOSTFULL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTFORCE_RXFIFO2_ALMOSTFULL_MASK) | (((uint32_t)val) << ADC_REGS_INTFORCE_RXFIFO2_ALMOSTFULL_SHIFT))

#define  ADC_REGS_INTFORCE_RXFIFO1_ALMOSTFULL_MASK 0x100000
#define  ADC_REGS_INTFORCE_RXFIFO1_ALMOSTFULL_SHIFT 20
#define  ADC_REGS_INTFORCE_RXFIFO1_ALMOSTFULL_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTFORCE_RXFIFO1_ALMOSTFULL_MASK) >> ADC_REGS_INTFORCE_RXFIFO1_ALMOSTFULL_SHIFT)
#define  ADC_REGS_INTFORCE_RXFIFO1_ALMOSTFULL_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTFORCE_RXFIFO1_ALMOSTFULL_MASK) | (((uint32_t)val) << ADC_REGS_INTFORCE_RXFIFO1_ALMOSTFULL_SHIFT))

#define  ADC_REGS_INTFORCE_RESERVED2_MASK 0x80000
#define  ADC_REGS_INTFORCE_RESERVED2_SHIFT 19
#define  ADC_REGS_INTFORCE_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTFORCE_RESERVED2_MASK) >> ADC_REGS_INTFORCE_RESERVED2_SHIFT)
#define  ADC_REGS_INTFORCE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTFORCE_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INTFORCE_RESERVED2_SHIFT))

#define  ADC_REGS_INTFORCE_BYP_DONE_MASK 0x40000
#define  ADC_REGS_INTFORCE_BYP_DONE_SHIFT 18
#define  ADC_REGS_INTFORCE_BYP_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTFORCE_BYP_DONE_MASK) >> ADC_REGS_INTFORCE_BYP_DONE_SHIFT)
#define  ADC_REGS_INTFORCE_BYP_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTFORCE_BYP_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTFORCE_BYP_DONE_SHIFT))

#define  ADC_REGS_INTFORCE_CONT_DONE_MASK 0x20000
#define  ADC_REGS_INTFORCE_CONT_DONE_SHIFT 17
#define  ADC_REGS_INTFORCE_CONT_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTFORCE_CONT_DONE_MASK) >> ADC_REGS_INTFORCE_CONT_DONE_SHIFT)
#define  ADC_REGS_INTFORCE_CONT_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTFORCE_CONT_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTFORCE_CONT_DONE_SHIFT))

#define  ADC_REGS_INTFORCE_FW_DONE_MASK 0x10000
#define  ADC_REGS_INTFORCE_FW_DONE_SHIFT 16
#define  ADC_REGS_INTFORCE_FW_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTFORCE_FW_DONE_MASK) >> ADC_REGS_INTFORCE_FW_DONE_SHIFT)
#define  ADC_REGS_INTFORCE_FW_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTFORCE_FW_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTFORCE_FW_DONE_SHIFT))

#define  ADC_REGS_INTFORCE_RESERVED3_MASK 0xc000
#define  ADC_REGS_INTFORCE_RESERVED3_SHIFT 14
#define  ADC_REGS_INTFORCE_RESERVED3_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTFORCE_RESERVED3_MASK) >> ADC_REGS_INTFORCE_RESERVED3_SHIFT)
#define  ADC_REGS_INTFORCE_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTFORCE_RESERVED3_MASK) | (((uint32_t)val) << ADC_REGS_INTFORCE_RESERVED3_SHIFT))

#define  ADC_REGS_INTFORCE_HW_TRIGGER_DONE_MASK 0x3fff
#define  ADC_REGS_INTFORCE_HW_TRIGGER_DONE_SHIFT 0
#define  ADC_REGS_INTFORCE_HW_TRIGGER_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_INTFORCE_HW_TRIGGER_DONE_MASK) >> ADC_REGS_INTFORCE_HW_TRIGGER_DONE_SHIFT)
#define  ADC_REGS_INTFORCE_HW_TRIGGER_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INTFORCE_HW_TRIGGER_DONE_MASK) | (((uint32_t)val) << ADC_REGS_INTFORCE_HW_TRIGGER_DONE_SHIFT))

//====================================================================
//Register: Interrupt2 Enable Register (Int2Ena)
/** \brief 0=disable interrupt. 1=enable interrupt.<BR>*/
//====================================================================

#define  ADC_REGS_INT2ENA_RESERVED1_MASK 0xffff0000
#define  ADC_REGS_INT2ENA_RESERVED1_SHIFT 16
#define  ADC_REGS_INT2ENA_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INT2ENA_RESERVED1_MASK) >> ADC_REGS_INT2ENA_RESERVED1_SHIFT)
#define  ADC_REGS_INT2ENA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INT2ENA_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INT2ENA_RESERVED1_SHIFT))

#define  ADC_REGS_INT2ENA_THRESHOLD_MASK 0xffff
#define  ADC_REGS_INT2ENA_THRESHOLD_SHIFT 0
#define  ADC_REGS_INT2ENA_THRESHOLD_MASK_SHIFT(reg) (((reg) & ADC_REGS_INT2ENA_THRESHOLD_MASK) >> ADC_REGS_INT2ENA_THRESHOLD_SHIFT)
#define  ADC_REGS_INT2ENA_THRESHOLD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INT2ENA_THRESHOLD_MASK) | (((uint32_t)val) << ADC_REGS_INT2ENA_THRESHOLD_SHIFT))

//====================================================================
//Register: Interrupt2 Raw Register (Int2Raw)
/** \brief This register represents the pre-masked interrupt condition. <BR>
        Remains set until cleared by writing the Interrupt Acknowledge register. <BR>*/
//====================================================================

#define  ADC_REGS_INT2RAW_RESERVED1_MASK 0xffff0000
#define  ADC_REGS_INT2RAW_RESERVED1_SHIFT 16
#define  ADC_REGS_INT2RAW_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INT2RAW_RESERVED1_MASK) >> ADC_REGS_INT2RAW_RESERVED1_SHIFT)
#define  ADC_REGS_INT2RAW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INT2RAW_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INT2RAW_RESERVED1_SHIFT))

#define  ADC_REGS_INT2RAW_THRESHOLD_MASK 0xffff
#define  ADC_REGS_INT2RAW_THRESHOLD_SHIFT 0
#define  ADC_REGS_INT2RAW_THRESHOLD_MASK_SHIFT(reg) (((reg) & ADC_REGS_INT2RAW_THRESHOLD_MASK) >> ADC_REGS_INT2RAW_THRESHOLD_SHIFT)
#define  ADC_REGS_INT2RAW_THRESHOLD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INT2RAW_THRESHOLD_MASK) | (((uint32_t)val) << ADC_REGS_INT2RAW_THRESHOLD_SHIFT))

//====================================================================
//Register: Interrupt2 Active Register (Int2Active)
/** \brief This register represents the post-masked interrupt condition: IntActive = IntRaw AND IntEna.<BR>*/
//====================================================================

#define  ADC_REGS_INT2ACTIVE_RESERVED1_MASK 0xffff0000
#define  ADC_REGS_INT2ACTIVE_RESERVED1_SHIFT 16
#define  ADC_REGS_INT2ACTIVE_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INT2ACTIVE_RESERVED1_MASK) >> ADC_REGS_INT2ACTIVE_RESERVED1_SHIFT)
#define  ADC_REGS_INT2ACTIVE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INT2ACTIVE_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INT2ACTIVE_RESERVED1_SHIFT))

#define  ADC_REGS_INT2ACTIVE_THRESHOLD_MASK 0xffff
#define  ADC_REGS_INT2ACTIVE_THRESHOLD_SHIFT 0
#define  ADC_REGS_INT2ACTIVE_THRESHOLD_MASK_SHIFT(reg) (((reg) & ADC_REGS_INT2ACTIVE_THRESHOLD_MASK) >> ADC_REGS_INT2ACTIVE_THRESHOLD_SHIFT)
#define  ADC_REGS_INT2ACTIVE_THRESHOLD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INT2ACTIVE_THRESHOLD_MASK) | (((uint32_t)val) << ADC_REGS_INT2ACTIVE_THRESHOLD_SHIFT))

//====================================================================
//Register: Interrupt2 Acknowledge Register (Int2Ack)
/** \brief Writing a 1 to an IntAck bit will clear the corresponding interrupt bit, raw and active.<BR>*/
//====================================================================

#define  ADC_REGS_INT2ACK_RESERVED1_MASK 0xffff0000
#define  ADC_REGS_INT2ACK_RESERVED1_SHIFT 16
#define  ADC_REGS_INT2ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INT2ACK_RESERVED1_MASK) >> ADC_REGS_INT2ACK_RESERVED1_SHIFT)
#define  ADC_REGS_INT2ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INT2ACK_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INT2ACK_RESERVED1_SHIFT))

#define  ADC_REGS_INT2ACK_THRESHOLD_MASK 0xffff
#define  ADC_REGS_INT2ACK_THRESHOLD_SHIFT 0
#define  ADC_REGS_INT2ACK_THRESHOLD_MASK_SHIFT(reg) (((reg) & ADC_REGS_INT2ACK_THRESHOLD_MASK) >> ADC_REGS_INT2ACK_THRESHOLD_SHIFT)
#define  ADC_REGS_INT2ACK_THRESHOLD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INT2ACK_THRESHOLD_MASK) | (((uint32_t)val) << ADC_REGS_INT2ACK_THRESHOLD_SHIFT))

//====================================================================
//Register: Interrupt2 Force Register (Int2Force)
/** \brief 0 = do nothing, 1 = set corresponding interrupt bit, raw and active if enabled.<BR>*/
//====================================================================

#define  ADC_REGS_INT2FORCE_RESERVED1_MASK 0xffff0000
#define  ADC_REGS_INT2FORCE_RESERVED1_SHIFT 16
#define  ADC_REGS_INT2FORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INT2FORCE_RESERVED1_MASK) >> ADC_REGS_INT2FORCE_RESERVED1_SHIFT)
#define  ADC_REGS_INT2FORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INT2FORCE_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INT2FORCE_RESERVED1_SHIFT))

#define  ADC_REGS_INT2FORCE_THRESHOLD_MASK 0xffff
#define  ADC_REGS_INT2FORCE_THRESHOLD_SHIFT 0
#define  ADC_REGS_INT2FORCE_THRESHOLD_MASK_SHIFT(reg) (((reg) & ADC_REGS_INT2FORCE_THRESHOLD_MASK) >> ADC_REGS_INT2FORCE_THRESHOLD_SHIFT)
#define  ADC_REGS_INT2FORCE_THRESHOLD_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INT2FORCE_THRESHOLD_MASK) | (((uint32_t)val) << ADC_REGS_INT2FORCE_THRESHOLD_SHIFT))

//====================================================================
//Register: Firmware Request Register (FWRequest)
/** \brief Write to this register to initiate a Firmware Request.*/
//====================================================================

#define  ADC_REGS_FWREQUEST_RESERVED1_MASK 0xfffffffe
#define  ADC_REGS_FWREQUEST_RESERVED1_SHIFT 1
#define  ADC_REGS_FWREQUEST_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_FWREQUEST_RESERVED1_MASK) >> ADC_REGS_FWREQUEST_RESERVED1_SHIFT)
#define  ADC_REGS_FWREQUEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_FWREQUEST_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_FWREQUEST_RESERVED1_SHIFT))

#define  ADC_REGS_FWREQUEST_START_MASK 0x1
#define  ADC_REGS_FWREQUEST_START_SHIFT 0
#define  ADC_REGS_FWREQUEST_START_MASK_SHIFT(reg) (((reg) & ADC_REGS_FWREQUEST_START_MASK) >> ADC_REGS_FWREQUEST_START_SHIFT)
#define  ADC_REGS_FWREQUEST_START_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_FWREQUEST_START_MASK) | (((uint32_t)val) << ADC_REGS_FWREQUEST_START_SHIFT))

//====================================================================
//Register: Bypass Control Register (BypControl)
/** \brief This register directly controls the input ports of the SARADC hadmacro when in BYPASS mode.*/
//====================================================================

#define  ADC_REGS_BYPCONTROL_RESERVED1_MASK 0xfffff800
#define  ADC_REGS_BYPCONTROL_RESERVED1_SHIFT 11
#define  ADC_REGS_BYPCONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_BYPCONTROL_RESERVED1_MASK) >> ADC_REGS_BYPCONTROL_RESERVED1_SHIFT)
#define  ADC_REGS_BYPCONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_BYPCONTROL_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_BYPCONTROL_RESERVED1_SHIFT))

#define  ADC_REGS_BYPCONTROL_EXTMUX_MASK 0x700
#define  ADC_REGS_BYPCONTROL_EXTMUX_SHIFT 8
#define  ADC_REGS_BYPCONTROL_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_BYPCONTROL_EXTMUX_MASK) >> ADC_REGS_BYPCONTROL_EXTMUX_SHIFT)
#define  ADC_REGS_BYPCONTROL_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_BYPCONTROL_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_BYPCONTROL_EXTMUX_SHIFT))

#define  ADC_REGS_BYPCONTROL_CHAN_MASK 0xf0
#define  ADC_REGS_BYPCONTROL_CHAN_SHIFT 4
#define  ADC_REGS_BYPCONTROL_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_BYPCONTROL_CHAN_MASK) >> ADC_REGS_BYPCONTROL_CHAN_SHIFT)
#define  ADC_REGS_BYPCONTROL_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_BYPCONTROL_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_BYPCONTROL_CHAN_SHIFT))

#define  ADC_REGS_BYPCONTROL_RESERVED2_MASK 0x8
#define  ADC_REGS_BYPCONTROL_RESERVED2_SHIFT 3
#define  ADC_REGS_BYPCONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_BYPCONTROL_RESERVED2_MASK) >> ADC_REGS_BYPCONTROL_RESERVED2_SHIFT)
#define  ADC_REGS_BYPCONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_BYPCONTROL_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_BYPCONTROL_RESERVED2_SHIFT))

#define  ADC_REGS_BYPCONTROL_BUF_EN_MASK 0x4
#define  ADC_REGS_BYPCONTROL_BUF_EN_SHIFT 2
#define  ADC_REGS_BYPCONTROL_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_BYPCONTROL_BUF_EN_MASK) >> ADC_REGS_BYPCONTROL_BUF_EN_SHIFT)
#define  ADC_REGS_BYPCONTROL_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_BYPCONTROL_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_BYPCONTROL_BUF_EN_SHIFT))

#define  ADC_REGS_BYPCONTROL_CONT_MASK 0x2
#define  ADC_REGS_BYPCONTROL_CONT_SHIFT 1
#define  ADC_REGS_BYPCONTROL_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_BYPCONTROL_CONT_MASK) >> ADC_REGS_BYPCONTROL_CONT_SHIFT)
#define  ADC_REGS_BYPCONTROL_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_BYPCONTROL_CONT_MASK) | (((uint32_t)val) << ADC_REGS_BYPCONTROL_CONT_SHIFT))

#define  ADC_REGS_BYPCONTROL_START_MASK 0x1
#define  ADC_REGS_BYPCONTROL_START_SHIFT 0
#define  ADC_REGS_BYPCONTROL_START_MASK_SHIFT(reg) (((reg) & ADC_REGS_BYPCONTROL_START_MASK) >> ADC_REGS_BYPCONTROL_START_SHIFT)
#define  ADC_REGS_BYPCONTROL_START_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_BYPCONTROL_START_MASK) | (((uint32_t)val) << ADC_REGS_BYPCONTROL_START_SHIFT))

//====================================================================
//Register: Bypass Status Register (BypStatus)
/** \brief This register provides the digitized data from the SARADC hadmacro when in BYPASS mode (direct control).*/
//====================================================================

#define  ADC_REGS_BYPSTATUS_DONE_MASK 0x80000000
#define  ADC_REGS_BYPSTATUS_DONE_SHIFT 31
#define  ADC_REGS_BYPSTATUS_DONE_MASK_SHIFT(reg) (((reg) & ADC_REGS_BYPSTATUS_DONE_MASK) >> ADC_REGS_BYPSTATUS_DONE_SHIFT)
#define  ADC_REGS_BYPSTATUS_DONE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_BYPSTATUS_DONE_MASK) | (((uint32_t)val) << ADC_REGS_BYPSTATUS_DONE_SHIFT))

#define  ADC_REGS_BYPSTATUS_RESERVED1_MASK 0x7ffffc00
#define  ADC_REGS_BYPSTATUS_RESERVED1_SHIFT 10
#define  ADC_REGS_BYPSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_BYPSTATUS_RESERVED1_MASK) >> ADC_REGS_BYPSTATUS_RESERVED1_SHIFT)
#define  ADC_REGS_BYPSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_BYPSTATUS_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_BYPSTATUS_RESERVED1_SHIFT))

#define  ADC_REGS_BYPSTATUS_DOUT_MASK 0x3ff
#define  ADC_REGS_BYPSTATUS_DOUT_SHIFT 0
#define  ADC_REGS_BYPSTATUS_DOUT_MASK_SHIFT(reg) (((reg) & ADC_REGS_BYPSTATUS_DOUT_MASK) >> ADC_REGS_BYPSTATUS_DOUT_SHIFT)
#define  ADC_REGS_BYPSTATUS_DOUT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_BYPSTATUS_DOUT_MASK) | (((uint32_t)val) << ADC_REGS_BYPSTATUS_DOUT_SHIFT))

//====================================================================
//Register: RXFIFO1 Register (RXFIFO1)
/** \brief The 8-entry FIFO is filled with the most recently outputted samples from the ADC channel
       that is selected. <BR>
       Note that the FIFO can generate an interrupt when it is AlmostFull or Overflow.
       The Empty status, in addition to AlmostFull and Overflow status, can be viewed in
       the Interrupt Raw Register (IntRaw).*/
//====================================================================

#define  ADC_REGS_RXFIFO1_TAG_MASK 0xffffc000
#define  ADC_REGS_RXFIFO1_TAG_SHIFT 14
#define  ADC_REGS_RXFIFO1_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXFIFO1_TAG_MASK) >> ADC_REGS_RXFIFO1_TAG_SHIFT)
#define  ADC_REGS_RXFIFO1_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXFIFO1_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXFIFO1_TAG_SHIFT))

#define  ADC_REGS_RXFIFO1_RESERVED1_MASK 0x3c00
#define  ADC_REGS_RXFIFO1_RESERVED1_SHIFT 10
#define  ADC_REGS_RXFIFO1_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXFIFO1_RESERVED1_MASK) >> ADC_REGS_RXFIFO1_RESERVED1_SHIFT)
#define  ADC_REGS_RXFIFO1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXFIFO1_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_RXFIFO1_RESERVED1_SHIFT))

#define  ADC_REGS_RXFIFO1_DATA_MASK 0x3ff
#define  ADC_REGS_RXFIFO1_DATA_SHIFT 0
#define  ADC_REGS_RXFIFO1_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXFIFO1_DATA_MASK) >> ADC_REGS_RXFIFO1_DATA_SHIFT)
#define  ADC_REGS_RXFIFO1_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXFIFO1_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXFIFO1_DATA_SHIFT))

//====================================================================
//Register: RXFIFO2 Register (RXFIFO2)
/** \brief The 8-entry FIFO is filled with the most recently outputted samples from the ADC channel
       that is selected. <BR>
       Note that the FIFO can generate an interrupt when it is AlmostFull or Overflow.
       The Empty status, in addition to AlmostFull and Overflow status, can be viewed in
       the Interrupt Raw Register (IntRaw).*/
//====================================================================

#define  ADC_REGS_RXFIFO2_TAG_MASK 0xffffc000
#define  ADC_REGS_RXFIFO2_TAG_SHIFT 14
#define  ADC_REGS_RXFIFO2_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXFIFO2_TAG_MASK) >> ADC_REGS_RXFIFO2_TAG_SHIFT)
#define  ADC_REGS_RXFIFO2_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXFIFO2_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXFIFO2_TAG_SHIFT))

#define  ADC_REGS_RXFIFO2_RESERVED1_MASK 0x3c00
#define  ADC_REGS_RXFIFO2_RESERVED1_SHIFT 10
#define  ADC_REGS_RXFIFO2_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXFIFO2_RESERVED1_MASK) >> ADC_REGS_RXFIFO2_RESERVED1_SHIFT)
#define  ADC_REGS_RXFIFO2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXFIFO2_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_RXFIFO2_RESERVED1_SHIFT))

#define  ADC_REGS_RXFIFO2_DATA_MASK 0x3ff
#define  ADC_REGS_RXFIFO2_DATA_SHIFT 0
#define  ADC_REGS_RXFIFO2_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXFIFO2_DATA_MASK) >> ADC_REGS_RXFIFO2_DATA_SHIFT)
#define  ADC_REGS_RXFIFO2_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXFIFO2_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXFIFO2_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 1 of 16) (RXData0)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 1 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA0_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA0_TAG_SHIFT 14
#define  ADC_REGS_RXDATA0_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA0_TAG_MASK) >> ADC_REGS_RXDATA0_TAG_SHIFT)
#define  ADC_REGS_RXDATA0_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA0_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA0_TAG_SHIFT))

#define  ADC_REGS_RXDATA0_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA0_DATA_SHIFT 0
#define  ADC_REGS_RXDATA0_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA0_DATA_MASK) >> ADC_REGS_RXDATA0_DATA_SHIFT)
#define  ADC_REGS_RXDATA0_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA0_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA0_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 2 of 16) (RXData1)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 2 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA1_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA1_TAG_SHIFT 14
#define  ADC_REGS_RXDATA1_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA1_TAG_MASK) >> ADC_REGS_RXDATA1_TAG_SHIFT)
#define  ADC_REGS_RXDATA1_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA1_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA1_TAG_SHIFT))

#define  ADC_REGS_RXDATA1_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA1_DATA_SHIFT 0
#define  ADC_REGS_RXDATA1_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA1_DATA_MASK) >> ADC_REGS_RXDATA1_DATA_SHIFT)
#define  ADC_REGS_RXDATA1_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA1_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA1_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 3 of 16) (RXData2)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 3 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA2_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA2_TAG_SHIFT 14
#define  ADC_REGS_RXDATA2_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA2_TAG_MASK) >> ADC_REGS_RXDATA2_TAG_SHIFT)
#define  ADC_REGS_RXDATA2_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA2_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA2_TAG_SHIFT))

#define  ADC_REGS_RXDATA2_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA2_DATA_SHIFT 0
#define  ADC_REGS_RXDATA2_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA2_DATA_MASK) >> ADC_REGS_RXDATA2_DATA_SHIFT)
#define  ADC_REGS_RXDATA2_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA2_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA2_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 4 of 16) (RXData3)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 4 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA3_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA3_TAG_SHIFT 14
#define  ADC_REGS_RXDATA3_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA3_TAG_MASK) >> ADC_REGS_RXDATA3_TAG_SHIFT)
#define  ADC_REGS_RXDATA3_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA3_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA3_TAG_SHIFT))

#define  ADC_REGS_RXDATA3_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA3_DATA_SHIFT 0
#define  ADC_REGS_RXDATA3_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA3_DATA_MASK) >> ADC_REGS_RXDATA3_DATA_SHIFT)
#define  ADC_REGS_RXDATA3_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA3_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA3_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 5 of 16) (RXData4)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 5 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA4_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA4_TAG_SHIFT 14
#define  ADC_REGS_RXDATA4_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA4_TAG_MASK) >> ADC_REGS_RXDATA4_TAG_SHIFT)
#define  ADC_REGS_RXDATA4_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA4_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA4_TAG_SHIFT))

#define  ADC_REGS_RXDATA4_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA4_DATA_SHIFT 0
#define  ADC_REGS_RXDATA4_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA4_DATA_MASK) >> ADC_REGS_RXDATA4_DATA_SHIFT)
#define  ADC_REGS_RXDATA4_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA4_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA4_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 6 of 16) (RXData5)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 6 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA5_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA5_TAG_SHIFT 14
#define  ADC_REGS_RXDATA5_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA5_TAG_MASK) >> ADC_REGS_RXDATA5_TAG_SHIFT)
#define  ADC_REGS_RXDATA5_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA5_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA5_TAG_SHIFT))

#define  ADC_REGS_RXDATA5_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA5_DATA_SHIFT 0
#define  ADC_REGS_RXDATA5_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA5_DATA_MASK) >> ADC_REGS_RXDATA5_DATA_SHIFT)
#define  ADC_REGS_RXDATA5_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA5_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA5_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 7 of 16) (RXData6)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 7 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA6_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA6_TAG_SHIFT 14
#define  ADC_REGS_RXDATA6_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA6_TAG_MASK) >> ADC_REGS_RXDATA6_TAG_SHIFT)
#define  ADC_REGS_RXDATA6_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA6_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA6_TAG_SHIFT))

#define  ADC_REGS_RXDATA6_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA6_DATA_SHIFT 0
#define  ADC_REGS_RXDATA6_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA6_DATA_MASK) >> ADC_REGS_RXDATA6_DATA_SHIFT)
#define  ADC_REGS_RXDATA6_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA6_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA6_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 8 of 16) (RXData7)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 8 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA7_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA7_TAG_SHIFT 14
#define  ADC_REGS_RXDATA7_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA7_TAG_MASK) >> ADC_REGS_RXDATA7_TAG_SHIFT)
#define  ADC_REGS_RXDATA7_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA7_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA7_TAG_SHIFT))

#define  ADC_REGS_RXDATA7_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA7_DATA_SHIFT 0
#define  ADC_REGS_RXDATA7_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA7_DATA_MASK) >> ADC_REGS_RXDATA7_DATA_SHIFT)
#define  ADC_REGS_RXDATA7_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA7_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA7_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 9 of 16) (RXData8)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 9 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA8_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA8_TAG_SHIFT 14
#define  ADC_REGS_RXDATA8_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA8_TAG_MASK) >> ADC_REGS_RXDATA8_TAG_SHIFT)
#define  ADC_REGS_RXDATA8_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA8_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA8_TAG_SHIFT))

#define  ADC_REGS_RXDATA8_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA8_DATA_SHIFT 0
#define  ADC_REGS_RXDATA8_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA8_DATA_MASK) >> ADC_REGS_RXDATA8_DATA_SHIFT)
#define  ADC_REGS_RXDATA8_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA8_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA8_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 10 of 16) (RXData9)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 10 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA9_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA9_TAG_SHIFT 14
#define  ADC_REGS_RXDATA9_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA9_TAG_MASK) >> ADC_REGS_RXDATA9_TAG_SHIFT)
#define  ADC_REGS_RXDATA9_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA9_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA9_TAG_SHIFT))

#define  ADC_REGS_RXDATA9_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA9_DATA_SHIFT 0
#define  ADC_REGS_RXDATA9_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA9_DATA_MASK) >> ADC_REGS_RXDATA9_DATA_SHIFT)
#define  ADC_REGS_RXDATA9_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA9_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA9_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 11 of 16) (RXData10)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 11 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA10_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA10_TAG_SHIFT 14
#define  ADC_REGS_RXDATA10_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA10_TAG_MASK) >> ADC_REGS_RXDATA10_TAG_SHIFT)
#define  ADC_REGS_RXDATA10_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA10_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA10_TAG_SHIFT))

#define  ADC_REGS_RXDATA10_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA10_DATA_SHIFT 0
#define  ADC_REGS_RXDATA10_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA10_DATA_MASK) >> ADC_REGS_RXDATA10_DATA_SHIFT)
#define  ADC_REGS_RXDATA10_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA10_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA10_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 12 of 16) (RXData11)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 12 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA11_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA11_TAG_SHIFT 14
#define  ADC_REGS_RXDATA11_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA11_TAG_MASK) >> ADC_REGS_RXDATA11_TAG_SHIFT)
#define  ADC_REGS_RXDATA11_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA11_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA11_TAG_SHIFT))

#define  ADC_REGS_RXDATA11_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA11_DATA_SHIFT 0
#define  ADC_REGS_RXDATA11_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA11_DATA_MASK) >> ADC_REGS_RXDATA11_DATA_SHIFT)
#define  ADC_REGS_RXDATA11_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA11_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA11_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 13 of 16) (RXData12)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 13 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA12_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA12_TAG_SHIFT 14
#define  ADC_REGS_RXDATA12_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA12_TAG_MASK) >> ADC_REGS_RXDATA12_TAG_SHIFT)
#define  ADC_REGS_RXDATA12_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA12_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA12_TAG_SHIFT))

#define  ADC_REGS_RXDATA12_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA12_DATA_SHIFT 0
#define  ADC_REGS_RXDATA12_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA12_DATA_MASK) >> ADC_REGS_RXDATA12_DATA_SHIFT)
#define  ADC_REGS_RXDATA12_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA12_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA12_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 14 of 16) (RXData13)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 14 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA13_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA13_TAG_SHIFT 14
#define  ADC_REGS_RXDATA13_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA13_TAG_MASK) >> ADC_REGS_RXDATA13_TAG_SHIFT)
#define  ADC_REGS_RXDATA13_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA13_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA13_TAG_SHIFT))

#define  ADC_REGS_RXDATA13_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA13_DATA_SHIFT 0
#define  ADC_REGS_RXDATA13_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA13_DATA_MASK) >> ADC_REGS_RXDATA13_DATA_SHIFT)
#define  ADC_REGS_RXDATA13_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA13_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA13_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 15 of 16) (RXData14)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 15 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA14_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA14_TAG_SHIFT 14
#define  ADC_REGS_RXDATA14_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA14_TAG_MASK) >> ADC_REGS_RXDATA14_TAG_SHIFT)
#define  ADC_REGS_RXDATA14_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA14_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA14_TAG_SHIFT))

#define  ADC_REGS_RXDATA14_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA14_DATA_SHIFT 0
#define  ADC_REGS_RXDATA14_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA14_DATA_MASK) >> ADC_REGS_RXDATA14_DATA_SHIFT)
#define  ADC_REGS_RXDATA14_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA14_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA14_DATA_SHIFT))

//====================================================================
//Register: RXData Result Register (Instance 16 of 16) (RXData15)
/** \brief This register contains the post-processed data result corresponding to Instruction Configuration Table Entry[i]. (Instance 16 of 16)*/
//====================================================================

#define  ADC_REGS_RXDATA15_TAG_MASK 0xffffc000
#define  ADC_REGS_RXDATA15_TAG_SHIFT 14
#define  ADC_REGS_RXDATA15_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA15_TAG_MASK) >> ADC_REGS_RXDATA15_TAG_SHIFT)
#define  ADC_REGS_RXDATA15_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA15_TAG_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA15_TAG_SHIFT))

#define  ADC_REGS_RXDATA15_DATA_MASK 0x3fff
#define  ADC_REGS_RXDATA15_DATA_SHIFT 0
#define  ADC_REGS_RXDATA15_DATA_MASK_SHIFT(reg) (((reg) & ADC_REGS_RXDATA15_DATA_MASK) >> ADC_REGS_RXDATA15_DATA_SHIFT)
#define  ADC_REGS_RXDATA15_DATA_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_RXDATA15_DATA_MASK) | (((uint32_t)val) << ADC_REGS_RXDATA15_DATA_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 1 of 16) (Instruction0)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 1 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION0_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION0_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION0_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION0_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION0_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION0_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION0_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION0_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION0_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION0_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION0_TAG_MASK) >> ADC_REGS_INSTRUCTION0_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION0_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION0_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION0_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION0_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION0_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION0_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION0_MAX_MASK) >> ADC_REGS_INSTRUCTION0_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION0_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION0_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION0_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION0_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION0_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION0_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION0_MIN_MASK) >> ADC_REGS_INSTRUCTION0_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION0_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION0_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION0_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION0_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION0_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION0_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION0_ACCUM_MASK) >> ADC_REGS_INSTRUCTION0_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION0_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION0_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION0_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION0_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION0_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION0_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION0_FIFO_MASK) >> ADC_REGS_INSTRUCTION0_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION0_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION0_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION0_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION0_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION0_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION0_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION0_CONT_MASK) >> ADC_REGS_INSTRUCTION0_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION0_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION0_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION0_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION0_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION0_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION0_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION0_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION0_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION0_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION0_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION0_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION0_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION0_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION0_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION0_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION0_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION0_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION0_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION0_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION0_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION0_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION0_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION0_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION0_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION0_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION0_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION0_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION0_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION0_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION0_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION0_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION0_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION0_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION0_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION0_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION0_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION0_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION0_CHAN_MASK) >> ADC_REGS_INSTRUCTION0_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION0_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION0_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION0_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 2 of 16) (Instruction1)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 2 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION1_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION1_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION1_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION1_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION1_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION1_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION1_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION1_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION1_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION1_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION1_TAG_MASK) >> ADC_REGS_INSTRUCTION1_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION1_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION1_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION1_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION1_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION1_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION1_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION1_MAX_MASK) >> ADC_REGS_INSTRUCTION1_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION1_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION1_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION1_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION1_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION1_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION1_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION1_MIN_MASK) >> ADC_REGS_INSTRUCTION1_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION1_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION1_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION1_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION1_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION1_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION1_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION1_ACCUM_MASK) >> ADC_REGS_INSTRUCTION1_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION1_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION1_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION1_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION1_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION1_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION1_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION1_FIFO_MASK) >> ADC_REGS_INSTRUCTION1_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION1_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION1_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION1_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION1_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION1_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION1_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION1_CONT_MASK) >> ADC_REGS_INSTRUCTION1_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION1_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION1_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION1_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION1_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION1_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION1_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION1_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION1_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION1_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION1_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION1_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION1_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION1_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION1_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION1_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION1_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION1_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION1_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION1_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION1_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION1_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION1_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION1_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION1_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION1_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION1_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION1_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION1_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION1_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION1_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION1_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION1_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION1_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION1_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION1_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION1_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION1_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION1_CHAN_MASK) >> ADC_REGS_INSTRUCTION1_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION1_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION1_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION1_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 3 of 16) (Instruction2)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 3 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION2_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION2_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION2_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION2_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION2_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION2_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION2_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION2_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION2_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION2_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION2_TAG_MASK) >> ADC_REGS_INSTRUCTION2_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION2_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION2_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION2_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION2_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION2_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION2_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION2_MAX_MASK) >> ADC_REGS_INSTRUCTION2_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION2_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION2_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION2_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION2_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION2_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION2_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION2_MIN_MASK) >> ADC_REGS_INSTRUCTION2_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION2_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION2_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION2_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION2_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION2_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION2_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION2_ACCUM_MASK) >> ADC_REGS_INSTRUCTION2_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION2_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION2_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION2_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION2_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION2_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION2_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION2_FIFO_MASK) >> ADC_REGS_INSTRUCTION2_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION2_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION2_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION2_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION2_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION2_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION2_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION2_CONT_MASK) >> ADC_REGS_INSTRUCTION2_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION2_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION2_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION2_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION2_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION2_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION2_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION2_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION2_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION2_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION2_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION2_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION2_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION2_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION2_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION2_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION2_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION2_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION2_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION2_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION2_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION2_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION2_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION2_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION2_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION2_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION2_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION2_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION2_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION2_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION2_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION2_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION2_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION2_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION2_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION2_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION2_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION2_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION2_CHAN_MASK) >> ADC_REGS_INSTRUCTION2_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION2_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION2_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION2_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 4 of 16) (Instruction3)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 4 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION3_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION3_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION3_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION3_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION3_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION3_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION3_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION3_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION3_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION3_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION3_TAG_MASK) >> ADC_REGS_INSTRUCTION3_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION3_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION3_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION3_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION3_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION3_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION3_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION3_MAX_MASK) >> ADC_REGS_INSTRUCTION3_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION3_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION3_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION3_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION3_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION3_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION3_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION3_MIN_MASK) >> ADC_REGS_INSTRUCTION3_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION3_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION3_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION3_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION3_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION3_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION3_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION3_ACCUM_MASK) >> ADC_REGS_INSTRUCTION3_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION3_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION3_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION3_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION3_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION3_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION3_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION3_FIFO_MASK) >> ADC_REGS_INSTRUCTION3_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION3_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION3_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION3_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION3_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION3_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION3_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION3_CONT_MASK) >> ADC_REGS_INSTRUCTION3_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION3_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION3_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION3_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION3_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION3_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION3_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION3_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION3_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION3_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION3_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION3_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION3_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION3_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION3_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION3_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION3_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION3_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION3_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION3_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION3_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION3_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION3_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION3_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION3_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION3_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION3_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION3_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION3_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION3_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION3_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION3_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION3_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION3_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION3_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION3_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION3_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION3_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION3_CHAN_MASK) >> ADC_REGS_INSTRUCTION3_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION3_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION3_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION3_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 5 of 16) (Instruction4)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 5 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION4_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION4_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION4_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION4_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION4_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION4_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION4_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION4_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION4_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION4_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION4_TAG_MASK) >> ADC_REGS_INSTRUCTION4_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION4_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION4_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION4_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION4_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION4_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION4_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION4_MAX_MASK) >> ADC_REGS_INSTRUCTION4_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION4_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION4_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION4_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION4_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION4_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION4_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION4_MIN_MASK) >> ADC_REGS_INSTRUCTION4_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION4_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION4_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION4_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION4_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION4_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION4_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION4_ACCUM_MASK) >> ADC_REGS_INSTRUCTION4_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION4_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION4_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION4_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION4_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION4_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION4_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION4_FIFO_MASK) >> ADC_REGS_INSTRUCTION4_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION4_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION4_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION4_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION4_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION4_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION4_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION4_CONT_MASK) >> ADC_REGS_INSTRUCTION4_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION4_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION4_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION4_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION4_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION4_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION4_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION4_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION4_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION4_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION4_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION4_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION4_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION4_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION4_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION4_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION4_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION4_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION4_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION4_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION4_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION4_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION4_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION4_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION4_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION4_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION4_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION4_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION4_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION4_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION4_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION4_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION4_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION4_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION4_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION4_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION4_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION4_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION4_CHAN_MASK) >> ADC_REGS_INSTRUCTION4_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION4_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION4_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION4_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 6 of 16) (Instruction5)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 6 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION5_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION5_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION5_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION5_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION5_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION5_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION5_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION5_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION5_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION5_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION5_TAG_MASK) >> ADC_REGS_INSTRUCTION5_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION5_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION5_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION5_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION5_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION5_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION5_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION5_MAX_MASK) >> ADC_REGS_INSTRUCTION5_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION5_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION5_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION5_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION5_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION5_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION5_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION5_MIN_MASK) >> ADC_REGS_INSTRUCTION5_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION5_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION5_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION5_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION5_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION5_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION5_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION5_ACCUM_MASK) >> ADC_REGS_INSTRUCTION5_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION5_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION5_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION5_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION5_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION5_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION5_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION5_FIFO_MASK) >> ADC_REGS_INSTRUCTION5_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION5_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION5_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION5_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION5_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION5_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION5_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION5_CONT_MASK) >> ADC_REGS_INSTRUCTION5_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION5_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION5_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION5_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION5_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION5_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION5_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION5_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION5_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION5_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION5_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION5_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION5_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION5_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION5_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION5_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION5_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION5_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION5_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION5_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION5_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION5_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION5_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION5_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION5_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION5_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION5_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION5_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION5_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION5_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION5_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION5_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION5_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION5_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION5_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION5_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION5_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION5_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION5_CHAN_MASK) >> ADC_REGS_INSTRUCTION5_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION5_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION5_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION5_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 7 of 16) (Instruction6)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 7 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION6_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION6_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION6_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION6_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION6_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION6_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION6_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION6_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION6_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION6_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION6_TAG_MASK) >> ADC_REGS_INSTRUCTION6_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION6_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION6_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION6_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION6_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION6_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION6_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION6_MAX_MASK) >> ADC_REGS_INSTRUCTION6_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION6_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION6_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION6_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION6_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION6_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION6_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION6_MIN_MASK) >> ADC_REGS_INSTRUCTION6_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION6_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION6_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION6_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION6_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION6_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION6_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION6_ACCUM_MASK) >> ADC_REGS_INSTRUCTION6_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION6_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION6_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION6_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION6_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION6_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION6_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION6_FIFO_MASK) >> ADC_REGS_INSTRUCTION6_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION6_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION6_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION6_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION6_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION6_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION6_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION6_CONT_MASK) >> ADC_REGS_INSTRUCTION6_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION6_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION6_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION6_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION6_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION6_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION6_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION6_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION6_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION6_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION6_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION6_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION6_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION6_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION6_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION6_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION6_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION6_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION6_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION6_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION6_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION6_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION6_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION6_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION6_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION6_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION6_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION6_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION6_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION6_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION6_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION6_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION6_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION6_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION6_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION6_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION6_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION6_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION6_CHAN_MASK) >> ADC_REGS_INSTRUCTION6_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION6_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION6_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION6_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 8 of 16) (Instruction7)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 8 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION7_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION7_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION7_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION7_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION7_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION7_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION7_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION7_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION7_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION7_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION7_TAG_MASK) >> ADC_REGS_INSTRUCTION7_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION7_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION7_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION7_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION7_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION7_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION7_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION7_MAX_MASK) >> ADC_REGS_INSTRUCTION7_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION7_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION7_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION7_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION7_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION7_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION7_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION7_MIN_MASK) >> ADC_REGS_INSTRUCTION7_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION7_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION7_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION7_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION7_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION7_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION7_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION7_ACCUM_MASK) >> ADC_REGS_INSTRUCTION7_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION7_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION7_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION7_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION7_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION7_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION7_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION7_FIFO_MASK) >> ADC_REGS_INSTRUCTION7_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION7_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION7_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION7_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION7_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION7_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION7_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION7_CONT_MASK) >> ADC_REGS_INSTRUCTION7_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION7_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION7_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION7_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION7_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION7_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION7_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION7_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION7_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION7_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION7_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION7_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION7_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION7_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION7_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION7_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION7_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION7_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION7_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION7_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION7_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION7_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION7_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION7_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION7_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION7_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION7_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION7_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION7_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION7_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION7_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION7_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION7_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION7_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION7_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION7_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION7_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION7_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION7_CHAN_MASK) >> ADC_REGS_INSTRUCTION7_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION7_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION7_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION7_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 9 of 16) (Instruction8)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 9 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION8_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION8_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION8_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION8_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION8_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION8_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION8_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION8_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION8_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION8_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION8_TAG_MASK) >> ADC_REGS_INSTRUCTION8_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION8_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION8_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION8_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION8_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION8_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION8_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION8_MAX_MASK) >> ADC_REGS_INSTRUCTION8_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION8_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION8_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION8_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION8_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION8_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION8_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION8_MIN_MASK) >> ADC_REGS_INSTRUCTION8_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION8_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION8_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION8_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION8_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION8_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION8_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION8_ACCUM_MASK) >> ADC_REGS_INSTRUCTION8_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION8_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION8_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION8_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION8_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION8_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION8_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION8_FIFO_MASK) >> ADC_REGS_INSTRUCTION8_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION8_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION8_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION8_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION8_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION8_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION8_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION8_CONT_MASK) >> ADC_REGS_INSTRUCTION8_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION8_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION8_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION8_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION8_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION8_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION8_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION8_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION8_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION8_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION8_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION8_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION8_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION8_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION8_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION8_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION8_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION8_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION8_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION8_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION8_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION8_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION8_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION8_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION8_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION8_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION8_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION8_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION8_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION8_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION8_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION8_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION8_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION8_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION8_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION8_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION8_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION8_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION8_CHAN_MASK) >> ADC_REGS_INSTRUCTION8_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION8_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION8_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION8_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 10 of 16) (Instruction9)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 10 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION9_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION9_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION9_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION9_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION9_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION9_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION9_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION9_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION9_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION9_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION9_TAG_MASK) >> ADC_REGS_INSTRUCTION9_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION9_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION9_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION9_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION9_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION9_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION9_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION9_MAX_MASK) >> ADC_REGS_INSTRUCTION9_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION9_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION9_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION9_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION9_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION9_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION9_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION9_MIN_MASK) >> ADC_REGS_INSTRUCTION9_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION9_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION9_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION9_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION9_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION9_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION9_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION9_ACCUM_MASK) >> ADC_REGS_INSTRUCTION9_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION9_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION9_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION9_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION9_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION9_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION9_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION9_FIFO_MASK) >> ADC_REGS_INSTRUCTION9_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION9_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION9_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION9_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION9_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION9_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION9_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION9_CONT_MASK) >> ADC_REGS_INSTRUCTION9_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION9_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION9_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION9_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION9_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION9_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION9_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION9_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION9_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION9_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION9_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION9_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION9_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION9_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION9_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION9_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION9_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION9_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION9_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION9_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION9_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION9_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION9_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION9_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION9_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION9_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION9_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION9_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION9_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION9_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION9_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION9_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION9_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION9_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION9_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION9_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION9_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION9_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION9_CHAN_MASK) >> ADC_REGS_INSTRUCTION9_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION9_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION9_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION9_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 11 of 16) (Instruction10)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 11 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION10_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION10_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION10_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION10_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION10_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION10_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION10_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION10_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION10_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION10_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION10_TAG_MASK) >> ADC_REGS_INSTRUCTION10_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION10_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION10_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION10_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION10_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION10_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION10_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION10_MAX_MASK) >> ADC_REGS_INSTRUCTION10_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION10_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION10_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION10_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION10_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION10_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION10_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION10_MIN_MASK) >> ADC_REGS_INSTRUCTION10_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION10_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION10_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION10_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION10_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION10_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION10_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION10_ACCUM_MASK) >> ADC_REGS_INSTRUCTION10_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION10_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION10_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION10_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION10_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION10_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION10_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION10_FIFO_MASK) >> ADC_REGS_INSTRUCTION10_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION10_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION10_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION10_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION10_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION10_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION10_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION10_CONT_MASK) >> ADC_REGS_INSTRUCTION10_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION10_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION10_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION10_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION10_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION10_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION10_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION10_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION10_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION10_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION10_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION10_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION10_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION10_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION10_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION10_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION10_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION10_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION10_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION10_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION10_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION10_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION10_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION10_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION10_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION10_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION10_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION10_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION10_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION10_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION10_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION10_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION10_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION10_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION10_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION10_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION10_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION10_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION10_CHAN_MASK) >> ADC_REGS_INSTRUCTION10_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION10_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION10_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION10_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 12 of 16) (Instruction11)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 12 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION11_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION11_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION11_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION11_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION11_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION11_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION11_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION11_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION11_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION11_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION11_TAG_MASK) >> ADC_REGS_INSTRUCTION11_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION11_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION11_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION11_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION11_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION11_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION11_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION11_MAX_MASK) >> ADC_REGS_INSTRUCTION11_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION11_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION11_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION11_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION11_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION11_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION11_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION11_MIN_MASK) >> ADC_REGS_INSTRUCTION11_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION11_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION11_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION11_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION11_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION11_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION11_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION11_ACCUM_MASK) >> ADC_REGS_INSTRUCTION11_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION11_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION11_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION11_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION11_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION11_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION11_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION11_FIFO_MASK) >> ADC_REGS_INSTRUCTION11_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION11_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION11_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION11_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION11_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION11_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION11_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION11_CONT_MASK) >> ADC_REGS_INSTRUCTION11_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION11_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION11_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION11_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION11_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION11_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION11_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION11_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION11_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION11_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION11_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION11_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION11_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION11_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION11_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION11_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION11_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION11_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION11_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION11_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION11_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION11_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION11_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION11_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION11_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION11_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION11_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION11_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION11_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION11_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION11_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION11_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION11_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION11_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION11_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION11_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION11_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION11_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION11_CHAN_MASK) >> ADC_REGS_INSTRUCTION11_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION11_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION11_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION11_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 13 of 16) (Instruction12)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 13 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION12_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION12_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION12_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION12_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION12_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION12_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION12_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION12_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION12_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION12_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION12_TAG_MASK) >> ADC_REGS_INSTRUCTION12_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION12_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION12_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION12_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION12_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION12_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION12_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION12_MAX_MASK) >> ADC_REGS_INSTRUCTION12_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION12_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION12_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION12_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION12_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION12_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION12_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION12_MIN_MASK) >> ADC_REGS_INSTRUCTION12_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION12_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION12_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION12_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION12_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION12_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION12_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION12_ACCUM_MASK) >> ADC_REGS_INSTRUCTION12_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION12_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION12_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION12_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION12_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION12_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION12_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION12_FIFO_MASK) >> ADC_REGS_INSTRUCTION12_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION12_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION12_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION12_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION12_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION12_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION12_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION12_CONT_MASK) >> ADC_REGS_INSTRUCTION12_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION12_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION12_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION12_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION12_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION12_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION12_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION12_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION12_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION12_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION12_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION12_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION12_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION12_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION12_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION12_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION12_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION12_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION12_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION12_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION12_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION12_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION12_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION12_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION12_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION12_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION12_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION12_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION12_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION12_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION12_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION12_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION12_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION12_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION12_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION12_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION12_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION12_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION12_CHAN_MASK) >> ADC_REGS_INSTRUCTION12_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION12_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION12_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION12_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 14 of 16) (Instruction13)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 14 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION13_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION13_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION13_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION13_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION13_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION13_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION13_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION13_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION13_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION13_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION13_TAG_MASK) >> ADC_REGS_INSTRUCTION13_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION13_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION13_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION13_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION13_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION13_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION13_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION13_MAX_MASK) >> ADC_REGS_INSTRUCTION13_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION13_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION13_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION13_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION13_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION13_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION13_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION13_MIN_MASK) >> ADC_REGS_INSTRUCTION13_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION13_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION13_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION13_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION13_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION13_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION13_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION13_ACCUM_MASK) >> ADC_REGS_INSTRUCTION13_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION13_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION13_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION13_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION13_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION13_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION13_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION13_FIFO_MASK) >> ADC_REGS_INSTRUCTION13_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION13_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION13_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION13_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION13_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION13_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION13_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION13_CONT_MASK) >> ADC_REGS_INSTRUCTION13_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION13_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION13_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION13_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION13_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION13_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION13_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION13_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION13_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION13_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION13_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION13_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION13_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION13_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION13_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION13_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION13_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION13_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION13_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION13_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION13_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION13_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION13_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION13_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION13_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION13_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION13_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION13_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION13_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION13_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION13_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION13_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION13_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION13_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION13_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION13_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION13_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION13_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION13_CHAN_MASK) >> ADC_REGS_INSTRUCTION13_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION13_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION13_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION13_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 15 of 16) (Instruction14)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 15 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION14_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION14_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION14_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION14_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION14_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION14_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION14_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION14_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION14_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION14_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION14_TAG_MASK) >> ADC_REGS_INSTRUCTION14_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION14_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION14_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION14_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION14_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION14_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION14_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION14_MAX_MASK) >> ADC_REGS_INSTRUCTION14_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION14_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION14_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION14_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION14_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION14_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION14_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION14_MIN_MASK) >> ADC_REGS_INSTRUCTION14_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION14_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION14_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION14_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION14_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION14_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION14_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION14_ACCUM_MASK) >> ADC_REGS_INSTRUCTION14_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION14_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION14_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION14_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION14_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION14_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION14_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION14_FIFO_MASK) >> ADC_REGS_INSTRUCTION14_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION14_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION14_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION14_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION14_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION14_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION14_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION14_CONT_MASK) >> ADC_REGS_INSTRUCTION14_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION14_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION14_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION14_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION14_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION14_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION14_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION14_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION14_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION14_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION14_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION14_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION14_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION14_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION14_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION14_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION14_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION14_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION14_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION14_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION14_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION14_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION14_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION14_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION14_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION14_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION14_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION14_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION14_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION14_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION14_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION14_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION14_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION14_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION14_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION14_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION14_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION14_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION14_CHAN_MASK) >> ADC_REGS_INSTRUCTION14_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION14_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION14_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION14_CHAN_SHIFT))

//====================================================================
//Register: Instruction Configuration Table Register (Instance 16 of 16) (Instruction15)
/** \brief A table entry represents the instruction for a sampling pass on a single ADC channel.
     A sampling sequence (algorithm) can consist of consecutive instructions in the table,
     and the nLast bit of the instruction indicates the final pass of the algorithm. <BR>
     Each source event (Firmware request, each Harware trigger, Continuous mode) should have
     an algorithm programmed into this table. <BR>
     Although not required, it is recommended that when firmware desires to re-program
     the sampling algorithm for a particular source event, firmware should first disable the
     corresponding trigger in the Priority Control Table entry (see Priority.enable bit). (Instance 16 of 16)*/
//====================================================================

#define  ADC_REGS_INSTRUCTION15_RESERVED1_MASK 0xe0000000
#define  ADC_REGS_INSTRUCTION15_RESERVED1_SHIFT 29
#define  ADC_REGS_INSTRUCTION15_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION15_RESERVED1_MASK) >> ADC_REGS_INSTRUCTION15_RESERVED1_SHIFT)
#define  ADC_REGS_INSTRUCTION15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION15_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION15_RESERVED1_SHIFT))

#define  ADC_REGS_INSTRUCTION15_TAG_MASK 0x1c000000
#define  ADC_REGS_INSTRUCTION15_TAG_SHIFT 26
#define  ADC_REGS_INSTRUCTION15_TAG_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION15_TAG_MASK) >> ADC_REGS_INSTRUCTION15_TAG_SHIFT)
#define  ADC_REGS_INSTRUCTION15_TAG_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION15_TAG_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION15_TAG_SHIFT))

#define  ADC_REGS_INSTRUCTION15_MAX_MASK 0x3800000
#define  ADC_REGS_INSTRUCTION15_MAX_SHIFT 23
#define  ADC_REGS_INSTRUCTION15_MAX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION15_MAX_MASK) >> ADC_REGS_INSTRUCTION15_MAX_SHIFT)
#define  ADC_REGS_INSTRUCTION15_MAX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION15_MAX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION15_MAX_SHIFT))

#define  ADC_REGS_INSTRUCTION15_MIN_MASK 0x700000
#define  ADC_REGS_INSTRUCTION15_MIN_SHIFT 20
#define  ADC_REGS_INSTRUCTION15_MIN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION15_MIN_MASK) >> ADC_REGS_INSTRUCTION15_MIN_SHIFT)
#define  ADC_REGS_INSTRUCTION15_MIN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION15_MIN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION15_MIN_SHIFT))

#define  ADC_REGS_INSTRUCTION15_ACCUM_MASK 0x80000
#define  ADC_REGS_INSTRUCTION15_ACCUM_SHIFT 19
#define  ADC_REGS_INSTRUCTION15_ACCUM_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION15_ACCUM_MASK) >> ADC_REGS_INSTRUCTION15_ACCUM_SHIFT)
#define  ADC_REGS_INSTRUCTION15_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION15_ACCUM_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION15_ACCUM_SHIFT))

#define  ADC_REGS_INSTRUCTION15_FIFO_MASK 0x60000
#define  ADC_REGS_INSTRUCTION15_FIFO_SHIFT 17
#define  ADC_REGS_INSTRUCTION15_FIFO_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION15_FIFO_MASK) >> ADC_REGS_INSTRUCTION15_FIFO_SHIFT)
#define  ADC_REGS_INSTRUCTION15_FIFO_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION15_FIFO_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION15_FIFO_SHIFT))

#define  ADC_REGS_INSTRUCTION15_CONT_MASK 0x10000
#define  ADC_REGS_INSTRUCTION15_CONT_SHIFT 16
#define  ADC_REGS_INSTRUCTION15_CONT_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION15_CONT_MASK) >> ADC_REGS_INSTRUCTION15_CONT_SHIFT)
#define  ADC_REGS_INSTRUCTION15_CONT_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION15_CONT_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION15_CONT_SHIFT))

#define  ADC_REGS_INSTRUCTION15_RESERVED2_MASK 0xf000
#define  ADC_REGS_INSTRUCTION15_RESERVED2_SHIFT 12
#define  ADC_REGS_INSTRUCTION15_RESERVED2_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION15_RESERVED2_MASK) >> ADC_REGS_INSTRUCTION15_RESERVED2_SHIFT)
#define  ADC_REGS_INSTRUCTION15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION15_RESERVED2_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION15_RESERVED2_SHIFT))

#define  ADC_REGS_INSTRUCTION15_N_SAMPLES_MASK 0xf00
#define  ADC_REGS_INSTRUCTION15_N_SAMPLES_SHIFT 8
#define  ADC_REGS_INSTRUCTION15_N_SAMPLES_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION15_N_SAMPLES_MASK) >> ADC_REGS_INSTRUCTION15_N_SAMPLES_SHIFT)
#define  ADC_REGS_INSTRUCTION15_N_SAMPLES_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION15_N_SAMPLES_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION15_N_SAMPLES_SHIFT))

#define  ADC_REGS_INSTRUCTION15_BUF_EN_MASK 0x80
#define  ADC_REGS_INSTRUCTION15_BUF_EN_SHIFT 7
#define  ADC_REGS_INSTRUCTION15_BUF_EN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION15_BUF_EN_MASK) >> ADC_REGS_INSTRUCTION15_BUF_EN_SHIFT)
#define  ADC_REGS_INSTRUCTION15_BUF_EN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION15_BUF_EN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION15_BUF_EN_SHIFT))

#define  ADC_REGS_INSTRUCTION15_EXTMUX_MASK 0x70
#define  ADC_REGS_INSTRUCTION15_EXTMUX_SHIFT 4
#define  ADC_REGS_INSTRUCTION15_EXTMUX_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION15_EXTMUX_MASK) >> ADC_REGS_INSTRUCTION15_EXTMUX_SHIFT)
#define  ADC_REGS_INSTRUCTION15_EXTMUX_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION15_EXTMUX_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION15_EXTMUX_SHIFT))

#define  ADC_REGS_INSTRUCTION15_CHAN_MASK 0xf
#define  ADC_REGS_INSTRUCTION15_CHAN_SHIFT 0
#define  ADC_REGS_INSTRUCTION15_CHAN_MASK_SHIFT(reg) (((reg) & ADC_REGS_INSTRUCTION15_CHAN_MASK) >> ADC_REGS_INSTRUCTION15_CHAN_SHIFT)
#define  ADC_REGS_INSTRUCTION15_CHAN_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_INSTRUCTION15_CHAN_MASK) | (((uint32_t)val) << ADC_REGS_INSTRUCTION15_CHAN_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 1 of 15) (Priority0)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 1 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY0_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY0_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY0_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY0_ENABLE_MASK) >> ADC_REGS_PRIORITY0_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY0_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY0_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY0_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY0_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY0_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY0_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY0_RESERVED1_MASK) >> ADC_REGS_PRIORITY0_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY0_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY0_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY0_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY0_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY0_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY0_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY0_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY0_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY0_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY0_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY0_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY0_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY0_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY0_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY0_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY0_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY0_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY0_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 2 of 15) (Priority1)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 2 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY1_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY1_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY1_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY1_ENABLE_MASK) >> ADC_REGS_PRIORITY1_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY1_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY1_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY1_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY1_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY1_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY1_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY1_RESERVED1_MASK) >> ADC_REGS_PRIORITY1_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY1_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY1_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY1_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY1_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY1_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY1_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY1_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY1_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY1_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY1_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY1_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY1_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY1_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY1_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY1_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY1_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY1_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY1_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 3 of 15) (Priority2)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 3 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY2_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY2_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY2_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY2_ENABLE_MASK) >> ADC_REGS_PRIORITY2_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY2_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY2_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY2_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY2_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY2_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY2_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY2_RESERVED1_MASK) >> ADC_REGS_PRIORITY2_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY2_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY2_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY2_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY2_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY2_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY2_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY2_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY2_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY2_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY2_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY2_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY2_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY2_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY2_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY2_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY2_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY2_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY2_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 4 of 15) (Priority3)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 4 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY3_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY3_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY3_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY3_ENABLE_MASK) >> ADC_REGS_PRIORITY3_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY3_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY3_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY3_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY3_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY3_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY3_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY3_RESERVED1_MASK) >> ADC_REGS_PRIORITY3_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY3_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY3_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY3_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY3_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY3_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY3_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY3_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY3_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY3_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY3_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY3_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY3_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY3_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY3_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY3_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY3_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY3_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY3_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 5 of 15) (Priority4)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 5 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY4_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY4_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY4_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY4_ENABLE_MASK) >> ADC_REGS_PRIORITY4_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY4_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY4_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY4_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY4_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY4_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY4_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY4_RESERVED1_MASK) >> ADC_REGS_PRIORITY4_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY4_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY4_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY4_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY4_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY4_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY4_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY4_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY4_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY4_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY4_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY4_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY4_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY4_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY4_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY4_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY4_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY4_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY4_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 6 of 15) (Priority5)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 6 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY5_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY5_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY5_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY5_ENABLE_MASK) >> ADC_REGS_PRIORITY5_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY5_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY5_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY5_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY5_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY5_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY5_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY5_RESERVED1_MASK) >> ADC_REGS_PRIORITY5_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY5_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY5_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY5_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY5_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY5_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY5_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY5_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY5_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY5_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY5_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY5_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY5_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY5_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY5_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY5_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY5_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY5_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY5_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 7 of 15) (Priority6)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 7 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY6_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY6_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY6_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY6_ENABLE_MASK) >> ADC_REGS_PRIORITY6_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY6_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY6_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY6_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY6_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY6_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY6_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY6_RESERVED1_MASK) >> ADC_REGS_PRIORITY6_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY6_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY6_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY6_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY6_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY6_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY6_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY6_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY6_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY6_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY6_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY6_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY6_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY6_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY6_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY6_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY6_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY6_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY6_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 8 of 15) (Priority7)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 8 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY7_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY7_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY7_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY7_ENABLE_MASK) >> ADC_REGS_PRIORITY7_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY7_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY7_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY7_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY7_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY7_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY7_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY7_RESERVED1_MASK) >> ADC_REGS_PRIORITY7_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY7_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY7_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY7_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY7_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY7_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY7_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY7_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY7_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY7_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY7_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY7_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY7_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY7_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY7_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY7_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY7_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY7_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY7_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 9 of 15) (Priority8)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 9 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY8_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY8_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY8_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY8_ENABLE_MASK) >> ADC_REGS_PRIORITY8_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY8_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY8_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY8_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY8_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY8_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY8_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY8_RESERVED1_MASK) >> ADC_REGS_PRIORITY8_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY8_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY8_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY8_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY8_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY8_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY8_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY8_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY8_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY8_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY8_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY8_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY8_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY8_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY8_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY8_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY8_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY8_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY8_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 10 of 15) (Priority9)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 10 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY9_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY9_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY9_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY9_ENABLE_MASK) >> ADC_REGS_PRIORITY9_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY9_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY9_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY9_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY9_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY9_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY9_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY9_RESERVED1_MASK) >> ADC_REGS_PRIORITY9_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY9_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY9_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY9_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY9_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY9_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY9_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY9_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY9_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY9_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY9_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY9_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY9_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY9_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY9_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY9_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY9_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY9_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY9_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 11 of 15) (Priority10)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 11 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY10_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY10_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY10_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY10_ENABLE_MASK) >> ADC_REGS_PRIORITY10_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY10_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY10_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY10_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY10_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY10_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY10_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY10_RESERVED1_MASK) >> ADC_REGS_PRIORITY10_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY10_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY10_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY10_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY10_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY10_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY10_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY10_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY10_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY10_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY10_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY10_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY10_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY10_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY10_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY10_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY10_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY10_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY10_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 12 of 15) (Priority11)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 12 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY11_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY11_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY11_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY11_ENABLE_MASK) >> ADC_REGS_PRIORITY11_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY11_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY11_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY11_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY11_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY11_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY11_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY11_RESERVED1_MASK) >> ADC_REGS_PRIORITY11_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY11_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY11_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY11_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY11_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY11_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY11_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY11_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY11_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY11_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY11_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY11_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY11_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY11_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY11_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY11_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY11_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY11_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY11_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 13 of 15) (Priority12)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 13 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY12_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY12_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY12_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY12_ENABLE_MASK) >> ADC_REGS_PRIORITY12_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY12_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY12_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY12_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY12_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY12_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY12_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY12_RESERVED1_MASK) >> ADC_REGS_PRIORITY12_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY12_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY12_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY12_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY12_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY12_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY12_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY12_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY12_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY12_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY12_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY12_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY12_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY12_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY12_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY12_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY12_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY12_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY12_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 14 of 15) (Priority13)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 14 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY13_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY13_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY13_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY13_ENABLE_MASK) >> ADC_REGS_PRIORITY13_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY13_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY13_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY13_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY13_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY13_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY13_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY13_RESERVED1_MASK) >> ADC_REGS_PRIORITY13_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY13_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY13_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY13_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY13_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY13_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY13_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY13_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY13_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY13_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY13_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY13_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY13_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY13_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY13_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY13_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY13_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY13_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY13_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register (Instance 15 of 15) (Priority14)
/** \brief The Priority Control Table has 16 entries to accommodate 16 trigger sources:
     14 hardware trigger descriptors, one firmware request descriptor, and one continuous mode descriptor.
     The prioritization among the trigger sources is implied by which register each trigger is
     programmably assigned to: <BR>
       Priority0 Register represents the highest priority trigger <BR>
       ... <BR>
       PriorityN Register represents N'th rank   <BR>
       ... <BR>
       Priority15 Register serves the Continuous mode trigger, which is the lowest priority of all. (Instance 15 of 15)*/
//====================================================================

#define  ADC_REGS_PRIORITY14_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY14_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY14_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY14_ENABLE_MASK) >> ADC_REGS_PRIORITY14_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY14_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY14_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY14_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY14_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY14_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY14_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY14_RESERVED1_MASK) >> ADC_REGS_PRIORITY14_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY14_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY14_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY14_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY14_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY14_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY14_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY14_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY14_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY14_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY14_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY14_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY14_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY14_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY14_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY14_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY14_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY14_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY14_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: Priority Control Table Register for Continuous mode (Priority_15)
/** \brief Continuous mode has the lowest priority of all the trigger sources.*/
//====================================================================

#define  ADC_REGS_PRIORITY_15_ENABLE_MASK 0x80000000
#define  ADC_REGS_PRIORITY_15_ENABLE_SHIFT 31
#define  ADC_REGS_PRIORITY_15_ENABLE_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY_15_ENABLE_MASK) >> ADC_REGS_PRIORITY_15_ENABLE_SHIFT)
#define  ADC_REGS_PRIORITY_15_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY_15_ENABLE_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY_15_ENABLE_SHIFT))

#define  ADC_REGS_PRIORITY_15_RESERVED1_MASK 0x7fffff00
#define  ADC_REGS_PRIORITY_15_RESERVED1_SHIFT 8
#define  ADC_REGS_PRIORITY_15_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY_15_RESERVED1_MASK) >> ADC_REGS_PRIORITY_15_RESERVED1_SHIFT)
#define  ADC_REGS_PRIORITY_15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY_15_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY_15_RESERVED1_SHIFT))

#define  ADC_REGS_PRIORITY_15_INSTR_ADDR_MASK 0xf0
#define  ADC_REGS_PRIORITY_15_INSTR_ADDR_SHIFT 4
#define  ADC_REGS_PRIORITY_15_INSTR_ADDR_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY_15_INSTR_ADDR_MASK) >> ADC_REGS_PRIORITY_15_INSTR_ADDR_SHIFT)
#define  ADC_REGS_PRIORITY_15_INSTR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY_15_INSTR_ADDR_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY_15_INSTR_ADDR_SHIFT))

#define  ADC_REGS_PRIORITY_15_TRIGGER_SRC_MASK 0xf
#define  ADC_REGS_PRIORITY_15_TRIGGER_SRC_SHIFT 0
#define  ADC_REGS_PRIORITY_15_TRIGGER_SRC_MASK_SHIFT(reg) (((reg) & ADC_REGS_PRIORITY_15_TRIGGER_SRC_MASK) >> ADC_REGS_PRIORITY_15_TRIGGER_SRC_SHIFT)
#define  ADC_REGS_PRIORITY_15_TRIGGER_SRC_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_PRIORITY_15_TRIGGER_SRC_MASK) | (((uint32_t)val) << ADC_REGS_PRIORITY_15_TRIGGER_SRC_SHIFT))

//====================================================================
//Register: HWTrigger Mux Control0 (TriggerMuxControl0)
/** \brief The ADC Control block provides 14 HW trigger input ports, HWtrigger[0-13]. For systems with more than 14 trigger sources, use this register to select the pre-HWtrigger mux input for HWtrigger[0-7]. The actual pre-HWtrigger multiplexers are outside of the ADC Control block.*/
//====================================================================

#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_7_MASK 0xf0000000
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_7_SHIFT 28
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_7_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_7_MASK) >> ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_7_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_7_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_7_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_7_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_6_MASK 0xf000000
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_6_SHIFT 24
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_6_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_6_MASK) >> ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_6_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_6_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_6_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_6_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_5_MASK 0xf00000
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_5_SHIFT 20
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_5_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_5_MASK) >> ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_5_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_5_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_5_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_5_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_4_MASK 0xf0000
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_4_SHIFT 16
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_4_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_4_MASK) >> ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_4_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_4_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_4_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_4_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_3_MASK 0xf000
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_3_SHIFT 12
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_3_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_3_MASK) >> ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_3_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_3_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_3_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_3_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_2_MASK 0xf00
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_2_SHIFT 8
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_2_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_2_MASK) >> ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_2_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_2_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_2_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_1_MASK 0xf0
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_1_SHIFT 4
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_1_MASK) >> ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_1_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_1_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_0_MASK 0xf
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_0_SHIFT 0
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_0_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_0_MASK) >> ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_0_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_0_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_0_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL0_MUXSEL_0_SHIFT))

//====================================================================
//Register: HWTrigger Mux Control1 (TriggerMuxControl1)
/** \brief The ADC Control block provides 14 HW trigger input ports, HWtrigger[0-13]. For systems with more than 14 trigger sources, use this register to select the pre-HWtrigger mux input for HWtrigger[8-13]. The actual pre-HWtrigger multiplexers are outside of the ADC Control block.*/
//====================================================================

#define  ADC_REGS_TRIGGERMUXCONTROL1_RESERVED1_MASK 0xff000000
#define  ADC_REGS_TRIGGERMUXCONTROL1_RESERVED1_SHIFT 24
#define  ADC_REGS_TRIGGERMUXCONTROL1_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL1_RESERVED1_MASK) >> ADC_REGS_TRIGGERMUXCONTROL1_RESERVED1_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL1_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL1_RESERVED1_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_13_MASK 0xf00000
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_13_SHIFT 20
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_13_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_13_MASK) >> ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_13_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_13_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_13_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_13_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_12_MASK 0xf0000
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_12_SHIFT 16
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_12_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_12_MASK) >> ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_12_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_12_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_12_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_12_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_11_MASK 0xf000
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_11_SHIFT 12
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_11_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_11_MASK) >> ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_11_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_11_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_11_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_11_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_10_MASK 0xf00
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_10_SHIFT 8
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_10_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_10_MASK) >> ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_10_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_10_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_10_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_10_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_9_MASK 0xf0
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_9_SHIFT 4
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_9_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_9_MASK) >> ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_9_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_9_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_9_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_9_SHIFT))

#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_8_MASK 0xf
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_8_SHIFT 0
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_8_MASK_SHIFT(reg) (((reg) & ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_8_MASK) >> ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_8_SHIFT)
#define  ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_8_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_8_MASK) | (((uint32_t)val) << ADC_REGS_TRIGGERMUXCONTROL1_MUXSEL_8_SHIFT))

//====================================================================
//Register: Datastamp Mux Control (DatastampMuxControl)
/** \brief The ADC Control block provides four datastamp input ports, Datastamp0-3. For systems with more than 4 datastamp sources, use this register to select the pre-Datastamp mux input. The actual pre-Datastamp multiplexers are outside of the ADC Control block.*/
//====================================================================

#define  ADC_REGS_DATASTAMPMUXCONTROL_RESERVED1_MASK 0xffff0000
#define  ADC_REGS_DATASTAMPMUXCONTROL_RESERVED1_SHIFT 16
#define  ADC_REGS_DATASTAMPMUXCONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & ADC_REGS_DATASTAMPMUXCONTROL_RESERVED1_MASK) >> ADC_REGS_DATASTAMPMUXCONTROL_RESERVED1_SHIFT)
#define  ADC_REGS_DATASTAMPMUXCONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_DATASTAMPMUXCONTROL_RESERVED1_MASK) | (((uint32_t)val) << ADC_REGS_DATASTAMPMUXCONTROL_RESERVED1_SHIFT))

#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_3_MASK 0xf000
#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_3_SHIFT 12
#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_3_MASK_SHIFT(reg) (((reg) & ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_3_MASK) >> ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_3_SHIFT)
#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_3_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_3_MASK) | (((uint32_t)val) << ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_3_SHIFT))

#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_2_MASK 0xf00
#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_2_SHIFT 8
#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_2_MASK_SHIFT(reg) (((reg) & ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_2_MASK) >> ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_2_SHIFT)
#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_2_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_2_MASK) | (((uint32_t)val) << ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_2_SHIFT))

#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_1_MASK 0xf0
#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_1_SHIFT 4
#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_1_MASK_SHIFT(reg) (((reg) & ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_1_MASK) >> ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_1_SHIFT)
#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_1_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_1_MASK) | (((uint32_t)val) << ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_1_SHIFT))

#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_0_MASK 0xf
#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_0_SHIFT 0
#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_0_MASK_SHIFT(reg) (((reg) & ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_0_MASK) >> ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_0_SHIFT)
#define  ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_0_REPLACE_VAL(reg,val) (((reg) & ~ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_0_MASK) | (((uint32_t)val) << ADC_REGS_DATASTAMPMUXCONTROL_MUXSEL_0_SHIFT))

#endif // ADC_REGS
