 /*
 **************************************************************************************
 *
 * Copyright (c) 2010 Marvell International, Ltd.
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file MC_regmasks.h
 * Generated using RegBuild 1.6.1
 *
 *************************************************************************
 */

#ifndef _MC_REGMASKS_H_
#define _MC_REGMASKS_H_

//#include <stdint.h>

//====================================================================
//
//Register File: MC (MC)
/** \brief This defines the registers for the Memory Controller (MC).*/
//
//====================================================================

//====================================================================
//Register: CPU ID and Revision (ID)
/** \brief This register contains the CPU ID and Revision.*/
//====================================================================

#define  MC_ID_RESERVED1_MASK 0xffff0000
#define  MC_ID_RESERVED1_SHIFT 16
#define  MC_ID_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_ID_RESERVED1_MASK) >> MC_ID_RESERVED1_SHIFT)
#define  MC_ID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_ID_RESERVED1_MASK) | (((uint32_t)val) << MC_ID_RESERVED1_SHIFT))

#define  MC_ID_ARCHVERSION_MASK 0xf000
#define  MC_ID_ARCHVERSION_SHIFT 12
#define  MC_ID_ARCHVERSION_MASK_SHIFT(reg) (((reg) & MC_ID_ARCHVERSION_MASK) >> MC_ID_ARCHVERSION_SHIFT)
#define  MC_ID_ARCHVERSION_REPLACE_VAL(reg,val) (((reg) & ~MC_ID_ARCHVERSION_MASK) | (((uint32_t)val) << MC_ID_ARCHVERSION_SHIFT))

#define  MC_ID_ARCHVARIANT_MASK 0xf00
#define  MC_ID_ARCHVARIANT_SHIFT 8
#define  MC_ID_ARCHVARIANT_MASK_SHIFT(reg) (((reg) & MC_ID_ARCHVARIANT_MASK) >> MC_ID_ARCHVARIANT_SHIFT)
#define  MC_ID_ARCHVARIANT_REPLACE_VAL(reg,val) (((reg) & ~MC_ID_ARCHVARIANT_MASK) | (((uint32_t)val) << MC_ID_ARCHVARIANT_SHIFT))

#define  MC_ID_REV_MASK 0xff
#define  MC_ID_REV_SHIFT 0
#define  MC_ID_REV_MASK_SHIFT(reg) (((reg) & MC_ID_REV_MASK) >> MC_ID_REV_SHIFT)
#define  MC_ID_REV_REPLACE_VAL(reg,val) (((reg) & ~MC_ID_REV_MASK) | (((uint32_t)val) << MC_ID_REV_SHIFT))

//====================================================================
//Register: Configuration Register Decode Address (RegDecodeAddr)
/** \brief This register defines the address of all regular configuration registers.
      If this register is changed, all subsequent configuration register
      accesses need to use the new address.*/
//====================================================================

#define  MC_REGDECODEADDR_CONFIGADDR_MASK 0xffff0000
#define  MC_REGDECODEADDR_CONFIGADDR_SHIFT 16
#define  MC_REGDECODEADDR_CONFIGADDR_MASK_SHIFT(reg) (((reg) & MC_REGDECODEADDR_CONFIGADDR_MASK) >> MC_REGDECODEADDR_CONFIGADDR_SHIFT)
#define  MC_REGDECODEADDR_CONFIGADDR_REPLACE_VAL(reg,val) (((reg) & ~MC_REGDECODEADDR_CONFIGADDR_MASK) | (((uint32_t)val) << MC_REGDECODEADDR_CONFIGADDR_SHIFT))

#define  MC_REGDECODEADDR_SIGNATURE_MASK 0xffff
#define  MC_REGDECODEADDR_SIGNATURE_SHIFT 0
#define  MC_REGDECODEADDR_SIGNATURE_MASK_SHIFT(reg) (((reg) & MC_REGDECODEADDR_SIGNATURE_MASK) >> MC_REGDECODEADDR_SIGNATURE_SHIFT)
#define  MC_REGDECODEADDR_SIGNATURE_REPLACE_VAL(reg,val) (((reg) & ~MC_REGDECODEADDR_SIGNATURE_MASK) | (((uint32_t)val) << MC_REGDECODEADDR_SIGNATURE_SHIFT))

//====================================================================
//Register: SDRAM Configuration Register 0 (SDRAMConfig0)
/** \brief This is the configuration of chip select 0.*/
//====================================================================

#define  MC_SDRAMCONFIG0_RESERVED1_MASK 0x80000000
#define  MC_SDRAMCONFIG0_RESERVED1_SHIFT 31
#define  MC_SDRAMCONFIG0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG0_RESERVED1_MASK) >> MC_SDRAMCONFIG0_RESERVED1_SHIFT)
#define  MC_SDRAMCONFIG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG0_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG0_RESERVED1_SHIFT))

#define  MC_SDRAMCONFIG0_PASR_MASK 0x70000000
#define  MC_SDRAMCONFIG0_PASR_SHIFT 28
#define  MC_SDRAMCONFIG0_PASR_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG0_PASR_MASK) >> MC_SDRAMCONFIG0_PASR_SHIFT)
#define  MC_SDRAMCONFIG0_PASR_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG0_PASR_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG0_PASR_SHIFT))

#define  MC_SDRAMCONFIG0_RESERVED2_MASK 0xff00000
#define  MC_SDRAMCONFIG0_RESERVED2_SHIFT 20
#define  MC_SDRAMCONFIG0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG0_RESERVED2_MASK) >> MC_SDRAMCONFIG0_RESERVED2_SHIFT)
#define  MC_SDRAMCONFIG0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG0_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG0_RESERVED2_SHIFT))

#define  MC_SDRAMCONFIG0_RTT_MASK 0xe0000
#define  MC_SDRAMCONFIG0_RTT_SHIFT 17
#define  MC_SDRAMCONFIG0_RTT_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG0_RTT_MASK) >> MC_SDRAMCONFIG0_RTT_SHIFT)
#define  MC_SDRAMCONFIG0_RTT_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG0_RTT_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG0_RTT_SHIFT))

#define  MC_SDRAMCONFIG0_RESERVED3_MASK 0x10000
#define  MC_SDRAMCONFIG0_RESERVED3_SHIFT 16
#define  MC_SDRAMCONFIG0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG0_RESERVED3_MASK) >> MC_SDRAMCONFIG0_RESERVED3_SHIFT)
#define  MC_SDRAMCONFIG0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG0_RESERVED3_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG0_RESERVED3_SHIFT))

#define  MC_SDRAMCONFIG0_ODS_MASK 0xc000
#define  MC_SDRAMCONFIG0_ODS_SHIFT 14
#define  MC_SDRAMCONFIG0_ODS_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG0_ODS_MASK) >> MC_SDRAMCONFIG0_ODS_SHIFT)
#define  MC_SDRAMCONFIG0_ODS_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG0_ODS_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG0_ODS_SHIFT))

#define  MC_SDRAMCONFIG0_BANK_MASK 0x3000
#define  MC_SDRAMCONFIG0_BANK_SHIFT 12
#define  MC_SDRAMCONFIG0_BANK_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG0_BANK_MASK) >> MC_SDRAMCONFIG0_BANK_SHIFT)
#define  MC_SDRAMCONFIG0_BANK_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG0_BANK_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG0_BANK_SHIFT))

#define  MC_SDRAMCONFIG0_ROW_MASK 0xf00
#define  MC_SDRAMCONFIG0_ROW_SHIFT 8
#define  MC_SDRAMCONFIG0_ROW_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG0_ROW_MASK) >> MC_SDRAMCONFIG0_ROW_SHIFT)
#define  MC_SDRAMCONFIG0_ROW_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG0_ROW_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG0_ROW_SHIFT))

#define  MC_SDRAMCONFIG0_COL_MASK 0xf0
#define  MC_SDRAMCONFIG0_COL_SHIFT 4
#define  MC_SDRAMCONFIG0_COL_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG0_COL_MASK) >> MC_SDRAMCONFIG0_COL_SHIFT)
#define  MC_SDRAMCONFIG0_COL_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG0_COL_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG0_COL_SHIFT))

#define  MC_SDRAMCONFIG0_RESERVED4_MASK 0xf
#define  MC_SDRAMCONFIG0_RESERVED4_SHIFT 0
#define  MC_SDRAMCONFIG0_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG0_RESERVED4_MASK) >> MC_SDRAMCONFIG0_RESERVED4_SHIFT)
#define  MC_SDRAMCONFIG0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG0_RESERVED4_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG0_RESERVED4_SHIFT))

//====================================================================
//Register: SDRAM Configuration Register 1 (SDRAMConfig1)
/** \brief This is the configuration of chip select 1.*/
//====================================================================

#define  MC_SDRAMCONFIG1_RESERVED1_MASK 0x80000000
#define  MC_SDRAMCONFIG1_RESERVED1_SHIFT 31
#define  MC_SDRAMCONFIG1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG1_RESERVED1_MASK) >> MC_SDRAMCONFIG1_RESERVED1_SHIFT)
#define  MC_SDRAMCONFIG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG1_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG1_RESERVED1_SHIFT))

#define  MC_SDRAMCONFIG1_PASR_MASK 0x70000000
#define  MC_SDRAMCONFIG1_PASR_SHIFT 28
#define  MC_SDRAMCONFIG1_PASR_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG1_PASR_MASK) >> MC_SDRAMCONFIG1_PASR_SHIFT)
#define  MC_SDRAMCONFIG1_PASR_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG1_PASR_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG1_PASR_SHIFT))

#define  MC_SDRAMCONFIG1_RESERVED2_MASK 0xff00000
#define  MC_SDRAMCONFIG1_RESERVED2_SHIFT 20
#define  MC_SDRAMCONFIG1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG1_RESERVED2_MASK) >> MC_SDRAMCONFIG1_RESERVED2_SHIFT)
#define  MC_SDRAMCONFIG1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG1_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG1_RESERVED2_SHIFT))

#define  MC_SDRAMCONFIG1_RTT_MASK 0xe0000
#define  MC_SDRAMCONFIG1_RTT_SHIFT 17
#define  MC_SDRAMCONFIG1_RTT_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG1_RTT_MASK) >> MC_SDRAMCONFIG1_RTT_SHIFT)
#define  MC_SDRAMCONFIG1_RTT_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG1_RTT_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG1_RTT_SHIFT))

#define  MC_SDRAMCONFIG1_RESERVED3_MASK 0x10000
#define  MC_SDRAMCONFIG1_RESERVED3_SHIFT 16
#define  MC_SDRAMCONFIG1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG1_RESERVED3_MASK) >> MC_SDRAMCONFIG1_RESERVED3_SHIFT)
#define  MC_SDRAMCONFIG1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG1_RESERVED3_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG1_RESERVED3_SHIFT))

#define  MC_SDRAMCONFIG1_ODS_MASK 0xc000
#define  MC_SDRAMCONFIG1_ODS_SHIFT 14
#define  MC_SDRAMCONFIG1_ODS_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG1_ODS_MASK) >> MC_SDRAMCONFIG1_ODS_SHIFT)
#define  MC_SDRAMCONFIG1_ODS_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG1_ODS_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG1_ODS_SHIFT))

#define  MC_SDRAMCONFIG1_BANK_MASK 0x3000
#define  MC_SDRAMCONFIG1_BANK_SHIFT 12
#define  MC_SDRAMCONFIG1_BANK_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG1_BANK_MASK) >> MC_SDRAMCONFIG1_BANK_SHIFT)
#define  MC_SDRAMCONFIG1_BANK_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG1_BANK_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG1_BANK_SHIFT))

#define  MC_SDRAMCONFIG1_ROW_MASK 0xf00
#define  MC_SDRAMCONFIG1_ROW_SHIFT 8
#define  MC_SDRAMCONFIG1_ROW_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG1_ROW_MASK) >> MC_SDRAMCONFIG1_ROW_SHIFT)
#define  MC_SDRAMCONFIG1_ROW_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG1_ROW_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG1_ROW_SHIFT))

#define  MC_SDRAMCONFIG1_COL_MASK 0xf0
#define  MC_SDRAMCONFIG1_COL_SHIFT 4
#define  MC_SDRAMCONFIG1_COL_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG1_COL_MASK) >> MC_SDRAMCONFIG1_COL_SHIFT)
#define  MC_SDRAMCONFIG1_COL_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG1_COL_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG1_COL_SHIFT))

#define  MC_SDRAMCONFIG1_RESERVED4_MASK 0xf
#define  MC_SDRAMCONFIG1_RESERVED4_SHIFT 0
#define  MC_SDRAMCONFIG1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG1_RESERVED4_MASK) >> MC_SDRAMCONFIG1_RESERVED4_SHIFT)
#define  MC_SDRAMCONFIG1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG1_RESERVED4_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG1_RESERVED4_SHIFT))

//====================================================================
//Register: SDRAM Configuration Register 2 (SDRAMConfig2)
/** \brief This is the configuration of chip select 2.*/
//====================================================================

#define  MC_SDRAMCONFIG2_RESERVED1_MASK 0x80000000
#define  MC_SDRAMCONFIG2_RESERVED1_SHIFT 31
#define  MC_SDRAMCONFIG2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG2_RESERVED1_MASK) >> MC_SDRAMCONFIG2_RESERVED1_SHIFT)
#define  MC_SDRAMCONFIG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG2_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG2_RESERVED1_SHIFT))

#define  MC_SDRAMCONFIG2_PASR_MASK 0x70000000
#define  MC_SDRAMCONFIG2_PASR_SHIFT 28
#define  MC_SDRAMCONFIG2_PASR_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG2_PASR_MASK) >> MC_SDRAMCONFIG2_PASR_SHIFT)
#define  MC_SDRAMCONFIG2_PASR_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG2_PASR_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG2_PASR_SHIFT))

#define  MC_SDRAMCONFIG2_RESERVED2_MASK 0xff00000
#define  MC_SDRAMCONFIG2_RESERVED2_SHIFT 20
#define  MC_SDRAMCONFIG2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG2_RESERVED2_MASK) >> MC_SDRAMCONFIG2_RESERVED2_SHIFT)
#define  MC_SDRAMCONFIG2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG2_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG2_RESERVED2_SHIFT))

#define  MC_SDRAMCONFIG2_RTT_MASK 0xe0000
#define  MC_SDRAMCONFIG2_RTT_SHIFT 17
#define  MC_SDRAMCONFIG2_RTT_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG2_RTT_MASK) >> MC_SDRAMCONFIG2_RTT_SHIFT)
#define  MC_SDRAMCONFIG2_RTT_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG2_RTT_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG2_RTT_SHIFT))

#define  MC_SDRAMCONFIG2_RESERVED3_MASK 0x10000
#define  MC_SDRAMCONFIG2_RESERVED3_SHIFT 16
#define  MC_SDRAMCONFIG2_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG2_RESERVED3_MASK) >> MC_SDRAMCONFIG2_RESERVED3_SHIFT)
#define  MC_SDRAMCONFIG2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG2_RESERVED3_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG2_RESERVED3_SHIFT))

#define  MC_SDRAMCONFIG2_ODS_MASK 0xc000
#define  MC_SDRAMCONFIG2_ODS_SHIFT 14
#define  MC_SDRAMCONFIG2_ODS_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG2_ODS_MASK) >> MC_SDRAMCONFIG2_ODS_SHIFT)
#define  MC_SDRAMCONFIG2_ODS_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG2_ODS_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG2_ODS_SHIFT))

#define  MC_SDRAMCONFIG2_BANK_MASK 0x3000
#define  MC_SDRAMCONFIG2_BANK_SHIFT 12
#define  MC_SDRAMCONFIG2_BANK_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG2_BANK_MASK) >> MC_SDRAMCONFIG2_BANK_SHIFT)
#define  MC_SDRAMCONFIG2_BANK_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG2_BANK_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG2_BANK_SHIFT))

#define  MC_SDRAMCONFIG2_ROW_MASK 0xf00
#define  MC_SDRAMCONFIG2_ROW_SHIFT 8
#define  MC_SDRAMCONFIG2_ROW_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG2_ROW_MASK) >> MC_SDRAMCONFIG2_ROW_SHIFT)
#define  MC_SDRAMCONFIG2_ROW_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG2_ROW_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG2_ROW_SHIFT))

#define  MC_SDRAMCONFIG2_COL_MASK 0xf0
#define  MC_SDRAMCONFIG2_COL_SHIFT 4
#define  MC_SDRAMCONFIG2_COL_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG2_COL_MASK) >> MC_SDRAMCONFIG2_COL_SHIFT)
#define  MC_SDRAMCONFIG2_COL_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG2_COL_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG2_COL_SHIFT))

#define  MC_SDRAMCONFIG2_RESERVED4_MASK 0xf
#define  MC_SDRAMCONFIG2_RESERVED4_SHIFT 0
#define  MC_SDRAMCONFIG2_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG2_RESERVED4_MASK) >> MC_SDRAMCONFIG2_RESERVED4_SHIFT)
#define  MC_SDRAMCONFIG2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG2_RESERVED4_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG2_RESERVED4_SHIFT))

//====================================================================
//Register: SDRAM Configuration Register 3 (SDRAMConfig3)
/** \brief This is the configuration of chip select 3.*/
//====================================================================

#define  MC_SDRAMCONFIG3_RESERVED1_MASK 0x80000000
#define  MC_SDRAMCONFIG3_RESERVED1_SHIFT 31
#define  MC_SDRAMCONFIG3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG3_RESERVED1_MASK) >> MC_SDRAMCONFIG3_RESERVED1_SHIFT)
#define  MC_SDRAMCONFIG3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG3_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG3_RESERVED1_SHIFT))

#define  MC_SDRAMCONFIG3_PASR_MASK 0x70000000
#define  MC_SDRAMCONFIG3_PASR_SHIFT 28
#define  MC_SDRAMCONFIG3_PASR_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG3_PASR_MASK) >> MC_SDRAMCONFIG3_PASR_SHIFT)
#define  MC_SDRAMCONFIG3_PASR_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG3_PASR_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG3_PASR_SHIFT))

#define  MC_SDRAMCONFIG3_RESERVED2_MASK 0xff00000
#define  MC_SDRAMCONFIG3_RESERVED2_SHIFT 20
#define  MC_SDRAMCONFIG3_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG3_RESERVED2_MASK) >> MC_SDRAMCONFIG3_RESERVED2_SHIFT)
#define  MC_SDRAMCONFIG3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG3_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG3_RESERVED2_SHIFT))

#define  MC_SDRAMCONFIG3_RTT_MASK 0xe0000
#define  MC_SDRAMCONFIG3_RTT_SHIFT 17
#define  MC_SDRAMCONFIG3_RTT_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG3_RTT_MASK) >> MC_SDRAMCONFIG3_RTT_SHIFT)
#define  MC_SDRAMCONFIG3_RTT_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG3_RTT_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG3_RTT_SHIFT))

#define  MC_SDRAMCONFIG3_RESERVED3_MASK 0x10000
#define  MC_SDRAMCONFIG3_RESERVED3_SHIFT 16
#define  MC_SDRAMCONFIG3_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG3_RESERVED3_MASK) >> MC_SDRAMCONFIG3_RESERVED3_SHIFT)
#define  MC_SDRAMCONFIG3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG3_RESERVED3_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG3_RESERVED3_SHIFT))

#define  MC_SDRAMCONFIG3_ODS_MASK 0xc000
#define  MC_SDRAMCONFIG3_ODS_SHIFT 14
#define  MC_SDRAMCONFIG3_ODS_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG3_ODS_MASK) >> MC_SDRAMCONFIG3_ODS_SHIFT)
#define  MC_SDRAMCONFIG3_ODS_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG3_ODS_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG3_ODS_SHIFT))

#define  MC_SDRAMCONFIG3_BANK_MASK 0x3000
#define  MC_SDRAMCONFIG3_BANK_SHIFT 12
#define  MC_SDRAMCONFIG3_BANK_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG3_BANK_MASK) >> MC_SDRAMCONFIG3_BANK_SHIFT)
#define  MC_SDRAMCONFIG3_BANK_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG3_BANK_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG3_BANK_SHIFT))

#define  MC_SDRAMCONFIG3_ROW_MASK 0xf00
#define  MC_SDRAMCONFIG3_ROW_SHIFT 8
#define  MC_SDRAMCONFIG3_ROW_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG3_ROW_MASK) >> MC_SDRAMCONFIG3_ROW_SHIFT)
#define  MC_SDRAMCONFIG3_ROW_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG3_ROW_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG3_ROW_SHIFT))

#define  MC_SDRAMCONFIG3_COL_MASK 0xf0
#define  MC_SDRAMCONFIG3_COL_SHIFT 4
#define  MC_SDRAMCONFIG3_COL_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG3_COL_MASK) >> MC_SDRAMCONFIG3_COL_SHIFT)
#define  MC_SDRAMCONFIG3_COL_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG3_COL_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG3_COL_SHIFT))

#define  MC_SDRAMCONFIG3_RESERVED4_MASK 0xf
#define  MC_SDRAMCONFIG3_RESERVED4_SHIFT 0
#define  MC_SDRAMCONFIG3_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONFIG3_RESERVED4_MASK) >> MC_SDRAMCONFIG3_RESERVED4_SHIFT)
#define  MC_SDRAMCONFIG3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONFIG3_RESERVED4_MASK) | (((uint32_t)val) << MC_SDRAMCONFIG3_RESERVED4_SHIFT))

//====================================================================
//Register: SDRAM Timing Register I (SDRAMTiming1)
/** \brief This is the first timing setup register. All values
      are in DCLK units. Its values are applied to all chip selects.*/
//====================================================================

#define  MC_SDRAMTIMING1_TCCD_MASK 0xe0000000
#define  MC_SDRAMTIMING1_TCCD_SHIFT 29
#define  MC_SDRAMTIMING1_TCCD_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING1_TCCD_MASK) >> MC_SDRAMTIMING1_TCCD_SHIFT)
#define  MC_SDRAMTIMING1_TCCD_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING1_TCCD_MASK) | (((uint32_t)val) << MC_SDRAMTIMING1_TCCD_SHIFT))

#define  MC_SDRAMTIMING1_TRTP_MASK 0x1c000000
#define  MC_SDRAMTIMING1_TRTP_SHIFT 26
#define  MC_SDRAMTIMING1_TRTP_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING1_TRTP_MASK) >> MC_SDRAMTIMING1_TRTP_SHIFT)
#define  MC_SDRAMTIMING1_TRTP_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING1_TRTP_MASK) | (((uint32_t)val) << MC_SDRAMTIMING1_TRTP_SHIFT))

#define  MC_SDRAMTIMING1_TWTR_MASK 0x3c00000
#define  MC_SDRAMTIMING1_TWTR_SHIFT 22
#define  MC_SDRAMTIMING1_TWTR_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING1_TWTR_MASK) >> MC_SDRAMTIMING1_TWTR_SHIFT)
#define  MC_SDRAMTIMING1_TWTR_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING1_TWTR_MASK) | (((uint32_t)val) << MC_SDRAMTIMING1_TWTR_SHIFT))

#define  MC_SDRAMTIMING1_TRC_MASK 0x3f0000
#define  MC_SDRAMTIMING1_TRC_SHIFT 16
#define  MC_SDRAMTIMING1_TRC_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING1_TRC_MASK) >> MC_SDRAMTIMING1_TRC_SHIFT)
#define  MC_SDRAMTIMING1_TRC_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING1_TRC_MASK) | (((uint32_t)val) << MC_SDRAMTIMING1_TRC_SHIFT))

#define  MC_SDRAMTIMING1_TREFC_MASK 0xffff
#define  MC_SDRAMTIMING1_TREFC_SHIFT 0
#define  MC_SDRAMTIMING1_TREFC_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING1_TREFC_MASK) >> MC_SDRAMTIMING1_TREFC_SHIFT)
#define  MC_SDRAMTIMING1_TREFC_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING1_TREFC_MASK) | (((uint32_t)val) << MC_SDRAMTIMING1_TREFC_SHIFT))

//====================================================================
//Register: SDRAM Timing Register II (SDRAMTiming2)
/** \brief This is the second timing setup register.
      Its values are applied to all chip selects.*/
//====================================================================

#define  MC_SDRAMTIMING2_TRP_MASK 0xf0000000
#define  MC_SDRAMTIMING2_TRP_SHIFT 28
#define  MC_SDRAMTIMING2_TRP_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING2_TRP_MASK) >> MC_SDRAMTIMING2_TRP_SHIFT)
#define  MC_SDRAMTIMING2_TRP_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING2_TRP_MASK) | (((uint32_t)val) << MC_SDRAMTIMING2_TRP_SHIFT))

#define  MC_SDRAMTIMING2_TRRD_MASK 0xf000000
#define  MC_SDRAMTIMING2_TRRD_SHIFT 24
#define  MC_SDRAMTIMING2_TRRD_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING2_TRRD_MASK) >> MC_SDRAMTIMING2_TRRD_SHIFT)
#define  MC_SDRAMTIMING2_TRRD_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING2_TRRD_MASK) | (((uint32_t)val) << MC_SDRAMTIMING2_TRRD_SHIFT))

#define  MC_SDRAMTIMING2_TRCD_MASK 0xf00000
#define  MC_SDRAMTIMING2_TRCD_SHIFT 20
#define  MC_SDRAMTIMING2_TRCD_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING2_TRCD_MASK) >> MC_SDRAMTIMING2_TRCD_SHIFT)
#define  MC_SDRAMTIMING2_TRCD_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING2_TRCD_MASK) | (((uint32_t)val) << MC_SDRAMTIMING2_TRCD_SHIFT))

#define  MC_SDRAMTIMING2_TWR_MASK 0xf0000
#define  MC_SDRAMTIMING2_TWR_SHIFT 16
#define  MC_SDRAMTIMING2_TWR_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING2_TWR_MASK) >> MC_SDRAMTIMING2_TWR_SHIFT)
#define  MC_SDRAMTIMING2_TWR_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING2_TWR_MASK) | (((uint32_t)val) << MC_SDRAMTIMING2_TWR_SHIFT))

#define  MC_SDRAMTIMING2_RESERVED1_MASK 0xe000
#define  MC_SDRAMTIMING2_RESERVED1_SHIFT 13
#define  MC_SDRAMTIMING2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING2_RESERVED1_MASK) >> MC_SDRAMTIMING2_RESERVED1_SHIFT)
#define  MC_SDRAMTIMING2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING2_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMTIMING2_RESERVED1_SHIFT))

#define  MC_SDRAMTIMING2_TRFC_MASK 0x1ff0
#define  MC_SDRAMTIMING2_TRFC_SHIFT 4
#define  MC_SDRAMTIMING2_TRFC_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING2_TRFC_MASK) >> MC_SDRAMTIMING2_TRFC_SHIFT)
#define  MC_SDRAMTIMING2_TRFC_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING2_TRFC_MASK) | (((uint32_t)val) << MC_SDRAMTIMING2_TRFC_SHIFT))

#define  MC_SDRAMTIMING2_RESERVED2_MASK 0x8
#define  MC_SDRAMTIMING2_RESERVED2_SHIFT 3
#define  MC_SDRAMTIMING2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING2_RESERVED2_MASK) >> MC_SDRAMTIMING2_RESERVED2_SHIFT)
#define  MC_SDRAMTIMING2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING2_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMTIMING2_RESERVED2_SHIFT))

#define  MC_SDRAMTIMING2_TMRD_MASK 0x7
#define  MC_SDRAMTIMING2_TMRD_SHIFT 0
#define  MC_SDRAMTIMING2_TMRD_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING2_TMRD_MASK) >> MC_SDRAMTIMING2_TMRD_SHIFT)
#define  MC_SDRAMTIMING2_TMRD_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING2_TMRD_MASK) | (((uint32_t)val) << MC_SDRAMTIMING2_TMRD_SHIFT))

//====================================================================
//Register: SDRAM Timing Register III (SDRAMTiming3)
/** \brief This is the third timing setup register. All values are
      in DCLK units. Its values are applied to all chip selects.*/
//====================================================================

#define  MC_SDRAMTIMING3_TMOD_MASK 0xf0000000
#define  MC_SDRAMTIMING3_TMOD_SHIFT 28
#define  MC_SDRAMTIMING3_TMOD_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING3_TMOD_MASK) >> MC_SDRAMTIMING3_TMOD_SHIFT)
#define  MC_SDRAMTIMING3_TMOD_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING3_TMOD_MASK) | (((uint32_t)val) << MC_SDRAMTIMING3_TMOD_SHIFT))

#define  MC_SDRAMTIMING3_RESERVED1_MASK 0x8000000
#define  MC_SDRAMTIMING3_RESERVED1_SHIFT 27
#define  MC_SDRAMTIMING3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING3_RESERVED1_MASK) >> MC_SDRAMTIMING3_RESERVED1_SHIFT)
#define  MC_SDRAMTIMING3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING3_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMTIMING3_RESERVED1_SHIFT))

#define  MC_SDRAMTIMING3_TXSNR_8_MASK 0x4000000
#define  MC_SDRAMTIMING3_TXSNR_8_SHIFT 26
#define  MC_SDRAMTIMING3_TXSNR_8_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING3_TXSNR_8_MASK) >> MC_SDRAMTIMING3_TXSNR_8_SHIFT)
#define  MC_SDRAMTIMING3_TXSNR_8_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING3_TXSNR_8_MASK) | (((uint32_t)val) << MC_SDRAMTIMING3_TXSNR_8_SHIFT))

#define  MC_SDRAMTIMING3_TXSRD_MASK 0x3ff0000
#define  MC_SDRAMTIMING3_TXSRD_SHIFT 16
#define  MC_SDRAMTIMING3_TXSRD_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING3_TXSRD_MASK) >> MC_SDRAMTIMING3_TXSRD_SHIFT)
#define  MC_SDRAMTIMING3_TXSRD_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING3_TXSRD_MASK) | (((uint32_t)val) << MC_SDRAMTIMING3_TXSRD_SHIFT))

#define  MC_SDRAMTIMING3_TXSNR_MASK 0xff00
#define  MC_SDRAMTIMING3_TXSNR_SHIFT 8
#define  MC_SDRAMTIMING3_TXSNR_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING3_TXSNR_MASK) >> MC_SDRAMTIMING3_TXSNR_SHIFT)
#define  MC_SDRAMTIMING3_TXSNR_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING3_TXSNR_MASK) | (((uint32_t)val) << MC_SDRAMTIMING3_TXSNR_SHIFT))

#define  MC_SDRAMTIMING3_TXARDS_MASK 0xf8
#define  MC_SDRAMTIMING3_TXARDS_SHIFT 3
#define  MC_SDRAMTIMING3_TXARDS_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING3_TXARDS_MASK) >> MC_SDRAMTIMING3_TXARDS_SHIFT)
#define  MC_SDRAMTIMING3_TXARDS_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING3_TXARDS_MASK) | (((uint32_t)val) << MC_SDRAMTIMING3_TXARDS_SHIFT))

#define  MC_SDRAMTIMING3_TXP_MASK 0x7
#define  MC_SDRAMTIMING3_TXP_SHIFT 0
#define  MC_SDRAMTIMING3_TXP_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING3_TXP_MASK) >> MC_SDRAMTIMING3_TXP_SHIFT)
#define  MC_SDRAMTIMING3_TXP_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING3_TXP_MASK) | (((uint32_t)val) << MC_SDRAMTIMING3_TXP_SHIFT))

//====================================================================
//Register: SDRAM Timing Register IV (SDRAMTiming4)
/** \brief This is the fourth timing setup register.
      Its values are applied to all chip selects.*/
//====================================================================

#define  MC_SDRAMTIMING4_RESERVED1_MASK 0x80000000
#define  MC_SDRAMTIMING4_RESERVED1_SHIFT 31
#define  MC_SDRAMTIMING4_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING4_RESERVED1_MASK) >> MC_SDRAMTIMING4_RESERVED1_SHIFT)
#define  MC_SDRAMTIMING4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING4_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMTIMING4_RESERVED1_SHIFT))

#define  MC_SDRAMTIMING4_TCKE_MASK 0x70000000
#define  MC_SDRAMTIMING4_TCKE_SHIFT 28
#define  MC_SDRAMTIMING4_TCKE_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING4_TCKE_MASK) >> MC_SDRAMTIMING4_TCKE_SHIFT)
#define  MC_SDRAMTIMING4_TCKE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING4_TCKE_MASK) | (((uint32_t)val) << MC_SDRAMTIMING4_TCKE_SHIFT))

#define  MC_SDRAMTIMING4_INITCOUNT_MASK 0xff00000
#define  MC_SDRAMTIMING4_INITCOUNT_SHIFT 20
#define  MC_SDRAMTIMING4_INITCOUNT_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING4_INITCOUNT_MASK) >> MC_SDRAMTIMING4_INITCOUNT_SHIFT)
#define  MC_SDRAMTIMING4_INITCOUNT_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING4_INITCOUNT_MASK) | (((uint32_t)val) << MC_SDRAMTIMING4_INITCOUNT_SHIFT))

#define  MC_SDRAMTIMING4_TRWDEXTDLY_MASK 0xe0000
#define  MC_SDRAMTIMING4_TRWDEXTDLY_SHIFT 17
#define  MC_SDRAMTIMING4_TRWDEXTDLY_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING4_TRWDEXTDLY_MASK) >> MC_SDRAMTIMING4_TRWDEXTDLY_SHIFT)
#define  MC_SDRAMTIMING4_TRWDEXTDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING4_TRWDEXTDLY_MASK) | (((uint32_t)val) << MC_SDRAMTIMING4_TRWDEXTDLY_SHIFT))

#define  MC_SDRAMTIMING4_RESETCOUNT_MASK 0x1fc00
#define  MC_SDRAMTIMING4_RESETCOUNT_SHIFT 10
#define  MC_SDRAMTIMING4_RESETCOUNT_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING4_RESETCOUNT_MASK) >> MC_SDRAMTIMING4_RESETCOUNT_SHIFT)
#define  MC_SDRAMTIMING4_RESETCOUNT_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING4_RESETCOUNT_MASK) | (((uint32_t)val) << MC_SDRAMTIMING4_RESETCOUNT_SHIFT))

#define  MC_SDRAMTIMING4_INITCOUNTNOP_MASK 0x3ff
#define  MC_SDRAMTIMING4_INITCOUNTNOP_SHIFT 0
#define  MC_SDRAMTIMING4_INITCOUNTNOP_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING4_INITCOUNTNOP_MASK) >> MC_SDRAMTIMING4_INITCOUNTNOP_SHIFT)
#define  MC_SDRAMTIMING4_INITCOUNTNOP_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING4_INITCOUNTNOP_MASK) | (((uint32_t)val) << MC_SDRAMTIMING4_INITCOUNTNOP_SHIFT))

//====================================================================
//Register: SDRAM Timing Register V (SDRAMTiming5)
/** \brief This is the fifth timing setup register.
      Its values are applied to all chip selects.*/
//====================================================================

#define  MC_SDRAMTIMING5_RESERVED1_MASK 0xffc00000
#define  MC_SDRAMTIMING5_RESERVED1_SHIFT 22
#define  MC_SDRAMTIMING5_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING5_RESERVED1_MASK) >> MC_SDRAMTIMING5_RESERVED1_SHIFT)
#define  MC_SDRAMTIMING5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING5_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMTIMING5_RESERVED1_SHIFT))

#define  MC_SDRAMTIMING5_TRAS_MASK 0x3f0000
#define  MC_SDRAMTIMING5_TRAS_SHIFT 16
#define  MC_SDRAMTIMING5_TRAS_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING5_TRAS_MASK) >> MC_SDRAMTIMING5_TRAS_SHIFT)
#define  MC_SDRAMTIMING5_TRAS_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING5_TRAS_MASK) | (((uint32_t)val) << MC_SDRAMTIMING5_TRAS_SHIFT))

#define  MC_SDRAMTIMING5_RESERVED2_MASK 0x8000
#define  MC_SDRAMTIMING5_RESERVED2_SHIFT 15
#define  MC_SDRAMTIMING5_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING5_RESERVED2_MASK) >> MC_SDRAMTIMING5_RESERVED2_SHIFT)
#define  MC_SDRAMTIMING5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING5_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMTIMING5_RESERVED2_SHIFT))

#define  MC_SDRAMTIMING5_TCCD_CCS_WR_EXT_DLY_MASK 0x7000
#define  MC_SDRAMTIMING5_TCCD_CCS_WR_EXT_DLY_SHIFT 12
#define  MC_SDRAMTIMING5_TCCD_CCS_WR_EXT_DLY_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING5_TCCD_CCS_WR_EXT_DLY_MASK) >> MC_SDRAMTIMING5_TCCD_CCS_WR_EXT_DLY_SHIFT)
#define  MC_SDRAMTIMING5_TCCD_CCS_WR_EXT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING5_TCCD_CCS_WR_EXT_DLY_MASK) | (((uint32_t)val) << MC_SDRAMTIMING5_TCCD_CCS_WR_EXT_DLY_SHIFT))

#define  MC_SDRAMTIMING5_RESERVED3_MASK 0xc00
#define  MC_SDRAMTIMING5_RESERVED3_SHIFT 10
#define  MC_SDRAMTIMING5_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING5_RESERVED3_MASK) >> MC_SDRAMTIMING5_RESERVED3_SHIFT)
#define  MC_SDRAMTIMING5_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING5_RESERVED3_MASK) | (((uint32_t)val) << MC_SDRAMTIMING5_RESERVED3_SHIFT))

#define  MC_SDRAMTIMING5_TFAW_MASK 0x3f0
#define  MC_SDRAMTIMING5_TFAW_SHIFT 4
#define  MC_SDRAMTIMING5_TFAW_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING5_TFAW_MASK) >> MC_SDRAMTIMING5_TFAW_SHIFT)
#define  MC_SDRAMTIMING5_TFAW_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING5_TFAW_MASK) | (((uint32_t)val) << MC_SDRAMTIMING5_TFAW_SHIFT))

#define  MC_SDRAMTIMING5_RESERVED4_MASK 0x8
#define  MC_SDRAMTIMING5_RESERVED4_SHIFT 3
#define  MC_SDRAMTIMING5_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING5_RESERVED4_MASK) >> MC_SDRAMTIMING5_RESERVED4_SHIFT)
#define  MC_SDRAMTIMING5_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING5_RESERVED4_MASK) | (((uint32_t)val) << MC_SDRAMTIMING5_RESERVED4_SHIFT))

#define  MC_SDRAMTIMING5_TCCD_CCS_EXT_DLY_MASK 0x7
#define  MC_SDRAMTIMING5_TCCD_CCS_EXT_DLY_SHIFT 0
#define  MC_SDRAMTIMING5_TCCD_CCS_EXT_DLY_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING5_TCCD_CCS_EXT_DLY_MASK) >> MC_SDRAMTIMING5_TCCD_CCS_EXT_DLY_SHIFT)
#define  MC_SDRAMTIMING5_TCCD_CCS_EXT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING5_TCCD_CCS_EXT_DLY_MASK) | (((uint32_t)val) << MC_SDRAMTIMING5_TCCD_CCS_EXT_DLY_SHIFT))

//====================================================================
//Register: SDRAM Timing Register VI (SDRAMTiming6)
/** \brief This is the sixth timing setup register.
      Its values are applied to all chip selects.*/
//====================================================================

#define  MC_SDRAMTIMING6_TWL_EARLY_MASK 0xc0000000
#define  MC_SDRAMTIMING6_TWL_EARLY_SHIFT 30
#define  MC_SDRAMTIMING6_TWL_EARLY_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING6_TWL_EARLY_MASK) >> MC_SDRAMTIMING6_TWL_EARLY_SHIFT)
#define  MC_SDRAMTIMING6_TWL_EARLY_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING6_TWL_EARLY_MASK) | (((uint32_t)val) << MC_SDRAMTIMING6_TWL_EARLY_SHIFT))

#define  MC_SDRAMTIMING6_RESERVED1_MASK 0x20000000
#define  MC_SDRAMTIMING6_RESERVED1_SHIFT 29
#define  MC_SDRAMTIMING6_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING6_RESERVED1_MASK) >> MC_SDRAMTIMING6_RESERVED1_SHIFT)
#define  MC_SDRAMTIMING6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING6_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMTIMING6_RESERVED1_SHIFT))

#define  MC_SDRAMTIMING6_TZQCS_MASK 0x1ff00000
#define  MC_SDRAMTIMING6_TZQCS_SHIFT 20
#define  MC_SDRAMTIMING6_TZQCS_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING6_TZQCS_MASK) >> MC_SDRAMTIMING6_TZQCS_SHIFT)
#define  MC_SDRAMTIMING6_TZQCS_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING6_TZQCS_MASK) | (((uint32_t)val) << MC_SDRAMTIMING6_TZQCS_SHIFT))

#define  MC_SDRAMTIMING6_RESERVED2_MASK 0x80000
#define  MC_SDRAMTIMING6_RESERVED2_SHIFT 19
#define  MC_SDRAMTIMING6_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING6_RESERVED2_MASK) >> MC_SDRAMTIMING6_RESERVED2_SHIFT)
#define  MC_SDRAMTIMING6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING6_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMTIMING6_RESERVED2_SHIFT))

#define  MC_SDRAMTIMING6_TZQOPER_MASK 0x7fc00
#define  MC_SDRAMTIMING6_TZQOPER_SHIFT 10
#define  MC_SDRAMTIMING6_TZQOPER_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING6_TZQOPER_MASK) >> MC_SDRAMTIMING6_TZQOPER_SHIFT)
#define  MC_SDRAMTIMING6_TZQOPER_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING6_TZQOPER_MASK) | (((uint32_t)val) << MC_SDRAMTIMING6_TZQOPER_SHIFT))

#define  MC_SDRAMTIMING6_TZQINIT_MASK 0x3ff
#define  MC_SDRAMTIMING6_TZQINIT_SHIFT 0
#define  MC_SDRAMTIMING6_TZQINIT_MASK_SHIFT(reg) (((reg) & MC_SDRAMTIMING6_TZQINIT_MASK) >> MC_SDRAMTIMING6_TZQINIT_SHIFT)
#define  MC_SDRAMTIMING6_TZQINIT_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMTIMING6_TZQINIT_MASK) | (((uint32_t)val) << MC_SDRAMTIMING6_TZQINIT_SHIFT))

//====================================================================
//Register: FTDLL Configuration (FTDLLConfig)
/** \brief This register configures the MSIL FTDLL macro. Refer to the FTDLL
      datasheet for more information.*/
//====================================================================

#define  MC_FTDLLCONFIG_OFFSETVALC_MASK 0xf8000000
#define  MC_FTDLLCONFIG_OFFSETVALC_SHIFT 27
#define  MC_FTDLLCONFIG_OFFSETVALC_MASK_SHIFT(reg) (((reg) & MC_FTDLLCONFIG_OFFSETVALC_MASK) >> MC_FTDLLCONFIG_OFFSETVALC_SHIFT)
#define  MC_FTDLLCONFIG_OFFSETVALC_REPLACE_VAL(reg,val) (((reg) & ~MC_FTDLLCONFIG_OFFSETVALC_MASK) | (((uint32_t)val) << MC_FTDLLCONFIG_OFFSETVALC_SHIFT))

#define  MC_FTDLLCONFIG_OFFSETCTLC_MASK 0x6000000
#define  MC_FTDLLCONFIG_OFFSETCTLC_SHIFT 25
#define  MC_FTDLLCONFIG_OFFSETCTLC_MASK_SHIFT(reg) (((reg) & MC_FTDLLCONFIG_OFFSETCTLC_MASK) >> MC_FTDLLCONFIG_OFFSETCTLC_SHIFT)
#define  MC_FTDLLCONFIG_OFFSETCTLC_REPLACE_VAL(reg,val) (((reg) & ~MC_FTDLLCONFIG_OFFSETCTLC_MASK) | (((uint32_t)val) << MC_FTDLLCONFIG_OFFSETCTLC_SHIFT))

#define  MC_FTDLLCONFIG_OFFSETVALB_MASK 0x1f00000
#define  MC_FTDLLCONFIG_OFFSETVALB_SHIFT 20
#define  MC_FTDLLCONFIG_OFFSETVALB_MASK_SHIFT(reg) (((reg) & MC_FTDLLCONFIG_OFFSETVALB_MASK) >> MC_FTDLLCONFIG_OFFSETVALB_SHIFT)
#define  MC_FTDLLCONFIG_OFFSETVALB_REPLACE_VAL(reg,val) (((reg) & ~MC_FTDLLCONFIG_OFFSETVALB_MASK) | (((uint32_t)val) << MC_FTDLLCONFIG_OFFSETVALB_SHIFT))

#define  MC_FTDLLCONFIG_OFFSETCTLB_MASK 0xc0000
#define  MC_FTDLLCONFIG_OFFSETCTLB_SHIFT 18
#define  MC_FTDLLCONFIG_OFFSETCTLB_MASK_SHIFT(reg) (((reg) & MC_FTDLLCONFIG_OFFSETCTLB_MASK) >> MC_FTDLLCONFIG_OFFSETCTLB_SHIFT)
#define  MC_FTDLLCONFIG_OFFSETCTLB_REPLACE_VAL(reg,val) (((reg) & ~MC_FTDLLCONFIG_OFFSETCTLB_MASK) | (((uint32_t)val) << MC_FTDLLCONFIG_OFFSETCTLB_SHIFT))

#define  MC_FTDLLCONFIG_OFFSETVALA_MASK 0x3e000
#define  MC_FTDLLCONFIG_OFFSETVALA_SHIFT 13
#define  MC_FTDLLCONFIG_OFFSETVALA_MASK_SHIFT(reg) (((reg) & MC_FTDLLCONFIG_OFFSETVALA_MASK) >> MC_FTDLLCONFIG_OFFSETVALA_SHIFT)
#define  MC_FTDLLCONFIG_OFFSETVALA_REPLACE_VAL(reg,val) (((reg) & ~MC_FTDLLCONFIG_OFFSETVALA_MASK) | (((uint32_t)val) << MC_FTDLLCONFIG_OFFSETVALA_SHIFT))

#define  MC_FTDLLCONFIG_OFFSETCTLA_MASK 0x1800
#define  MC_FTDLLCONFIG_OFFSETCTLA_SHIFT 11
#define  MC_FTDLLCONFIG_OFFSETCTLA_MASK_SHIFT(reg) (((reg) & MC_FTDLLCONFIG_OFFSETCTLA_MASK) >> MC_FTDLLCONFIG_OFFSETCTLA_SHIFT)
#define  MC_FTDLLCONFIG_OFFSETCTLA_REPLACE_VAL(reg,val) (((reg) & ~MC_FTDLLCONFIG_OFFSETCTLA_MASK) | (((uint32_t)val) << MC_FTDLLCONFIG_OFFSETCTLA_SHIFT))

#define  MC_FTDLLCONFIG_INITDELAY_MASK 0x7f0
#define  MC_FTDLLCONFIG_INITDELAY_SHIFT 4
#define  MC_FTDLLCONFIG_INITDELAY_MASK_SHIFT(reg) (((reg) & MC_FTDLLCONFIG_INITDELAY_MASK) >> MC_FTDLLCONFIG_INITDELAY_SHIFT)
#define  MC_FTDLLCONFIG_INITDELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_FTDLLCONFIG_INITDELAY_MASK) | (((uint32_t)val) << MC_FTDLLCONFIG_INITDELAY_SHIFT))

#define  MC_FTDLLCONFIG_LOADINIT_MASK 0x8
#define  MC_FTDLLCONFIG_LOADINIT_SHIFT 3
#define  MC_FTDLLCONFIG_LOADINIT_MASK_SHIFT(reg) (((reg) & MC_FTDLLCONFIG_LOADINIT_MASK) >> MC_FTDLLCONFIG_LOADINIT_SHIFT)
#define  MC_FTDLLCONFIG_LOADINIT_REPLACE_VAL(reg,val) (((reg) & ~MC_FTDLLCONFIG_LOADINIT_MASK) | (((uint32_t)val) << MC_FTDLLCONFIG_LOADINIT_SHIFT))

#define  MC_FTDLLCONFIG_RESERVED1_MASK 0x6
#define  MC_FTDLLCONFIG_RESERVED1_SHIFT 1
#define  MC_FTDLLCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_FTDLLCONFIG_RESERVED1_MASK) >> MC_FTDLLCONFIG_RESERVED1_SHIFT)
#define  MC_FTDLLCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_FTDLLCONFIG_RESERVED1_MASK) | (((uint32_t)val) << MC_FTDLLCONFIG_RESERVED1_SHIFT))

#define  MC_FTDLLCONFIG_OVERRIDEPHD_MASK 0x1
#define  MC_FTDLLCONFIG_OVERRIDEPHD_SHIFT 0
#define  MC_FTDLLCONFIG_OVERRIDEPHD_MASK_SHIFT(reg) (((reg) & MC_FTDLLCONFIG_OVERRIDEPHD_MASK) >> MC_FTDLLCONFIG_OVERRIDEPHD_SHIFT)
#define  MC_FTDLLCONFIG_OVERRIDEPHD_REPLACE_VAL(reg,val) (((reg) & ~MC_FTDLLCONFIG_OVERRIDEPHD_MASK) | (((uint32_t)val) << MC_FTDLLCONFIG_OVERRIDEPHD_SHIFT))

//====================================================================
//Register: SDRAM Control Register I (SDRAMControl1)
/** \brief This register configures various SDRAM control features. It is
      applied to all chip selects.*/
//====================================================================

#define  MC_SDRAMCONTROL1_APSEN_MASK 0x80000000
#define  MC_SDRAMCONTROL1_APSEN_SHIFT 31
#define  MC_SDRAMCONTROL1_APSEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_APSEN_MASK) >> MC_SDRAMCONTROL1_APSEN_SHIFT)
#define  MC_SDRAMCONTROL1_APSEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_APSEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_APSEN_SHIFT))

#define  MC_SDRAMCONTROL1_APSTYPE_MASK 0x70000000
#define  MC_SDRAMCONTROL1_APSTYPE_SHIFT 28
#define  MC_SDRAMCONTROL1_APSTYPE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_APSTYPE_MASK) >> MC_SDRAMCONTROL1_APSTYPE_SHIFT)
#define  MC_SDRAMCONTROL1_APSTYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_APSTYPE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_APSTYPE_SHIFT))

#define  MC_SDRAMCONTROL1_APSVALUE_MASK 0xfff0000
#define  MC_SDRAMCONTROL1_APSVALUE_SHIFT 16
#define  MC_SDRAMCONTROL1_APSVALUE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_APSVALUE_MASK) >> MC_SDRAMCONTROL1_APSVALUE_SHIFT)
#define  MC_SDRAMCONTROL1_APSVALUE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_APSVALUE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_APSVALUE_SHIFT))

#define  MC_SDRAMCONTROL1_RESERVED1_MASK 0x8000
#define  MC_SDRAMCONTROL1_RESERVED1_SHIFT 15
#define  MC_SDRAMCONTROL1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_RESERVED1_MASK) >> MC_SDRAMCONTROL1_RESERVED1_SHIFT)
#define  MC_SDRAMCONTROL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_RESERVED1_SHIFT))

#define  MC_SDRAMCONTROL1_ACLKSTOPEXITDLY_MASK 0x7000
#define  MC_SDRAMCONTROL1_ACLKSTOPEXITDLY_SHIFT 12
#define  MC_SDRAMCONTROL1_ACLKSTOPEXITDLY_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_ACLKSTOPEXITDLY_MASK) >> MC_SDRAMCONTROL1_ACLKSTOPEXITDLY_SHIFT)
#define  MC_SDRAMCONTROL1_ACLKSTOPEXITDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_ACLKSTOPEXITDLY_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_ACLKSTOPEXITDLY_SHIFT))

#define  MC_SDRAMCONTROL1_RESERVED2_MASK 0xf00
#define  MC_SDRAMCONTROL1_RESERVED2_SHIFT 8
#define  MC_SDRAMCONTROL1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_RESERVED2_MASK) >> MC_SDRAMCONTROL1_RESERVED2_SHIFT)
#define  MC_SDRAMCONTROL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_RESERVED2_SHIFT))

#define  MC_SDRAMCONTROL1_ACLKSTOPEN_MASK 0x80
#define  MC_SDRAMCONTROL1_ACLKSTOPEN_SHIFT 7
#define  MC_SDRAMCONTROL1_ACLKSTOPEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_ACLKSTOPEN_MASK) >> MC_SDRAMCONTROL1_ACLKSTOPEN_SHIFT)
#define  MC_SDRAMCONTROL1_ACLKSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_ACLKSTOPEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_ACLKSTOPEN_SHIFT))

#define  MC_SDRAMCONTROL1_DLLRST_MASK 0x40
#define  MC_SDRAMCONTROL1_DLLRST_SHIFT 6
#define  MC_SDRAMCONTROL1_DLLRST_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_DLLRST_MASK) >> MC_SDRAMCONTROL1_DLLRST_SHIFT)
#define  MC_SDRAMCONTROL1_DLLRST_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_DLLRST_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_DLLRST_SHIFT))

#define  MC_SDRAMCONTROL1_RESERVED3_MASK 0x20
#define  MC_SDRAMCONTROL1_RESERVED3_SHIFT 5
#define  MC_SDRAMCONTROL1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_RESERVED3_MASK) >> MC_SDRAMCONTROL1_RESERVED3_SHIFT)
#define  MC_SDRAMCONTROL1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_RESERVED3_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_RESERVED3_SHIFT))

#define  MC_SDRAMCONTROL1_CASBT_MASK 0x10
#define  MC_SDRAMCONTROL1_CASBT_SHIFT 4
#define  MC_SDRAMCONTROL1_CASBT_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_CASBT_MASK) >> MC_SDRAMCONTROL1_CASBT_SHIFT)
#define  MC_SDRAMCONTROL1_CASBT_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_CASBT_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_CASBT_SHIFT))

#define  MC_SDRAMCONTROL1_OUTEN_MASK 0x8
#define  MC_SDRAMCONTROL1_OUTEN_SHIFT 3
#define  MC_SDRAMCONTROL1_OUTEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_OUTEN_MASK) >> MC_SDRAMCONTROL1_OUTEN_SHIFT)
#define  MC_SDRAMCONTROL1_OUTEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_OUTEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_OUTEN_SHIFT))

#define  MC_SDRAMCONTROL1_RESERVED4_MASK 0x4
#define  MC_SDRAMCONTROL1_RESERVED4_SHIFT 2
#define  MC_SDRAMCONTROL1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_RESERVED4_MASK) >> MC_SDRAMCONTROL1_RESERVED4_SHIFT)
#define  MC_SDRAMCONTROL1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_RESERVED4_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_RESERVED4_SHIFT))

#define  MC_SDRAMCONTROL1_TW2RDIS_MASK 0x2
#define  MC_SDRAMCONTROL1_TW2RDIS_SHIFT 1
#define  MC_SDRAMCONTROL1_TW2RDIS_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_TW2RDIS_MASK) >> MC_SDRAMCONTROL1_TW2RDIS_SHIFT)
#define  MC_SDRAMCONTROL1_TW2RDIS_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_TW2RDIS_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_TW2RDIS_SHIFT))

#define  MC_SDRAMCONTROL1_RESERVED5_MASK 0x1
#define  MC_SDRAMCONTROL1_RESERVED5_SHIFT 0
#define  MC_SDRAMCONTROL1_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL1_RESERVED5_MASK) >> MC_SDRAMCONTROL1_RESERVED5_SHIFT)
#define  MC_SDRAMCONTROL1_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL1_RESERVED5_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL1_RESERVED5_SHIFT))

//====================================================================
//Register: SDRAM Control Register II (SDRAMControl2)
/** \brief This register configures various SDRAM control features. It is
      applied to all chip selects.*/
//====================================================================

#define  MC_SDRAMCONTROL2_RESERVED1_MASK 0xf0000000
#define  MC_SDRAMCONTROL2_RESERVED1_SHIFT 28
#define  MC_SDRAMCONTROL2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_RESERVED1_MASK) >> MC_SDRAMCONTROL2_RESERVED1_SHIFT)
#define  MC_SDRAMCONTROL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_RESERVED1_SHIFT))

#define  MC_SDRAMCONTROL2_REFPOSTEDEN_MASK 0x8000000
#define  MC_SDRAMCONTROL2_REFPOSTEDEN_SHIFT 27
#define  MC_SDRAMCONTROL2_REFPOSTEDEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_REFPOSTEDEN_MASK) >> MC_SDRAMCONTROL2_REFPOSTEDEN_SHIFT)
#define  MC_SDRAMCONTROL2_REFPOSTEDEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_REFPOSTEDEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_REFPOSTEDEN_SHIFT))

#define  MC_SDRAMCONTROL2_REFPOSTEDMAX_MASK 0x7000000
#define  MC_SDRAMCONTROL2_REFPOSTEDMAX_SHIFT 24
#define  MC_SDRAMCONTROL2_REFPOSTEDMAX_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_REFPOSTEDMAX_MASK) >> MC_SDRAMCONTROL2_REFPOSTEDMAX_SHIFT)
#define  MC_SDRAMCONTROL2_REFPOSTEDMAX_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_REFPOSTEDMAX_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_REFPOSTEDMAX_SHIFT))

#define  MC_SDRAMCONTROL2_RESERVED2_MASK 0xc00000
#define  MC_SDRAMCONTROL2_RESERVED2_SHIFT 22
#define  MC_SDRAMCONTROL2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_RESERVED2_MASK) >> MC_SDRAMCONTROL2_RESERVED2_SHIFT)
#define  MC_SDRAMCONTROL2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_RESERVED2_SHIFT))

#define  MC_SDRAMCONTROL2_LINEBOUND_MASK 0x3f0000
#define  MC_SDRAMCONTROL2_LINEBOUND_SHIFT 16
#define  MC_SDRAMCONTROL2_LINEBOUND_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_LINEBOUND_MASK) >> MC_SDRAMCONTROL2_LINEBOUND_SHIFT)
#define  MC_SDRAMCONTROL2_LINEBOUND_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_LINEBOUND_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_LINEBOUND_SHIFT))

#define  MC_SDRAMCONTROL2_RESERVED3_MASK 0xfc00
#define  MC_SDRAMCONTROL2_RESERVED3_SHIFT 10
#define  MC_SDRAMCONTROL2_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_RESERVED3_MASK) >> MC_SDRAMCONTROL2_RESERVED3_SHIFT)
#define  MC_SDRAMCONTROL2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_RESERVED3_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_RESERVED3_SHIFT))

#define  MC_SDRAMCONTROL2_REFPBMODE_MASK 0x200
#define  MC_SDRAMCONTROL2_REFPBMODE_SHIFT 9
#define  MC_SDRAMCONTROL2_REFPBMODE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_REFPBMODE_MASK) >> MC_SDRAMCONTROL2_REFPBMODE_SHIFT)
#define  MC_SDRAMCONTROL2_REFPBMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_REFPBMODE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_REFPBMODE_SHIFT))

#define  MC_SDRAMCONTROL2_PDMODE_MASK 0x100
#define  MC_SDRAMCONTROL2_PDMODE_SHIFT 8
#define  MC_SDRAMCONTROL2_PDMODE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_PDMODE_MASK) >> MC_SDRAMCONTROL2_PDMODE_SHIFT)
#define  MC_SDRAMCONTROL2_PDMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_PDMODE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_PDMODE_SHIFT))

#define  MC_SDRAMCONTROL2_RESERVED4_MASK 0x80
#define  MC_SDRAMCONTROL2_RESERVED4_SHIFT 7
#define  MC_SDRAMCONTROL2_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_RESERVED4_MASK) >> MC_SDRAMCONTROL2_RESERVED4_SHIFT)
#define  MC_SDRAMCONTROL2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_RESERVED4_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_RESERVED4_SHIFT))

#define  MC_SDRAMCONTROL2_TWOTMODE_MASK 0x40
#define  MC_SDRAMCONTROL2_TWOTMODE_SHIFT 6
#define  MC_SDRAMCONTROL2_TWOTMODE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_TWOTMODE_MASK) >> MC_SDRAMCONTROL2_TWOTMODE_SHIFT)
#define  MC_SDRAMCONTROL2_TWOTMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_TWOTMODE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_TWOTMODE_SHIFT))

#define  MC_SDRAMCONTROL2_RDIMM_MASK 0x20
#define  MC_SDRAMCONTROL2_RDIMM_SHIFT 5
#define  MC_SDRAMCONTROL2_RDIMM_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_RDIMM_MASK) >> MC_SDRAMCONTROL2_RDIMM_SHIFT)
#define  MC_SDRAMCONTROL2_RDIMM_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_RDIMM_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_RDIMM_SHIFT))

#define  MC_SDRAMCONTROL2_AUTOPRE_MASK 0x10
#define  MC_SDRAMCONTROL2_AUTOPRE_SHIFT 4
#define  MC_SDRAMCONTROL2_AUTOPRE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_AUTOPRE_MASK) >> MC_SDRAMCONTROL2_AUTOPRE_SHIFT)
#define  MC_SDRAMCONTROL2_AUTOPRE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_AUTOPRE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_AUTOPRE_SHIFT))

#define  MC_SDRAMCONTROL2_RESERVED5_MASK 0x8
#define  MC_SDRAMCONTROL2_RESERVED5_SHIFT 3
#define  MC_SDRAMCONTROL2_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_RESERVED5_MASK) >> MC_SDRAMCONTROL2_RESERVED5_SHIFT)
#define  MC_SDRAMCONTROL2_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_RESERVED5_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_RESERVED5_SHIFT))

#define  MC_SDRAMCONTROL2_WRITELEVELMODE_MASK 0x4
#define  MC_SDRAMCONTROL2_WRITELEVELMODE_SHIFT 2
#define  MC_SDRAMCONTROL2_WRITELEVELMODE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_WRITELEVELMODE_MASK) >> MC_SDRAMCONTROL2_WRITELEVELMODE_SHIFT)
#define  MC_SDRAMCONTROL2_WRITELEVELMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_WRITELEVELMODE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_WRITELEVELMODE_SHIFT))

#define  MC_SDRAMCONTROL2_SHDWMODE_MASK 0x2
#define  MC_SDRAMCONTROL2_SHDWMODE_SHIFT 1
#define  MC_SDRAMCONTROL2_SHDWMODE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_SHDWMODE_MASK) >> MC_SDRAMCONTROL2_SHDWMODE_SHIFT)
#define  MC_SDRAMCONTROL2_SHDWMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_SHDWMODE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_SHDWMODE_SHIFT))

#define  MC_SDRAMCONTROL2_TESTMODE_MASK 0x1
#define  MC_SDRAMCONTROL2_TESTMODE_SHIFT 0
#define  MC_SDRAMCONTROL2_TESTMODE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL2_TESTMODE_MASK) >> MC_SDRAMCONTROL2_TESTMODE_SHIFT)
#define  MC_SDRAMCONTROL2_TESTMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL2_TESTMODE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL2_TESTMODE_SHIFT))

//====================================================================
//Register: SDRAM Control Register III (SDRAMControl3)
/** \brief This register configures data transfer speed. Only users familar
      with the data transfer process should attempt to program bits 11 - 0.
      Refer to the MC datasheet for further details.*/
//====================================================================

#define  MC_SDRAMCONTROL3_DCEARLYCMDEN_MASK 0x80000000
#define  MC_SDRAMCONTROL3_DCEARLYCMDEN_SHIFT 31
#define  MC_SDRAMCONTROL3_DCEARLYCMDEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_DCEARLYCMDEN_MASK) >> MC_SDRAMCONTROL3_DCEARLYCMDEN_SHIFT)
#define  MC_SDRAMCONTROL3_DCEARLYCMDEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_DCEARLYCMDEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_DCEARLYCMDEN_SHIFT))

#define  MC_SDRAMCONTROL3_DCMCFLOPREQEN_MASK 0x40000000
#define  MC_SDRAMCONTROL3_DCMCFLOPREQEN_SHIFT 30
#define  MC_SDRAMCONTROL3_DCMCFLOPREQEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_DCMCFLOPREQEN_MASK) >> MC_SDRAMCONTROL3_DCMCFLOPREQEN_SHIFT)
#define  MC_SDRAMCONTROL3_DCMCFLOPREQEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_DCMCFLOPREQEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_DCMCFLOPREQEN_SHIFT))

#define  MC_SDRAMCONTROL3_MCFLOPGNTEN_MASK 0x20000000
#define  MC_SDRAMCONTROL3_MCFLOPGNTEN_SHIFT 29
#define  MC_SDRAMCONTROL3_MCFLOPGNTEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_MCFLOPGNTEN_MASK) >> MC_SDRAMCONTROL3_MCFLOPGNTEN_SHIFT)
#define  MC_SDRAMCONTROL3_MCFLOPGNTEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_MCFLOPGNTEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_MCFLOPGNTEN_SHIFT))

#define  MC_SDRAMCONTROL3_RESERVED1_MASK 0x1ff00000
#define  MC_SDRAMCONTROL3_RESERVED1_SHIFT 20
#define  MC_SDRAMCONTROL3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_RESERVED1_MASK) >> MC_SDRAMCONTROL3_RESERVED1_SHIFT)
#define  MC_SDRAMCONTROL3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_RESERVED1_SHIFT))

#define  MC_SDRAMCONTROL3_MSTR3_EARLY_WRITE_EN_MASK 0x80000
#define  MC_SDRAMCONTROL3_MSTR3_EARLY_WRITE_EN_SHIFT 19
#define  MC_SDRAMCONTROL3_MSTR3_EARLY_WRITE_EN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_MSTR3_EARLY_WRITE_EN_MASK) >> MC_SDRAMCONTROL3_MSTR3_EARLY_WRITE_EN_SHIFT)
#define  MC_SDRAMCONTROL3_MSTR3_EARLY_WRITE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_MSTR3_EARLY_WRITE_EN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_MSTR3_EARLY_WRITE_EN_SHIFT))

#define  MC_SDRAMCONTROL3_MSTR2_EARLY_WRITE_EN_MASK 0x40000
#define  MC_SDRAMCONTROL3_MSTR2_EARLY_WRITE_EN_SHIFT 18
#define  MC_SDRAMCONTROL3_MSTR2_EARLY_WRITE_EN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_MSTR2_EARLY_WRITE_EN_MASK) >> MC_SDRAMCONTROL3_MSTR2_EARLY_WRITE_EN_SHIFT)
#define  MC_SDRAMCONTROL3_MSTR2_EARLY_WRITE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_MSTR2_EARLY_WRITE_EN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_MSTR2_EARLY_WRITE_EN_SHIFT))

#define  MC_SDRAMCONTROL3_MSTR3_FAST_WRITE_EN_MASK 0x20000
#define  MC_SDRAMCONTROL3_MSTR3_FAST_WRITE_EN_SHIFT 17
#define  MC_SDRAMCONTROL3_MSTR3_FAST_WRITE_EN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_MSTR3_FAST_WRITE_EN_MASK) >> MC_SDRAMCONTROL3_MSTR3_FAST_WRITE_EN_SHIFT)
#define  MC_SDRAMCONTROL3_MSTR3_FAST_WRITE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_MSTR3_FAST_WRITE_EN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_MSTR3_FAST_WRITE_EN_SHIFT))

#define  MC_SDRAMCONTROL3_MSTR2_FAST_WRITE_EN_MASK 0x10000
#define  MC_SDRAMCONTROL3_MSTR2_FAST_WRITE_EN_SHIFT 16
#define  MC_SDRAMCONTROL3_MSTR2_FAST_WRITE_EN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_MSTR2_FAST_WRITE_EN_MASK) >> MC_SDRAMCONTROL3_MSTR2_FAST_WRITE_EN_SHIFT)
#define  MC_SDRAMCONTROL3_MSTR2_FAST_WRITE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_MSTR2_FAST_WRITE_EN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_MSTR2_FAST_WRITE_EN_SHIFT))

#define  MC_SDRAMCONTROL3_RESERVED2_MASK 0xf000
#define  MC_SDRAMCONTROL3_RESERVED2_SHIFT 12
#define  MC_SDRAMCONTROL3_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_RESERVED2_MASK) >> MC_SDRAMCONTROL3_RESERVED2_SHIFT)
#define  MC_SDRAMCONTROL3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_RESERVED2_SHIFT))

#define  MC_SDRAMCONTROL3_SBEARLYWRITEUSERVALUE_MASK 0xe00
#define  MC_SDRAMCONTROL3_SBEARLYWRITEUSERVALUE_SHIFT 9
#define  MC_SDRAMCONTROL3_SBEARLYWRITEUSERVALUE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_SBEARLYWRITEUSERVALUE_MASK) >> MC_SDRAMCONTROL3_SBEARLYWRITEUSERVALUE_SHIFT)
#define  MC_SDRAMCONTROL3_SBEARLYWRITEUSERVALUE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_SBEARLYWRITEUSERVALUE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_SBEARLYWRITEUSERVALUE_SHIFT))

#define  MC_SDRAMCONTROL3_CPUEARLYWRITEUSERVALUE_MASK 0x1c0
#define  MC_SDRAMCONTROL3_CPUEARLYWRITEUSERVALUE_SHIFT 6
#define  MC_SDRAMCONTROL3_CPUEARLYWRITEUSERVALUE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_CPUEARLYWRITEUSERVALUE_MASK) >> MC_SDRAMCONTROL3_CPUEARLYWRITEUSERVALUE_SHIFT)
#define  MC_SDRAMCONTROL3_CPUEARLYWRITEUSERVALUE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_CPUEARLYWRITEUSERVALUE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_CPUEARLYWRITEUSERVALUE_SHIFT))

#define  MC_SDRAMCONTROL3_SBEARLYWRITEUSER_MASK 0x20
#define  MC_SDRAMCONTROL3_SBEARLYWRITEUSER_SHIFT 5
#define  MC_SDRAMCONTROL3_SBEARLYWRITEUSER_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_SBEARLYWRITEUSER_MASK) >> MC_SDRAMCONTROL3_SBEARLYWRITEUSER_SHIFT)
#define  MC_SDRAMCONTROL3_SBEARLYWRITEUSER_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_SBEARLYWRITEUSER_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_SBEARLYWRITEUSER_SHIFT))

#define  MC_SDRAMCONTROL3_CPUEARLYWRITEUSER_MASK 0x10
#define  MC_SDRAMCONTROL3_CPUEARLYWRITEUSER_SHIFT 4
#define  MC_SDRAMCONTROL3_CPUEARLYWRITEUSER_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_CPUEARLYWRITEUSER_MASK) >> MC_SDRAMCONTROL3_CPUEARLYWRITEUSER_SHIFT)
#define  MC_SDRAMCONTROL3_CPUEARLYWRITEUSER_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_CPUEARLYWRITEUSER_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_CPUEARLYWRITEUSER_SHIFT))

#define  MC_SDRAMCONTROL3_SBEARLYWRITEEN_MASK 0x8
#define  MC_SDRAMCONTROL3_SBEARLYWRITEEN_SHIFT 3
#define  MC_SDRAMCONTROL3_SBEARLYWRITEEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_SBEARLYWRITEEN_MASK) >> MC_SDRAMCONTROL3_SBEARLYWRITEEN_SHIFT)
#define  MC_SDRAMCONTROL3_SBEARLYWRITEEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_SBEARLYWRITEEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_SBEARLYWRITEEN_SHIFT))

#define  MC_SDRAMCONTROL3_CPUEARLYWRITEEN_MASK 0x4
#define  MC_SDRAMCONTROL3_CPUEARLYWRITEEN_SHIFT 2
#define  MC_SDRAMCONTROL3_CPUEARLYWRITEEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_CPUEARLYWRITEEN_MASK) >> MC_SDRAMCONTROL3_CPUEARLYWRITEEN_SHIFT)
#define  MC_SDRAMCONTROL3_CPUEARLYWRITEEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_CPUEARLYWRITEEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_CPUEARLYWRITEEN_SHIFT))

#define  MC_SDRAMCONTROL3_SBFASTWRITEEN_MASK 0x2
#define  MC_SDRAMCONTROL3_SBFASTWRITEEN_SHIFT 1
#define  MC_SDRAMCONTROL3_SBFASTWRITEEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_SBFASTWRITEEN_MASK) >> MC_SDRAMCONTROL3_SBFASTWRITEEN_SHIFT)
#define  MC_SDRAMCONTROL3_SBFASTWRITEEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_SBFASTWRITEEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_SBFASTWRITEEN_SHIFT))

#define  MC_SDRAMCONTROL3_CPUFASTWRITEEN_MASK 0x1
#define  MC_SDRAMCONTROL3_CPUFASTWRITEEN_SHIFT 0
#define  MC_SDRAMCONTROL3_CPUFASTWRITEEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL3_CPUFASTWRITEEN_MASK) >> MC_SDRAMCONTROL3_CPUFASTWRITEEN_SHIFT)
#define  MC_SDRAMCONTROL3_CPUFASTWRITEEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL3_CPUFASTWRITEEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL3_CPUFASTWRITEEN_SHIFT))

//====================================================================
//Register: SDRAM Control Register IV (SDRAMControl4)
/** \brief This register configures SDRAM control features. Values are applied
      to all chip selects.*/
//====================================================================

#define  MC_SDRAMCONTROL4_DLLEN_MASK 0x80000000
#define  MC_SDRAMCONTROL4_DLLEN_SHIFT 31
#define  MC_SDRAMCONTROL4_DLLEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_DLLEN_MASK) >> MC_SDRAMCONTROL4_DLLEN_SHIFT)
#define  MC_SDRAMCONTROL4_DLLEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_DLLEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_DLLEN_SHIFT))

#define  MC_SDRAMCONTROL4_DQSBEN_MASK 0x40000000
#define  MC_SDRAMCONTROL4_DQSBEN_SHIFT 30
#define  MC_SDRAMCONTROL4_DQSBEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_DQSBEN_MASK) >> MC_SDRAMCONTROL4_DQSBEN_SHIFT)
#define  MC_SDRAMCONTROL4_DQSBEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_DQSBEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_DQSBEN_SHIFT))

#define  MC_SDRAMCONTROL4_FASTBANK_MASK 0x20000000
#define  MC_SDRAMCONTROL4_FASTBANK_SHIFT 29
#define  MC_SDRAMCONTROL4_FASTBANK_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_FASTBANK_MASK) >> MC_SDRAMCONTROL4_FASTBANK_SHIFT)
#define  MC_SDRAMCONTROL4_FASTBANK_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_FASTBANK_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_FASTBANK_SHIFT))

#define  MC_SDRAMCONTROL4_RESERVED1_MASK 0x1e000000
#define  MC_SDRAMCONTROL4_RESERVED1_SHIFT 25
#define  MC_SDRAMCONTROL4_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_RESERVED1_MASK) >> MC_SDRAMCONTROL4_RESERVED1_SHIFT)
#define  MC_SDRAMCONTROL4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_RESERVED1_SHIFT))

#define  MC_SDRAMCONTROL4_BURSTLENGTH_MASK 0x1c00000
#define  MC_SDRAMCONTROL4_BURSTLENGTH_SHIFT 22
#define  MC_SDRAMCONTROL4_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_BURSTLENGTH_MASK) >> MC_SDRAMCONTROL4_BURSTLENGTH_SHIFT)
#define  MC_SDRAMCONTROL4_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_BURSTLENGTH_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_BURSTLENGTH_SHIFT))

#define  MC_SDRAMCONTROL4_ALAT_MASK 0x380000
#define  MC_SDRAMCONTROL4_ALAT_SHIFT 19
#define  MC_SDRAMCONTROL4_ALAT_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_ALAT_MASK) >> MC_SDRAMCONTROL4_ALAT_SHIFT)
#define  MC_SDRAMCONTROL4_ALAT_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_ALAT_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_ALAT_SHIFT))

#define  MC_SDRAMCONTROL4_ALATEN_MASK 0x40000
#define  MC_SDRAMCONTROL4_ALATEN_SHIFT 18
#define  MC_SDRAMCONTROL4_ALATEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_ALATEN_MASK) >> MC_SDRAMCONTROL4_ALATEN_SHIFT)
#define  MC_SDRAMCONTROL4_ALATEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_ALATEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_ALATEN_SHIFT))

#define  MC_SDRAMCONTROL4_RDQSEN_MASK 0x20000
#define  MC_SDRAMCONTROL4_RDQSEN_SHIFT 17
#define  MC_SDRAMCONTROL4_RDQSEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_RDQSEN_MASK) >> MC_SDRAMCONTROL4_RDQSEN_SHIFT)
#define  MC_SDRAMCONTROL4_RDQSEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_RDQSEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_RDQSEN_SHIFT))

#define  MC_SDRAMCONTROL4_CASLAT_MASK 0x1c000
#define  MC_SDRAMCONTROL4_CASLAT_SHIFT 14
#define  MC_SDRAMCONTROL4_CASLAT_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_CASLAT_MASK) >> MC_SDRAMCONTROL4_CASLAT_SHIFT)
#define  MC_SDRAMCONTROL4_CASLAT_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_CASLAT_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_CASLAT_SHIFT))

#define  MC_SDRAMCONTROL4_CASLOWERLAT_MASK 0x2000
#define  MC_SDRAMCONTROL4_CASLOWERLAT_SHIFT 13
#define  MC_SDRAMCONTROL4_CASLOWERLAT_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_CASLOWERLAT_MASK) >> MC_SDRAMCONTROL4_CASLOWERLAT_SHIFT)
#define  MC_SDRAMCONTROL4_CASLOWERLAT_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_CASLOWERLAT_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_CASLOWERLAT_SHIFT))

#define  MC_SDRAMCONTROL4_CASWL_MASK 0x1c00
#define  MC_SDRAMCONTROL4_CASWL_SHIFT 10
#define  MC_SDRAMCONTROL4_CASWL_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_CASWL_MASK) >> MC_SDRAMCONTROL4_CASWL_SHIFT)
#define  MC_SDRAMCONTROL4_CASWL_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_CASWL_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_CASWL_SHIFT))

#define  MC_SDRAMCONTROL4_DATAWIDTHX8_MASK 0x200
#define  MC_SDRAMCONTROL4_DATAWIDTHX8_SHIFT 9
#define  MC_SDRAMCONTROL4_DATAWIDTHX8_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_DATAWIDTHX8_MASK) >> MC_SDRAMCONTROL4_DATAWIDTHX8_SHIFT)
#define  MC_SDRAMCONTROL4_DATAWIDTHX8_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_DATAWIDTHX8_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_DATAWIDTHX8_SHIFT))

#define  MC_SDRAMCONTROL4_S4TYPE_MASK 0x100
#define  MC_SDRAMCONTROL4_S4TYPE_SHIFT 8
#define  MC_SDRAMCONTROL4_S4TYPE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_S4TYPE_MASK) >> MC_SDRAMCONTROL4_S4TYPE_SHIFT)
#define  MC_SDRAMCONTROL4_S4TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_S4TYPE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_S4TYPE_SHIFT))

#define  MC_SDRAMCONTROL4_ASR_MASK 0x80
#define  MC_SDRAMCONTROL4_ASR_SHIFT 7
#define  MC_SDRAMCONTROL4_ASR_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_ASR_MASK) >> MC_SDRAMCONTROL4_ASR_SHIFT)
#define  MC_SDRAMCONTROL4_ASR_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_ASR_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_ASR_SHIFT))

#define  MC_SDRAMCONTROL4_SRT_MASK 0x40
#define  MC_SDRAMCONTROL4_SRT_SHIFT 6
#define  MC_SDRAMCONTROL4_SRT_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_SRT_MASK) >> MC_SDRAMCONTROL4_SRT_SHIFT)
#define  MC_SDRAMCONTROL4_SRT_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_SRT_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_SRT_SHIFT))

#define  MC_SDRAMCONTROL4_MPR_MASK 0x20
#define  MC_SDRAMCONTROL4_MPR_SHIFT 5
#define  MC_SDRAMCONTROL4_MPR_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_MPR_MASK) >> MC_SDRAMCONTROL4_MPR_SHIFT)
#define  MC_SDRAMCONTROL4_MPR_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_MPR_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_MPR_SHIFT))

#define  MC_SDRAMCONTROL4_SDRAMTYPE_MASK 0x1c
#define  MC_SDRAMCONTROL4_SDRAMTYPE_SHIFT 2
#define  MC_SDRAMCONTROL4_SDRAMTYPE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_SDRAMTYPE_MASK) >> MC_SDRAMCONTROL4_SDRAMTYPE_SHIFT)
#define  MC_SDRAMCONTROL4_SDRAMTYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_SDRAMTYPE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_SDRAMTYPE_SHIFT))

#define  MC_SDRAMCONTROL4_DATAWIDTH_MASK 0x3
#define  MC_SDRAMCONTROL4_DATAWIDTH_SHIFT 0
#define  MC_SDRAMCONTROL4_DATAWIDTH_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL4_DATAWIDTH_MASK) >> MC_SDRAMCONTROL4_DATAWIDTH_SHIFT)
#define  MC_SDRAMCONTROL4_DATAWIDTH_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL4_DATAWIDTH_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL4_DATAWIDTH_SHIFT))

//====================================================================
//Register: SDRAM Control Register V (SDRAMControl5)
/** \brief This register configures arbitration weights for arbitration between
      the four master input.*/
//====================================================================

#define  MC_SDRAMCONTROL5_RESERVED1_MASK 0xf0000000
#define  MC_SDRAMCONTROL5_RESERVED1_SHIFT 28
#define  MC_SDRAMCONTROL5_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL5_RESERVED1_MASK) >> MC_SDRAMCONTROL5_RESERVED1_SHIFT)
#define  MC_SDRAMCONTROL5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL5_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL5_RESERVED1_SHIFT))

#define  MC_SDRAMCONTROL5_MSTRWT3_MASK 0xf000000
#define  MC_SDRAMCONTROL5_MSTRWT3_SHIFT 24
#define  MC_SDRAMCONTROL5_MSTRWT3_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL5_MSTRWT3_MASK) >> MC_SDRAMCONTROL5_MSTRWT3_SHIFT)
#define  MC_SDRAMCONTROL5_MSTRWT3_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL5_MSTRWT3_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL5_MSTRWT3_SHIFT))

#define  MC_SDRAMCONTROL5_RESERVED2_MASK 0xf00000
#define  MC_SDRAMCONTROL5_RESERVED2_SHIFT 20
#define  MC_SDRAMCONTROL5_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL5_RESERVED2_MASK) >> MC_SDRAMCONTROL5_RESERVED2_SHIFT)
#define  MC_SDRAMCONTROL5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL5_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL5_RESERVED2_SHIFT))

#define  MC_SDRAMCONTROL5_MSTRWT2_MASK 0xf0000
#define  MC_SDRAMCONTROL5_MSTRWT2_SHIFT 16
#define  MC_SDRAMCONTROL5_MSTRWT2_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL5_MSTRWT2_MASK) >> MC_SDRAMCONTROL5_MSTRWT2_SHIFT)
#define  MC_SDRAMCONTROL5_MSTRWT2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL5_MSTRWT2_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL5_MSTRWT2_SHIFT))

#define  MC_SDRAMCONTROL5_RESERVED3_MASK 0xf000
#define  MC_SDRAMCONTROL5_RESERVED3_SHIFT 12
#define  MC_SDRAMCONTROL5_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL5_RESERVED3_MASK) >> MC_SDRAMCONTROL5_RESERVED3_SHIFT)
#define  MC_SDRAMCONTROL5_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL5_RESERVED3_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL5_RESERVED3_SHIFT))

#define  MC_SDRAMCONTROL5_MSTRWT1_MASK 0xf00
#define  MC_SDRAMCONTROL5_MSTRWT1_SHIFT 8
#define  MC_SDRAMCONTROL5_MSTRWT1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL5_MSTRWT1_MASK) >> MC_SDRAMCONTROL5_MSTRWT1_SHIFT)
#define  MC_SDRAMCONTROL5_MSTRWT1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL5_MSTRWT1_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL5_MSTRWT1_SHIFT))

#define  MC_SDRAMCONTROL5_RESERVED4_MASK 0xf0
#define  MC_SDRAMCONTROL5_RESERVED4_SHIFT 4
#define  MC_SDRAMCONTROL5_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL5_RESERVED4_MASK) >> MC_SDRAMCONTROL5_RESERVED4_SHIFT)
#define  MC_SDRAMCONTROL5_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL5_RESERVED4_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL5_RESERVED4_SHIFT))

#define  MC_SDRAMCONTROL5_MSTRWT0_MASK 0xf
#define  MC_SDRAMCONTROL5_MSTRWT0_SHIFT 0
#define  MC_SDRAMCONTROL5_MSTRWT0_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL5_MSTRWT0_MASK) >> MC_SDRAMCONTROL5_MSTRWT0_SHIFT)
#define  MC_SDRAMCONTROL5_MSTRWT0_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL5_MSTRWT0_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL5_MSTRWT0_SHIFT))

//====================================================================
//Register: SDRAM Control VI (SDRAMControl6)
/** \brief PHY control register 6.*/
//====================================================================

#define  MC_SDRAMCONTROL6_ODT3READEN_MASK 0xf0000000
#define  MC_SDRAMCONTROL6_ODT3READEN_SHIFT 28
#define  MC_SDRAMCONTROL6_ODT3READEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL6_ODT3READEN_MASK) >> MC_SDRAMCONTROL6_ODT3READEN_SHIFT)
#define  MC_SDRAMCONTROL6_ODT3READEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL6_ODT3READEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL6_ODT3READEN_SHIFT))

#define  MC_SDRAMCONTROL6_ODT3WRITEEN_MASK 0xf000000
#define  MC_SDRAMCONTROL6_ODT3WRITEEN_SHIFT 24
#define  MC_SDRAMCONTROL6_ODT3WRITEEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL6_ODT3WRITEEN_MASK) >> MC_SDRAMCONTROL6_ODT3WRITEEN_SHIFT)
#define  MC_SDRAMCONTROL6_ODT3WRITEEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL6_ODT3WRITEEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL6_ODT3WRITEEN_SHIFT))

#define  MC_SDRAMCONTROL6_ODT2READEN_MASK 0xf00000
#define  MC_SDRAMCONTROL6_ODT2READEN_SHIFT 20
#define  MC_SDRAMCONTROL6_ODT2READEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL6_ODT2READEN_MASK) >> MC_SDRAMCONTROL6_ODT2READEN_SHIFT)
#define  MC_SDRAMCONTROL6_ODT2READEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL6_ODT2READEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL6_ODT2READEN_SHIFT))

#define  MC_SDRAMCONTROL6_ODT2WRITEEN_MASK 0xf0000
#define  MC_SDRAMCONTROL6_ODT2WRITEEN_SHIFT 16
#define  MC_SDRAMCONTROL6_ODT2WRITEEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL6_ODT2WRITEEN_MASK) >> MC_SDRAMCONTROL6_ODT2WRITEEN_SHIFT)
#define  MC_SDRAMCONTROL6_ODT2WRITEEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL6_ODT2WRITEEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL6_ODT2WRITEEN_SHIFT))

#define  MC_SDRAMCONTROL6_ODT1READEN_MASK 0xf000
#define  MC_SDRAMCONTROL6_ODT1READEN_SHIFT 12
#define  MC_SDRAMCONTROL6_ODT1READEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL6_ODT1READEN_MASK) >> MC_SDRAMCONTROL6_ODT1READEN_SHIFT)
#define  MC_SDRAMCONTROL6_ODT1READEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL6_ODT1READEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL6_ODT1READEN_SHIFT))

#define  MC_SDRAMCONTROL6_ODT1WRITEEN_MASK 0xf00
#define  MC_SDRAMCONTROL6_ODT1WRITEEN_SHIFT 8
#define  MC_SDRAMCONTROL6_ODT1WRITEEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL6_ODT1WRITEEN_MASK) >> MC_SDRAMCONTROL6_ODT1WRITEEN_SHIFT)
#define  MC_SDRAMCONTROL6_ODT1WRITEEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL6_ODT1WRITEEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL6_ODT1WRITEEN_SHIFT))

#define  MC_SDRAMCONTROL6_ODT0READEN_MASK 0xf0
#define  MC_SDRAMCONTROL6_ODT0READEN_SHIFT 4
#define  MC_SDRAMCONTROL6_ODT0READEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL6_ODT0READEN_MASK) >> MC_SDRAMCONTROL6_ODT0READEN_SHIFT)
#define  MC_SDRAMCONTROL6_ODT0READEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL6_ODT0READEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL6_ODT0READEN_SHIFT))

#define  MC_SDRAMCONTROL6_ODT0WRITEEN_MASK 0xf
#define  MC_SDRAMCONTROL6_ODT0WRITEEN_SHIFT 0
#define  MC_SDRAMCONTROL6_ODT0WRITEEN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL6_ODT0WRITEEN_MASK) >> MC_SDRAMCONTROL6_ODT0WRITEEN_SHIFT)
#define  MC_SDRAMCONTROL6_ODT0WRITEEN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL6_ODT0WRITEEN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL6_ODT0WRITEEN_SHIFT))

//====================================================================
//Register: SDRAM Control VII (SDRAMControl7)
/** \brief PHY control register 7.*/
//====================================================================

#define  MC_SDRAMCONTROL7_RESERVED1_MASK 0xfc000000
#define  MC_SDRAMCONTROL7_RESERVED1_SHIFT 26
#define  MC_SDRAMCONTROL7_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL7_RESERVED1_MASK) >> MC_SDRAMCONTROL7_RESERVED1_SHIFT)
#define  MC_SDRAMCONTROL7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL7_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL7_RESERVED1_SHIFT))

#define  MC_SDRAMCONTROL7_PADTERMSWITCHMODE_MASK 0x3000000
#define  MC_SDRAMCONTROL7_PADTERMSWITCHMODE_SHIFT 24
#define  MC_SDRAMCONTROL7_PADTERMSWITCHMODE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL7_PADTERMSWITCHMODE_MASK) >> MC_SDRAMCONTROL7_PADTERMSWITCHMODE_SHIFT)
#define  MC_SDRAMCONTROL7_PADTERMSWITCHMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL7_PADTERMSWITCHMODE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL7_PADTERMSWITCHMODE_SHIFT))

#define  MC_SDRAMCONTROL7_RESERVED2_MASK 0xfe0000
#define  MC_SDRAMCONTROL7_RESERVED2_SHIFT 17
#define  MC_SDRAMCONTROL7_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL7_RESERVED2_MASK) >> MC_SDRAMCONTROL7_RESERVED2_SHIFT)
#define  MC_SDRAMCONTROL7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL7_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL7_RESERVED2_SHIFT))

#define  MC_SDRAMCONTROL7_DDR3_ODT_EARLY_DIS_MASK 0x10000
#define  MC_SDRAMCONTROL7_DDR3_ODT_EARLY_DIS_SHIFT 16
#define  MC_SDRAMCONTROL7_DDR3_ODT_EARLY_DIS_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL7_DDR3_ODT_EARLY_DIS_MASK) >> MC_SDRAMCONTROL7_DDR3_ODT_EARLY_DIS_SHIFT)
#define  MC_SDRAMCONTROL7_DDR3_ODT_EARLY_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL7_DDR3_ODT_EARLY_DIS_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL7_DDR3_ODT_EARLY_DIS_SHIFT))

#define  MC_SDRAMCONTROL7_RESERVED3_MASK 0xff00
#define  MC_SDRAMCONTROL7_RESERVED3_SHIFT 8
#define  MC_SDRAMCONTROL7_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL7_RESERVED3_MASK) >> MC_SDRAMCONTROL7_RESERVED3_SHIFT)
#define  MC_SDRAMCONTROL7_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL7_RESERVED3_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL7_RESERVED3_SHIFT))

#define  MC_SDRAMCONTROL7_ODT3SWITCHMODE_MASK 0xc0
#define  MC_SDRAMCONTROL7_ODT3SWITCHMODE_SHIFT 6
#define  MC_SDRAMCONTROL7_ODT3SWITCHMODE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL7_ODT3SWITCHMODE_MASK) >> MC_SDRAMCONTROL7_ODT3SWITCHMODE_SHIFT)
#define  MC_SDRAMCONTROL7_ODT3SWITCHMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL7_ODT3SWITCHMODE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL7_ODT3SWITCHMODE_SHIFT))

#define  MC_SDRAMCONTROL7_ODT2SWITCHMODE_MASK 0x30
#define  MC_SDRAMCONTROL7_ODT2SWITCHMODE_SHIFT 4
#define  MC_SDRAMCONTROL7_ODT2SWITCHMODE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL7_ODT2SWITCHMODE_MASK) >> MC_SDRAMCONTROL7_ODT2SWITCHMODE_SHIFT)
#define  MC_SDRAMCONTROL7_ODT2SWITCHMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL7_ODT2SWITCHMODE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL7_ODT2SWITCHMODE_SHIFT))

#define  MC_SDRAMCONTROL7_ODT1SWITCHMODE_MASK 0xc
#define  MC_SDRAMCONTROL7_ODT1SWITCHMODE_SHIFT 2
#define  MC_SDRAMCONTROL7_ODT1SWITCHMODE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL7_ODT1SWITCHMODE_MASK) >> MC_SDRAMCONTROL7_ODT1SWITCHMODE_SHIFT)
#define  MC_SDRAMCONTROL7_ODT1SWITCHMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL7_ODT1SWITCHMODE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL7_ODT1SWITCHMODE_SHIFT))

#define  MC_SDRAMCONTROL7_ODT0SWITCHMODE_MASK 0x3
#define  MC_SDRAMCONTROL7_ODT0SWITCHMODE_SHIFT 0
#define  MC_SDRAMCONTROL7_ODT0SWITCHMODE_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL7_ODT0SWITCHMODE_MASK) >> MC_SDRAMCONTROL7_ODT0SWITCHMODE_SHIFT)
#define  MC_SDRAMCONTROL7_ODT0SWITCHMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL7_ODT0SWITCHMODE_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL7_ODT0SWITCHMODE_SHIFT))

//====================================================================
//Register: SDRAM Control Register 13 (SDRAMControl13)
/** \brief SDRAM control register 13.*/
//====================================================================

#define  MC_SDRAMCONTROL13_RESERVED1_MASK 0xfffff800
#define  MC_SDRAMCONTROL13_RESERVED1_SHIFT 11
#define  MC_SDRAMCONTROL13_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL13_RESERVED1_MASK) >> MC_SDRAMCONTROL13_RESERVED1_SHIFT)
#define  MC_SDRAMCONTROL13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL13_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL13_RESERVED1_SHIFT))

#define  MC_SDRAMCONTROL13_MSTR_LOCK_BYP_NUM_MASK 0x600
#define  MC_SDRAMCONTROL13_MSTR_LOCK_BYP_NUM_SHIFT 9
#define  MC_SDRAMCONTROL13_MSTR_LOCK_BYP_NUM_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL13_MSTR_LOCK_BYP_NUM_MASK) >> MC_SDRAMCONTROL13_MSTR_LOCK_BYP_NUM_SHIFT)
#define  MC_SDRAMCONTROL13_MSTR_LOCK_BYP_NUM_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL13_MSTR_LOCK_BYP_NUM_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL13_MSTR_LOCK_BYP_NUM_SHIFT))

#define  MC_SDRAMCONTROL13_MSTR_LOCK_BYP_EN_MASK 0x100
#define  MC_SDRAMCONTROL13_MSTR_LOCK_BYP_EN_SHIFT 8
#define  MC_SDRAMCONTROL13_MSTR_LOCK_BYP_EN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL13_MSTR_LOCK_BYP_EN_MASK) >> MC_SDRAMCONTROL13_MSTR_LOCK_BYP_EN_SHIFT)
#define  MC_SDRAMCONTROL13_MSTR_LOCK_BYP_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL13_MSTR_LOCK_BYP_EN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL13_MSTR_LOCK_BYP_EN_SHIFT))

#define  MC_SDRAMCONTROL13_RESERVED2_MASK 0xc0
#define  MC_SDRAMCONTROL13_RESERVED2_SHIFT 6
#define  MC_SDRAMCONTROL13_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL13_RESERVED2_MASK) >> MC_SDRAMCONTROL13_RESERVED2_SHIFT)
#define  MC_SDRAMCONTROL13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL13_RESERVED2_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL13_RESERVED2_SHIFT))

#define  MC_SDRAMCONTROL13_SRX_AUTO_ZQCL_DIS_MASK 0x20
#define  MC_SDRAMCONTROL13_SRX_AUTO_ZQCL_DIS_SHIFT 5
#define  MC_SDRAMCONTROL13_SRX_AUTO_ZQCL_DIS_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL13_SRX_AUTO_ZQCL_DIS_MASK) >> MC_SDRAMCONTROL13_SRX_AUTO_ZQCL_DIS_SHIFT)
#define  MC_SDRAMCONTROL13_SRX_AUTO_ZQCL_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL13_SRX_AUTO_ZQCL_DIS_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL13_SRX_AUTO_ZQCL_DIS_SHIFT))

#define  MC_SDRAMCONTROL13_MC_SLOW_QUEUE_ONLY_MASK 0x10
#define  MC_SDRAMCONTROL13_MC_SLOW_QUEUE_ONLY_SHIFT 4
#define  MC_SDRAMCONTROL13_MC_SLOW_QUEUE_ONLY_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL13_MC_SLOW_QUEUE_ONLY_MASK) >> MC_SDRAMCONTROL13_MC_SLOW_QUEUE_ONLY_SHIFT)
#define  MC_SDRAMCONTROL13_MC_SLOW_QUEUE_ONLY_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL13_MC_SLOW_QUEUE_ONLY_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL13_MC_SLOW_QUEUE_ONLY_SHIFT))

#define  MC_SDRAMCONTROL13_MSTR_WRAP_EN_MASK 0xf
#define  MC_SDRAMCONTROL13_MSTR_WRAP_EN_SHIFT 0
#define  MC_SDRAMCONTROL13_MSTR_WRAP_EN_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL13_MSTR_WRAP_EN_MASK) >> MC_SDRAMCONTROL13_MSTR_WRAP_EN_SHIFT)
#define  MC_SDRAMCONTROL13_MSTR_WRAP_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL13_MSTR_WRAP_EN_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL13_MSTR_WRAP_EN_SHIFT))

//====================================================================
//Register: SDRAM Control XIV (SDRAMControl14)
/** \brief SDRAM control register 14.*/
//====================================================================

#define  MC_SDRAMCONTROL14_RESERVED1_MASK 0xfffffffe
#define  MC_SDRAMCONTROL14_RESERVED1_SHIFT 1
#define  MC_SDRAMCONTROL14_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL14_RESERVED1_MASK) >> MC_SDRAMCONTROL14_RESERVED1_SHIFT)
#define  MC_SDRAMCONTROL14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL14_RESERVED1_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL14_RESERVED1_SHIFT))

#define  MC_SDRAMCONTROL14_BLOCKALLDATAREQ_MASK 0x1
#define  MC_SDRAMCONTROL14_BLOCKALLDATAREQ_SHIFT 0
#define  MC_SDRAMCONTROL14_BLOCKALLDATAREQ_MASK_SHIFT(reg) (((reg) & MC_SDRAMCONTROL14_BLOCKALLDATAREQ_MASK) >> MC_SDRAMCONTROL14_BLOCKALLDATAREQ_SHIFT)
#define  MC_SDRAMCONTROL14_BLOCKALLDATAREQ_REPLACE_VAL(reg,val) (((reg) & ~MC_SDRAMCONTROL14_BLOCKALLDATAREQ_MASK) | (((uint32_t)val) << MC_SDRAMCONTROL14_BLOCKALLDATAREQ_SHIFT))

//====================================================================
//Register: MCB2DRAM Control Register 1 (MCBControl1)
/** \brief This register configures arbitration weights for arbitration between
      the four master inputs of MCB2DRAM connected to MC master port 1.*/
//====================================================================

#define  MC_MCBCONTROL1_RESERVED1_MASK 0xf0000000
#define  MC_MCBCONTROL1_RESERVED1_SHIFT 28
#define  MC_MCBCONTROL1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL1_RESERVED1_MASK) >> MC_MCBCONTROL1_RESERVED1_SHIFT)
#define  MC_MCBCONTROL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL1_RESERVED1_MASK) | (((uint32_t)val) << MC_MCBCONTROL1_RESERVED1_SHIFT))

#define  MC_MCBCONTROL1_MSTRWT3_MASK 0xf000000
#define  MC_MCBCONTROL1_MSTRWT3_SHIFT 24
#define  MC_MCBCONTROL1_MSTRWT3_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL1_MSTRWT3_MASK) >> MC_MCBCONTROL1_MSTRWT3_SHIFT)
#define  MC_MCBCONTROL1_MSTRWT3_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL1_MSTRWT3_MASK) | (((uint32_t)val) << MC_MCBCONTROL1_MSTRWT3_SHIFT))

#define  MC_MCBCONTROL1_RESERVED2_MASK 0xf00000
#define  MC_MCBCONTROL1_RESERVED2_SHIFT 20
#define  MC_MCBCONTROL1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL1_RESERVED2_MASK) >> MC_MCBCONTROL1_RESERVED2_SHIFT)
#define  MC_MCBCONTROL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL1_RESERVED2_MASK) | (((uint32_t)val) << MC_MCBCONTROL1_RESERVED2_SHIFT))

#define  MC_MCBCONTROL1_MSTRWT2_MASK 0xf0000
#define  MC_MCBCONTROL1_MSTRWT2_SHIFT 16
#define  MC_MCBCONTROL1_MSTRWT2_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL1_MSTRWT2_MASK) >> MC_MCBCONTROL1_MSTRWT2_SHIFT)
#define  MC_MCBCONTROL1_MSTRWT2_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL1_MSTRWT2_MASK) | (((uint32_t)val) << MC_MCBCONTROL1_MSTRWT2_SHIFT))

#define  MC_MCBCONTROL1_RESERVED3_MASK 0xf000
#define  MC_MCBCONTROL1_RESERVED3_SHIFT 12
#define  MC_MCBCONTROL1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL1_RESERVED3_MASK) >> MC_MCBCONTROL1_RESERVED3_SHIFT)
#define  MC_MCBCONTROL1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL1_RESERVED3_MASK) | (((uint32_t)val) << MC_MCBCONTROL1_RESERVED3_SHIFT))

#define  MC_MCBCONTROL1_MSTRWT1_MASK 0xf00
#define  MC_MCBCONTROL1_MSTRWT1_SHIFT 8
#define  MC_MCBCONTROL1_MSTRWT1_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL1_MSTRWT1_MASK) >> MC_MCBCONTROL1_MSTRWT1_SHIFT)
#define  MC_MCBCONTROL1_MSTRWT1_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL1_MSTRWT1_MASK) | (((uint32_t)val) << MC_MCBCONTROL1_MSTRWT1_SHIFT))

#define  MC_MCBCONTROL1_RESERVED4_MASK 0xf0
#define  MC_MCBCONTROL1_RESERVED4_SHIFT 4
#define  MC_MCBCONTROL1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL1_RESERVED4_MASK) >> MC_MCBCONTROL1_RESERVED4_SHIFT)
#define  MC_MCBCONTROL1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL1_RESERVED4_MASK) | (((uint32_t)val) << MC_MCBCONTROL1_RESERVED4_SHIFT))

#define  MC_MCBCONTROL1_MSTRWT0_MASK 0xf
#define  MC_MCBCONTROL1_MSTRWT0_SHIFT 0
#define  MC_MCBCONTROL1_MSTRWT0_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL1_MSTRWT0_MASK) >> MC_MCBCONTROL1_MSTRWT0_SHIFT)
#define  MC_MCBCONTROL1_MSTRWT0_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL1_MSTRWT0_MASK) | (((uint32_t)val) << MC_MCBCONTROL1_MSTRWT0_SHIFT))

//====================================================================
//Register: MCB2DRAM Control Register 2 (MCBControl2)
/** \brief This register configures arbitration weights for arbitration between
      the four master inputs of MCB2DRAM connected to MC master port 2.*/
//====================================================================

#define  MC_MCBCONTROL2_RESERVED1_MASK 0xf0000000
#define  MC_MCBCONTROL2_RESERVED1_SHIFT 28
#define  MC_MCBCONTROL2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL2_RESERVED1_MASK) >> MC_MCBCONTROL2_RESERVED1_SHIFT)
#define  MC_MCBCONTROL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL2_RESERVED1_MASK) | (((uint32_t)val) << MC_MCBCONTROL2_RESERVED1_SHIFT))

#define  MC_MCBCONTROL2_MSTRWT3_MASK 0xf000000
#define  MC_MCBCONTROL2_MSTRWT3_SHIFT 24
#define  MC_MCBCONTROL2_MSTRWT3_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL2_MSTRWT3_MASK) >> MC_MCBCONTROL2_MSTRWT3_SHIFT)
#define  MC_MCBCONTROL2_MSTRWT3_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL2_MSTRWT3_MASK) | (((uint32_t)val) << MC_MCBCONTROL2_MSTRWT3_SHIFT))

#define  MC_MCBCONTROL2_RESERVED2_MASK 0xf00000
#define  MC_MCBCONTROL2_RESERVED2_SHIFT 20
#define  MC_MCBCONTROL2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL2_RESERVED2_MASK) >> MC_MCBCONTROL2_RESERVED2_SHIFT)
#define  MC_MCBCONTROL2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL2_RESERVED2_MASK) | (((uint32_t)val) << MC_MCBCONTROL2_RESERVED2_SHIFT))

#define  MC_MCBCONTROL2_MSTRWT2_MASK 0xf0000
#define  MC_MCBCONTROL2_MSTRWT2_SHIFT 16
#define  MC_MCBCONTROL2_MSTRWT2_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL2_MSTRWT2_MASK) >> MC_MCBCONTROL2_MSTRWT2_SHIFT)
#define  MC_MCBCONTROL2_MSTRWT2_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL2_MSTRWT2_MASK) | (((uint32_t)val) << MC_MCBCONTROL2_MSTRWT2_SHIFT))

#define  MC_MCBCONTROL2_RESERVED3_MASK 0xf000
#define  MC_MCBCONTROL2_RESERVED3_SHIFT 12
#define  MC_MCBCONTROL2_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL2_RESERVED3_MASK) >> MC_MCBCONTROL2_RESERVED3_SHIFT)
#define  MC_MCBCONTROL2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL2_RESERVED3_MASK) | (((uint32_t)val) << MC_MCBCONTROL2_RESERVED3_SHIFT))

#define  MC_MCBCONTROL2_MSTRWT1_MASK 0xf00
#define  MC_MCBCONTROL2_MSTRWT1_SHIFT 8
#define  MC_MCBCONTROL2_MSTRWT1_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL2_MSTRWT1_MASK) >> MC_MCBCONTROL2_MSTRWT1_SHIFT)
#define  MC_MCBCONTROL2_MSTRWT1_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL2_MSTRWT1_MASK) | (((uint32_t)val) << MC_MCBCONTROL2_MSTRWT1_SHIFT))

#define  MC_MCBCONTROL2_RESERVED4_MASK 0xf0
#define  MC_MCBCONTROL2_RESERVED4_SHIFT 4
#define  MC_MCBCONTROL2_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL2_RESERVED4_MASK) >> MC_MCBCONTROL2_RESERVED4_SHIFT)
#define  MC_MCBCONTROL2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL2_RESERVED4_MASK) | (((uint32_t)val) << MC_MCBCONTROL2_RESERVED4_SHIFT))

#define  MC_MCBCONTROL2_MSTRWT0_MASK 0xf
#define  MC_MCBCONTROL2_MSTRWT0_SHIFT 0
#define  MC_MCBCONTROL2_MSTRWT0_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL2_MSTRWT0_MASK) >> MC_MCBCONTROL2_MSTRWT0_SHIFT)
#define  MC_MCBCONTROL2_MSTRWT0_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL2_MSTRWT0_MASK) | (((uint32_t)val) << MC_MCBCONTROL2_MSTRWT0_SHIFT))

//====================================================================
//Register: MCB2DRAM Control Register 3 (MCBControl3)
/** \brief This register configures arbitration weights for arbitration between
      the four master inputs of MCB2DRAM connected to MC master port 3.*/
//====================================================================

#define  MC_MCBCONTROL3_RESERVED1_MASK 0xf0000000
#define  MC_MCBCONTROL3_RESERVED1_SHIFT 28
#define  MC_MCBCONTROL3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL3_RESERVED1_MASK) >> MC_MCBCONTROL3_RESERVED1_SHIFT)
#define  MC_MCBCONTROL3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL3_RESERVED1_MASK) | (((uint32_t)val) << MC_MCBCONTROL3_RESERVED1_SHIFT))

#define  MC_MCBCONTROL3_MSTRWT3_MASK 0xf000000
#define  MC_MCBCONTROL3_MSTRWT3_SHIFT 24
#define  MC_MCBCONTROL3_MSTRWT3_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL3_MSTRWT3_MASK) >> MC_MCBCONTROL3_MSTRWT3_SHIFT)
#define  MC_MCBCONTROL3_MSTRWT3_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL3_MSTRWT3_MASK) | (((uint32_t)val) << MC_MCBCONTROL3_MSTRWT3_SHIFT))

#define  MC_MCBCONTROL3_RESERVED2_MASK 0xf00000
#define  MC_MCBCONTROL3_RESERVED2_SHIFT 20
#define  MC_MCBCONTROL3_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL3_RESERVED2_MASK) >> MC_MCBCONTROL3_RESERVED2_SHIFT)
#define  MC_MCBCONTROL3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL3_RESERVED2_MASK) | (((uint32_t)val) << MC_MCBCONTROL3_RESERVED2_SHIFT))

#define  MC_MCBCONTROL3_MSTRWT2_MASK 0xf0000
#define  MC_MCBCONTROL3_MSTRWT2_SHIFT 16
#define  MC_MCBCONTROL3_MSTRWT2_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL3_MSTRWT2_MASK) >> MC_MCBCONTROL3_MSTRWT2_SHIFT)
#define  MC_MCBCONTROL3_MSTRWT2_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL3_MSTRWT2_MASK) | (((uint32_t)val) << MC_MCBCONTROL3_MSTRWT2_SHIFT))

#define  MC_MCBCONTROL3_RESERVED3_MASK 0xf000
#define  MC_MCBCONTROL3_RESERVED3_SHIFT 12
#define  MC_MCBCONTROL3_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL3_RESERVED3_MASK) >> MC_MCBCONTROL3_RESERVED3_SHIFT)
#define  MC_MCBCONTROL3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL3_RESERVED3_MASK) | (((uint32_t)val) << MC_MCBCONTROL3_RESERVED3_SHIFT))

#define  MC_MCBCONTROL3_MSTRWT1_MASK 0xf00
#define  MC_MCBCONTROL3_MSTRWT1_SHIFT 8
#define  MC_MCBCONTROL3_MSTRWT1_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL3_MSTRWT1_MASK) >> MC_MCBCONTROL3_MSTRWT1_SHIFT)
#define  MC_MCBCONTROL3_MSTRWT1_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL3_MSTRWT1_MASK) | (((uint32_t)val) << MC_MCBCONTROL3_MSTRWT1_SHIFT))

#define  MC_MCBCONTROL3_RESERVED4_MASK 0xf0
#define  MC_MCBCONTROL3_RESERVED4_SHIFT 4
#define  MC_MCBCONTROL3_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL3_RESERVED4_MASK) >> MC_MCBCONTROL3_RESERVED4_SHIFT)
#define  MC_MCBCONTROL3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL3_RESERVED4_MASK) | (((uint32_t)val) << MC_MCBCONTROL3_RESERVED4_SHIFT))

#define  MC_MCBCONTROL3_MSTRWT0_MASK 0xf
#define  MC_MCBCONTROL3_MSTRWT0_SHIFT 0
#define  MC_MCBCONTROL3_MSTRWT0_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL3_MSTRWT0_MASK) >> MC_MCBCONTROL3_MSTRWT0_SHIFT)
#define  MC_MCBCONTROL3_MSTRWT0_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL3_MSTRWT0_MASK) | (((uint32_t)val) << MC_MCBCONTROL3_MSTRWT0_SHIFT))

//====================================================================
//Register: MCB Read/Write Flow Control (MCBControl4)
//====================================================================

#define  MC_MCBCONTROL4_RESERVED1_MASK 0xf0000000
#define  MC_MCBCONTROL4_RESERVED1_SHIFT 28
#define  MC_MCBCONTROL4_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_RESERVED1_MASK) >> MC_MCBCONTROL4_RESERVED1_SHIFT)
#define  MC_MCBCONTROL4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_RESERVED1_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_RESERVED1_SHIFT))

#define  MC_MCBCONTROL4_MCBWRAPBURSTEN_MASK 0xe000000
#define  MC_MCBCONTROL4_MCBWRAPBURSTEN_SHIFT 25
#define  MC_MCBCONTROL4_MCBWRAPBURSTEN_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_MCBWRAPBURSTEN_MASK) >> MC_MCBCONTROL4_MCBWRAPBURSTEN_SHIFT)
#define  MC_MCBCONTROL4_MCBWRAPBURSTEN_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_MCBWRAPBURSTEN_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_MCBWRAPBURSTEN_SHIFT))

#define  MC_MCBCONTROL4_RESERVED2_MASK 0x1000000
#define  MC_MCBCONTROL4_RESERVED2_SHIFT 24
#define  MC_MCBCONTROL4_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_RESERVED2_MASK) >> MC_MCBCONTROL4_RESERVED2_SHIFT)
#define  MC_MCBCONTROL4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_RESERVED2_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_RESERVED2_SHIFT))

#define  MC_MCBCONTROL4_MCBTAGEN_MASK 0xe00000
#define  MC_MCBCONTROL4_MCBTAGEN_SHIFT 21
#define  MC_MCBCONTROL4_MCBTAGEN_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_MCBTAGEN_MASK) >> MC_MCBCONTROL4_MCBTAGEN_SHIFT)
#define  MC_MCBCONTROL4_MCBTAGEN_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_MCBTAGEN_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_MCBTAGEN_SHIFT))

#define  MC_MCBCONTROL4_RESERVED3_MASK 0x100000
#define  MC_MCBCONTROL4_RESERVED3_SHIFT 20
#define  MC_MCBCONTROL4_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_RESERVED3_MASK) >> MC_MCBCONTROL4_RESERVED3_SHIFT)
#define  MC_MCBCONTROL4_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_RESERVED3_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_RESERVED3_SHIFT))

#define  MC_MCBCONTROL4_MCBRGERREN_MASK 0xe0000
#define  MC_MCBCONTROL4_MCBRGERREN_SHIFT 17
#define  MC_MCBCONTROL4_MCBRGERREN_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_MCBRGERREN_MASK) >> MC_MCBCONTROL4_MCBRGERREN_SHIFT)
#define  MC_MCBCONTROL4_MCBRGERREN_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_MCBRGERREN_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_MCBRGERREN_SHIFT))

#define  MC_MCBCONTROL4_RESERVED4_MASK 0x10000
#define  MC_MCBCONTROL4_RESERVED4_SHIFT 16
#define  MC_MCBCONTROL4_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_RESERVED4_MASK) >> MC_MCBCONTROL4_RESERVED4_SHIFT)
#define  MC_MCBCONTROL4_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_RESERVED4_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_RESERVED4_SHIFT))

#define  MC_MCBCONTROL4_MCBPAGEEN_MASK 0xe000
#define  MC_MCBCONTROL4_MCBPAGEEN_SHIFT 13
#define  MC_MCBCONTROL4_MCBPAGEEN_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_MCBPAGEEN_MASK) >> MC_MCBCONTROL4_MCBPAGEEN_SHIFT)
#define  MC_MCBCONTROL4_MCBPAGEEN_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_MCBPAGEEN_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_MCBPAGEEN_SHIFT))

#define  MC_MCBCONTROL4_RESERVED5_MASK 0x1000
#define  MC_MCBCONTROL4_RESERVED5_SHIFT 12
#define  MC_MCBCONTROL4_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_RESERVED5_MASK) >> MC_MCBCONTROL4_RESERVED5_SHIFT)
#define  MC_MCBCONTROL4_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_RESERVED5_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_RESERVED5_SHIFT))

#define  MC_MCBCONTROL4_MCBWRREN_MASK 0xe00
#define  MC_MCBCONTROL4_MCBWRREN_SHIFT 9
#define  MC_MCBCONTROL4_MCBWRREN_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_MCBWRREN_MASK) >> MC_MCBCONTROL4_MCBWRREN_SHIFT)
#define  MC_MCBCONTROL4_MCBWRREN_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_MCBWRREN_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_MCBWRREN_SHIFT))

#define  MC_MCBCONTROL4_RESERVED6_MASK 0x100
#define  MC_MCBCONTROL4_RESERVED6_SHIFT 8
#define  MC_MCBCONTROL4_RESERVED6_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_RESERVED6_MASK) >> MC_MCBCONTROL4_RESERVED6_SHIFT)
#define  MC_MCBCONTROL4_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_RESERVED6_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_RESERVED6_SHIFT))

#define  MC_MCBCONTROL4_MCBRDEN_MASK 0xe0
#define  MC_MCBCONTROL4_MCBRDEN_SHIFT 5
#define  MC_MCBCONTROL4_MCBRDEN_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_MCBRDEN_MASK) >> MC_MCBCONTROL4_MCBRDEN_SHIFT)
#define  MC_MCBCONTROL4_MCBRDEN_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_MCBRDEN_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_MCBRDEN_SHIFT))

#define  MC_MCBCONTROL4_RESERVED7_MASK 0x10
#define  MC_MCBCONTROL4_RESERVED7_SHIFT 4
#define  MC_MCBCONTROL4_RESERVED7_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_RESERVED7_MASK) >> MC_MCBCONTROL4_RESERVED7_SHIFT)
#define  MC_MCBCONTROL4_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_RESERVED7_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_RESERVED7_SHIFT))

#define  MC_MCBCONTROL4_MCBWREN_MASK 0xe
#define  MC_MCBCONTROL4_MCBWREN_SHIFT 1
#define  MC_MCBCONTROL4_MCBWREN_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_MCBWREN_MASK) >> MC_MCBCONTROL4_MCBWREN_SHIFT)
#define  MC_MCBCONTROL4_MCBWREN_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_MCBWREN_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_MCBWREN_SHIFT))

#define  MC_MCBCONTROL4_RESERVED8_MASK 0x1
#define  MC_MCBCONTROL4_RESERVED8_SHIFT 0
#define  MC_MCBCONTROL4_RESERVED8_MASK_SHIFT(reg) (((reg) & MC_MCBCONTROL4_RESERVED8_MASK) >> MC_MCBCONTROL4_RESERVED8_SHIFT)
#define  MC_MCBCONTROL4_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~MC_MCBCONTROL4_RESERVED8_MASK) | (((uint32_t)val) << MC_MCBCONTROL4_RESERVED8_SHIFT))

//====================================================================
//Register: Master Out of Range (MstrOutOfRange)
/** \brief The register shows the source of the interrupt that informs
      when an out-of-range access is detected.*/
//====================================================================

#define  MC_MSTROUTOFRANGE_RESERVED1_MASK 0xfffffff0
#define  MC_MSTROUTOFRANGE_RESERVED1_SHIFT 4
#define  MC_MSTROUTOFRANGE_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MSTROUTOFRANGE_RESERVED1_MASK) >> MC_MSTROUTOFRANGE_RESERVED1_SHIFT)
#define  MC_MSTROUTOFRANGE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MSTROUTOFRANGE_RESERVED1_MASK) | (((uint32_t)val) << MC_MSTROUTOFRANGE_RESERVED1_SHIFT))

#define  MC_MSTROUTOFRANGE_MSTR3_MASK 0x8
#define  MC_MSTROUTOFRANGE_MSTR3_SHIFT 3
#define  MC_MSTROUTOFRANGE_MSTR3_MASK_SHIFT(reg) (((reg) & MC_MSTROUTOFRANGE_MSTR3_MASK) >> MC_MSTROUTOFRANGE_MSTR3_SHIFT)
#define  MC_MSTROUTOFRANGE_MSTR3_REPLACE_VAL(reg,val) (((reg) & ~MC_MSTROUTOFRANGE_MSTR3_MASK) | (((uint32_t)val) << MC_MSTROUTOFRANGE_MSTR3_SHIFT))

#define  MC_MSTROUTOFRANGE_MSTR2_MASK 0x4
#define  MC_MSTROUTOFRANGE_MSTR2_SHIFT 2
#define  MC_MSTROUTOFRANGE_MSTR2_MASK_SHIFT(reg) (((reg) & MC_MSTROUTOFRANGE_MSTR2_MASK) >> MC_MSTROUTOFRANGE_MSTR2_SHIFT)
#define  MC_MSTROUTOFRANGE_MSTR2_REPLACE_VAL(reg,val) (((reg) & ~MC_MSTROUTOFRANGE_MSTR2_MASK) | (((uint32_t)val) << MC_MSTROUTOFRANGE_MSTR2_SHIFT))

#define  MC_MSTROUTOFRANGE_MSTR1_MASK 0x2
#define  MC_MSTROUTOFRANGE_MSTR1_SHIFT 1
#define  MC_MSTROUTOFRANGE_MSTR1_MASK_SHIFT(reg) (((reg) & MC_MSTROUTOFRANGE_MSTR1_MASK) >> MC_MSTROUTOFRANGE_MSTR1_SHIFT)
#define  MC_MSTROUTOFRANGE_MSTR1_REPLACE_VAL(reg,val) (((reg) & ~MC_MSTROUTOFRANGE_MSTR1_MASK) | (((uint32_t)val) << MC_MSTROUTOFRANGE_MSTR1_SHIFT))

#define  MC_MSTROUTOFRANGE_RESERVED2_MASK 0x1
#define  MC_MSTROUTOFRANGE_RESERVED2_SHIFT 0
#define  MC_MSTROUTOFRANGE_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MSTROUTOFRANGE_RESERVED2_MASK) >> MC_MSTROUTOFRANGE_RESERVED2_SHIFT)
#define  MC_MSTROUTOFRANGE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MSTROUTOFRANGE_RESERVED2_MASK) | (((uint32_t)val) << MC_MSTROUTOFRANGE_RESERVED2_SHIFT))

//====================================================================
//Register: SDRAM Pad Calibration (PadCal)
/** \brief SDRAM pad calibration control.*/
//====================================================================

#define  MC_PADCAL_RESERVED1_MASK 0xc0000000
#define  MC_PADCAL_RESERVED1_SHIFT 30
#define  MC_PADCAL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PADCAL_RESERVED1_MASK) >> MC_PADCAL_RESERVED1_SHIFT)
#define  MC_PADCAL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PADCAL_RESERVED1_MASK) | (((uint32_t)val) << MC_PADCAL_RESERVED1_SHIFT))

#define  MC_PADCAL_ZNCAL_MASK 0x3f000000
#define  MC_PADCAL_ZNCAL_SHIFT 24
#define  MC_PADCAL_ZNCAL_MASK_SHIFT(reg) (((reg) & MC_PADCAL_ZNCAL_MASK) >> MC_PADCAL_ZNCAL_SHIFT)
#define  MC_PADCAL_ZNCAL_REPLACE_VAL(reg,val) (((reg) & ~MC_PADCAL_ZNCAL_MASK) | (((uint32_t)val) << MC_PADCAL_ZNCAL_SHIFT))

#define  MC_PADCAL_ZPCLK_MASK 0xfc0000
#define  MC_PADCAL_ZPCLK_SHIFT 18
#define  MC_PADCAL_ZPCLK_MASK_SHIFT(reg) (((reg) & MC_PADCAL_ZPCLK_MASK) >> MC_PADCAL_ZPCLK_SHIFT)
#define  MC_PADCAL_ZPCLK_REPLACE_VAL(reg,val) (((reg) & ~MC_PADCAL_ZPCLK_MASK) | (((uint32_t)val) << MC_PADCAL_ZPCLK_SHIFT))

#define  MC_PADCAL_ZNCLK_MASK 0x3f000
#define  MC_PADCAL_ZNCLK_SHIFT 12
#define  MC_PADCAL_ZNCLK_MASK_SHIFT(reg) (((reg) & MC_PADCAL_ZNCLK_MASK) >> MC_PADCAL_ZNCLK_SHIFT)
#define  MC_PADCAL_ZNCLK_REPLACE_VAL(reg,val) (((reg) & ~MC_PADCAL_ZNCLK_MASK) | (((uint32_t)val) << MC_PADCAL_ZNCLK_SHIFT))

#define  MC_PADCAL_ZPCNTL_MASK 0xfc0
#define  MC_PADCAL_ZPCNTL_SHIFT 6
#define  MC_PADCAL_ZPCNTL_MASK_SHIFT(reg) (((reg) & MC_PADCAL_ZPCNTL_MASK) >> MC_PADCAL_ZPCNTL_SHIFT)
#define  MC_PADCAL_ZPCNTL_REPLACE_VAL(reg,val) (((reg) & ~MC_PADCAL_ZPCNTL_MASK) | (((uint32_t)val) << MC_PADCAL_ZPCNTL_SHIFT))

#define  MC_PADCAL_ZNCNTL_MASK 0x3f
#define  MC_PADCAL_ZNCNTL_SHIFT 0
#define  MC_PADCAL_ZNCNTL_MASK_SHIFT(reg) (((reg) & MC_PADCAL_ZNCNTL_MASK) >> MC_PADCAL_ZNCNTL_SHIFT)
#define  MC_PADCAL_ZNCNTL_REPLACE_VAL(reg,val) (((reg) & ~MC_PADCAL_ZNCNTL_MASK) | (((uint32_t)val) << MC_PADCAL_ZNCNTL_SHIFT))

//====================================================================
//Register: PHY Control I (PHYControl1)
/** \brief PHY control register 1.*/
//====================================================================

#define  MC_PHYCONTROL1_ZPCAL_MASK 0xfc000000
#define  MC_PHYCONTROL1_ZPCAL_SHIFT 26
#define  MC_PHYCONTROL1_ZPCAL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_ZPCAL_MASK) >> MC_PHYCONTROL1_ZPCAL_SHIFT)
#define  MC_PHYCONTROL1_ZPCAL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_ZPCAL_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_ZPCAL_SHIFT))

#define  MC_PHYCONTROL1_RESERVED1_MASK 0x3800000
#define  MC_PHYCONTROL1_RESERVED1_SHIFT 23
#define  MC_PHYCONTROL1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_RESERVED1_MASK) >> MC_PHYCONTROL1_RESERVED1_SHIFT)
#define  MC_PHYCONTROL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_RESERVED1_SHIFT))

#define  MC_PHYCONTROL1_PDCOMPB_MASK 0x400000
#define  MC_PHYCONTROL1_PDCOMPB_SHIFT 22
#define  MC_PHYCONTROL1_PDCOMPB_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_PDCOMPB_MASK) >> MC_PHYCONTROL1_PDCOMPB_SHIFT)
#define  MC_PHYCONTROL1_PDCOMPB_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_PDCOMPB_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_PDCOMPB_SHIFT))

#define  MC_PHYCONTROL1_CALNOE_MASK 0x200000
#define  MC_PHYCONTROL1_CALNOE_SHIFT 21
#define  MC_PHYCONTROL1_CALNOE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_CALNOE_MASK) >> MC_PHYCONTROL1_CALNOE_SHIFT)
#define  MC_PHYCONTROL1_CALNOE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_CALNOE_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_CALNOE_SHIFT))

#define  MC_PHYCONTROL1_DLLINCA_MASK 0x100000
#define  MC_PHYCONTROL1_DLLINCA_SHIFT 20
#define  MC_PHYCONTROL1_DLLINCA_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_DLLINCA_MASK) >> MC_PHYCONTROL1_DLLINCA_SHIFT)
#define  MC_PHYCONTROL1_DLLINCA_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_DLLINCA_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_DLLINCA_SHIFT))

#define  MC_PHYCONTROL1_DLLDECA_MASK 0x80000
#define  MC_PHYCONTROL1_DLLDECA_SHIFT 19
#define  MC_PHYCONTROL1_DLLDECA_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_DLLDECA_MASK) >> MC_PHYCONTROL1_DLLDECA_SHIFT)
#define  MC_PHYCONTROL1_DLLDECA_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_DLLDECA_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_DLLDECA_SHIFT))

#define  MC_PHYCONTROL1_DLLINCB_MASK 0x40000
#define  MC_PHYCONTROL1_DLLINCB_SHIFT 18
#define  MC_PHYCONTROL1_DLLINCB_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_DLLINCB_MASK) >> MC_PHYCONTROL1_DLLINCB_SHIFT)
#define  MC_PHYCONTROL1_DLLINCB_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_DLLINCB_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_DLLINCB_SHIFT))

#define  MC_PHYCONTROL1_DLLDECB_MASK 0x20000
#define  MC_PHYCONTROL1_DLLDECB_SHIFT 17
#define  MC_PHYCONTROL1_DLLDECB_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_DLLDECB_MASK) >> MC_PHYCONTROL1_DLLDECB_SHIFT)
#define  MC_PHYCONTROL1_DLLDECB_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_DLLDECB_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_DLLDECB_SHIFT))

#define  MC_PHYCONTROL1_DLLINCC_MASK 0x10000
#define  MC_PHYCONTROL1_DLLINCC_SHIFT 16
#define  MC_PHYCONTROL1_DLLINCC_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_DLLINCC_MASK) >> MC_PHYCONTROL1_DLLINCC_SHIFT)
#define  MC_PHYCONTROL1_DLLINCC_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_DLLINCC_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_DLLINCC_SHIFT))

#define  MC_PHYCONTROL1_DLLDECC_MASK 0x8000
#define  MC_PHYCONTROL1_DLLDECC_SHIFT 15
#define  MC_PHYCONTROL1_DLLDECC_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_DLLDECC_MASK) >> MC_PHYCONTROL1_DLLDECC_SHIFT)
#define  MC_PHYCONTROL1_DLLDECC_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_DLLDECC_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_DLLDECC_SHIFT))

#define  MC_PHYCONTROL1_RESERVED2_MASK 0x4000
#define  MC_PHYCONTROL1_RESERVED2_SHIFT 14
#define  MC_PHYCONTROL1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_RESERVED2_MASK) >> MC_PHYCONTROL1_RESERVED2_SHIFT)
#define  MC_PHYCONTROL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_RESERVED2_SHIFT))

#define  MC_PHYCONTROL1_CTRLNOE_MASK 0x2000
#define  MC_PHYCONTROL1_CTRLNOE_SHIFT 13
#define  MC_PHYCONTROL1_CTRLNOE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_CTRLNOE_MASK) >> MC_PHYCONTROL1_CTRLNOE_SHIFT)
#define  MC_PHYCONTROL1_CTRLNOE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_CTRLNOE_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_CTRLNOE_SHIFT))

#define  MC_PHYCONTROL1_CLKNOE_MASK 0x1000
#define  MC_PHYCONTROL1_CLKNOE_SHIFT 12
#define  MC_PHYCONTROL1_CLKNOE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_CLKNOE_MASK) >> MC_PHYCONTROL1_CLKNOE_SHIFT)
#define  MC_PHYCONTROL1_CLKNOE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_CLKNOE_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_CLKNOE_SHIFT))

#define  MC_PHYCONTROL1_SENSELATCHNXT_MASK 0x800
#define  MC_PHYCONTROL1_SENSELATCHNXT_SHIFT 11
#define  MC_PHYCONTROL1_SENSELATCHNXT_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_SENSELATCHNXT_MASK) >> MC_PHYCONTROL1_SENSELATCHNXT_SHIFT)
#define  MC_PHYCONTROL1_SENSELATCHNXT_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_SENSELATCHNXT_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_SENSELATCHNXT_SHIFT))

#define  MC_PHYCONTROL1_OCDDRVEN_MASK 0x400
#define  MC_PHYCONTROL1_OCDDRVEN_SHIFT 10
#define  MC_PHYCONTROL1_OCDDRVEN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_OCDDRVEN_MASK) >> MC_PHYCONTROL1_OCDDRVEN_SHIFT)
#define  MC_PHYCONTROL1_OCDDRVEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_OCDDRVEN_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_OCDDRVEN_SHIFT))

#define  MC_PHYCONTROL1_RESERVED3_MASK 0x300
#define  MC_PHYCONTROL1_RESERVED3_SHIFT 8
#define  MC_PHYCONTROL1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_RESERVED3_MASK) >> MC_PHYCONTROL1_RESERVED3_SHIFT)
#define  MC_PHYCONTROL1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_RESERVED3_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_RESERVED3_SHIFT))

#define  MC_PHYCONTROL1_ADDDQDLY_MASK 0x80
#define  MC_PHYCONTROL1_ADDDQDLY_SHIFT 7
#define  MC_PHYCONTROL1_ADDDQDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_ADDDQDLY_MASK) >> MC_PHYCONTROL1_ADDDQDLY_SHIFT)
#define  MC_PHYCONTROL1_ADDDQDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_ADDDQDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_ADDDQDLY_SHIFT))

#define  MC_PHYCONTROL1_ADDDQSDLY_MASK 0x40
#define  MC_PHYCONTROL1_ADDDQSDLY_SHIFT 6
#define  MC_PHYCONTROL1_ADDDQSDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_ADDDQSDLY_MASK) >> MC_PHYCONTROL1_ADDDQSDLY_SHIFT)
#define  MC_PHYCONTROL1_ADDDQSDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_ADDDQSDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_ADDDQSDLY_SHIFT))

#define  MC_PHYCONTROL1_CTRLPOS_MASK 0x20
#define  MC_PHYCONTROL1_CTRLPOS_SHIFT 5
#define  MC_PHYCONTROL1_CTRLPOS_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_CTRLPOS_MASK) >> MC_PHYCONTROL1_CTRLPOS_SHIFT)
#define  MC_PHYCONTROL1_CTRLPOS_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_CTRLPOS_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_CTRLPOS_SHIFT))

#define  MC_PHYCONTROL1_RESERVED4_MASK 0x1f
#define  MC_PHYCONTROL1_RESERVED4_SHIFT 0
#define  MC_PHYCONTROL1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL1_RESERVED4_MASK) >> MC_PHYCONTROL1_RESERVED4_SHIFT)
#define  MC_PHYCONTROL1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL1_RESERVED4_MASK) | (((uint32_t)val) << MC_PHYCONTROL1_RESERVED4_SHIFT))

//====================================================================
//Register: PHY Control II (PHYControl2)
/** \brief PHY control register 2.*/
//====================================================================

#define  MC_PHYCONTROL2_RESERVED1_MASK 0xfff00000
#define  MC_PHYCONTROL2_RESERVED1_SHIFT 20
#define  MC_PHYCONTROL2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_RESERVED1_MASK) >> MC_PHYCONTROL2_RESERVED1_SHIFT)
#define  MC_PHYCONTROL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_RESERVED1_SHIFT))

#define  MC_PHYCONTROL2_ODTREADEN_MASK 0x80000
#define  MC_PHYCONTROL2_ODTREADEN_SHIFT 19
#define  MC_PHYCONTROL2_ODTREADEN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_ODTREADEN_MASK) >> MC_PHYCONTROL2_ODTREADEN_SHIFT)
#define  MC_PHYCONTROL2_ODTREADEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_ODTREADEN_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_ODTREADEN_SHIFT))

#define  MC_PHYCONTROL2_RESERVED2_MASK 0x78000
#define  MC_PHYCONTROL2_RESERVED2_SHIFT 15
#define  MC_PHYCONTROL2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_RESERVED2_MASK) >> MC_PHYCONTROL2_RESERVED2_SHIFT)
#define  MC_PHYCONTROL2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_RESERVED2_SHIFT))

#define  MC_PHYCONTROL2_ODTTESTMODE_MASK 0x4000
#define  MC_PHYCONTROL2_ODTTESTMODE_SHIFT 14
#define  MC_PHYCONTROL2_ODTTESTMODE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_ODTTESTMODE_MASK) >> MC_PHYCONTROL2_ODTTESTMODE_SHIFT)
#define  MC_PHYCONTROL2_ODTTESTMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_ODTTESTMODE_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_ODTTESTMODE_SHIFT))

#define  MC_PHYCONTROL2_SDRAMODT0_MASK 0x2000
#define  MC_PHYCONTROL2_SDRAMODT0_SHIFT 13
#define  MC_PHYCONTROL2_SDRAMODT0_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_SDRAMODT0_MASK) >> MC_PHYCONTROL2_SDRAMODT0_SHIFT)
#define  MC_PHYCONTROL2_SDRAMODT0_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_SDRAMODT0_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_SDRAMODT0_SHIFT))

#define  MC_PHYCONTROL2_SDRAMODT1_MASK 0x1000
#define  MC_PHYCONTROL2_SDRAMODT1_SHIFT 12
#define  MC_PHYCONTROL2_SDRAMODT1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_SDRAMODT1_MASK) >> MC_PHYCONTROL2_SDRAMODT1_SHIFT)
#define  MC_PHYCONTROL2_SDRAMODT1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_SDRAMODT1_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_SDRAMODT1_SHIFT))

#define  MC_PHYCONTROL2_SDRAMODT2_MASK 0x800
#define  MC_PHYCONTROL2_SDRAMODT2_SHIFT 11
#define  MC_PHYCONTROL2_SDRAMODT2_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_SDRAMODT2_MASK) >> MC_PHYCONTROL2_SDRAMODT2_SHIFT)
#define  MC_PHYCONTROL2_SDRAMODT2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_SDRAMODT2_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_SDRAMODT2_SHIFT))

#define  MC_PHYCONTROL2_PADODTEN_MASK 0x400
#define  MC_PHYCONTROL2_PADODTEN_SHIFT 10
#define  MC_PHYCONTROL2_PADODTEN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_PADODTEN_MASK) >> MC_PHYCONTROL2_PADODTEN_SHIFT)
#define  MC_PHYCONTROL2_PADODTEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_PADODTEN_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_PADODTEN_SHIFT))

#define  MC_PHYCONTROL2_ODTSWITCHMODE_MASK 0x300
#define  MC_PHYCONTROL2_ODTSWITCHMODE_SHIFT 8
#define  MC_PHYCONTROL2_ODTSWITCHMODE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_ODTSWITCHMODE_MASK) >> MC_PHYCONTROL2_ODTSWITCHMODE_SHIFT)
#define  MC_PHYCONTROL2_ODTSWITCHMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_ODTSWITCHMODE_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_ODTSWITCHMODE_SHIFT))

#define  MC_PHYCONTROL2_DQODTM1_MASK 0x80
#define  MC_PHYCONTROL2_DQODTM1_SHIFT 7
#define  MC_PHYCONTROL2_DQODTM1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_DQODTM1_MASK) >> MC_PHYCONTROL2_DQODTM1_SHIFT)
#define  MC_PHYCONTROL2_DQODTM1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_DQODTM1_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_DQODTM1_SHIFT))

#define  MC_PHYCONTROL2_DQODTM0_MASK 0x40
#define  MC_PHYCONTROL2_DQODTM0_SHIFT 6
#define  MC_PHYCONTROL2_DQODTM0_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_DQODTM0_MASK) >> MC_PHYCONTROL2_DQODTM0_SHIFT)
#define  MC_PHYCONTROL2_DQODTM0_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_DQODTM0_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_DQODTM0_SHIFT))

#define  MC_PHYCONTROL2_CNTLSR_MASK 0x30
#define  MC_PHYCONTROL2_CNTLSR_SHIFT 4
#define  MC_PHYCONTROL2_CNTLSR_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_CNTLSR_MASK) >> MC_PHYCONTROL2_CNTLSR_SHIFT)
#define  MC_PHYCONTROL2_CNTLSR_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_CNTLSR_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_CNTLSR_SHIFT))

#define  MC_PHYCONTROL2_DATASR_MASK 0xc
#define  MC_PHYCONTROL2_DATASR_SHIFT 2
#define  MC_PHYCONTROL2_DATASR_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_DATASR_MASK) >> MC_PHYCONTROL2_DATASR_SHIFT)
#define  MC_PHYCONTROL2_DATASR_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_DATASR_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_DATASR_SHIFT))

#define  MC_PHYCONTROL2_CNTLCALEN_MASK 0x2
#define  MC_PHYCONTROL2_CNTLCALEN_SHIFT 1
#define  MC_PHYCONTROL2_CNTLCALEN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_CNTLCALEN_MASK) >> MC_PHYCONTROL2_CNTLCALEN_SHIFT)
#define  MC_PHYCONTROL2_CNTLCALEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_CNTLCALEN_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_CNTLCALEN_SHIFT))

#define  MC_PHYCONTROL2_DATACALEN_MASK 0x1
#define  MC_PHYCONTROL2_DATACALEN_SHIFT 0
#define  MC_PHYCONTROL2_DATACALEN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL2_DATACALEN_MASK) >> MC_PHYCONTROL2_DATACALEN_SHIFT)
#define  MC_PHYCONTROL2_DATACALEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL2_DATACALEN_MASK) | (((uint32_t)val) << MC_PHYCONTROL2_DATACALEN_SHIFT))

//====================================================================
//Register: PHY Control III (PHYControl3)
/** \brief PHY control register 3.*/
//====================================================================

#define  MC_PHYCONTROL3_REFDLYMINMAXCLR_MASK 0x80000000
#define  MC_PHYCONTROL3_REFDLYMINMAXCLR_SHIFT 31
#define  MC_PHYCONTROL3_REFDLYMINMAXCLR_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_REFDLYMINMAXCLR_MASK) >> MC_PHYCONTROL3_REFDLYMINMAXCLR_SHIFT)
#define  MC_PHYCONTROL3_REFDLYMINMAXCLR_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_REFDLYMINMAXCLR_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_REFDLYMINMAXCLR_SHIFT))

#define  MC_PHYCONTROL3_TRANSPARENTMODE_MASK 0x40000000
#define  MC_PHYCONTROL3_TRANSPARENTMODE_SHIFT 30
#define  MC_PHYCONTROL3_TRANSPARENTMODE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_TRANSPARENTMODE_MASK) >> MC_PHYCONTROL3_TRANSPARENTMODE_SHIFT)
#define  MC_PHYCONTROL3_TRANSPARENTMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_TRANSPARENTMODE_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_TRANSPARENTMODE_SHIFT))

#define  MC_PHYCONTROL3_REFRESHMODEEN_MASK 0x20000000
#define  MC_PHYCONTROL3_REFRESHMODEEN_SHIFT 29
#define  MC_PHYCONTROL3_REFRESHMODEEN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_REFRESHMODEEN_MASK) >> MC_PHYCONTROL3_REFRESHMODEEN_SHIFT)
#define  MC_PHYCONTROL3_REFRESHMODEEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_REFRESHMODEEN_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_REFRESHMODEEN_SHIFT))

#define  MC_PHYCONTROL3_DFVB4SEL_MASK 0x10000000
#define  MC_PHYCONTROL3_DFVB4SEL_SHIFT 28
#define  MC_PHYCONTROL3_DFVB4SEL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_DFVB4SEL_MASK) >> MC_PHYCONTROL3_DFVB4SEL_SHIFT)
#define  MC_PHYCONTROL3_DFVB4SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_DFVB4SEL_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_DFVB4SEL_SHIFT))

#define  MC_PHYCONTROL3_DFVB4FILTER_MASK 0x8000000
#define  MC_PHYCONTROL3_DFVB4FILTER_SHIFT 27
#define  MC_PHYCONTROL3_DFVB4FILTER_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_DFVB4FILTER_MASK) >> MC_PHYCONTROL3_DFVB4FILTER_SHIFT)
#define  MC_PHYCONTROL3_DFVB4FILTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_DFVB4FILTER_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_DFVB4FILTER_SHIFT))

#define  MC_PHYCONTROL3_UPDTIMERVAL_MASK 0x7fe0000
#define  MC_PHYCONTROL3_UPDTIMERVAL_SHIFT 17
#define  MC_PHYCONTROL3_UPDTIMERVAL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_UPDTIMERVAL_MASK) >> MC_PHYCONTROL3_UPDTIMERVAL_SHIFT)
#define  MC_PHYCONTROL3_UPDTIMERVAL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_UPDTIMERVAL_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_UPDTIMERVAL_SHIFT))

#define  MC_PHYCONTROL3_RESERVED1_MASK 0x18000
#define  MC_PHYCONTROL3_RESERVED1_SHIFT 15
#define  MC_PHYCONTROL3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_RESERVED1_MASK) >> MC_PHYCONTROL3_RESERVED1_SHIFT)
#define  MC_PHYCONTROL3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_RESERVED1_SHIFT))

#define  MC_PHYCONTROL3_PHYRFIFORDRSTEN_MASK 0x4000
#define  MC_PHYCONTROL3_PHYRFIFORDRSTEN_SHIFT 14
#define  MC_PHYCONTROL3_PHYRFIFORDRSTEN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_PHYRFIFORDRSTEN_MASK) >> MC_PHYCONTROL3_PHYRFIFORDRSTEN_SHIFT)
#define  MC_PHYCONTROL3_PHYRFIFORDRSTEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_PHYRFIFORDRSTEN_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_PHYRFIFORDRSTEN_SHIFT))

#define  MC_PHYCONTROL3_RESERVED2_MASK 0x2000
#define  MC_PHYCONTROL3_RESERVED2_SHIFT 13
#define  MC_PHYCONTROL3_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_RESERVED2_MASK) >> MC_PHYCONTROL3_RESERVED2_SHIFT)
#define  MC_PHYCONTROL3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_RESERVED2_SHIFT))

#define  MC_PHYCONTROL3_DQOENEXTEND_MASK 0x1000
#define  MC_PHYCONTROL3_DQOENEXTEND_SHIFT 12
#define  MC_PHYCONTROL3_DQOENEXTEND_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_DQOENEXTEND_MASK) >> MC_PHYCONTROL3_DQOENEXTEND_SHIFT)
#define  MC_PHYCONTROL3_DQOENEXTEND_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_DQOENEXTEND_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_DQOENEXTEND_SHIFT))

#define  MC_PHYCONTROL3_DQOENDLY_MASK 0xc00
#define  MC_PHYCONTROL3_DQOENDLY_SHIFT 10
#define  MC_PHYCONTROL3_DQOENDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_DQOENDLY_MASK) >> MC_PHYCONTROL3_DQOENDLY_SHIFT)
#define  MC_PHYCONTROL3_DQOENDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_DQOENDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_DQOENDLY_SHIFT))

#define  MC_PHYCONTROL3_RDEXTDLY_MASK 0x380
#define  MC_PHYCONTROL3_RDEXTDLY_SHIFT 7
#define  MC_PHYCONTROL3_RDEXTDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_RDEXTDLY_MASK) >> MC_PHYCONTROL3_RDEXTDLY_SHIFT)
#define  MC_PHYCONTROL3_RDEXTDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_RDEXTDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_RDEXTDLY_SHIFT))

#define  MC_PHYCONTROL3_PHYRFIFODLY_MASK 0x70
#define  MC_PHYCONTROL3_PHYRFIFODLY_SHIFT 4
#define  MC_PHYCONTROL3_PHYRFIFODLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_PHYRFIFODLY_MASK) >> MC_PHYCONTROL3_PHYRFIFODLY_SHIFT)
#define  MC_PHYCONTROL3_PHYRFIFODLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_PHYRFIFODLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_PHYRFIFODLY_SHIFT))

#define  MC_PHYCONTROL3_DQEXTDLY_MASK 0xf
#define  MC_PHYCONTROL3_DQEXTDLY_SHIFT 0
#define  MC_PHYCONTROL3_DQEXTDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL3_DQEXTDLY_MASK) >> MC_PHYCONTROL3_DQEXTDLY_SHIFT)
#define  MC_PHYCONTROL3_DQEXTDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL3_DQEXTDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL3_DQEXTDLY_SHIFT))

//====================================================================
//Register: PHY Control IV (PHYControl4)
/** \brief PHY control register 4.*/
//====================================================================

#define  MC_PHYCONTROL4_RESERVED1_MASK 0xff000000
#define  MC_PHYCONTROL4_RESERVED1_SHIFT 24
#define  MC_PHYCONTROL4_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL4_RESERVED1_MASK) >> MC_PHYCONTROL4_RESERVED1_SHIFT)
#define  MC_PHYCONTROL4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL4_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL4_RESERVED1_SHIFT))

#define  MC_PHYCONTROL4_FTDLLDELAYVALC_MASK 0xff0000
#define  MC_PHYCONTROL4_FTDLLDELAYVALC_SHIFT 16
#define  MC_PHYCONTROL4_FTDLLDELAYVALC_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL4_FTDLLDELAYVALC_MASK) >> MC_PHYCONTROL4_FTDLLDELAYVALC_SHIFT)
#define  MC_PHYCONTROL4_FTDLLDELAYVALC_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL4_FTDLLDELAYVALC_MASK) | (((uint32_t)val) << MC_PHYCONTROL4_FTDLLDELAYVALC_SHIFT))

#define  MC_PHYCONTROL4_FTDLLDELAYVALB_MASK 0xff00
#define  MC_PHYCONTROL4_FTDLLDELAYVALB_SHIFT 8
#define  MC_PHYCONTROL4_FTDLLDELAYVALB_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL4_FTDLLDELAYVALB_MASK) >> MC_PHYCONTROL4_FTDLLDELAYVALB_SHIFT)
#define  MC_PHYCONTROL4_FTDLLDELAYVALB_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL4_FTDLLDELAYVALB_MASK) | (((uint32_t)val) << MC_PHYCONTROL4_FTDLLDELAYVALB_SHIFT))

#define  MC_PHYCONTROL4_FTDLLDELAYVALA_MASK 0xff
#define  MC_PHYCONTROL4_FTDLLDELAYVALA_SHIFT 0
#define  MC_PHYCONTROL4_FTDLLDELAYVALA_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL4_FTDLLDELAYVALA_MASK) >> MC_PHYCONTROL4_FTDLLDELAYVALA_SHIFT)
#define  MC_PHYCONTROL4_FTDLLDELAYVALA_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL4_FTDLLDELAYVALA_MASK) | (((uint32_t)val) << MC_PHYCONTROL4_FTDLLDELAYVALA_SHIFT))

//====================================================================
//Register: PHY Control V (PHYControl5)
/** \brief PHY control register 5.*/
//====================================================================

#define  MC_PHYCONTROL5_RESERVED1_MASK 0xfff00000
#define  MC_PHYCONTROL5_RESERVED1_SHIFT 20
#define  MC_PHYCONTROL5_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL5_RESERVED1_MASK) >> MC_PHYCONTROL5_RESERVED1_SHIFT)
#define  MC_PHYCONTROL5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL5_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL5_RESERVED1_SHIFT))

#define  MC_PHYCONTROL5_DQSREFDLY_MASK 0xffc00
#define  MC_PHYCONTROL5_DQSREFDLY_SHIFT 10
#define  MC_PHYCONTROL5_DQSREFDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL5_DQSREFDLY_MASK) >> MC_PHYCONTROL5_DQSREFDLY_SHIFT)
#define  MC_PHYCONTROL5_DQSREFDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL5_DQSREFDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL5_DQSREFDLY_SHIFT))

#define  MC_PHYCONTROL5_DCLKREFDLY_MASK 0x3ff
#define  MC_PHYCONTROL5_DCLKREFDLY_SHIFT 0
#define  MC_PHYCONTROL5_DCLKREFDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL5_DCLKREFDLY_MASK) >> MC_PHYCONTROL5_DCLKREFDLY_SHIFT)
#define  MC_PHYCONTROL5_DCLKREFDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL5_DCLKREFDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL5_DCLKREFDLY_SHIFT))

//====================================================================
//Register: PHY Control VI (PHYControl6)
/** \brief PHY control register 6.*/
//====================================================================

#define  MC_PHYCONTROL6_RESERVED1_MASK 0xfff00000
#define  MC_PHYCONTROL6_RESERVED1_SHIFT 20
#define  MC_PHYCONTROL6_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL6_RESERVED1_MASK) >> MC_PHYCONTROL6_RESERVED1_SHIFT)
#define  MC_PHYCONTROL6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL6_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL6_RESERVED1_SHIFT))

#define  MC_PHYCONTROL6_REFDELAYMAX_MASK 0xffc00
#define  MC_PHYCONTROL6_REFDELAYMAX_SHIFT 10
#define  MC_PHYCONTROL6_REFDELAYMAX_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL6_REFDELAYMAX_MASK) >> MC_PHYCONTROL6_REFDELAYMAX_SHIFT)
#define  MC_PHYCONTROL6_REFDELAYMAX_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL6_REFDELAYMAX_MASK) | (((uint32_t)val) << MC_PHYCONTROL6_REFDELAYMAX_SHIFT))

#define  MC_PHYCONTROL6_REFDELAYMIN_MASK 0x3ff
#define  MC_PHYCONTROL6_REFDELAYMIN_SHIFT 0
#define  MC_PHYCONTROL6_REFDELAYMIN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL6_REFDELAYMIN_MASK) >> MC_PHYCONTROL6_REFDELAYMIN_SHIFT)
#define  MC_PHYCONTROL6_REFDELAYMIN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL6_REFDELAYMIN_MASK) | (((uint32_t)val) << MC_PHYCONTROL6_REFDELAYMIN_SHIFT))

//====================================================================
//Register: PHY Control VII (PHY65_SC) (PHYControl7)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL7_RESERVED1_MASK 0xc0000000
#define  MC_PHYCONTROL7_RESERVED1_SHIFT 30
#define  MC_PHYCONTROL7_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL7_RESERVED1_MASK) >> MC_PHYCONTROL7_RESERVED1_SHIFT)
#define  MC_PHYCONTROL7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL7_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL7_RESERVED1_SHIFT))

#define  MC_PHYCONTROL7_PHYQSVREFSEL_MASK 0x30000000
#define  MC_PHYCONTROL7_PHYQSVREFSEL_SHIFT 28
#define  MC_PHYCONTROL7_PHYQSVREFSEL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL7_PHYQSVREFSEL_MASK) >> MC_PHYCONTROL7_PHYQSVREFSEL_SHIFT)
#define  MC_PHYCONTROL7_PHYQSVREFSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL7_PHYQSVREFSEL_MASK) | (((uint32_t)val) << MC_PHYCONTROL7_PHYQSVREFSEL_SHIFT))

#define  MC_PHYCONTROL7_PHYDQZPDRV_MASK 0xf000000
#define  MC_PHYCONTROL7_PHYDQZPDRV_SHIFT 24
#define  MC_PHYCONTROL7_PHYDQZPDRV_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL7_PHYDQZPDRV_MASK) >> MC_PHYCONTROL7_PHYDQZPDRV_SHIFT)
#define  MC_PHYCONTROL7_PHYDQZPDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL7_PHYDQZPDRV_MASK) | (((uint32_t)val) << MC_PHYCONTROL7_PHYDQZPDRV_SHIFT))

#define  MC_PHYCONTROL7_PHYDQZNDRV_MASK 0xf00000
#define  MC_PHYCONTROL7_PHYDQZNDRV_SHIFT 20
#define  MC_PHYCONTROL7_PHYDQZNDRV_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL7_PHYDQZNDRV_MASK) >> MC_PHYCONTROL7_PHYDQZNDRV_SHIFT)
#define  MC_PHYCONTROL7_PHYDQZNDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL7_PHYDQZNDRV_MASK) | (((uint32_t)val) << MC_PHYCONTROL7_PHYDQZNDRV_SHIFT))

#define  MC_PHYCONTROL7_PHYDQZPTRM_MASK 0xf0000
#define  MC_PHYCONTROL7_PHYDQZPTRM_SHIFT 16
#define  MC_PHYCONTROL7_PHYDQZPTRM_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL7_PHYDQZPTRM_MASK) >> MC_PHYCONTROL7_PHYDQZPTRM_SHIFT)
#define  MC_PHYCONTROL7_PHYDQZPTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL7_PHYDQZPTRM_MASK) | (((uint32_t)val) << MC_PHYCONTROL7_PHYDQZPTRM_SHIFT))

#define  MC_PHYCONTROL7_PHYDQZNTRM_MASK 0xf000
#define  MC_PHYCONTROL7_PHYDQZNTRM_SHIFT 12
#define  MC_PHYCONTROL7_PHYDQZNTRM_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL7_PHYDQZNTRM_MASK) >> MC_PHYCONTROL7_PHYDQZNTRM_SHIFT)
#define  MC_PHYCONTROL7_PHYDQZNTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL7_PHYDQZNTRM_MASK) | (((uint32_t)val) << MC_PHYCONTROL7_PHYDQZNTRM_SHIFT))

#define  MC_PHYCONTROL7_PHYDQZNR_MASK 0xf00
#define  MC_PHYCONTROL7_PHYDQZNR_SHIFT 8
#define  MC_PHYCONTROL7_PHYDQZNR_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL7_PHYDQZNR_MASK) >> MC_PHYCONTROL7_PHYDQZNR_SHIFT)
#define  MC_PHYCONTROL7_PHYDQZNR_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL7_PHYDQZNR_MASK) | (((uint32_t)val) << MC_PHYCONTROL7_PHYDQZNR_SHIFT))

#define  MC_PHYCONTROL7_PHYDQZPR_MASK 0xf0
#define  MC_PHYCONTROL7_PHYDQZPR_SHIFT 4
#define  MC_PHYCONTROL7_PHYDQZPR_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL7_PHYDQZPR_MASK) >> MC_PHYCONTROL7_PHYDQZPR_SHIFT)
#define  MC_PHYCONTROL7_PHYDQZPR_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL7_PHYDQZPR_MASK) | (((uint32_t)val) << MC_PHYCONTROL7_PHYDQZPR_SHIFT))

#define  MC_PHYCONTROL7_PHYDQVREFSEL_MASK 0xc
#define  MC_PHYCONTROL7_PHYDQVREFSEL_SHIFT 2
#define  MC_PHYCONTROL7_PHYDQVREFSEL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL7_PHYDQVREFSEL_MASK) >> MC_PHYCONTROL7_PHYDQVREFSEL_SHIFT)
#define  MC_PHYCONTROL7_PHYDQVREFSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL7_PHYDQVREFSEL_MASK) | (((uint32_t)val) << MC_PHYCONTROL7_PHYDQVREFSEL_SHIFT))

#define  MC_PHYCONTROL7_PHYDQZD_MASK 0x2
#define  MC_PHYCONTROL7_PHYDQZD_SHIFT 1
#define  MC_PHYCONTROL7_PHYDQZD_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL7_PHYDQZD_MASK) >> MC_PHYCONTROL7_PHYDQZD_SHIFT)
#define  MC_PHYCONTROL7_PHYDQZD_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL7_PHYDQZD_MASK) | (((uint32_t)val) << MC_PHYCONTROL7_PHYDQZD_SHIFT))

#define  MC_PHYCONTROL7_PHYDQMODE_MASK 0x1
#define  MC_PHYCONTROL7_PHYDQMODE_SHIFT 0
#define  MC_PHYCONTROL7_PHYDQMODE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL7_PHYDQMODE_MASK) >> MC_PHYCONTROL7_PHYDQMODE_SHIFT)
#define  MC_PHYCONTROL7_PHYDQMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL7_PHYDQMODE_MASK) | (((uint32_t)val) << MC_PHYCONTROL7_PHYDQMODE_SHIFT))

//====================================================================
//Register: PHY Control VIII (PHY65_SC) (PHYControl8)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL8_RESERVED1_MASK 0xf0000000
#define  MC_PHYCONTROL8_RESERVED1_SHIFT 28
#define  MC_PHYCONTROL8_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL8_RESERVED1_MASK) >> MC_PHYCONTROL8_RESERVED1_SHIFT)
#define  MC_PHYCONTROL8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL8_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL8_RESERVED1_SHIFT))

#define  MC_PHYCONTROL8_PHYADCMZPDRV_MASK 0xf000000
#define  MC_PHYCONTROL8_PHYADCMZPDRV_SHIFT 24
#define  MC_PHYCONTROL8_PHYADCMZPDRV_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL8_PHYADCMZPDRV_MASK) >> MC_PHYCONTROL8_PHYADCMZPDRV_SHIFT)
#define  MC_PHYCONTROL8_PHYADCMZPDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL8_PHYADCMZPDRV_MASK) | (((uint32_t)val) << MC_PHYCONTROL8_PHYADCMZPDRV_SHIFT))

#define  MC_PHYCONTROL8_PHYADCMZNDRV_MASK 0xf00000
#define  MC_PHYCONTROL8_PHYADCMZNDRV_SHIFT 20
#define  MC_PHYCONTROL8_PHYADCMZNDRV_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL8_PHYADCMZNDRV_MASK) >> MC_PHYCONTROL8_PHYADCMZNDRV_SHIFT)
#define  MC_PHYCONTROL8_PHYADCMZNDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL8_PHYADCMZNDRV_MASK) | (((uint32_t)val) << MC_PHYCONTROL8_PHYADCMZNDRV_SHIFT))

#define  MC_PHYCONTROL8_PHYADCMZPTRM_MASK 0xf0000
#define  MC_PHYCONTROL8_PHYADCMZPTRM_SHIFT 16
#define  MC_PHYCONTROL8_PHYADCMZPTRM_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL8_PHYADCMZPTRM_MASK) >> MC_PHYCONTROL8_PHYADCMZPTRM_SHIFT)
#define  MC_PHYCONTROL8_PHYADCMZPTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL8_PHYADCMZPTRM_MASK) | (((uint32_t)val) << MC_PHYCONTROL8_PHYADCMZPTRM_SHIFT))

#define  MC_PHYCONTROL8_PHYADCMZNTRM_MASK 0xf000
#define  MC_PHYCONTROL8_PHYADCMZNTRM_SHIFT 12
#define  MC_PHYCONTROL8_PHYADCMZNTRM_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL8_PHYADCMZNTRM_MASK) >> MC_PHYCONTROL8_PHYADCMZNTRM_SHIFT)
#define  MC_PHYCONTROL8_PHYADCMZNTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL8_PHYADCMZNTRM_MASK) | (((uint32_t)val) << MC_PHYCONTROL8_PHYADCMZNTRM_SHIFT))

#define  MC_PHYCONTROL8_PHYADCMZNR_MASK 0xf00
#define  MC_PHYCONTROL8_PHYADCMZNR_SHIFT 8
#define  MC_PHYCONTROL8_PHYADCMZNR_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL8_PHYADCMZNR_MASK) >> MC_PHYCONTROL8_PHYADCMZNR_SHIFT)
#define  MC_PHYCONTROL8_PHYADCMZNR_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL8_PHYADCMZNR_MASK) | (((uint32_t)val) << MC_PHYCONTROL8_PHYADCMZNR_SHIFT))

#define  MC_PHYCONTROL8_PHYADCMZPR_MASK 0xf0
#define  MC_PHYCONTROL8_PHYADCMZPR_SHIFT 4
#define  MC_PHYCONTROL8_PHYADCMZPR_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL8_PHYADCMZPR_MASK) >> MC_PHYCONTROL8_PHYADCMZPR_SHIFT)
#define  MC_PHYCONTROL8_PHYADCMZPR_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL8_PHYADCMZPR_MASK) | (((uint32_t)val) << MC_PHYCONTROL8_PHYADCMZPR_SHIFT))

#define  MC_PHYCONTROL8_PHYADCMVREFSEL_MASK 0xc
#define  MC_PHYCONTROL8_PHYADCMVREFSEL_SHIFT 2
#define  MC_PHYCONTROL8_PHYADCMVREFSEL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL8_PHYADCMVREFSEL_MASK) >> MC_PHYCONTROL8_PHYADCMVREFSEL_SHIFT)
#define  MC_PHYCONTROL8_PHYADCMVREFSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL8_PHYADCMVREFSEL_MASK) | (((uint32_t)val) << MC_PHYCONTROL8_PHYADCMVREFSEL_SHIFT))

#define  MC_PHYCONTROL8_PHYADCMZD_MASK 0x2
#define  MC_PHYCONTROL8_PHYADCMZD_SHIFT 1
#define  MC_PHYCONTROL8_PHYADCMZD_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL8_PHYADCMZD_MASK) >> MC_PHYCONTROL8_PHYADCMZD_SHIFT)
#define  MC_PHYCONTROL8_PHYADCMZD_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL8_PHYADCMZD_MASK) | (((uint32_t)val) << MC_PHYCONTROL8_PHYADCMZD_SHIFT))

#define  MC_PHYCONTROL8_PHYADCMMODE_MASK 0x1
#define  MC_PHYCONTROL8_PHYADCMMODE_SHIFT 0
#define  MC_PHYCONTROL8_PHYADCMMODE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL8_PHYADCMMODE_MASK) >> MC_PHYCONTROL8_PHYADCMMODE_SHIFT)
#define  MC_PHYCONTROL8_PHYADCMMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL8_PHYADCMMODE_MASK) | (((uint32_t)val) << MC_PHYCONTROL8_PHYADCMMODE_SHIFT))

//====================================================================
//Register: PHY Control IX (PHY65_SC) (PHYControl9)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL9_PHYDQRCVTYPE_MASK 0x80000000
#define  MC_PHYCONTROL9_PHYDQRCVTYPE_SHIFT 31
#define  MC_PHYCONTROL9_PHYDQRCVTYPE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_PHYDQRCVTYPE_MASK) >> MC_PHYCONTROL9_PHYDQRCVTYPE_SHIFT)
#define  MC_PHYCONTROL9_PHYDQRCVTYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_PHYDQRCVTYPE_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_PHYDQRCVTYPE_SHIFT))

#define  MC_PHYCONTROL9_PHYQSRCVTYPE_MASK 0x40000000
#define  MC_PHYCONTROL9_PHYQSRCVTYPE_SHIFT 30
#define  MC_PHYCONTROL9_PHYQSRCVTYPE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_PHYQSRCVTYPE_MASK) >> MC_PHYCONTROL9_PHYQSRCVTYPE_SHIFT)
#define  MC_PHYCONTROL9_PHYQSRCVTYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_PHYQSRCVTYPE_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_PHYQSRCVTYPE_SHIFT))

#define  MC_PHYCONTROL9_PHYDQRCVEP_MASK 0x38000000
#define  MC_PHYCONTROL9_PHYDQRCVEP_SHIFT 27
#define  MC_PHYCONTROL9_PHYDQRCVEP_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_PHYDQRCVEP_MASK) >> MC_PHYCONTROL9_PHYDQRCVEP_SHIFT)
#define  MC_PHYCONTROL9_PHYDQRCVEP_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_PHYDQRCVEP_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_PHYDQRCVEP_SHIFT))

#define  MC_PHYCONTROL9_PHYDQRCVEN_MASK 0x7000000
#define  MC_PHYCONTROL9_PHYDQRCVEN_SHIFT 24
#define  MC_PHYCONTROL9_PHYDQRCVEN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_PHYDQRCVEN_MASK) >> MC_PHYCONTROL9_PHYDQRCVEN_SHIFT)
#define  MC_PHYCONTROL9_PHYDQRCVEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_PHYDQRCVEN_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_PHYDQRCVEN_SHIFT))

#define  MC_PHYCONTROL9_RESERVED1_MASK 0xc00000
#define  MC_PHYCONTROL9_RESERVED1_SHIFT 22
#define  MC_PHYCONTROL9_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_RESERVED1_MASK) >> MC_PHYCONTROL9_RESERVED1_SHIFT)
#define  MC_PHYCONTROL9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_RESERVED1_SHIFT))

#define  MC_PHYCONTROL9_PHYCKZD_MASK 0x200000
#define  MC_PHYCONTROL9_PHYCKZD_SHIFT 21
#define  MC_PHYCONTROL9_PHYCKZD_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_PHYCKZD_MASK) >> MC_PHYCONTROL9_PHYCKZD_SHIFT)
#define  MC_PHYCONTROL9_PHYCKZD_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_PHYCKZD_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_PHYCKZD_SHIFT))

#define  MC_PHYCONTROL9_RESERVED2_MASK 0x100000
#define  MC_PHYCONTROL9_RESERVED2_SHIFT 20
#define  MC_PHYCONTROL9_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_RESERVED2_MASK) >> MC_PHYCONTROL9_RESERVED2_SHIFT)
#define  MC_PHYCONTROL9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_RESERVED2_SHIFT))

#define  MC_PHYCONTROL9_PHYWCKDQDLY_MASK 0xe0000
#define  MC_PHYCONTROL9_PHYWCKDQDLY_SHIFT 17
#define  MC_PHYCONTROL9_PHYWCKDQDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_PHYWCKDQDLY_MASK) >> MC_PHYCONTROL9_PHYWCKDQDLY_SHIFT)
#define  MC_PHYCONTROL9_PHYWCKDQDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_PHYWCKDQDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_PHYWCKDQDLY_SHIFT))

#define  MC_PHYCONTROL9_PHYWCKQSDLY_MASK 0x1c000
#define  MC_PHYCONTROL9_PHYWCKQSDLY_SHIFT 14
#define  MC_PHYCONTROL9_PHYWCKQSDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_PHYWCKQSDLY_MASK) >> MC_PHYCONTROL9_PHYWCKQSDLY_SHIFT)
#define  MC_PHYCONTROL9_PHYWCKQSDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_PHYWCKQSDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_PHYWCKQSDLY_SHIFT))

#define  MC_PHYCONTROL9_PHYWCKACDLY_MASK 0x3800
#define  MC_PHYCONTROL9_PHYWCKACDLY_SHIFT 11
#define  MC_PHYCONTROL9_PHYWCKACDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_PHYWCKACDLY_MASK) >> MC_PHYCONTROL9_PHYWCKACDLY_SHIFT)
#define  MC_PHYCONTROL9_PHYWCKACDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_PHYWCKACDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_PHYWCKACDLY_SHIFT))

#define  MC_PHYCONTROL9_PHYWCKCKDLY_MASK 0x700
#define  MC_PHYCONTROL9_PHYWCKCKDLY_SHIFT 8
#define  MC_PHYCONTROL9_PHYWCKCKDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_PHYWCKCKDLY_MASK) >> MC_PHYCONTROL9_PHYWCKCKDLY_SHIFT)
#define  MC_PHYCONTROL9_PHYWCKCKDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_PHYWCKCKDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_PHYWCKCKDLY_SHIFT))

#define  MC_PHYCONTROL9_PHYCKZNR_MASK 0xf0
#define  MC_PHYCONTROL9_PHYCKZNR_SHIFT 4
#define  MC_PHYCONTROL9_PHYCKZNR_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_PHYCKZNR_MASK) >> MC_PHYCONTROL9_PHYCKZNR_SHIFT)
#define  MC_PHYCONTROL9_PHYCKZNR_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_PHYCKZNR_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_PHYCKZNR_SHIFT))

#define  MC_PHYCONTROL9_PHYCKZPR_MASK 0xf
#define  MC_PHYCONTROL9_PHYCKZPR_SHIFT 0
#define  MC_PHYCONTROL9_PHYCKZPR_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL9_PHYCKZPR_MASK) >> MC_PHYCONTROL9_PHYCKZPR_SHIFT)
#define  MC_PHYCONTROL9_PHYCKZPR_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL9_PHYCKZPR_MASK) | (((uint32_t)val) << MC_PHYCONTROL9_PHYCKZPR_SHIFT))

//====================================================================
//Register: PHY Control X (PHY65_SC) (PHYControl10)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL10_RESERVED1_MASK 0xffc00000
#define  MC_PHYCONTROL10_RESERVED1_SHIFT 22
#define  MC_PHYCONTROL10_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_RESERVED1_MASK) >> MC_PHYCONTROL10_RESERVED1_SHIFT)
#define  MC_PHYCONTROL10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_RESERVED1_SHIFT))

#define  MC_PHYCONTROL10_PAD_CAL_INTERVAL_MASK 0x300000
#define  MC_PHYCONTROL10_PAD_CAL_INTERVAL_SHIFT 20
#define  MC_PHYCONTROL10_PAD_CAL_INTERVAL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_PAD_CAL_INTERVAL_MASK) >> MC_PHYCONTROL10_PAD_CAL_INTERVAL_SHIFT)
#define  MC_PHYCONTROL10_PAD_CAL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_PAD_CAL_INTERVAL_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_PAD_CAL_INTERVAL_SHIFT))

#define  MC_PHYCONTROL10_PAD_CAL_AUTO_SEL_MASK 0xe0000
#define  MC_PHYCONTROL10_PAD_CAL_AUTO_SEL_SHIFT 17
#define  MC_PHYCONTROL10_PAD_CAL_AUTO_SEL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_PAD_CAL_AUTO_SEL_MASK) >> MC_PHYCONTROL10_PAD_CAL_AUTO_SEL_SHIFT)
#define  MC_PHYCONTROL10_PAD_CAL_AUTO_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_PAD_CAL_AUTO_SEL_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_PAD_CAL_AUTO_SEL_SHIFT))

#define  MC_PHYCONTROL10_PAD_CAL_AUTO_MASK 0x10000
#define  MC_PHYCONTROL10_PAD_CAL_AUTO_SHIFT 16
#define  MC_PHYCONTROL10_PAD_CAL_AUTO_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_PAD_CAL_AUTO_MASK) >> MC_PHYCONTROL10_PAD_CAL_AUTO_SHIFT)
#define  MC_PHYCONTROL10_PAD_CAL_AUTO_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_PAD_CAL_AUTO_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_PAD_CAL_AUTO_SHIFT))

#define  MC_PHYCONTROL10_RESERVED2_MASK 0xc000
#define  MC_PHYCONTROL10_RESERVED2_SHIFT 14
#define  MC_PHYCONTROL10_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_RESERVED2_MASK) >> MC_PHYCONTROL10_RESERVED2_SHIFT)
#define  MC_PHYCONTROL10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_RESERVED2_SHIFT))

#define  MC_PHYCONTROL10_READFIFODEPTH_MASK 0x3000
#define  MC_PHYCONTROL10_READFIFODEPTH_SHIFT 12
#define  MC_PHYCONTROL10_READFIFODEPTH_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_READFIFODEPTH_MASK) >> MC_PHYCONTROL10_READFIFODEPTH_SHIFT)
#define  MC_PHYCONTROL10_READFIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_READFIFODEPTH_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_READFIFODEPTH_SHIFT))

#define  MC_PHYCONTROL10_RESERVED3_MASK 0x800
#define  MC_PHYCONTROL10_RESERVED3_SHIFT 11
#define  MC_PHYCONTROL10_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_RESERVED3_MASK) >> MC_PHYCONTROL10_RESERVED3_SHIFT)
#define  MC_PHYCONTROL10_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_RESERVED3_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_RESERVED3_SHIFT))

#define  MC_PHYCONTROL10_WRITEDQSBONE_MASK 0x400
#define  MC_PHYCONTROL10_WRITEDQSBONE_SHIFT 10
#define  MC_PHYCONTROL10_WRITEDQSBONE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_WRITEDQSBONE_MASK) >> MC_PHYCONTROL10_WRITEDQSBONE_SHIFT)
#define  MC_PHYCONTROL10_WRITEDQSBONE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_WRITEDQSBONE_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_WRITEDQSBONE_SHIFT))

#define  MC_PHYCONTROL10_EXT_REQ_PHY_SYNC_DIS_MASK 0x200
#define  MC_PHYCONTROL10_EXT_REQ_PHY_SYNC_DIS_SHIFT 9
#define  MC_PHYCONTROL10_EXT_REQ_PHY_SYNC_DIS_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_EXT_REQ_PHY_SYNC_DIS_MASK) >> MC_PHYCONTROL10_EXT_REQ_PHY_SYNC_DIS_SHIFT)
#define  MC_PHYCONTROL10_EXT_REQ_PHY_SYNC_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_EXT_REQ_PHY_SYNC_DIS_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_EXT_REQ_PHY_SYNC_DIS_SHIFT))

#define  MC_PHYCONTROL10_WRITEDQSBEN_MASK 0x100
#define  MC_PHYCONTROL10_WRITEDQSBEN_SHIFT 8
#define  MC_PHYCONTROL10_WRITEDQSBEN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_WRITEDQSBEN_MASK) >> MC_PHYCONTROL10_WRITEDQSBEN_SHIFT)
#define  MC_PHYCONTROL10_WRITEDQSBEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_WRITEDQSBEN_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_WRITEDQSBEN_SHIFT))

#define  MC_PHYCONTROL10_ALLBYTEPD_MASK 0x80
#define  MC_PHYCONTROL10_ALLBYTEPD_SHIFT 7
#define  MC_PHYCONTROL10_ALLBYTEPD_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_ALLBYTEPD_MASK) >> MC_PHYCONTROL10_ALLBYTEPD_SHIFT)
#define  MC_PHYCONTROL10_ALLBYTEPD_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_ALLBYTEPD_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_ALLBYTEPD_SHIFT))

#define  MC_PHYCONTROL10_ALLBYTEOE_MASK 0x40
#define  MC_PHYCONTROL10_ALLBYTEOE_SHIFT 6
#define  MC_PHYCONTROL10_ALLBYTEOE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_ALLBYTEOE_MASK) >> MC_PHYCONTROL10_ALLBYTEOE_SHIFT)
#define  MC_PHYCONTROL10_ALLBYTEOE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_ALLBYTEOE_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_ALLBYTEOE_SHIFT))

#define  MC_PHYCONTROL10_RESERVED4_MASK 0x20
#define  MC_PHYCONTROL10_RESERVED4_SHIFT 5
#define  MC_PHYCONTROL10_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_RESERVED4_MASK) >> MC_PHYCONTROL10_RESERVED4_SHIFT)
#define  MC_PHYCONTROL10_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_RESERVED4_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_RESERVED4_SHIFT))

#define  MC_PHYCONTROL10_MCDQSNPD_MASK 0x10
#define  MC_PHYCONTROL10_MCDQSNPD_SHIFT 4
#define  MC_PHYCONTROL10_MCDQSNPD_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_MCDQSNPD_MASK) >> MC_PHYCONTROL10_MCDQSNPD_SHIFT)
#define  MC_PHYCONTROL10_MCDQSNPD_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_MCDQSNPD_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_MCDQSNPD_SHIFT))

#define  MC_PHYCONTROL10_MCDQSPD_MASK 0x8
#define  MC_PHYCONTROL10_MCDQSPD_SHIFT 3
#define  MC_PHYCONTROL10_MCDQSPD_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_MCDQSPD_MASK) >> MC_PHYCONTROL10_MCDQSPD_SHIFT)
#define  MC_PHYCONTROL10_MCDQSPD_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_MCDQSPD_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_MCDQSPD_SHIFT))

#define  MC_PHYCONTROL10_MCDQPD_MASK 0x4
#define  MC_PHYCONTROL10_MCDQPD_SHIFT 2
#define  MC_PHYCONTROL10_MCDQPD_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_MCDQPD_MASK) >> MC_PHYCONTROL10_MCDQPD_SHIFT)
#define  MC_PHYCONTROL10_MCDQPD_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_MCDQPD_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_MCDQPD_SHIFT))

#define  MC_PHYCONTROL10_MCCKPD_MASK 0x2
#define  MC_PHYCONTROL10_MCCKPD_SHIFT 1
#define  MC_PHYCONTROL10_MCCKPD_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_MCCKPD_MASK) >> MC_PHYCONTROL10_MCCKPD_SHIFT)
#define  MC_PHYCONTROL10_MCCKPD_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_MCCKPD_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_MCCKPD_SHIFT))

#define  MC_PHYCONTROL10_MCACPD_MASK 0x1
#define  MC_PHYCONTROL10_MCACPD_SHIFT 0
#define  MC_PHYCONTROL10_MCACPD_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL10_MCACPD_MASK) >> MC_PHYCONTROL10_MCACPD_SHIFT)
#define  MC_PHYCONTROL10_MCACPD_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL10_MCACPD_MASK) | (((uint32_t)val) << MC_PHYCONTROL10_MCACPD_SHIFT))

//====================================================================
//Register: PHY Control XI (PHY65_SC) (PHYControl11)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL11_PLLTESTMON_MASK 0xf0000000
#define  MC_PHYCONTROL11_PLLTESTMON_SHIFT 28
#define  MC_PHYCONTROL11_PLLTESTMON_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_PLLTESTMON_MASK) >> MC_PHYCONTROL11_PLLTESTMON_SHIFT)
#define  MC_PHYCONTROL11_PLLTESTMON_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_PLLTESTMON_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_PLLTESTMON_SHIFT))

#define  MC_PHYCONTROL11_PLLVREGIVREF_MASK 0xc000000
#define  MC_PHYCONTROL11_PLLVREGIVREF_SHIFT 26
#define  MC_PHYCONTROL11_PLLVREGIVREF_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_PLLVREGIVREF_MASK) >> MC_PHYCONTROL11_PLLVREGIVREF_SHIFT)
#define  MC_PHYCONTROL11_PLLVREGIVREF_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_PLLVREGIVREF_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_PLLVREGIVREF_SHIFT))

#define  MC_PHYCONTROL11_PLLCTUNE_MASK 0x3000000
#define  MC_PHYCONTROL11_PLLCTUNE_SHIFT 24
#define  MC_PHYCONTROL11_PLLCTUNE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_PLLCTUNE_MASK) >> MC_PHYCONTROL11_PLLCTUNE_SHIFT)
#define  MC_PHYCONTROL11_PLLCTUNE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_PLLCTUNE_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_PLLCTUNE_SHIFT))

#define  MC_PHYCONTROL11_PLLRESERVE_MASK 0xc00000
#define  MC_PHYCONTROL11_PLLRESERVE_SHIFT 22
#define  MC_PHYCONTROL11_PLLRESERVE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_PLLRESERVE_MASK) >> MC_PHYCONTROL11_PLLRESERVE_SHIFT)
#define  MC_PHYCONTROL11_PLLRESERVE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_PLLRESERVE_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_PLLRESERVE_SHIFT))

#define  MC_PHYCONTROL11_PLLVDDM_MASK 0x300000
#define  MC_PHYCONTROL11_PLLVDDM_SHIFT 20
#define  MC_PHYCONTROL11_PLLVDDM_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_PLLVDDM_MASK) >> MC_PHYCONTROL11_PLLVDDM_SHIFT)
#define  MC_PHYCONTROL11_PLLVDDM_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_PLLVDDM_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_PLLVDDM_SHIFT))

#define  MC_PHYCONTROL11_PLLVDDL_MASK 0xf0000
#define  MC_PHYCONTROL11_PLLVDDL_SHIFT 16
#define  MC_PHYCONTROL11_PLLVDDL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_PLLVDDL_MASK) >> MC_PHYCONTROL11_PLLVDDL_SHIFT)
#define  MC_PHYCONTROL11_PLLVDDL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_PLLVDDL_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_PLLVDDL_SHIFT))

#define  MC_PHYCONTROL11_PLLKVCO_MASK 0xf000
#define  MC_PHYCONTROL11_PLLKVCO_SHIFT 12
#define  MC_PHYCONTROL11_PLLKVCO_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_PLLKVCO_MASK) >> MC_PHYCONTROL11_PLLKVCO_SHIFT)
#define  MC_PHYCONTROL11_PLLKVCO_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_PLLKVCO_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_PLLKVCO_SHIFT))

#define  MC_PHYCONTROL11_PLLVCODIVSEL_MASK 0xe00
#define  MC_PHYCONTROL11_PLLVCODIVSEL_SHIFT 9
#define  MC_PHYCONTROL11_PLLVCODIVSEL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_PLLVCODIVSEL_MASK) >> MC_PHYCONTROL11_PLLVCODIVSEL_SHIFT)
#define  MC_PHYCONTROL11_PLLVCODIVSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_PLLVCODIVSEL_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_PLLVCODIVSEL_SHIFT))

#define  MC_PHYCONTROL11_PLLVCOVRNG_MASK 0x1c0
#define  MC_PHYCONTROL11_PLLVCOVRNG_SHIFT 6
#define  MC_PHYCONTROL11_PLLVCOVRNG_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_PLLVCOVRNG_MASK) >> MC_PHYCONTROL11_PLLVCOVRNG_SHIFT)
#define  MC_PHYCONTROL11_PLLVCOVRNG_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_PLLVCOVRNG_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_PLLVCOVRNG_SHIFT))

#define  MC_PHYCONTROL11_PLLICP_MASK 0x38
#define  MC_PHYCONTROL11_PLLICP_SHIFT 3
#define  MC_PHYCONTROL11_PLLICP_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_PLLICP_MASK) >> MC_PHYCONTROL11_PLLICP_SHIFT)
#define  MC_PHYCONTROL11_PLLICP_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_PLLICP_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_PLLICP_SHIFT))

#define  MC_PHYCONTROL11_PLLUPDATESEL_MASK 0x4
#define  MC_PHYCONTROL11_PLLUPDATESEL_SHIFT 2
#define  MC_PHYCONTROL11_PLLUPDATESEL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_PLLUPDATESEL_MASK) >> MC_PHYCONTROL11_PLLUPDATESEL_SHIFT)
#define  MC_PHYCONTROL11_PLLUPDATESEL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_PLLUPDATESEL_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_PLLUPDATESEL_SHIFT))

#define  MC_PHYCONTROL11_PLLPUPLL_MASK 0x2
#define  MC_PHYCONTROL11_PLLPUPLL_SHIFT 1
#define  MC_PHYCONTROL11_PLLPUPLL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_PLLPUPLL_MASK) >> MC_PHYCONTROL11_PLLPUPLL_SHIFT)
#define  MC_PHYCONTROL11_PLLPUPLL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_PLLPUPLL_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_PLLPUPLL_SHIFT))

#define  MC_PHYCONTROL11_MCSYNCTYPE_MASK 0x1
#define  MC_PHYCONTROL11_MCSYNCTYPE_SHIFT 0
#define  MC_PHYCONTROL11_MCSYNCTYPE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL11_MCSYNCTYPE_MASK) >> MC_PHYCONTROL11_MCSYNCTYPE_SHIFT)
#define  MC_PHYCONTROL11_MCSYNCTYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL11_MCSYNCTYPE_MASK) | (((uint32_t)val) << MC_PHYCONTROL11_MCSYNCTYPE_SHIFT))

//====================================================================
//Register: PHY Control XII (PHY65_SC) (PHYControl12)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL12_PLL_FBDLY_MASK 0xf8000000
#define  MC_PHYCONTROL12_PLL_FBDLY_SHIFT 27
#define  MC_PHYCONTROL12_PLL_FBDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL12_PLL_FBDLY_MASK) >> MC_PHYCONTROL12_PLL_FBDLY_SHIFT)
#define  MC_PHYCONTROL12_PLL_FBDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL12_PLL_FBDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL12_PLL_FBDLY_SHIFT))

#define  MC_PHYCONTROL12_RESERVED1_MASK 0x6000000
#define  MC_PHYCONTROL12_RESERVED1_SHIFT 25
#define  MC_PHYCONTROL12_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL12_RESERVED1_MASK) >> MC_PHYCONTROL12_RESERVED1_SHIFT)
#define  MC_PHYCONTROL12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL12_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL12_RESERVED1_SHIFT))

#define  MC_PHYCONTROL12_PLL_FBDIV_MASK 0x1ff0000
#define  MC_PHYCONTROL12_PLL_FBDIV_SHIFT 16
#define  MC_PHYCONTROL12_PLL_FBDIV_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL12_PLL_FBDIV_MASK) >> MC_PHYCONTROL12_PLL_FBDIV_SHIFT)
#define  MC_PHYCONTROL12_PLL_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL12_PLL_FBDIV_MASK) | (((uint32_t)val) << MC_PHYCONTROL12_PLL_FBDIV_SHIFT))

#define  MC_PHYCONTROL12_PLL_REFDLY_MASK 0xf800
#define  MC_PHYCONTROL12_PLL_REFDLY_SHIFT 11
#define  MC_PHYCONTROL12_PLL_REFDLY_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL12_PLL_REFDLY_MASK) >> MC_PHYCONTROL12_PLL_REFDLY_SHIFT)
#define  MC_PHYCONTROL12_PLL_REFDLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL12_PLL_REFDLY_MASK) | (((uint32_t)val) << MC_PHYCONTROL12_PLL_REFDLY_SHIFT))

#define  MC_PHYCONTROL12_RESERVED2_MASK 0x600
#define  MC_PHYCONTROL12_RESERVED2_SHIFT 9
#define  MC_PHYCONTROL12_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL12_RESERVED2_MASK) >> MC_PHYCONTROL12_RESERVED2_SHIFT)
#define  MC_PHYCONTROL12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL12_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYCONTROL12_RESERVED2_SHIFT))

#define  MC_PHYCONTROL12_PLL_REFDIV_MASK 0x1ff
#define  MC_PHYCONTROL12_PLL_REFDIV_SHIFT 0
#define  MC_PHYCONTROL12_PLL_REFDIV_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL12_PLL_REFDIV_MASK) >> MC_PHYCONTROL12_PLL_REFDIV_SHIFT)
#define  MC_PHYCONTROL12_PLL_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL12_PLL_REFDIV_MASK) | (((uint32_t)val) << MC_PHYCONTROL12_PLL_REFDIV_SHIFT))

//====================================================================
//Register: PHY Control XIII (PHY65_SC) (PHYControl13)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL13_DLL_RESET_TIMER_MASK 0xf0000000
#define  MC_PHYCONTROL13_DLL_RESET_TIMER_SHIFT 28
#define  MC_PHYCONTROL13_DLL_RESET_TIMER_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL13_DLL_RESET_TIMER_MASK) >> MC_PHYCONTROL13_DLL_RESET_TIMER_SHIFT)
#define  MC_PHYCONTROL13_DLL_RESET_TIMER_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL13_DLL_RESET_TIMER_MASK) | (((uint32_t)val) << MC_PHYCONTROL13_DLL_RESET_TIMER_SHIFT))

#define  MC_PHYCONTROL13_DLL_UPDATE_STALL_MC_DIS_MASK 0x8000000
#define  MC_PHYCONTROL13_DLL_UPDATE_STALL_MC_DIS_SHIFT 27
#define  MC_PHYCONTROL13_DLL_UPDATE_STALL_MC_DIS_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL13_DLL_UPDATE_STALL_MC_DIS_MASK) >> MC_PHYCONTROL13_DLL_UPDATE_STALL_MC_DIS_SHIFT)
#define  MC_PHYCONTROL13_DLL_UPDATE_STALL_MC_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL13_DLL_UPDATE_STALL_MC_DIS_MASK) | (((uint32_t)val) << MC_PHYCONTROL13_DLL_UPDATE_STALL_MC_DIS_SHIFT))

#define  MC_PHYCONTROL13_RESERVED1_MASK 0x7c00000
#define  MC_PHYCONTROL13_RESERVED1_SHIFT 22
#define  MC_PHYCONTROL13_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL13_RESERVED1_MASK) >> MC_PHYCONTROL13_RESERVED1_SHIFT)
#define  MC_PHYCONTROL13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL13_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL13_RESERVED1_SHIFT))

#define  MC_PHYCONTROL13_DLL_DELAY_TEST_MASK 0x3f0000
#define  MC_PHYCONTROL13_DLL_DELAY_TEST_SHIFT 16
#define  MC_PHYCONTROL13_DLL_DELAY_TEST_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL13_DLL_DELAY_TEST_MASK) >> MC_PHYCONTROL13_DLL_DELAY_TEST_SHIFT)
#define  MC_PHYCONTROL13_DLL_DELAY_TEST_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL13_DLL_DELAY_TEST_MASK) | (((uint32_t)val) << MC_PHYCONTROL13_DLL_DELAY_TEST_SHIFT))

#define  MC_PHYCONTROL13_RESERVED2_MASK 0xfff0
#define  MC_PHYCONTROL13_RESERVED2_SHIFT 4
#define  MC_PHYCONTROL13_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL13_RESERVED2_MASK) >> MC_PHYCONTROL13_RESERVED2_SHIFT)
#define  MC_PHYCONTROL13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL13_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYCONTROL13_RESERVED2_SHIFT))

#define  MC_PHYCONTROL13_DLL_AUTO_MANUAL_UP_MASK 0x8
#define  MC_PHYCONTROL13_DLL_AUTO_MANUAL_UP_SHIFT 3
#define  MC_PHYCONTROL13_DLL_AUTO_MANUAL_UP_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL13_DLL_AUTO_MANUAL_UP_MASK) >> MC_PHYCONTROL13_DLL_AUTO_MANUAL_UP_SHIFT)
#define  MC_PHYCONTROL13_DLL_AUTO_MANUAL_UP_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL13_DLL_AUTO_MANUAL_UP_MASK) | (((uint32_t)val) << MC_PHYCONTROL13_DLL_AUTO_MANUAL_UP_SHIFT))

#define  MC_PHYCONTROL13_RESERVED3_MASK 0x7
#define  MC_PHYCONTROL13_RESERVED3_SHIFT 0
#define  MC_PHYCONTROL13_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL13_RESERVED3_MASK) >> MC_PHYCONTROL13_RESERVED3_SHIFT)
#define  MC_PHYCONTROL13_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL13_RESERVED3_MASK) | (((uint32_t)val) << MC_PHYCONTROL13_RESERVED3_SHIFT))

//====================================================================
//Register: PHY Control XIV (PHY_SC) (PHYControl14)
/** \brief Further configuration for the Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL14_PHYSYNCEN_MASK 0x80000000
#define  MC_PHYCONTROL14_PHYSYNCEN_SHIFT 31
#define  MC_PHYCONTROL14_PHYSYNCEN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_PHYSYNCEN_MASK) >> MC_PHYCONTROL14_PHYSYNCEN_SHIFT)
#define  MC_PHYCONTROL14_PHYSYNCEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_PHYSYNCEN_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_PHYSYNCEN_SHIFT))

#define  MC_PHYCONTROL14_DLLUPDATEEN_MASK 0x40000000
#define  MC_PHYCONTROL14_DLLUPDATEEN_SHIFT 30
#define  MC_PHYCONTROL14_DLLUPDATEEN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_DLLUPDATEEN_MASK) >> MC_PHYCONTROL14_DLLUPDATEEN_SHIFT)
#define  MC_PHYCONTROL14_DLLUPDATEEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_DLLUPDATEEN_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_DLLUPDATEEN_SHIFT))

#define  MC_PHYCONTROL14_PHYDLLRST_MASK 0x20000000
#define  MC_PHYCONTROL14_PHYDLLRST_SHIFT 29
#define  MC_PHYCONTROL14_PHYDLLRST_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_PHYDLLRST_MASK) >> MC_PHYCONTROL14_PHYDLLRST_SHIFT)
#define  MC_PHYCONTROL14_PHYDLLRST_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_PHYDLLRST_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_PHYDLLRST_SHIFT))

#define  MC_PHYCONTROL14_PHYPLLRST_MASK 0x10000000
#define  MC_PHYCONTROL14_PHYPLLRST_SHIFT 28
#define  MC_PHYCONTROL14_PHYPLLRST_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_PHYPLLRST_MASK) >> MC_PHYCONTROL14_PHYPLLRST_SHIFT)
#define  MC_PHYCONTROL14_PHYPLLRST_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_PHYPLLRST_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_PHYPLLRST_SHIFT))

#define  MC_PHYCONTROL14_RESERVED1_MASK 0xf000000
#define  MC_PHYCONTROL14_RESERVED1_SHIFT 24
#define  MC_PHYCONTROL14_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_RESERVED1_MASK) >> MC_PHYCONTROL14_RESERVED1_SHIFT)
#define  MC_PHYCONTROL14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_RESERVED1_SHIFT))

#define  MC_PHYCONTROL14_PHYCALZPR_MASK 0xf00000
#define  MC_PHYCONTROL14_PHYCALZPR_SHIFT 20
#define  MC_PHYCONTROL14_PHYCALZPR_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_PHYCALZPR_MASK) >> MC_PHYCONTROL14_PHYCALZPR_SHIFT)
#define  MC_PHYCONTROL14_PHYCALZPR_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_PHYCALZPR_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_PHYCALZPR_SHIFT))

#define  MC_PHYCONTROL14_PHYCALZNR_MASK 0xf0000
#define  MC_PHYCONTROL14_PHYCALZNR_SHIFT 16
#define  MC_PHYCONTROL14_PHYCALZNR_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_PHYCALZNR_MASK) >> MC_PHYCONTROL14_PHYCALZNR_SHIFT)
#define  MC_PHYCONTROL14_PHYCALZNR_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_PHYCALZNR_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_PHYCALZNR_SHIFT))

#define  MC_PHYCONTROL14_DLLDELAYOUT_MASK 0xff00
#define  MC_PHYCONTROL14_DLLDELAYOUT_SHIFT 8
#define  MC_PHYCONTROL14_DLLDELAYOUT_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_DLLDELAYOUT_MASK) >> MC_PHYCONTROL14_DLLDELAYOUT_SHIFT)
#define  MC_PHYCONTROL14_DLLDELAYOUT_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_DLLDELAYOUT_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_DLLDELAYOUT_SHIFT))

#define  MC_PHYCONTROL14_RESERVED2_MASK 0xc0
#define  MC_PHYCONTROL14_RESERVED2_SHIFT 6
#define  MC_PHYCONTROL14_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_RESERVED2_MASK) >> MC_PHYCONTROL14_RESERVED2_SHIFT)
#define  MC_PHYCONTROL14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_RESERVED2_SHIFT))

#define  MC_PHYCONTROL14_DLLCLKTST_MASK 0x20
#define  MC_PHYCONTROL14_DLLCLKTST_SHIFT 5
#define  MC_PHYCONTROL14_DLLCLKTST_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_DLLCLKTST_MASK) >> MC_PHYCONTROL14_DLLCLKTST_SHIFT)
#define  MC_PHYCONTROL14_DLLCLKTST_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_DLLCLKTST_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_DLLCLKTST_SHIFT))

#define  MC_PHYCONTROL14_RESERVED3_MASK 0x10
#define  MC_PHYCONTROL14_RESERVED3_SHIFT 4
#define  MC_PHYCONTROL14_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_RESERVED3_MASK) >> MC_PHYCONTROL14_RESERVED3_SHIFT)
#define  MC_PHYCONTROL14_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_RESERVED3_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_RESERVED3_SHIFT))

#define  MC_PHYCONTROL14_CALERR_MASK 0x8
#define  MC_PHYCONTROL14_CALERR_SHIFT 3
#define  MC_PHYCONTROL14_CALERR_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_CALERR_MASK) >> MC_PHYCONTROL14_CALERR_SHIFT)
#define  MC_PHYCONTROL14_CALERR_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_CALERR_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_CALERR_SHIFT))

#define  MC_PHYCONTROL14_CALLDONE_MASK 0x4
#define  MC_PHYCONTROL14_CALLDONE_SHIFT 2
#define  MC_PHYCONTROL14_CALLDONE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_CALLDONE_MASK) >> MC_PHYCONTROL14_CALLDONE_SHIFT)
#define  MC_PHYCONTROL14_CALLDONE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_CALLDONE_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_CALLDONE_SHIFT))

#define  MC_PHYCONTROL14_DLLLOCK_MASK 0x2
#define  MC_PHYCONTROL14_DLLLOCK_SHIFT 1
#define  MC_PHYCONTROL14_DLLLOCK_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_DLLLOCK_MASK) >> MC_PHYCONTROL14_DLLLOCK_SHIFT)
#define  MC_PHYCONTROL14_DLLLOCK_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_DLLLOCK_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_DLLLOCK_SHIFT))

#define  MC_PHYCONTROL14_PLLPLLLOCK_MASK 0x1
#define  MC_PHYCONTROL14_PLLPLLLOCK_SHIFT 0
#define  MC_PHYCONTROL14_PLLPLLLOCK_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL14_PLLPLLLOCK_MASK) >> MC_PHYCONTROL14_PLLPLLLOCK_SHIFT)
#define  MC_PHYCONTROL14_PLLPLLLOCK_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL14_PLLPLLLOCK_MASK) | (((uint32_t)val) << MC_PHYCONTROL14_PLLPLLLOCK_SHIFT))

//====================================================================
//Register: PHY Control XV (PHY65_SC) (PHYControl15)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL15_PHY_WL_DQS_PULSE_MASK 0x80000000
#define  MC_PHYCONTROL15_PHY_WL_DQS_PULSE_SHIFT 31
#define  MC_PHYCONTROL15_PHY_WL_DQS_PULSE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL15_PHY_WL_DQS_PULSE_MASK) >> MC_PHYCONTROL15_PHY_WL_DQS_PULSE_SHIFT)
#define  MC_PHYCONTROL15_PHY_WL_DQS_PULSE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL15_PHY_WL_DQS_PULSE_MASK) | (((uint32_t)val) << MC_PHYCONTROL15_PHY_WL_DQS_PULSE_SHIFT))

#define  MC_PHYCONTROL15_RESERVED1_MASK 0x7ffffe00
#define  MC_PHYCONTROL15_RESERVED1_SHIFT 9
#define  MC_PHYCONTROL15_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL15_RESERVED1_MASK) >> MC_PHYCONTROL15_RESERVED1_SHIFT)
#define  MC_PHYCONTROL15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL15_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL15_RESERVED1_SHIFT))

#define  MC_PHYCONTROL15_PHY_WL_DQ_OUT_MASK 0x1ff
#define  MC_PHYCONTROL15_PHY_WL_DQ_OUT_SHIFT 0
#define  MC_PHYCONTROL15_PHY_WL_DQ_OUT_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL15_PHY_WL_DQ_OUT_MASK) >> MC_PHYCONTROL15_PHY_WL_DQ_OUT_SHIFT)
#define  MC_PHYCONTROL15_PHY_WL_DQ_OUT_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL15_PHY_WL_DQ_OUT_MASK) | (((uint32_t)val) << MC_PHYCONTROL15_PHY_WL_DQ_OUT_SHIFT))

//====================================================================
//Register: PHY DLL Select (PHY65_SC) (PHYDLLSelect)
/** \brief This register selects which byte lane the PHY DLL Control register
      refers to. For example, if this register is set to 2, the PHY DLL
      Control register is accessing data for byte lane 2.*/
//====================================================================

#define  MC_PHYDLLSELECT_RESERVED1_MASK 0xffffffe0
#define  MC_PHYDLLSELECT_RESERVED1_SHIFT 5
#define  MC_PHYDLLSELECT_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYDLLSELECT_RESERVED1_MASK) >> MC_PHYDLLSELECT_RESERVED1_SHIFT)
#define  MC_PHYDLLSELECT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDLLSELECT_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYDLLSELECT_RESERVED1_SHIFT))

#define  MC_PHYDLLSELECT_DLLSELECT_MASK 0x1f
#define  MC_PHYDLLSELECT_DLLSELECT_SHIFT 0
#define  MC_PHYDLLSELECT_DLLSELECT_MASK_SHIFT(reg) (((reg) & MC_PHYDLLSELECT_DLLSELECT_MASK) >> MC_PHYDLLSELECT_DLLSELECT_SHIFT)
#define  MC_PHYDLLSELECT_DLLSELECT_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDLLSELECT_DLLSELECT_MASK) | (((uint32_t)val) << MC_PHYDLLSELECT_DLLSELECT_SHIFT))

//====================================================================
//Register: PHY DLL Control (PHY65_SC) (PHYDLLControl)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYDLLCONTROL_RESERVED1_MASK 0xfe000000
#define  MC_PHYDLLCONTROL_RESERVED1_SHIFT 25
#define  MC_PHYDLLCONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYDLLCONTROL_RESERVED1_MASK) >> MC_PHYDLLCONTROL_RESERVED1_SHIFT)
#define  MC_PHYDLLCONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDLLCONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYDLLCONTROL_RESERVED1_SHIFT))

#define  MC_PHYDLLCONTROL_DLL_DELAY_TEST_MASK 0x1ff0000
#define  MC_PHYDLLCONTROL_DLL_DELAY_TEST_SHIFT 16
#define  MC_PHYDLLCONTROL_DLL_DELAY_TEST_MASK_SHIFT(reg) (((reg) & MC_PHYDLLCONTROL_DLL_DELAY_TEST_MASK) >> MC_PHYDLLCONTROL_DLL_DELAY_TEST_SHIFT)
#define  MC_PHYDLLCONTROL_DLL_DELAY_TEST_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDLLCONTROL_DLL_DELAY_TEST_MASK) | (((uint32_t)val) << MC_PHYDLLCONTROL_DLL_DELAY_TEST_SHIFT))

#define  MC_PHYDLLCONTROL_DLL_GAIN2X_MASK 0x8000
#define  MC_PHYDLLCONTROL_DLL_GAIN2X_SHIFT 15
#define  MC_PHYDLLCONTROL_DLL_GAIN2X_MASK_SHIFT(reg) (((reg) & MC_PHYDLLCONTROL_DLL_GAIN2X_MASK) >> MC_PHYDLLCONTROL_DLL_GAIN2X_SHIFT)
#define  MC_PHYDLLCONTROL_DLL_GAIN2X_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDLLCONTROL_DLL_GAIN2X_MASK) | (((uint32_t)val) << MC_PHYDLLCONTROL_DLL_GAIN2X_SHIFT))

#define  MC_PHYDLLCONTROL_RESERVED2_MASK 0x4000
#define  MC_PHYDLLCONTROL_RESERVED2_SHIFT 14
#define  MC_PHYDLLCONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYDLLCONTROL_RESERVED2_MASK) >> MC_PHYDLLCONTROL_RESERVED2_SHIFT)
#define  MC_PHYDLLCONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDLLCONTROL_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYDLLCONTROL_RESERVED2_SHIFT))

#define  MC_PHYDLLCONTROL_DLL_PHSEL1_MASK 0x3e00
#define  MC_PHYDLLCONTROL_DLL_PHSEL1_SHIFT 9
#define  MC_PHYDLLCONTROL_DLL_PHSEL1_MASK_SHIFT(reg) (((reg) & MC_PHYDLLCONTROL_DLL_PHSEL1_MASK) >> MC_PHYDLLCONTROL_DLL_PHSEL1_SHIFT)
#define  MC_PHYDLLCONTROL_DLL_PHSEL1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDLLCONTROL_DLL_PHSEL1_MASK) | (((uint32_t)val) << MC_PHYDLLCONTROL_DLL_PHSEL1_SHIFT))

#define  MC_PHYDLLCONTROL_DLL_PHSEL0_MASK 0x1f0
#define  MC_PHYDLLCONTROL_DLL_PHSEL0_SHIFT 4
#define  MC_PHYDLLCONTROL_DLL_PHSEL0_MASK_SHIFT(reg) (((reg) & MC_PHYDLLCONTROL_DLL_PHSEL0_MASK) >> MC_PHYDLLCONTROL_DLL_PHSEL0_SHIFT)
#define  MC_PHYDLLCONTROL_DLL_PHSEL0_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDLLCONTROL_DLL_PHSEL0_MASK) | (((uint32_t)val) << MC_PHYDLLCONTROL_DLL_PHSEL0_SHIFT))

#define  MC_PHYDLLCONTROL_RESERVED3_MASK 0x8
#define  MC_PHYDLLCONTROL_RESERVED3_SHIFT 3
#define  MC_PHYDLLCONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_PHYDLLCONTROL_RESERVED3_MASK) >> MC_PHYDLLCONTROL_RESERVED3_SHIFT)
#define  MC_PHYDLLCONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDLLCONTROL_RESERVED3_MASK) | (((uint32_t)val) << MC_PHYDLLCONTROL_RESERVED3_SHIFT))

#define  MC_PHYDLLCONTROL_DLL_AUTO_UPDATE_EN_MASK 0x4
#define  MC_PHYDLLCONTROL_DLL_AUTO_UPDATE_EN_SHIFT 2
#define  MC_PHYDLLCONTROL_DLL_AUTO_UPDATE_EN_MASK_SHIFT(reg) (((reg) & MC_PHYDLLCONTROL_DLL_AUTO_UPDATE_EN_MASK) >> MC_PHYDLLCONTROL_DLL_AUTO_UPDATE_EN_SHIFT)
#define  MC_PHYDLLCONTROL_DLL_AUTO_UPDATE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDLLCONTROL_DLL_AUTO_UPDATE_EN_MASK) | (((uint32_t)val) << MC_PHYDLLCONTROL_DLL_AUTO_UPDATE_EN_SHIFT))

#define  MC_PHYDLLCONTROL_DLL_TEST_EN_MASK 0x2
#define  MC_PHYDLLCONTROL_DLL_TEST_EN_SHIFT 1
#define  MC_PHYDLLCONTROL_DLL_TEST_EN_MASK_SHIFT(reg) (((reg) & MC_PHYDLLCONTROL_DLL_TEST_EN_MASK) >> MC_PHYDLLCONTROL_DLL_TEST_EN_SHIFT)
#define  MC_PHYDLLCONTROL_DLL_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDLLCONTROL_DLL_TEST_EN_MASK) | (((uint32_t)val) << MC_PHYDLLCONTROL_DLL_TEST_EN_SHIFT))

#define  MC_PHYDLLCONTROL_DLL_BYPASS_EN_MASK 0x1
#define  MC_PHYDLLCONTROL_DLL_BYPASS_EN_SHIFT 0
#define  MC_PHYDLLCONTROL_DLL_BYPASS_EN_MASK_SHIFT(reg) (((reg) & MC_PHYDLLCONTROL_DLL_BYPASS_EN_MASK) >> MC_PHYDLLCONTROL_DLL_BYPASS_EN_SHIFT)
#define  MC_PHYDLLCONTROL_DLL_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDLLCONTROL_DLL_BYPASS_EN_MASK) | (((uint32_t)val) << MC_PHYDLLCONTROL_DLL_BYPASS_EN_SHIFT))

//====================================================================
//Register: PHY Data Byte Control (PHY65_SC) (PHYDataByteControl)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYDATABYTECONTROL_RESERVED1_MASK 0xfffff800
#define  MC_PHYDATABYTECONTROL_RESERVED1_SHIFT 11
#define  MC_PHYDATABYTECONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYDATABYTECONTROL_RESERVED1_MASK) >> MC_PHYDATABYTECONTROL_RESERVED1_SHIFT)
#define  MC_PHYDATABYTECONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDATABYTECONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYDATABYTECONTROL_RESERVED1_SHIFT))

#define  MC_PHYDATABYTECONTROL_DQPWRDWN_MASK 0x400
#define  MC_PHYDATABYTECONTROL_DQPWRDWN_SHIFT 10
#define  MC_PHYDATABYTECONTROL_DQPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYDATABYTECONTROL_DQPWRDWN_MASK) >> MC_PHYDATABYTECONTROL_DQPWRDWN_SHIFT)
#define  MC_PHYDATABYTECONTROL_DQPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDATABYTECONTROL_DQPWRDWN_MASK) | (((uint32_t)val) << MC_PHYDATABYTECONTROL_DQPWRDWN_SHIFT))

#define  MC_PHYDATABYTECONTROL_DMPWRDWN_MASK 0x200
#define  MC_PHYDATABYTECONTROL_DMPWRDWN_SHIFT 9
#define  MC_PHYDATABYTECONTROL_DMPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYDATABYTECONTROL_DMPWRDWN_MASK) >> MC_PHYDATABYTECONTROL_DMPWRDWN_SHIFT)
#define  MC_PHYDATABYTECONTROL_DMPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDATABYTECONTROL_DMPWRDWN_MASK) | (((uint32_t)val) << MC_PHYDATABYTECONTROL_DMPWRDWN_SHIFT))

#define  MC_PHYDATABYTECONTROL_QSPWRDWN_MASK 0x100
#define  MC_PHYDATABYTECONTROL_QSPWRDWN_SHIFT 8
#define  MC_PHYDATABYTECONTROL_QSPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYDATABYTECONTROL_QSPWRDWN_MASK) >> MC_PHYDATABYTECONTROL_QSPWRDWN_SHIFT)
#define  MC_PHYDATABYTECONTROL_QSPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDATABYTECONTROL_QSPWRDWN_MASK) | (((uint32_t)val) << MC_PHYDATABYTECONTROL_QSPWRDWN_SHIFT))

#define  MC_PHYDATABYTECONTROL_DQRESERVE_MASK 0xff
#define  MC_PHYDATABYTECONTROL_DQRESERVE_SHIFT 0
#define  MC_PHYDATABYTECONTROL_DQRESERVE_MASK_SHIFT(reg) (((reg) & MC_PHYDATABYTECONTROL_DQRESERVE_MASK) >> MC_PHYDATABYTECONTROL_DQRESERVE_SHIFT)
#define  MC_PHYDATABYTECONTROL_DQRESERVE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDATABYTECONTROL_DQRESERVE_MASK) | (((uint32_t)val) << MC_PHYDATABYTECONTROL_DQRESERVE_SHIFT))

//====================================================================
//Register: PHY Control XVI (PHY_SC) (PHYControl16)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL16_RESERVED1_MASK 0xffffff80
#define  MC_PHYCONTROL16_RESERVED1_SHIFT 7
#define  MC_PHYCONTROL16_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL16_RESERVED1_MASK) >> MC_PHYCONTROL16_RESERVED1_SHIFT)
#define  MC_PHYCONTROL16_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL16_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL16_RESERVED1_SHIFT))

#define  MC_PHYCONTROL16_READGAPRESETCYCLES_MASK 0x70
#define  MC_PHYCONTROL16_READGAPRESETCYCLES_SHIFT 4
#define  MC_PHYCONTROL16_READGAPRESETCYCLES_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL16_READGAPRESETCYCLES_MASK) >> MC_PHYCONTROL16_READGAPRESETCYCLES_SHIFT)
#define  MC_PHYCONTROL16_READGAPRESETCYCLES_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL16_READGAPRESETCYCLES_MASK) | (((uint32_t)val) << MC_PHYCONTROL16_READGAPRESETCYCLES_SHIFT))

#define  MC_PHYCONTROL16_RESERVED2_MASK 0xe
#define  MC_PHYCONTROL16_RESERVED2_SHIFT 1
#define  MC_PHYCONTROL16_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL16_RESERVED2_MASK) >> MC_PHYCONTROL16_RESERVED2_SHIFT)
#define  MC_PHYCONTROL16_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL16_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYCONTROL16_RESERVED2_SHIFT))

#define  MC_PHYCONTROL16_READGAPRESETEN_MASK 0x1
#define  MC_PHYCONTROL16_READGAPRESETEN_SHIFT 0
#define  MC_PHYCONTROL16_READGAPRESETEN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL16_READGAPRESETEN_MASK) >> MC_PHYCONTROL16_READGAPRESETEN_SHIFT)
#define  MC_PHYCONTROL16_READGAPRESETEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL16_READGAPRESETEN_MASK) | (((uint32_t)val) << MC_PHYCONTROL16_READGAPRESETEN_SHIFT))

//====================================================================
//Register: PHY Control XIX (PHY_SC) (PHYControl19)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL19_RESERVED1_MASK 0xff800000
#define  MC_PHYCONTROL19_RESERVED1_SHIFT 23
#define  MC_PHYCONTROL19_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL19_RESERVED1_MASK) >> MC_PHYCONTROL19_RESERVED1_SHIFT)
#define  MC_PHYCONTROL19_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL19_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL19_RESERVED1_SHIFT))

#define  MC_PHYCONTROL19_BAPWRDWN_MASK 0x700000
#define  MC_PHYCONTROL19_BAPWRDWN_SHIFT 20
#define  MC_PHYCONTROL19_BAPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL19_BAPWRDWN_MASK) >> MC_PHYCONTROL19_BAPWRDWN_SHIFT)
#define  MC_PHYCONTROL19_BAPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL19_BAPWRDWN_MASK) | (((uint32_t)val) << MC_PHYCONTROL19_BAPWRDWN_SHIFT))

#define  MC_PHYCONTROL19_RESERVED2_MASK 0xf0000
#define  MC_PHYCONTROL19_RESERVED2_SHIFT 16
#define  MC_PHYCONTROL19_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL19_RESERVED2_MASK) >> MC_PHYCONTROL19_RESERVED2_SHIFT)
#define  MC_PHYCONTROL19_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL19_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYCONTROL19_RESERVED2_SHIFT))

#define  MC_PHYCONTROL19_ADPWRDWN_MASK 0xffff
#define  MC_PHYCONTROL19_ADPWRDWN_SHIFT 0
#define  MC_PHYCONTROL19_ADPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL19_ADPWRDWN_MASK) >> MC_PHYCONTROL19_ADPWRDWN_SHIFT)
#define  MC_PHYCONTROL19_ADPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL19_ADPWRDWN_MASK) | (((uint32_t)val) << MC_PHYCONTROL19_ADPWRDWN_SHIFT))

//====================================================================
//Register: PHY Control XX (PHY_SC) (PHYControl20)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL20_RESERVED1_MASK 0xfff00000
#define  MC_PHYCONTROL20_RESERVED1_SHIFT 20
#define  MC_PHYCONTROL20_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL20_RESERVED1_MASK) >> MC_PHYCONTROL20_RESERVED1_SHIFT)
#define  MC_PHYCONTROL20_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL20_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL20_RESERVED1_SHIFT))

#define  MC_PHYCONTROL20_RESETPWRDWN_MASK 0x80000
#define  MC_PHYCONTROL20_RESETPWRDWN_SHIFT 19
#define  MC_PHYCONTROL20_RESETPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL20_RESETPWRDWN_MASK) >> MC_PHYCONTROL20_RESETPWRDWN_SHIFT)
#define  MC_PHYCONTROL20_RESETPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL20_RESETPWRDWN_MASK) | (((uint32_t)val) << MC_PHYCONTROL20_RESETPWRDWN_SHIFT))

#define  MC_PHYCONTROL20_WEPWRDWN_MASK 0x40000
#define  MC_PHYCONTROL20_WEPWRDWN_SHIFT 18
#define  MC_PHYCONTROL20_WEPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL20_WEPWRDWN_MASK) >> MC_PHYCONTROL20_WEPWRDWN_SHIFT)
#define  MC_PHYCONTROL20_WEPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL20_WEPWRDWN_MASK) | (((uint32_t)val) << MC_PHYCONTROL20_WEPWRDWN_SHIFT))

#define  MC_PHYCONTROL20_CASPWRDWN_MASK 0x20000
#define  MC_PHYCONTROL20_CASPWRDWN_SHIFT 17
#define  MC_PHYCONTROL20_CASPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL20_CASPWRDWN_MASK) >> MC_PHYCONTROL20_CASPWRDWN_SHIFT)
#define  MC_PHYCONTROL20_CASPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL20_CASPWRDWN_MASK) | (((uint32_t)val) << MC_PHYCONTROL20_CASPWRDWN_SHIFT))

#define  MC_PHYCONTROL20_RASPWRDWN_MASK 0x10000
#define  MC_PHYCONTROL20_RASPWRDWN_SHIFT 16
#define  MC_PHYCONTROL20_RASPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL20_RASPWRDWN_MASK) >> MC_PHYCONTROL20_RASPWRDWN_SHIFT)
#define  MC_PHYCONTROL20_RASPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL20_RASPWRDWN_MASK) | (((uint32_t)val) << MC_PHYCONTROL20_RASPWRDWN_SHIFT))

#define  MC_PHYCONTROL20_ODTPWRDWN_MASK 0xf000
#define  MC_PHYCONTROL20_ODTPWRDWN_SHIFT 12
#define  MC_PHYCONTROL20_ODTPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL20_ODTPWRDWN_MASK) >> MC_PHYCONTROL20_ODTPWRDWN_SHIFT)
#define  MC_PHYCONTROL20_ODTPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL20_ODTPWRDWN_MASK) | (((uint32_t)val) << MC_PHYCONTROL20_ODTPWRDWN_SHIFT))

#define  MC_PHYCONTROL20_CKEPWRDWN_MASK 0xf00
#define  MC_PHYCONTROL20_CKEPWRDWN_SHIFT 8
#define  MC_PHYCONTROL20_CKEPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL20_CKEPWRDWN_MASK) >> MC_PHYCONTROL20_CKEPWRDWN_SHIFT)
#define  MC_PHYCONTROL20_CKEPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL20_CKEPWRDWN_MASK) | (((uint32_t)val) << MC_PHYCONTROL20_CKEPWRDWN_SHIFT))

#define  MC_PHYCONTROL20_CSPWRDWN_MASK 0xf0
#define  MC_PHYCONTROL20_CSPWRDWN_SHIFT 4
#define  MC_PHYCONTROL20_CSPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL20_CSPWRDWN_MASK) >> MC_PHYCONTROL20_CSPWRDWN_SHIFT)
#define  MC_PHYCONTROL20_CSPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL20_CSPWRDWN_MASK) | (((uint32_t)val) << MC_PHYCONTROL20_CSPWRDWN_SHIFT))

#define  MC_PHYCONTROL20_CKPWRDWN_MASK 0xf
#define  MC_PHYCONTROL20_CKPWRDWN_SHIFT 0
#define  MC_PHYCONTROL20_CKPWRDWN_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL20_CKPWRDWN_MASK) >> MC_PHYCONTROL20_CKPWRDWN_SHIFT)
#define  MC_PHYCONTROL20_CKPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL20_CKPWRDWN_MASK) | (((uint32_t)val) << MC_PHYCONTROL20_CKPWRDWN_SHIFT))

//====================================================================
//Register: PHY Control XXI (PHY_SC) (PHYControl21)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL21_CKRESERVE_MASK 0xff000000
#define  MC_PHYCONTROL21_CKRESERVE_SHIFT 24
#define  MC_PHYCONTROL21_CKRESERVE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL21_CKRESERVE_MASK) >> MC_PHYCONTROL21_CKRESERVE_SHIFT)
#define  MC_PHYCONTROL21_CKRESERVE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL21_CKRESERVE_MASK) | (((uint32_t)val) << MC_PHYCONTROL21_CKRESERVE_SHIFT))

#define  MC_PHYCONTROL21_ACRESERVE_MASK 0xffffff
#define  MC_PHYCONTROL21_ACRESERVE_SHIFT 0
#define  MC_PHYCONTROL21_ACRESERVE_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL21_ACRESERVE_MASK) >> MC_PHYCONTROL21_ACRESERVE_SHIFT)
#define  MC_PHYCONTROL21_ACRESERVE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL21_ACRESERVE_MASK) | (((uint32_t)val) << MC_PHYCONTROL21_ACRESERVE_SHIFT))

//====================================================================
//Register: PHY Control XXII (PHY_SC) (PHYControl22)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYCONTROL22_RESERVED1_MASK 0xfffffffc
#define  MC_PHYCONTROL22_RESERVED1_SHIFT 2
#define  MC_PHYCONTROL22_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL22_RESERVED1_MASK) >> MC_PHYCONTROL22_RESERVED1_SHIFT)
#define  MC_PHYCONTROL22_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL22_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYCONTROL22_RESERVED1_SHIFT))

#define  MC_PHYCONTROL22_WRST_SEL_MASK 0x3
#define  MC_PHYCONTROL22_WRST_SEL_SHIFT 0
#define  MC_PHYCONTROL22_WRST_SEL_MASK_SHIFT(reg) (((reg) & MC_PHYCONTROL22_WRST_SEL_MASK) >> MC_PHYCONTROL22_WRST_SEL_SHIFT)
#define  MC_PHYCONTROL22_WRST_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYCONTROL22_WRST_SEL_MASK) | (((uint32_t)val) << MC_PHYCONTROL22_WRST_SEL_SHIFT))

//====================================================================
//Register: PHY DQS Gate Control (PHY_SC) (PHYDQSGate)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYDQSGATE_RESERVED1_MASK 0xfffff000
#define  MC_PHYDQSGATE_RESERVED1_SHIFT 12
#define  MC_PHYDQSGATE_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYDQSGATE_RESERVED1_MASK) >> MC_PHYDQSGATE_RESERVED1_SHIFT)
#define  MC_PHYDQSGATE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDQSGATE_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYDQSGATE_RESERVED1_SHIFT))

#define  MC_PHYDQSGATE_EDGE_MASK 0x800
#define  MC_PHYDQSGATE_EDGE_SHIFT 11
#define  MC_PHYDQSGATE_EDGE_MASK_SHIFT(reg) (((reg) & MC_PHYDQSGATE_EDGE_MASK) >> MC_PHYDQSGATE_EDGE_SHIFT)
#define  MC_PHYDQSGATE_EDGE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDQSGATE_EDGE_MASK) | (((uint32_t)val) << MC_PHYDQSGATE_EDGE_SHIFT))

#define  MC_PHYDQSGATE_DELAYCYCLES_MASK 0x700
#define  MC_PHYDQSGATE_DELAYCYCLES_SHIFT 8
#define  MC_PHYDQSGATE_DELAYCYCLES_MASK_SHIFT(reg) (((reg) & MC_PHYDQSGATE_DELAYCYCLES_MASK) >> MC_PHYDQSGATE_DELAYCYCLES_SHIFT)
#define  MC_PHYDQSGATE_DELAYCYCLES_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDQSGATE_DELAYCYCLES_MASK) | (((uint32_t)val) << MC_PHYDQSGATE_DELAYCYCLES_SHIFT))

#define  MC_PHYDQSGATE_DELAYTAPS_MASK 0xff
#define  MC_PHYDQSGATE_DELAYTAPS_SHIFT 0
#define  MC_PHYDQSGATE_DELAYTAPS_MASK_SHIFT(reg) (((reg) & MC_PHYDQSGATE_DELAYTAPS_MASK) >> MC_PHYDQSGATE_DELAYTAPS_SHIFT)
#define  MC_PHYDQSGATE_DELAYTAPS_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYDQSGATE_DELAYTAPS_MASK) | (((uint32_t)val) << MC_PHYDQSGATE_DELAYTAPS_SHIFT))

//====================================================================
//Register: PHY Write Level Select (PHY_SC) (PHYWriteLevelSelect)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYWRITELEVELSELECT_RESERVED1_MASK 0xffc00000
#define  MC_PHYWRITELEVELSELECT_RESERVED1_SHIFT 22
#define  MC_PHYWRITELEVELSELECT_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYWRITELEVELSELECT_RESERVED1_MASK) >> MC_PHYWRITELEVELSELECT_RESERVED1_SHIFT)
#define  MC_PHYWRITELEVELSELECT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWRITELEVELSELECT_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYWRITELEVELSELECT_RESERVED1_SHIFT))

#define  MC_PHYWRITELEVELSELECT_ACSEL_MASK 0x300000
#define  MC_PHYWRITELEVELSELECT_ACSEL_SHIFT 20
#define  MC_PHYWRITELEVELSELECT_ACSEL_MASK_SHIFT(reg) (((reg) & MC_PHYWRITELEVELSELECT_ACSEL_MASK) >> MC_PHYWRITELEVELSELECT_ACSEL_SHIFT)
#define  MC_PHYWRITELEVELSELECT_ACSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWRITELEVELSELECT_ACSEL_MASK) | (((uint32_t)val) << MC_PHYWRITELEVELSELECT_ACSEL_SHIFT))

#define  MC_PHYWRITELEVELSELECT_DQSGATEEN_MASK 0xc0000
#define  MC_PHYWRITELEVELSELECT_DQSGATEEN_SHIFT 18
#define  MC_PHYWRITELEVELSELECT_DQSGATEEN_MASK_SHIFT(reg) (((reg) & MC_PHYWRITELEVELSELECT_DQSGATEEN_MASK) >> MC_PHYWRITELEVELSELECT_DQSGATEEN_SHIFT)
#define  MC_PHYWRITELEVELSELECT_DQSGATEEN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWRITELEVELSELECT_DQSGATEEN_MASK) | (((uint32_t)val) << MC_PHYWRITELEVELSELECT_DQSGATEEN_SHIFT))

#define  MC_PHYWRITELEVELSELECT_RESERVED2_MASK 0x3f000
#define  MC_PHYWRITELEVELSELECT_RESERVED2_SHIFT 12
#define  MC_PHYWRITELEVELSELECT_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYWRITELEVELSELECT_RESERVED2_MASK) >> MC_PHYWRITELEVELSELECT_RESERVED2_SHIFT)
#define  MC_PHYWRITELEVELSELECT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWRITELEVELSELECT_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYWRITELEVELSELECT_RESERVED2_SHIFT))

#define  MC_PHYWRITELEVELSELECT_CSSEL_MASK 0xf00
#define  MC_PHYWRITELEVELSELECT_CSSEL_SHIFT 8
#define  MC_PHYWRITELEVELSELECT_CSSEL_MASK_SHIFT(reg) (((reg) & MC_PHYWRITELEVELSELECT_CSSEL_MASK) >> MC_PHYWRITELEVELSELECT_CSSEL_SHIFT)
#define  MC_PHYWRITELEVELSELECT_CSSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWRITELEVELSELECT_CSSEL_MASK) | (((uint32_t)val) << MC_PHYWRITELEVELSELECT_CSSEL_SHIFT))

#define  MC_PHYWRITELEVELSELECT_RESERVED3_MASK 0xf0
#define  MC_PHYWRITELEVELSELECT_RESERVED3_SHIFT 4
#define  MC_PHYWRITELEVELSELECT_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_PHYWRITELEVELSELECT_RESERVED3_MASK) >> MC_PHYWRITELEVELSELECT_RESERVED3_SHIFT)
#define  MC_PHYWRITELEVELSELECT_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWRITELEVELSELECT_RESERVED3_MASK) | (((uint32_t)val) << MC_PHYWRITELEVELSELECT_RESERVED3_SHIFT))

#define  MC_PHYWRITELEVELSELECT_BYTESEL_MASK 0xf
#define  MC_PHYWRITELEVELSELECT_BYTESEL_SHIFT 0
#define  MC_PHYWRITELEVELSELECT_BYTESEL_MASK_SHIFT(reg) (((reg) & MC_PHYWRITELEVELSELECT_BYTESEL_MASK) >> MC_PHYWRITELEVELSELECT_BYTESEL_SHIFT)
#define  MC_PHYWRITELEVELSELECT_BYTESEL_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWRITELEVELSELECT_BYTESEL_MASK) | (((uint32_t)val) << MC_PHYWRITELEVELSELECT_BYTESEL_SHIFT))

//====================================================================
//Register: PHY Control Register WL Control (PHY65_SC) (PHYWLControl)
/** \brief PHY Control Register Write-Leveling Control*/
//====================================================================

#define  MC_PHYWLCONTROL_RESERVED1_MASK 0xff800000
#define  MC_PHYWLCONTROL_RESERVED1_SHIFT 23
#define  MC_PHYWLCONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYWLCONTROL_RESERVED1_MASK) >> MC_PHYWLCONTROL_RESERVED1_SHIFT)
#define  MC_PHYWLCONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWLCONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYWLCONTROL_RESERVED1_SHIFT))

#define  MC_PHYWLCONTROL_PHY_WL_WCK_QS_DLY_MASK 0x7f0000
#define  MC_PHYWLCONTROL_PHY_WL_WCK_QS_DLY_SHIFT 16
#define  MC_PHYWLCONTROL_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_PHYWLCONTROL_PHY_WL_WCK_QS_DLY_MASK) >> MC_PHYWLCONTROL_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_PHYWLCONTROL_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWLCONTROL_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_PHYWLCONTROL_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_PHYWLCONTROL_RESERVED2_MASK 0xff80
#define  MC_PHYWLCONTROL_RESERVED2_SHIFT 7
#define  MC_PHYWLCONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHYWLCONTROL_RESERVED2_MASK) >> MC_PHYWLCONTROL_RESERVED2_SHIFT)
#define  MC_PHYWLCONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWLCONTROL_RESERVED2_MASK) | (((uint32_t)val) << MC_PHYWLCONTROL_RESERVED2_SHIFT))

#define  MC_PHYWLCONTROL_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_PHYWLCONTROL_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_PHYWLCONTROL_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_PHYWLCONTROL_PHY_WL_WCK_DQ_DLY_MASK) >> MC_PHYWLCONTROL_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_PHYWLCONTROL_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWLCONTROL_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_PHYWLCONTROL_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY Write Level Clock 0 (PHY_SC) (PHYWriteLevelClock0)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYWRITELEVELCLOCK0_CK_MASK 0xffffffff
#define  MC_PHYWRITELEVELCLOCK0_CK_SHIFT 0
#define  MC_PHYWRITELEVELCLOCK0_CK_MASK_SHIFT(reg) (((reg) & MC_PHYWRITELEVELCLOCK0_CK_MASK) >> MC_PHYWRITELEVELCLOCK0_CK_SHIFT)
#define  MC_PHYWRITELEVELCLOCK0_CK_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWRITELEVELCLOCK0_CK_MASK) | (((uint32_t)val) << MC_PHYWRITELEVELCLOCK0_CK_SHIFT))

//====================================================================
//Register: PHY Write Level Clock 1 (PHY_SC) (PHYWriteLevelClock1)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYWRITELEVELCLOCK1_AC_MASK 0xffffffff
#define  MC_PHYWRITELEVELCLOCK1_AC_SHIFT 0
#define  MC_PHYWRITELEVELCLOCK1_AC_MASK_SHIFT(reg) (((reg) & MC_PHYWRITELEVELCLOCK1_AC_MASK) >> MC_PHYWRITELEVELCLOCK1_AC_SHIFT)
#define  MC_PHYWRITELEVELCLOCK1_AC_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWRITELEVELCLOCK1_AC_MASK) | (((uint32_t)val) << MC_PHYWRITELEVELCLOCK1_AC_SHIFT))

//====================================================================
//Register: PHY Write Level Test Mode (PHY_SC) (PHYWriteLevelTest)
/** \brief Further configuration for the 65nm Santa Clara PHY design.*/
//====================================================================

#define  MC_PHYWRITELEVELTEST_RESERVED1_MASK 0xffffffe0
#define  MC_PHYWRITELEVELTEST_RESERVED1_SHIFT 5
#define  MC_PHYWRITELEVELTEST_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHYWRITELEVELTEST_RESERVED1_MASK) >> MC_PHYWRITELEVELTEST_RESERVED1_SHIFT)
#define  MC_PHYWRITELEVELTEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWRITELEVELTEST_RESERVED1_MASK) | (((uint32_t)val) << MC_PHYWRITELEVELTEST_RESERVED1_SHIFT))

#define  MC_PHYWRITELEVELTEST_TESTMODE_MASK 0x1f
#define  MC_PHYWRITELEVELTEST_TESTMODE_SHIFT 0
#define  MC_PHYWRITELEVELTEST_TESTMODE_MASK_SHIFT(reg) (((reg) & MC_PHYWRITELEVELTEST_TESTMODE_MASK) >> MC_PHYWRITELEVELTEST_TESTMODE_SHIFT)
#define  MC_PHYWRITELEVELTEST_TESTMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_PHYWRITELEVELTEST_TESTMODE_MASK) | (((uint32_t)val) << MC_PHYWRITELEVELTEST_TESTMODE_SHIFT))

//====================================================================
//Register: Memory Address Map Register 0 (MemAddrMap0)
/** \brief This register maps chip select 0's memory space into the 
      system's memory space.*/
//====================================================================

#define  MC_MEMADDRMAP0_STARTADDR_MASK 0xff800000
#define  MC_MEMADDRMAP0_STARTADDR_SHIFT 23
#define  MC_MEMADDRMAP0_STARTADDR_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP0_STARTADDR_MASK) >> MC_MEMADDRMAP0_STARTADDR_SHIFT)
#define  MC_MEMADDRMAP0_STARTADDR_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP0_STARTADDR_MASK) | (((uint32_t)val) << MC_MEMADDRMAP0_STARTADDR_SHIFT))

#define  MC_MEMADDRMAP0_RESERVED1_MASK 0x700000
#define  MC_MEMADDRMAP0_RESERVED1_SHIFT 20
#define  MC_MEMADDRMAP0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP0_RESERVED1_MASK) >> MC_MEMADDRMAP0_RESERVED1_SHIFT)
#define  MC_MEMADDRMAP0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP0_RESERVED1_MASK) | (((uint32_t)val) << MC_MEMADDRMAP0_RESERVED1_SHIFT))

#define  MC_MEMADDRMAP0_AREALEN_MASK 0xf0000
#define  MC_MEMADDRMAP0_AREALEN_SHIFT 16
#define  MC_MEMADDRMAP0_AREALEN_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP0_AREALEN_MASK) >> MC_MEMADDRMAP0_AREALEN_SHIFT)
#define  MC_MEMADDRMAP0_AREALEN_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP0_AREALEN_MASK) | (((uint32_t)val) << MC_MEMADDRMAP0_AREALEN_SHIFT))

#define  MC_MEMADDRMAP0_ADDRMASK_MASK 0xff80
#define  MC_MEMADDRMAP0_ADDRMASK_SHIFT 7
#define  MC_MEMADDRMAP0_ADDRMASK_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP0_ADDRMASK_MASK) >> MC_MEMADDRMAP0_ADDRMASK_SHIFT)
#define  MC_MEMADDRMAP0_ADDRMASK_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP0_ADDRMASK_MASK) | (((uint32_t)val) << MC_MEMADDRMAP0_ADDRMASK_SHIFT))

#define  MC_MEMADDRMAP0_RESERVED2_MASK 0x7e
#define  MC_MEMADDRMAP0_RESERVED2_SHIFT 1
#define  MC_MEMADDRMAP0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP0_RESERVED2_MASK) >> MC_MEMADDRMAP0_RESERVED2_SHIFT)
#define  MC_MEMADDRMAP0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP0_RESERVED2_MASK) | (((uint32_t)val) << MC_MEMADDRMAP0_RESERVED2_SHIFT))

#define  MC_MEMADDRMAP0_VALID_MASK 0x1
#define  MC_MEMADDRMAP0_VALID_SHIFT 0
#define  MC_MEMADDRMAP0_VALID_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP0_VALID_MASK) >> MC_MEMADDRMAP0_VALID_SHIFT)
#define  MC_MEMADDRMAP0_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP0_VALID_MASK) | (((uint32_t)val) << MC_MEMADDRMAP0_VALID_SHIFT))

//====================================================================
//Register: Memory Address Map Register 1 (MemAddrMap1)
/** \brief This register maps chip select 1's memory space into the 
      system's memory space.*/
//====================================================================

#define  MC_MEMADDRMAP1_STARTADDR_MASK 0xff800000
#define  MC_MEMADDRMAP1_STARTADDR_SHIFT 23
#define  MC_MEMADDRMAP1_STARTADDR_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP1_STARTADDR_MASK) >> MC_MEMADDRMAP1_STARTADDR_SHIFT)
#define  MC_MEMADDRMAP1_STARTADDR_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP1_STARTADDR_MASK) | (((uint32_t)val) << MC_MEMADDRMAP1_STARTADDR_SHIFT))

#define  MC_MEMADDRMAP1_RESERVED1_MASK 0x700000
#define  MC_MEMADDRMAP1_RESERVED1_SHIFT 20
#define  MC_MEMADDRMAP1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP1_RESERVED1_MASK) >> MC_MEMADDRMAP1_RESERVED1_SHIFT)
#define  MC_MEMADDRMAP1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP1_RESERVED1_MASK) | (((uint32_t)val) << MC_MEMADDRMAP1_RESERVED1_SHIFT))

#define  MC_MEMADDRMAP1_AREALEN_MASK 0xf0000
#define  MC_MEMADDRMAP1_AREALEN_SHIFT 16
#define  MC_MEMADDRMAP1_AREALEN_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP1_AREALEN_MASK) >> MC_MEMADDRMAP1_AREALEN_SHIFT)
#define  MC_MEMADDRMAP1_AREALEN_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP1_AREALEN_MASK) | (((uint32_t)val) << MC_MEMADDRMAP1_AREALEN_SHIFT))

#define  MC_MEMADDRMAP1_ADDRMASK_MASK 0xff80
#define  MC_MEMADDRMAP1_ADDRMASK_SHIFT 7
#define  MC_MEMADDRMAP1_ADDRMASK_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP1_ADDRMASK_MASK) >> MC_MEMADDRMAP1_ADDRMASK_SHIFT)
#define  MC_MEMADDRMAP1_ADDRMASK_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP1_ADDRMASK_MASK) | (((uint32_t)val) << MC_MEMADDRMAP1_ADDRMASK_SHIFT))

#define  MC_MEMADDRMAP1_RESERVED2_MASK 0x7e
#define  MC_MEMADDRMAP1_RESERVED2_SHIFT 1
#define  MC_MEMADDRMAP1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP1_RESERVED2_MASK) >> MC_MEMADDRMAP1_RESERVED2_SHIFT)
#define  MC_MEMADDRMAP1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP1_RESERVED2_MASK) | (((uint32_t)val) << MC_MEMADDRMAP1_RESERVED2_SHIFT))

#define  MC_MEMADDRMAP1_VALID_MASK 0x1
#define  MC_MEMADDRMAP1_VALID_SHIFT 0
#define  MC_MEMADDRMAP1_VALID_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP1_VALID_MASK) >> MC_MEMADDRMAP1_VALID_SHIFT)
#define  MC_MEMADDRMAP1_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP1_VALID_MASK) | (((uint32_t)val) << MC_MEMADDRMAP1_VALID_SHIFT))

//====================================================================
//Register: Memory Address Map Register 2 (MemAddrMap2)
/** \brief This register maps chip select 2's memory space into the 
      system's memory space.*/
//====================================================================

#define  MC_MEMADDRMAP2_STARTADDR_MASK 0xff800000
#define  MC_MEMADDRMAP2_STARTADDR_SHIFT 23
#define  MC_MEMADDRMAP2_STARTADDR_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP2_STARTADDR_MASK) >> MC_MEMADDRMAP2_STARTADDR_SHIFT)
#define  MC_MEMADDRMAP2_STARTADDR_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP2_STARTADDR_MASK) | (((uint32_t)val) << MC_MEMADDRMAP2_STARTADDR_SHIFT))

#define  MC_MEMADDRMAP2_RESERVED1_MASK 0x700000
#define  MC_MEMADDRMAP2_RESERVED1_SHIFT 20
#define  MC_MEMADDRMAP2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP2_RESERVED1_MASK) >> MC_MEMADDRMAP2_RESERVED1_SHIFT)
#define  MC_MEMADDRMAP2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP2_RESERVED1_MASK) | (((uint32_t)val) << MC_MEMADDRMAP2_RESERVED1_SHIFT))

#define  MC_MEMADDRMAP2_AREALEN_MASK 0xf0000
#define  MC_MEMADDRMAP2_AREALEN_SHIFT 16
#define  MC_MEMADDRMAP2_AREALEN_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP2_AREALEN_MASK) >> MC_MEMADDRMAP2_AREALEN_SHIFT)
#define  MC_MEMADDRMAP2_AREALEN_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP2_AREALEN_MASK) | (((uint32_t)val) << MC_MEMADDRMAP2_AREALEN_SHIFT))

#define  MC_MEMADDRMAP2_ADDRMASK_MASK 0xff80
#define  MC_MEMADDRMAP2_ADDRMASK_SHIFT 7
#define  MC_MEMADDRMAP2_ADDRMASK_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP2_ADDRMASK_MASK) >> MC_MEMADDRMAP2_ADDRMASK_SHIFT)
#define  MC_MEMADDRMAP2_ADDRMASK_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP2_ADDRMASK_MASK) | (((uint32_t)val) << MC_MEMADDRMAP2_ADDRMASK_SHIFT))

#define  MC_MEMADDRMAP2_RESERVED2_MASK 0x7e
#define  MC_MEMADDRMAP2_RESERVED2_SHIFT 1
#define  MC_MEMADDRMAP2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP2_RESERVED2_MASK) >> MC_MEMADDRMAP2_RESERVED2_SHIFT)
#define  MC_MEMADDRMAP2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP2_RESERVED2_MASK) | (((uint32_t)val) << MC_MEMADDRMAP2_RESERVED2_SHIFT))

#define  MC_MEMADDRMAP2_VALID_MASK 0x1
#define  MC_MEMADDRMAP2_VALID_SHIFT 0
#define  MC_MEMADDRMAP2_VALID_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP2_VALID_MASK) >> MC_MEMADDRMAP2_VALID_SHIFT)
#define  MC_MEMADDRMAP2_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP2_VALID_MASK) | (((uint32_t)val) << MC_MEMADDRMAP2_VALID_SHIFT))

//====================================================================
//Register: Memory Address Map Register 3 (MemAddrMap3)
/** \brief This register maps chip select 2's memory space into the 
      system's memory space.*/
//====================================================================

#define  MC_MEMADDRMAP3_STARTADDR_MASK 0xff800000
#define  MC_MEMADDRMAP3_STARTADDR_SHIFT 23
#define  MC_MEMADDRMAP3_STARTADDR_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP3_STARTADDR_MASK) >> MC_MEMADDRMAP3_STARTADDR_SHIFT)
#define  MC_MEMADDRMAP3_STARTADDR_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP3_STARTADDR_MASK) | (((uint32_t)val) << MC_MEMADDRMAP3_STARTADDR_SHIFT))

#define  MC_MEMADDRMAP3_RESERVED1_MASK 0x700000
#define  MC_MEMADDRMAP3_RESERVED1_SHIFT 20
#define  MC_MEMADDRMAP3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP3_RESERVED1_MASK) >> MC_MEMADDRMAP3_RESERVED1_SHIFT)
#define  MC_MEMADDRMAP3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP3_RESERVED1_MASK) | (((uint32_t)val) << MC_MEMADDRMAP3_RESERVED1_SHIFT))

#define  MC_MEMADDRMAP3_AREALEN_MASK 0xf0000
#define  MC_MEMADDRMAP3_AREALEN_SHIFT 16
#define  MC_MEMADDRMAP3_AREALEN_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP3_AREALEN_MASK) >> MC_MEMADDRMAP3_AREALEN_SHIFT)
#define  MC_MEMADDRMAP3_AREALEN_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP3_AREALEN_MASK) | (((uint32_t)val) << MC_MEMADDRMAP3_AREALEN_SHIFT))

#define  MC_MEMADDRMAP3_ADDRMASK_MASK 0xff80
#define  MC_MEMADDRMAP3_ADDRMASK_SHIFT 7
#define  MC_MEMADDRMAP3_ADDRMASK_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP3_ADDRMASK_MASK) >> MC_MEMADDRMAP3_ADDRMASK_SHIFT)
#define  MC_MEMADDRMAP3_ADDRMASK_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP3_ADDRMASK_MASK) | (((uint32_t)val) << MC_MEMADDRMAP3_ADDRMASK_SHIFT))

#define  MC_MEMADDRMAP3_RESERVED2_MASK 0x7e
#define  MC_MEMADDRMAP3_RESERVED2_SHIFT 1
#define  MC_MEMADDRMAP3_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP3_RESERVED2_MASK) >> MC_MEMADDRMAP3_RESERVED2_SHIFT)
#define  MC_MEMADDRMAP3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP3_RESERVED2_MASK) | (((uint32_t)val) << MC_MEMADDRMAP3_RESERVED2_SHIFT))

#define  MC_MEMADDRMAP3_VALID_MASK 0x1
#define  MC_MEMADDRMAP3_VALID_SHIFT 0
#define  MC_MEMADDRMAP3_VALID_MASK_SHIFT(reg) (((reg) & MC_MEMADDRMAP3_VALID_MASK) >> MC_MEMADDRMAP3_VALID_SHIFT)
#define  MC_MEMADDRMAP3_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_MEMADDRMAP3_VALID_MASK) | (((uint32_t)val) << MC_MEMADDRMAP3_VALID_SHIFT))

//====================================================================
//Register: User Initiated Command Register (UserCommand)
/** \brief This register provides an interface for various user initiated
      commands.*/
//====================================================================

#define  MC_USERCOMMAND_RESERVED1_MASK 0xc0000000
#define  MC_USERCOMMAND_RESERVED1_SHIFT 30
#define  MC_USERCOMMAND_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_RESERVED1_MASK) >> MC_USERCOMMAND_RESERVED1_SHIFT)
#define  MC_USERCOMMAND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_RESERVED1_MASK) | (((uint32_t)val) << MC_USERCOMMAND_RESERVED1_SHIFT))

#define  MC_USERCOMMAND_USERDPDREQ_MASK 0x30000000
#define  MC_USERCOMMAND_USERDPDREQ_SHIFT 28
#define  MC_USERCOMMAND_USERDPDREQ_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_USERDPDREQ_MASK) >> MC_USERCOMMAND_USERDPDREQ_SHIFT)
#define  MC_USERCOMMAND_USERDPDREQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_USERDPDREQ_MASK) | (((uint32_t)val) << MC_USERCOMMAND_USERDPDREQ_SHIFT))

#define  MC_USERCOMMAND_CHIPSELECT_MASK 0xf000000
#define  MC_USERCOMMAND_CHIPSELECT_SHIFT 24
#define  MC_USERCOMMAND_CHIPSELECT_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_CHIPSELECT_MASK) >> MC_USERCOMMAND_CHIPSELECT_SHIFT)
#define  MC_USERCOMMAND_CHIPSELECT_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_CHIPSELECT_MASK) | (((uint32_t)val) << MC_USERCOMMAND_CHIPSELECT_SHIFT))

#define  MC_USERCOMMAND_RESERVED2_MASK 0xffc000
#define  MC_USERCOMMAND_RESERVED2_SHIFT 14
#define  MC_USERCOMMAND_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_RESERVED2_MASK) >> MC_USERCOMMAND_RESERVED2_SHIFT)
#define  MC_USERCOMMAND_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_RESERVED2_MASK) | (((uint32_t)val) << MC_USERCOMMAND_RESERVED2_SHIFT))

#define  MC_USERCOMMAND_USERZQSHORT_MASK 0x2000
#define  MC_USERCOMMAND_USERZQSHORT_SHIFT 13
#define  MC_USERCOMMAND_USERZQSHORT_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_USERZQSHORT_MASK) >> MC_USERCOMMAND_USERZQSHORT_SHIFT)
#define  MC_USERCOMMAND_USERZQSHORT_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_USERZQSHORT_MASK) | (((uint32_t)val) << MC_USERCOMMAND_USERZQSHORT_SHIFT))

#define  MC_USERCOMMAND_USERZQLONG_MASK 0x1000
#define  MC_USERCOMMAND_USERZQLONG_SHIFT 12
#define  MC_USERCOMMAND_USERZQLONG_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_USERZQLONG_MASK) >> MC_USERCOMMAND_USERZQLONG_SHIFT)
#define  MC_USERCOMMAND_USERZQLONG_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_USERZQLONG_MASK) | (((uint32_t)val) << MC_USERCOMMAND_USERZQLONG_SHIFT))

#define  MC_USERCOMMAND_USERLMREQ3_MASK 0x800
#define  MC_USERCOMMAND_USERLMREQ3_SHIFT 11
#define  MC_USERCOMMAND_USERLMREQ3_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_USERLMREQ3_MASK) >> MC_USERCOMMAND_USERLMREQ3_SHIFT)
#define  MC_USERCOMMAND_USERLMREQ3_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_USERLMREQ3_MASK) | (((uint32_t)val) << MC_USERCOMMAND_USERLMREQ3_SHIFT))

#define  MC_USERCOMMAND_USERLMREQ2_MASK 0x400
#define  MC_USERCOMMAND_USERLMREQ2_SHIFT 10
#define  MC_USERCOMMAND_USERLMREQ2_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_USERLMREQ2_MASK) >> MC_USERCOMMAND_USERLMREQ2_SHIFT)
#define  MC_USERCOMMAND_USERLMREQ2_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_USERLMREQ2_MASK) | (((uint32_t)val) << MC_USERCOMMAND_USERLMREQ2_SHIFT))

#define  MC_USERCOMMAND_USERLMREQ1_MASK 0x200
#define  MC_USERCOMMAND_USERLMREQ1_SHIFT 9
#define  MC_USERCOMMAND_USERLMREQ1_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_USERLMREQ1_MASK) >> MC_USERCOMMAND_USERLMREQ1_SHIFT)
#define  MC_USERCOMMAND_USERLMREQ1_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_USERLMREQ1_MASK) | (((uint32_t)val) << MC_USERCOMMAND_USERLMREQ1_SHIFT))

#define  MC_USERCOMMAND_USERLMREQ0_MASK 0x100
#define  MC_USERCOMMAND_USERLMREQ0_SHIFT 8
#define  MC_USERCOMMAND_USERLMREQ0_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_USERLMREQ0_MASK) >> MC_USERCOMMAND_USERLMREQ0_SHIFT)
#define  MC_USERCOMMAND_USERLMREQ0_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_USERLMREQ0_MASK) | (((uint32_t)val) << MC_USERCOMMAND_USERLMREQ0_SHIFT))

#define  MC_USERCOMMAND_USERSRREQ_MASK 0xc0
#define  MC_USERCOMMAND_USERSRREQ_SHIFT 6
#define  MC_USERCOMMAND_USERSRREQ_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_USERSRREQ_MASK) >> MC_USERCOMMAND_USERSRREQ_SHIFT)
#define  MC_USERCOMMAND_USERSRREQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_USERSRREQ_MASK) | (((uint32_t)val) << MC_USERCOMMAND_USERSRREQ_SHIFT))

#define  MC_USERCOMMAND_RESERVED3_MASK 0x20
#define  MC_USERCOMMAND_RESERVED3_SHIFT 5
#define  MC_USERCOMMAND_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_RESERVED3_MASK) >> MC_USERCOMMAND_RESERVED3_SHIFT)
#define  MC_USERCOMMAND_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_RESERVED3_MASK) | (((uint32_t)val) << MC_USERCOMMAND_RESERVED3_SHIFT))

#define  MC_USERCOMMAND_USERPSREQ_MASK 0x10
#define  MC_USERCOMMAND_USERPSREQ_SHIFT 4
#define  MC_USERCOMMAND_USERPSREQ_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_USERPSREQ_MASK) >> MC_USERCOMMAND_USERPSREQ_SHIFT)
#define  MC_USERCOMMAND_USERPSREQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_USERPSREQ_MASK) | (((uint32_t)val) << MC_USERCOMMAND_USERPSREQ_SHIFT))

#define  MC_USERCOMMAND_RESERVED4_MASK 0xe
#define  MC_USERCOMMAND_RESERVED4_SHIFT 1
#define  MC_USERCOMMAND_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_RESERVED4_MASK) >> MC_USERCOMMAND_RESERVED4_SHIFT)
#define  MC_USERCOMMAND_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_RESERVED4_MASK) | (((uint32_t)val) << MC_USERCOMMAND_RESERVED4_SHIFT))

#define  MC_USERCOMMAND_SDRAMINIT_MASK 0x1
#define  MC_USERCOMMAND_SDRAMINIT_SHIFT 0
#define  MC_USERCOMMAND_SDRAMINIT_MASK_SHIFT(reg) (((reg) & MC_USERCOMMAND_SDRAMINIT_MASK) >> MC_USERCOMMAND_SDRAMINIT_SHIFT)
#define  MC_USERCOMMAND_SDRAMINIT_REPLACE_VAL(reg,val) (((reg) & ~MC_USERCOMMAND_SDRAMINIT_MASK) | (((uint32_t)val) << MC_USERCOMMAND_SDRAMINIT_SHIFT))

//====================================================================
//Register: DRAM Status Register (DRAMStatus)
/** \brief This register provides the status of the DRAM components.*/
//====================================================================

#define  MC_DRAMSTATUS_RESERVED1_MASK 0xfffffffe
#define  MC_DRAMSTATUS_RESERVED1_SHIFT 1
#define  MC_DRAMSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_DRAMSTATUS_RESERVED1_MASK) >> MC_DRAMSTATUS_RESERVED1_SHIFT)
#define  MC_DRAMSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAMSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MC_DRAMSTATUS_RESERVED1_SHIFT))

#define  MC_DRAMSTATUS_INITDONE_MASK 0x1
#define  MC_DRAMSTATUS_INITDONE_SHIFT 0
#define  MC_DRAMSTATUS_INITDONE_MASK_SHIFT(reg) (((reg) & MC_DRAMSTATUS_INITDONE_MASK) >> MC_DRAMSTATUS_INITDONE_SHIFT)
#define  MC_DRAMSTATUS_INITDONE_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAMSTATUS_INITDONE_MASK) | (((uint32_t)val) << MC_DRAMSTATUS_INITDONE_SHIFT))

//====================================================================
//Register: Shadow Repair Register 0 (ShdwRpr0)
//====================================================================

#define  MC_SHDWRPR0_RESERVED1_MASK 0xffffffff
#define  MC_SHDWRPR0_RESERVED1_SHIFT 0
#define  MC_SHDWRPR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SHDWRPR0_RESERVED1_MASK) >> MC_SHDWRPR0_RESERVED1_SHIFT)
#define  MC_SHDWRPR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SHDWRPR0_RESERVED1_MASK) | (((uint32_t)val) << MC_SHDWRPR0_RESERVED1_SHIFT))

//====================================================================
//Register: Shadow Repair Register 1 (ShdwRpr1)
/** \brief This register provides the CAM entry index.*/
//====================================================================

#define  MC_SHDWRPR1_RESERVED1_MASK 0xfffffff0
#define  MC_SHDWRPR1_RESERVED1_SHIFT 4
#define  MC_SHDWRPR1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SHDWRPR1_RESERVED1_MASK) >> MC_SHDWRPR1_RESERVED1_SHIFT)
#define  MC_SHDWRPR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SHDWRPR1_RESERVED1_MASK) | (((uint32_t)val) << MC_SHDWRPR1_RESERVED1_SHIFT))

#define  MC_SHDWRPR1_CAMINDEX_MASK 0xf
#define  MC_SHDWRPR1_CAMINDEX_SHIFT 0
#define  MC_SHDWRPR1_CAMINDEX_MASK_SHIFT(reg) (((reg) & MC_SHDWRPR1_CAMINDEX_MASK) >> MC_SHDWRPR1_CAMINDEX_SHIFT)
#define  MC_SHDWRPR1_CAMINDEX_REPLACE_VAL(reg,val) (((reg) & ~MC_SHDWRPR1_CAMINDEX_MASK) | (((uint32_t)val) << MC_SHDWRPR1_CAMINDEX_SHIFT))

//====================================================================
//Register: Shadow Repair Register 2 (ShdwRpr2)
/** \brief This register programs the shadow repair CAM.*/
//====================================================================

#define  MC_SHDWRPR2_RESERVED1_MASK 0xf8000000
#define  MC_SHDWRPR2_RESERVED1_SHIFT 27
#define  MC_SHDWRPR2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SHDWRPR2_RESERVED1_MASK) >> MC_SHDWRPR2_RESERVED1_SHIFT)
#define  MC_SHDWRPR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SHDWRPR2_RESERVED1_MASK) | (((uint32_t)val) << MC_SHDWRPR2_RESERVED1_SHIFT))

#define  MC_SHDWRPR2_CAMDATA_MASK 0x7fffffc
#define  MC_SHDWRPR2_CAMDATA_SHIFT 2
#define  MC_SHDWRPR2_CAMDATA_MASK_SHIFT(reg) (((reg) & MC_SHDWRPR2_CAMDATA_MASK) >> MC_SHDWRPR2_CAMDATA_SHIFT)
#define  MC_SHDWRPR2_CAMDATA_REPLACE_VAL(reg,val) (((reg) & ~MC_SHDWRPR2_CAMDATA_MASK) | (((uint32_t)val) << MC_SHDWRPR2_CAMDATA_SHIFT))

#define  MC_SHDWRPR2_RESERVED2_MASK 0x2
#define  MC_SHDWRPR2_RESERVED2_SHIFT 1
#define  MC_SHDWRPR2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_SHDWRPR2_RESERVED2_MASK) >> MC_SHDWRPR2_RESERVED2_SHIFT)
#define  MC_SHDWRPR2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_SHDWRPR2_RESERVED2_MASK) | (((uint32_t)val) << MC_SHDWRPR2_RESERVED2_SHIFT))

#define  MC_SHDWRPR2_CAMENABLE_MASK 0x1
#define  MC_SHDWRPR2_CAMENABLE_SHIFT 0
#define  MC_SHDWRPR2_CAMENABLE_MASK_SHIFT(reg) (((reg) & MC_SHDWRPR2_CAMENABLE_MASK) >> MC_SHDWRPR2_CAMENABLE_SHIFT)
#define  MC_SHDWRPR2_CAMENABLE_REPLACE_VAL(reg,val) (((reg) & ~MC_SHDWRPR2_CAMENABLE_MASK) | (((uint32_t)val) << MC_SHDWRPR2_CAMENABLE_SHIFT))

//====================================================================
//Register: Test Mode 0 Register (TestMode0)
/** \brief This register activates a command on the external DRAM bus. Before
      using this register, the command's address should be programmed into
      the Test Mode 1 Register, and the Test Mode bit (bit 0) of the SDRAM
      Control Register II should be set.*/
//====================================================================

#define  MC_TESTMODE0_RESERVED1_MASK 0xfffffff8
#define  MC_TESTMODE0_RESERVED1_SHIFT 3
#define  MC_TESTMODE0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TESTMODE0_RESERVED1_MASK) >> MC_TESTMODE0_RESERVED1_SHIFT)
#define  MC_TESTMODE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TESTMODE0_RESERVED1_MASK) | (((uint32_t)val) << MC_TESTMODE0_RESERVED1_SHIFT))

#define  MC_TESTMODE0_COMMAND_MASK 0x7
#define  MC_TESTMODE0_COMMAND_SHIFT 0
#define  MC_TESTMODE0_COMMAND_MASK_SHIFT(reg) (((reg) & MC_TESTMODE0_COMMAND_MASK) >> MC_TESTMODE0_COMMAND_SHIFT)
#define  MC_TESTMODE0_COMMAND_REPLACE_VAL(reg,val) (((reg) & ~MC_TESTMODE0_COMMAND_MASK) | (((uint32_t)val) << MC_TESTMODE0_COMMAND_SHIFT))

//====================================================================
//Register: Test Mode 1 Register (TestMode1)
/** \brief This register contains the address information for the test mode
      command. Before a test mode command is issued, the Test Mode bit
      (bit 0) of the SDRAM Control Register II should be set.*/
//====================================================================

#define  MC_TESTMODE1_RESERVED1_MASK 0xff800000
#define  MC_TESTMODE1_RESERVED1_SHIFT 23
#define  MC_TESTMODE1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TESTMODE1_RESERVED1_MASK) >> MC_TESTMODE1_RESERVED1_SHIFT)
#define  MC_TESTMODE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TESTMODE1_RESERVED1_MASK) | (((uint32_t)val) << MC_TESTMODE1_RESERVED1_SHIFT))

#define  MC_TESTMODE1_CSN2_MASK 0x400000
#define  MC_TESTMODE1_CSN2_SHIFT 22
#define  MC_TESTMODE1_CSN2_MASK_SHIFT(reg) (((reg) & MC_TESTMODE1_CSN2_MASK) >> MC_TESTMODE1_CSN2_SHIFT)
#define  MC_TESTMODE1_CSN2_REPLACE_VAL(reg,val) (((reg) & ~MC_TESTMODE1_CSN2_MASK) | (((uint32_t)val) << MC_TESTMODE1_CSN2_SHIFT))

#define  MC_TESTMODE1_CSN1_MASK 0x200000
#define  MC_TESTMODE1_CSN1_SHIFT 21
#define  MC_TESTMODE1_CSN1_MASK_SHIFT(reg) (((reg) & MC_TESTMODE1_CSN1_MASK) >> MC_TESTMODE1_CSN1_SHIFT)
#define  MC_TESTMODE1_CSN1_REPLACE_VAL(reg,val) (((reg) & ~MC_TESTMODE1_CSN1_MASK) | (((uint32_t)val) << MC_TESTMODE1_CSN1_SHIFT))

#define  MC_TESTMODE1_CSN0_MASK 0x100000
#define  MC_TESTMODE1_CSN0_SHIFT 20
#define  MC_TESTMODE1_CSN0_MASK_SHIFT(reg) (((reg) & MC_TESTMODE1_CSN0_MASK) >> MC_TESTMODE1_CSN0_SHIFT)
#define  MC_TESTMODE1_CSN0_REPLACE_VAL(reg,val) (((reg) & ~MC_TESTMODE1_CSN0_MASK) | (((uint32_t)val) << MC_TESTMODE1_CSN0_SHIFT))

#define  MC_TESTMODE1_RESERVED2_MASK 0x80000
#define  MC_TESTMODE1_RESERVED2_SHIFT 19
#define  MC_TESTMODE1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TESTMODE1_RESERVED2_MASK) >> MC_TESTMODE1_RESERVED2_SHIFT)
#define  MC_TESTMODE1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TESTMODE1_RESERVED2_MASK) | (((uint32_t)val) << MC_TESTMODE1_RESERVED2_SHIFT))

#define  MC_TESTMODE1_BANK_MASK 0x70000
#define  MC_TESTMODE1_BANK_SHIFT 16
#define  MC_TESTMODE1_BANK_MASK_SHIFT(reg) (((reg) & MC_TESTMODE1_BANK_MASK) >> MC_TESTMODE1_BANK_SHIFT)
#define  MC_TESTMODE1_BANK_REPLACE_VAL(reg,val) (((reg) & ~MC_TESTMODE1_BANK_MASK) | (((uint32_t)val) << MC_TESTMODE1_BANK_SHIFT))

#define  MC_TESTMODE1_RESERVED3_MASK 0xc000
#define  MC_TESTMODE1_RESERVED3_SHIFT 14
#define  MC_TESTMODE1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_TESTMODE1_RESERVED3_MASK) >> MC_TESTMODE1_RESERVED3_SHIFT)
#define  MC_TESTMODE1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_TESTMODE1_RESERVED3_MASK) | (((uint32_t)val) << MC_TESTMODE1_RESERVED3_SHIFT))

#define  MC_TESTMODE1_ADDRESS_MASK 0x3fff
#define  MC_TESTMODE1_ADDRESS_SHIFT 0
#define  MC_TESTMODE1_ADDRESS_MASK_SHIFT(reg) (((reg) & MC_TESTMODE1_ADDRESS_MASK) >> MC_TESTMODE1_ADDRESS_SHIFT)
#define  MC_TESTMODE1_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~MC_TESTMODE1_ADDRESS_MASK) | (((uint32_t)val) << MC_TESTMODE1_ADDRESS_SHIFT))

#endif // MC
