/*
 * (C) Copyright 2015
 * Marvell Semiconductor <www.marvell.com>
 *
 *  reset - Reset code for the G2 family of ASICs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/io.h>
#include <asm/arch/regAddrs.h>


#define TWR                 (0x0)
#define TTCR                (0x4)
#define TCR                 (0x8)

#define WDT_ENABLE          (0x80000000)
#define WDT_CONTINUOUS_MODE	(0x2)
#define WDT_TIMER_ENABLE	(0x1)


void reset_cpu(ulong addr) {
    static void __iomem *wdt_reg = AP_MPMU_MPMU_TIMERS_BASE;

	/* Set the count register to something small */
	writel(0x00000055, wdt_reg + TTCR);

	/* Set timer enable, continuous mode, 1us timebase */
	writel(WDT_TIMER_ENABLE | WDT_CONTINUOUS_MODE, wdt_reg + TCR);

	/* Enable watchdog */
	writel(WDT_ENABLE, wdt_reg + TWR);

	while (1);
#if 0
    struct TIMERS_REGS_s *ts = (struct TIMERS_REGS_s *)APB_TMR_BASE;

    ts->TWR0  = ts->TWR0 ^ 0xf;
    ts->TCR0  = 0;
    ts->TTCR0 = 1000;
    ts->TCR0  = 0x3;
    ts->TWR0  = (1 << 31) | (ts->TWR0 ^ 0xf);
#endif
}
