/*
 *  reset - Reset code for the mv61x0 ASIC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
#include <common.h>
#include <asm/arch/regAddrs.h>
#include <asm/arch/TIMERS_regmasks.h>
#include <asm/arch/TIMERS_regstructs.h>

void reset_cpu(ulong addr) {
    struct TIMERS_REGS_s *ts = (struct TIMERS_REGS_s *)APB_TMR_BASE;

    ts->TWR0  = ts->TWR0 ^ 0xf;
    ts->TCR0  = 0;
    ts->TTCR0 = 1000;
    ts->TCR0  = 0x3;
    ts->TWR0  = (1 << 31) | (ts->TWR0 ^ 0xf);
}
