#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>

typedef struct sv_tpanel_info {
	unsigned short pos_x;
	unsigned short pos_y;
	unsigned short press;
	unsigned short info;
} sv_tpanel_info_t;

typedef struct sv_ts_mas_ver_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int mjcd:8;
	unsigned int micdh:8;
	unsigned int micdl:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) sv_ts_mas_ver_cmd_t;

int main(int argc, char** argv)
{
	int rc = 0;
	int fd = 0;
	int cnt = 0;
	sv_ts_mas_ver_cmd_t ver_cmd;
	sv_tpanel_info_t info;

	printf("size of sv_ts_mas_ver_cmd_t = %d\n", sizeof(ver_cmd));

	fd = open("/dev/svtouch", O_RDWR);
	if (fd < 0) {
		rc = fd;
		goto EXIT_FUNC;
	}

	/*for (cnt = 0; cnt < 100; cnt++) {*/
	for ( ; ; ) {
		rc = read(fd, &info, sizeof(info));
		if (rc == sizeof(sv_tpanel_info_t)) {
			printf("succeed to read axys!\n");
			printf("  pos_x = %u\n", info.pos_x);
			printf("  pos_y = %u\n", info.pos_y);
			printf("  press = %u\n", info.press);
		} else {
			printf("failed to read axis with rc = %d\n", rc);
		}
	}

	close(fd);

 EXIT_FUNC:
	return rc;
}
