#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/input.h>
#include <linux/i2c.h>
#include <linux/gpio.h>
#include <linux/errno.h>
#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/module.h>
#include <linux/device.h>
#include <linux/cdev.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/timer.h>
#include <linux/platform_device.h>
#include <linux/syscalls.h>
#include <linux/clk.h>
#include <linux/slab.h>
#include <linux/workqueue.h>
#include <linux/kthread.h>
#include <asm/gpio.h>

#include "svinput.h"
#include "sv_touchpanel.h"

static int sv_pos_info_num = 0;
static int s_touchpanel_is_opened = SVINPUT_FALSE;

static DECLARE_WAIT_QUEUE_HEAD(tp_wait_queue);

static sv_tpanel_info_t cur_pos = {
	.pos_x = 0,
	.pos_y = 0,
	.press = 0,
	.info = 0,
};

void touchpanel_wqueue_handler(work_struct_t *work, svinput_slv_tp_cmd_t *slv_tp_cmd)
{
	svinput_work_t *ptr_work = NULL;

	ptr_work = (svinput_work_t*)work;

	++(ptr_work->touch_cnt);
	DPRINTK("Touch count=>%d\n", ptr_work->touch_cnt);
	cur_pos.press = (slv_tp_cmd->pres) ? 1 : 0;
	/* 押下イベントの場合にだけ座標を更新する */
	if (cur_pos.press) {
		cur_pos.pos_x = ((slv_tp_cmd->xh << 8) & 0xff00) | ((slv_tp_cmd->xl) & 0x00ff);
		cur_pos.pos_y = ((slv_tp_cmd->yh << 8) & 0xff00) | ((slv_tp_cmd->yl) & 0x00ff);
	}
	/* 誰かが開いてる時だけアップデート */
	if (s_touchpanel_is_opened) {
		sv_pos_info_num++;
		wake_up_interruptible(&tp_wait_queue);
	} else {
		sv_pos_info_num = 0;
	}

	return;
}

int touchpanel_open(struct inode *inode, struct file *file)
{
	int rc = 0;
	FUNC_START;
	s_touchpanel_is_opened = SVINPUT_TRUE;
	FUNC_END;
	return rc;
}

int touchpanel_release(struct inode *inode, struct file *file)
{
	int rc = 0;
	FUNC_START;
	s_touchpanel_is_opened = SVINPUT_FALSE;
	FUNC_END;
	return rc;
}

ssize_t touchpanel_read(struct file *file, char *buffer, size_t count, loff_t *ppos)
{
	int rc = 0;

	FUNC_START;
	wait_event_interruptible(tp_wait_queue, (sv_pos_info_num != 0));
	rc = copy_to_user(buffer, &cur_pos, sizeof(sv_tpanel_info_t));
	count = (rc == 0) ? sizeof(sv_tpanel_info_t) : 0;
	sv_pos_info_num--;
	if (sv_pos_info_num < 0) {
		sv_pos_info_num = 0;
	}
	FUNC_END;

	return count;
}
