/***** -*- C -*- **************************************
 * $Id$
 *
 * Copyright (C) 2015 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : RICOH input device driver
 *	 PROGRAM NAME	 : svinput.ko
 *	 FILE NAME		 : sv_power.h
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : Hideaki Yamamoto
 *	 AUTHOR 		 : $Author$
 *-----------------------------------------------------
 *		 HISTORY
 *	 Hideaki Yamamoto - 20 Nov 2015: Created.
 *	 $Log$
 ******************************************************/
#ifndef _SV_POWER_H_
#define _SV_POWER_H_

#include "ctlope_power.h"

typedef struct svinput_mas_lsvstat_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_lsvstat_cmd_t;

int power_open(struct inode *inode, struct file *file);
int power_release(struct inode *inode, struct file *file);
void power_probe(struct i2c_client *client, const struct i2c_device_id *idp);
int power_remove(struct i2c_client *client);
long power_ioctl(struct file *file, unsigned int cmd, unsigned long arg);
ssize_t power_read(struct file *file, char *buffer, size_t count, loff_t *ppos);
unsigned int power_poll(struct file *file, poll_table * wait);

irqreturn_t power_mtrig_isr(int irq, void *dev_id);
irqreturn_t power_opereq_isr(int irq, void *dev_id);
irqreturn_t power_scr_reboot_isr(int irq, void *dev_id);

void power_set_ucom_ver(svinput_slvl_ver_cmd_t *ucom_ver);
void power_set_boot_cmd(svinput_slv_boot_cmd_t *slv_boot);

void power_mtrig_wqueue_handler(work_struct_t *work);
void power_opereq_wqueue_handler(work_struct_t *work);
void power_scr_wqueue_handler(work_struct_t *work);
void power_or_poll_wqueue_handler(work_struct_t *work);

void power_shutdown(void);

#endif /* _SV_POWER_H_ */
