/***** -*- C -*- **************************************
 * $Id$
 *
 * Copyright (C) 2015 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : RICOH input device driver
 *	 PROGRAM NAME	 : svinput.ko
 *	 FILE NAME		 : sv_led.h
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : Hideaki Yamamoto
 *	 AUTHOR 		 : $Author$
 *-----------------------------------------------------
 *		 HISTORY
 *	 Hideaki Yamamoto - 20 Nov 2015: Created.
 *	 $Log$
 ******************************************************/
#ifndef _SV_LED_H_
#define _SV_LED_H_

#include "ctlope_led.h"

/* 全LED消灯/点灯 */
typedef struct svinput_mas_allled_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_allled_cmd_t;

/* 指定LED消灯/点灯 */
typedef struct svinput_mas_led_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int raw:8;
	unsigned int col:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_led_cmd_t;

/* 全LED点滅停止 */
typedef struct svinput_mas_allled_blink_stop_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_allled_blink_stop_cmd_t;

/* 全LED点滅開始 */
typedef struct svinput_mas_allled_blink_start_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int bt:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_allled_blink_start_cmd_t;

/* 指定LED点滅停止設定(*1) */
typedef struct svinput_mas_led_blink_stop_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int que:8;
	unsigned int raw:8;
	unsigned int col:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_led_blink_stop_cmd_t;

/* 指定LED点滅開始設定(*1) */
typedef struct svinput_mas_led_blink_start_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int que:8;
	unsigned int bt:8;
	unsigned int raw:8;
	unsigned int col:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_led_blink_start_cmd_t;

/* 保留LED点滅開始/停止 */
typedef struct svinput_mas_resv_led_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int sw:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_resv_led_cmd_t;

int led_open(struct inode *inode, struct file *file);
int led_release(struct inode *inode, struct file *file);
void led_probe(struct i2c_client *client, const struct i2c_device_id *idp);
long led_ioctl(struct file *file, unsigned int cmd, unsigned long arg);

#endif /* _SV_LED_H_ */
