#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/input.h>
#include <linux/i2c.h>
#include <linux/gpio.h>
#include <linux/errno.h>
#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/module.h>
#include <linux/device.h>
#include <linux/cdev.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/timer.h>
#include <linux/platform_device.h>
#include <linux/syscalls.h>
#include <linux/clk.h>
#include <linux/slab.h>
#include <linux/workqueue.h>
#include <linux/kthread.h>
#include <asm/gpio.h>

#include "svinput.h"
#include "sv_led.h"

static int s_led_is_opened = SVINPUT_FALSE;
static struct i2c_client *s_client = NULL;
static led_info_t s_led_info;

int led_open(struct inode *inode, struct file *file)
{
	int rc = 0;
	s_led_is_opened = SVINPUT_TRUE;
	return rc;
}

int led_release(struct inode *inode, struct file *file)
{
	int rc = 0;
	s_led_is_opened = SVINPUT_FALSE;
	return rc;
}

void led_probe(struct i2c_client *client, const struct i2c_device_id *idp)
{
	int raw = 0;
	int col = 0;

	s_client = client;

	for (raw = 0; raw < MFPOPE_LED_SCAN_MAX; raw++) {
		for (col = 0; col < MFPOPE_LED_DATA_MAX; col++) {
			s_led_info.state[col][raw] = s_led_info.bt[col][raw] = s_led_info.que[col][raw] = s_led_info.sw[col][raw] = ST_OFF;
		}
	}

	return;
}

long led_ioctl(struct file *file, unsigned int cmd, unsigned long arg)
{
	int led_stat = 0;
	int col = 0;
	int raw = 0;
	long rc = 0xffffffff;
	char recv_buf[I2C_RECV_BUF_SIZE] = {0};
	led_args_t led_args;
	svinput_mas_allled_cmd_t allled_onoff = {
		.hdr = ST1,
		.len = 0,
		/* cmd, sum */
	};
	svinput_mas_led_cmd_t led_onoff = {
		.hdr = ST1,
		.len = 2,
		/* cmd, led0, sum */
	};
	svinput_mas_allled_blink_stop_cmd_t allled_bl_stop = {
		.hdr = ST1,
		.cmd = 0x14,
		.len = 0,
		.sum = 0x14,
	};
	svinput_mas_allled_blink_start_cmd_t allled_bl_start = {
		.hdr = ST1,
		.cmd = 0x15,
		.len = 1,
		.sum = 0x16,
		/* bt, sum */
	};
	svinput_mas_led_blink_stop_cmd_t led_bl_stop = {
		.hdr = ST1,
		.cmd = 0x14,
		.len = 2,
		.sum = 0x16,
		/* que, bt, raw, col, sum */
	};
	svinput_mas_led_blink_start_cmd_t led_bl_start = {
		.hdr = ST1,
		.cmd = 0x15,
		.len = 2,
		.sum = 0x17,
		/* que, bt, raw, col, sum */
	};
#if 0
	svinput_mas_resv_led_cmd_t resv_led = {
		.hdr = ST1,
		.cmd = 0x16,
		.len = 1,
		/* sw, sum */
	};
#endif

	FUNC_START;

	if (!s_client) {
		rc = -1;
		goto EXIT_FUNC;
	}

	if ((cmd != LD_IOC_GET_LEDS_INFO) && (cmd != LD_IOC_ALL_LEDS_OFF) && (cmd != LD_IOC_ALL_LEDS_ON) &&
		(cmd != LD_IOC_ALL_LEDS_BLNK_STOP)) {
		rc = copy_from_user(&led_args, (void __user *)arg, sizeof(int));
		if (rc != 0) {
			rc = -1;
			goto EXIT_FUNC;
		}
	}

	switch (cmd) {
	/* 全LEDを消灯 or 点灯 */
	case LD_IOC_ALL_LEDS_OFF:
	case LD_IOC_ALL_LEDS_ON:
		DPRINTK(VT100_RED"%s\n"VT100_NORM, (cmd == LD_IOC_ALL_LEDS_OFF) ? "LD_IOC_ALL_LEDS_OFF" : "LD_IOC_ALL_LEDS_ON");
		allled_onoff.cmd = (cmd == LD_IOC_ALL_LEDS_OFF) ? 0x10 : 0x11;
		allled_onoff.sum = ((allled_onoff.cmd + allled_onoff.len) & 0x00ff);
		rc = i2c_master_send(s_client, (char*)(&allled_onoff), sizeof(allled_onoff));
		if (rc < 0) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		rc = i2c_master_recv(s_client, recv_buf, sizeof(recv_buf));
		if (rc < 0) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		} else {
			/*rc = (recv_buf[0] == PAK) ? 0 : -1;*/
			rc = 0;
		}
		if (rc == 0) {
			led_stat = (cmd == LD_IOC_ALL_LEDS_OFF) ? 0 : ST_ON;
			for (col = 0; col < MFPOPE_LED_DATA_MAX; col++) {
				for (raw = 0; raw < MFPOPE_LED_SCAN_MAX; raw++) {
					s_led_info.state[col][raw] = led_stat;
					s_led_info.bt[col][raw] = s_led_info.que[col][raw] = s_led_info.sw[col][raw] = 0;
				}
			}
		}
		break;
	/* 個別に指定したいLEDを消灯 or 点灯(DYNAMIC LED用) */
	case LD_IOC_DYNAMIC_LED_OFF:
	case LD_IOC_DYNAMIC_LED_ON:
		DPRINTK(VT100_RED"%s\n"VT100_NORM, (cmd == LD_IOC_DYNAMIC_LED_OFF) ? "LD_IOC_DYNAMIC_LED_OFF" : "LD_IOC_DYNAMIC_LED_ON");
		if ((led_args.ledDataNo < 0) || (led_args.ledDataNo >= MFPOPE_LED_DATA_MAX)) {
			rc = -1;
			goto EXIT_FUNC;
		}
		if ((led_args.ledScanNo < 0) || (led_args.ledScanNo >= MFPOPE_LED_SCAN_MAX)) {
			rc = -1;
			goto EXIT_FUNC;
		}
		led_onoff.cmd = (cmd == LD_IOC_DYNAMIC_LED_OFF) ? 0x10 : 0x11;
		led_onoff.raw = led_args.ledDataNo;
		led_onoff.col = led_args.ledScanNo;
		led_onoff.sum = ((led_onoff.cmd + led_onoff.len + led_onoff.raw + led_onoff.col) & 0x00ff);
		rc = i2c_master_send(s_client, (char*)(&led_onoff), sizeof(led_onoff));
		if (rc < 0) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		rc = i2c_master_recv(s_client, recv_buf, sizeof(recv_buf));
		if (rc < 0) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		} else {
			/*rc = (recv_buf[0] == PAK) ? 0 : -1;*/
			rc = 0;
		}
		if (rc == 0) {
			led_stat = (cmd == LD_IOC_DYNAMIC_LED_OFF) ? ST_OFF : ST_ON;
			s_led_info.state[led_args.ledScanNo][led_args.ledDataNo] = led_stat;
		}
		break;
	/* 全LEDの点滅を停止 */
	case LD_IOC_ALL_LEDS_BLNK_STOP:
		DPRINTK(VT100_RED"LD_IOC_ALL_LEDS_BLNK_STOP\n"VT100_NORM);
		rc = i2c_master_send(s_client, (char*)(&allled_bl_stop), sizeof(allled_bl_stop));
		if (rc < 0) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		rc = i2c_master_recv(s_client, recv_buf, sizeof(recv_buf));
		if (rc < 0) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		} else {
			/*rc = (recv_buf[0] == PAK) ? 0 : -1;*/
			rc = 0;
		}
		if (rc == 0) {
			for (col = 0; col < MFPOPE_LED_DATA_MAX; col++) {
				for (raw = 0; raw < MFPOPE_LED_SCAN_MAX; raw++) {
					s_led_info.bt[col][raw] = 0;
					s_led_info.state[col][raw] = s_led_info.que[col][raw] = s_led_info.sw[col][raw] = 0;
				}
			}
		}
		break;
	/* 全LEDの点滅を開始 */
	case LD_IOC_ALL_LEDS_BLNK_START:
		DPRINTK(VT100_RED"LD_IOC_ALL_LEDS_BLNK_START\n"VT100_NORM);
		allled_bl_start.bt = led_args.bt;
		allled_bl_start.sum = ((allled_bl_start.sum + allled_bl_start.bt) & 0x00ff);
		rc = i2c_master_send(s_client, (char*)(&allled_bl_start), sizeof(allled_bl_start));
		if (rc < 0) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		rc = i2c_master_recv(s_client, recv_buf, sizeof(recv_buf));
		if (rc < 0) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		} else {
			/*rc = (recv_buf[0] == PAK) ? 0 : -1;*/
			rc = 0;
		}
		if (rc == 0) {
			for (col = 0; col < MFPOPE_LED_DATA_MAX; col++) {
				for (raw = 0; raw < MFPOPE_LED_SCAN_MAX; raw++) {
					s_led_info.state[col][raw] = ST_BLNK;
					s_led_info.bt[col][raw] = led_args.bt;
					s_led_info.que[col][raw] = s_led_info.sw[col][raw] = 0;
				}
			}
		}
		break;
	/* 個別に指定したLEDの点滅を停止/点滅 (DYNAMIC LED用) */
	case LD_IOC_DYNAMIC_LED_BLNK_STOP:
		DPRINTK(VT100_RED"LD_IOC_DYNAMIC_LED_BLNK_STOP\n"VT100_NORM);
		if ((led_args.ledDataNo < 0) || (led_args.ledDataNo >= MFPOPE_LED_DATA_MAX)) {
			rc = -1;
			goto EXIT_FUNC;
		}
		if ((led_args.ledScanNo < 0) || (led_args.ledScanNo >= MFPOPE_LED_SCAN_MAX)) {
			rc = -1;
			goto EXIT_FUNC;
		}
		led_bl_stop.que = 0;/* 暫定でqueue無効 文句を言われたら考える */
		led_bl_stop.raw = led_args.ledDataNo;
		led_bl_stop.col = led_args.ledScanNo;
		led_bl_stop.sum = ((led_bl_stop.sum + led_bl_stop.raw + led_bl_stop.col) & 0x00ff);
		rc = i2c_master_send(s_client, (char*)(&led_bl_stop), sizeof(led_bl_stop));
		if (rc < 0) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		rc = i2c_master_recv(s_client, recv_buf, sizeof(recv_buf));
		if (rc < 0) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		} else {
			/*rc = (recv_buf[0] == PAK) ? 0 : -1;*/
			rc = 0;
		}
		if (rc == 0) {
			s_led_info.state[led_args.ledScanNo][led_args.ledDataNo] = ST_OFF;
			s_led_info.bt[led_args.ledScanNo][led_args.ledDataNo] = 0;
		}
		break;
	case LD_IOC_DYNAMIC_LED_BLNK_START:
		DPRINTK(VT100_RED"LD_IOC_DYNAMIC_LED_BLNK_START\n"VT100_NORM);
		if ((led_args.ledDataNo < 0) || (led_args.ledDataNo >= MFPOPE_LED_DATA_MAX)) {
			rc = -1;
			goto EXIT_FUNC;
		}
		if ((led_args.ledScanNo < 0) || (led_args.ledScanNo >= MFPOPE_LED_SCAN_MAX)) {
			rc = -1;
			goto EXIT_FUNC;
		}
		led_bl_start.que = 0;/* 暫定でqueue無効 文句を言われたら考える */
		led_bl_start.bt = led_args.bt;
		led_bl_start.raw = led_args.ledDataNo;
		led_bl_start.col = led_args.ledScanNo;
		led_bl_start.sum = ((led_bl_start.sum + led_bl_start.bt + led_bl_start.raw + led_bl_start.col) & 0x00ff);
		rc = i2c_master_send(s_client, (char*)(&led_bl_start), sizeof(led_bl_start));
		if (rc < 0) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		rc = i2c_master_recv(s_client, recv_buf, sizeof(recv_buf));
		if (rc < 0) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		} else {
			/*rc = (recv_buf[0] == PAK) ? 0 : -1;*/
			rc = 0;
		}
		if (rc == 0) {
			s_led_info.state[led_args.ledScanNo][led_args.ledDataNo] = ST_BLNK;
			s_led_info.bt[led_args.ledScanNo][led_args.ledDataNo] = led_args.bt;
		}
		break;
	/* 各LEDの状態取得 */
	case LD_IOC_GET_LEDS_INFO:
		DPRINTK(VT100_RED"LD_IOC_GET_LEDS_INFO\n"VT100_NORM);
		rc = copy_to_user((void __user *)arg, &s_led_info, sizeof(led_info_t));
		if (rc != 0) {
			rc = -1;
		}
		break;
	default:
		DPRINTK("Unknown command => 0x%02x\n", cmd);
		break;
	}

 EXIT_FUNC:
	FUNC_END;
	return rc;
}
