#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>

typedef unsigned short uint16_t;
typedef unsigned int uint32_t;

#include "ctlope_inputevent.h"

static const char *evt_name[] = {
	"KEY_RELEASE",
	"KEY_PUSH",
	"KEY_REPEAT",
	"KEY_SPKEY",
};

int main(int argc, char** argv)
{
	int rc = 0;
	int fd = 0;
	ope_input_event_t input_evt;

	fd = open("/dev/opeinputevent", O_RDWR);
	if (fd < 0) {
		rc = fd;
		goto EXIT_FUNC;
	}

	for ( ; ; ) {
		rc = read(fd, &input_evt, sizeof(input_evt));
		if (rc == sizeof(input_evt)) {
			printf("succeed to read keyboard!\n");
			printf("time.tv_sec=%d, time_tv_usec=%d\n", input_evt.time.tv_sec, input_evt.time.tv_usec);
			printf("type=%s\n", (input_evt.type == SV_EV_KEY) ? "SV_EV_KEY" : "SV_EV_TOUCH");
			printf("key.code=0x%04x, key.status=%s\n", input_evt.param.key.code, evt_name[input_evt.param.key.status]);
		} else {
			printf("failed to read key event with rc=%d\n", rc);
		}
	}

	close(fd);

 EXIT_FUNC:
	return rc;
}
