/***** -*- C -*- **************************************
 * $Id$
 *
 * Copyright (C) 2015 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : RICOH input device driver
 *	 PROGRAM NAME	 : svinput.ko
 *	 FILE NAME		 : sv_backlight.c
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : Hideaki Yamamoto
 *	 AUTHOR 		 : $Author$
 *-----------------------------------------------------
 *		 HISTORY
 *	 Hideaki Yamamoto - 20 Nov 2015: Created.
 *	 $Log$
 ******************************************************/
#ifndef _SV_BACKLIGHT_H_
#define _SV_BACKLIGHT_H_

#include "ctlope_backlight.h"

/* Keyboard command struct */
typedef struct svinput_mas_bl_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int onoff:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_bl_cmd_t;

int backlight_open(struct inode *inode, struct file *file);
int backlight_release(struct inode *inode, struct file *file);
void backlight_probe(struct i2c_client *client, const struct i2c_device_id *idp);
long backlight_ioctl(struct file *file, unsigned int cmd, unsigned long arg);

#endif /* _SV_BACKLIGHT_H_ */
