/***** -*- C -*- **************************************
 * $Id$
 *
 * Copyright (C) 2015 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : RICOH input device driver
 *	 PROGRAM NAME	 : svinput.ko
 *	 FILE NAME		 : ctlope_led.h
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : Hideaki Yamamoto
 *	 AUTHOR 		 : $Author$
 *-----------------------------------------------------
 *		 HISTORY
 *	 Hideaki Yamamoto - 20 Nov 2015: Created.
 *	 $Log$
 ******************************************************/
#ifndef _CTLOPE_LED_H_
#define _CTLOPE_LED_H_

#define MFPOPE_LED_DATA_MAX 6
#define MFPOPE_LED_SCAN_MAX 6

typedef struct led_args {
	unsigned char ledDataNo;
	unsigned char ledScanNo;
	unsigned char bt;
	unsigned char echo;
	unsigned char led2_DataNo;
	unsigned char led2_ScanNo;
} led_args_t;

typedef enum {
	ST_OFF = 0,
	ST_ON = 1,
	ST_BLNK = 2,
	ST_ECHO = 3,
} led_status_t;

typedef enum {
	QUE_LOW = 0x00,
	QUE_HIGH = 0x01,
	QUE_SET = 0x10,
} que_status_t;

typedef enum {
	LED_ALT_OFF = 0,
	LED_ALT_ON = 1,
} alt_status_t;

typedef enum {
	LED_SYNC_OFF = 0,
	LED_SYNC_ON = 2,
} sync_status_t;

typedef enum {
	ECO_LED_OFF = 0,
	ECO_LED_ON = 1,
} eco_led_status_t;

typedef enum {
	ECO_LED_FLG = 0x03,
	ECO_LED_TDLY = 5,
	ECO_LED_TB = 3,
	ECO_LED_BR = 2,
	ECO_LED_TL = 100,
	ECO_LED_TH = 35,
	ECO_LED_BRL = 8,
	ECO_LED_BRH = 100,
	LED_NO_ECHO = 0x80,
} eco_led_args_t;

typedef struct led_info {
	unsigned char state[MFPOPE_LED_SCAN_MAX][MFPOPE_LED_DATA_MAX];
	unsigned char bt[MFPOPE_LED_SCAN_MAX][MFPOPE_LED_DATA_MAX];
	unsigned char que[MFPOPE_LED_SCAN_MAX][MFPOPE_LED_DATA_MAX];
	unsigned char sw[MFPOPE_LED_SCAN_MAX][MFPOPE_LED_DATA_MAX];
} led_info_t;

#define LD_IOC_ALL_LEDS_OFF _IO(0xe6, 0x04)
#define LD_IOC_ALL_LEDS_ON _IO(0xe6, 0x05)
#define LD_IOC_DYNAMIC_LED_OFF _IOW(0xe6, 0x06, led_args_t)
#define LD_IOC_DYNAMIC_LED_ON _IOW(0xe6, 0x07, led_args_t)
#define LD_IOC_ALL_LEDS_BLNK_STOP _IO(0xe6, 0x08)
#define LD_IOC_ALL_LEDS_BLNK_START _IOW(0xe6, 0x09, led_args_t)
/*#define LD_IOC_ALT_LEDS_BLNK_STOP _IOW(0xe6, 0x0a, led_args_t)*/
/*#define LD_IOC_ALT_LEDS_BLNK_START _IOW(0xe6, 0x0b, led_args_t)*/
#define LD_IOC_DYNAMIC_LED_BLNK_STOP _IOW(0xe6, 0x0c, led_args_t)
#define LD_IOC_DYNAMIC_LED_BLNK_START _IOW(0xe6, 0x0d, led_args_t)
/*#define LD_IOC_SYNC_LEDS_BLNK_STOP _IO(0xe6, 0x0e)*/
/*#define LD_IOC_SYNC_LEDS_BLNK_START _IOW(0xe6, 0x0f, led_args_t)*/
#define LD_IOC_GET_LEDS_INFO _IOR(0xe6, 0x10, led_info_t)

#endif /* _CTLOPE_LED_H_ */
