#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <string.h>
#include <errno.h>  

#include "ctlope_backlight.h"

/**
   #define BL_IOC_ON _IO(0xe6, 0x02)
   #define BL_IOC_OFF _IO(0xe6, 0x03)
*/

int main(int argc, char **argv)
{
	int cmd = 0;
	int fd = 0;
	int errnum = 0;
	int rc = 0;

	if (argc == 2) {
		cmd = strtol(argv[1], NULL, 10);
	} else {
		printf("Invalid argument...\n");
		rc = -1;
		goto EXIT_FUNC;
	}

	fd = open("/dev/opebacklight", O_RDWR);
	if (fd < 0) {
		rc = -2;
		printf("Can't open device special...\n");
		goto EXIT_FUNC;
	}

	switch (cmd) {
	case 2:/* 0x02 */
		if (argc == 2) {
			rc = ioctl(fd, BL_IOC_ON);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 3:/* 0x03 */
		if (argc == 2) {
			rc = ioctl(fd, BL_IOC_OFF);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	default:
		printf("Invalid command %d\n", cmd);
		rc = -1;
		break;
	}

	close(fd);

 EXIT_FUNC:
	return rc;
}
