/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/

/**
 * \file stepper-api.h
*/

#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/slab.h>
#include <linux/device.h>
#include <linux/platform_device.h>
#include <linux/kfifo.h>
#include <linux/mutex.h>
#include <linux/semaphore.h>
#include <linux/kernel.h>
#include <linux/of_device.h>
#include <linux/kthread.h>

#include <asm/io.h>
#include <asm/irq.h>
#include <asm/mach/irq.h>
#include <asm/gpio.h>

#include "stepper-api.h"

void trig_state_const(stmotor_t *motor_handle, void *cb_user_data)
{
    printk("Got the constant trigger%x\n", cb_user_data);
}
void trig_pos(stmotor_t *motor_handle, void *cb_user_data)
{
    printk("Got the position trigger%x\n", cb_user_data);
}

void trig_state_accel(stmotor_t *motor_handle, void *cb_user_data)
{
    printk("Got the accel trigger%x\n", cb_user_data);
}
void trig_state_stop(stmotor_t *motor_handle, void *cb_user_data)
{
    printk("Got the stop trigger%x\n", cb_user_data);
}
void trig_state_stopped(stmotor_t *motor_handle, void *cb_user_data)
{
    printk("Got the stopped trigger%x\n", cb_user_data);
}
void trig_state_deacl(stmotor_t *motor_handle, void *cb_user_data)
{
    printk("Got the deacl trigger%x\n", cb_user_data);
}
void trig_state_velocity(stmotor_t *motor_handle, void *cb_user_data)
{
    printk("Got the velocity trigger%x\n", cb_user_data);
}

void run_test(void)
{
    int i;
    stmotor_pin_connect_t pin_connect;
    stmotor_pin_sequence_t pin_seq;
    stmotor_t *handle;
    stmotor_TVT_t fb_300M_tvt;   
    uint32_t fb_accel8u_300M[200] = {
        270,267,265,262,260,257,255,253,250,248,245,243,241,238,236,234,232,230,227,225,
        223,221,219,217,215,213,211,209,207,205,203,201,199,197,195,193,191,190,188,186,
        184,182,181,179,177,176,174,172,171,169,167,166,164,163,161,160,158,157,155,154,
        152,151,149,148,146,145,144,142,141,140,138,137,136,134,133,132,131,129,128,127,
        126,125,123,122,121,120,119,118,116,115,114,113,112,111,110,109,108,107,106,105,
        104,103,102,101,100,99,98,97,96,95,94,93,93,92,91,90,89,88,87,87,
        86,85,84,83,83,82,81,80,79,79,78,77,76,76,75,74,74,73,72,72,
        71,70,70,69,68,68,67,66,66,65,64,64,63,63,62,61,61,60,60,59,
        59,58,57,57,56,56,55,55,54,54,53,53,52,52,51,51,50,50,49,49,
        48,48,47,47,47,46,46,45,45,44,44,44,43,43,42,42,42,41,41,40};

    stmotor_move_param_t motor_entry = {ACCEL_PWM_M, 58, 64, 64, &fb_300M_tvt, 200, fb_accel8u_300M};
    for (i = 0; i < 9; i++)
    {
        fb_300M_tvt.tvt[i] = 1000;
    }
    memset(&pin_connect, 0, sizeof(pin_connect));
    pin_connect.block_num = 1;      // y motor
    pin_connect.pin_cfg[0] = STEP_OUTPUT_MODE_SEQ;  // 4
    pin_connect.pin_cfg[1] = STEP_OUTPUT_MODE_REG0;  // 2
    pin_connect.pin_cfg[2] = STEP_OUTPUT_MODE_SEQ;   // 4
    pin_connect.pin_cfg[3] = STEP_OUTPUT_MODE_REG1;  // 3
    pin_connect.pin_cfg[4] = STEP_OUTPUT_MODE_REG0;  // 2

    memset(&pin_seq, 0, sizeof(pin_seq));
    pin_seq.pin_seq[0] = 0x88888888;

    handle = smot_step_create_motor(&pin_connect, &pin_seq, 8);
    if (!handle)
    {
        return;
    }
    smot_step_set_motor_move_params(handle, &motor_entry);
   // smot_step_set_speed(handle, 200);
    smot_step_add_trigger(handle, TRIG_POSITION, 2500, trig_pos, 0x321);
    smot_step_add_trigger(handle, TRIG_STATE, MOTOR_CONSTANT, trig_state_const,0x123);
    smot_step_add_trigger(handle, TRIG_MOTOR_START, MOTOR_ACCEL, trig_state_accel,0x124);
    smot_step_add_trigger(handle, TRIG_STATE, MOTOR_DECEL, trig_state_deacl,0x125);
    smot_step_add_trigger(handle, TRIG_STATE, MOTOR_STOPPED, trig_state_stop,0x126);
    smot_step_add_trigger(handle, TRIG_VELOCITY, 40, trig_state_velocity, 0x127);
    smot_step_set_motor_deaccl_table(handle, 150, fb_accel8u_300M);
    smot_step_move_rel(handle, 20000, MOT_REVERSE, false, 0);
 //   sleep(10);
}



static int __init stepper_init(void)
{
    run_test();
    return 0;
}


static void __exit stepper_platform_exit(void)
{
    printk(KERN_ERR "%s: driver platform init begun\n", __func__);

    printk(KERN_ERR "stepper:  platform remove complete\n");
}

module_exit(stepper_platform_exit);

module_init(stepper_init);

MODULE_AUTHOR("Copyright (c) 2015 Marvell International Ltd. All Rights Reserved");
MODULE_DESCRIPTION("Marvell Scan Stepper Driver");

MODULE_LICENSE("GPL");
MODULE_VERSION("2015_May_4");
