/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2004-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/

/**
 * \file stepper.h
 *
 * \brief Internal header file for stepper motor driver
 *
 *  Internal data types and functions for the stepper motor driver, things
 *  that are not part of the external API.
 *
 */

#include "stepper-api.h"

#ifndef INC_STEPPER_H
#define INC_STEPPER_H


// Stepper motor commmand packet
typedef struct {
    uint32_t  pwm_m;
    uint32_t  pwm_p;
    uint8_t   acc_incr;
    uint16_t  st_tgt;
    uint8_t   inf;
    uint8_t   ls_en;
    uint8_t   dir;
    uint8_t   acc_dir;
    uint8_t   cmd;
    uint8_t   issue;
} stepper_cmd_packet_t;


// Motor trigger settings (one is stored for each motor)
typedef struct stmotor_trigger_s
{
    stmotor_trigger_cond_t type;
    uint32_t               param;
    TriggerCbFuncPtr       callback;
    void                  *cb_user_data;
} stmotor_trigger_t;


// Collection of motor parameters and state for each instantiated motor.
typedef struct stmotor_params_s
{
    bool               created;             // Motor created for this block

    /* Settings from the platform */
    volatile void    *motor_regs;           // Stepper motor control registers (rev unknown)
    stmotor_block_id_t block_num;           // ASIC motor block number
    uint32_t          irq_num;              // ASIC irq number
    int               nEnableSrc;           // ASIC nEnable Pin Source/Mode

    /* Configured motor parameters */
    uint32_t         *accel_table;          // Accel table pointer set by motor params
    uint32_t          accel_table_entries;  // Number of values in the accel_table
    stmotor_accel_t   accel_select;         // Accel method set by motor params
    uint16_t          preholding_steps;
    uint16_t          postholding_steps;
    int               max_index;            // Max allowed accel index (speed limiter)

    /* Motor state variables */
    bool              motor_running;        // Motor running (yes/no)
    bool              motor_active;         // Motor block enabled (yes/no)
    stmotor_state_t   motor_state;
    uint32_t          ref_position;         // Tracks mech reference position

    /* Current move variables */
    int               cur_index;            // Current accel index
    uint32_t          pending_steps;        // Pending steps
    uint8_t           direction;            // Direction
    bool              ls_requested;         // Line start pulses requested
    uint32_t          enable_ls_at_stepnum; // Turn on ls at step number
    stmotor_trigger_t trigger;              // Trigger for current move
    stepper_cmd_packet_t  cmd_packet;       // Command packet

} stmotor_params_t;


// Used by platform code to tear down driver
void step_remove_motor(stmotor_block_id_t block_num);


#endif // INC_STEPPER_H

