/*
 ******************************************************************************
 * Copyright (c) 2011 Marvell International, Ltd. All Rights Reserved
 *
 *                         Marvell Confidential
 ******************************************************************************
 *
 *
 *  Portions of this may contain copyrighted or confidential materials from
 *  Marvell and/or Marvell's suppliers. Copying and distribution of such
 *  materials for any other purpose except in conjunction with a Marvell
 *  Product, is expressly prohibited.
 *   
 *  DISCLAIMER OF WARRANTIES. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE
 *  LAW, THE SOURCE CODE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
 *  MARVELL AND ITS SUPPLIERS DISCLAIM ANY WARRANTY OR OBLIGATION TO PROVIDE
 *  SUPPORT, UPDATES OR BUG FIXES FOR THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTY AS TO THE ACCURACY, SUFFICIENCY OR SUITABILITY
 *  FOR ANY PURPOSES WHAT-SO-EVER OF THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTIES OR REPRE-SENTATIONS HEREUNDER, WHETHER
 *  EXPRESS OR IMPLIED, EITHER IN FACT OR BY OPERATION OF LAW, STATUTORY OR
 *  OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES, TERMS OR CONDITIONS
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, SATISFACTORY QUALITY,
 *  CORRESPONDENCE WITH DESCRIPTION, QUIET ENJOYMENT OR NON-INFRINGEMENT OF
 *  THIRD PARTY INTELLECTUAL PROPERTY RIGHTS.
 *  
 ******************************************************************************
*/

#ifndef _UPC_TEST_H_
#define _UPC_TEST_H_

#include "Xena.h"
#include "regAddrs.h"
#include "SIC_regheaders.h"
#include "uart_regheaders.h"

volatile XENA_REGS_t    *upcRegs;
volatile SIC_REGS_t     *sic1Regs;
volatile UART_REGS_t    *uart3Regs;

#define UART3_IRQ       0x02
#define SIC1_FIQ        0x80000000

#define IO_RESET        0
#define IO_SET          1
#define IO_LOW          0
#define IO_HIGH         1
#define IO_OFF          0
#define IO_ON           1
#define IO_DISABLE      0
#define IO_ENABLE       1
#define IO_NOT_LOCK     0
#define IO_LOCK         1
#define IO_NML          0
#define IO_ERROR        1
#define IO_CW           0
#define IO_CCW          1
#define IO_HOLD         0
#define IO_STEP         1
#define IO_ACC_AUTO     2
#define IO_ACC          0
#define IO_DEC          1
#define IO_RX_NOT_READY 0
#define IO_RX_READY     1
#define IO_TX_BUSY      0
#define IO_TX_EMPTY     1

#define THR_EMP_INT     0x2
#define RX_AVAIL_INT    0x4
#define LST_CHNG_INT    0x6
#define TIME_OUT_INT    0xC
#define MODEM_INT       0x0
#define BUSY_DET_INT    0x7
#define NON_INT         0x1

#endif // _UPC_TEST_H_

