/*
 ******************************************************************************
 * Copyright (c) 2011 Marvell International, Ltd. All Rights Reserved
 *
 *                         Marvell Confidential
 ******************************************************************************
 *
 *
 *  Portions of this may contain copyrighted or confidential materials from
 *  Marvell and/or Marvell's suppliers. Copying and distribution of such
 *  materials for any other purpose except in conjunction with a Marvell
 *  Product, is expressly prohibited.
 *   
 *  DISCLAIMER OF WARRANTIES. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE
 *  LAW, THE SOURCE CODE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
 *  MARVELL AND ITS SUPPLIERS DISCLAIM ANY WARRANTY OR OBLIGATION TO PROVIDE
 *  SUPPORT, UPDATES OR BUG FIXES FOR THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTY AS TO THE ACCURACY, SUFFICIENCY OR SUITABILITY
 *  FOR ANY PURPOSES WHAT-SO-EVER OF THE SOURCE CODE. NEITHER MARVELL NOR ITS
 *  SUPPLIERS MAKE ANY WARRANTIES OR REPRE-SENTATIONS HEREUNDER, WHETHER
 *  EXPRESS OR IMPLIED, EITHER IN FACT OR BY OPERATION OF LAW, STATUTORY OR
 *  OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES, TERMS OR CONDITIONS
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, SATISFACTORY QUALITY,
 *  CORRESPONDENCE WITH DESCRIPTION, QUIET ENJOYMENT OR NON-INFRINGEMENT OF
 *  THIRD PARTY INTELLECTUAL PROPERTY RIGHTS.
 *  
 ******************************************************************************
*/

#include <stdint.h>

#define UART0_THR ((volatile unsigned char *)0xF8060000)
#define UART0_LSR ((volatile unsigned char *)0xF8060014)

void print(const char *s)
{
#ifdef UART
    while(*s) {
        // Wait THRE=1
        while(((*UART0_LSR) & 0x20) == 0);
        *UART0_THR = *s++;
    }

    // Wait for TDRE
    while(((*UART0_LSR) & 0x40) == 0);
#endif
}

void printh(uint32_t val)
{
#ifdef UART
  int i;

  print("0x");

  for(i = 0; i < 8; i++) {
    switch((val >> (28 - (i * 4))) & 0x0F) {
      case  0: print("0"); break;
      case  1: print("1"); break;
      case  2: print("2"); break;
      case  3: print("3"); break;
      case  4: print("4"); break;
      case  5: print("5"); break;
      case  6: print("6"); break;
      case  7: print("7"); break;
      case  8: print("8"); break;
      case  9: print("9"); break;
      case 10: print("a"); break;
      case 11: print("b"); break;
      case 12: print("c"); break;
      case 13: print("d"); break;
      case 14: print("e"); break;
      case 15: print("f"); break;
    }
  }
#endif
}

