#!/bin/bash

# ******************************************************************************
# * Copyright (c) 2011 Marvell International, Ltd. All Rights Reserved
# *
# *                         Marvell Confidential
# ******************************************************************************
# *
# *  Portions of this may contain copyrighted or confidential materials from
# *  Marvell and/or Marvell's suppliers. Copying and distribution of such
# *  materials for any other purpose except in conjunction with a Marvell
# *  Product, is expressly prohibited.
# *   
# *  DISCLAIMER OF WARRANTIES. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE
# *  LAW, THE SOURCE CODE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
# *  MARVELL AND ITS SUPPLIERS DISCLAIM ANY WARRANTY OR OBLIGATION TO PROVIDE
# *  SUPPORT, UPDATES OR BUG FIXES FOR THE SOURCE CODE. NEITHER MARVELL NOR ITS
# *  SUPPLIERS MAKE ANY WARRANTY AS TO THE ACCURACY, SUFFICIENCY OR SUITABILITY
# *  FOR ANY PURPOSES WHAT-SO-EVER OF THE SOURCE CODE. NEITHER MARVELL NOR ITS
# *  SUPPLIERS MAKE ANY WARRANTIES OR REPRE-SENTATIONS HEREUNDER, WHETHER
# *  EXPRESS OR IMPLIED, EITHER IN FACT OR BY OPERATION OF LAW, STATUTORY OR
# *  OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES, TERMS OR CONDITIONS
# *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, SATISFACTORY QUALITY,
# *  CORRESPONDENCE WITH DESCRIPTION, QUIET ENJOYMENT OR NON-INFRINGEMENT OF
# *  THIRD PARTY INTELLECTUAL PROPERTY RIGHTS.
# *  
# ******************************************************************************

function errortest()
{
   if test "$1" = ""
   then
      echo "ERROR: variable ----> $2 <---- is not set"
                echo ""
                echo "please call $0 from the appropriate script"
      echo "exiting now"
      exit 1
   fi
}
errortest "$PRJROOT" "PRJROOT"
errortest "$MV_TOOLS_PATH" "MV_TOOLS_PATH"
errortest "$COMPILER_PATH_PREFIX" "COMPILER_PATH_PREFIX"
# CONF_ARCH should be set to which ASIC
errortest "$CONF_ARCH" "CONF_ARCH"
# CONF_VERSION should be set to version of the ASIC
errortest "$CONF_VER" "CONF_VER"

# use the linux compiler and include files for tools in applications space!
export LINUX_INCPATH=-I${MV_TOOLS_PATH}/libc/usr/include/

# use the bare metal (eabi) compiler and include files for all UPC builds!
export INCPATH=-I/opt/arm-marvell-gcc/arm-marvell-eabi/include
export LIBPATH=/opt/arm-marvell-gcc/lib/gcc/arm-marvell-eabi/4.2.0

export IOCTLPATH=-I${PRJROOT}/linux-mrvl/arch/arm/mach-gogin/userspace

# use the linux ASIC include files for upc-resident processes!
export ASICPATH=-I${PRJROOT}/linux-mrvl/arch/arm/mach-gogin/include/asic

export UPC=-mcpu=marvell-f
export IO_DATA=0x0401E000
export FM_DATA=0x0401EA00

# first, build any UPC tools, utilities, etc...
arm-marvell-eabi-as  ${UPC} -g -mlittle-endian -o preboot_fm.o preboot_fm.s
arm-marvell-eabi-as  ${UPC} -g -mlittle-endian -o preboot_io.o preboot_io.s

arm-marvell-eabi-gcc ${UPC} -g -mlittle-endian -Wall -DCPU_FREQ=529 -DUART -c -Os -o dbg_printf.o dbg_printf.c

arm-marvell-eabi-gcc ${UPC} -g -mlittle-endian -Wall -DCPU_FREQ=529 -DUART  ${INCPATH} -c -Os -o upctalk0.o upctalk0.c
arm-marvell-eabi-gcc ${UPC} -g -mlittle-endian -Wall -DCPU_FREQ=529 -DUART  ${INCPATH} -c -Os -o upctalk1.o upctalk1.c

arm-marvell-eabi-gcc ${UPC} -g -mlittle-endian -Wall -DCPU_FREQ=529 -DUART -D${CONF_ARCH} -D${CONF_VER} ${INCPATH} ${ASICPATH} -c -Os -o upc_uart.o upc_uart.c
arm-marvell-eabi-gcc ${UPC} -g -mlittle-endian -Wall -DCPU_FREQ=529        -D${CONF_ARCH} -D${CONF_VER} ${INCPATH} ${ASICPATH} -c -Os -o upc_wait.o upc_wait.c

arm-marvell-eabi-ld -L ${LIBPATH} --print-map -entry=0x0 -Ttext 0x0 -Tdata ${IO_DATA} -Tbss ${IO_DATA} -EL -o upctalk0.elf preboot_io.o upctalk0.o dbg_printf.o > upctalk0.map
arm-marvell-eabi-ld -L ${LIBPATH} --print-map -entry=0x0 -Ttext 0x0 -Tdata ${FM_DATA} -Tbss ${FM_DATA} -EL -o upctalk1.elf preboot_fm.o upctalk1.o dbg_printf.o > upctalk1.map

arm-marvell-eabi-ld -L ${LIBPATH} --print-map -entry=0x0 -Ttext 0x0 -Tdata ${IO_DATA} -Tbss ${IO_DATA} -EL -o upc_uart.elf preboot_io.o upc_uart.o dbg_printf.o > upc_uart.map
arm-marvell-eabi-ld -L ${LIBPATH} --print-map -entry=0x0 -Ttext 0x0 -Tdata ${FM_DATA} -Tbss ${FM_DATA} -EL -o upc_wait.elf preboot_fm.o upc_wait.o > upc_wait.map

arm-marvell-eabi-objdump -S upctalk0.elf --source > upctalk0.dump
arm-marvell-eabi-objdump -S upctalk1.elf --source > upctalk1.dump

arm-marvell-eabi-objdump -S upc_uart.elf --source > upc_uart.dump
arm-marvell-eabi-objdump -S upc_wait.elf --source > upc_wait.dump

arm-marvell-eabi-objcopy -O binary upctalk0.elf upctalk0.bin
arm-marvell-eabi-objcopy -O binary upctalk1.elf upctalk1.bin

arm-marvell-eabi-objcopy -O binary upc_uart.elf upc_uart.bin
arm-marvell-eabi-objcopy -O binary upc_wait.elf upc_wait.bin

# second, build any application space tools, etc...
${COMPILER_PATH_PREFIX}gcc ${LINUX_INCPATH} ${IOCTLPATH} -mlittle-endian -Wall upc_start_stop.c -o upc_start_stop

# finish up by copying all binaries to the product root_fs...
mkdir -p ${PRJROOT}/root_fs/tools
mv upc_uart.bin upc_wait.bin upctalk1.bin upctalk0.bin upc_start_stop ${PRJROOT}/root_fs/tools

# add any build clean-up stuff here...
rm *.o
