/*======================================================================*
 *  
 *----------------------------------------------------------------------*/
#define  TMP_USB_GATING
#define  ENABLE_ECO_AVS

/*======================================================================*
 *  Include Files
 *----------------------------------------------------------------------*/
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/cdev.h>
//#include <linux/irqreturn.h>
//#include <linux/interrupt.h>
#include <linux/io.h>
#include <linux/gpio.h>
#include <linux/uaccess.h>
#include <linux/types.h>
#include <linux/clk-private.h>
#include <linux/clk.h>
#include <linux/clk-provider.h>
#include <linux/delay.h>

#include <linux/of.h>
#include <linux/of_address.h>

#include <linux/device.h>
//#include <linux/platform_device.h>


#include "simva.h"

#include <linux/usb.h>
#include <linux/usb/hcd.h>

/* bugfix:usb device power */
#include <linux/workqueue.h> 

/* XXX */
//extern int  ehci_setup(struct usb_hcd *hcd);
//extern struct usb_hcd  *simva_host_cd;

/*======================================================================*
 *  Macros
 *----------------------------------------------------------------------*/
#define  SIMVA_ENABLE		(1)
#define  SIMVA_DISABLE		(0)

#define  SIMVA_OPE_4LINE	(0)
#define  SIMVA_OPE_PUMBAA	(1)
#define  SIMVA_OPE_CHEETAH	(2)

#define  SIMVA_USB2			(0)
#define  SIMVA_USB3			(1)

/*  sram power control register address  */
/*  apmu_base points 0xD063_0000 physically  */
//#define  PCIe_dm4_SRAMPdwn_SPCTL (apmu_base+0x80)
#define  usb3d_SRAMPdwn_SPCTL    (apmu_base+0xa4)
#define  usbdm_SRAMPdwn_SPCTL    (apmu_base+0xc0)
#define  usbh_SRAMPdwn_SPCTL     (apmu_base+0xc8)
/*  sram power control register address. these are set to lowleakage mode in module load  */
#define  lcd_SRAMPdwn_SPCTL      (apmu_base+0xd0)
#define  SATA_SRAMPdwn_SPCTL     (apmu_base+0x68)
#define  PCIe_dm2_SRAMPdwn_SPCTL (apmu_base+0x74)
#define  PCIe_dm4_SRAMPdwn_SPCTL (apmu_base+0x80)
#define  usb3d_SRAMPdwn_SPCTL    (apmu_base+0xa4)
#define  MC5_SRAMSpeedCtl_SRAMCTL (apmu_base+0x108)

/*  sram in IPMU  */
#define  UPCSRAMPdwn_SPCTL       (ipmu_misc_base+0x10)
#define  PIPSRAMPdwn_SPCTL       (ipmu_misc_base+0x18)
#define  JBIGSRAMPdwn_SPCTL      (ipmu_misc_base+0x28)
#define  JPEGSRAMPdwn_SPCTL      (ipmu_misc_base+0x30)
#define  ICESRAMPdwn_SPCTL       (ipmu_misc_base+0x38)
#define  ROTSRAMPdwn_SPCTL       (ipmu_misc_base+0x54)

/*  avs control register address  */
#define  AVS_CONTROL             (mpmu_base+0x6000)

#define POW_LED_GPIO1_NO (149)
#define POW_LED_GPIO2_NO (203)

/*======================================================================*
 *  Types
 *----------------------------------------------------------------------*/
typedef struct simva_mod_info
{
	int            major;
	struct class  *simva_mod_class;
} simva_mod_info_t;
simva_mod_info_t  simva_mod_info;

typedef struct mem_area
{
	unsigned char  *addr;
	int             size;
} mem_area_t;

/*======================================================================*
 *  Functions
 *----------------------------------------------------------------------*/
static int  __init simva_mod_init(void);
static void __exit simva_mod_exit(void);

static int simva_mod_open(struct inode *inode, struct file *filep);
static int simva_mod_close(struct inode *inode, struct file *filep);
static int simva_mod_read(struct file *filep, char __user *buf, size_t len, loff_t *ptr);
static int simva_mod_write(struct file *filep, const char __user *buf, size_t len, loff_t *ptr);
static long simva_mod_ioctl(struct file *filep, unsigned int cmd, unsigned long arg);
static loff_t simva_mod_seek(struct file *file, loff_t offset, int origin);

static int simva_mod_clkgating(char *name, int  cmd);
static int simva_mod_pllbypass(char *name, int cmd);
static int  simva_mod_sram_lowleakage(void *addr, int  cmd);
static int  simva_mod_lvds_phy_powerdown(int  cmd);
//static int  simva_mod_AVS_powerdown(int  cmd);

static void  cache_flush_range(unsigned char  *addr, int  size);

/*======================================================================*
 *  Variables
 *----------------------------------------------------------------------*/
struct cdev  cdev_simva_mod;
static struct of_device_id of_apmu_table[] = {
	{.compatible = "marvell,pegmatite-apmu"},
	{ /* end of list */ },
};
static struct of_device_id of_memory_controller_table[] = {
	{.compatible = "marvell,mckinley5"},
	{ /* end of list */ },
};
static struct of_device_id of_mpmu_table[] = {
	{.compatible = "marvell,pegmatite-mpmu"},
	{ /* end of list */ },
};

static void  __iomem *apmu_base;
static void  __iomem *memory_controller_base;
static void  __iomem *mpmu_base;
static void  __iomem *ipmu_misc_base;
static void  __iomem *gmac0_base;

//  simva_opepanel:
//      0 - 4line
//      1 - pumbaa
//      2 - cheetah
int  simva_opepanel=0;
module_param(simva_opepanel, int, 0);

/* bugfix:usb device power */
/*  work_queue */
static struct workqueue_struct	*ptr_gpioa0_wq = NULL;
typedef struct gpioa0_ws {
	struct work_struct	ws;
	int					cnt;
}gpioa0_ws_t;
static gpioa0_ws_t gpioa0_work_struct;

static unsigned char is_vesta_model = 1;

static enum EN_MEDIA_HUB_ON_TYPE {
	EN_MEDIA_HUB_ON_TYPE_INITIALIZING,
	EN_MEDIA_HUB_ON_TYPE_ECOMODE,
} sEnMediaHubOnType = EN_MEDIA_HUB_ON_TYPE_INITIALIZING;

int enable_scr_interrupt = 1;
EXPORT_SYMBOL(enable_scr_interrupt);

/*======================================================================*
 *  open I/F
 *----------------------------------------------------------------------*/
static int simva_mod_open(struct inode *inode, struct file *filep)
{
	int retvalue = -EBUSY;

	printk(KERN_DEBUG "simva_mod: opened.\n");
	retvalue = 0;
	return retvalue;
}


/*======================================================================*
 *  close I/F
 *----------------------------------------------------------------------*/
static int simva_mod_close(struct inode *inode, struct file *filep)
{
	return 0;
}


/*======================================================================*
 *  read I/F
 *----------------------------------------------------------------------*/
static int simva_mod_read(struct file *filep, char __user *buf, size_t len, loff_t *ptr)
{
	int  retvalue = -EBUSY;

	printk(KERN_DEBUG "simva_mod: read.\n");
	return retvalue;
}


/*======================================================================*
 *  write I/F
 *----------------------------------------------------------------------*/
static int simva_mod_write(struct file *filep, const char __user *buf, size_t len, loff_t *ptr)
{
	int  retvalue;

	printk(KERN_DEBUG "simva_mod: write.\n");
	retvalue = 0;
	return(retvalue);
}

int  simva_mod_gmac_eco(int  cmd)
{
	//  XXX 2015/11/24 add (temporary:OFF the 125MHz clock of gmac)
	if(cmd==SIMVA_ENABLE)
	{
		writel(0x0002, gmac0_base+0x14);
		msleep(10);
		writel(0x0d93, gmac0_base+0x10);
		msleep(10);
		writel(0x484e, gmac0_base+0x14);
		msleep(10);
		writel(0x0c13, gmac0_base+0x10);
		msleep(10);
		//  XXX 2015/11/24 add (temporary:OFF the LED of ether)
		writel(0x0003, gmac0_base+0x14);
		msleep(10);
		writel(0x0d93, gmac0_base+0x10);
		msleep(10);
		writel(0x088a, gmac0_base+0x14);
		msleep(10);
		writel(0x0c13, gmac0_base+0x10);
		msleep(10);
		writel(0x0000, gmac0_base+0x14);
		msleep(10);
		writel(0x0d93, gmac0_base+0x10);
		msleep(10);
	}
	else
	{
		printk(KERN_CRIT "[msugi:%s] !!!! Doesn't impliment gmac awake from ecomode.\n", __FUNCTION__);
	}

	return 0;
}

#if defined(TMP_USB_GATING)
static int  TMP_simva_mod_usb_gate(int trgt, int  cmd);
int  TMP_simva_mod_usb_gate(int trgt, int  cmd)
{
	int						retvalue;
	static void __iomem *	apmucnf = NULL;
	unsigned long        	value;
	unsigned long r1;
	int i=0;
	
	
	apmucnf = ioremap(0xd0630000, 0x1000);
	if(apmucnf == NULL)
	{
		printk(KERN_CRIT "[msugi] can't map apmucnf\n");
		retvalue = -1;
		goto l_Exit;
	}
	
	if(cmd)
	{
		// cmd==SIMVA_ENABLE,  usb clk off
		if(trgt == SIMVA_USB2)
		{
			
			value = readl(apmucnf+0x4b0);
			value &= (~(BIT(1)));
			writel(value, apmucnf+0x4b0);
			//USB CLK OFF CHECK
			while(i<100) {
				r1 = readl(apmucnf+0x4b4);
				r1 &= ( BIT(7) );
				if (r1) {	break;	} //wait bit7==1
				i++;
				udelay(100);
			}
			if (i>=100) {
				//ugh! add error proc
			}
			
			value = readl(apmucnf+0x4b8);
			value &= (~(BIT(1)));
			writel(value, apmucnf+0x4b8);
			//USB CLK OFF CHECK
			while(i<100) {
				r1 = readl(apmucnf+0x4bc);
				r1 &= ( BIT(7) );
				if (r1) {	break;	} //wait bit7==1
				i++;
				udelay(100);
			}
			if (i>=100) {
				//ugh! add error proc
			}
		}
		else if(trgt == SIMVA_USB3)
		{
			
			value = readl(apmucnf+0x4c0);
			value &= (~(BIT(1)));
			writel(value, apmucnf+0x4c0);
			//USB CLK OFF CHECK
			while(i<100) {
				r1 = readl(apmucnf+0x4c4);
				r1 &= ( BIT(7) );
				if (r1) {	break;	} //wait bit7==1
				i++;
				udelay(100);
			}
			if (i>=100) {
				//ugh! add error proc
			}
			
			value = readl(apmucnf+0x4c8);
			value &= (~(BIT(1)));
			writel(value, apmucnf+0x4c8);
			//USB CLK OFF CHECK
			while(i<100) {
				r1 = readl(apmucnf+0x4cc);
				r1 &= ( BIT(7) );
				if (r1) {	break;	} //wait bit7==1
				i++;
				udelay(100);
			}
			if (i>=100) {
				//ugh! add error proc
			}
		}
	}
	else
	{
		// cmd==SIMVA_DISABLE
		if(trgt == SIMVA_USB2)
		{
			
			value = readl(apmucnf+0x4b0);
			value |= BIT(1);
			writel(value, apmucnf+0x4b0);
			//USB CLK ON CHECK
			while(i<100) {
				r1 = readl(apmucnf+0x4b4);
				r1 &= ( BIT(7) );
				if (!r1) {	break;	} //wait bit7==0
				i++;
				udelay(100);
			}
			if (i>=100) {
				//ugh! add error proc
			}
			
			value = readl(apmucnf+0x4b8);
			value |= BIT(1);
			writel(value, apmucnf+0x4b8);
			//USB CLK ON CHECK
			while(i<100) {
				r1 = readl(apmucnf+0x4bc);
				r1 &= ( BIT(7) );
				if (!r1) {	break;	} //wait bit7==0
				i++;
				udelay(100);
			}
			if (i>=100) {
				//ugh! add error proc
			}
		}
		else if(trgt == SIMVA_USB3)
		{
			
			value = readl(apmucnf+0x4c0);
			value |= BIT(1);
			writel(value, apmucnf+0x4c0);
			//USB CLK ON CHECK
			while(i<100) {
				r1 = readl(apmucnf+0x4c4);
				r1 &= ( BIT(7) );
				if (!r1) {	break;	} //wait bit7==0
				i++;
				udelay(100);
			}
			if (i>=100) {
				//ugh! add error proc
			}
			
			value = readl(apmucnf+0x4c8);
			value |= BIT(1);
			writel(value, apmucnf+0x4c8);
			//USB CLK ON CHECK
			while(i<100) {
				r1 = readl(apmucnf+0x4cc);
				r1 &= ( BIT(7) );
				if (!r1) {	break;	} //wait bit7==0
				i++;
				udelay(100);
			}
			if (i>=100) {
				//ugh! add error proc
			}
		}
	}
	
	retvalue = 0;
l_Exit:
	if(apmucnf)
		iounmap(apmucnf);
	return(retvalue);
}
#endif


#if defined(TMP_USB_GATING)
static int  TMP_simva_mod_usb2h2_off(void  *usb2utm, void  *usb2host);
int  TMP_simva_mod_usb2h2_off(void  *usb2utm, void  *usb2host)
{
	unsigned long   value;
	
	
	value = readl(usb2host+0x184);
	value |= BIT(23);
	writel(value, usb2host+0x184);
	
	value = readl(usb2host+0x140);
	value |= BIT(1);
	writel(value, usb2host+0x140);
	
	value = readl(usb2utm+0x04c);
	value &= ~(BIT(24));
	writel(value, usb2utm+0x04c);
	
	value = readl(usb2utm+0x044);
	value |= BIT(1);
	writel(value, usb2utm+0x044);

	return 0;
}
#endif


#if defined(TMP_USB_GATING)
static int  TMP_simva_mod_usb2h2_on(void  *usb2utm, void  *usb2host);
int  TMP_simva_mod_usb2h2_on(void  *usb2utm, void  *usb2host)
{
	unsigned long   value;
	
	
	value = readl(usb2utm+0x044);
	value &= ~(BIT(1));
	writel(value, usb2utm+0x044);
	
	msleep(10); //wait 10ms
	
	value = readl(usb2host+0x140);
	value &= ~(BIT(1));
	writel(value, usb2host+0x140);
	
	value = readl(usb2utm+0x04c);
	value |= BIT(24);
	writel(value, usb2utm+0x04c);
	
	value = readl(usb2host+0x184);
	value &= ~(BIT(23));
	writel(value, usb2host+0x184);
	
	return 0;
}
#endif

#if defined(TMP_USB_GATING)
static int  TMP_simva_mod_usb3d0_off(void  *comphy, void  *usb2utm, void  *usb3dev);
int  TMP_simva_mod_usb3d0_off(void  *comphy, void  *usb2utm, void  *usb3dev)
{
	unsigned long   value;
	
	
//	printk("[simva:%s:%d] point\n", __FUNCTION__, __LINE__);
	value = readl(comphy+0x704);
	value |= BIT(8);
	writel(value, comphy+0x704);
	
//	printk("[simva:%s:%d] point\n", __FUNCTION__, __LINE__);
	value = readl(usb3dev+0x184);
	value |= BIT(23);
	writel(value, usb3dev+0x184);
	
//	printk("[simva:%s:%d] point\n", __FUNCTION__, __LINE__);
	value = readl(usb3dev+0x140);
	value |= BIT(1);
	writel(value, usb3dev+0x140);
	
//	printk("[simva:%s:%d] point\n", __FUNCTION__, __LINE__);
	value = readl(usb2utm+0x08c);
	value &= ~(BIT(24));
	writel(value, usb2utm+0x08c);
	
//	printk("[simva:%s:%d] point\n", __FUNCTION__, __LINE__);
	value = readl(usb2utm+0x084);
	value |= BIT(1);
	writel(value, usb2utm+0x084);
	
	printk("[simva:%s:%d] point\n", __FUNCTION__, __LINE__);
	return 0;
}
#endif

#if defined(TMP_USB_GATING)
static int  TMP_simva_mod_usb3d0_on(void  *comphy, void  *usb2utm, void  *usb3dev);
int  TMP_simva_mod_usb3d0_on(void  *comphy, void  *usb2utm, void  *usb3dev)
{
	unsigned long   value;
	
	
//	printk("[simva:%s:%d] point\n", __FUNCTION__, __LINE__);
	value = readl(usb2utm+0x084);
	value &= ~(BIT(1));
	writel(value, usb2utm+0x084);
	
	msleep(10); // wait 10ms
	
//	printk("[simva:%s:%d] point\n", __FUNCTION__, __LINE__);
	value = readl(usb2utm+0x08c);
	value |= BIT(24);
	writel(value, usb2utm+0x08c);
	
//	printk("[simva:%s:%d] point\n", __FUNCTION__, __LINE__);
	value = readl(usb3dev+0x140);
	value &= ~(BIT(1));
	writel(value, usb3dev+0x140);
	
//	printk("[simva:%s:%d] point\n", __FUNCTION__, __LINE__);
	value = readl(usb3dev+0x184);
	value &= ~(BIT(23));
	writel(value, usb3dev+0x184);
	
//	printk("[simva:%s:%d] point\n", __FUNCTION__, __LINE__);
	value = readl(comphy+0x704);
	value &= ~(BIT(8));
	writel(value, comphy+0x704);
	
	printk("[simva:%s:%d] point\n", __FUNCTION__, __LINE__);
	return 0;
}
#endif


#if defined(TMP_USB_GATING)
static int  TMP_simva_mod_usb2x1_off(void  *usb2utm, void  *usb2dual);
int  TMP_simva_mod_usb2x1_off(void  *usb2utm, void  *usb2dual)
{
	unsigned long   value;
	
	
	value = readl(usb2dual+0x184);
	value |= BIT(23);
	writel(value, usb2dual+0x184);
	
	value = readl(usb2dual+0x140);
	value |= BIT(1);
	writel(value, usb2dual+0x140);
	
	value = readl(usb2utm+0x00c);
	value &= ~BIT(24);
	writel(value, usb2utm+0x00c);
	
	value = readl(usb2utm+0x004);
	value |= BIT(1);
	writel(value, usb2utm+0x004);
	
	return 0;
}
#endif

#if defined(TMP_USB_GATING)
static int  TMP_simva_mod_usb2x1_on(void  *usb2utm, void  *usb2dual);
int  TMP_simva_mod_usb2x1_on(void  *usb2utm, void  *usb2dual)
{
	unsigned long   value;
	
	value = readl(usb2utm+0x004);
	value &= ~(BIT(1));
	writel(value, usb2utm+0x004);
	
	msleep(10); //wait 10ms
	
	value = readl(usb2dual+0x140);
	value &= ~(BIT(1));
	writel(value, usb2dual+0x140);
	
	value = readl(usb2utm+0x00c);
	value |= BIT(24);
	writel(value, usb2utm+0x00c);
	
	value = readl(usb2dual+0x184);
	value &= ~(BIT(23));
	writel(value, usb2dual+0x184);
	
	return 0;
}
#endif




#if defined(TMP_USB_GATING)
static int  TMP_simva_mod_usb_power_on(int  cmd);
int  TMP_simva_mod_usb_power_on(int  cmd)
{
	void  __iomem  *comphy=NULL;	/*  from 0xD073_0000  */
	void  __iomem  *usb2utm=NULL;	/*  from 0xD074_0000  */
	void  __iomem  *usb3devL=NULL;	/*  from 0xD422_4000  */
	void  __iomem  *usb2host=NULL;	/*  from 0xD429_1xxx  */
	void  __iomem  *usb2dual=NULL;	/*  from 0xD429_8xxx  */
	void  __iomem  *tmp_io;
	struct device_node *np;
	int of_r32_ret, gui_dev_type;
	u32  val;
	
	
	printk("[simva:%s:%d] start poweron of USB.\n", __FUNCTION__, __LINE__);
	
	/*  map devices  */ 
	comphy = ioremap(0xd0730000, 0x800);
	if(comphy == NULL)
	{
		printk("[simva:%s:%d] can't map COMPHY area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb2utm = ioremap(0xd0740000, 0x100);
	if(usb2utm == NULL)
	{
		printk("[simva:%s:%d] can't map USB2UTM area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb3devL = ioremap(0xd4224000, 0x200);
	if(usb3devL == NULL)
	{
		printk("[simva:%s:%d] can't map USB3DevL area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb2host = ioremap(0xd4291000, 0x200);
	if(usb2host==NULL)
	{
		printk("[simva:%s:%d] can't map USB2Host area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb2dual = ioremap(0xd4298000, 0x200);
	if(usb2dual==NULL)
	{
		printk("[simva:%s:%d] can't map USB2dual area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	
	/* dtsgui_dev_typeɃfoCXނ擾i0:4line, 1:touch panel, 2:cheetahj */
	np = of_find_compatible_node(NULL, NULL, "ricoh,gui-device-type");
	if(!np)
	{
		printk("[simva:%s:%d] Can't find compatible node %s\n", __FUNCTION__, __LINE__, "ricoh,gui-device-type");
		goto l_Exit;
	}
	of_r32_ret = of_property_read_u32(np, "gui-device-type", &gui_dev_type); //gui_dev_type 0:4line, 1:touch panel, 2:cheetah
	if(of_r32_ret < 0)
	{
		printk("[simva:%s:%d] Can't read device type %s\n", __FUNCTION__, __LINE__, "gui-device-type");
		return -1;
	}
	printk("[simva:%s:%d] gui_dev_type %d\n", __FUNCTION__, __LINE__, gui_dev_type);
	
	/* GPIOA[0] set */
	tmp_io = ioremap(0xd401e000, 4);
	val = (((readl(tmp_io)) & ((~(BIT(2))) & (~(BIT(1))))) | ((BIT(0))));
	writel(val, tmp_io);
	iounmap(tmp_io);
	
	
	simva_mod_sram_lowleakage(usb3d_SRAMPdwn_SPCTL, SIMVA_DISABLE);
	
	simva_mod_sram_lowleakage(usbdm_SRAMPdwn_SPCTL, SIMVA_DISABLE);
	
	if (gui_dev_type == 0) {
		//P only. if mf, this is executed in MEDIA_HUB_ON
		simva_mod_sram_lowleakage(usbh_SRAMPdwn_SPCTL,  SIMVA_DISABLE);
	}
	
	TMP_simva_mod_usb_gate(SIMVA_USB2, SIMVA_DISABLE); //usb clock on, and check
	TMP_simva_mod_usb_gate(SIMVA_USB3, SIMVA_DISABLE); //usb clock on, and check
	
	//sai /* XXX : usb clock check */
	
	msleep(100);
	
	TMP_simva_mod_usb3d0_on(comphy, usb2utm, usb3devL);
	
	/* GPIOA[1] edge unset */
	tmp_io = ioremap(0xd4019018, 4);
	val = ((readl(tmp_io)) | (BIT(1)));
	writel(val, tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd4019010, 4);
	val = ((readl(tmp_io)) & (~(BIT(1))));
	writel(val, tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd4019014, 4);
	val = ((readl(tmp_io)) & (~(BIT(1))));
	writel(val, tmp_io);
	iounmap(tmp_io);
	
	if (gui_dev_type == 0) {
		//P only. if mf, this is executed in MEDIA_HUB_ON
		TMP_simva_mod_usb2h2_on(usb2utm, usb2host);
		
		//P only. if mf, this is executed in MEDIA_HUB_ON
		if(is_vesta_model) {
			//SCR micon ON
			tmp_io = ioremap(0xd4019408, 4);
			val = readl(tmp_io);
			val = (val | (BIT(30)));
			writel(val, tmp_io);
			iounmap(tmp_io);
			msleep(10);
			enable_scr_interrupt = 1;
		}
		
		/* XXX : usb host(usb2h2) re-atach */
		
		//P only. if mf, this is executed in MEDIA_HUB_ON
		if(is_vesta_model) {
			/* XXX : media hub power on */
			gpio_set_value(62, 1);
		}
		
		//P only. if mf, this is executed in MEDIA_HUB_ON
		TMP_simva_mod_usb2x1_on(usb2utm, usb2dual);
	}

	//2016/01/27 : call ehci initialize
	//printk("[simva] !!!! check this !!!!\n");
	//ret = ehci_setup(simva_host_cd);
	//printk("[simva]     ehci_setup() = %d\n", ret);
	

l_Exit:
	/*  unmap resources  */
	if(comphy)
		iounmap(comphy);
	if(usb2utm)
		iounmap(usb2utm);
	if(usb3devL)
		iounmap(usb3devL);
	if(usb2host)
		iounmap(usb2host);
	if(usb2dual)
		iounmap(usb2dual);

	return 0;
}

int  TMP_simva_mod_usb_power_on_SIMVA_MOD_MEDIA_HUB_ON(unsigned long doesExist3GDongle)
{
	void  __iomem  *comphy=NULL;	/*  from 0xD073_0000  */
	void  __iomem  *usb2utm=NULL;	/*  from 0xD074_0000  */
	void  __iomem  *usb3devL=NULL;	/*  from 0xD422_4000  */
	void  __iomem  *usb2host=NULL;	/*  from 0xD429_1xxx  */
	void  __iomem  *usb2dual=NULL;	/*  from 0xD429_8xxx  */
	void  __iomem  *tmp_io;
	struct device_node *np;
	int of_r32_ret, gui_dev_type;
	u32  val;
	
	
	
	/*  map devices  */ 
	comphy = ioremap(0xd0730000, 0x800);
	if(comphy == NULL)
	{
		printk("[simva:%s:%d] can't map COMPHY area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb2utm = ioremap(0xd0740000, 0x100);
	if(usb2utm == NULL)
	{
		printk("[simva:%s:%d] can't map USB2UTM area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb3devL = ioremap(0xd4224000, 0x200);
	if(usb3devL == NULL)
	{
		printk("[simva:%s:%d] can't map USB3DevL area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb2host = ioremap(0xd4291000, 0x200);
	if(usb2host==NULL)
	{
		printk("[simva:%s:%d] can't map USB2Host area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb2dual = ioremap(0xd4298000, 0x200);
	if(usb2dual==NULL)
	{
		printk("[simva:%s:%d] can't map USB2dual area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	
	if (doesExist3GDongle == 1) {
		//exist 3gdongle
		
#if 0
		TMP_simva_mod_usb_gate(SIMVA_USB2, SIMVA_DISABLE); //usb clock on, and check
		TMP_simva_mod_usb2h2_on(usb2utm, usb2host);
#endif
		
		//SCR micon ON
		tmp_io = ioremap(0xd4019408, 4);
		val = readl(tmp_io);
		val = (val | (BIT(30)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		msleep(10);
		enable_scr_interrupt = 1;
	} else {
		//NON exist 3gdongle
		
#if 0
		simva_mod_sram_lowleakage(usbh_SRAMPdwn_SPCTL,  SIMVA_DISABLE);
#endif
		
		//TMP_simva_mod_usb_gate(SIMVA_USB2, SIMVA_DISABLE); //usb clock on, and check
#if 0
		TMP_simva_mod_usb2h2_on(usb2utm, usb2host);
#endif
		
#if 1
		//SCR micon ON
		tmp_io = ioremap(0xd4019408, 4);
		val = readl(tmp_io);
		val = (val | (BIT(30)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		msleep(10);
		enable_scr_interrupt = 1;
#endif
		
		/* XXX : media hub power on */
		gpio_set_value(62, 1);
		
#if 0
		TMP_simva_mod_usb2x1_on(usb2utm, usb2dual);
#endif
	}	
	

l_Exit:
	/*  unmap resources  */
	if(comphy)
		iounmap(comphy);
	if(usb2utm)
		iounmap(usb2utm);
	if(usb3devL)
		iounmap(usb3devL);
	if(usb2host)
		iounmap(usb2host);
	if(usb2dual)
		iounmap(usb2dual);

	return 0;
}
#endif

#if defined(TMP_USB_GATING)
static int  TMP_simva_mod_usb_power_off(int  cmd);
int  TMP_simva_mod_usb_power_off(int  cmd)
{
	int				retvalue=-1;
	void  __iomem  *comphy=NULL;	/*  from 0xD073_0000  */
	void  __iomem  *usb2utm=NULL;	/*  from 0xD074_0000  */
	void  __iomem  *usb3devS=NULL;	/*  from 0xD422_0000  */
	void  __iomem  *usb3devL=NULL;	/*  from 0xD422_4000  */
	void  __iomem  *usb2host=NULL;	/*  from 0xD429_1xxx  */
	void  __iomem  *usb2dual=NULL;	/*  from 0xD429_8xxx  */
	void  __iomem  *tmp_io;
	unsigned long	exist_3gdongle;
	unsigned long	exist_usbdev;
	struct device_node *np;
	int of_r32_ret, gui_dev_type;
	u32  val;
	
	
	printk("[simva:%s:%d] start powerdown of USB.\n", __FUNCTION__, __LINE__);
	
	
	/* map devices */
	comphy = ioremap(0xd0730000, 0x800);
	if(comphy == NULL)
	{
		printk("[simva:%s:%d] can't map COMPHY area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb2utm = ioremap(0xd0740000, 0x100);
	if(usb2utm == NULL)
	{
		printk("[simva:%s:%d] can't map USB2UTM area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb3devS = ioremap(0xd4220000, 0x2000);
	if(usb3devS == NULL)
	{
		printk("[simva:%s:%d] can't map USB3DevS area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb3devL = ioremap(0xd4224000, 0x200);
	if(usb3devL == NULL)
	{
		printk("[simva:%s:%d] can't map USB3DevL area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb2host = ioremap(0xd4291000, 0x200);
	if(usb2host==NULL)
	{
		printk("[simva:%s:%d] can't map USB2Host area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb2dual = ioremap(0xd4298000, 0x200);
	if(usb2dual==NULL)
	{
		printk("[simva:%s:%d] can't map USB2dual area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	
	
	/* check status and decide route */
	exist_3gdongle = !!(*(unsigned long*)(usb2dual+0x184) & BIT(0));
	exist_usbdev   = !!(*(unsigned long*)(usb3devS +0x02c) & BIT(2));
	printk("[simva:%s:%d] DEBUG 0x%08x\n", __FUNCTION__, __LINE__, (unsigned int)*(unsigned long*)(usb3devS +0x02c));
	
	
	/* dtsgui_dev_typeɃfoCXނ擾i0:4line, 1:touch panel, 2:cheetahj */
	np = of_find_compatible_node(NULL, NULL, "ricoh,gui-device-type");
	if(!np)
	{
		printk("[simva:%s:%d] Can't find compatible node %s\n", __FUNCTION__, __LINE__, "ricoh,gui-device-type");
		goto l_Exit;
	}
	of_r32_ret = of_property_read_u32(np, "gui-device-type", &gui_dev_type); //gui_dev_type 0:4line, 1:touch panel, 2:cheetah
	if(of_r32_ret < 0)
	{
		printk("[simva:%s:%d] Can't read device type %s\n", __FUNCTION__, __LINE__, "gui-device-type");
		return -1;
	}
	printk("[simva:%s:%d] gui_dev_type %d\n", __FUNCTION__, __LINE__, gui_dev_type);
	
	
	printk("[simva:%s] route select : 3gdongle=%d usbdev=%d.\n", __FUNCTION__, (int)exist_3gdongle, (int)exist_usbdev);
	if(gui_dev_type==2)
	{
		
		if (exist_usbdev==1) {
			//nothing to do
			
		} else {
			//(exist_usbdev==0)
			//route 1
			//USB Device(UWB3d0) OFF
			TMP_simva_mod_usb_gate(SIMVA_USB3, SIMVA_DISABLE);
			TMP_simva_mod_usb3d0_off(comphy, usb2utm, usb3devL);
			
			//SRAM for USB Low Leakage Mode
			simva_mod_sram_lowleakage(usb3d_SRAMPdwn_SPCTL, SIMVA_ENABLE);
			
			//usb clock off, and check
			TMP_simva_mod_usb_gate(SIMVA_USB3, SIMVA_ENABLE);
			
			//set gpioA[0] to trriger from eco mode
			
			/* GPIOA[A] set */
			tmp_io = ioremap(0xd401e000, 4);
			val = readl(tmp_io);
			val = (val & (~(BIT(2))) & (~(BIT(1))) & (~(BIT(0))));
			writel(val, tmp_io);
			iounmap(tmp_io);
			
			/* GPIOA[0] set edge */
			tmp_io = ioremap(0xd4019018, 4);
			val = readl(tmp_io);
			val = (val | (BIT(0)));
			writel(val, tmp_io);
			iounmap(tmp_io);
			
			tmp_io = ioremap(0xd4019010, 4);
			val = readl(tmp_io);
			val = (val | (BIT(0)));
			writel(val, tmp_io);
			iounmap(tmp_io);
			
			tmp_io = ioremap(0xd4019014, 4);
			val = readl(tmp_io);
			val = (val | (BIT(0)));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
	}
	else
	{
		if (exist_usbdev==1) {
			if (exist_3gdongle==1) {
				//exist_usbdev==1 and exist_3gdongle=1
				//route 2
				//printk("[simva:%s] route2\n", __FUNCTION__);
				
				if(is_vesta_model) {
					//SCR micon off
					tmp_io = ioremap(0xd401940c, 4);
					val = readl(tmp_io);
					val = (val | (BIT(30)));
					writel(val, tmp_io);
					iounmap(tmp_io);
					enable_scr_interrupt = 0;
				}
				
				//disable gate of USB2, and USB Host(USB2h2) OFF
				TMP_simva_mod_usb_gate(SIMVA_USB2, SIMVA_DISABLE);
				TMP_simva_mod_usb2h2_off(usb2utm, usb2host);
			} else {
				//exist_usbdev==1 and exist_3gdongle=0
				//route 3
				//printk("[simva:%s] route3\n", __FUNCTION__);
				
				/* XXX : media hub IF(usb2x1) detatch */
				//ugh! media hub detach must be done here, for only Vesta-P
				
				//Off usb2x1
				TMP_simva_mod_usb_gate(SIMVA_USB2, SIMVA_DISABLE);
				TMP_simva_mod_usb2x1_off(usb2utm, usb2dual);
				
				if(is_vesta_model) {
					//media hub power off
					gpio_set_value(62, 0);
				}
				
				if(is_vesta_model) {
					//SCR micon off
					tmp_io = ioremap(0xd401940c, 4);
					val = readl(tmp_io);
					val = (val | (BIT(30)));
					writel(val, tmp_io);
					iounmap(tmp_io);
					enable_scr_interrupt = 0;
				}
				
				//Off usb2h2
				TMP_simva_mod_usb_gate(SIMVA_USB2, SIMVA_DISABLE);
				TMP_simva_mod_usb2h2_off(usb2utm, usb2host);
				
				simva_mod_sram_lowleakage(usbdm_SRAMPdwn_SPCTL, SIMVA_ENABLE);
				simva_mod_sram_lowleakage(usbh_SRAMPdwn_SPCTL,  SIMVA_ENABLE);
			}
		} else {
			if (exist_3gdongle==1) {
				//exist_usbdev==0 and exist_3gdongle=1
				//route4
				//printk("[simva:%s] route4\n", __FUNCTION__);
				
				//SCR micon off
				tmp_io = ioremap(0xd401940c, 4);
				val = readl(tmp_io);
				val = (val | (BIT(30)));
				writel(val, tmp_io);
				iounmap(tmp_io);
				enable_scr_interrupt = 0;
				
				//off usb2h2
				TMP_simva_mod_usb_gate(SIMVA_USB2, SIMVA_DISABLE);
				TMP_simva_mod_usb2h2_off(usb2utm, usb2host);
				
				//Off usb3d0
				TMP_simva_mod_usb_gate(SIMVA_USB3, SIMVA_DISABLE);
				TMP_simva_mod_usb3d0_off(comphy, usb2utm, usb3devL);
				
				simva_mod_sram_lowleakage(usb3d_SRAMPdwn_SPCTL, SIMVA_ENABLE);
				simva_mod_sram_lowleakage(usbh_SRAMPdwn_SPCTL,  SIMVA_ENABLE);
				
				//usb3 clock off, and check */
				TMP_simva_mod_usb_gate(SIMVA_USB3, SIMVA_ENABLE);
				
				//set gpioA[0] to trriger from eco mode
				/* GPIOA[A] set */
				tmp_io = ioremap(0xd401e000, 4);
				val = readl(tmp_io);
				val = (val & (~(BIT(2))) & (~(BIT(1))) & (~(BIT(0))));
				writel(val, tmp_io);
				iounmap(tmp_io);
				
				/* GPIOA[0] set edge */
				tmp_io = ioremap(0xd4019018, 4);
				val = readl(tmp_io);
				val = (val | (BIT(0)));
				writel(val, tmp_io);
				iounmap(tmp_io);
				
				tmp_io = ioremap(0xd4019010, 4);
				val = readl(tmp_io);
				val = (val | (BIT(0)));
				writel(val, tmp_io);
				iounmap(tmp_io);
				
				tmp_io = ioremap(0xd4019014, 4);
				val = readl(tmp_io);
				val = (val | (BIT(0)));
				writel(val, tmp_io);
				iounmap(tmp_io);
			} else {
				//exist_usbdev==0 and exist_3gdongle=0
				//printk("[simva:%s] route5\n", __FUNCTION__);
				
				/* XXX : media hub IF(usb2x1) detatch */
				//ugh! media hub detouch is done at here only for Vesta-P
				
				//Media Hub IF(USB2x1) off
				TMP_simva_mod_usb_gate(SIMVA_USB2, SIMVA_DISABLE);
				TMP_simva_mod_usb2x1_off(usb2utm, usb2dual);
				
				if(is_vesta_model) {
					//media hub power off
					gpio_set_value(62, 0);
				}
				
				//SCR micon off
				tmp_io = ioremap(0xd401940c, 4);
				val = readl(tmp_io);
				val = (val | (BIT(30)));
				writel(val, tmp_io);
				iounmap(tmp_io);
				enable_scr_interrupt = 0;
				
				//USB Host(USB2h2) Off
				TMP_simva_mod_usb_gate(SIMVA_USB2, SIMVA_DISABLE);
				TMP_simva_mod_usb2h2_off(usb2utm, usb2host);
				
				//Off usb3d0
				TMP_simva_mod_usb_gate(SIMVA_USB3, SIMVA_DISABLE);
				TMP_simva_mod_usb3d0_off(comphy, usb2utm, usb3devL);
				
				simva_mod_sram_lowleakage(usb3d_SRAMPdwn_SPCTL, SIMVA_ENABLE);
				simva_mod_sram_lowleakage(usbh_SRAMPdwn_SPCTL,  SIMVA_ENABLE);
				
				//usb3 clock off, and check */
				TMP_simva_mod_usb_gate(SIMVA_USB3, SIMVA_ENABLE);
				
				//set gpioA[0] to trriger from eco mode
				/* GPIOA[A] set */
				tmp_io = ioremap(0xd401e000, 4);
				val = readl(tmp_io);
				val = (val & (~(BIT(2))) & (~(BIT(1))) & (~(BIT(0))));
				writel(val, tmp_io);
				iounmap(tmp_io);
				
				/* GPIOA[0] set edge */
				tmp_io = ioremap(0xd4019018, 4);
				val = readl(tmp_io);
				val = (val | (BIT(0)));
				writel(val, tmp_io);
				iounmap(tmp_io);
				
				tmp_io = ioremap(0xd4019010, 4);
				val = readl(tmp_io);
				val = (val | (BIT(0)));
				writel(val, tmp_io);
				iounmap(tmp_io);
				
				tmp_io = ioremap(0xd4019014, 4);
				val = readl(tmp_io);
				val = (val | (BIT(0)));
				writel(val, tmp_io);
				iounmap(tmp_io);
			}
		}
	}
	
	retvalue = 0;
	
l_Exit:
	/*  unmap resources  */
	if(comphy)
		iounmap(comphy);
	if(usb2utm)
		iounmap(usb2utm);
	if(usb3devS)
		iounmap(usb3devS);
	if(usb3devL)
		iounmap(usb3devL);
	if(usb2host)
		iounmap(usb2host);
	if(usb2dual)
		iounmap(usb2dual);
	return 0;
}

int  TMP_simva_mod_usb_power_off_SIMVA_MOD_MEDIA_HUB_OFF(unsigned long doesExist3GDongle)
{
	int				retvalue=-1;
	void  __iomem  *comphy=NULL;	/*  from 0xD073_0000  */
	void  __iomem  *usb2utm=NULL;	/*  from 0xD074_0000  */
	void  __iomem  *usb3devS=NULL;	/*  from 0xD422_0000  */
	void  __iomem  *usb3devL=NULL;	/*  from 0xD422_4000  */
	void  __iomem  *usb2host=NULL;	/*  from 0xD429_1xxx  */
	void  __iomem  *usb2dual=NULL;	/*  from 0xD429_8xxx  */
	void  __iomem  *tmp_io;
	unsigned long	exist_3gdongle;
	unsigned long	exist_usbdev;
	struct device_node *np;
	int of_r32_ret, gui_dev_type;
	u32  val;
	
	
	/* map devices */
	comphy = ioremap(0xd0730000, 0x800);
	if(comphy == NULL)
	{
		printk("[simva:%s:%d] can't map COMPHY area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb2utm = ioremap(0xd0740000, 0x100);
	if(usb2utm == NULL)
	{
		printk("[simva:%s:%d] can't map USB2UTM area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb3devS = ioremap(0xd4220000, 0x2000);
	if(usb3devS == NULL)
	{
		printk("[simva:%s:%d] can't map USB3DevS area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb3devL = ioremap(0xd4224000, 0x200);
	if(usb3devL == NULL)
	{
		printk("[simva:%s:%d] can't map USB3DevL area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb2host = ioremap(0xd4291000, 0x200);
	if(usb2host==NULL)
	{
		printk("[simva:%s:%d] can't map USB2Host area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	usb2dual = ioremap(0xd4298000, 0x200);
	if(usb2dual==NULL)
	{
		printk("[simva:%s:%d] can't map USB2dual area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	
	if (doesExist3GDongle == 1) {
		//exist 3gdongle
		
		//SCR micon off
		tmp_io = ioremap(0xd401940c, 4);
		val = readl(tmp_io);
		val = (val | (BIT(30)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		enable_scr_interrupt = 0;
		
#if 0
		//disable gate of USB2, and USB Host(USB2h2) OFF
		TMP_simva_mod_usb_gate(SIMVA_USB2, SIMVA_DISABLE);
		TMP_simva_mod_usb2h2_off(usb2utm, usb2host);
#endif
	} else {
		//NON exist 3gdongle
		
//		TMP_simva_mod_usb_gate(SIMVA_USB2, SIMVA_DISABLE);
#if 0
		//Off usb2x1
		TMP_simva_mod_usb2x1_off(usb2utm, usb2dual);
#endif

		//media hub power off
		gpio_set_value(62, 0);

#if 1
		//SCR micon off
		tmp_io = ioremap(0xd401940c, 4);
		val = readl(tmp_io);
		val = (val | (BIT(30)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		enable_scr_interrupt = 0;
#endif		
#if 0
		//Off usb2h2
		//TMP_simva_mod_usb_gate(SIMVA_USB2, SIMVA_DISABLE);
		TMP_simva_mod_usb2h2_off(usb2utm, usb2host);
#endif
		
#if 0
		simva_mod_sram_lowleakage(usbh_SRAMPdwn_SPCTL,  SIMVA_ENABLE);
#endif
	}
	
	retvalue = 0;
	
l_Exit:
	/*  unmap resources  */
	if(comphy)
		iounmap(comphy);
	if(usb2utm)
		iounmap(usb2utm);
	if(usb3devS)
		iounmap(usb3devS);
	if(usb3devL)
		iounmap(usb3devL);
	if(usb2host)
		iounmap(usb2host);
	if(usb2dual)
		iounmap(usb2dual);
	return 0;
}

#endif

static int  TMP_simva_mod_gpu_power_off(int  cmd);
int  TMP_simva_mod_gpu_power_off(int  cmd)
{
	int rc = -1;
	unsigned long   val;
	void  __iomem  *apmucnf=NULL;	/*  from 0xD063_0000  */
	
	
	printk("[simva:%s:%d] start powerdown of GPU.\n", __FUNCTION__, __LINE__);
	
	/* map devices */
	apmucnf = ioremap(0xd0630000, 0x1000);
	if(apmucnf == NULL)
	{
		printk("[simva:%s:%d] can't map CLKRST  area.\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	
	val = readl(apmucnf+0x4e8);
	val &= ~(BIT(1));
	writel(val, apmucnf+0x4e8);
	
	val = readl(apmucnf+0x4f8);
	val &= ~(BIT(1));
	writel(val, apmucnf+0x4f8);
	
	val = readl(apmucnf+0x500);
	val &= ~(BIT(1));
	writel(val, apmucnf+0x500);
	
	val = readl(apmucnf+0x030);
	val &= ~(BIT(0));
	writel(val, apmucnf+0x030);
	
	val = readl(apmucnf+0x030);
	val &= ((~(BIT(4))) & (~(BIT(5))));
	writel(val, apmucnf+0x030);
	
	msleep(1);
	
	val = readl(apmucnf+0x034);
	
	rc = 0;
	
l_Exit:
	if(apmucnf)
		iounmap(apmucnf);
	
	return rc;
}

/*======================================================================*
 *  ioctl I/F
 *----------------------------------------------------------------------*/
static long simva_mod_ioctl(struct file *filep, unsigned int cmd, unsigned long arg)
{
	int  retvalue=0;
	u32  val;
	mem_area_t  mem;
	void __iomem *tmp_io;
	
	switch (cmd)
	{
	case SIMVA_MOD_CLOCKGATING_ENABLE:
		printk("simva_mod: seigyo SIMVA_MOD_CLOCKGATING_ENABLE\n");
		
		/* sleep a)-i) */
		tmp_io = ioremap(0xf9080140, 4);
		val = ((readl(tmp_io)) & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		tmp_io = ioremap(0xf9080148, 4);
		val = ((readl(tmp_io)) & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		if(is_vesta_model) {
			tmp_io = ioremap(0xf9080170, 4);
			val = ((readl(tmp_io)) & (~(BIT(1))));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
		
		/* sleep a)-ii) */
		simva_mod_sram_lowleakage(UPCSRAMPdwn_SPCTL, SIMVA_ENABLE);
		
		/* sleep a)-iii) */
		tmp_io = ioremap(0xf9080000, 4);
		val = ((readl(tmp_io)) & (~(BIT(0))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* sleep a)-iv) */
		tmp_io = ioremap(0xf9080000, 4);
		val = ((readl(tmp_io)) & (~(BIT(4))) & (~(BIT(5))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* sleep a)-v) */
		msleep(1);
		
		/* XXX : sleep a)-vi) check satatus*/
		
		/* sleep b) */
		//simva_mod_lvds_phy_powerdown(SIMVA_ENABLE);
		//if(simva_opepanel!=SIMVA_OPE_4LINE)
		//{
		//	simva_mod_clkgating("apbuslcdclkgate", SIMVA_ENABLE);
		//}
		
		/* sleep c)-i) */		
//		simva_mod_clkgating("uart1clkgate", SIMVA_ENABLE);		//nothing in device tree
		simva_mod_clkgating("cpudbgclkgate", SIMVA_ENABLE);		//0xd0630400
//		simva_mod_clkgating("lcdxclkgate", SIMVA_ENABLE);		//0xd0630518

		if(is_vesta_model) {
			simva_mod_clkgating("ipsbusapbclkgate", SIMVA_ENABLE);	//0xf9080180
		}
		
		if(is_vesta_model) {
			tmp_io = ioremap(0xd063054c, 4);
			val = ((readl(tmp_io)) & (~(BIT(1))));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}

		if(is_vesta_model) {
			tmp_io = ioremap(0xf9080180, 4);
			val = ((readl(tmp_io)) & (~(BIT(1))));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
		
		/* XXX : sleep c)-ii) */
		
		/* sleep d)-i) */
		tmp_io = ioremap(0xf9080128, 4);
		val = ((readl(tmp_io)) & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		tmp_io = ioremap(0xf9080130, 4);
		val = ((readl(tmp_io)) & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);

		if(is_vesta_model) {
			tmp_io = ioremap(0xf9080138, 4);
			val = ((readl(tmp_io)) & (~(BIT(1))));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
		
		tmp_io = ioremap(0xf9080160, 4);
		val = ((readl(tmp_io)) & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		//  XXX 2016/10/21 Change (onboard LED off)
		gpio_set_value(POW_LED_GPIO1_NO, 0);
		//gpio_set_value(POW_LED_GPIO2_NO, 0);
		
		/* XXX : not defined now */
		//simva_mod_clkgating("uart2clkgate", 1);
		//simva_mod_gmac_eco(SIMVA_ENABLE); Defect #157
		break;
	case SIMVA_MOD_CLOCKGATING_DISABLE:
		printk("simva_mod: SIMVA_MOD_CLOCKGATING_DISABLE\n");
		
		/* wakeup f)-i) */
		//if(simva_opepanel!=SIMVA_OPE_4LINE)
		//{
		//	simva_mod_clkgating("apbuslcdclkgate", SIMVA_DISABLE);
		//}
//		simva_mod_clkgating("uart1clkgate", SIMVA_DISABLE);		//nothing in device tree
		simva_mod_clkgating("cpudbgclkgate", SIMVA_DISABLE);	//0xd0630400
//		simva_mod_clkgating("lcdxclkgate", SIMVA_DISABLE);		//0xd0630518

		if(is_vesta_model) {
			simva_mod_clkgating("ipsbusapbclkgate", SIMVA_DISABLE);	//0xf9080180
		}

		if(is_vesta_model) {
			tmp_io = ioremap(0xd063054c, 4);
			val = ((readl(tmp_io)) | (BIT(1)));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}

		if(is_vesta_model) {
			tmp_io = ioremap(0xf9080180, 4);
			val = ((readl(tmp_io)) | (BIT(1)));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
		
		/* XXX : wakeup f)-ii) */
		
		/* wakeup g) */
		//simva_mod_lvds_phy_powerdown(SIMVA_DISABLE);
		//2015/11/06 add, 2017/1/20 sai remove
		//simva_mod_clkgating("apbususb3daclkgate", SIMVA_DISABLE);
		//simva_mod_clkgating("nssclk", SIMVA_DISABLE);
		
		//  XXX 2016/10/21 Change (onboard LED on)
		gpio_set_value(POW_LED_GPIO1_NO, 1);
		//gpio_set_value(POW_LED_GPIO2_NO, 1);
		
		/* XXX : not defined now */
		//simva_mod_clkgating("uart2clkgate", 0);
		//simva_mod_gmac_eco(SIMVA_DISABLE); Defect #157
		break;
	case SIMVA_MOD_SRAM_LOWLEAKAGE_ENABLE:
		printk("simva_mod: SIMVA_MOD_SRAM_LOWLEAKAGE_ENABLE\n");
		/* sleep d)-ii) */
		//  Move from step (c-ii)
		// simva_mod_sram_lowleakage(UPCSRAMPdwn_SPCTL, SIMVA_ENABLE);
		simva_mod_sram_lowleakage(PIPSRAMPdwn_SPCTL, SIMVA_ENABLE);
		
		simva_mod_sram_lowleakage(JBIGSRAMPdwn_SPCTL, SIMVA_ENABLE);
		
		simva_mod_sram_lowleakage(JPEGSRAMPdwn_SPCTL, SIMVA_ENABLE);
		
		simva_mod_sram_lowleakage(ICESRAMPdwn_SPCTL, SIMVA_ENABLE);
		
		simva_mod_sram_lowleakage(ROTSRAMPdwn_SPCTL, SIMVA_ENABLE);
		//  XXX : TEMPORARY commented
		//simva_mod_sram_lowleakage(MC5_SRAMSpeedCtl_SRAMCTL, SIMVA_ENABLE);
		//d ) SRAM low Leakage Mode Eneable
		if(simva_opepanel!=SIMVA_OPE_4LINE)
		{
//			simva_mod_sram_lowleakage(lcd_SRAMPdwn_SPCTL, SIMVA_ENABLE);
		}
		
		/* sleep d)-iii) */
		tmp_io = ioremap(0xf9080008, 4);
		val = ((readl(tmp_io)) & (~(BIT(0))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* sleep d)-iv) */
		tmp_io = ioremap(0xf9080008, 4);
		val = ((readl(tmp_io)) & (~(BIT(4))) & (~(BIT(5))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* sleep d)-v) */
		msleep(1);
		
		/* XXX : sleep d)-vi) */
		
#if defined(TMP_USB_GATING)  /*  XXX : TEMPORARY  */
		/* sleep f) */
		//TMP_simva_mod_usb_gate();
		TMP_simva_mod_usb_power_off(SIMVA_ENABLE);
#else
		simva_mod_clkgating("apbususb2aclkgate", SIMVA_ENABLE);
		simva_mod_clkgating("apbususbphyaclkgate", SIMVA_ENABLE);
#endif
		break;
	case SIMVA_MOD_SRAM_LOWLEAKAGE_DISABLE:
		printk("simva_mod: seigyo SIMVA_MOD_SRAM_LOWLEAKAGE_DISABLE\n");
		
		/* wakeup c)-i) */
		tmp_io = ioremap(0xf9080140, 4);
		val = ((readl(tmp_io)) & (~(BIT(0))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		tmp_io = ioremap(0xf9080148, 4);
		val = ((readl(tmp_io)) & (~(BIT(0))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		if(is_vesta_model) {
			tmp_io = ioremap(0xf9080170, 4);
			val = ((readl(tmp_io)) & (~(BIT(0))));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
		
		/* wakeup c)-ii) */
		tmp_io = ioremap(0xf9080000, 4);
		val = (((readl(tmp_io)) | BIT(4)) & (~(BIT(5))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* wakeup c)-iii) */
		msleep(1);
		
		/* XXX : wakeup c)-iv) */
		
		/* wakeup c)-v) */
		tmp_io = ioremap(0xf9080000, 4);
		val = ((readl(tmp_io)) | BIT(4) | BIT(5));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* wakeup c)-vi) */
		msleep(1);
		
		/* XXX : wakeup c)-vii) */
		
		if(is_vesta_model) {
			/* wakeup c)-viii) */
			tmp_io = ioremap(0xf9080170, 4);
			val = ((readl(tmp_io)) | (BIT(1)));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
		
		tmp_io = ioremap(0xf9080148, 4);
		val = ((readl(tmp_io)) | (BIT(1)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		tmp_io = ioremap(0xf9080140, 4);
		val = ((readl(tmp_io)) | (BIT(1)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* wakeup c)-ix) */
		tmp_io = ioremap(0xf9080140, 4);
		val = ((readl(tmp_io)) & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);

		tmp_io = ioremap(0xf9080148, 4);
		val = ((readl(tmp_io)) & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);

		if(is_vesta_model) {
			tmp_io = ioremap(0xf9080170, 4);
			val = ((readl(tmp_io)) & (~(BIT(1))));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
		
		/* wakeup c)-xi) */
		tmp_io = ioremap(0xf9080000, 4);
		val = ((readl(tmp_io)) | (BIT(0)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		if(is_vesta_model) {
			/* wakeup c)-xii) */
			tmp_io = ioremap(0xf9080170, 4);
			val = ((readl(tmp_io)) | (BIT(1)));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}

		tmp_io = ioremap(0xf9080148, 4);
		val = ((readl(tmp_io)) | (BIT(1)));
		writel(val, tmp_io);
		iounmap(tmp_io);

		tmp_io = ioremap(0xf9080140, 4);
		val = ((readl(tmp_io)) | (BIT(1)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* wakeup c)-xiii) */
		simva_mod_sram_lowleakage(UPCSRAMPdwn_SPCTL, SIMVA_DISABLE);
		
		if(is_vesta_model) {
			/* wakeup c)-xiv) */
			tmp_io = ioremap(0xf9080170, 4);
			val = ((readl(tmp_io)) | (BIT(0)));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}

		tmp_io = ioremap(0xf9080148, 4);
		val = ((readl(tmp_io)) | (BIT(0)));
		writel(val, tmp_io);
		iounmap(tmp_io);

		tmp_io = ioremap(0xf9080140, 4);
		val = ((readl(tmp_io)) | (BIT(0)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* wakeup d)-i) */
		tmp_io = ioremap(0xf9080128, 4);
		val = ((readl(tmp_io)) & (~(BIT(0))));
		writel(val, tmp_io);
		iounmap(tmp_io);

		tmp_io = ioremap(0xf9080130, 4);
		val = ((readl(tmp_io)) & (~(BIT(0))));
		writel(val, tmp_io);
		iounmap(tmp_io);

		if(is_vesta_model) {
			tmp_io = ioremap(0xf9080138, 4);
			val = ((readl(tmp_io)) & (~(BIT(0))));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
		
		tmp_io = ioremap(0xf9080160, 4);
		val = ((readl(tmp_io)) & (~(BIT(0))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* wakeup d)-ii) */
		tmp_io = ioremap(0xf9080008, 4);
		val = (((readl(tmp_io)) | BIT(4)) & (~(BIT(5))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* wakeup d)-iii) */
		msleep(1);
		
		/* XXX : wakeup d)-iv) */
		
		/* wakeup d)-v) */
		tmp_io = ioremap(0xf9080008, 4); //sai corrected
		val = ((readl(tmp_io)) | BIT(4) | BIT(5));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* wakeup d)-vi) */
		msleep(1);
		
		/* XXX : wakeup d)-vii) */
		
		/* wakeup d)-viii) */
		tmp_io = ioremap(0xf9080128, 4);
		val = ((readl(tmp_io)) | (BIT(1)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		tmp_io = ioremap(0xf9080130, 4);
		val = ((readl(tmp_io)) | (BIT(1)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		if(is_vesta_model) {
			tmp_io = ioremap(0xf9080138, 4);
			val = ((readl(tmp_io)) | (BIT(1)));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
		
		tmp_io = ioremap(0xf9080160, 4);
		val = ((readl(tmp_io)) | (BIT(1)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* wakeup d)-ix) */
		tmp_io = ioremap(0xf9080128, 4);
		val = ((readl(tmp_io)) & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		tmp_io = ioremap(0xf9080130, 4);
		val = ((readl(tmp_io)) & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);

		if(is_vesta_model) {
			tmp_io = ioremap(0xf9080138, 4);
			val = ((readl(tmp_io)) & (~(BIT(1))));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
		
		tmp_io = ioremap(0xf9080160, 4);
		val = ((readl(tmp_io)) & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* wakeup d)-xi) */
		tmp_io = ioremap(0xf9080008, 4);
		val = ((readl(tmp_io)) | (BIT(0)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* wakeup d)-xii) */
		tmp_io = ioremap(0xf9080128, 4);
		val = ((readl(tmp_io)) | (BIT(1)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		tmp_io = ioremap(0xf9080130, 4);
		val = ((readl(tmp_io)) | (BIT(1)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		if(is_vesta_model) {
			tmp_io = ioremap(0xf9080138, 4);
			val = ((readl(tmp_io)) | (BIT(1)));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
		
		tmp_io = ioremap(0xf9080160, 4);
		val = ((readl(tmp_io)) | (BIT(1)));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		/* wakeup d)-xiii) */
		//simva_mod_sram_lowleakage(UPCSRAMPdwn_SPCTL, SIMVA_DISABLE);
		simva_mod_sram_lowleakage(PIPSRAMPdwn_SPCTL, SIMVA_DISABLE);
		
		simva_mod_sram_lowleakage(JBIGSRAMPdwn_SPCTL, SIMVA_DISABLE);
		
		simva_mod_sram_lowleakage(JPEGSRAMPdwn_SPCTL, SIMVA_DISABLE);
		
		simva_mod_sram_lowleakage(ICESRAMPdwn_SPCTL, SIMVA_DISABLE);
		
		simva_mod_sram_lowleakage(ROTSRAMPdwn_SPCTL, SIMVA_DISABLE);
		//  XXX : TEMPORARY commented
		//simva_mod_sram_lowleakage(MC5_SRAMSpeedCtl_SRAMCTL, SIMVA_DISABLE);
		//d ) SRAM low Leakage Mode Disable
		if(simva_opepanel!=SIMVA_OPE_4LINE)
		{
//			simva_mod_sram_lowleakage(lcd_SRAMPdwn_SPCTL, SIMVA_DISABLE);
		}
		/* wakeup d)-xiv) */
		tmp_io = ioremap(0xf9080128, 4);
		val = ((readl(tmp_io)) | BIT(0));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		tmp_io = ioremap(0xf9080130, 4);
		val = ((readl(tmp_io)) | BIT(0));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		if(is_vesta_model) {
			tmp_io = ioremap(0xf9080138, 4);
			val = ((readl(tmp_io)) | BIT(0));
			writel(val, tmp_io);
			iounmap(tmp_io);
		}
		
		tmp_io = ioremap(0xf9080160, 4);
		val = ((readl(tmp_io)) | BIT(0));
		writel(val, tmp_io);
		iounmap(tmp_io);
		
		break;
	case SIMVA_MOD_DRAM_AUTOSELFREFRESH_ENABLE:
		printk("simva_mod: SIMVA_MOD_DRAM_AUTOSELFREFRESH_ENABLE\n");
		/* sleep g) */
		val = 0xA;
		writel(val, memory_controller_base + 0x2cc);
		break;
	case SIMVA_MOD_DRAM_AUTOSELFREFRESH_DISABLE:
		printk("simva_mod: SIMVA_MOD_DRAM_AUTOSELFREFRESH_DISABLE\n");
		/* wakeup h) */
		val = 0;
		writel(val, memory_controller_base + 0x2cc);
		break;
	case SIMVA_MOD_PLL_BYPASSMODE_ENABLE:
		printk("simva_mod: SIMVA_MOD_PLL_BYPASSMODE_ENABLE\n");
		/* sleep h) */
		simva_mod_pllbypass("scanpll", SIMVA_ENABLE);
		/* XXX : not defined now */
		simva_mod_pllbypass("lvdsafepll0", 1);

		simva_mod_pllbypass("lvdsafepll1", 1);
		/* stop AVS */
		/* simva_mod_AVS_powerdown(SIMVA_ENABLE); */
		break;
	case SIMVA_MOD_PLL_BYPASSMODE_DISABLE:
		printk("simva_mod: seigyo SIMVA_MOD_PLL_BYPASSMODE_DISABLE\n");
		/* wakeup a) */
		/* start AVS */
		//simva_mod_AVS_powerdown(SIMVA_DISABLE);
		simva_mod_pllbypass("scanpll", SIMVA_DISABLE);
		/* XXX : not defined now */
		simva_mod_pllbypass("lvdsafepll0", 0);
		simva_mod_pllbypass("lvdsafepll1", 0);
		
		/* wakeup b) */
		TMP_simva_mod_usb_power_on(SIMVA_ENABLE);
		
		break;
	case SIMVA_MOD_CPU_LOWSPEED_ENABLE:
	case TEST_SIMVA_MOD_CPU_LOWSPEED_ENABLE:
		printk("simva_mod: SIMVA_MOD_CPU_LOWSPEED_ENABLE\n");
		simva_mod_pllbypass("corepll", SIMVA_ENABLE);
		break;
	case SIMVA_MOD_CPU_LOWSPEED_DISABLE:
	case TEST_SIMVA_MOD_CPU_LOWSPEED_DISABLE:
		printk("simva_mod: SIMVA_MOD_CPU_LOWSPEED_DISABLE\n");
		simva_mod_pllbypass("corepll", SIMVA_DISABLE);
		break; 
	case SIMVA_MOD_CACHE_FLUSH:
		printk("simva_mod: SIMVA_MOD_CACHE_FLUSH\n");
		if (copy_from_user(&mem, (void __user *)arg, sizeof(mem))) {	
			retvalue = -EFAULT;
		}
		cache_flush_range(mem.addr, mem.size);
		break; 
	case SIMVA_MOD_MEDIA_HUB_ON:
		if (sEnMediaHubOnType == EN_MEDIA_HUB_ON_TYPE_ECOMODE) {
			//if SIMVA_MOD_MEDIA_HUB_ON is called in initializing, there are nothing to do
			if(is_vesta_model) {
				TMP_simva_mod_usb_power_on_SIMVA_MOD_MEDIA_HUB_ON(arg);
			}
		}
		break;
	case SIMVA_MOD_MEDIA_HUB_OFF:
		sEnMediaHubOnType = EN_MEDIA_HUB_ON_TYPE_ECOMODE; //after first SIMVA_MOD_MEDIA_HUB_OFF, SIMVA_MOD_MEDIA_HUB_OFF is NOT under initializing
		if(is_vesta_model) {
			TMP_simva_mod_usb_power_off_SIMVA_MOD_MEDIA_HUB_OFF(arg);
		}
		break;
	default:
		retvalue = -ENOTTY;
		break;
	}
	return(retvalue);
}


#define  CACHE_LINE_SIZE   (64)
static void __cache_flush(unsigned long  addr)
{
	//printk("## addr = %p\n", addr);
	asm volatile ("mcr p15, 0, %0, c7, c10, 1"::"r"(addr));
	return;
}
void  cache_flush_range(unsigned char  *addr, int  size)
{
	unsigned char  *start;
	unsigned char  *end;
	unsigned char  *cur;
	
	printk("##%s : (%p, %d)\n", __FUNCTION__, addr, size);
	start = (unsigned char *)(((unsigned long)addr) & ~(CACHE_LINE_SIZE-1));
	end   = (unsigned char *)((unsigned long)addr + (unsigned long)size);
	cur   = start;
	while(cur < end)
	{
		__cache_flush((unsigned long)cur);
		cur += CACHE_LINE_SIZE;
	}
	asm volatile("dsb");
	return;
}


/*======================================================================*
 *  For LowPower Setting, gating clock
 *  parameter:
 *    name : clock or clock gate name. it's defined in device tree.
 *    cmd  : if this is true, clock gating enable. if false, clcok gating disable.
 *----------------------------------------------------------------------*/
int simva_mod_clkgating(char *name, int  cmd)
{
	int          retvalue;
	struct clk  *clkgate = __clk_lookup(name);

	if(clkgate == NULL) {
		goto l_LookupCLK_Err;
	}
	if(cmd)
	{
		//SIMVA_ENABLE
		if(__clk_is_enabled(clkgate))
		{
			clk_disable(clkgate);
			printk("[msugi:%s] %s is gated.\n", __FUNCTION__, name);
			if(__clk_is_enabled(clkgate))
			{
				printk(KERN_CRIT "[msugi:%s] !!!! %s can't gate !!!!\n",
					__FUNCTION__, name);
				printk(KERN_CRIT "[msugi:%s]  %s has enable_count %d\n",
					__FUNCTION__, name, clkgate->enable_count);
			}
		}
		else {
			printk("[%s] clk '%s' is not enabled\n", __FUNCTION__, name);
		}
	}
	else
	{
		//SIMVA_DISABLE
		clk_prepare(clkgate);
		clk_enable(clkgate);
		printk("[msugi:%s] %s is enabled.\n", __FUNCTION__, name);
	}
	retvalue = 0;
l_Exit:
	return(retvalue);
l_LookupCLK_Err:
	pr_emerg("Can't find clk : %s\n", name);
	retvalue = -1;
	goto l_Exit;
}

int  simva_mod_sram_lowleakage(void *addr, int  cmd)
{
	int  retvalue;
	u32  val;
	
	if(cmd)
	{
		val = readl(addr);
		val |= 0x03;
		writel(val, addr);
	}
	else
	{
		val = readl(addr);
		val &= ~0x03;
		writel(val, addr);
	}
	retvalue = 0;
	return(retvalue);
}

struct pll_regs {
	volatile uint32_t rst_prediv;
	volatile uint32_t mult_postdiv;
	volatile uint32_t kvco;
	volatile uint32_t misc;
	volatile uint32_t feedback_mode_deskew;
	volatile uint32_t offset_mode;
	volatile uint32_t fixed_mode_ssc_mode;
	volatile uint32_t ssc_freq_ssc_range;
	volatile uint32_t clk_control_marvell_test;
	volatile uint32_t lock_state;
	volatile uint32_t reserve_out;
};

#define to_pegmatite_pll(_hw) container_of(_hw, struct pegmatite_pll, hw)
struct pegmatite_pll {
	struct clk_hw           hw;
	struct pll_regs         *regs;
	int                     predivider;
};



/*======================================================================*
 *  For LowPower Setting, pll bypass mode
 *  parameter:
 *    name : pll name. it's defined in device tree.
 *    cmd  : if this is true, clock gating enable. if false, clcok gating disable.
 *----------------------------------------------------------------------*/
int simva_mod_pllbypass(char *name, int cmd)
{
	int  retvalue;
	struct clk *clk;
	struct clk_hw *hw;
	struct pegmatite_pll *pll;
	unsigned int  val;
	
	if(!strcmp(name, "corepll"))
	{
		val = readl(mpmu_base+0x2018);
		val = ((val & 0xfffeffff)|(cmd<<16));
		writel(val, mpmu_base+0x2018);
	}
	else if(!strcmp(name, "lvdsafepll0"))
	{
		val = readl(mpmu_base+0x4018);
		val = ((val & 0xfffeffff)|(cmd<<16));
		writel(val, mpmu_base+0x4018);
	}
	else if(!strcmp(name, "lvdsafepll1"))
	{
		val = readl(mpmu_base+0x4818);
		val = ((val & 0xfffeffff)|(cmd<<16));
		writel(val, mpmu_base+0x4818);
	}
	else
	{
		clk = __clk_lookup(name);
		if(clk == NULL)
			goto l_LookupPLL_Err;
		printk("[%s] name = %s\n", __FUNCTION__, name);
		printk("      clk = %p\n", clk);
		hw  = clk->hw;
		printk("      clk_hw = %p\n", hw);
		pll = to_pegmatite_pll(hw);
		printk("      pll    = %p\n", pll);
		val = readl(&pll->regs->fixed_mode_ssc_mode);
		printk(" simva_mod : pll val = %x\n", val);
		if(cmd)
		{
			printk(" simva_mod : enable bypass '%s'\n", name);
			//clk_disable(pll);
		}
		else
		{
			printk(" simva_mod : disable bypass '%s'\n", name);
			//clk_prepare(pll);
			//clk_enable(pll);
		}
		val &= 0xFFFEFFFF;
		val = val | ( cmd << 16 );
		writel(val, &pll->regs->fixed_mode_ssc_mode);
	}
	retvalue = 0;
l_Exit:
	return(retvalue);
l_LookupPLL_Err:
	pr_emerg("Can't find pll : %s\n", name);
	retvalue = -1;
	goto l_Exit;
}


/*======================================================================*
 *  seek I/F
 *----------------------------------------------------------------------*/
static loff_t simva_mod_seek(struct file *file, loff_t offset, int origin)
{
	loff_t retvalue = 0;
	
	printk(KERN_DEBUG "simva_mod: seek\n");
	return(retvalue);
}

struct file_operations simva_mod_fops =
{
	.owner          = THIS_MODULE,
	.read           = simva_mod_read,
	.write          = simva_mod_write,
	.unlocked_ioctl = simva_mod_ioctl,
	.open           = simva_mod_open,
	.release        = simva_mod_close,
	.llseek         = simva_mod_seek,
};

/*
#if defined(ENABLE_ECO_AVS)
int  simva_mod_AVS_powerdown(int  cmd)
{
	int            ret;
	unsigned long  value;

	if(cmd)
	{
		value = readl(AVS_CONTROL);
		value &= ~(BIT(1)|BIT(0));;  //  clear "ENABLE" and "RST_B" bits [1:0]
		writel(value, AVS_CONTROL);
	}
	else
	{
		//  start AVS
		value = readl(AVS_CONTROL);
		value |= (BIT(1)|BIT(0));  //  set "ENABLE" and "RST_B" bits [1:0]
		writel(value, AVS_CONTROL);
	}
	return ret;
}
#endif
*/


static int  simva_mod_lvds_powerdown(void);
int  simva_mod_lvds_powerdown(void)
{
	int             ret = -1;
	void  __iomem  *pad=NULL;
	void  __iomem  *AIB_locked=NULL;
	void  __iomem  *AIB_ext=NULL;
	unsigned long   value;
	
	
	pad = ioremap(0xd401e000, 0x400);
	if(pad==NULL)
	{
		printk("[simva:%s:%d] can't map PAD area\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	AIB_locked = ioremap(0xd4015000, 0x8);
	if(AIB_locked==NULL)
	{
		printk("[simva:%s:%d] can't map AIB_lcoked area\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}
	AIB_ext = ioremap(0xd401ebf0, 0x8);
	if(AIB_ext==NULL)
	{
		printk("[simva:%s:%d] can't map AIB_ext area\n", __FUNCTION__, __LINE__);
		goto l_Exit;
	}

#define  SET_PAD_PD_BIT(x)		\
	do {				\
		value  = readl((x));	\
		value |= BIT(25);	\
		writel(value, (x));	\
	} while(0)
	
	//  e-i)    LVDS PAD Power Down
	SET_PAD_PD_BIT((pad+0x1b8));
	SET_PAD_PD_BIT((pad+0x1bc));
	SET_PAD_PD_BIT((pad+0x1c0));
	SET_PAD_PD_BIT((pad+0x1c4));
	SET_PAD_PD_BIT((pad+0x1c8));
	SET_PAD_PD_BIT((pad+0x1cc));
	SET_PAD_PD_BIT((pad+0x1d0));
	SET_PAD_PD_BIT((pad+0x1d4));
	SET_PAD_PD_BIT((pad+0x324));
	SET_PAD_PD_BIT((pad+0x328));
	SET_PAD_PD_BIT((pad+0x32c));
	SET_PAD_PD_BIT((pad+0x330));
	SET_PAD_PD_BIT((pad+0x334));
	SET_PAD_PD_BIT((pad+0x338));
	
	//  e-ii)   SCIF0 LVDS CLK Power Down
	writel(0xbaba, AIB_locked+0x0);
	writel(0xeb10, AIB_locked+0x4);
	writel(0x000a, AIB_ext+0x0);
	msleep(10);
	
	//  e-iii)  SCIF1 LVDS CLK Power Down
	writel(0xbaba, AIB_locked+0x0);
	writel(0xeb10, AIB_locked+0x4);
	writel(0x000a, AIB_ext+0x4);
	
	ret = 0;
l_Exit:
	if(pad)
		iounmap(pad);
	if(AIB_locked)
		iounmap(AIB_locked);
	if(AIB_ext)
		iounmap(AIB_ext);
	return ret;
}


int  simva_mod_lvds_phy_powerdown(int  cmd)
{
	void __iomem *tmp_io;
	unsigned long  tmp_val;
	
	
	tmp_io = ioremap(0xd008b100, 0x300);
	if(tmp_io==NULL)
	{
		printk("[simva:%s:%d] can't map lvds phy area.\n", __FUNCTION__, __LINE__);
		return -1;
	}
	if(cmd==SIMVA_ENABLE)
	{
		tmp_val = readl(tmp_io+0x90);
		tmp_val &= ( (~(BIT(0))) & (~(BIT(8))) & (~(BIT(28))) & (~(BIT(30))) );
		writel(tmp_val, tmp_io+0x90);
		
		tmp_val = readl(tmp_io+0x200);
		tmp_val &= ~BIT(23);
		writel(tmp_val, tmp_io+0x200);
		
		tmp_val = readl(tmp_io+0x220);
		tmp_val |= ( (BIT(27)) | (BIT(28)) | (BIT(29)) );
		writel(tmp_val, tmp_io+0x220);
		//  gating lcd clk
		//simva_mod_clkgating("apbuslcdclkgate", SIMVA_ENABLE);
	}
	else
	{
		tmp_val = readl(tmp_io+0x90);
		tmp_val |= ( (BIT(0)) | (BIT(8)) | (BIT(28)) | (BIT(30)) );
		writel(tmp_val, tmp_io+0x90);
		
		tmp_val = readl(tmp_io+0x200);
		tmp_val |= BIT(23);
		writel(tmp_val, tmp_io+0x200);
		
		tmp_val = readl(tmp_io+0x220);
		tmp_val &= ( (~(BIT(27))) & (~(BIT(28))) & (~(BIT(29))) );
		writel(tmp_val, tmp_io+0x220);
	}
	iounmap(tmp_io);
	return 0;
}

static int  simva_mod_pcie_powerdown(void);
int  simva_mod_pcie_powerdown(void)
{
	void __iomem  *pcie_clk=NULL;
	unsigned long  pcie_clk_val;
	void __iomem  *pcie_reset=NULL;
	unsigned long  pcie_reset_val;
	void __iomem  *pcie_phy=NULL;
	unsigned long  pcie_phy_val;
	void __iomem *tmp_io;
	u32  val;
	
	
	/* b-i) disable clock gating for PCIe block */
	simva_mod_clkgating("apbuspciedm2aclkgate", SIMVA_DISABLE);
	simva_mod_clkgating("apbuspciedm4aclkgate", SIMVA_DISABLE);
	
	pcie_clk = ioremap(0xd06304d0, 0xc);
	
#if 0
	//sai remove
	pcie_clk_val = readl(pcie_clk);
	pcie_clk_val |= BIT(1);
	writel(pcie_clk_val, pcie_clk);
	
	//sai remove
	pcie_clk_val = readl(pcie_clk+0x8);
	pcie_clk_val |= BIT(1);
	writel(pcie_clk_val, pcie_clk+0x8);
#endif
	
	tmp_io = ioremap(0xd06304d4, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd06304dc, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	/* XXX : b-ii) check PCIe clock doesn't gated */
	
	/* b-iii) negate reset signal for PCIe block */
	pcie_reset = ioremap(0xd0630578, 0x4);
	pcie_reset_val = readl(pcie_reset);
	pcie_reset_val |= (BIT(1)|BIT(0));
	writel(pcie_reset_val, pcie_reset);
	
	/* XXX : b-iv) PCIe power down */
	pcie_phy = ioremap(0xd0782000, 0x800);
	pcie_phy_val = readl(pcie_phy+0x4);
	pcie_phy_val &= ~(BIT(14)|BIT(13)|BIT(12)|BIT(10));
	writel(pcie_phy_val, pcie_phy+0x4);
	
	pcie_phy_val = readl(pcie_phy+0x98);
	pcie_phy_val |= BIT(15);
	writel(pcie_phy_val, pcie_phy+0x98);
	
	pcie_phy_val = readl(pcie_phy+0x704);
	pcie_phy_val |= BIT(8);
	writel(pcie_phy_val, pcie_phy+0x704);
	
	/* b-v) assert reset signal for PCIe block */
	pcie_reset_val &= ~(BIT(1)|BIT(0));
	writel(pcie_reset_val, pcie_reset);
	
	/* b-vi) enable clock gating for PCIe block */
	simva_mod_clkgating("apbuspciedm2aclkgate", SIMVA_ENABLE);
	simva_mod_clkgating("apbuspciedm4aclkgate", SIMVA_ENABLE);
	
#if 0
	//sai remove
	pcie_clk_val = readl(pcie_clk);
	pcie_clk_val &= (~BIT(1));
	writel(pcie_clk_val, pcie_clk);
	
	//sai remove
	pcie_clk_val = readl(pcie_clk+0x8);
	pcie_clk_val &= (~BIT(1));
	writel(pcie_clk_val, pcie_clk+0x8);
#endif
	
	tmp_io = ioremap(0xd06304d4, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd06304dc, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	/* XXX : b-vii) check PCIe clock gated */
	
	if(pcie_clk)
		iounmap(pcie_clk);
	if(pcie_reset)
		iounmap(pcie_reset);
	if(pcie_phy)
		iounmap(pcie_phy);
	return 0;
}

/* bugfix:usb device power	 */
/* GPIOA[0] ISR				 */
void simva_mod_gpioa0_bottom_isr(struct work_struct *work)
{
	gpioa0_ws_t *ws;
	ws = (gpioa0_ws_t *)work;
	if(ws->cnt){
		printk("simva_mod: wakeup usb power.%d.\n",ws->cnt);
		TMP_simva_mod_usb_power_on(SIMVA_ENABLE);
		ws->cnt = 0;
	}
}
static irqreturn_t simva_mod_gpioa0_top_isr(int irq, void *dev_id)
{
	gpioa0_ws_t *ws;
	ws = (gpioa0_ws_t *)&gpioa0_work_struct;
	if(!ws->cnt){
		ws->cnt++;
		queue_work(ptr_gpioa0_wq, (struct work_struct *)ws);
	}
	else{
		printk("simva_mod: already stock gpioa0 isr queue.\n");
	}
	return IRQ_HANDLED;
}



char *gVerStr="gVerStr 0105-17 "__DATE__":"__TIME__;

/*======================================================================*
 *  Do at Loading
 *----------------------------------------------------------------------*/
static int __init simva_mod_init(void)
{
	int		retval;
	int		iret;
	dev_t	simva_mod_dev;
	struct	device_node  *np;
	u32  val;
	void __iomem *tmp_io;
	int		irq, error;
	
	
	printk(KERN_ERR "simva_mod: module_init\n");
	printk("[simva] build at %s %s\n", __DATE__, __TIME__);
	printk("[simva] opepanel mode = %d\n", simva_opepanel);
	
	/* create class (/sys/class/simva_mod) */
	simva_mod_info.simva_mod_class = class_create(THIS_MODULE, "simva_mod");
	if(IS_ERR(simva_mod_info.simva_mod_class))
	{
		retval = PTR_ERR(simva_mod_info.simva_mod_class);
		printk(KERN_DEBUG "simva_mod: can't create class\n");
	}
	
	iret = alloc_chrdev_region(&simva_mod_dev, 0, 0, "simva_mod");
	if(iret)
	{
		printk(KERN_DEBUG "simva_mod: can't alloc character device.\n");
		return (iret);
	}
	simva_mod_info.major = MAJOR(simva_mod_dev);
	device_create(simva_mod_info.simva_mod_class, NULL, MKDEV(simva_mod_info.major, 0), NULL, "simva_mod");
	
	cdev_init(&cdev_simva_mod, &simva_mod_fops);
	cdev_simva_mod.owner = THIS_MODULE;
	iret = cdev_add(&cdev_simva_mod, MKDEV(simva_mod_info.major, 0), 1);
	if(iret < 0)
	{
		printk(KERN_DEBUG "simva_mod: cdev_add() error(%d)\n", iret);
		return -1;
	}
	
	
	/* map devices */
	np = of_find_matching_node(NULL, of_apmu_table);
	if(np)
	{
		/* XXX */
		apmu_base = of_iomap(np, 0);
		printk("apmu base mapped address : %p\n", apmu_base);
	}
	np = of_find_matching_node(NULL, of_memory_controller_table);
	if(np)
	{
		/* XXX */
		memory_controller_base = of_iomap(np, 0);
		printk("memory controller mapped address : %p\n", memory_controller_base);
	}
	else
	{
		printk(KERN_CRIT "## simva_mod: can't get memory controller address.\n");
	}
	np = of_find_matching_node(NULL, of_mpmu_table);
	if(np)
	{
		mpmu_base = of_iomap(np, 0);
		printk("mpmu mapped address : %p\n", mpmu_base);
	}
	else
	{
		printk(KERN_CRIT "## simva_mod: can't get mpmu address.\n");
	}
	ipmu_misc_base = ioremap(0xf9080000, 0x1000);
	if(ipmu_misc_base==NULL)
	{
		printk(KERN_CRIT "## IPMU can't mapped.\n");
	}
	gmac0_base = ioremap(0xd0700000, 0x1000);
	if(gmac0_base == NULL)
	{
		printk(KERN_CRIT "## gmac0 can't mapped.\n");
	}
	
	
	/* s.nakamura add */
	{
		const char chimay_model_name[] = "RICOH Monochro ";
		char* get_model_name = NULL;
		int length = strlen(chimay_model_name);
		struct device_node* p_node = of_find_all_nodes(NULL);
		
		get_model_name = of_get_property(p_node, "model", NULL);
		if (NULL != get_model_name) {
			if(0 == strncmp(chimay_model_name, (const char*)get_model_name, length)) {
				printk("[simva] is chimay model : %s \n", get_model_name);
				is_vesta_model = 0;
			} else {
				printk("[simva] is vesta model : %s \n", get_model_name);
				is_vesta_model = 1;
			}
		}
	}
	
	
	/* a) PHY Power Down Control */
	simva_mod_lvds_phy_powerdown(SIMVA_ENABLE);
	
	/* b) PCIe Power OFF */
	simva_mod_pcie_powerdown();
	
	
	/* c) i) Gate unused module clock */
	simva_mod_clkgating("tpiuclkgate", SIMVA_ENABLE);			// 0xd0630408, (org 0xd0630208)
	if(simva_opepanel==SIMVA_OPE_4LINE)
	{
		simva_mod_clkgating("i2c1clkgate", SIMVA_ENABLE);			// 0xd0630428
	}
	simva_mod_clkgating("i2c2clkgate", SIMVA_ENABLE);			// 0xd0630430
	simva_mod_clkgating("i2c3clkgate", SIMVA_ENABLE);			// 0xd0630438
	simva_mod_clkgating("i2c4clkgate", SIMVA_ENABLE);			// 0xd0630440
	
	if(simva_opepanel!=SIMVA_OPE_4LINE)
	{
		simva_mod_clkgating("i2c5clkgate", SIMVA_ENABLE);			// 0xd0630448
	}
	
	simva_mod_clkgating("ssp2clkgate", SIMVA_ENABLE);			// 0xd0630460
	simva_mod_clkgating("apbusdiv2clkgate", SIMVA_ENABLE);		// 0xd0630478, (org 0xd0630240)
	simva_mod_clkgating("apbuslcdclkgate", SIMVA_ENABLE);	// 0xd0630488
	simva_mod_clkgating("apbuscdmaclkgate", SIMVA_ENABLE);		// 0xd0630490, (org 0xd0630258)
	simva_mod_clkgating("apbussataclkgate", SIMVA_ENABLE);		// 0xd06304e0, (org 0xd06302b0)
	simva_mod_clkgating("lcdxclkgate", SIMVA_ENABLE);		// 0xd0630518

	if(is_vesta_model) {
		if(simva_opepanel!=SIMVA_OPE_4LINE)
		{
			simva_mod_clkgating("uart3clkgate", SIMVA_ENABLE);		// 0xd063054c
		}
	}

	simva_mod_clkgating("audioclkgate", SIMVA_ENABLE);			// 0xf9080108

	if(is_vesta_model) {
		simva_mod_clkgating("nssclkgate", SIMVA_ENABLE);				// 0xf9080120
	}

	simva_mod_clkgating("ipsbusapbclkgate", SIMVA_DISABLE);		// 0xf9080180
	simva_mod_clkgating("apbususb3phyaclkgate", SIMVA_DISABLE); // 0xd06304c8, (org 0xd0630298)
	
	
	if(is_vesta_model) {
		tmp_io = ioremap(0xd0630450, 4); //i2c6clkgate
		val = readl(tmp_io);
		val = (val & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);
	}
	
	if(is_vesta_model) {
		tmp_io = ioremap(0xd0630468, 4); //ssp3clkgate
		val = readl(tmp_io);
		val = (val & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);
	}

	if(is_vesta_model) {
		tmp_io = ioremap(0xf9080110, 4); //adctsenclkgate
		val = readl(tmp_io);
		val = (val & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);
	}

	tmp_io = ioremap(0xf9080168, 4); //ipsbusmvdoclkgate
	val = readl(tmp_io);
	val = (val & (~(BIT(1))));
	writel(val, tmp_io);
	iounmap(tmp_io);
	

	if(is_vesta_model) {
		tmp_io = ioremap(0xf9080188, 4); //ipbus dec Clkgen configuration register
		val = readl(tmp_io);
		val = (val & (~(BIT(1))));
		writel(val, tmp_io);
		iounmap(tmp_io);
	}

	/* c) ii) check Gate unused module clock */
	mdelay(3); //not msleep
	
	tmp_io = ioremap(0xd063040c, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd063042c, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd0630434, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd063043c, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd0630444, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd063044c, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd0630454, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd0630464, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd063046c, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd063047c, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd063048c, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd06304e4, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd063051c, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xd0630544, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xf908010c, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xf9080114, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xf9080124, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xf908015c, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xf908016c, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	tmp_io = ioremap(0xf908018c, 4);
	val = readl(tmp_io);
	iounmap(tmp_io);
	
	/* d) Power Island Power Off of GPU */
	
	TMP_simva_mod_gpu_power_off(SIMVA_ENABLE);
	
#if 0
	//sai remove
	tmp_io = ioremap(0xd06304e8, 4);
	val = ((readl(tmp_io)) & (~(BIT(1))));
	writel(val, tmp_io);
	iounmap(tmp_io);
#endif
	
#if 0
	//sai remove
	tmp_io = ioremap(0xd06304f8, 4);
	val = ((readl(tmp_io)) & (~(BIT(1))));
	writel(val, tmp_io);
	iounmap(tmp_io);
#endif
	
#if 0
	//sai remove
	tmp_io = ioremap(0xd0630500, 4);
	val = ((readl(tmp_io)) & (~(BIT(1))));
	writel(val, tmp_io);
	iounmap(tmp_io);
#endif
	
	/* e) LVDS Power Down Control */
	simva_mod_lvds_powerdown();
	
	/* f) SRAM Low Leakage Mode */
	simva_mod_sram_lowleakage(SATA_SRAMPdwn_SPCTL, SIMVA_ENABLE);
	simva_mod_sram_lowleakage(PCIe_dm2_SRAMPdwn_SPCTL, SIMVA_ENABLE);
	simva_mod_sram_lowleakage(PCIe_dm4_SRAMPdwn_SPCTL, SIMVA_ENABLE);
	simva_mod_sram_lowleakage(lcd_SRAMPdwn_SPCTL, SIMVA_ENABLE);
	
	//  XXX 2016/10/21 Change (onboard LED on)
	gpio_set_value(POW_LED_GPIO1_NO, 1);
	//gpio_set_value(POW_LED_GPIO2_NO, 1);
	
	/* bugfix:usb device power */
	/* USBfoCXmɂx̏ */
	ptr_gpioa0_wq = create_singlethread_workqueue("GPIOA0_WQ");
	if (!ptr_gpioa0_wq) {
		printk("[simva_mod:]Can't create workqueue_struct!\n");
	}
	INIT_WORK((struct work_struct *)(&gpioa0_work_struct), simva_mod_gpioa0_bottom_isr);
	gpioa0_work_struct.cnt = 0;
	
	// USBfoCXmpGPIOA[0] request_irq
	irq = gpio_to_irq(0);	// GPIOA[0]
	error =  request_irq(irq, simva_mod_gpioa0_top_isr, IRQF_TRIGGER_FALLING, "SIMVA_MOD_GPIOA0", &simva_mod_dev); // simva_mod_devgȂ֋XĂB
	if (error) {
		printk("simva_mod:request_irq NG\n");
	}
	
	retval = 0;
	return retval;
}
module_init(simva_mod_init);


/*======================================================================*
 *  Do at Unloading
 *----------------------------------------------------------------------*/
static void __exit simva_mod_exit(void)
{
	printk(KERN_ERR "simva_mod: module_exit\n");
	unregister_chrdev_region(MKDEV(simva_mod_info.major,0), 0);
	class_destroy(simva_mod_info.simva_mod_class);
}
module_exit(simva_mod_exit);


MODULE_AUTHOR("RICOH");
MODULE_DESCRIPTION("simva kernel module");

MODULE_LICENSE("GPL");
MODULE_VERSION("2015_July_23 01");
