/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2014, 2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/

#ifndef _SCCPLITE_H_
#define _SCCPLITE_H_

// grab the ioctl definitions (shared by user space)
#include "userspace/sccplite_ioctl.h"

// Kernel (driver-to-driver) interface functions
void sccp_processor_start( int device, int start_word_addr );
void sccp_processor_stop( int device );
void sccp_processor_resume( int device );

void sccp_set_interrupt( int device, uint32_t intr );
void sccp_clr_interrupt( int device, uint32_t intr );

int  sccp_read_sram_words(  int device, int word_offset, uint16_t *data, int byte_length );
int  sccp_write_sram_words( int device, int word_offset, uint16_t *data, int byte_length );

// Writes microcode to the SRAM and sets up SCCP's stack.  Input is 32-bit padded instructions, which is what the compiler outputs.
int  sccp_write_microcode( int device, int word_offset, int *data, int byte_length );

#endif // _SCCPLITE_H_

