#!/bin/ash
#
# ============================================================================
# Copyright (c) 2014 Marvell International, Ltd. All Rights Reserved
#
# Marvell Confidential
# ============================================================================
#

echo "debugging..."
SCCPLITE_ADDR_BASE=0xF818
SCCPLITE_DEV="/dev/sccp0"
SCCPLITE_SOURCE="test_sccp.bin"

SCCPLITE_BPTR0=$SCCPLITE_ADDR_BASE"0000"        # [R/W]: Bit Pointer 0 Register
SCCPLITE_BPTR1=$SCCPLITE_ADDR_BASE"0004"        # [R/W]: Bit Pointer 1 Register
SCCPLITE_GEN0=$SCCPLITE_ADDR_BASE"0008"         # [R/W]: General Purpose Register 0
SCCPLITE_GEN1=$SCCPLITE_ADDR_BASE"000c"         # [R/W]: General Purpose Register 1
SCCPLITE_GEN2=$SCCPLITE_ADDR_BASE"0010"         # [R/W]: General Purpose Register 2
SCCPLITE_GEN3=$SCCPLITE_ADDR_BASE"0014"         # [R/W]: General Purpose Register 3
SCCPLITE_GEN4=$SCCPLITE_ADDR_BASE"0018"         # [R/W]: General Purpose Register 4
SCCPLITE_GEN5=$SCCPLITE_ADDR_BASE"001c"         # [R/W]: General Purpose Register 5
SCCPLITE_STACK=$SCCPLITE_ADDR_BASE"0020"        # [R/W]: Stack Pointer
SCCPLITE_MODE=$SCCPLITE_ADDR_BASE"0024"         # [R/W]: Mode Register
SCCPLITE_GPIO_OE=$SCCPLITE_ADDR_BASE"0028"      # [R/W]: GPIO Output Enable Register
SCCPLITE_GPIO_O=$SCCPLITE_ADDR_BASE"002c"       # [R/W]: GPIO Output Value Register
SCCPLITE_GPIO_I=$SCCPLITE_ADDR_BASE"0030"       # [R]: GPIO Input Value Register
SCCPLITE_TRIG=$SCCPLITE_ADDR_BASE"0034"         # [R/W]: External Triggers Register
SCCPLITE_INT=$SCCPLITE_ADDR_BASE"0038"          # [R/W]: Interrupts Register
SCCPLITE_PAR=$SCCPLITE_ADDR_BASE"003c"          # [R/W]: Parity Register
SCCPLITE_TRIG_RD=$SCCPLITE_ADDR_BASE"0040"      # [R]: External Triggers Read Register
SCCPLITE_EXT_ADDR_L=$SCCPLITE_ADDR_BASE"0044"   # [R/W]: External Address Lower
SCCPLITE_EXT_ADDR_U=$SCCPLITE_ADDR_BASE"0048"   # [R/W]: External Address Upper
SCCPLITE_EXT_DATA_L=$SCCPLITE_ADDR_BASE"004c"   # [R/W]: External Data Lower
SCCPLITE_EXT_DATA_U=$SCCPLITE_ADDR_BASE"0050"   # [R/W]: External Data Upper
SCCPLITE_EXT_ERR=$SCCPLITE_ADDR_BASE"0054"      # [R/W]: External Error Register
SCCPLITE_CPU_CTRL=$SCCPLITE_ADDR_BASE"0100"     # [R/W]: CPU Control Register
SCCPLITE_IPTR=$SCCPLITE_ADDR_BASE"0104"         # [R/W]: Instruction Pointer Register
SCCPLITE_CINST=$SCCPLITE_ADDR_BASE"0108"        # [R]: Current Instruction Register
SCCPLITE_DEBUG_IADDR=$SCCPLITE_ADDR_BASE"010c"  # [R]: Debug Instruction Address
SCCPLITE_TRIG_CFG0=$SCCPLITE_ADDR_BASE"0110"    # [R/W]: Trigger Configuration 0
SCCPLITE_TRIG_CFG1=$SCCPLITE_ADDR_BASE"0114"    # [R/W]: Trigger Configuration 1
SCCPLITE_REV0=$SCCPLITE_ADDR_BASE"0118"         # [R]: IP Tagging Revision 0
SCCPLITE_REV1=$SCCPLITE_ADDR_BASE"011c"         # [R]: IP Tagging Revision 1
SCCPLITE_SRAM=$SCCPLITE_ADDR_BASE"1000"         # [R/W]: Microcode SRAM


sccplite_reg_and_name() # (<reg addr>, <reg name> )
{
    address=$1
    name=$2

    data_read=`devmem $address`
    printf "%s = 0x%x\n" $name $data_read
}

sccplite_dump_regs()
{
    sccplite_reg_and_name $SCCPLITE_BPTR0           SCCPLITE_BPTR0      
    sccplite_reg_and_name $SCCPLITE_BPTR1           SCCPLITE_BPTR1      
    sccplite_reg_and_name $SCCPLITE_GEN0            SCCPLITE_GEN0       
    sccplite_reg_and_name $SCCPLITE_GEN1            SCCPLITE_GEN1       
    sccplite_reg_and_name $SCCPLITE_GEN2            SCCPLITE_GEN2       
    #sccplite_reg_and_name $SCCPLITE_GEN3            SCCPLITE_GEN3       
    #sccplite_reg_and_name $SCCPLITE_GEN4            SCCPLITE_GEN4       
    #sccplite_reg_and_name $SCCPLITE_GEN5            SCCPLITE_GEN5       
    sccplite_reg_and_name $SCCPLITE_STACK           SCCPLITE_STACK      
    sccplite_reg_and_name $SCCPLITE_MODE            SCCPLITE_MODE       
    #sccplite_reg_and_name $SCCPLITE_GPIO_OE         SCCPLITE_GPIO_OE    
    #sccplite_reg_and_name $SCCPLITE_GPIO_O          SCCPLITE_GPIO_O     
    #sccplite_reg_and_name $SCCPLITE_GPIO_I          SCCPLITE_GPIO_I     
    #sccplite_reg_and_name $SCCPLITE_TRIG            SCCPLITE_TRIG       
    #sccplite_reg_and_name $SCCPLITE_INT             SCCPLITE_INT        
    #sccplite_reg_and_name $SCCPLITE_PAR             SCCPLITE_PAR        
    #sccplite_reg_and_name $SCCPLITE_TRIG_RD         SCCPLITE_TRIG_RD    
    #sccplite_reg_and_name $SCCPLITE_EXT_ADDR_L      SCCPLITE_EXT_ADDR_L 
    #sccplite_reg_and_name $SCCPLITE_EXT_ADDR_U      SCCPLITE_EXT_ADDR_U 
    #sccplite_reg_and_name $SCCPLITE_EXT_DATA_L      SCCPLITE_EXT_DATA_L 
    #sccplite_reg_and_name $SCCPLITE_EXT_DATA_U      SCCPLITE_EXT_DATA_U 
    #sccplite_reg_and_name $SCCPLITE_EXT_ERR         SCCPLITE_EXT_ERR    
    sccplite_reg_and_name $SCCPLITE_CPU_CTRL        SCCPLITE_CPU_CTRL   
    sccplite_reg_and_name $SCCPLITE_IPTR            SCCPLITE_IPTR       
    sccplite_reg_and_name $SCCPLITE_CINST           SCCPLITE_CINST      
    sccplite_reg_and_name $SCCPLITE_DEBUG_IADDR     SCCPLITE_DEBUG_IADDR
    #sccplite_reg_and_name $SCCPLITE_TRIG_CFG0       SCCPLITE_TRIG_CFG0  
    #sccplite_reg_and_name $SCCPLITE_TRIG_CFG1       SCCPLITE_TRIG_CFG1  
    #sccplite_reg_and_name $SCCPLITE_REV0            SCCPLITE_REV0       
    #sccplite_reg_and_name $SCCPLITE_REV1            SCCPLITE_REV1       
    #sccplite_reg_and_name $SCCPLITE_SRAM            SCCPLITE_SRAM       

    printf "\n\n"
}


sccplite_halt()
{
    devmem $SCCPLITE_CPU_CTRL 32 0          # clear run bit(s)
}

sccplite_run()
{
    devmem $SCCPLITE_CPU_CTRL 32 5          # write run & defer to CPU access bits
}

sccplite_ss()
{
    devmem $SCCPLITE_CPU_CTRL 32 2          # write single step to register
}

sccplite_ss_mult() #(<number of steps>)
{
    steps=$1
    cur_step=0
    while [ $cur_step -lt $steps ]
    do
        # Perform x number of single steps
        devmem $SCCPLITE_CPU_CTRL 32 2          # write single step to register
        cur_step=`expr $cur_step + 1`
    done
}


sccplite_load() #(<afe code filename>)
{
    if [ -e $SCCPLITE_DEV ];then
        cat $1 > $SCCPLITE_DEV
    else
        echo "Error! No SCCP dev file."
        exit -1
    fi
}

sccplite_write_reg() # (<reg> <value>)
{
    address=$1
    value=$2
    devmem $address 32 $value 
    #echo devmem $address 32 $value 
}

sccplite_print_reg() # (<reg>)
{
    address=$1
    data_read=`devmem $address`
    printf "0x%x\n" $data_read
}

sccplite_test_reg() # (<reg> <value>)
{
    address=$1
    value=$2
    data_read=`devmem $address 16`
    if [ $data_read != $value ]
    then
        echo "VALUE DID NOT MATCH!"
        echo "DataRead $data_read"
        echo "Value    $value"
        exit -1
    fi

}

# Halt and reset key values
sccplite_halt
sccplite_write_reg $SCCPLITE_CPU_CTRL 0x80000000
sccplite_write_reg $SCCPLITE_IPTR 0

# Load new code
sccplite_load $SCCPLITE_SOURCE

# start section
sccplite_dump_regs
sccplite_ss_mult 8

printf "Data loaded:\n"
#printf "g1 should be 0x1234 is "
#sccplite_print_reg $SCCPLITE_GEN1
sccplite_test_reg $SCCPLITE_GEN1 0x1234
#printf "g2 should be 0xa5a5 is "
#sccplite_print_reg $SCCPLITE_GEN2
sccplite_test_reg $SCCPLITE_GEN2 0xA5A5


# loop0 section
echo "Loop 0"
sccplite_ss_mult 161
sccplite_test_reg $SCCPLITE_GEN1 0x1234
sccplite_ss
sccplite_test_reg $SCCPLITE_GEN1 0x0000


# loop1 section
echo "Loop 1"
sccplite_ss
sccplite_test_reg $SCCPLITE_GEN0 0x0020
sccplite_ss_mult 160
sccplite_test_reg $SCCPLITE_GEN2 0xA5A5
sccplite_ss
sccplite_test_reg $SCCPLITE_GEN2 0x0000

# loop2 section
echo "Loop 2"
sccplite_ss
sccplite_test_reg $SCCPLITE_GEN0 0x0010
sccplite_ss_mult 112
sccplite_test_reg $SCCPLITE_GEN0 0x0000
sccplite_ss

# loop3 section
echo "Loop 3"
sccplite_ss
sccplite_test_reg $SCCPLITE_GEN0 0x0020
sccplite_ss_mult 162
sccplite_test_reg $SCCPLITE_GEN0 0x0000
sccplite_run

echo "Finished!"


