#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>


#define DEV_FILE "/dev/notice"


int main(void){
	
	int fd;
	fd_set rfds;
	struct timeval tv;
	int retval;
	unsigned char buf[64];
	ssize_t sz;
	int i;
	int pid;
	int loop = 0;

	for( i=0; i<64; i++ ){
		buf[i] = 0;
	}

	
	if( (pid = fork() ) == 0 ){
//	  while(1){

		fd = open( DEV_FILE, O_RDWR );
		if( fd == -1 ){
			perror( "open" );
			exit(1);
		}

printf( "loop settings...\n" );
		FD_ZERO(&rfds);
		FD_SET(fd, &rfds);
		tv.tv_sec = 60;
		tv.tv_usec =1000;

printf( "loop start\n" );
		while(1){
printf( "loop top\n" );
			do {

				printf( "select()...\n" );
				retval = select( fd + 1, &rfds, NULL, NULL, &tv );
				if( retval <= 0 ){
					perror( "select" );
printf( "kokokita=%d, retval=%d\n", __LINE__, retval );
					break;
				}
printf( "kokokita=%d retval=%d\n", __LINE__, retval );
				if( retval ) break;
printf( "kokokita=%d\n", __LINE__ );
			}while( retval == 0 );

printf( "kokokita=%d\n", __LINE__ );

			if( FD_ISSET( fd, &rfds ) ){
				printf( "read() ...\n" );
				sz = read( fd, buf, sizeof(buf) );
				printf( "read() size=%d\n", sz );

				for( i=0; i<6; i++ ){
					printf( "0x%02X ,", buf[i] );
				}
				printf( "\n" );
				if( buf[4] == 0x88 ){
					printf( "[%s] end\n", __func__ );
//					break;
				}else{
					printf( "[%s] failed\n", __func__ );
				}
			}
printf( "kokokita=%d loop=%d\n", __LINE__, loop );
			if( loop++ >= 10 ){
				printf( "select done\n" );
				break;
			}
		}
printf( "loop end\n" );
		close(fd);

	}else{
/*
		fd = open( DEV_FILE, O_RDWR );
		if( fd == -1 ){
			perror( "open" );
			exit(1);
		}

		printf( "write side. waiting... \n" );
		sleep( 3 );
		
		sz = write( fd, buf, sizeof(buf) );
		if( sz == -1 ){
			perror( "write" );
		}
		printf( "■■■■■■write done!\n" );

		close(fd);
*/
	}

	printf( "pid=%d, close \n", pid );
	return 0;
}

